/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCPlayDevCardRequest
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 1111L;
    private String game;
    private int devCard;

    public SOCPlayDevCardRequest(String ga, int dc) {
        this.messageType = 1049;
        this.game = ga;
        this.devCard = dc;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getDevCard() {
        return this.devCard;
    }

    @Override
    public String toCmd() {
        return SOCPlayDevCardRequest.toCmd(this.game, this.devCard);
    }

    public static String toCmd(String ga, int dc) {
        return "1049|" + ga + "," + dc;
    }

    public static SOCPlayDevCardRequest parseDataStr(String s) {
        int dc;
        String ga;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            ga = st.nextToken();
            dc = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            return null;
        }
        return new SOCPlayDevCardRequest(ga, dc);
    }

    @Override
    public String toString() {
        return "SOCPlayDevCardRequest:game=" + this.game + "|devCard=" + this.devCard;
    }
}

