/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCPlayerElement
extends SOCMessage
implements SOCMessageForGame {
    public static final int VERSION_FOR_CARD_ELEMENTS = 2000;
    private static final long serialVersionUID = 2000L;
    public static final int SET = 100;
    public static final int GAIN = 101;
    public static final int LOSE = 102;
    public static final int SET_NEWS = -100;
    public static final int GAIN_NEWS = -101;
    public static final int LOSE_NEWS = -102;
    private String game;
    private int playerNumber;
    private int elementType;
    private int actionType;
    private int amount;
    private final boolean news;
    public static final String[] ACTION_STRINGS = new String[]{"SET", "GAIN", "LOSE"};

    public static PEType elementTypeForPieceType(int ptype) {
        PEType et;
        switch (ptype) {
            case 0: {
                et = PEType.ROADS;
                break;
            }
            case 1: {
                et = PEType.SETTLEMENTS;
                break;
            }
            case 2: {
                et = PEType.CITIES;
                break;
            }
            case 3: {
                et = PEType.SHIPS;
                break;
            }
            default: {
                et = PEType.UNKNOWN_TYPE;
            }
        }
        return et;
    }

    public SOCPlayerElement(String ga, int pn, int ac, int et, int amt) throws IllegalArgumentException {
        this(ga, pn, ac, et, amt, false);
    }

    public SOCPlayerElement(String ga, int pn, int ac, PEType et, int amt) throws IllegalArgumentException {
        this(ga, pn, ac, et.value, amt, false);
    }

    public SOCPlayerElement(String ga, int pn, int ac, PEType et, int amt, boolean isNews) throws IllegalArgumentException {
        this(ga, pn, ac, et.value, amt, isNews);
    }

    public SOCPlayerElement(String ga, int pn, int ac, int et, int amt, boolean isNews) throws IllegalArgumentException {
        if (ac == -101 || ac == -100 || ac == -102) {
            throw new IllegalArgumentException("use isNews instead");
        }
        this.messageType = 1024;
        this.game = ga;
        this.playerNumber = pn;
        this.actionType = ac;
        this.elementType = et;
        this.amount = amt;
        this.news = isNews;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    public int getAction() {
        return this.actionType;
    }

    public int getElementType() {
        return this.elementType;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean isNews() {
        return this.news;
    }

    @Override
    public String toCmd() {
        int ac = this.actionType;
        if (this.news) {
            switch (ac) {
                case 101: {
                    ac = -101;
                    break;
                }
                case 102: {
                    ac = -102;
                    break;
                }
                case 100: {
                    ac = -100;
                }
            }
        }
        return SOCPlayerElement.toCmd(this.game, this.playerNumber, ac, this.elementType, this.amount);
    }

    public static String toCmd(String ga, int pn, int ac, PEType et, int amt) {
        return SOCPlayerElement.toCmd(ga, pn, ac, et.getValue(), amt);
    }

    private static String toCmd(String ga, int pn, int ac, int et, int amt) {
        boolean isNews = false;
        switch (ac) {
            case -101: {
                isNews = true;
                ac = 101;
                break;
            }
            case -100: {
                isNews = true;
                ac = 100;
                break;
            }
            case -102: {
                isNews = true;
                ac = 102;
                break;
            }
        }
        return "1024|" + ga + "," + pn + "," + ac + "," + et + "," + amt + (isNews ? ",Y" : "");
    }

    public static SOCPlayerElement parseDataStr(String s) {
        int va;
        int et;
        int ac;
        int pn;
        String ga;
        boolean isNews = false;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            ga = st.nextToken();
            pn = Integer.parseInt(st.nextToken());
            ac = Integer.parseInt(st.nextToken());
            et = Integer.parseInt(st.nextToken());
            va = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                isNews = st.nextToken().equals("Y");
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCPlayerElement(ga, pn, ac, et, va, isNews);
    }

    public static String stripAttribNames(String messageStrParams) {
        String s = SOCMessage.stripAttribNames(messageStrParams);
        if (s == null) {
            return null;
        }
        String[] pieces = s.split(",");
        if (pieces.length <= 2 || pieces[2].isEmpty()) {
            return s;
        }
        String act = pieces[2];
        if (Character.isDigit(act.charAt(0))) {
            try {
                if (Integer.parseInt(act) >= 0) {
                    return s;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int actType = -1;
        for (int ac = 0; ac < ACTION_STRINGS.length; ++ac) {
            if (!ACTION_STRINGS[ac].equals(act)) continue;
            actType = ac + 100;
            break;
        }
        if (actType != -1) {
            pieces[2] = Integer.toString(actType);
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < pieces.length; ++i) {
            if (i > 0) {
                ret.append(',');
            }
            ret.append(pieces[i]);
        }
        return ret.toString();
    }

    @Override
    public String toString() {
        String act = this.actionType >= 100 && this.actionType - 100 < ACTION_STRINGS.length ? ACTION_STRINGS[this.actionType - 100] : Integer.toString(this.actionType);
        String s = "SOCPlayerElement:game=" + this.game + "|playerNum=" + this.playerNumber + "|actionType=" + act + "|elementType=" + this.elementType + "|amount=" + this.amount + (this.news ? "|news=Y" : "");
        return s;
    }

    public static enum PEType {
        UNKNOWN_TYPE(0),
        CLAY(1),
        ORE(2),
        SHEEP(3),
        WHEAT(4),
        WOOD(5),
        UNKNOWN_RESOURCE(6),
        ROADS(10),
        SETTLEMENTS(11),
        CITIES(12),
        SHIPS(13),
        NUMKNIGHTS(15),
        ASK_SPECIAL_BUILD(16),
        RESOURCE_COUNT(17),
        LAST_SETTLEMENT_NODE(18),
        PLAYED_DEV_CARD_FLAG(19),
        DISCARD_FLAG(20),
        HAS_SPECIAL_BUILT(21),
        NUM_PLAYED_DEV_CARD_DISC(22),
        NUM_PLAYED_DEV_CARD_MONO(23),
        NUM_PLAYED_DEV_CARD_ROADS(24),
        NUM_UNDOS_REMAINING(25),
        NUM_PICK_GOLD_HEX_RESOURCES(101),
        SCENARIO_SVP(102),
        PLAYEREVENTS_BITMASK(103),
        SCENARIO_SVP_LANDAREAS_BITMASK(104),
        STARTING_LANDAREAS(105),
        SCENARIO_CLOTH_COUNT(106),
        SCENARIO_WARSHIP_COUNT(107);

        private int value;

        private PEType(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }

        public static PEType valueOf(int ti) {
            for (PEType et : PEType.values()) {
                if (et.value != ti) continue;
                return et;
            }
            return null;
        }

        public static int[] getValues(PEType[] pe) throws NullPointerException {
            if (pe == null) {
                return null;
            }
            int L = pe.length;
            int[] iv = new int[L];
            for (int i = 0; i < L; ++i) {
                iv[i] = pe[i].value;
            }
            return iv;
        }
    }
}

