/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.ArrayList;
import java.util.List;
import soc.game.ResourceSet;
import soc.message.SOCMessageTemplateMi;
import soc.message.SOCPlayerElement;

public class SOCPlayerElements
extends SOCMessageTemplateMi {
    private static final long serialVersionUID = 2000L;
    public static final int MIN_VERSION = 2000;
    private int playerNumber;
    private int actionType;
    private int[] elementTypes;
    private int[] amounts;

    public SOCPlayerElements(String ga, int pn, int ac, SOCPlayerElement.PEType[] et, int[] amt) throws NullPointerException {
        this(ga, pn, ac, SOCPlayerElement.PEType.getValues(et), amt);
    }

    private SOCPlayerElements(String ga, int pn, int ac, int[] et, int[] amt) throws NullPointerException {
        super(1086, ga, new int[2 + 2 * et.length]);
        if (amt == null) {
            throw new NullPointerException();
        }
        this.playerNumber = pn;
        this.actionType = ac;
        this.elementTypes = et;
        this.amounts = amt;
        this.pa[0] = pn;
        this.pa[1] = ac;
        int pai = 2;
        for (int eti = 0; eti < et.length; ++eti) {
            this.pa[pai] = et[eti];
            this.pa[++pai] = amt[eti];
            ++pai;
        }
    }

    public SOCPlayerElements(String ga, int pn, int ac, ResourceSet rs) throws NullPointerException {
        super(1086, ga, null);
        this.playerNumber = pn;
        this.actionType = ac;
        int typeCount = rs.getResourceTypeCount();
        this.pa = new int[2 + 2 * typeCount];
        this.pa[0] = pn;
        this.pa[1] = ac;
        if (typeCount > 0) {
            this.elementTypes = new int[typeCount];
            this.amounts = new int[typeCount];
        }
        int pai = 2;
        int eti = 0;
        for (int r = 1; r <= 5; ++r) {
            int amt = rs.getAmount(r);
            if (amt <= 0) continue;
            this.pa[pai] = r;
            this.pa[++pai] = amt;
            ++pai;
            this.elementTypes[eti] = r;
            this.amounts[eti] = amt;
            ++eti;
        }
    }

    @Override
    public int getMinimumVersion() {
        return 2000;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    public int getAction() {
        return this.actionType;
    }

    public int[] getElementTypes() {
        return this.elementTypes;
    }

    public int[] getAmounts() {
        return this.amounts;
    }

    public static SOCPlayerElements parseDataStr(List<String> pa) {
        if (pa == null) {
            return null;
        }
        int L = pa.size();
        if (L < 5 || L % 2 == 0) {
            return null;
        }
        try {
            String gaName = pa.get(0);
            int playerNumber = Integer.parseInt(pa.get(1));
            int actionType = Integer.parseInt(pa.get(2));
            int n = (L - 3) / 2;
            int[] elementTypes = new int[n];
            int[] amounts = new int[n];
            int pai = 3;
            for (int i = 0; i < n; ++i) {
                elementTypes[i] = Integer.parseInt(pa.get(pai));
                amounts[i] = Integer.parseInt(pa.get(++pai));
                ++pai;
            }
            return new SOCPlayerElements(gaName, playerNumber, actionType, elementTypes, amounts);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<String> stripAttribsToList(String messageStrParams) {
        String[] pieces = messageStrParams.split("\\|");
        if (pieces.length != 4) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        if (!pieces[0].startsWith("game=")) {
            return null;
        }
        ret.add(pieces[0].substring(5));
        if (!pieces[1].startsWith("playerNum=")) {
            return null;
        }
        ret.add(pieces[1].substring(10));
        String act = pieces[2];
        if (!act.startsWith("actionType=")) {
            return null;
        }
        if (!Character.isDigit((act = act.substring(11)).charAt(0))) {
            for (int ac = 0; ac < SOCPlayerElement.ACTION_STRINGS.length; ++ac) {
                if (!SOCPlayerElement.ACTION_STRINGS[ac].equals(act)) continue;
                act = Integer.toString(ac + 100);
                break;
            }
        }
        ret.add(act);
        pieces = pieces[3].split(",");
        for (int i = 0; i < pieces.length; ++i) {
            String piece = pieces[i];
            if (piece.charAt(0) != 'e') {
                return null;
            }
            int j = piece.indexOf(61);
            if (j < 2) {
                return null;
            }
            ret.add(piece.substring(1, j));
            ret.add(piece.substring(j + 1));
        }
        return ret;
    }

    @Override
    public String toString() {
        String act = this.actionType >= 100 && this.actionType - 100 < SOCPlayerElement.ACTION_STRINGS.length ? SOCPlayerElement.ACTION_STRINGS[this.actionType - 100] : Integer.toString(this.actionType);
        StringBuilder sb = new StringBuilder("SOCPlayerElements:game=" + this.game + "|playerNum=" + this.playerNumber + "|actionType=" + act + '|');
        for (int i = 2; i < this.pa.length; ++i) {
            if (i > 2) {
                sb.append(',');
            }
            sb.append('e');
            sb.append(this.pa[i]);
            sb.append('=');
            sb.append(this.pa[++i]);
        }
        return sb.toString();
    }
}

