/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.List;
import soc.game.SOCPlayer;
import soc.game.SOCResourceSet;
import soc.message.SOCMessageTemplateMi;

public class SOCPlayerStats
extends SOCMessageTemplateMi {
    private static final long serialVersionUID = 2000L;
    public static final int STYPE_MIN = 1;
    public static final int STYPE_RES_ROLL = 1;
    public static final int STYPE_TRADES = 2;
    public static final int STYPE_MAX = 2;
    public static final int VERSION_FOR_RES_ROLL = 1109;
    public static final int VERSION_FOR_TRADES = 2600;
    public static final int VERSION_FOR_SENT_AT_SITDOWN = 2700;

    public SOCPlayerStats(SOCPlayer pl, int stype) throws IllegalArgumentException, NullPointerException {
        super(1085, pl.getGame().getName(), new int[SOCPlayerStats.len(pl, stype)]);
        this.pa[0] = stype;
        switch (stype) {
            case 1: {
                int[] rstats = pl.getResourceRollStats();
                for (int i = 1; i <= 5; ++i) {
                    this.pa[i] = rstats[i];
                }
                if (this.pa.length <= 6) break;
                this.pa[6] = rstats[6];
                break;
            }
            case 2: {
                this.pa[1] = 10;
                int pi = 2;
                SOCResourceSet[][] tradesGiveGet = pl.getResourceTradeStats();
                for (int tradeType = 0; tradeType < 8; ++tradeType) {
                    for (int giveGet = 0; giveGet < 2; ++giveGet) {
                        int[] res = tradesGiveGet[giveGet][tradeType].getAmounts(false);
                        System.arraycopy(res, 0, this.pa, pi, 5);
                        pi += 5;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("stype out of range: " + stype);
            }
        }
    }

    protected SOCPlayerStats(String gameName, int[] pa) throws IllegalArgumentException {
        super(1085, gameName, pa);
    }

    private static final int len(SOCPlayer pl, int stype) throws IllegalArgumentException, NullPointerException {
        switch (stype) {
            case 1: {
                boolean hasGold = pl.getResourceRollStats()[6] != 0;
                return 6 + (hasGold ? 1 : 0);
            }
            case 2: {
                return 82;
            }
        }
        throw new IllegalArgumentException("stype out of range: " + stype);
    }

    @Override
    public int getMinimumVersion() {
        return 1109;
    }

    public int getStatType() {
        return this.pa[0];
    }

    public static SOCPlayerStats parseDataStr(List<String> pa) {
        if (pa == null) {
            return null;
        }
        int L = pa.size();
        if (L < 2) {
            return null;
        }
        try {
            String gaName = pa.get(0);
            int[] ipa = new int[L - 1];
            for (int i = 0; i < ipa.length; ++i) {
                ipa[i] = Integer.parseInt(pa.get(i + 1));
            }
            return new SOCPlayerStats(gaName, ipa);
        }
        catch (Exception e) {
            return null;
        }
    }
}

