/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCPotentialSettlements
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 2000L;
    public static final int VERSION_FOR_PLAYERNUM_ALL = 2000;
    private String game;
    private int playerNumber;
    private List<Integer> psNodes;
    private final boolean psNodesFromAll;
    public final int areaCount;
    public final int startingLandArea;
    public final HashSet<Integer>[] landAreasLegalNodes;
    public int[][] legalSeaEdges;

    public SOCPotentialSettlements(String ga, int pn, List<Integer> ps) {
        this.messageType = 1057;
        this.game = ga;
        this.playerNumber = pn;
        this.psNodes = ps;
        this.psNodesFromAll = false;
        this.areaCount = 1;
        this.landAreasLegalNodes = null;
        this.startingLandArea = 1;
        this.legalSeaEdges = null;
    }

    public SOCPotentialSettlements(String ga, int pn, List<Integer> ps, int[][] lse) throws IllegalArgumentException {
        this(ga, pn, ps);
        if (pn <= 0) {
            throw new IllegalArgumentException("pn");
        }
        this.legalSeaEdges = lse;
    }

    public SOCPotentialSettlements(String ga, int pn, List<Integer> ps, int pan, HashSet<Integer>[] lan, int[][] lse) throws IllegalArgumentException, NullPointerException {
        this.messageType = 1057;
        this.game = ga;
        this.playerNumber = pn;
        this.psNodes = ps;
        this.psNodesFromAll = pan == 0 && ps == null;
        this.areaCount = lan.length - 1;
        this.landAreasLegalNodes = lan;
        this.startingLandArea = pan;
        this.legalSeaEdges = lse;
        for (int i = 1; i < lan.length; ++i) {
            if (lan[i] != null) continue;
            throw new IllegalArgumentException("lan[" + i + "] null");
        }
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    public List<Integer> getPotentialSettlements(boolean buildIfFromLALN) {
        List<Integer> ps = this.psNodes;
        if (buildIfFromLALN && ps == null && this.landAreasLegalNodes != null) {
            if (this.psNodesFromAll) {
                ps = new ArrayList<Integer>();
                for (int i = 1; i < this.landAreasLegalNodes.length; ++i) {
                    ps.addAll(this.landAreasLegalNodes[i]);
                }
            } else {
                ps = new ArrayList<Integer>(this.landAreasLegalNodes[this.startingLandArea]);
            }
        }
        return ps;
    }

    @Override
    public String toCmd() {
        if (this.landAreasLegalNodes == null && this.legalSeaEdges == null) {
            return SOCPotentialSettlements.toCmd(this.game, this.playerNumber, this.psNodes);
        }
        if (this.landAreasLegalNodes != null) {
            return SOCPotentialSettlements.toCmd(this.game, this.playerNumber, this.psNodes, this.startingLandArea, this.landAreasLegalNodes, this.legalSeaEdges);
        }
        return SOCPotentialSettlements.toCmd(this.game, this.playerNumber, this.psNodes, 0, null, this.legalSeaEdges);
    }

    private static String toCmd(String ga, int pn, List<Integer> ps) {
        String cmd = "1057|" + ga + "," + pn;
        for (Integer number : ps) {
            cmd = cmd + "," + number;
        }
        return cmd;
    }

    private static String toCmd(String ga, int pn, List<Integer> ps, int pan, HashSet<Integer>[] lan, int[][] lse) {
        StringBuilder cmd = new StringBuilder("1057|" + ga + "," + pn);
        if (ps != null) {
            if (!ps.isEmpty()) {
                Iterator<Integer> iter = ps.iterator();
                while (iter.hasNext()) {
                    cmd.append(",");
                    cmd.append(iter.next());
                }
            } else {
                cmd.append(",");
                cmd.append(0);
            }
        }
        cmd.append(",");
        cmd.append("NA");
        cmd.append(",");
        cmd.append(lan != null ? lan.length - 1 : 0);
        cmd.append(",");
        cmd.append("PAN");
        cmd.append(",");
        cmd.append(pan);
        if (lan != null) {
            for (int i = 1; i < lan.length; ++i) {
                cmd.append(",");
                cmd.append("LA");
                cmd.append(i);
                Iterator<Integer> pnIter = lan[i].iterator();
                while (pnIter.hasNext()) {
                    cmd.append(",");
                    int number = pnIter.next();
                    cmd.append(number);
                }
            }
        }
        if (lse != null) {
            for (int i = 0; i < lse.length; ++i) {
                cmd.append(",");
                cmd.append("SE");
                int[] lse_i = lse[i];
                if (lse_i.length == 0 && i == lse.length - 1) {
                    cmd.append(",");
                    cmd.append(0);
                    continue;
                }
                for (int j = 0; j < lse_i.length; ++j) {
                    cmd.append(",");
                    int k = lse_i[j];
                    if (k < 0) {
                        cmd.append('-');
                        k = -k;
                    }
                    cmd.append(Integer.toHexString(k));
                }
            }
        }
        return cmd.toString();
    }

    public static SOCPotentialSettlements parseDataStr(String s) {
        int pn;
        String ga;
        ArrayList<Integer> ps = new ArrayList<Integer>();
        HashSet[] lan = null;
        int pan = 0;
        Object legalSeaEdges = null;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            ga = st.nextToken();
            pn = Integer.parseInt(st.nextToken());
            boolean hadNA = false;
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (tok.equals("NA")) {
                    hadNA = true;
                    break;
                }
                ps.add(Integer.parseInt(tok));
            }
            if (hadNA) {
                String tok;
                int numArea = Integer.parseInt(st.nextToken());
                if (numArea > 0) {
                    lan = new HashSet[numArea + 1];
                }
                if (!(tok = st.nextToken()).equals("PAN")) {
                    return null;
                }
                pan = Integer.parseInt(st.nextToken());
                if (pan < 0) {
                    return null;
                }
                if (st.hasMoreTokens()) {
                    tok = st.nextToken();
                } else {
                    tok = null;
                    if (numArea > 1 || pan != 1) {
                        return null;
                    }
                }
                while (st.hasMoreTokens()) {
                    if (!tok.startsWith("LA")) {
                        if (tok.equals("SE")) break;
                        return null;
                    }
                    int areaNum = Integer.parseInt(tok.substring(2));
                    if (areaNum <= 0) {
                        return null;
                    }
                    HashSet<Integer> ls = new HashSet<Integer>();
                    while (st.hasMoreTokens() && !(tok = st.nextToken()).equals("SE") && !tok.startsWith("LA")) {
                        if (areaNum == 0) {
                            return null;
                        }
                        ls.add(Integer.parseInt(tok));
                    }
                    lan[areaNum] = ls;
                }
                if (st.hasMoreTokens() && tok.equals("SE")) {
                    ArrayList<int[]> allLSE = new ArrayList<int[]>();
                    while (st.hasMoreTokens() && tok.equals("SE")) {
                        ArrayList<Integer> lse = new ArrayList<Integer>();
                        while (st.hasMoreTokens() && !(tok = st.nextToken()).equals("SE")) {
                            int edge = Integer.parseInt(tok, 16);
                            if (edge == 0) continue;
                            lse.add(edge);
                        }
                        int L = lse.size();
                        int[] lseArr = new int[L];
                        for (int i = 0; i < L; ++i) {
                            lseArr[i] = (Integer)lse.get(i);
                        }
                        allLSE.add(lseArr);
                    }
                    int L = allLSE.size();
                    legalSeaEdges = new int[L][];
                    for (int i = 0; i < L; ++i) {
                        legalSeaEdges[i] = (int[])allLSE.get(i);
                    }
                }
                if (ps.isEmpty()) {
                    ps = null;
                } else if (ps.size() == 1 && (Integer)ps.get(0) == 0) {
                    ps.clear();
                }
                if (numArea > 0) {
                    for (int i = 1; i <= numArea; ++i) {
                        if (lan[i] != null) continue;
                        return null;
                    }
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        if (lan == null) {
            if (legalSeaEdges != null) {
                if (pn <= 0) {
                    return null;
                }
                return new SOCPotentialSettlements(ga, pn, (List<Integer>)ps, (int[][])legalSeaEdges);
            }
            return new SOCPotentialSettlements(ga, pn, ps);
        }
        return new SOCPotentialSettlements(ga, pn, (List<Integer>)ps, pan, lan, (int[][])legalSeaEdges);
    }

    public static String stripAttribNames(String messageStrParams) {
        int psListStatus;
        String[] pieces = messageStrParams.split("\\|");
        if (pieces.length < 3) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        if (!pieces[0].startsWith("game=")) {
            return null;
        }
        ret.append(pieces[0].substring(5));
        if (!pieces[1].startsWith("playerNum=")) {
            return null;
        }
        ret.append(',').append(pieces[1].substring(10));
        String s = pieces[2];
        if (s.length() <= 5 || !s.startsWith("list=")) {
            return null;
        }
        if ((s = s.substring(5)).equals("(null)") || s.equals("(fromAllLANodes)")) {
            psListStatus = -1;
        } else if (s.equals("(empty)")) {
            psListStatus = 0;
        } else {
            psListStatus = 1;
            for (String coordStr : s.split(" ")) {
                ret.append(',').append(Integer.toString(Integer.parseInt(coordStr, 16)));
            }
        }
        if (pieces.length <= 3) {
            return ret.toString();
        }
        if (psListStatus == 0) {
            ret.append(',').append(0);
        }
        int pieceIdx = 3;
        if (pieces[3].startsWith("pan=")) {
            int i;
            String piece;
            int pan = Integer.parseInt(pieces[3].substring(4));
            ArrayList<Object> landAreaNodes = new ArrayList<Object>();
            for (pieceIdx = 4; pieceIdx < pieces.length && (piece = pieces[pieceIdx]).startsWith("la"); ++pieceIdx) {
                i = piece.indexOf(61);
                if (i < 3 || i > 5) {
                    return null;
                }
                int n = Integer.parseInt(piece.substring(2, i));
                if (n <= 0) {
                    return null;
                }
                if (n < landAreaNodes.size() && landAreaNodes.get(n) != null) {
                    return null;
                }
                ArrayList nodes = new ArrayList();
                String rhs = piece.substring(i + 1);
                if (!rhs.equals("(empty)")) {
                    for (String node : rhs.split(" ")) {
                        nodes.add(Integer.parseInt(node, 16));
                    }
                }
                while (n >= landAreaNodes.size()) {
                    landAreaNodes.add(null);
                }
                landAreaNodes.set(n, nodes);
            }
            int numArea = landAreaNodes.size() - 1;
            ret.append(",NA,").append(numArea);
            ret.append(",PAN,").append(pan);
            for (i = 1; i <= numArea; ++i) {
                ret.append(",LA").append(i);
                List list = (List)landAreaNodes.get(i);
                if (list == null) continue;
                for (Integer node : list) {
                    ret.append(',').append(node);
                }
            }
        } else if (pieceIdx < pieces.length) {
            ret.append(",NA,0,PAN,0");
        }
        if (pieceIdx < pieces.length) {
            String piece = pieces[pieceIdx];
            int pL = piece.length();
            if (!piece.startsWith("lse={") || !piece.substring(pL - 2).equals("}}")) {
                return null;
            }
            ArrayList lse = new ArrayList();
            for (String subLseStr : piece.substring(6, pL - 2).split("\\},\\{", 99)) {
                ArrayList<Integer> subLse = new ArrayList<Integer>();
                if (!subLseStr.isEmpty()) {
                    for (String item : subLseStr.split(",")) {
                        int i = item.indexOf(45);
                        if (i == -1) {
                            subLse.add(Integer.parseInt(item, 16));
                            continue;
                        }
                        subLse.add(Integer.parseInt(item.substring(0, i), 16));
                        subLse.add(-Integer.parseInt(item.substring(i + 1), 16));
                    }
                }
                lse.add(subLse);
            }
            for (List list : lse) {
                ret.append(",SE");
                int L = list.size();
                for (int i = 0; i < L; ++i) {
                    int next;
                    ret.append(',').append(Integer.toString((Integer)list.get(i), 16));
                    if (i + 1 >= L || (next = ((Integer)list.get(i + 1)).intValue()) >= 0) continue;
                    ret.append(',').append(Integer.toString(next, 16));
                    ++i;
                }
            }
            if (((List)lse.get(lse.size() - 1)).isEmpty()) {
                ret.append(",0");
            }
        }
        return ret.toString();
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("SOCPotentialSettlements:game=" + this.game + "|playerNum=" + this.playerNumber + "|list=");
        if (this.psNodesFromAll) {
            s.append("(fromAllLANodes)");
        } else if (this.psNodes == null) {
            s.append("(null)");
        } else if (this.psNodes.isEmpty()) {
            s.append("(empty)");
        } else {
            for (Integer number : this.psNodes) {
                s.append(Integer.toHexString(number));
                s.append(' ');
            }
        }
        if (this.landAreasLegalNodes != null) {
            s.append("|pan=");
            s.append(this.startingLandArea);
            for (int i = 1; i < this.landAreasLegalNodes.length; ++i) {
                s.append("|la");
                s.append(i);
                s.append('=');
                HashSet<Integer> nodes = this.landAreasLegalNodes[i];
                if (nodes.isEmpty()) {
                    s.append("(empty)");
                    continue;
                }
                for (int number : nodes) {
                    s.append(Integer.toHexString(number));
                    s.append(' ');
                }
            }
        }
        if (this.legalSeaEdges != null) {
            s.append("|lse={");
            for (int i = 0; i < this.legalSeaEdges.length; ++i) {
                if (i > 0) {
                    s.append(',');
                }
                s.append('{');
                int[] lse_i = this.legalSeaEdges[i];
                for (int j = 0; j < lse_i.length; ++j) {
                    int k = lse_i[j];
                    if (k < 0) {
                        s.append('-');
                        k = -k;
                    } else if (j > 0) {
                        s.append(',');
                    }
                    s.append(Integer.toHexString(k));
                }
                s.append('}');
            }
            s.append('}');
        }
        return s.toString();
    }
}

