/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCPutPiece
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 1111L;
    private String game;
    private int pieceType;
    private int playerNumber;
    private int coordinates;

    public SOCPutPiece(String na, int pn, int pt, int co) throws IllegalArgumentException {
        if (pt < 0) {
            throw new IllegalArgumentException("pt: " + pt);
        }
        if (co < 0) {
            throw new IllegalArgumentException("coord < 0: " + co);
        }
        this.messageType = 1009;
        this.game = na;
        this.pieceType = pt;
        this.playerNumber = pn;
        this.coordinates = co;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getPieceType() {
        return this.pieceType;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    public int getCoordinates() {
        return this.coordinates;
    }

    @Override
    public String toCmd() {
        return SOCPutPiece.toCmd(this.game, this.playerNumber, this.pieceType, this.coordinates);
    }

    public static String toCmd(String ga, int pn, int pt, int co) throws IllegalArgumentException {
        if (pt < 0) {
            throw new IllegalArgumentException("pt: " + pt);
        }
        if (co < 0) {
            throw new IllegalArgumentException("coord < 0: " + co);
        }
        return "1009|" + ga + "," + pn + "," + pt + "," + co;
    }

    public static SOCPutPiece parseDataStr(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            String na = st.nextToken();
            int pn = Integer.parseInt(st.nextToken());
            int pt = Integer.parseInt(st.nextToken());
            int co = Integer.parseInt(st.nextToken());
            return new SOCPutPiece(na, pn, pt, co);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String stripAttribNames(String messageStrParams) {
        String s = SOCMessage.stripAttribNames(messageStrParams);
        if (s == null) {
            return null;
        }
        String[] pieces = s.split(",");
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            ret.append(pieces[i]).append(',');
        }
        ret.append(Integer.parseInt(pieces[3], 16));
        return ret.toString();
    }

    @Override
    public String toString() {
        String s = "SOCPutPiece:game=" + this.game + "|playerNumber=" + this.playerNumber + "|pieceType=" + this.pieceType + "|coord=" + Integer.toHexString(this.coordinates);
        return s;
    }
}

