/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCRejectOffer
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 2500L;
    public static final int VERSION_FOR_REPLY_REASONS = 2500;
    public static final int REASON_CANNOT_MAKE_TRADE = 1;
    public static final int REASON_NOT_YOUR_TURN = 2;
    public static final int REASON_CANNOT_MAKE_OFFER = 3;
    private String game;
    private int playerNumber;
    private int reasonCode;

    public SOCRejectOffer(String ga, int pn) {
        this(ga, pn, 0);
    }

    public SOCRejectOffer(String ga, int pn, int reasonCode) {
        this.messageType = 1037;
        this.game = ga;
        this.playerNumber = pn;
        this.reasonCode = reasonCode;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    public int getReasonCode() {
        return this.reasonCode;
    }

    @Override
    public String toCmd() {
        return "1037|" + this.game + "," + this.playerNumber + (this.reasonCode != 0 ? "," + this.reasonCode : "");
    }

    public static SOCRejectOffer parseDataStr(String s) {
        int pn;
        String ga;
        int rc = 0;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            ga = st.nextToken();
            pn = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                rc = Integer.parseInt(st.nextToken());
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCRejectOffer(ga, pn, rc);
    }

    @Override
    public String toString() {
        return "SOCRejectOffer:game=" + this.game + "|playerNumber=" + this.playerNumber + (this.reasonCode != 0 ? "|reasonCode=" + this.reasonCode : "");
    }
}

