/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import soc.game.ResourceSet;
import soc.game.SOCResourceSet;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;
import soc.message.SOCPlayerElement;

public class SOCRobberyResult
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 2500L;
    public static final int MIN_VERSION = 2500;
    public final String gaName;
    public final int victimPN;
    public final int perpPN;
    public final int resType;
    public final SOCResourceSet resSet;
    public final SOCPlayerElement.PEType peType;
    public final boolean isGainLose;
    public final int amount;
    public final int victimAmount;
    public final int extraValue;

    public SOCRobberyResult(String gaName, int perpPN, int victimPN, int resType, boolean isGainLose, int amount, int victimAmount, int extraValue) throws IllegalArgumentException {
        this(gaName, perpPN, victimPN, resType, null, null, isGainLose, amount, victimAmount, extraValue);
    }

    public SOCRobberyResult(String gaName, int perpPN, int victimPN, ResourceSet resSet, int extraValue) throws IllegalArgumentException {
        this(gaName, perpPN, victimPN, -1, resSet, null, true, 0, 0, extraValue);
    }

    public SOCRobberyResult(String gaName, int perpPN, int victimPN, SOCPlayerElement.PEType peType, boolean isGainLose, int amount, int victimAmount, int extraValue) throws IllegalArgumentException {
        this(gaName, perpPN, victimPN, -1, null, peType, isGainLose, amount, victimAmount, extraValue);
    }

    private SOCRobberyResult(String gaName, int perpPN, int victimPN, int resType, ResourceSet resSet, SOCPlayerElement.PEType peType, boolean isGainLose, int amount, int victimAmount, int extraValue) throws IllegalArgumentException {
        if (peType == null && resSet == null && resType < 0) {
            throw new IllegalArgumentException("peType/resSet/resType");
        }
        if (resSet == null && (amount < 0 || victimAmount < 0)) {
            throw new IllegalArgumentException("amounts");
        }
        if (isGainLose && victimAmount != 0) {
            throw new IllegalArgumentException("victimAmount but isGainLose");
        }
        if (resSet != null && resSet.isEmpty()) {
            throw new IllegalArgumentException("resSet empty");
        }
        this.messageType = 1102;
        this.gaName = gaName;
        this.perpPN = perpPN;
        this.victimPN = victimPN;
        this.resType = resSet == null && peType == null ? resType : 0;
        this.resSet = resSet == null ? null : new SOCResourceSet(resSet);
        this.peType = peType;
        this.isGainLose = isGainLose;
        this.amount = amount;
        this.victimAmount = victimAmount;
        this.extraValue = extraValue;
    }

    @Override
    public String getGame() {
        return this.gaName;
    }

    @Override
    public final int getMinimumVersion() {
        return 2500;
    }

    @Override
    public String toCmd() {
        StringBuilder sb = new StringBuilder("1102|" + this.gaName + "," + this.perpPN + "," + this.victimPN + ",");
        if (this.resSet != null) {
            sb.append('S');
            for (int rt = 1; rt <= 5; ++rt) {
                int am = this.resSet.getAmount(rt);
                if (am == 0) continue;
                sb.append(",").append(rt).append(",").append(am);
            }
        } else if (this.peType != null) {
            sb.append('E').append(",").append(this.peType.getValue()).append(",").append(this.amount);
        } else {
            sb.append('R').append(",").append(this.resType).append(",").append(this.amount);
        }
        sb.append(",").append(this.isGainLose ? (char)'T' : 'F');
        if (this.victimAmount != 0 || this.extraValue != 0) {
            sb.append(",").append(this.victimAmount);
            if (this.extraValue != 0) {
                sb.append(",").append(this.extraValue);
            }
        }
        return sb.toString();
    }

    public static SOCRobberyResult parseDataStr(String cmd) {
        StringTokenizer st = new StringTokenizer(cmd, ",");
        try {
            boolean gainLose;
            int amt;
            SOCPlayerElement.PEType petype;
            int rtype;
            SOCResourceSet rset = null;
            String ga = st.nextToken();
            int ppn = Integer.parseInt(st.nextToken());
            int vpn = Integer.parseInt(st.nextToken());
            String s = st.nextToken();
            if (s.length() != 1) {
                return null;
            }
            char ch = s.charAt(0);
            int typeval = Integer.parseInt(st.nextToken());
            if (ch == 'S') {
                rtype = -1;
                petype = null;
                amt = 0;
                rset = new SOCResourceSet();
                rset.add(Integer.parseInt(st.nextToken()), typeval);
                while (true) {
                    if ((s = st.nextToken()).length() == 0) {
                        return null;
                    }
                    if (Character.isDigit(s.charAt(0))) {
                        int resTypeval = Integer.parseInt(s);
                        int resAmt = Integer.parseInt(st.nextToken());
                        rset.add(resAmt, resTypeval);
                        continue;
                    }
                    break;
                }
            } else if (ch == 'R') {
                rtype = typeval;
                petype = null;
                amt = Integer.parseInt(st.nextToken());
                s = st.nextToken();
            } else if (ch == 'E') {
                rtype = -1;
                petype = SOCPlayerElement.PEType.valueOf(typeval);
                if (petype == null) {
                    return null;
                }
                amt = Integer.parseInt(st.nextToken());
                s = st.nextToken();
            } else {
                return null;
            }
            if (s.length() != 1) {
                return null;
            }
            ch = s.charAt(0);
            if (ch == 'T') {
                gainLose = true;
            } else if (ch == 'F') {
                gainLose = false;
            } else {
                return null;
            }
            int victimAmt = st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : 0;
            int extraVal = st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : 0;
            return new SOCRobberyResult(ga, ppn, vpn, rtype, rset, petype, gainLose, amt, victimAmt, extraVal);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String stripAttribNames(String messageStrParams) {
        boolean isPENotRes = messageStrParams.contains("|peType=");
        boolean isResSet = !isPENotRes && messageStrParams.contains("|resSet=");
        boolean hasExtraValSkipsVictimAmt = messageStrParams.contains("|extraValue=") && !messageStrParams.contains("|victimAmount=");
        List<String> pieces = SOCMessage.stripAttribsToList(messageStrParams);
        if (pieces.size() < 6) {
            return null;
        }
        if (!(pieces instanceof ArrayList)) {
            pieces = new ArrayList<String>(pieces);
        }
        pieces.add(3, isResSet ? "S" : (isPENotRes ? "E" : "R"));
        int boolParamIdx = 6;
        if (isPENotRes) {
            SOCPlayerElement.PEType pe = SOCPlayerElement.PEType.valueOf(pieces.get(4));
            int v = pe != null ? pe.getValue() : 0;
            pieces.set(4, Integer.toString(v));
        } else if (isResSet) {
            if (pieces.size() < 11) {
                return null;
            }
            ArrayList<String> resPairs = new ArrayList<String>();
            int i = 4;
            int rtype = 1;
            while (i <= 8) {
                try {
                    int amt;
                    String s = pieces.get(i);
                    if (i == 4 && s.startsWith("clay=")) {
                        s = s.substring(5);
                    }
                    if ((amt = Integer.parseInt(s)) != 0) {
                        resPairs.add(Integer.toString(rtype));
                        resPairs.add(Integer.toString(amt));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ++i;
                ++rtype;
            }
            for (i = 1; i <= 6; ++i) {
                pieces.remove(4);
            }
            pieces.addAll(4, resPairs);
            boolParamIdx = 4 + resPairs.size();
        }
        pieces.set(boolParamIdx, pieces.get(boolParamIdx).equals("true") ? "T" : "F");
        if (hasExtraValSkipsVictimAmt) {
            pieces.add(pieces.size() - 1, "0");
        }
        StringBuilder ret = new StringBuilder(pieces.get(0));
        int L = pieces.size();
        for (int i = 1; i < L; ++i) {
            ret.append(',').append(pieces.get(i));
        }
        return ret.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SOCRobberyResult:game=" + this.gaName);
        sb.append("|perp=").append(this.perpPN).append("|victim=").append(this.victimPN);
        if (this.resSet != null) {
            sb.append("|resSet=").append(this.resSet);
        } else if (this.peType != null) {
            sb.append("|peType=").append((Object)this.peType).append("|amount=").append(this.amount);
        } else {
            sb.append("|resType=").append(this.resType).append("|amount=").append(this.amount);
        }
        sb.append("|isGainLose=").append(this.isGainLose);
        if (this.victimAmount != 0 || !this.isGainLose) {
            sb.append("|victimAmount=").append(this.victimAmount);
        }
        if (this.extraValue != 0) {
            sb.append("|extraValue=").append(this.extraValue);
        }
        return sb.toString();
    }
}

