/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCRollDicePrompt
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 1111L;
    private String game;
    private int playerNumber;

    public SOCRollDicePrompt(String ga, int pn) {
        this.messageType = 1072;
        this.game = ga;
        this.playerNumber = pn;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    @Override
    public String toCmd() {
        return SOCRollDicePrompt.toCmd(this.game, this.playerNumber);
    }

    public static String toCmd(String ga, int pn) {
        return "1072|" + ga + "," + pn;
    }

    public static SOCRollDicePrompt parseDataStr(String s) {
        int pn;
        String ga;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            ga = st.nextToken();
            pn = Integer.parseInt(st.nextToken());
        }
        catch (Exception e) {
            return null;
        }
        return new SOCRollDicePrompt(ga, pn);
    }

    @Override
    public String toString() {
        return "SOCRollDicePrompt:game=" + this.game + "|playerNumber=" + this.playerNumber;
    }

    @Override
    public int getMinimumVersion() {
        return 1100;
    }
}

