/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCKeyedMessage;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCSVPTextMessage
extends SOCMessage
implements SOCKeyedMessage,
SOCMessageForGame {
    private static final long serialVersionUID = 2000L;
    public final String game;
    public final int pn;
    public final int svp;
    public final String desc;
    public final boolean isLocalized;

    public SOCSVPTextMessage(String ga, int pn, int svp, String desc) throws IllegalArgumentException {
        this(ga, pn, svp, desc, false);
    }

    public SOCSVPTextMessage(String ga, int pn, int svp, String desc, boolean isLocal) throws IllegalArgumentException {
        if (desc == null || !SOCSVPTextMessage.isSingleLineAndSafe(desc, true)) {
            throw new IllegalArgumentException("desc");
        }
        this.messageType = 1097;
        this.game = ga;
        this.pn = pn;
        this.svp = svp;
        this.desc = desc;
        this.isLocalized = isLocal;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    @Override
    public String toCmd() {
        return SOCSVPTextMessage.toCmd(this.messageType, this.game, this.pn, this.svp, this.desc);
    }

    protected static String toCmd(int messageType, String ga, int pn, int svp, String desc) {
        return Integer.toString(messageType) + "|" + ga + "," + pn + "," + svp + "," + desc;
    }

    @Override
    public String getKey() {
        return this.desc;
    }

    @Override
    public SOCMessage localize(String localizedText) {
        return new SOCSVPTextMessage(this.game, this.pn, this.svp, localizedText, true);
    }

    public static SOCSVPTextMessage parseDataStr(String s) {
        String desc;
        int svp;
        int pn;
        String ga;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            ga = st.nextToken();
            pn = Integer.parseInt(st.nextToken());
            svp = Integer.parseInt(st.nextToken());
            desc = st.nextToken(Character.toString('\u0001')).trim();
            if (desc.startsWith(",")) {
                desc = desc.substring(1);
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCSVPTextMessage(ga, pn, svp, desc, true);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ":game=" + this.game + "|pn=" + this.pn + "|svp=" + this.svp + "|desc=" + this.desc;
    }
}

