/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.ArrayList;
import java.util.List;
import soc.game.SOCScenario;
import soc.message.SOCMessage;
import soc.message.SOCMessageFromUnauthClient;
import soc.message.SOCMessageTemplateMs;

public class SOCScenarioInfo
extends SOCMessageTemplateMs
implements SOCMessageFromUnauthClient {
    private static final long serialVersionUID = 2500L;
    public static final String MARKER_ANY_CHANGED = "?";
    public static final String MARKER_SCEN_NAME_LIST = "[";
    public static final String MARKER_NO_MORE_SCENS = "-";
    public static final int MARKER_KEY_UNKNOWN = -2;
    private static final String STR_MARKER_KEY_UNKNOWN = Integer.toString(-2);
    public final boolean isFromServer;
    private SOCScenario scen;
    private final String scKey;
    public final boolean isKeyUnknown;
    public final boolean noMoreScens;
    private final String[] FIELD_NAMES = new String[]{"key", "minVers", "lastModVers", "opts", "title", "desc"};

    public SOCScenarioInfo(SOCScenario sc, String localDesc, String localLongDesc) {
        super(1101, new ArrayList<String>());
        this.isFromServer = true;
        this.isKeyUnknown = false;
        this.noMoreScens = sc == null;
        this.scen = sc;
        if (sc != null) {
            this.scKey = sc.key;
            String opts = sc.scOpts;
            if (localDesc == null) {
                localDesc = sc.getDesc();
            }
            this.pa.add(sc.key);
            this.pa.add(Integer.toString(sc.minVersion));
            this.pa.add(Integer.toString(sc.lastModVersion));
            this.pa.add(opts);
            this.pa.add(localDesc);
            if (localLongDesc == null) {
                localLongDesc = sc.getLongDesc();
            }
            if (localLongDesc != null && localLongDesc.length() > 0) {
                this.pa.add(localLongDesc);
            }
        } else {
            this.scKey = MARKER_NO_MORE_SCENS;
            this.pa.add(MARKER_NO_MORE_SCENS);
        }
    }

    public SOCScenarioInfo(String scKey, boolean isServerReply) throws IllegalArgumentException {
        super(1101, new ArrayList<String>());
        if (!SOCScenarioInfo.isSingleLineAndSafe(scKey)) {
            throw new IllegalArgumentException("scKey: " + scKey);
        }
        this.isFromServer = isServerReply;
        this.noMoreScens = false;
        this.isKeyUnknown = isServerReply;
        this.scKey = scKey;
        if (!isServerReply) {
            this.pa.add(MARKER_SCEN_NAME_LIST);
        }
        this.pa.add(scKey);
        if (!isServerReply) {
            return;
        }
        this.pa.add("0");
        this.pa.add(STR_MARKER_KEY_UNKNOWN);
    }

    public SOCScenarioInfo(List<String> scKeys, boolean addMarkerAnyChanged) throws IllegalArgumentException {
        super(1101, scKeys != null ? scKeys : new ArrayList());
        this.isFromServer = false;
        if (scKeys == null || scKeys.isEmpty()) {
            if (!addMarkerAnyChanged) {
                throw new IllegalArgumentException("empty message");
            }
        } else {
            for (String sc : scKeys) {
                if (SOCMessage.isSingleLineAndSafe(sc)) continue;
                throw new IllegalArgumentException();
            }
            this.pa.add(0, MARKER_SCEN_NAME_LIST);
        }
        if (addMarkerAnyChanged) {
            this.pa.add(MARKER_ANY_CHANGED);
        }
        this.scKey = null;
        this.isKeyUnknown = false;
        this.noMoreScens = false;
    }

    private SOCScenarioInfo(List<String> pa) throws IllegalArgumentException, IndexOutOfBoundsException, NumberFormatException {
        super(1101, SOCScenarioInfo.parseData_FindEmptyStrs(pa));
        int L = pa.size();
        String s = pa.get(0);
        boolean startswithCliListMarker = s.equals(MARKER_SCEN_NAME_LIST);
        boolean bl = this.isFromServer = !startswithCliListMarker && !s.equals(MARKER_ANY_CHANGED);
        if (!this.isFromServer) {
            if (startswithCliListMarker) {
                pa.remove(0);
                if (pa.isEmpty()) {
                    throw new IndexOutOfBoundsException();
                }
            }
            this.scKey = null;
            this.isKeyUnknown = false;
            this.noMoreScens = false;
        } else {
            this.scKey = s;
            this.noMoreScens = this.scKey.equals(MARKER_NO_MORE_SCENS);
            if (!this.noMoreScens) {
                int minVers = Integer.parseInt(pa.get(1));
                int lastModVers = Integer.parseInt(pa.get(2));
                boolean bl2 = this.isKeyUnknown = lastModVers == -2;
                if (!this.isKeyUnknown) {
                    String longDesc = L >= 6 ? pa.get(5) : null;
                    this.scen = new SOCScenario(this.scKey, minVers, lastModVers, pa.get(4), longDesc, pa.get(3));
                }
            } else {
                this.isKeyUnknown = false;
            }
        }
    }

    @Override
    public int getMinimumVersion() {
        return 2000;
    }

    public SOCScenario getScenario() {
        return this.scen;
    }

    public String getScenarioKey() {
        return this.scKey;
    }

    public static SOCScenarioInfo parseDataStr(List<String> pa, String soleParam) {
        if (pa == null) {
            if (soleParam == null) {
                return null;
            }
            pa = new ArrayList<String>();
            pa.add(soleParam);
        } else if (pa.isEmpty()) {
            return null;
        }
        try {
            return new SOCScenarioInfo(pa);
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public String toString() {
        ArrayList<String> fields = this.pa;
        if (this.isFromServer && fields.size() > 2 && (this.isKeyUnknown || ((String)fields.get(2)).equals(STR_MARKER_KEY_UNKNOWN))) {
            fields = new ArrayList<String>(fields);
            fields.set(2, "MARKER_KEY_UNKNOWN");
        }
        return this.toString((List<String>)fields, this.isFromServer ? this.FIELD_NAMES : null);
    }
}

