/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.game.GameAction;
import soc.game.ResourceSet;
import soc.game.SOCResourceSet;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCSetLastAction
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 2700L;
    public static final int VERSION_FOR_SETLASTACTION = 2700;
    private final String game;
    private final int actTypeValue;
    private final int param1;
    private final int param2;
    private final int param3;
    private final ResourceSet rset1;
    private final ResourceSet rset2;

    public SOCSetLastAction(String gn, int aType, int p1, int p2, int p3) {
        this(gn, aType, p1, p2, p3, null, null);
    }

    public SOCSetLastAction(String gn, int aType, int p1, int p2, int p3, ResourceSet rs1, ResourceSet rs2) {
        this.messageType = 1106;
        this.game = gn;
        this.actTypeValue = aType;
        this.param1 = p1;
        this.param2 = p2;
        this.param3 = p3;
        this.rset1 = rs1;
        this.rset2 = rs2;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getActionTypeValue() {
        return this.actTypeValue;
    }

    public int getParam1() {
        return this.param1;
    }

    public int getParam2() {
        return this.param2;
    }

    public int getParam3() {
        return this.param3;
    }

    public ResourceSet getRS1() {
        return this.rset1;
    }

    public ResourceSet getRS2() {
        return this.rset2;
    }

    @Override
    public String toCmd() {
        int rtype;
        StringBuilder ret = new StringBuilder("1106|" + this.game + "," + this.actTypeValue + "," + this.param1 + "," + this.param2 + "," + this.param3);
        if (this.rset1 != null) {
            ret.append(',').append("R1");
            for (rtype = 1; rtype <= 5; ++rtype) {
                ret.append(',').append(this.rset1.getAmount(rtype));
            }
        }
        if (this.rset2 != null) {
            ret.append(',').append("R2");
            for (rtype = 1; rtype <= 5; ++rtype) {
                ret.append(',').append(this.rset2.getAmount(rtype));
            }
        }
        return ret.toString();
    }

    public static SOCSetLastAction parseDataStr(String s) {
        SOCResourceSet rs1 = null;
        SOCResourceSet rs2 = null;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            String gaName = st.nextToken();
            int aType = Integer.parseInt(st.nextToken());
            int p1 = Integer.parseInt(st.nextToken());
            int p2 = Integer.parseInt(st.nextToken());
            int p3 = Integer.parseInt(st.nextToken());
            while (st.hasMoreTokens()) {
                int wo;
                int wh;
                int sh;
                int or;
                int cl;
                String tok = st.nextToken();
                if (tok.equals("R1")) {
                    cl = Integer.parseInt(st.nextToken());
                    or = Integer.parseInt(st.nextToken());
                    sh = Integer.parseInt(st.nextToken());
                    wh = Integer.parseInt(st.nextToken());
                    wo = Integer.parseInt(st.nextToken());
                    rs1 = new SOCResourceSet(cl, or, sh, wh, wo, 0);
                    continue;
                }
                if (!tok.equals("R2")) continue;
                cl = Integer.parseInt(st.nextToken());
                or = Integer.parseInt(st.nextToken());
                sh = Integer.parseInt(st.nextToken());
                wh = Integer.parseInt(st.nextToken());
                wo = Integer.parseInt(st.nextToken());
                rs2 = new SOCResourceSet(cl, or, sh, wh, wo, 0);
            }
            return new SOCSetLastAction(gaName, aType, p1, p2, p3, rs1, rs2);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public int getMinimumVersion() {
        return 2700;
    }

    public static String stripAttribNames(String messageStrParams) {
        int startIdx = (messageStrParams = messageStrParams.replace("|rs1=[", "|R1|").replace("|rs2=[", "|R2|").replace("|unknown=0]", "")).indexOf("|actType=") + 9;
        if (startIdx <= 9) {
            return null;
        }
        int endIdx = messageStrParams.indexOf(124, startIdx);
        if (endIdx == -1 || endIdx - startIdx <= 1) {
            return null;
        }
        String actTypeIdent = messageStrParams.substring(startIdx, endIdx);
        if (!Character.isDigit(actTypeIdent.charAt(0))) {
            GameAction.ActionType act = GameAction.ActionType.valueOf(actTypeIdent);
            if (act == null) {
                act = GameAction.ActionType.UNKNOWN;
            }
            int atv = act.value;
            messageStrParams = messageStrParams.substring(0, startIdx - 8) + atv + messageStrParams.substring(endIdx);
        }
        return SOCMessage.stripAttribNames(messageStrParams);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SOCSetLastAction:game=" + this.game + "|actType=");
        GameAction.ActionType at = GameAction.ActionType.valueOf(this.actTypeValue);
        if (at != null) {
            sb.append((Object)at);
        } else {
            sb.append(this.actTypeValue);
        }
        if (this.param1 != 0 || this.param2 != 0 || this.param3 != 0) {
            sb.append("|p1=").append(this.param1);
            if (this.param2 != 0 || this.param3 != 0) {
                sb.append("|p2=").append(this.param2);
                if (this.param3 != 0) {
                    sb.append("|p3=").append(this.param3);
                }
            }
        }
        if (this.rset1 != null) {
            sb.append("|rs1=[").append(this.rset1).append(']');
        }
        if (this.rset2 != null) {
            sb.append("|rs2=[").append(this.rset2).append(']');
        }
        return sb.toString();
    }
}

