/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCSetPlayedDevCard
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 1111L;
    private String game;
    private int playerNumber;
    private boolean playedDevCard;

    public SOCSetPlayedDevCard(String ga, int pn, boolean pd) {
        this.messageType = 1048;
        this.game = ga;
        this.playerNumber = pn;
        this.playedDevCard = pd;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    public boolean hasPlayedDevCard() {
        return this.playedDevCard;
    }

    @Override
    public String toCmd() {
        return SOCSetPlayedDevCard.toCmd(this.game, this.playerNumber, this.playedDevCard);
    }

    public static String toCmd(String ga, int pn, boolean pd) {
        return "1048|" + ga + "," + pn + "," + pd;
    }

    public static SOCSetPlayedDevCard parseDataStr(String s) {
        boolean pd;
        int pn;
        String ga;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            ga = st.nextToken();
            pn = Integer.parseInt(st.nextToken());
            pd = Boolean.valueOf(st.nextToken());
        }
        catch (Exception e) {
            return null;
        }
        return new SOCSetPlayedDevCard(ga, pn, pd);
    }

    @Override
    public String toString() {
        return "SOCSetPlayedDevCard:game=" + this.game + "|playerNumber=" + this.playerNumber + "|playedDevCard=" + this.playedDevCard;
    }
}

