/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.InputMismatchException;
import java.util.StringTokenizer;
import soc.game.SOCGame;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCSetSeatLock
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 2000L;
    public static final int VERSION_FOR_ALL_SEATS = 2000;
    private final String game;
    private final int playerNumber;
    private SOCGame.SeatLockState state;
    private final SOCGame.SeatLockState[] states;

    public SOCSetSeatLock(String ga, int pn, SOCGame.SeatLockState st) {
        this.messageType = 1068;
        this.game = ga;
        this.playerNumber = pn;
        this.state = st;
        this.states = null;
    }

    public SOCSetSeatLock(String ga, SOCGame.SeatLockState[] st) throws IllegalArgumentException {
        if (st.length != 4 && st.length != 6) {
            throw new IllegalArgumentException("length");
        }
        this.messageType = 1068;
        this.game = ga;
        this.playerNumber = -1;
        this.states = st;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    public SOCGame.SeatLockState getLockState() {
        return this.state;
    }

    public SOCGame.SeatLockState[] getLockStates() {
        return this.states;
    }

    @Override
    public String toCmd() {
        if (this.states == null) {
            return SOCSetSeatLock.toCmd(this.game, this.playerNumber, this.state);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("1068|" + this.game);
        for (int pn = 0; pn < this.states.length; ++pn) {
            sb.append(',');
            SOCGame.SeatLockState st = this.states[pn];
            sb.append(st == SOCGame.SeatLockState.LOCKED ? "true" : (st == SOCGame.SeatLockState.UNLOCKED ? "false" : "clear"));
        }
        return sb.toString();
    }

    public static String toCmd(String ga, int pn, SOCGame.SeatLockState st) {
        return "1068|" + ga + "," + pn + "," + (st == SOCGame.SeatLockState.LOCKED ? "true" : (st == SOCGame.SeatLockState.UNLOCKED ? "false" : "clear"));
    }

    public static SOCSetSeatLock parseDataStr(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            String ga = st.nextToken();
            String tok = st.nextToken();
            if (Character.isDigit(tok.charAt(0))) {
                int pn = Integer.parseInt(tok);
                SOCGame.SeatLockState ls = SOCSetSeatLock.parseLockState(st.nextToken());
                return new SOCSetSeatLock(ga, pn, ls);
            }
            int np = 1 + st.countTokens();
            if (np != 4 && np != 6) {
                return null;
            }
            SOCGame.SeatLockState[] sls = new SOCGame.SeatLockState[np];
            sls[0] = SOCSetSeatLock.parseLockState(tok);
            for (int pn = 1; pn < np; ++pn) {
                sls[pn] = SOCSetSeatLock.parseLockState(st.nextToken());
            }
            return new SOCSetSeatLock(ga, sls);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static SOCGame.SeatLockState parseLockState(String lockst) throws InputMismatchException {
        SOCGame.SeatLockState ls;
        if (lockst.equals("true")) {
            ls = SOCGame.SeatLockState.LOCKED;
        } else if (lockst.equals("false")) {
            ls = SOCGame.SeatLockState.UNLOCKED;
        } else if (lockst.equals("clear")) {
            ls = SOCGame.SeatLockState.CLEAR_ON_RESET;
        } else {
            throw new InputMismatchException("lockstate: " + lockst);
        }
        return ls;
    }

    public static String stripAttribNames(String messageStrParams) {
        String s = SOCMessage.stripAttribNames(messageStrParams);
        if (s == null) {
            return null;
        }
        String[] pieces = s.split(",");
        if (pieces.length < 2) {
            return s;
        }
        for (int i = 1; i < pieces.length; ++i) {
            String lock = pieces[i];
            if ("LOCKED".equals(lock)) {
                pieces[i] = "true";
                continue;
            }
            if ("UNLOCKED".equals(lock)) {
                pieces[i] = "false";
                continue;
            }
            if (!"CLEAR_ON_RESET".equals(lock)) continue;
            pieces[i] = "clear";
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < pieces.length; ++i) {
            if (i > 0) {
                ret.append(',');
            }
            ret.append(pieces[i]);
        }
        return ret.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SOCSetSeatLock:game=" + this.game);
        if (this.states == null) {
            sb.append("|playerNumber=");
            sb.append(this.playerNumber);
            sb.append("|state=");
            sb.append((Object)this.state);
        } else {
            sb.append("|states=");
            for (int pn = 0; pn < this.states.length; ++pn) {
                if (pn > 0) {
                    sb.append(',');
                }
                sb.append((Object)this.states[pn]);
            }
        }
        return sb.toString();
    }
}

