/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.List;
import java.util.StringTokenizer;
import soc.game.SOCGame;
import soc.game.SOCSpecialItem;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCSetSpecialItem
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 2000L;
    public static final int OP_SET = 1;
    public static final int OP_CLEAR = 2;
    public static final int OP_PICK = 3;
    public static final int OP_DECLINE = 4;
    public static final int OP_SET_PICK = 5;
    public static final int OP_CLEAR_PICK = 6;
    public final String game;
    public final String typeKey;
    public final int op;
    public final int gameItemIndex;
    public final int playerItemIndex;
    public final int playerNumber;
    public final int coord;
    public final int level;
    public final String sv;
    public static final String[] OPS_STRS = new String[]{null, "SET", "CLEAR", "PICK", "DECLINE", "SET_PICK", "CLEAR_PICK"};

    public SOCSetSpecialItem(SOCGame game, int op, String typeKey, int gi, int pi, SOCSpecialItem item) throws IllegalArgumentException, NullPointerException {
        this(game.getName(), op, typeKey, gi, pi, item.getPlayer() != null ? item.getPlayer().getPlayerNumber() : -1, item.getCoordinates(), item.getLevel(), item.getStringValue());
    }

    public SOCSetSpecialItem(String ga, int op, String typeKey, int gi, int pi, int pn) throws IllegalArgumentException, NullPointerException {
        this(ga, op, typeKey, gi, pi, pn, -1, 0, null);
    }

    public SOCSetSpecialItem(String ga, int op, String typeKey, int gi, int pi, int pn, int co, int lv, String sv) throws IllegalArgumentException {
        if (ga == null || typeKey == null || pn != -1 && pi == -1 || pi == -1 && gi == -1 || sv != null && !SOCMessage.isSingleLineAndSafe(sv)) {
            throw new IllegalArgumentException();
        }
        this.messageType = 1099;
        this.game = ga;
        this.op = op;
        this.typeKey = typeKey;
        this.gameItemIndex = gi;
        this.playerItemIndex = pi;
        this.playerNumber = pn;
        this.coord = co;
        this.level = lv;
        this.sv = sv != null && sv.length() > 0 ? sv : null;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public static SOCSetSpecialItem parseDataStr(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            String ga = st.nextToken();
            int op = Integer.parseInt(st.nextToken());
            String tk = st.nextToken();
            int gi = Integer.parseInt(st.nextToken());
            int pi = Integer.parseInt(st.nextToken());
            int pn = Integer.parseInt(st.nextToken());
            int co = Integer.parseInt(st.nextToken());
            int lv = Integer.parseInt(st.nextToken());
            String sv = st.nextToken();
            if (sv.equals("\t")) {
                sv = null;
            }
            return new SOCSetSpecialItem(ga, op, tk, gi, pi, pn, co, lv, sv);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public int getMinimumVersion() {
        return 2000;
    }

    @Override
    public String toCmd() {
        String svStr = this.sv != null ? this.sv : "\t";
        return "1099|" + this.game + "," + this.op + "," + this.typeKey + "," + this.gameItemIndex + "," + this.playerItemIndex + "," + this.playerNumber + "," + this.coord + "," + this.level + "," + svStr;
    }

    public static String stripAttribNames(String messageStrParams) {
        int op;
        boolean svIsNull = false;
        if (messageStrParams.endsWith("|sv null")) {
            svIsNull = true;
        } else if (-1 == messageStrParams.indexOf("|sv=")) {
            return null;
        }
        List<String> pieces = SOCMessage.stripAttribsToList(messageStrParams);
        if (pieces == null || pieces.size() != 9) {
            return null;
        }
        String opStr = pieces.get(1);
        for (op = 1; op < OPS_STRS.length; ++op) {
            if (!OPS_STRS[op].equals(opStr)) continue;
            pieces.set(1, Integer.toString(op));
            break;
        }
        if (op >= OPS_STRS.length) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            ret.append(pieces.get(i)).append(',');
        }
        if (svIsNull) {
            ret.append("\t");
        } else {
            ret.append(pieces.get(8));
        }
        return ret.toString();
    }

    @Override
    public String toString() {
        String opStr = this.op > 0 && this.op < OPS_STRS.length ? OPS_STRS[this.op] : Integer.toString(this.op);
        return "SOCSetSpecialItem:game=" + this.game + "|op=" + opStr + "|typeKey=" + this.typeKey + "|gi=" + this.gameItemIndex + "|pi=" + this.playerItemIndex + "|pn=" + this.playerNumber + "|co=" + (this.coord >= 0 ? Integer.toHexString(this.coord) : Integer.toString(this.coord)) + "|lv=" + this.level + (this.sv != null ? "|sv=" + this.sv : "|sv null");
    }
}

