/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCSitDown
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 1111L;
    private String game;
    private String nickname;
    private int playerNumber;
    private boolean robotFlag;

    public SOCSitDown(String ga, String nk, int pn, boolean rf) {
        this.messageType = 1012;
        this.game = ga;
        this.nickname = nk;
        this.playerNumber = pn;
        this.robotFlag = rf;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public String getNickname() {
        return this.nickname;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    public boolean isRobot() {
        return this.robotFlag;
    }

    @Override
    public String toCmd() {
        return SOCSitDown.toCmd(this.game, this.nickname, this.playerNumber, this.robotFlag);
    }

    public static String toCmd(String ga, String nk, int pn, boolean rf) {
        return "1012|" + ga + "," + nk + "," + pn + "," + rf;
    }

    public static SOCSitDown parseDataStr(String s) {
        boolean rf;
        int pn;
        String nk;
        String ga;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            ga = st.nextToken();
            nk = st.nextToken();
            pn = Integer.parseInt(st.nextToken());
            rf = Boolean.valueOf(st.nextToken());
        }
        catch (Exception e) {
            return null;
        }
        return new SOCSitDown(ga, nk, pn, rf);
    }

    @Override
    public String toString() {
        return "SOCSitDown:game=" + this.game + "|nickname=" + this.nickname + "|playerNumber=" + this.playerNumber + "|robotFlag=" + this.robotFlag;
    }
}

