/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCStartGame
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 2000L;
    private String game;
    private final int gameState;

    public SOCStartGame(String ga, int gs) {
        this.messageType = 1018;
        this.game = ga;
        this.gameState = gs > 0 ? gs : 0;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getGameState() {
        return this.gameState;
    }

    @Override
    public String toCmd() {
        return SOCStartGame.toCmd(this.game, this.gameState);
    }

    public static String toCmd(String ga, int gs) {
        return "1018|" + ga + (gs > 0 ? "," + gs : "");
    }

    public static SOCStartGame parseDataStr(String s) {
        try {
            int gs = 0;
            StringTokenizer st = new StringTokenizer(s, ",");
            String ga = st.nextToken();
            if (st.hasMoreTokens()) {
                gs = Integer.parseInt(st.nextToken());
            }
            return new SOCStartGame(ga, gs);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String toString() {
        return "SOCStartGame:game=" + this.game + (this.gameState != 0 ? "|gameState=" + this.gameState : "");
    }
}

