/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import soc.message.SOCMessage;

public class SOCStatusMessage
extends SOCMessage {
    private static final long serialVersionUID = 2000L;
    public static final int SV_OK = 0;
    public static final int SV_NOT_OK_GENERIC = 1;
    public static final int SV_NAME_NOT_FOUND = 2;
    public static final int SV_PW_WRONG = 3;
    public static final int SV_NAME_IN_USE = 4;
    public static final int SV_CANT_JOIN_GAME_VERSION = 5;
    public static final int SV_PROBLEM_WITH_DB = 6;
    public static final int SV_ACCT_CREATED_OK = 7;
    public static final int SV_ACCT_NOT_CREATED_ERR = 8;
    public static final int SV_NEWGAME_OPTION_UNKNOWN = 9;
    public static final int SV_NEWGAME_OPTION_VALUE_TOONEW = 10;
    public static final int SV_NEWGAME_ALREADY_EXISTS = 11;
    public static final int SV_NEWGAME_NAME_REJECTED = 12;
    public static final int SV_NAME_TOO_LONG = 13;
    public static final int SV_NEWGAME_TOO_MANY_CREATED = 14;
    public static final int SV_NEWCHANNEL_TOO_MANY_CREATED = 15;
    public static final int SV_PW_REQUIRED = 16;
    public static final int SV_ACCT_NOT_CREATED_DENIED = 17;
    public static final int SV_ACCT_CREATED_OK_FIRST_ONE = 18;
    public static final int SV_NAME_NOT_ALLOWED = 19;
    public static final int SV_OK_SET_NICKNAME = 20;
    public static final int SV_OK_DEBUG_MODE_ON = 21;
    public static final int SV_GAME_CLIENT_FEATURES_NEEDED = 22;
    public static final int SV_SERVER_SHUTDOWN = 23;
    public static final int VERSION_FOR_SV_SERVER_SHUTDOWN = 2100;
    public static final int SV_MUST_AUTH_FIRST = 24;
    private String status;
    private int svalue;

    public SOCStatusMessage(String st) {
        this(0, st);
    }

    public static SOCStatusMessage buildForVersion(int sv, int cliVers, String st) throws IllegalArgumentException {
        return new SOCStatusMessage(SOCStatusMessage.statusFallbackForVersion(sv, cliVers), st);
    }

    public SOCStatusMessage(int sv, String st) {
        this.messageType = 1069;
        this.status = st;
        this.svalue = sv;
    }

    public String getStatus() {
        return this.status;
    }

    public int getStatusValue() {
        return this.svalue;
    }

    @Override
    public String toCmd() {
        return SOCStatusMessage.toCmd(this.svalue, this.status);
    }

    public static String toCmd(int sv, String st) {
        StringBuffer sb = new StringBuffer();
        sb.append(1069);
        sb.append("|");
        if (sv > 0) {
            sb.append(sv);
            sb.append(",");
        }
        sb.append(st);
        return sb.toString();
    }

    public static String toCmd(int sv, int cliVers, String st) throws IllegalArgumentException {
        int fallSV = SOCStatusMessage.statusFallbackForVersion(sv, cliVers);
        if (fallSV != sv) {
            return SOCStatusMessage.toCmd(fallSV, cliVers, st);
        }
        return SOCStatusMessage.toCmd(sv, st);
    }

    public static boolean statusValidAtVersion(int statusValue, int cliVersion) {
        switch (cliVersion) {
            case 1106: {
                return statusValue <= 8;
            }
            case 1107: 
            case 1108: 
            case 1109: {
                return statusValue <= 13;
            }
            case 1110: {
                return statusValue <= 15;
            }
            case 1119: {
                return statusValue <= 17;
            }
            case 1120: {
                return statusValue <= 18;
            }
            case 1200: {
                return statusValue <= 20;
            }
        }
        if (cliVersion < 1106) {
            return statusValue == 0;
        }
        if (cliVersion < 1119) {
            return statusValue < 16;
        }
        if (cliVersion < 1200) {
            return statusValue < 20;
        }
        if (cliVersion < 2000) {
            return statusValue < 21;
        }
        if (cliVersion < 2100) {
            return statusValue < 23;
        }
        if (cliVersion < 2400) {
            return statusValue < 24;
        }
        return statusValue <= 24;
    }

    public static int statusFallbackForVersion(int sv, int cliVersion) throws IllegalArgumentException {
        if (!SOCStatusMessage.statusValidAtVersion(sv, cliVersion)) {
            boolean reject = false;
            switch (sv) {
                case 21: {
                    sv = 0;
                    break;
                }
                case 16: {
                    sv = 3;
                    break;
                }
                case 18: {
                    sv = 7;
                    break;
                }
                case 20: {
                    reject = true;
                    break;
                }
                case 22: {
                    if (cliVersion >= 1107) {
                        sv = 10;
                        break;
                    }
                }
                default: {
                    sv = cliVersion >= 1106 ? 1 : 0;
                }
            }
            if (reject) {
                throw new IllegalArgumentException("No fallback for sv " + sv + " at client v" + cliVersion);
            }
        }
        return sv;
    }

    public static SOCStatusMessage parseDataStr(String s) {
        int sv = 0;
        int i = s.indexOf(",");
        if (i != -1) {
            if (i > 0) {
                try {
                    sv = Integer.parseInt(s.substring(0, i));
                    if (sv < 0) {
                        sv = 0;
                    }
                }
                catch (NumberFormatException e) {
                    i = -1;
                }
            } else {
                return null;
            }
            s = s.substring(i + 1);
        }
        return new SOCStatusMessage(sv, s);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SOCStatusMessage:");
        if (this.svalue > 0) {
            sb.append("sv=").append(this.svalue).append('|');
        }
        sb.append("status=");
        sb.append(this.status);
        return sb.toString();
    }
}

