/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCTurn
extends SOCMessage
implements SOCMessageForGame {
    public static final int VERSION_FOR_FLAG_CLEAR_AND_SBP_TEXT = 2500;
    public static final int VERSION_FOR_SEND_BEGIN_FIRST_TURN = 2500;
    private static final long serialVersionUID = 2000L;
    private String game;
    private int playerNumber;
    private final int gameState;

    public SOCTurn(String ga, int pn, int gs) {
        this.messageType = 1026;
        this.game = ga;
        this.playerNumber = pn;
        this.gameState = gs > 0 ? gs : 0;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    public int getGameState() {
        return this.gameState;
    }

    @Override
    public String toCmd() {
        return "1026|" + this.game + "," + this.playerNumber + (this.gameState > 0 ? "," + this.gameState : "");
    }

    public static SOCTurn parseDataStr(String s) {
        try {
            int gs = 0;
            StringTokenizer st = new StringTokenizer(s, ",");
            String ga = st.nextToken();
            int pn = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                gs = Integer.parseInt(st.nextToken());
            }
            return new SOCTurn(ga, pn, gs);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String toString() {
        return "SOCTurn:game=" + this.game + "|playerNumber=" + this.playerNumber + (this.gameState != 0 ? "|gameState=" + this.gameState : "");
    }
}

