/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCKeyedMessage;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCUndoNotAllowedReasonText
extends SOCMessage
implements SOCKeyedMessage,
SOCMessageForGame {
    private static final long serialVersionUID = 2700L;
    public final String game;
    public final boolean isNotAllowed;
    public final String reason;
    public final boolean isLocalized;

    public SOCUndoNotAllowedReasonText(String ga, boolean isNotAllowed, String reason) throws IllegalArgumentException {
        this(ga, isNotAllowed, reason, false);
    }

    public SOCUndoNotAllowedReasonText(String ga, boolean isNotAllowed, String reason, boolean isLocal) throws IllegalArgumentException {
        if (reason != null && (reason.isEmpty() || !SOCUndoNotAllowedReasonText.isSingleLineAndSafe(reason, true))) {
            throw new IllegalArgumentException("reason");
        }
        this.messageType = 1107;
        this.game = ga;
        this.isNotAllowed = isNotAllowed;
        this.reason = reason;
        this.isLocalized = isLocal;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    @Override
    public String toCmd() {
        return Integer.toString(this.messageType) + "|" + this.game + "," + (this.isNotAllowed ? 1 : 0) + (this.reason != null ? "," + this.reason : "");
    }

    @Override
    public String getKey() {
        return this.reason;
    }

    @Override
    public SOCMessage localize(String localizedText) {
        return new SOCUndoNotAllowedReasonText(this.game, this.isNotAllowed, localizedText, true);
    }

    public static SOCUndoNotAllowedReasonText parseDataStr(String s) {
        String reason;
        boolean isNotAllowed;
        String ga;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            ga = st.nextToken();
            int isNotAllowedInt = Integer.parseInt(st.nextToken());
            if (isNotAllowedInt < 0 || isNotAllowedInt > 1) {
                return null;
            }
            boolean bl = isNotAllowed = isNotAllowedInt == 1;
            if (st.hasMoreTokens()) {
                reason = st.nextToken(Character.toString('\u0001')).trim();
                if (reason.startsWith(",")) {
                    reason = reason.substring(1);
                }
            } else {
                reason = null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCUndoNotAllowedReasonText(ga, isNotAllowed, reason, true);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ":game=" + this.game + "|isNotAllowed=" + (this.isNotAllowed ? 1 : 0) + (this.reason != null ? "|reason=" + this.reason : "");
    }
}

