/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;

public class SOCUndoPutPiece
extends SOCMessage
implements SOCMessageForGame {
    private static final long serialVersionUID = 2700L;
    private final String game;
    private final int pieceType;
    private final int playerNumber;
    private final int coordinates;
    private final int movedFromCoordinates;

    public SOCUndoPutPiece(String gn, int pn, int pt, int co) throws IllegalArgumentException {
        this(gn, pn, pt, co, 0);
    }

    public SOCUndoPutPiece(String gn, int pn, int pt, int co, int fromCo) throws IllegalArgumentException {
        if (pt < 0) {
            throw new IllegalArgumentException("pt: " + pt);
        }
        if (co <= 0) {
            throw new IllegalArgumentException("coord <= 0: " + co);
        }
        if (fromCo < 0) {
            throw new IllegalArgumentException("fromCo < 0: " + fromCo);
        }
        this.messageType = 1105;
        this.game = gn;
        this.pieceType = pt;
        this.playerNumber = pn;
        this.coordinates = co;
        this.movedFromCoordinates = fromCo;
    }

    @Override
    public String getGame() {
        return this.game;
    }

    public int getPieceType() {
        return this.pieceType;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }

    public int getCoordinates() {
        return this.coordinates;
    }

    public int getMovedFromCoordinates() {
        return this.movedFromCoordinates;
    }

    @Override
    public String toCmd() {
        StringBuilder ret = new StringBuilder("1105|" + this.game + "," + this.playerNumber + "," + this.pieceType + "," + this.coordinates);
        if (this.movedFromCoordinates != 0) {
            ret.append(",").append(this.movedFromCoordinates);
        }
        return ret.toString();
    }

    public static SOCUndoPutPiece parseDataStr(String s) {
        int fromCo = 0;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            String gn = st.nextToken();
            int pn = Integer.parseInt(st.nextToken());
            int pt = Integer.parseInt(st.nextToken());
            int co = Integer.parseInt(st.nextToken());
            if (st.hasMoreTokens()) {
                fromCo = Integer.parseInt(st.nextToken());
            }
            return new SOCUndoPutPiece(gn, pn, pt, co, fromCo);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public int getMinimumVersion() {
        return 2700;
    }

    public static String stripAttribNames(String messageStrParams) {
        String s = SOCMessage.stripAttribNames(messageStrParams);
        if (s == null) {
            return null;
        }
        String[] pieces = s.split(",");
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            ret.append(pieces[i]).append(',');
        }
        ret.append(Integer.parseInt(pieces[3], 16));
        if (pieces.length > 4) {
            ret.append(',').append(Integer.parseInt(pieces[4], 16));
        }
        return ret.toString();
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder("SOCUndoPutPiece:game=" + this.game + "|playerNumber=" + this.playerNumber + "|pieceType=" + this.pieceType + "|coord=" + Integer.toHexString(this.coordinates));
        if (this.movedFromCoordinates != 0) {
            ret.append("|movedFromCoord=").append(Integer.toHexString(this.movedFromCoordinates));
        }
        return ret.toString();
    }
}

