/*
 * Decompiled with CFR 0.152.
 */
package soc.message;

import java.util.List;
import java.util.StringTokenizer;
import soc.message.SOCMessage;
import soc.message.SOCMessageFromUnauthClient;

public class SOCVersion
extends SOCMessage
implements SOCMessageFromUnauthClient {
    private static final long serialVersionUID = 2000L;
    private String versStr;
    private int versNum;
    private String versBuild;
    public final String feats;
    public final String cliLocale;

    public SOCVersion(int verNum, String verStr, String verBuild, String feats, String cliLocale) throws IllegalArgumentException {
        if (verBuild == null && feats != null) {
            throw new IllegalArgumentException("null verBuild, non-null feats");
        }
        this.messageType = 9998;
        this.versNum = verNum;
        this.versStr = verStr;
        this.versBuild = verBuild;
        this.feats = feats;
        this.cliLocale = cliLocale;
    }

    public int getVersionNumber() {
        return this.versNum;
    }

    public String getVersionString() {
        return this.versStr;
    }

    public String getBuild() {
        return this.versBuild;
    }

    @Override
    public String toCmd() {
        return SOCVersion.toCmd(this.versNum, this.versStr, this.versBuild, this.feats, this.cliLocale);
    }

    public static String toCmd(int verNum, String verStr, String verBuild, String feats, String cliLocale) throws IllegalArgumentException {
        if (verBuild == null && feats != null) {
            throw new IllegalArgumentException("null verBuild, non-null feats");
        }
        return "9998|" + verNum + "," + verStr + "," + (verBuild != null ? verBuild : "\t") + "," + (feats != null ? feats : "\t") + (cliLocale != null ? "," + cliLocale : "");
    }

    public static SOCVersion parseDataStr(String s) {
        String bs;
        String vs;
        int vn;
        String fs = null;
        String clo = null;
        StringTokenizer st = new StringTokenizer(s, ",");
        try {
            vn = Integer.parseInt(st.nextToken());
            vs = st.nextToken();
            if (st.hasMoreTokens()) {
                bs = st.nextToken();
                if (bs.length() == 0 || "\t".equals(bs)) {
                    bs = null;
                }
                if (st.hasMoreTokens()) {
                    fs = st.nextToken();
                    if (fs.length() == 0 || "\t".equals(fs)) {
                        fs = null;
                    }
                    if (st.hasMoreTokens() && ((clo = st.nextToken()).length() == 0 || "\t".equals(clo))) {
                        clo = null;
                    }
                }
            } else {
                bs = null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return new SOCVersion(vn, vs, bs, fs, clo);
    }

    public static String stripAttribNames(String messageStrParams) {
        List<String> pieces = SOCMessage.stripAttribsToList(messageStrParams);
        if (pieces == null || pieces.size() < 5) {
            return null;
        }
        if (pieces.get(2).equals("(null)")) {
            pieces.set(2, "\t");
        }
        if (pieces.get(3).equals("(null)")) {
            pieces.set(3, "\t");
        }
        if (pieces.get(4).equals("(null)")) {
            pieces.set(4, "");
        }
        StringBuilder ret = new StringBuilder();
        boolean hadAny = false;
        for (String piece : pieces) {
            if (hadAny) {
                ret.append(',');
            } else {
                hadAny = true;
            }
            ret.append(piece);
        }
        return ret.toString();
    }

    @Override
    public String toString() {
        return "SOCVersion:" + this.versNum + "|str=" + this.versStr + "|verBuild=" + (this.versBuild != null ? this.versBuild : "(null)") + "|feats=" + (this.feats != null ? this.feats : "(null)") + "|cliLocale=" + (this.cliLocale != null ? this.cliLocale : "(null)");
    }

    @Override
    public int getMinimumVersion() {
        return 1100;
    }
}

