/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import java.util.Random;
import soc.game.SOCGame;
import soc.game.SOCPlayer;
import soc.game.SOCResourceSet;
import soc.robot.SOCBuildPlanStack;
import soc.robot.SOCPossiblePiece;
import soc.robot.SOCRobotBrain;

public class DiscardStrategy {
    protected final SOCGame game;
    protected final SOCPlayer ourPlayerData;
    protected final SOCRobotBrain brain;
    protected final Random rand;

    public DiscardStrategy(SOCGame ga, SOCPlayer pl, SOCRobotBrain br, Random rand) {
        if (pl == null || br == null) {
            throw new IllegalArgumentException();
        }
        this.game = ga;
        this.ourPlayerData = pl;
        this.brain = br;
        this.rand = rand;
    }

    public SOCResourceSet discard(int numDiscards, SOCBuildPlanStack buildingPlan) {
        SOCResourceSet discards = new SOCResourceSet();
        if (buildingPlan.isEmpty()) {
            this.brain.decisionMaker.planStuff(this.brain.getRobotParameters().getStrategyType());
            buildingPlan = this.brain.getBuildingPlan();
        }
        if (!buildingPlan.isEmpty()) {
            SOCPossiblePiece targetPiece = buildingPlan.getFirstPiece();
            this.brain.negotiator.setTargetPiece(this.ourPlayerData.getPlayerNumber(), buildingPlan);
            SOCResourceSet targetResources = targetPiece.getResourcesToBuild();
            SOCResourceSet leftOvers = this.ourPlayerData.getResources().copy();
            if (targetResources != null) {
                for (int rsrc = 1; rsrc <= 5; ++rsrc) {
                    if (leftOvers.getAmount(rsrc) > targetResources.getAmount(rsrc)) {
                        leftOvers.subtract(targetResources.getAmount(rsrc), rsrc);
                        continue;
                    }
                    leftOvers.setAmount(0, rsrc);
                }
            }
            SOCResourceSet neededRsrcs = this.ourPlayerData.getResources().copy();
            neededRsrcs.subtract(leftOvers);
            int[] resourceOrder = this.brain.getEstimatorFactory().getRollsForResourcesSorted(this.ourPlayerData);
            int curRsrc = 0;
            while (discards.getTotal() < numDiscards) {
                while (discards.getTotal() < numDiscards && curRsrc < 5) {
                    if (leftOvers.contains(resourceOrder[curRsrc])) {
                        discards.add(1, resourceOrder[curRsrc]);
                        leftOvers.subtract(1, resourceOrder[curRsrc]);
                        continue;
                    }
                    ++curRsrc;
                }
                curRsrc = 0;
                while (discards.getTotal() < numDiscards && curRsrc < 5) {
                    if (neededRsrcs.contains(resourceOrder[curRsrc])) {
                        discards.add(1, resourceOrder[curRsrc]);
                        neededRsrcs.subtract(1, resourceOrder[curRsrc]);
                        continue;
                    }
                    ++curRsrc;
                }
            }
            if (curRsrc == 5) {
                System.err.println("discardStrategy: PROBLEM IN DISCARD - curRsrc == 5");
            }
        } else {
            SOCGame.discardOrGainPickRandom(this.ourPlayerData.getResources(), numDiscards, true, discards, this.rand);
        }
        return discards;
    }
}

