/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import soc.game.SOCGame;
import soc.game.SOCPlayer;
import soc.robot.SOCRobotBrain;

public class MonopolyStrategy {
    protected final SOCGame game;
    protected final SOCPlayer ourPlayerData;
    protected int monopolyChoice;

    public MonopolyStrategy(SOCGame ga, SOCPlayer pl, SOCRobotBrain br) throws IllegalArgumentException {
        if (pl == null) {
            throw new IllegalArgumentException();
        }
        this.game = ga;
        this.ourPlayerData = pl;
        this.monopolyChoice = 3;
    }

    public int getMonopolyChoice() {
        return this.monopolyChoice;
    }

    public void setMonopolyChoice(int rtype) {
        this.monopolyChoice = rtype;
    }

    public boolean decidePlayMonopoly() {
        int bestResourceCount = 0;
        int bestResourceType = 0;
        int ourPN = this.ourPlayerData.getPlayerNumber();
        boolean threeForOne = this.ourPlayerData.getPortFlag(0);
        for (int resource = 1; resource <= 5; ++resource) {
            int freeResourceCount = 0;
            boolean twoForOne = this.ourPlayerData.getPortFlag(resource);
            int resourceTotal = 0;
            for (int pn = 0; pn < this.game.maxPlayers; ++pn) {
                if (pn == ourPN) continue;
                resourceTotal += this.game.getPlayer(pn).getResources().getAmount(resource);
            }
            freeResourceCount = twoForOne ? resourceTotal / 2 : (threeForOne ? resourceTotal / 3 : resourceTotal / 4);
            if (freeResourceCount <= bestResourceCount) continue;
            bestResourceCount = freeResourceCount;
            bestResourceType = resource;
        }
        if (bestResourceCount > 2) {
            this.monopolyChoice = bestResourceType;
            return true;
        }
        return false;
    }
}

