/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import soc.disableDebug.D;
import soc.game.SOCBoard;
import soc.game.SOCCity;
import soc.game.SOCDevCard;
import soc.game.SOCGame;
import soc.game.SOCPlayer;
import soc.game.SOCPlayerNumbers;
import soc.game.SOCPlayingPiece;
import soc.game.SOCResourceSet;
import soc.game.SOCRoad;
import soc.game.SOCRoutePiece;
import soc.game.SOCSettlement;
import soc.robot.BoardNodeScorePair;
import soc.robot.SOCBuildingSpeedEstimate;
import soc.robot.SOCBuildingSpeedEstimateFactory;
import soc.robot.SOCNumberProbabilities;
import soc.robot.SOCRobotBrain;
import soc.util.CutoffExceededException;

public class OpeningBuildStrategy {
    protected final SOCGame game;
    protected final SOCPlayer ourPlayerData;
    protected final SOCBuildingSpeedEstimateFactory bseFactory;
    protected transient D log = new D();
    protected int firstSettlement;
    protected int secondSettlement;
    protected int plannedRoadDestinationNode;
    protected int[] resourceEstimates;

    public OpeningBuildStrategy(SOCGame ga, SOCPlayer pl, SOCRobotBrain br) throws IllegalArgumentException {
        if (pl == null) {
            throw new IllegalArgumentException();
        }
        this.game = ga;
        this.ourPlayerData = pl;
        this.bseFactory = br != null ? br.getEstimatorFactory() : new SOCBuildingSpeedEstimateFactory(null);
    }

    public void cancelWrongPiecePlacement(SOCPlayingPiece cancelPiece) {
        if (cancelPiece instanceof SOCRoutePiece && this.plannedRoadDestinationNode > 0) {
            this.ourPlayerData.clearPotentialSettlement(this.plannedRoadDestinationNode);
        }
    }

    public int planInitialSettlements() {
        int portType2;
        this.log.debug("--- planInitialSettlements");
        this.firstSettlement = 0;
        this.secondSettlement = 0;
        int bestSpeed = 160;
        SOCBoard board = this.game.getBoard();
        SOCPlayerNumbers playerNumbers = new SOCPlayerNumbers(board);
        boolean[] ports = new boolean[6];
        SOCBuildingSpeedEstimate estimate = this.bseFactory.getEstimator();
        int[] prob = SOCNumberProbabilities.INT_VALUES;
        int bestProbTotal = 0;
        int[] ourPotentialSettlements = this.ourPlayerData.getPotentialSettlements_arr();
        if (ourPotentialSettlements == null) {
            return 0;
        }
        for (int i = 0; i < ourPotentialSettlements.length; ++i) {
            int firstNode = ourPotentialSettlements[i];
            Integer firstNodeInt = firstNode;
            this.log.debug("FIRST NODE -----------");
            this.log.debug("firstNode = " + board.nodeCoordToString(firstNode));
            StringBuffer sb = new StringBuffer();
            sb.append("numbers:[");
            playerNumbers.clear();
            int probTotal = playerNumbers.updateNumbersAndProbability(firstNode, board, prob, sb);
            sb.append("]");
            this.log.debug(sb.toString());
            sb = new StringBuffer();
            sb.append("ports: ");
            for (portType2 = 0; portType2 <= 5; ++portType2) {
                ports[portType2] = board.getPortCoordinates(portType2).contains(firstNodeInt);
                sb.append(ports[portType2] + "  ");
            }
            this.log.debug(sb.toString());
            this.log.debug("probTotal = " + probTotal);
            estimate.recalculateEstimates(playerNumbers);
            int speed = 0;
            boolean allTheWay = false;
            try {
                speed += estimate.calculateRollsAndRsrcFast(SOCResourceSet.EMPTY_SET, SOCSettlement.COST, 300, ports).getRolls();
                speed += estimate.calculateRollsAndRsrcFast(SOCResourceSet.EMPTY_SET, SOCCity.COST, 300, ports).getRolls();
                speed += estimate.calculateRollsAndRsrcFast(SOCResourceSet.EMPTY_SET, SOCDevCard.COST, 300, ports).getRolls();
                speed += estimate.calculateRollsAndRsrcFast(SOCResourceSet.EMPTY_SET, SOCRoad.COST, 300, ports).getRolls();
            }
            catch (CutoffExceededException portType2) {
                // empty catch block
            }
            for (int j = 1 + i; j < ourPotentialSettlements.length; ++j) {
                int secondNode = ourPotentialSettlements[j];
                if (board.isNodeAdjacentToNode(secondNode, firstNode)) continue;
                this.log.debug("firstNode = " + board.nodeCoordToString(firstNode));
                this.log.debug("secondNode = " + board.nodeCoordToString(secondNode));
                sb = new StringBuffer();
                sb.append("numbers:[");
                playerNumbers.clear();
                probTotal = playerNumbers.updateNumbersAndProbability(firstNode, board, prob, sb);
                sb.append("] [");
                probTotal += playerNumbers.updateNumbersAndProbability(secondNode, board, prob, sb);
                sb.append("]");
                this.log.debug(sb.toString());
                Arrays.fill(ports, false);
                int portType3 = board.getPortTypeFromNodeCoord(firstNode);
                if (portType3 != -1) {
                    ports[portType3] = true;
                }
                if ((portType3 = board.getPortTypeFromNodeCoord(secondNode)) != -1) {
                    ports[portType3] = true;
                }
                this.log.debug("probTotal = " + probTotal);
                estimate.recalculateEstimates(playerNumbers);
                speed = 0;
                allTheWay = false;
                try {
                    if ((speed += estimate.calculateRollsAndRsrcFast(SOCResourceSet.EMPTY_SET, SOCSettlement.COST, bestSpeed, ports).getRolls()) < bestSpeed && (speed += estimate.calculateRollsAndRsrcFast(SOCResourceSet.EMPTY_SET, SOCCity.COST, bestSpeed, ports).getRolls()) < bestSpeed && (speed += estimate.calculateRollsAndRsrcFast(SOCResourceSet.EMPTY_SET, SOCDevCard.COST, bestSpeed, ports).getRolls()) < bestSpeed) {
                        speed += estimate.calculateRollsAndRsrcFast(SOCResourceSet.EMPTY_SET, SOCRoad.COST, bestSpeed, ports).getRolls();
                        allTheWay = true;
                    }
                }
                catch (CutoffExceededException e) {
                    speed = bestSpeed;
                }
                if (speed < bestSpeed) {
                    this.firstSettlement = firstNode;
                    this.secondSettlement = secondNode;
                    bestSpeed = speed;
                    bestProbTotal = probTotal;
                    this.log.debug("bestSpeed = " + bestSpeed);
                    this.log.debug("bestProbTotal = " + bestProbTotal);
                    continue;
                }
                if (speed != bestSpeed || !allTheWay || probTotal <= bestProbTotal) continue;
                this.log.debug("Equal speed, better prob");
                this.firstSettlement = firstNode;
                this.secondSettlement = secondNode;
                bestSpeed = speed;
                bestProbTotal = probTotal;
                this.log.debug("firstSettlement = " + Integer.toHexString(this.firstSettlement));
                this.log.debug("secondSettlement = " + Integer.toHexString(this.secondSettlement));
                this.log.debug("bestSpeed = " + bestSpeed);
                this.log.debug("bestProbTotal = " + bestProbTotal);
            }
        }
        playerNumbers.clear();
        playerNumbers.updateNumbers(this.firstSettlement, board);
        Integer firstSettlementInt = this.firstSettlement;
        for (int portType4 = 0; portType4 <= 5; ++portType4) {
            ports[portType4] = board.getPortCoordinates(portType4).contains(firstSettlementInt);
        }
        estimate.recalculateEstimates(playerNumbers);
        int firstSpeed = 0;
        int cutoff = 100;
        firstSpeed += estimate.calculateRollsFast(SOCResourceSet.EMPTY_SET, SOCSettlement.COST, 100, ports);
        firstSpeed += estimate.calculateRollsFast(SOCResourceSet.EMPTY_SET, SOCCity.COST, 100, ports);
        firstSpeed += estimate.calculateRollsFast(SOCResourceSet.EMPTY_SET, SOCDevCard.COST, 100, ports);
        firstSpeed += estimate.calculateRollsFast(SOCResourceSet.EMPTY_SET, SOCRoad.COST, 100, ports);
        playerNumbers.clear();
        playerNumbers.updateNumbers(this.secondSettlement, board);
        Integer secondSettlementInt = this.secondSettlement;
        for (portType2 = 0; portType2 <= 5; ++portType2) {
            ports[portType2] = board.getPortCoordinates(portType2).contains(secondSettlementInt);
        }
        estimate.recalculateEstimates(playerNumbers);
        int secondSpeed = 0;
        secondSpeed += estimate.calculateRollsFast(SOCResourceSet.EMPTY_SET, SOCSettlement.COST, bestSpeed, ports);
        secondSpeed += estimate.calculateRollsFast(SOCResourceSet.EMPTY_SET, SOCCity.COST, bestSpeed, ports);
        secondSpeed += estimate.calculateRollsFast(SOCResourceSet.EMPTY_SET, SOCDevCard.COST, bestSpeed, ports);
        if (firstSpeed > (secondSpeed += estimate.calculateRollsFast(SOCResourceSet.EMPTY_SET, SOCRoad.COST, bestSpeed, ports))) {
            int tmp = this.firstSettlement;
            this.firstSettlement = this.secondSettlement;
            this.secondSettlement = tmp;
        }
        this.log.debug(board.nodeCoordToString(this.firstSettlement) + ":" + firstSpeed + ", " + board.nodeCoordToString(this.secondSettlement) + ":" + secondSpeed);
        return this.firstSettlement;
    }

    public int planSecondSettlement() {
        this.log.debug("--- planSecondSettlement");
        int bestSpeed = 160;
        SOCBoard board = this.game.getBoard();
        SOCPlayerNumbers playerNumbers = new SOCPlayerNumbers(board);
        boolean[] ports = new boolean[6];
        SOCBuildingSpeedEstimate estimate = this.bseFactory.getEstimator();
        int[] prob = SOCNumberProbabilities.INT_VALUES;
        int firstNode = this.firstSettlement;
        int bestProbTotal = 0;
        this.secondSettlement = -1;
        int[] ourPotentialSettlements = this.ourPlayerData.getPotentialSettlements_arr();
        if (ourPotentialSettlements == null) {
            return -1;
        }
        for (int i = 0; i < ourPotentialSettlements.length; ++i) {
            int[] rolls;
            int secondNode = ourPotentialSettlements[i];
            if (board.isNodeAdjacentToNode(secondNode, firstNode)) continue;
            StringBuffer sb = new StringBuffer();
            sb.append("numbers: ");
            playerNumbers.clear();
            int probTotal = playerNumbers.updateNumbersAndProbability(firstNode, board, prob, sb);
            probTotal += playerNumbers.updateNumbersAndProbability(secondNode, board, prob, sb);
            Arrays.fill(ports, false);
            int portType = board.getPortTypeFromNodeCoord(firstNode);
            if (portType != -1) {
                ports[portType] = true;
            }
            if ((portType = board.getPortTypeFromNodeCoord(secondNode)) != -1) {
                ports[portType] = true;
            }
            this.log.debug("probTotal = " + probTotal);
            estimate.recalculateEstimates(playerNumbers);
            int speed = 0;
            try {
                if ((speed += estimate.calculateRollsAndRsrcFast(SOCResourceSet.EMPTY_SET, SOCSettlement.COST, bestSpeed, ports).getRolls()) < bestSpeed && (speed += estimate.calculateRollsAndRsrcFast(SOCResourceSet.EMPTY_SET, SOCCity.COST, bestSpeed, ports).getRolls()) < bestSpeed && (speed += estimate.calculateRollsAndRsrcFast(SOCResourceSet.EMPTY_SET, SOCDevCard.COST, bestSpeed, ports).getRolls()) < bestSpeed) {
                    speed += estimate.calculateRollsAndRsrcFast(SOCResourceSet.EMPTY_SET, SOCRoad.COST, bestSpeed, ports).getRolls();
                }
            }
            catch (CutoffExceededException e) {
                speed = bestSpeed;
            }
            this.log.debug(Integer.toHexString(firstNode) + ", " + Integer.toHexString(secondNode) + ":" + speed);
            if (speed < bestSpeed || this.secondSettlement < 0) {
                this.firstSettlement = firstNode;
                this.secondSettlement = secondNode;
                bestSpeed = speed;
                bestProbTotal = probTotal;
                this.log.debug("firstSettlement = " + Integer.toHexString(this.firstSettlement));
                this.log.debug("secondSettlement = " + Integer.toHexString(this.secondSettlement));
                rolls = estimate.getEstimatesFromNothingFast(ports);
                sb = new StringBuffer();
                sb.append("road: " + rolls[0]);
                sb.append(" stlmt: " + rolls[1]);
                sb.append(" city: " + rolls[2]);
                sb.append(" card: " + rolls[3]);
                this.log.debug(sb.toString());
                this.log.debug("bestSpeed = " + bestSpeed);
                continue;
            }
            if (speed != bestSpeed || probTotal <= bestProbTotal) continue;
            this.firstSettlement = firstNode;
            this.secondSettlement = secondNode;
            bestSpeed = speed;
            bestProbTotal = probTotal;
            this.log.debug("firstSettlement = " + Integer.toHexString(this.firstSettlement));
            this.log.debug("secondSettlement = " + Integer.toHexString(this.secondSettlement));
            rolls = estimate.getEstimatesFromNothingFast(ports);
            sb = new StringBuffer();
            sb.append("road: " + rolls[0]);
            sb.append(" stlmt: " + rolls[1]);
            sb.append(" city: " + rolls[2]);
            sb.append(" card: " + rolls[3]);
            this.log.debug(sb.toString());
            this.log.debug("bestSpeed = " + bestSpeed);
        }
        return this.secondSettlement;
    }

    public int planInitRoad() {
        int settlementNode = this.ourPlayerData.getLastSettlementCoord();
        Hashtable<Integer, Integer> twoAway = new Hashtable<Integer, Integer>();
        this.log.debug("--- placeInitRoad");
        SOCBoard board = this.game.getBoard();
        for (int facing = 1; facing <= 6; ++facing) {
            int tmp = board.getAdjacentNodeToNode2Away(settlementNode, facing);
            if (tmp == -9 || !this.ourPlayerData.canPlaceSettlement(tmp)) continue;
            twoAway.put(tmp, 0);
        }
        this.scoreNodesForSettlements(twoAway, 3, 5, 10);
        this.log.debug("Init Road for " + this.ourPlayerData.getName());
        SOCPlayer dummy = new SOCPlayer(this.ourPlayerData.getPlayerNumber(), this.game);
        if (this.game.getGameState() == 6 || this.game.isGameOptionSet("_SC_3IP") && this.game.getGameState() == 11) {
            int numberOfBuilds = this.numberOfEnemyBuilds();
            this.log.debug("Other players will build " + numberOfBuilds + " settlements before I get to build again.");
            if (numberOfBuilds > 0) {
                Hashtable<Integer, Integer> allNodes = new Hashtable<Integer, Integer>();
                Iterator<Integer> psi = this.ourPlayerData.getPotentialSettlements().iterator();
                while (psi.hasNext()) {
                    allNodes.put(psi.next(), 0);
                }
                this.bestSpotForNumbers(allNodes, null, 100);
                List<Integer> miscPortNodes = board.getPortCoordinates(0);
                this.bestSpot2AwayFromANodeSet(allNodes, miscPortNodes, 5);
                int[] resourceEstis = this.estimateResourceRarity();
                for (int portType = 1; portType <= 5; ++portType) {
                    if (resourceEstis[portType] <= 33) continue;
                    List<Integer> portNodes = board.getPortCoordinates(portType);
                    int portWeight = resourceEstis[portType] * 10 / 56;
                    this.bestSpot2AwayFromANodeSet(allNodes, portNodes, portWeight);
                }
                ArrayList<Integer> psList = new ArrayList<Integer>();
                psList.addAll(this.ourPlayerData.getPotentialSettlements());
                dummy.setPotentialAndLegalSettlements(psList, false, null);
                for (int builds = 0; builds < numberOfBuilds; ++builds) {
                    BoardNodeScorePair bestNodePair = new BoardNodeScorePair(0, 0);
                    Enumeration<Integer> nodesEnum = allNodes.keys();
                    while (nodesEnum.hasMoreElements()) {
                        Integer nodeCoord = nodesEnum.nextElement();
                        int score = allNodes.get(nodeCoord);
                        this.log.debug("NODE = " + Integer.toHexString(nodeCoord) + " SCORE = " + score);
                        if (bestNodePair.getScore() >= score) continue;
                        bestNodePair.setScore(score);
                        bestNodePair.setNode(nodeCoord);
                    }
                    dummy.updatePotentials(new SOCSettlement(this.ourPlayerData, bestNodePair.getNode(), null));
                    allNodes.remove(bestNodePair.getNode());
                }
            }
        }
        BoardNodeScorePair bestNodePair = new BoardNodeScorePair(0, 0);
        Enumeration<Integer> cenum = twoAway.keys();
        while (cenum.hasMoreElements()) {
            Integer coordInt = cenum.nextElement();
            int coord = coordInt;
            int score = twoAway.get(coordInt);
            this.log.debug("Considering " + Integer.toHexString(coord) + " with a score of " + score);
            if (dummy.canPlaceSettlement(coord)) {
                if (bestNodePair.getScore() >= score) continue;
                bestNodePair.setScore(score);
                bestNodePair.setNode(coord);
                continue;
            }
            this.log.debug("Someone is bound to ruin that spot.");
        }
        this.plannedRoadDestinationNode = bestNodePair.getNode();
        int roadEdge = board.getAdjacentEdgeToNode2Away(settlementNode, this.plannedRoadDestinationNode);
        dummy.destroyPlayer();
        return roadEdge;
    }

    protected void scoreNodesForSettlements(Hashtable<Integer, Integer> nodes, int numberWeight, int miscPortWeight, int portWeight) {
        this.bestSpotForNumbers(nodes, this.ourPlayerData, numberWeight);
        if (!this.ourPlayerData.getPortFlag(0)) {
            List<Integer> miscPortNodes = this.game.getBoard().getPortCoordinates(0);
            this.bestSpotInANodeSet(nodes, miscPortNodes, miscPortWeight);
        }
        int[] resourceEstis = this.estimateResourceRarity();
        for (int portType = 1; portType <= 5; ++portType) {
            if (resourceEstis[portType] <= 33 || this.ourPlayerData.getPortFlag(portType)) continue;
            List<Integer> portNodes = this.game.getBoard().getPortCoordinates(portType);
            int estimatedPortWeight = resourceEstis[portType] * portWeight / 56;
            this.bestSpotInANodeSet(nodes, portNodes, estimatedPortWeight);
        }
    }

    protected void bestSpotInANodeSet(Hashtable<Integer, Integer> nodesIn, List<Integer> goodNodes, int weight) {
        Enumeration<Integer> nodesInEnum = nodesIn.keys();
        while (nodesInEnum.hasMoreElements()) {
            Integer nodeCoord = nodesInEnum.nextElement();
            int node = nodeCoord;
            int score = 0;
            int oldScore = nodesIn.get(nodeCoord);
            for (int goodNode : goodNodes) {
                if (node != goodNode) continue;
                score = 100;
                break;
            }
            nodesIn.put(nodeCoord, oldScore + (score *= weight));
        }
    }

    protected void bestSpot2AwayFromANodeSet(Hashtable<Integer, Integer> nodesIn, List<Integer> goodNodes, int weight) {
        SOCBoard board = this.game.getBoard();
        Enumeration<Integer> nodesInEnum = nodesIn.keys();
        while (nodesInEnum.hasMoreElements()) {
            int goodNodeTarget;
            Integer nodeCoord = nodesInEnum.nextElement();
            int node = nodeCoord;
            int score = 0;
            int oldScore = nodesIn.get(nodeCoord);
            Iterator<Integer> iterator = goodNodes.iterator();
            while (iterator.hasNext() && node != (goodNodeTarget = iterator.next().intValue())) {
                if (!board.isNode2AwayFromNode(node, goodNodeTarget)) continue;
                score = 100;
            }
            nodesIn.put(nodeCoord, oldScore + (score *= weight));
        }
    }

    public int[] estimateResourceRarity() {
        block4: {
            int[] numberWeights;
            SOCBoard board;
            block5: {
                if (this.resourceEstimates != null) break block4;
                board = this.game.getBoard();
                numberWeights = SOCNumberProbabilities.INT_VALUES;
                this.resourceEstimates = new int[6];
                this.resourceEstimates[0] = 0;
                int bef = board.getBoardEncodingFormat();
                if (bef != 2 && bef != 1) break block5;
                int L = board.getNumberLayout().length;
                for (int i = 0; i < L; ++i) {
                    int hexNumber = board.getNumberOnHexFromNumber(i);
                    if (hexNumber <= 0) continue;
                    int n = board.getHexTypeFromNumber(i);
                    this.resourceEstimates[n] = this.resourceEstimates[n] + numberWeights[hexNumber];
                }
                break block4;
            }
            int[] hcoord = board.getLandHexCoords();
            if (hcoord == null) break block4;
            int L = hcoord.length;
            for (int i = 0; i < L; ++i) {
                int hexNumber = board.getNumberOnHexFromCoord(hcoord[i]);
                if (hexNumber == 0) continue;
                int htype = board.getHexTypeFromCoord(hcoord[i]);
                if (htype == 7) {
                    int ht = 1;
                    while (ht <= 5) {
                        int n = ht++;
                        this.resourceEstimates[n] = this.resourceEstimates[n] + numberWeights[hexNumber];
                    }
                    continue;
                }
                if (htype < 0 || htype > 5) continue;
                int n = htype;
                this.resourceEstimates[n] = this.resourceEstimates[n] + numberWeights[hexNumber];
            }
        }
        return this.resourceEstimates;
    }

    protected int numberOfEnemyBuilds() {
        int numberOfBuilds = 0;
        int pNum = this.game.getCurrentPlayerNumber();
        if (this.game.getGameState() == 5 || this.game.getGameState() == 6) {
            do {
                if (++pNum >= this.game.maxPlayers) {
                    pNum = 0;
                }
                if (pNum == this.game.getFirstPlayer() || this.game.isSeatVacant(pNum)) continue;
                ++numberOfBuilds;
            } while (pNum != this.game.getFirstPlayer());
        }
        do {
            if (--pNum < 0) {
                pNum = this.game.maxPlayers - 1;
            }
            if (pNum == this.game.getCurrentPlayerNumber() || this.game.isSeatVacant(pNum)) continue;
            ++numberOfBuilds;
        } while (pNum != this.game.getCurrentPlayerNumber());
        return numberOfBuilds;
    }

    protected void bestSpotForNumbers(Hashtable<Integer, Integer> nodes, SOCPlayer player, int weight) {
        int[] numRating = SOCNumberProbabilities.INT_VALUES;
        SOCPlayerNumbers playerNumbers = player != null ? player.getNumbers() : null;
        SOCBoard board = this.game.getBoard();
        int maxScore = player != null ? 80 : 40;
        Enumeration<Integer> nodesEnum = nodes.keys();
        while (nodesEnum.hasMoreElements()) {
            Integer nodeInt = nodesEnum.nextElement();
            int oldScore = nodes.get(nodeInt);
            int score = 0;
            for (int hex : board.getAdjacentHexesToNode(nodeInt)) {
                int number = board.getNumberOnHexFromCoord(hex);
                score += numRating[number];
                if (number == 0 || playerNumbers == null || playerNumbers.hasNumber(number)) continue;
                score += numRating[number];
            }
            int nScore = score * 100 / maxScore * weight;
            Integer finalScore = nScore + oldScore;
            nodes.put(nodeInt, finalScore);
        }
    }
}

