/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import java.util.Random;
import soc.disableDebug.D;
import soc.game.SOCBoard;
import soc.game.SOCGame;
import soc.game.SOCPlayer;
import soc.robot.SOCBuildingSpeedEstimate;
import soc.robot.SOCPlayerTracker;
import soc.robot.SOCRobotBrain;

public class RobberStrategy {
    protected final SOCGame game;
    protected final SOCPlayer ourPlayerData;
    protected final SOCRobotBrain brain;
    protected final Random rand;
    protected static transient D log = new D();

    public RobberStrategy(SOCGame ga, SOCPlayer pl, SOCRobotBrain br, Random rand) {
        if (pl == null || br == null) {
            throw new IllegalArgumentException();
        }
        this.game = ga;
        this.ourPlayerData = pl;
        this.brain = br;
        this.rand = rand;
    }

    public int getBestRobberHex() {
        log.debug("%%% MOVEROBBER");
        int prevRobberHex = this.game.getBoard().getRobberHex();
        int victimNum = this.selectPlayerToThwart(prevRobberHex);
        return this.selectRobberHex(prevRobberHex, victimNum);
    }

    public int chooseRobberVictim(boolean[] isVictim, boolean canChooseNone) {
        SOCPlayerTracker[] playerTrackers = this.brain.playerTrackers;
        int choice = -1;
        for (int i = 0; i < this.game.maxPlayers; ++i) {
            if (this.game.isSeatVacant(i) || !isVictim[i]) continue;
            if (choice == -1) {
                choice = i;
                continue;
            }
            SOCPlayerTracker tracker1 = playerTrackers[i];
            SOCPlayerTracker tracker2 = playerTrackers[choice];
            if (tracker1 == null || tracker2 == null || tracker1.getWinGameETA() >= tracker2.getWinGameETA()) continue;
            choice = i;
        }
        return choice;
    }

    public int selectPlayerToThwart(int robberHex) {
        int[] winGameETAs = new int[this.game.maxPlayers];
        for (int i = this.game.maxPlayers - 1; i >= 0; --i) {
            winGameETAs[i] = 100;
        }
        for (SOCPlayerTracker tracker : this.brain.playerTrackers) {
            if (tracker == null) continue;
            int trackerPN = tracker.getPlayer().getPlayerNumber();
            log.debug("%%%%%%%%% TRACKER FOR PLAYER " + trackerPN);
            try {
                tracker.recalcWinGameETA();
                winGameETAs[trackerPN] = tracker.getWinGameETA();
                log.debug("winGameETA = " + tracker.getWinGameETA());
            }
            catch (NullPointerException e) {
                log.debug("Null Pointer Exception calculating winGameETA");
                winGameETAs[trackerPN] = 500;
            }
        }
        int ourPlayerNumber = this.ourPlayerData.getPlayerNumber();
        int victimNum = -1;
        for (int pnum = 0; pnum < this.game.maxPlayers; ++pnum) {
            if (this.game.isSeatVacant(pnum)) continue;
            if (victimNum < 0 && pnum != ourPlayerNumber) {
                log.debug("Picking a robber victim: pnum=" + pnum);
                victimNum = pnum;
                continue;
            }
            if (pnum == ourPlayerNumber || winGameETAs[pnum] >= winGameETAs[victimNum]) continue;
            log.debug("Picking a better robber victim: pnum=" + pnum);
            victimNum = pnum;
        }
        return victimNum;
    }

    public int selectRobberHex(int prevRobberHex, int victimNum) {
        int[] hexes = this.game.getBoard().getLandHexCoords();
        SOCPlayer victim = this.game.getPlayer(victimNum);
        SOCBuildingSpeedEstimate estimate = this.brain.getEstimator();
        int bestHex = prevRobberHex;
        int worstSpeed = 0;
        boolean skipDeserts = this.game.isGameOptionSet("RD");
        SOCBoard gboard = skipDeserts ? this.game.getBoard() : null;
        for (int i = 0; i < hexes.length; ++i) {
            if (hexes[i] == prevRobberHex || !this.ourPlayerData.getNumbers().hasNoResourcesForHex(hexes[i]) || skipDeserts && gboard.getHexTypeFromCoord(hexes[i]) == 6) continue;
            estimate.recalculateEstimates(victim.getNumbers(), hexes[i]);
            int[] speeds = estimate.getEstimatesFromNothingFast(victim.getPortFlags());
            int totalSpeed = 0;
            for (int j = 0; j < 5; ++j) {
                totalSpeed += speeds[j];
            }
            log.debug("total Speed = " + totalSpeed);
            if (totalSpeed <= worstSpeed) continue;
            bestHex = hexes[i];
            worstSpeed = totalSpeed;
            log.debug("bestHex = " + Integer.toHexString(bestHex));
            log.debug("worstSpeed = " + worstSpeed);
        }
        log.debug("%%% bestHex = " + Integer.toHexString(bestHex));
        if (bestHex == prevRobberHex) {
            for (int numRand = 0; bestHex == prevRobberHex || skipDeserts && gboard.getHexTypeFromCoord(bestHex) == 6 || numRand < 30 && this.ourPlayerData.getNumbers().hasNoResourcesForHex(bestHex); ++numRand) {
                bestHex = hexes[Math.abs(this.rand.nextInt()) % hexes.length];
                log.debug("%%% random pick = " + Integer.toHexString(bestHex));
            }
        }
        return bestHex;
    }
}

