/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Stack;
import soc.game.SOCResourceSet;
import soc.robot.SOCBuildPlan;
import soc.robot.SOCPossiblePiece;

public class SOCBuildPlanStack
extends Stack<SOCPossiblePiece>
implements SOCBuildPlan,
Serializable {
    private static final long serialVersionUID = 2500L;

    @Override
    public SOCPossiblePiece getPlannedPiece(int pieceNum) throws IndexOutOfBoundsException {
        return (SOCPossiblePiece)super.get(this.elementCount - 1 - pieceNum);
    }

    @Override
    public SOCPossiblePiece getFirstPiece() throws IndexOutOfBoundsException {
        return this.getPlannedPiece(0);
    }

    @Override
    public int getPlanDepth() {
        return this.elementCount;
    }

    @Override
    public SOCPossiblePiece advancePlan() throws NoSuchElementException {
        try {
            return (SOCPossiblePiece)this.pop();
        }
        catch (EmptyStackException e) {
            throw new NoSuchElementException(e.getMessage());
        }
    }

    @Override
    public SOCResourceSet getFirstPieceResources() {
        SOCResourceSet rs = this.isEmpty() ? null : this.getPlannedPiece(0).getResourcesToBuild();
        return rs != null ? rs : SOCResourceSet.EMPTY_SET;
    }

    @Override
    public SOCResourceSet getTotalResourcesForBuildPlan() {
        SOCResourceSet rs = new SOCResourceSet();
        Enumeration e = super.elements();
        while (e.hasMoreElements()) {
            SOCPossiblePiece pp = (SOCPossiblePiece)e.nextElement();
            SOCResourceSet ppCost = pp.getResourcesToBuild();
            if (ppCost == null) continue;
            rs.add(ppCost);
        }
        return rs;
    }
}

