/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import soc.disableDebug.D;
import soc.game.ResourceSet;
import soc.game.SOCCity;
import soc.game.SOCDevCard;
import soc.game.SOCPlayer;
import soc.game.SOCPlayerNumbers;
import soc.game.SOCResourceSet;
import soc.game.SOCRoad;
import soc.game.SOCSettlement;
import soc.game.SOCShip;
import soc.robot.SOCBuildingSpeedEstimateFactory;
import soc.robot.SOCNumberProbabilities;
import soc.robot.SOCResSetBuildTimePair;
import soc.util.CutoffExceededException;

public class SOCBuildingSpeedEstimate {
    public static final int ROAD = 0;
    public static final int SETTLEMENT = 1;
    public static final int CITY = 2;
    public static final int CARD = 3;
    public static final int SHIP = 4;
    public static final int MIN = 0;
    public static final int MAXPLUSONE = 5;
    public static final int DEFAULT_ROLL_LIMIT = 40;
    protected static boolean recalc;
    int[] estimatesFromNothing = new int[5];
    int[] estimatesFromNow = new int[5];
    private int[] rollsPerResource = new int[6];
    private SOCResourceSet[] resourcesForRoll;

    public SOCBuildingSpeedEstimate(SOCPlayerNumbers numbers) {
        this.recalculateRollsPerResource(numbers, -1);
        this.resourcesForRoll = new SOCResourceSet[13];
        this.recalculateResourcesForRoll(numbers, -1);
    }

    public SOCBuildingSpeedEstimate() {
        this.resourcesForRoll = new SOCResourceSet[13];
    }

    public static final int[] getRollsForResourcesSorted(SOCPlayer pl, SOCBuildingSpeedEstimateFactory bsef) {
        SOCPlayerNumbers nums = pl.getNumbers();
        SOCBuildingSpeedEstimate estimate = bsef != null ? bsef.getEstimator(nums) : new SOCBuildingSpeedEstimate(nums);
        int[] rollsPerResource = estimate.getRollsPerResource();
        int[] resourceOrder = new int[]{1, 2, 3, 4, 5};
        for (int j = 4; j >= 0; --j) {
            for (int i = 0; i < j; ++i) {
                if (rollsPerResource[resourceOrder[i]] >= rollsPerResource[resourceOrder[i + 1]]) continue;
                int tmp = resourceOrder[i];
                resourceOrder[i] = resourceOrder[i + 1];
                resourceOrder[i + 1] = tmp;
            }
        }
        return resourceOrder;
    }

    public int[] getEstimatesFromNothingAccurate(boolean[] ports) {
        if (recalc) {
            this.estimatesFromNothing[0] = 40;
            this.estimatesFromNothing[1] = 40;
            this.estimatesFromNothing[2] = 40;
            this.estimatesFromNothing[3] = 40;
            this.estimatesFromNothing[4] = 40;
            try {
                this.estimatesFromNothing[0] = this.calculateRollsAccurate(SOCResourceSet.EMPTY_SET, SOCRoad.COST, 40, ports).getRolls();
                this.estimatesFromNothing[1] = this.calculateRollsAccurate(SOCResourceSet.EMPTY_SET, SOCSettlement.COST, 40, ports).getRolls();
                this.estimatesFromNothing[2] = this.calculateRollsAccurate(SOCResourceSet.EMPTY_SET, SOCCity.COST, 40, ports).getRolls();
                this.estimatesFromNothing[3] = this.calculateRollsAccurate(SOCResourceSet.EMPTY_SET, SOCDevCard.COST, 40, ports).getRolls();
                this.estimatesFromNothing[4] = this.calculateRollsAccurate(SOCResourceSet.EMPTY_SET, SOCShip.COST, 40, ports).getRolls();
            }
            catch (CutoffExceededException cutoffExceededException) {
                // empty catch block
            }
        }
        return this.estimatesFromNothing;
    }

    public int[] getEstimatesFromNothingFast(boolean[] ports) {
        if (recalc) {
            this.estimatesFromNothing[0] = 40;
            this.estimatesFromNothing[1] = 40;
            this.estimatesFromNothing[2] = 40;
            this.estimatesFromNothing[3] = 40;
            this.estimatesFromNothing[4] = 40;
            try {
                this.estimatesFromNothing[0] = this.calculateRollsAndRsrcFast(SOCResourceSet.EMPTY_SET, SOCRoad.COST, 40, ports).getRolls();
                this.estimatesFromNothing[1] = this.calculateRollsAndRsrcFast(SOCResourceSet.EMPTY_SET, SOCSettlement.COST, 40, ports).getRolls();
                this.estimatesFromNothing[2] = this.calculateRollsAndRsrcFast(SOCResourceSet.EMPTY_SET, SOCCity.COST, 40, ports).getRolls();
                this.estimatesFromNothing[3] = this.calculateRollsAndRsrcFast(SOCResourceSet.EMPTY_SET, SOCDevCard.COST, 40, ports).getRolls();
                this.estimatesFromNothing[4] = this.calculateRollsAndRsrcFast(SOCResourceSet.EMPTY_SET, SOCShip.COST, 40, ports).getRolls();
            }
            catch (CutoffExceededException cutoffExceededException) {
                // empty catch block
            }
        }
        return this.estimatesFromNothing;
    }

    public int[] getEstimatesFromNothingFast(boolean[] ports, int limit) {
        if (recalc) {
            this.estimatesFromNothing[0] = limit;
            this.estimatesFromNothing[1] = limit;
            this.estimatesFromNothing[2] = limit;
            this.estimatesFromNothing[3] = limit;
            this.estimatesFromNothing[4] = limit;
            try {
                this.estimatesFromNothing[0] = this.calculateRollsAndRsrcFast(SOCResourceSet.EMPTY_SET, SOCRoad.COST, limit, ports).getRolls();
                this.estimatesFromNothing[1] = this.calculateRollsAndRsrcFast(SOCResourceSet.EMPTY_SET, SOCSettlement.COST, limit, ports).getRolls();
                this.estimatesFromNothing[2] = this.calculateRollsAndRsrcFast(SOCResourceSet.EMPTY_SET, SOCCity.COST, limit, ports).getRolls();
                this.estimatesFromNothing[3] = this.calculateRollsAndRsrcFast(SOCResourceSet.EMPTY_SET, SOCDevCard.COST, limit, ports).getRolls();
                this.estimatesFromNothing[4] = this.calculateRollsAndRsrcFast(SOCResourceSet.EMPTY_SET, SOCShip.COST, limit, ports).getRolls();
            }
            catch (CutoffExceededException cutoffExceededException) {
                // empty catch block
            }
        }
        return this.estimatesFromNothing;
    }

    public int[] getEstimatesFromNowAccurate(SOCResourceSet resources, boolean[] ports) {
        this.estimatesFromNow[0] = 40;
        this.estimatesFromNow[1] = 40;
        this.estimatesFromNow[2] = 40;
        this.estimatesFromNow[3] = 40;
        this.estimatesFromNow[4] = 40;
        try {
            this.estimatesFromNow[0] = this.calculateRollsAccurate(resources, SOCRoad.COST, 40, ports).getRolls();
            this.estimatesFromNow[1] = this.calculateRollsAccurate(resources, SOCSettlement.COST, 40, ports).getRolls();
            this.estimatesFromNow[2] = this.calculateRollsAccurate(resources, SOCCity.COST, 40, ports).getRolls();
            this.estimatesFromNow[3] = this.calculateRollsAccurate(resources, SOCDevCard.COST, 40, ports).getRolls();
            this.estimatesFromNow[4] = this.calculateRollsAccurate(resources, SOCShip.COST, 40, ports).getRolls();
        }
        catch (CutoffExceededException cutoffExceededException) {
            // empty catch block
        }
        return this.estimatesFromNow;
    }

    public int[] getEstimatesFromNowFast(SOCResourceSet resources, boolean[] ports) {
        this.estimatesFromNow[0] = 40;
        this.estimatesFromNow[1] = 40;
        this.estimatesFromNow[2] = 40;
        this.estimatesFromNow[3] = 40;
        this.estimatesFromNow[4] = 40;
        try {
            this.estimatesFromNow[0] = this.calculateRollsAndRsrcFast(resources, SOCRoad.COST, 40, ports).getRolls();
            this.estimatesFromNow[1] = this.calculateRollsAndRsrcFast(resources, SOCSettlement.COST, 40, ports).getRolls();
            this.estimatesFromNow[2] = this.calculateRollsAndRsrcFast(resources, SOCCity.COST, 40, ports).getRolls();
            this.estimatesFromNow[3] = this.calculateRollsAndRsrcFast(resources, SOCDevCard.COST, 40, ports).getRolls();
            this.estimatesFromNow[4] = this.calculateRollsAndRsrcFast(resources, SOCShip.COST, 40, ports).getRolls();
        }
        catch (CutoffExceededException cutoffExceededException) {
            // empty catch block
        }
        return this.estimatesFromNow;
    }

    public void recalculateEstimates(SOCPlayerNumbers numbers) {
        this.recalculateRollsPerResource(numbers, -1);
        this.recalculateResourcesForRoll(numbers, -1);
    }

    public void recalculateEstimates(SOCPlayerNumbers numbers, int robberHex) {
        this.recalculateRollsPerResource(numbers, robberHex);
        this.recalculateResourcesForRoll(numbers, robberHex);
    }

    public void recalculateRollsPerResource(SOCPlayerNumbers numbers, int robberHex) {
        recalc = true;
        for (int resource = 1; resource <= 5; ++resource) {
            float totalProbability = 0.0f;
            Enumeration<Integer> numbersEnum = (robberHex != -1 ? numbers.getNumbersForResource(resource, robberHex) : numbers.getNumbersForResource(resource)).elements();
            while (numbersEnum.hasMoreElements()) {
                Integer number = numbersEnum.nextElement();
                totalProbability += SOCNumberProbabilities.FLOAT_VALUES[number];
            }
            this.rollsPerResource[resource] = totalProbability != 0.0f ? Math.round(1.0f / totalProbability) : 55555;
        }
    }

    public void recalculateResourcesForRoll(SOCPlayerNumbers numbers, int robberHex) {
        recalc = true;
        for (int diceResult = 2; diceResult <= 12; ++diceResult) {
            Vector<Integer> resources;
            Vector<Integer> vector = resources = robberHex != -1 ? numbers.getResourcesForNumber(diceResult, robberHex) : numbers.getResourcesForNumber(diceResult);
            if (resources == null) continue;
            SOCResourceSet resourceSet = this.resourcesForRoll[diceResult];
            if (resourceSet == null) {
                this.resourcesForRoll[diceResult] = resourceSet = new SOCResourceSet();
            } else {
                resourceSet.clear();
            }
            Enumeration<Integer> resourcesEnum = resources.elements();
            while (resourcesEnum.hasMoreElements()) {
                Integer resourceInt = resourcesEnum.nextElement();
                resourceSet.add(1, resourceInt);
            }
        }
    }

    public int[] getRollsPerResource() {
        return this.rollsPerResource;
    }

    protected final int calculateRollsFast(ResourceSet startingResources, SOCResourceSet targetResources, int cutoff, boolean[] ports) {
        try {
            SOCResSetBuildTimePair pair = this.calculateRollsAndRsrcFast(startingResources, targetResources, cutoff, ports);
            return pair.getRolls();
        }
        catch (CutoffExceededException e) {
            return cutoff;
        }
    }

    protected SOCResSetBuildTimePair calculateRollsAndRsrcFast(ResourceSet startingResources, SOCResourceSet targetResources, int cutoff, boolean[] ports) throws CutoffExceededException {
        int resource;
        int mostNeededResource;
        int trades;
        int numTrades;
        int tradeRatio;
        int giveResource;
        SOCResourceSet ourResources = new SOCResourceSet(startingResources);
        int rolls = 0;
        if (!ourResources.contains(targetResources)) {
            for (giveResource = 1; giveResource <= 5; ++giveResource) {
                tradeRatio = ports[giveResource] ? 2 : (ports[0] ? 3 : 4);
                numTrades = (ourResources.getAmount(giveResource) - targetResources.getAmount(giveResource)) / tradeRatio;
                for (trades = 0; trades < numTrades; ++trades) {
                    mostNeededResource = -1;
                    for (resource = 1; resource <= 5; ++resource) {
                        if (ourResources.getAmount(resource) >= targetResources.getAmount(resource)) continue;
                        if (mostNeededResource < 0) {
                            mostNeededResource = resource;
                            continue;
                        }
                        if (this.rollsPerResource[resource] <= this.rollsPerResource[mostNeededResource]) continue;
                        mostNeededResource = resource;
                    }
                    if (mostNeededResource != -1 && ourResources.getAmount(giveResource) >= tradeRatio) {
                        ourResources.add(1, mostNeededResource);
                        if (ourResources.getAmount(giveResource) < tradeRatio) {
                            System.err.println("@@@ rsrcs=" + ourResources);
                            System.err.println("@@@ tradeRatio=" + tradeRatio);
                            System.err.println("@@@ giveResource=" + giveResource);
                            System.err.println("@@@ target=" + targetResources);
                        }
                        ourResources.subtract(tradeRatio, giveResource);
                    }
                    if (ourResources.contains(targetResources)) break;
                }
                if (ourResources.contains(targetResources)) break;
            }
        }
        block3: while (!ourResources.contains(targetResources)) {
            if (++rolls > cutoff) {
                throw new CutoffExceededException();
            }
            for (int resource2 = 1; resource2 <= 5; ++resource2) {
                if (this.rollsPerResource[resource2] != 0 && rolls % this.rollsPerResource[resource2] != 0) continue;
                ourResources.add(1, resource2);
            }
            if (ourResources.contains(targetResources)) continue;
            for (giveResource = 1; giveResource <= 5; ++giveResource) {
                tradeRatio = ports[giveResource] ? 2 : (ports[0] ? 3 : 4);
                numTrades = (ourResources.getAmount(giveResource) - targetResources.getAmount(giveResource)) / tradeRatio;
                for (trades = 0; trades < numTrades; ++trades) {
                    mostNeededResource = -1;
                    for (resource = 1; resource <= 5; ++resource) {
                        if (ourResources.getAmount(resource) >= targetResources.getAmount(resource)) continue;
                        if (mostNeededResource < 0) {
                            mostNeededResource = resource;
                            continue;
                        }
                        if (this.rollsPerResource[resource] <= this.rollsPerResource[mostNeededResource]) continue;
                        mostNeededResource = resource;
                    }
                    if (mostNeededResource != -1 && ourResources.getAmount(giveResource) >= tradeRatio) {
                        ourResources.add(1, mostNeededResource);
                        if (ourResources.getAmount(giveResource) < tradeRatio) {
                            System.err.println("@@@ rsrcs=" + ourResources);
                            System.err.println("@@@ tradeRatio=" + tradeRatio);
                            System.err.println("@@@ giveResource=" + giveResource);
                            System.err.println("@@@ target=" + targetResources);
                        }
                        ourResources.subtract(tradeRatio, giveResource);
                    }
                    if (ourResources.contains(targetResources)) break;
                }
                if (ourResources.contains(targetResources)) continue block3;
            }
        }
        return new SOCResSetBuildTimePair(ourResources, rolls);
    }

    protected SOCResSetBuildTimePair calculateRollsAccurate(SOCResourceSet startingResources, SOCResourceSet targetResources, int cutoff, boolean[] ports) throws CutoffExceededException {
        D.ebugPrintlnINFO("calculateRollsAccurate");
        D.ebugPrintlnINFO("  start: " + startingResources);
        D.ebugPrintlnINFO("  target: " + targetResources);
        SOCResourceSet ourResources = startingResources.copy();
        int rolls = 0;
        Hashtable[] resourcesOnRoll = new Hashtable[]{new Hashtable(), new Hashtable()};
        int lastRoll = 0;
        int thisRoll = 1;
        resourcesOnRoll[lastRoll].put(ourResources, Float.valueOf(1.0f));
        boolean targetReached = ourResources.contains(targetResources);
        SOCResourceSet targetReachedResources = null;
        float targetReachedProb = 0.0f;
        while (!targetReached) {
            if (++rolls > cutoff) {
                D.ebugPrintlnINFO("startingResources=" + startingResources + "\ntargetResources=" + targetResources + "\ncutoff=" + cutoff + "\nourResources=" + ourResources);
                throw new CutoffExceededException();
            }
            for (int diceResult = 2; diceResult <= 12; ++diceResult) {
                SOCResourceSet gainedResources = this.resourcesForRoll[diceResult];
                float diceProb = SOCNumberProbabilities.FLOAT_VALUES[diceResult];
                Enumeration lastResourcesEnum = resourcesOnRoll[lastRoll].keys();
                while (lastResourcesEnum.hasMoreElements()) {
                    SOCResourceSet lastResources = (SOCResourceSet)lastResourcesEnum.nextElement();
                    Float lastProb = (Float)resourcesOnRoll[lastRoll].get(lastResources);
                    SOCResourceSet newResources = lastResources.copy();
                    newResources.add(gainedResources);
                    float newProb = lastProb.floatValue() * diceProb;
                    if (!newResources.contains(targetResources)) {
                        for (int giveResource = 1; giveResource <= 5; ++giveResource) {
                            if (newResources.getAmount(giveResource) - targetResources.getAmount(giveResource) <= 1) continue;
                            int tradeRatio = ports[giveResource] ? 2 : (ports[0] ? 3 : 4);
                            int numTrades = (newResources.getAmount(giveResource) - targetResources.getAmount(giveResource)) / tradeRatio;
                            for (int trades = 0; trades < numTrades; ++trades) {
                                int mostNeededResource = -1;
                                for (int resource = 1; resource <= 5; ++resource) {
                                    if (newResources.getAmount(resource) >= targetResources.getAmount(resource)) continue;
                                    if (mostNeededResource < 0) {
                                        mostNeededResource = resource;
                                        continue;
                                    }
                                    if (this.rollsPerResource[resource] <= this.rollsPerResource[mostNeededResource]) continue;
                                    mostNeededResource = resource;
                                }
                                if (mostNeededResource != -1 && newResources.getAmount(giveResource) >= tradeRatio) {
                                    newResources.add(1, mostNeededResource);
                                    if (newResources.getAmount(giveResource) < tradeRatio) {
                                        System.err.println("@@@ rsrcs=" + newResources);
                                        System.err.println("@@@ tradeRatio=" + tradeRatio);
                                        System.err.println("@@@ giveResource=" + giveResource);
                                        System.err.println("@@@ target=" + targetResources);
                                    }
                                    newResources.subtract(tradeRatio, giveResource);
                                }
                                if (newResources.contains(targetResources)) break;
                            }
                            if (newResources.contains(targetResources)) break;
                        }
                    }
                    Float probFloat = (Float)resourcesOnRoll[thisRoll].get(newResources);
                    float newProb2 = newProb;
                    if (probFloat != null) {
                        newProb2 = probFloat.floatValue() + newProb;
                    }
                    if (newResources.contains(targetResources)) {
                        D.ebugPrintlnINFO("-----> TARGET HIT *");
                        D.ebugPrintlnINFO("newResources: " + newResources);
                        D.ebugPrintlnINFO("newProb: " + newProb);
                        targetReachedProb += newProb;
                        if (targetReachedResources == null) {
                            targetReachedResources = newResources;
                        }
                        if (!((double)targetReachedProb >= 0.5)) continue;
                        targetReached = true;
                        continue;
                    }
                    resourcesOnRoll[thisRoll].put(newResources, Float.valueOf(newProb2));
                }
            }
            int tmp = lastRoll;
            lastRoll = thisRoll;
            thisRoll = tmp;
            resourcesOnRoll[thisRoll].clear();
        }
        return new SOCResSetBuildTimePair(targetReachedResources, rolls);
    }
}

