/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;
import soc.disableDebug.D;
import soc.game.SOCBoard;
import soc.game.SOCBoardLarge;
import soc.game.SOCCity;
import soc.game.SOCFortress;
import soc.game.SOCGame;
import soc.game.SOCLRPathData;
import soc.game.SOCPlayer;
import soc.game.SOCPlayerNumbers;
import soc.game.SOCPlayingPiece;
import soc.game.SOCRoad;
import soc.game.SOCRoutePiece;
import soc.game.SOCSettlement;
import soc.game.SOCShip;
import soc.robot.SOCBuildingSpeedEstimate;
import soc.robot.SOCBuildingSpeedEstimateFactory;
import soc.robot.SOCPossibleCity;
import soc.robot.SOCPossiblePiece;
import soc.robot.SOCPossibleRoad;
import soc.robot.SOCPossibleSettlement;
import soc.robot.SOCPossibleShip;
import soc.robot.SOCRobotBrain;
import soc.robot.SOCRobotDM;
import soc.util.Pair;
import soc.util.Queue;

public class SOCPlayerTracker {
    protected static int EXPAND_LEVEL = 1;
    protected static int EXPAND_LEVEL_SHIP_EXTRA = 2;
    protected static int LR_CALC_LEVEL = 2;
    protected final SOCRobotBrain brain;
    private final SOCGame game;
    private final SOCPlayer player;
    private final int playerNumber;
    protected TreeMap<Integer, SOCPossibleSettlement> possibleSettlements;
    protected TreeMap<Integer, SOCPossibleRoad> possibleRoads;
    protected TreeMap<Integer, SOCPossibleCity> possibleCities;
    protected int longestRoadETA;
    protected int roadsToGo;
    protected int largestArmyETA;
    protected int winGameETA;
    protected int knightsToBuy;
    protected boolean needLR;
    protected boolean needLA;
    protected SOCSettlement pendingInitSettlement;
    private SOCShip scen_SC_PIRI_closestShipToFortress;
    boolean inUse;

    public SOCPlayerTracker(SOCPlayer pl, SOCRobotBrain br) throws IllegalArgumentException {
        if (pl == null || br == null) {
            throw new IllegalArgumentException("null pl or br");
        }
        this.inUse = false;
        this.brain = br;
        this.player = pl;
        this.playerNumber = pl.getPlayerNumber();
        this.game = pl.getGame();
        this.possibleRoads = new TreeMap();
        this.possibleSettlements = new TreeMap();
        this.possibleCities = new TreeMap();
        this.longestRoadETA = 500;
        this.roadsToGo = 20;
        this.largestArmyETA = 500;
        this.knightsToBuy = 0;
        this.pendingInitSettlement = null;
    }

    public SOCPlayerTracker(SOCPlayerTracker pt) {
        this.inUse = false;
        this.brain = pt.getBrain();
        this.player = pt.getPlayer();
        this.playerNumber = this.player.getPlayerNumber();
        this.game = pt.game;
        this.possibleRoads = new TreeMap();
        this.possibleSettlements = new TreeMap();
        this.possibleCities = new TreeMap();
        this.longestRoadETA = pt.getLongestRoadETA();
        this.roadsToGo = pt.getRoadsToGo();
        this.largestArmyETA = pt.getLargestArmyETA();
        this.knightsToBuy = pt.getKnightsToBuy();
        this.pendingInitSettlement = pt.getPendingInitSettlement();
        this.scen_SC_PIRI_closestShipToFortress = pt.scen_SC_PIRI_closestShipToFortress;
        for (SOCPossibleRoad posRoad : pt.getPossibleRoads().values()) {
            SOCPossibleRoad posRoadCopy = posRoad instanceof SOCPossibleShip ? new SOCPossibleShip((SOCPossibleShip)posRoad) : new SOCPossibleRoad(posRoad);
            this.possibleRoads.put(posRoadCopy.getCoordinates(), posRoadCopy);
        }
        for (SOCPossibleSettlement posSettlement : pt.getPossibleSettlements().values()) {
            SOCPossibleSettlement posSettlementCopy = new SOCPossibleSettlement(posSettlement);
            this.possibleSettlements.put(posSettlementCopy.getCoordinates(), posSettlementCopy);
        }
        for (SOCPossibleCity posCity : pt.getPossibleCities().values()) {
            SOCPossibleCity posCityCopy = new SOCPossibleCity(posCity);
            this.possibleCities.put(posCityCopy.getCoordinates(), posCityCopy);
        }
    }

    public void recalculateAllETAs() {
        this.recalcLargestArmyETA();
        this.recalcLongestRoadETA();
        this.recalcWinGameETA();
    }

    public static SOCPlayerTracker[] copyPlayerTrackers(SOCPlayerTracker[] trackers) {
        SOCPlayerTracker[] trackersCopy = new SOCPlayerTracker[trackers.length];
        for (SOCPlayerTracker pt : trackers) {
            if (pt == null) continue;
            trackersCopy[pt.getPlayer().getPlayerNumber()] = new SOCPlayerTracker(pt);
        }
        for (int tpn = 0; tpn < trackers.length; ++tpn) {
            SOCPossibleRoad necRoadCopy;
            SOCPlayerTracker tracker = trackers[tpn];
            if (tracker == null) continue;
            SOCPlayerTracker trackerCopy = trackersCopy[tracker.getPlayer().getPlayerNumber()];
            TreeMap<Integer, SOCPossibleRoad> possibleRoads = tracker.getPossibleRoads();
            TreeMap<Integer, SOCPossibleRoad> possibleRoadsCopy = trackerCopy.getPossibleRoads();
            TreeMap<Integer, SOCPossibleSettlement> possibleSettlements = tracker.getPossibleSettlements();
            TreeMap<Integer, SOCPossibleSettlement> possibleSettlementsCopy = trackerCopy.getPossibleSettlements();
            for (SOCPossibleRoad posRoad : possibleRoads.values()) {
                SOCPossibleRoad posRoadCopy = possibleRoadsCopy.get(posRoad.getCoordinates());
                for (SOCPossibleRoad necRoad : posRoad.getNecessaryRoads()) {
                    necRoadCopy = possibleRoadsCopy.get(necRoad.getCoordinates());
                    if (necRoadCopy != null) {
                        posRoadCopy.addNecessaryRoad(necRoadCopy);
                        continue;
                    }
                    D.ebugPrintlnINFO("*** ERROR in copyPlayerTrackers : necRoadCopy == null");
                }
                for (SOCPossiblePiece newPos : posRoad.getNewPossibilities()) {
                    switch (newPos.getType()) {
                        case 0: 
                        case 3: {
                            SOCPossibleRoad newPosRoadCopy = possibleRoadsCopy.get(newPos.getCoordinates());
                            if (newPosRoadCopy != null) {
                                posRoadCopy.addNewPossibility(newPosRoadCopy);
                                break;
                            }
                            D.ebugPrintlnINFO("*** ERROR in copyPlayerTrackers : newPosRoadCopy == null");
                            break;
                        }
                        case 1: {
                            SOCPossibleSettlement newPosSettlementCopy = possibleSettlementsCopy.get(newPos.getCoordinates());
                            if (newPosSettlementCopy != null) {
                                posRoadCopy.addNewPossibility(newPosSettlementCopy);
                                break;
                            }
                            D.ebugPrintlnINFO("*** ERROR in copyPlayerTrackers : newPosSettlementCopy == null");
                        }
                    }
                }
            }
            for (SOCPossibleSettlement posSet : possibleSettlements.values()) {
                SOCPossibleSettlement posSetCopy = possibleSettlementsCopy.get(posSet.getCoordinates());
                for (SOCPossibleRoad necRoad : posSet.getNecessaryRoads()) {
                    necRoadCopy = possibleRoadsCopy.get(necRoad.getCoordinates());
                    if (necRoadCopy != null) {
                        posSetCopy.addNecessaryRoad(necRoadCopy);
                        continue;
                    }
                    D.ebugPrintlnINFO("*** ERROR in copyPlayerTrackers : necRoadCopy == null");
                }
                for (SOCPossibleSettlement conflict : posSet.getConflicts()) {
                    SOCPlayerTracker trackerCopy2 = trackersCopy[conflict.getPlayer().getPlayerNumber()];
                    if (trackerCopy2 == null) {
                        D.ebugPrintlnINFO("*** ERROR in copyPlayerTrackers : trackerCopy2 == null");
                        continue;
                    }
                    SOCPossibleSettlement conflictCopy = trackerCopy2.getPossibleSettlements().get(conflict.getCoordinates());
                    if (conflictCopy == null) {
                        D.ebugPrintlnINFO("*** ERROR in copyPlayerTrackers : conflictCopy == null");
                        continue;
                    }
                    posSetCopy.addConflict(conflictCopy);
                }
            }
        }
        return trackersCopy;
    }

    public synchronized void takeMonitor() {
    }

    public synchronized void releaseMonitor() {
    }

    public SOCRobotBrain getBrain() {
        return this.brain;
    }

    public SOCPlayer getPlayer() {
        return this.player;
    }

    public TreeMap<Integer, SOCPossibleRoad> getPossibleRoads() {
        return this.possibleRoads;
    }

    public TreeMap<Integer, SOCPossibleSettlement> getPossibleSettlements() {
        return this.possibleSettlements;
    }

    public TreeMap<Integer, SOCPossibleCity> getPossibleCities() {
        return this.possibleCities;
    }

    public int getLongestRoadETA() {
        return this.longestRoadETA;
    }

    public int getRoadsToGo() {
        return this.roadsToGo;
    }

    public int getLargestArmyETA() {
        return this.largestArmyETA;
    }

    public int getKnightsToBuy() {
        return this.knightsToBuy;
    }

    public SOCSettlement getPendingInitSettlement() {
        return this.pendingInitSettlement;
    }

    public void setPendingInitSettlement(SOCSettlement s) {
        this.pendingInitSettlement = s;
    }

    public void addNewRoadOrShip(SOCRoutePiece road, SOCPlayerTracker[] trackers) {
        if (road.getPlayerNumber() == this.playerNumber) {
            this.addOurNewRoadOrShip(road, trackers, EXPAND_LEVEL);
        } else {
            this.addTheirNewRoadOrShip(road, false);
        }
    }

    public void cancelWrongRoadOrShip(SOCRoutePiece rs) {
        this.addTheirNewRoadOrShip(rs, true);
        for (SOCPossibleRoad pr : this.possibleRoads.values()) {
            if (pr.getCoordinates() != rs.getCoordinates()) continue;
            this.possibleRoads.remove(pr.getCoordinates());
            this.removeFromNecessaryRoads(pr);
            break;
        }
    }

    private void addOurNewRoadOrShip(SOCRoutePiece rs, SOCPlayerTracker[] trackers, int expandLevel) {
        for (SOCPossibleRoad pr : this.possibleRoads.values()) {
            pr.resetExpandedFlag();
            if (pr.getCoordinates() != rs.getCoordinates()) continue;
            this.possibleRoads.remove(pr.getCoordinates());
            this.removeFromNecessaryRoads(pr);
            break;
        }
        SOCBoard board = this.game.getBoard();
        List<Integer> adjNodeEnum = board.getAdjacentNodesToEdge(rs.getCoordinates());
        SOCBuildingSpeedEstimateFactory bsef = this.brain.getEstimatorFactory();
        for (Integer adjNode : adjNodeEnum) {
            if (!this.player.canPlaceSettlement(adjNode)) continue;
            SOCPossibleSettlement posSet = this.possibleSettlements.get(adjNode);
            if (posSet != null) {
                this.removeFromNecessaryRoads(posSet);
                posSet.getNecessaryRoads().clear();
                posSet.setNumberOfNecessaryRoads(0);
                continue;
            }
            SOCPossibleSettlement newPosSet = new SOCPossibleSettlement(this.player, adjNode, null, bsef);
            newPosSet.setNumberOfNecessaryRoads(0);
            this.possibleSettlements.put(adjNode, newPosSet);
            this.updateSettlementConflicts(newPosSet, trackers);
        }
        ArrayList<SOCPossibleRoad> newPossibleRoads = new ArrayList<SOCPossibleRoad>();
        ArrayList<SOCPossibleRoad> roadsToExpand = new ArrayList<SOCPossibleRoad>();
        for (Integer adjEdge : board.getAdjacentEdgesToEdge(rs.getCoordinates())) {
            int roadsBetween;
            int nodeBetween;
            int edge = adjEdge;
            boolean edgeIsPotentialRoute = rs.isRoadNotShip() ? this.player.isPotentialRoad(edge) : this.player.isPotentialShip(edge);
            boolean edgeRequiresCoastalSettlement = false;
            if (!edgeIsPotentialRoute && this.game.hasSeaBoard && this.player.canPlaceSettlement(nodeBetween = ((SOCBoardLarge)board).getNodeBetweenAdjacentEdges(rs.getCoordinates(), edge))) {
                boolean bl = edgeIsPotentialRoute = rs.isRoadNotShip() ? this.player.isPotentialShip(edge) : this.player.isPotentialRoad(edge);
                if (edgeIsPotentialRoute) {
                    edgeRequiresCoastalSettlement = true;
                }
            }
            if (!edgeIsPotentialRoute) continue;
            SOCPossibleRoad pr = this.possibleRoads.get(adjEdge);
            if (pr != null) {
                if (edgeRequiresCoastalSettlement && pr.isRoadNotShip() != rs.isRoadNotShip()) continue;
                if (!pr.getNecessaryRoads().isEmpty()) {
                    this.removeFromNecessaryRoads(pr);
                    pr.getNecessaryRoads().clear();
                    pr.setNumberOfNecessaryRoads(0);
                }
                roadsToExpand.add(pr);
                pr.setExpandedFlag();
                continue;
            }
            boolean isRoad = rs.isRoadNotShip();
            if (edgeRequiresCoastalSettlement) {
                isRoad = !isRoad;
                roadsBetween = 2;
            } else {
                roadsBetween = 0;
            }
            boolean isCoastal = edgeRequiresCoastalSettlement && this.player.isPotentialRoad(edge) && this.player.isPotentialShip(edge);
            SOCPossibleRoad newPR = isRoad && !isCoastal ? new SOCPossibleRoad(this.player, edge, null) : new SOCPossibleShip(this.player, edge, isCoastal, null);
            newPR.setNumberOfNecessaryRoads(roadsBetween);
            newPossibleRoads.add(newPR);
            roadsToExpand.add(newPR);
            newPR.setExpandedFlag();
        }
        for (SOCPossibleRoad newPR : newPossibleRoads) {
            this.possibleRoads.put(newPR.getCoordinates(), newPR);
        }
        SOCPlayer dummy = new SOCPlayer(this.player, "dummy");
        for (SOCPossibleRoad expandPR : roadsToExpand) {
            this.expandRoadOrShip(expandPR, this.player, dummy, trackers, expandLevel);
        }
        dummy.destroyPlayer();
        if (rs instanceof SOCShip && this.game.isGameOptionSet("_SC_PIRI")) {
            this.updateScenario_SC_PIRI_closestShipToFortress((SOCShip)rs, true);
        }
    }

    public void expandRoadOrShip(SOCPossibleRoad targetRoad, SOCPlayer pl, SOCPlayer dummy, SOCPlayerTracker[] trackers, int level) {
        SOCBoard board = this.game.getBoard();
        int tgtRoadEdge = targetRoad.getCoordinates();
        boolean isRoadNotShip = targetRoad.isRoadNotShip();
        SOCRoutePiece dummyRS = isRoadNotShip || targetRoad instanceof SOCPossibleShip && ((SOCPossibleShip)targetRoad).isCoastalRoadAndShip ? new SOCRoad(dummy, tgtRoadEdge, board) : new SOCShip(dummy, tgtRoadEdge, board);
        dummy.putPiece(dummyRS, true);
        SOCBuildingSpeedEstimateFactory bsef = this.brain.getEstimatorFactory();
        for (Integer adjNode : board.getAdjacentNodesToEdge(tgtRoadEdge)) {
            if (!dummy.canPlaceSettlement(adjNode)) continue;
            SOCPossibleSettlement posSet = this.possibleSettlements.get(adjNode);
            if (posSet != null) {
                if (posSet.getNecessaryRoads().isEmpty() || posSet.getNecessaryRoads().contains(targetRoad)) continue;
                posSet.addNecessaryRoad(targetRoad);
                targetRoad.addNewPossibility(posSet);
                if (targetRoad.getNumberOfNecessaryRoads() + 1 >= posSet.getNumberOfNecessaryRoads()) continue;
                posSet.setNumberOfNecessaryRoads(targetRoad.getNumberOfNecessaryRoads() + 1);
                continue;
            }
            ArrayList<SOCPossibleRoad> nr = new ArrayList<SOCPossibleRoad>();
            nr.add(targetRoad);
            SOCPossibleSettlement newPosSet = new SOCPossibleSettlement(pl, adjNode, nr, bsef);
            newPosSet.setNumberOfNecessaryRoads(targetRoad.getNumberOfNecessaryRoads() + 1);
            this.possibleSettlements.put(adjNode, newPosSet);
            targetRoad.addNewPossibility(newPosSet);
            this.updateSettlementConflicts(newPosSet, trackers);
        }
        if (level > 0 && 0 < dummy.getNumPieces(isRoadNotShip ? 0 : 3)) {
            ArrayList<SOCPossibleRoad> newPossibleRoads = new ArrayList<SOCPossibleRoad>();
            ArrayList<SOCPossibleRoad> roadsToExpand = new ArrayList<SOCPossibleRoad>();
            boolean isShipInSC_PIRI = !isRoadNotShip && this.game.isGameOptionSet("_SC_PIRI");
            for (Integer adjEdgeInt : board.getAdjacentEdgesToEdge(tgtRoadEdge)) {
                int nodeBetween;
                int tgtEdgeCol;
                int adjEdgeCol;
                int edge = adjEdgeInt;
                if (isShipInSC_PIRI && ((adjEdgeCol = edge & 0xFF) > (tgtEdgeCol = tgtRoadEdge & 0xFF) || adjEdgeCol == tgtEdgeCol && (tgtRoadEdge & 0x100) != 0)) continue;
                boolean edgeIsPotentialRoute = isRoadNotShip ? dummy.isPotentialRoad(edge) : dummy.isPotentialShip(edge);
                boolean edgeRequiresCoastalSettlement = false;
                if (!edgeIsPotentialRoute && this.game.hasSeaBoard && dummy.canPlaceSettlement(nodeBetween = ((SOCBoardLarge)board).getNodeBetweenAdjacentEdges(tgtRoadEdge, edge))) {
                    boolean bl = edgeIsPotentialRoute = isRoadNotShip ? dummy.isPotentialShip(edge) : dummy.isPotentialRoad(edge);
                    if (edgeIsPotentialRoute) {
                        edgeRequiresCoastalSettlement = true;
                    }
                }
                if (!edgeIsPotentialRoute) continue;
                int incrDistance = edgeRequiresCoastalSettlement ? 3 : 1;
                SOCPossibleRoad pr = this.possibleRoads.get(adjEdgeInt);
                if (pr != null) {
                    if (edgeRequiresCoastalSettlement && isRoadNotShip != pr.isRoadNotShip()) continue;
                    List<SOCPossibleRoad> nr = pr.getNecessaryRoads();
                    if (!nr.isEmpty() && !nr.contains(targetRoad)) {
                        nr.add(targetRoad);
                        targetRoad.addNewPossibility(pr);
                        if (targetRoad.getNumberOfNecessaryRoads() + incrDistance < pr.getNumberOfNecessaryRoads()) {
                            pr.setNumberOfNecessaryRoads(targetRoad.getNumberOfNecessaryRoads() + incrDistance);
                        }
                    }
                    if (pr.hasBeenExpanded()) continue;
                    roadsToExpand.add(pr);
                    pr.setExpandedFlag();
                    continue;
                }
                ArrayList<SOCPossibleRoad> neededRoads = new ArrayList<SOCPossibleRoad>();
                neededRoads.add(targetRoad);
                boolean isRoad = isRoadNotShip;
                if (edgeRequiresCoastalSettlement) {
                    isRoad = !isRoad;
                }
                boolean isCoastal = dummy.isPotentialRoad(edge) && dummy.isPotentialShip(edge) && (edgeRequiresCoastalSettlement || targetRoad instanceof SOCPossibleShip && ((SOCPossibleShip)targetRoad).isCoastalRoadAndShip);
                SOCPossibleRoad newPR = isRoad && !isCoastal ? new SOCPossibleRoad(pl, edge, neededRoads) : new SOCPossibleShip(pl, edge, isCoastal, neededRoads);
                newPR.setNumberOfNecessaryRoads(targetRoad.getNumberOfNecessaryRoads() + incrDistance);
                targetRoad.addNewPossibility(newPR);
                newPossibleRoads.add(newPR);
                roadsToExpand.add(newPR);
                newPR.setExpandedFlag();
            }
            for (SOCPossibleRoad newPR : newPossibleRoads) {
                this.possibleRoads.put(newPR.getCoordinates(), newPR);
            }
            for (SOCPossibleRoad expandPR : roadsToExpand) {
                this.expandRoadOrShip(expandPR, pl, dummy, trackers, level - 1);
            }
        }
        dummy.removePiece(dummyRS, null);
    }

    private void addTheirNewRoadOrShip(SOCRoutePiece rs, boolean isCancel) {
        D.ebugPrintlnINFO("$$$ addTheirNewRoadOrShip : " + rs);
        Integer edge = rs.getCoordinates();
        SOCPossibleRoad pr = this.possibleRoads.get(edge);
        if (pr != null) {
            this.possibleRoads.remove(edge);
            this.removeFromNecessaryRoads(pr);
            this.removeDependents(pr);
        }
    }

    public SOCShip getScenario_SC_PIRI_closestShipToFortress() {
        return this.scen_SC_PIRI_closestShipToFortress;
    }

    void updateScenario_SC_PIRI_closestShipToFortress(SOCShip ship, boolean shipAdded) throws IllegalArgumentException {
        int fortR;
        if (shipAdded && ship == null) {
            throw new IllegalArgumentException();
        }
        if (this.scen_SC_PIRI_closestShipToFortress == null && ship != null) {
            if (shipAdded) {
                this.scen_SC_PIRI_closestShipToFortress = ship;
            }
            return;
        }
        if (!shipAdded && ship != null && this.scen_SC_PIRI_closestShipToFortress != null && ship.getCoordinates() != this.scen_SC_PIRI_closestShipToFortress.getCoordinates()) {
            return;
        }
        SOCFortress fort = this.player.getFortress();
        int n = fortR = fort != null ? fort.getCoordinates() >> 8 : -1;
        if (shipAdded) {
            int shipEdge = ship.getCoordinates();
            int prevShipEdge = this.scen_SC_PIRI_closestShipToFortress.getCoordinates();
            int shipR = shipEdge >> 8;
            int shipC = shipEdge & 0xFF;
            int prevR = prevShipEdge >> 8;
            int prevC = prevShipEdge & 0xFF;
            if (shipC < prevC || shipC == prevC && fortR != -1 && Math.abs(shipR - fortR) < Math.abs(prevR - fortR)) {
                this.scen_SC_PIRI_closestShipToFortress = ship;
            }
        } else {
            Enumeration<SOCRoutePiece> roadAndShipEnum = this.player.getRoadsAndShips().elements();
            SOCShip closest = null;
            int closeR = -1;
            int closeC = -1;
            while (roadAndShipEnum.hasMoreElements()) {
                SOCRoutePiece rs = roadAndShipEnum.nextElement();
                if (!(rs instanceof SOCShip)) continue;
                int shipEdge = rs.getCoordinates();
                int shipR = shipEdge >> 8;
                int shipC = shipEdge & 0xFF;
                if (closest != null && shipC >= closeC && (shipC != closeC || fortR == -1 || Math.abs(shipR - fortR) >= Math.abs(closeR - fortR))) continue;
                closest = (SOCShip)rs;
                closeR = shipR;
                closeC = shipC;
            }
            this.scen_SC_PIRI_closestShipToFortress = closest;
        }
    }

    public int getScenario_SC_PIRI_shipDistanceToFortress(SOCShip ship) {
        SOCFortress fort = this.player.getFortress();
        if (fort == null) {
            return 0;
        }
        int fortNode = fort.getCoordinates();
        int shipEdge = ship.getCoordinates();
        int fortR = fortNode >> 8;
        int fortC = fortNode & 0xFF;
        int shipR = shipEdge >> 8;
        int shipC = shipEdge & 0xFF;
        return Math.abs(fortR - shipR) + Math.abs(fortC - shipC);
    }

    SOCPossibleShip recalcScenario_SC_PIRI_nextPotentialShip() {
        SOCShip closest;
        SOCFortress fort = this.player.getFortress();
        if (fort == null) {
            return null;
        }
        int fortR = fort.getCoordinates() >> 8;
        if (this.scen_SC_PIRI_closestShipToFortress == null) {
            this.updateScenario_SC_PIRI_closestShipToFortress(null, false);
        }
        if ((closest = this.scen_SC_PIRI_closestShipToFortress) == null) {
            return null;
        }
        List<Integer> closestAdjacs = ((SOCBoardLarge)this.game.getBoard()).getAdjacentEdgesToEdge(closest.getCoordinates());
        SOCPossibleShip nextShip = null;
        int nextR = -1;
        int nextC = -1;
        for (Integer edge : closestAdjacs) {
            SOCPossibleRoad rs = this.possibleRoads.get(edge);
            if (rs == null || !(rs instanceof SOCPossibleShip)) continue;
            int shipEdge = rs.getCoordinates();
            int shipR = shipEdge >> 8;
            int shipC = shipEdge & 0xFF;
            if (nextShip != null && shipC >= nextC && (shipC != nextC || Math.abs(shipR - fortR) >= Math.abs(nextR - fortR))) continue;
            nextShip = (SOCPossibleShip)rs;
            nextR = shipR;
            nextC = shipC;
        }
        return nextShip;
    }

    protected void updateSettlementConflicts(SOCPossibleSettlement ps, SOCPlayerTracker[] trackers) {
        SOCBoard board = this.game.getBoard();
        for (SOCPlayerTracker tracker : trackers) {
            SOCPossibleSettlement posSet;
            if (tracker == null) continue;
            if (tracker.getPlayer().getPlayerNumber() != ps.getPlayer().getPlayerNumber() && (posSet = tracker.getPossibleSettlements().get(ps.getCoordinates())) != null) {
                ps.addConflict(posSet);
                posSet.addConflict(ps);
            }
            for (Integer adjNode : board.getAdjacentNodesToNode(ps.getCoordinates())) {
                SOCPossibleSettlement posSet2 = tracker.getPossibleSettlements().get(adjNode);
                if (posSet2 == null) continue;
                ps.addConflict(posSet2);
                posSet2.addConflict(ps);
            }
        }
    }

    public synchronized void addNewSettlement(SOCSettlement settlement, SOCPlayerTracker[] trackers) {
        if (settlement.getPlayerNumber() == this.playerNumber) {
            this.addOurNewSettlement(settlement, trackers);
        } else {
            this.addTheirNewSettlement(settlement, false);
        }
    }

    public void cancelWrongSettlement(SOCSettlement settlement) {
        this.addTheirNewSettlement(settlement, true);
        Integer settlementCoords = settlement.getCoordinates();
        SOCPossibleSettlement ps = this.possibleSettlements.get(settlementCoords);
        D.ebugPrintlnINFO("$$$ removing (wrong) " + Integer.toHexString(settlement.getCoordinates()));
        this.possibleSettlements.remove(settlementCoords);
        this.removeFromNecessaryRoads(ps);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void addOurNewSettlement(SOCSettlement settlement, SOCPlayerTracker[] trackers) {
        D.ebugPrintlnINFO("$$$ addOurNewSettlement : " + settlement);
        SOCBoard board = this.game.getBoard();
        Integer settlementCoords = settlement.getCoordinates();
        this.possibleCities.put(settlementCoords, new SOCPossibleCity(this.player, settlement.getCoordinates(), this.brain.getEstimatorFactory()));
        SOCPossibleSettlement ps = this.possibleSettlements.get(settlementCoords);
        if (ps != null) {
            D.ebugPrintlnINFO("$$$ was a possible settlement");
            ArrayList<SOCPossibleSettlement> conflicts = new ArrayList<SOCPossibleSettlement>(ps.getConflicts());
            D.ebugPrintlnINFO("$$$ removing " + Integer.toHexString(settlement.getCoordinates()));
            this.possibleSettlements.remove(settlementCoords);
            this.removeFromNecessaryRoads(ps);
            for (SOCPossibleSettlement sOCPossibleSettlement : conflicts) {
                D.ebugPrintlnINFO("$$$ checking conflict with " + sOCPossibleSettlement.getPlayer().getPlayerNumber() + ":" + Integer.toHexString(sOCPossibleSettlement.getCoordinates()));
                SOCPlayerTracker tracker = trackers[sOCPossibleSettlement.getPlayer().getPlayerNumber()];
                if (tracker == null) continue;
                D.ebugPrintlnINFO("$$$ removing " + Integer.toHexString(sOCPossibleSettlement.getCoordinates()));
                tracker.getPossibleSettlements().remove(sOCPossibleSettlement.getCoordinates());
                this.removeFromNecessaryRoads(sOCPossibleSettlement);
                for (SOCPossibleSettlement sOCPossibleSettlement2 : sOCPossibleSettlement.getConflicts()) {
                    D.ebugPrintlnINFO("$$$ removing conflict " + Integer.toHexString(sOCPossibleSettlement.getCoordinates()) + " from " + Integer.toHexString(sOCPossibleSettlement2.getCoordinates()));
                    sOCPossibleSettlement2.removeConflict(sOCPossibleSettlement);
                }
            }
        } else {
            D.ebugPrintlnINFO("$$$ wasn't possible settlement");
            ArrayList<SOCPossibleSettlement> trash = new ArrayList<SOCPossibleSettlement>();
            List<Integer> adjNodes = board.getAdjacentNodesToNode(settlement.getCoordinates());
            for (SOCPlayerTracker sOCPlayerTracker : trackers) {
                if (sOCPlayerTracker == null) continue;
                SOCPossibleSettlement posSet = sOCPlayerTracker.getPossibleSettlements().get(settlementCoords);
                D.ebugPrintlnINFO("$$$ tracker for player " + sOCPlayerTracker.getPlayer().getPlayerNumber());
                D.ebugPrintlnINFO("$$$ checking node " + Integer.toHexString(settlement.getCoordinates()));
                if (posSet != null) {
                    D.ebugPrintlnINFO("$$$ trashing " + Integer.toHexString(posSet.getCoordinates()));
                    trash.add(posSet);
                    for (SOCPossibleSettlement conflict : posSet.getConflicts()) {
                        D.ebugPrintlnINFO("$$$ removing conflict " + Integer.toHexString(posSet.getCoordinates()) + " from " + Integer.toHexString(conflict.getCoordinates()));
                        conflict.removeConflict(posSet);
                    }
                }
                for (Integer adjNode : adjNodes) {
                    D.ebugPrintlnINFO("$$$ checking node " + Integer.toHexString(adjNode));
                    posSet = sOCPlayerTracker.getPossibleSettlements().get(adjNode);
                    if (posSet == null) continue;
                    D.ebugPrintlnINFO("$$$ trashing " + Integer.toHexString(posSet.getCoordinates()));
                    trash.add(posSet);
                    for (SOCPossibleSettlement conflict : posSet.getConflicts()) {
                        D.ebugPrintlnINFO("$$$ removing conflict " + Integer.toHexString(posSet.getCoordinates()) + " from " + Integer.toHexString(conflict.getCoordinates()));
                        conflict.removeConflict(posSet);
                    }
                }
                D.ebugPrintlnINFO("$$$ removing trash for " + sOCPlayerTracker.getPlayer().getPlayerNumber());
                for (SOCPossibleSettlement pset : trash) {
                    D.ebugPrintlnINFO("$$$ removing " + Integer.toHexString(pset.getCoordinates()) + " owned by " + pset.getPlayer().getPlayerNumber());
                    sOCPlayerTracker.getPossibleSettlements().remove(pset.getCoordinates());
                    this.removeFromNecessaryRoads(pset);
                }
                trash.clear();
            }
        }
        if (board instanceof SOCBoardLarge) {
            void var8_13;
            ArrayList<SOCPossibleRoad> roadsToExpand = null;
            boolean settleAlreadyHasRoad = false;
            Object var8_12 = null;
            List<Integer> adjacEdges = board.getAdjacentEdgesToNode(settlementCoords);
            for (Integer n : adjacEdges) {
                SOCRoutePiece rs;
                if (this.possibleRoads.get(n) != null || (rs = board.roadOrShipAtEdge(n)) == null || !rs.isRoadNotShip()) continue;
                settleAlreadyHasRoad = true;
                break;
            }
            for (Integer n : adjacEdges) {
                SOCPossibleRoad pRoad = this.possibleRoads.get(n);
                if (pRoad != null || board.roadOrShipAtEdge(n) != null) continue;
                if (this.player.isPotentialRoad(n)) {
                    boolean isCoastline = this.player.isPotentialShip(n);
                    if (settleAlreadyHasRoad && !isCoastline) continue;
                    if (var8_13 == null) {
                        ArrayList arrayList = new ArrayList();
                    }
                    var8_13.add(isCoastline ? new SOCPossibleShip(this.player, n, true, null) : new SOCPossibleRoad(this.player, n, null));
                    continue;
                }
                if (!this.player.isPotentialShip(n)) continue;
                SOCPossibleShip newPS = new SOCPossibleShip(this.player, n, false, null);
                this.possibleRoads.put(n, newPS);
                if (roadsToExpand == null) {
                    roadsToExpand = new ArrayList();
                }
                roadsToExpand.add(newPS);
                newPS.setExpandedFlag();
            }
            if (var8_13 != null && !this.game.isInitialPlacement()) {
                for (SOCPossibleRoad sOCPossibleRoad : var8_13) {
                    this.possibleRoads.put(sOCPossibleRoad.getCoordinates(), sOCPossibleRoad);
                    if (roadsToExpand == null) {
                        roadsToExpand = new ArrayList<SOCPossibleRoad>();
                    }
                    roadsToExpand.add(sOCPossibleRoad);
                    sOCPossibleRoad.setExpandedFlag();
                }
            }
            if (roadsToExpand != null) {
                SOCPlayer dummy = new SOCPlayer(this.player, "dummy");
                for (SOCPossibleRoad expandPR : roadsToExpand) {
                    int expand = EXPAND_LEVEL + (expandPR.isRoadNotShip() ? 0 : EXPAND_LEVEL_SHIP_EXTRA);
                    this.expandRoadOrShip(expandPR, this.player, dummy, trackers, expand);
                }
                dummy.destroyPlayer();
            }
        }
    }

    public void addTheirNewSettlement(SOCSettlement settlement, boolean isCancel) {
        D.ebugPrintlnINFO("$$$ addTheirNewSettlement : " + settlement);
        ArrayList<SOCPossibleRoad> prTrash = new ArrayList<SOCPossibleRoad>();
        ArrayList<SOCPossibleRoad> nrTrash = new ArrayList<SOCPossibleRoad>();
        List<Integer> adjEdges = this.game.getBoard().getAdjacentEdgesToNode(settlement.getCoordinates());
        for (Integer edge1 : adjEdges) {
            prTrash.clear();
            SOCPossibleRoad pr = this.possibleRoads.get(edge1);
            if (pr != null) {
                if (pr.getNecessaryRoads().isEmpty()) {
                    if (!isCancel) {
                        int settleCoord = settlement.getCoordinates();
                        int settlePN = settlement.getPlayerNumber();
                        for (SOCPossiblePiece threat : pr.getThreats()) {
                            if (threat.getType() != 1 || threat.getCoordinates() != settleCoord || threat.getPlayer().getPlayerNumber() != settlePN) continue;
                            D.ebugPrintlnINFO("$$$ new settlement cuts off road at " + Integer.toHexString(pr.getCoordinates()));
                            prTrash.add(pr);
                            break;
                        }
                    }
                } else {
                    nrTrash.clear();
                    block2: for (SOCPossibleRoad nr : pr.getNecessaryRoads()) {
                        int nrEdge = nr.getCoordinates();
                        for (Integer edge2 : adjEdges) {
                            if (nrEdge != edge2) continue;
                            D.ebugPrintlnINFO("$$$ removing dependency " + Integer.toHexString(nrEdge) + " from " + Integer.toHexString(pr.getCoordinates()));
                            nrTrash.add(nr);
                            continue block2;
                        }
                    }
                    if (!nrTrash.isEmpty()) {
                        for (SOCPossibleRoad nrTrashRoad : nrTrash) {
                            pr.getNecessaryRoads().remove(nrTrashRoad);
                            nrTrashRoad.getNewPossibilities().remove(pr);
                        }
                        if (pr.getNecessaryRoads().isEmpty()) {
                            D.ebugPrintlnINFO("$$$ no more dependencies, removing " + Integer.toHexString(pr.getCoordinates()));
                            prTrash.add(pr);
                        }
                    }
                }
            }
            for (SOCPossibleRoad prt : prTrash) {
                this.possibleRoads.remove(prt.getCoordinates());
                this.removeFromNecessaryRoads(prt);
                this.removeDependents(prt);
            }
        }
    }

    protected void removeDependents(SOCPossibleRoad road) {
        block4: for (SOCPossiblePiece newPos : road.getNewPossibilities()) {
            switch (newPos.getType()) {
                case 0: 
                case 3: {
                    List<SOCPossibleRoad> nr = ((SOCPossibleRoad)newPos).getNecessaryRoads();
                    if (nr.isEmpty()) {
                        System.err.println("ERROR in removeDependents - empty nr list for " + newPos);
                        break;
                    }
                    nr.remove(road);
                    if (nr.isEmpty()) {
                        this.possibleRoads.remove(newPos.getCoordinates());
                        this.removeFromNecessaryRoads((SOCPossibleRoad)newPos);
                        this.removeDependents((SOCPossibleRoad)newPos);
                        break;
                    }
                    int smallest = 40;
                    for (SOCPossibleRoad necRoad : nr) {
                        if (necRoad.getNumberOfNecessaryRoads() + 1 >= smallest) continue;
                        smallest = necRoad.getNumberOfNecessaryRoads() + 1;
                    }
                    ((SOCPossibleRoad)newPos).setNumberOfNecessaryRoads(smallest);
                    break;
                }
                case 1: {
                    List<SOCPossibleRoad> nr = ((SOCPossibleSettlement)newPos).getNecessaryRoads();
                    if (nr.isEmpty()) {
                        System.err.println("ERROR in removeDependents - empty nr list for " + newPos);
                        break;
                    }
                    nr.remove(road);
                    if (nr.isEmpty()) {
                        this.possibleSettlements.remove(newPos.getCoordinates());
                        this.removeFromNecessaryRoads((SOCPossibleSettlement)newPos);
                        for (SOCPossibleSettlement conflict : ((SOCPossibleSettlement)newPos).getConflicts()) {
                            conflict.removeConflict((SOCPossibleSettlement)newPos);
                        }
                        continue block4;
                    }
                    int smallest = 40;
                    for (SOCPossibleRoad necRoad : nr) {
                        if (necRoad.getNumberOfNecessaryRoads() + 1 >= smallest) continue;
                        smallest = necRoad.getNumberOfNecessaryRoads() + 1;
                    }
                    ((SOCPossibleSettlement)newPos).setNumberOfNecessaryRoads(smallest);
                }
            }
        }
        road.getNewPossibilities().clear();
    }

    protected void removeFromNecessaryRoads(SOCPossibleRoad pr) {
        for (SOCPossibleRoad nr : pr.getNecessaryRoads()) {
            nr.getNewPossibilities().remove(pr);
        }
    }

    protected void removeFromNecessaryRoads(SOCPossibleSettlement ps) {
        if (ps == null) {
            return;
        }
        for (SOCPossibleRoad nr : ps.getNecessaryRoads()) {
            nr.getNewPossibilities().remove(ps);
        }
    }

    public void cancelWrongCity(SOCCity city) {
        if (city == null) {
            return;
        }
        this.possibleCities.remove(city.getCoordinates());
    }

    public void addOurNewCity(SOCCity city) {
        this.possibleCities.remove(city.getCoordinates());
    }

    public void undoAddOurNewCity(SOCPossibleCity city) {
        this.possibleCities.put(city.getCoordinates(), city);
    }

    public void updateThreats(SOCPlayerTracker[] trackers) {
        SOCBoard board = this.game.getBoard();
        for (SOCPossibleRoad posRoad : this.possibleRoads.values()) {
            if (posRoad.isThreatUpdated() || !posRoad.getNecessaryRoads().isEmpty()) continue;
            int[] nArray = board.getAdjacentNodesToEdge_arr(posRoad.getCoordinates());
            SOCPlayerTracker[] sOCPlayerTrackerArray = board.getAdjacentEdgesToEdge(posRoad.getCoordinates()).iterator();
            while (sOCPlayerTrackerArray.hasNext()) {
                int adjEdge = sOCPlayerTrackerArray.next();
                SOCRoutePiece realRoad = this.player.getRoadOrShip(adjEdge);
                if (realRoad == null) continue;
                int[] nArray2 = realRoad.getAdjacentNodes();
                for (int pi = 0; pi < 2; ++pi) {
                    int adjNodeToPosRoad = nArray[pi];
                    for (int ri = 0; ri < 2; ++ri) {
                        int adjNodeToRealRoad = nArray2[ri];
                        if (adjNodeToPosRoad != adjNodeToRealRoad) continue;
                        Integer adjNodeToPosRoadInt = adjNodeToPosRoad;
                        for (int tpn = 0; tpn < trackers.length; ++tpn) {
                            SOCPossibleSettlement posEnemySet;
                            SOCPlayerTracker tracker;
                            if (tpn == this.playerNumber || (tracker = trackers[tpn]) == null || (posEnemySet = tracker.getPossibleSettlements().get(adjNodeToPosRoadInt)) == null) continue;
                            posRoad.addThreat(posEnemySet);
                        }
                    }
                }
            }
            for (SOCPlayerTracker sOCPlayerTracker : trackers) {
                SOCPossibleRoad posEnemyRoad;
                if (sOCPlayerTracker == null || sOCPlayerTracker.getPlayer().getPlayerNumber() == this.playerNumber || (posEnemyRoad = sOCPlayerTracker.getPossibleRoads().get(posRoad.getCoordinates())) == null) continue;
                posRoad.addThreat(posEnemyRoad);
            }
            List<SOCPossiblePiece> threats = posRoad.getThreats();
            Stack<SOCPossiblePiece> stack = new Stack<SOCPossiblePiece>();
            stack.push(posRoad);
            while (!stack.empty()) {
                SOCPossiblePiece curPosPiece = (SOCPossiblePiece)stack.pop();
                if (curPosPiece.getType() != 0 && (!(curPosPiece instanceof SOCPossibleShip) || !((SOCPossibleShip)curPosPiece).isCoastalRoadAndShip)) continue;
                for (SOCPossiblePiece newPosPiece : ((SOCPossibleRoad)curPosPiece).getNewPossibilities()) {
                    if (newPosPiece.getType() != 0 && (!(newPosPiece instanceof SOCPossibleShip) || !((SOCPossibleShip)newPosPiece).isCoastalRoadAndShip)) continue;
                    List<SOCPossibleRoad> necRoadList = ((SOCPossibleRoad)newPosPiece).getNecessaryRoads();
                    if (necRoadList.size() == 1 && necRoadList.get(0) == curPosPiece) {
                        for (SOCPossiblePiece threat : threats) {
                            ((SOCPossibleRoad)newPosPiece).addThreat(threat);
                        }
                    }
                    stack.push(newPosPiece);
                }
            }
            posRoad.threatUpdated();
        }
        for (SOCPossibleRoad posRoad : this.possibleRoads.values()) {
            if (posRoad.isThreatUpdated()) continue;
            for (SOCPlayerTracker tracker : trackers) {
                SOCPossibleRoad sOCPossibleRoad;
                if (tracker == null || tracker.getPlayer().getPlayerNumber() == this.playerNumber || (sOCPossibleRoad = tracker.getPossibleRoads().get(posRoad.getCoordinates())) == null) continue;
                posRoad.addThreat(sOCPossibleRoad);
                posRoad.threatUpdated();
            }
            List<SOCPossibleRoad> list = posRoad.getNecessaryRoads();
            if (list.size() == 1) {
                SOCPossibleRoad necRoad = list.get(0);
                int[] adjNodes1 = board.getAdjacentNodesToEdge_arr(posRoad.getCoordinates());
                for (int i1 = 0; i1 < 2; ++i1) {
                    int n = adjNodes1[i1];
                    int[] adjNodes2 = board.getAdjacentNodesToEdge_arr(necRoad.getCoordinates());
                    for (int i2 = 0; i2 < 2; ++i2) {
                        int adjNode2 = adjNodes2[i2];
                        if (n != adjNode2) continue;
                        Integer adjNodeInt = n;
                        for (SOCPlayerTracker tracker : trackers) {
                            SOCPossibleSettlement posEnemySet;
                            if (tracker == null || tracker.getPlayer().getPlayerNumber() == this.playerNumber || (posEnemySet = tracker.getPossibleSettlements().get(adjNodeInt)) == null) continue;
                            posRoad.addThreat(posEnemySet);
                        }
                    }
                }
            }
            posRoad.threatUpdated();
        }
        for (SOCPossibleSettlement sOCPossibleSettlement : this.possibleSettlements.values()) {
            if (sOCPossibleSettlement.isThreatUpdated()) continue;
            for (SOCPlayerTracker sOCPlayerTracker : trackers) {
                SOCPossibleSettlement posEnemySet;
                if (sOCPlayerTracker == null || sOCPlayerTracker.getPlayer().getPlayerNumber() == this.playerNumber || (posEnemySet = sOCPlayerTracker.getPossibleSettlements().get(sOCPossibleSettlement.getCoordinates())) == null) continue;
                sOCPossibleSettlement.addThreat(posEnemySet);
            }
            List<SOCPossibleRoad> necRoadList = sOCPossibleSettlement.getNecessaryRoads();
            if (!necRoadList.isEmpty()) {
                if (necRoadList.size() == 1) {
                    for (SOCPossiblePiece nrThreat : necRoadList.get(0).getThreats()) {
                        sOCPossibleSettlement.addThreat(nrThreat);
                    }
                } else {
                    SOCPossibleRoad nr = necRoadList.get(0);
                    for (SOCPossiblePiece sOCPossiblePiece : nr.getThreats()) {
                        boolean allHaveIt = true;
                        for (SOCPossibleRoad nr2 : necRoadList) {
                            if (nr2 == nr || nr2.getThreats().contains(sOCPossiblePiece)) continue;
                            allHaveIt = false;
                            break;
                        }
                        if (!allHaveIt) continue;
                        sOCPossibleSettlement.addThreat(sOCPossiblePiece);
                    }
                }
            }
            sOCPossibleSettlement.threatUpdated();
        }
    }

    public void recalcLongestRoadETA() {
        D.ebugPrintlnINFO("===  recalcLongestRoadETA for player " + this.playerNumber);
        SOCBuildingSpeedEstimate bse = this.brain.getEstimator(this.player.getNumbers());
        int roadETA = bse.calculateRollsFast(SOCGame.EMPTY_RESOURCES, SOCRoad.COST, 500, this.player.getPortFlags());
        this.roadsToGo = 500;
        this.longestRoadETA = 500;
        SOCPlayer lrPlayer = this.game.getPlayerWithLongestRoad();
        if (lrPlayer != null && lrPlayer.getPlayerNumber() == this.playerNumber) {
            this.longestRoadETA = 0;
            this.roadsToGo = 0;
        } else if (!this.game.isGameOptionSet("_SC_0RVP")) {
            int longestRoadLength = lrPlayer == null ? Math.max(4, this.player.getLongestRoadLength()) : lrPlayer.getLongestRoadLength();
            for (SOCLRPathData pathData : this.player.getLRPaths()) {
                int depth = Math.min(longestRoadLength + 1 - pathData.getLength(), this.player.getNumPieces(0));
                int minRoads = this.recalcLongestRoadETAAux(pathData.getBeginning(), pathData.getLength(), longestRoadLength, depth);
                this.roadsToGo = Math.min(minRoads, this.roadsToGo);
                minRoads = this.recalcLongestRoadETAAux(pathData.getEnd(), pathData.getLength(), longestRoadLength, depth);
                this.roadsToGo = Math.min(minRoads, this.roadsToGo);
            }
        }
        D.ebugPrintlnINFO("--- roadsToGo = " + this.roadsToGo);
        this.longestRoadETA = this.roadsToGo * roadETA;
    }

    private int recalcLongestRoadETAAux(int startNode, int pathLength, int lrLength, int searchDepth) {
        return (Integer)SOCRobotDM.recalcLongestRoadETAAux(this.player, false, startNode, pathLength, lrLength, searchDepth);
    }

    public void recalcLargestArmyETA() {
        int laSize = 0;
        SOCPlayer laPlayer = this.game.getPlayerWithLargestArmy();
        if (laPlayer == null) {
            laSize = 3;
        } else {
            if (laPlayer.getPlayerNumber() == this.playerNumber) {
                this.largestArmyETA = 0;
                return;
            }
            laSize = laPlayer.getNumKnights() + 1;
        }
        this.knightsToBuy = 0;
        if (this.player.getNumKnights() + this.player.getInventory().getAmount(9) < laSize) {
            this.knightsToBuy = laSize - (this.player.getNumKnights() + this.player.getInventory().getAmount(0, 9));
        }
        if (this.game.getNumDevCards() >= this.knightsToBuy) {
            SOCBuildingSpeedEstimate bse = this.brain.getEstimator(this.player.getNumbers());
            int[] ourBuildingSpeed = bse.getEstimatesFromNothingFast(this.player.getPortFlags());
            int cardETA = ourBuildingSpeed[3];
            this.largestArmyETA = (cardETA + 1) * this.knightsToBuy;
        } else {
            this.largestArmyETA = 500;
        }
    }

    public void updateLRValues() {
        SOCPlayer dummy = new SOCPlayer(this.player, "dummy");
        int lrLength = this.player.getLongestRoadLength();
        for (SOCPossibleRoad posRoad : this.possibleRoads.values()) {
            if (posRoad.getNecessaryRoads().isEmpty()) {
                SOCRoutePiece dummyRS = posRoad.isRoadNotShip() || posRoad instanceof SOCPossibleShip && ((SOCPossibleShip)posRoad).isCoastalRoadAndShip ? new SOCRoad(dummy, posRoad.getCoordinates(), null) : new SOCShip(dummy, posRoad.getCoordinates(), null);
                dummy.putPiece(dummyRS, true);
                int newLRLength = dummy.calcLongestRoad2();
                if (newLRLength <= lrLength) {
                    posRoad.setLRValue(0);
                } else {
                    posRoad.setLRValue(newLRLength - lrLength);
                }
                posRoad.setLRPotential(0);
                this.updateLRPotential(posRoad, dummy, dummyRS, lrLength, LR_CALC_LEVEL);
                dummy.removePiece(dummyRS, null);
                continue;
            }
            posRoad.setLRValue(0);
            posRoad.setLRPotential(0);
        }
        dummy.destroyPlayer();
    }

    public void updateLRPotential(SOCPossibleRoad posRoad, SOCPlayer dummy, SOCRoutePiece dummyRS, int lrLength, int level) {
        boolean noMoreExpansion;
        SOCBoard board = this.game.getBoard();
        if (level <= 0) {
            noMoreExpansion = true;
        } else {
            noMoreExpansion = false;
            for (int adjEdge : board.getAdjacentEdgesToEdge(dummyRS.getCoordinates())) {
                if ((!dummyRS.isRoadNotShip() || !dummy.isPotentialRoad(adjEdge)) && (dummyRS.isRoadNotShip() || !dummy.isPotentialShip(adjEdge))) continue;
                noMoreExpansion = false;
                break;
            }
        }
        if (noMoreExpansion) {
            int newPotentialLRValue = dummy.calcLongestRoad2() - lrLength;
            if (newPotentialLRValue > posRoad.getLRPotential()) {
                posRoad.setLRPotential(newPotentialLRValue);
            }
        } else {
            for (int adjEdge : board.getAdjacentEdgesToEdge(dummyRS.getCoordinates())) {
                if ((!dummyRS.isRoadNotShip() || !dummy.isPotentialRoad(adjEdge)) && (dummyRS.isRoadNotShip() || !dummy.isPotentialShip(adjEdge))) continue;
                SOCRoutePiece newDummyRS = dummyRS.isRoadNotShip() ? new SOCRoad(dummy, adjEdge, board) : new SOCShip(dummy, adjEdge, board);
                dummy.putPiece(newDummyRS, true);
                this.updateLRPotential(posRoad, dummy, newDummyRS, lrLength, level - 1);
                dummy.removePiece(newDummyRS, null);
            }
        }
    }

    public int getWinGameETA() {
        return this.winGameETA;
    }

    public boolean needsLR() {
        return this.needLR;
    }

    public boolean needsLA() {
        return this.needLA;
    }

    public void recalcWinGameETA() {
        int oldWGETA = this.winGameETA;
        try {
            this.needLR = false;
            this.needLA = false;
            this.winGameETA = 0;
            HashSet<Integer> printedWarnSettleCoords = new HashSet<Integer>();
            SOCPlayerNumbers tempPlayerNumbers = new SOCPlayerNumbers(this.player.getNumbers());
            boolean[] tempPortFlags = new boolean[6];
            for (int portType = 0; portType <= 5; ++portType) {
                tempPortFlags[portType] = this.player.getPortFlag(portType);
            }
            SOCBuildingSpeedEstimate[] tempSetBSE = new SOCBuildingSpeedEstimate[2];
            SOCBuildingSpeedEstimate[] tempCityBSE = new SOCBuildingSpeedEstimate[]{this.brain.getEstimator(), this.brain.getEstimator()};
            tempSetBSE[0] = this.brain.getEstimator();
            tempSetBSE[1] = this.brain.getEstimator();
            int[][] chosenSetBuildingSpeed = new int[2][5];
            int[][] chosenCityBuildingSpeed = new int[2][5];
            SOCBuildingSpeedEstimate tempBSE = this.brain.getEstimator();
            SOCBuildingSpeedEstimate ourBSE = this.brain.getEstimator(this.player.getNumbers());
            int[] ourBuildingSpeed = ourBSE.getEstimatesFromNothingFast(tempPortFlags);
            int cityETA = ourBuildingSpeed[2];
            int settlementETA = ourBuildingSpeed[1];
            int roadETA = ourBuildingSpeed[0];
            int cardETA = ourBuildingSpeed[3];
            int settlementPiecesLeft = this.player.getNumPieces(1);
            int cityPiecesLeft = this.player.getNumPieces(2);
            int citySpotsLeft = this.possibleCities.size();
            boolean haveLA = false;
            boolean haveLR = false;
            int tempLargestArmyETA = this.largestArmyETA;
            int tempLongestRoadETA = this.longestRoadETA;
            SOCPlayer laPlayer = this.game.getPlayerWithLargestArmy();
            SOCPlayer lrPlayer = this.game.getPlayerWithLongestRoad();
            SOCBoard board = this.game.getBoard();
            SOCBuildingSpeedEstimateFactory bsef = this.brain.getEstimatorFactory();
            if (laPlayer != null && this.playerNumber == laPlayer.getPlayerNumber()) {
                haveLA = true;
            }
            if (lrPlayer != null && this.playerNumber == lrPlayer.getPlayerNumber()) {
                haveLR = true;
            }
            TreeMap<Integer, SOCPossibleSettlement> posSetsCopy = new TreeMap<Integer, SOCPossibleSettlement>((SortedMap<Integer, SOCPossibleSettlement>)this.possibleSettlements);
            TreeMap<Integer, SOCPossibleCity> posCitiesCopy = new TreeMap<Integer, SOCPossibleCity>((SortedMap<Integer, SOCPossibleCity>)this.possibleCities);
            int points = this.player.getTotalVP();
            int vp_winner = this.game.vp_winner;
            while (points < vp_winner) {
                Object chosenSet;
                int fastestETA;
                D.ebugPrintlnINFO("WWW points = " + points);
                D.ebugPrintlnINFO("WWW settlementPiecesLeft = " + settlementPiecesLeft);
                D.ebugPrintlnINFO("WWW cityPiecesLeft = " + cityPiecesLeft);
                D.ebugPrintlnINFO("WWW settlementSpotsLeft = " + posSetsCopy.size());
                D.ebugPrintlnINFO("WWW citySpotsLeft = " + posCitiesCopy.size());
                D.ebugPrintlnINFO("WWW settlementETA = " + settlementETA);
                D.ebugPrintlnINFO("WWW cityETA = " + cityETA);
                D.ebugPrintlnINFO("WWW roadETA = " + roadETA);
                D.ebugPrintlnINFO("WWW cardETA = " + cardETA);
                if (points == vp_winner - 1) {
                    fastestETA = 500;
                    chosenSet = null;
                    if (settlementPiecesLeft > 0 && !posSetsCopy.isEmpty()) {
                        for (SOCPossibleSettlement posSet : posSetsCopy.values()) {
                            int posSetETA = settlementETA + posSet.getNumberOfNecessaryRoads() * roadETA;
                            if (posSetETA >= fastestETA) continue;
                            fastestETA = posSetETA;
                            chosenSet = posSet;
                        }
                        if (chosenSet != null) {
                            int totalNecRoads = SOCPlayerTracker.calcTotalNecessaryRoads((SOCPossibleSettlement)chosenSet, printedWarnSettleCoords);
                            fastestETA = settlementETA + totalNecRoads * roadETA;
                            D.ebugPrintlnINFO("WWW # necesesary roads = " + totalNecRoads);
                            D.ebugPrintlnINFO("WWW this settlement eta = " + (settlementETA + totalNecRoads * roadETA));
                            D.ebugPrintlnINFO("WWW settlement is " + chosenSet);
                            D.ebugPrintlnINFO("WWW settlement eta = " + fastestETA);
                        } else {
                            fastestETA = 500;
                        }
                    }
                    if (cityPiecesLeft > 0 && citySpotsLeft > 0 && cityETA <= fastestETA) {
                        D.ebugPrintlnINFO("WWW city eta = " + cityETA);
                        fastestETA = cityETA;
                    }
                    if (!haveLA && !this.needLA && tempLargestArmyETA < fastestETA) {
                        D.ebugPrintlnINFO("WWW LA eta = " + tempLargestArmyETA);
                        fastestETA = tempLargestArmyETA;
                    }
                    if (!haveLR && !this.needLR && tempLongestRoadETA < fastestETA) {
                        D.ebugPrintlnINFO("WWW LR eta = " + tempLongestRoadETA);
                        fastestETA = tempLongestRoadETA;
                    }
                    if (!haveLR && !this.needLR && fastestETA == tempLongestRoadETA) {
                        this.needLR = true;
                        if (this.brain.getDRecorder().isOn()) {
                            this.brain.getDRecorder().record(fastestETA + ": Longest Road");
                        }
                    } else if (!haveLA && !this.needLA && fastestETA == tempLargestArmyETA) {
                        this.needLA = true;
                        if (this.brain.getDRecorder().isOn()) {
                            this.brain.getDRecorder().record(fastestETA + ": Largest Army");
                        }
                    } else if (cityPiecesLeft > 0 && citySpotsLeft > 0 && cityETA == fastestETA) {
                        if (this.brain.getDRecorder().isOn()) {
                            this.brain.getDRecorder().record(fastestETA + ": City");
                        }
                    } else if (chosenSet != null && this.brain.getDRecorder().isOn()) {
                        this.brain.getDRecorder().record(fastestETA + ": Stlmt at " + board.nodeCoordToString(((SOCPossiblePiece)chosenSet).getCoordinates()));
                    }
                    D.ebugPrintlnINFO("WWW Adding " + fastestETA + " to win eta");
                    this.winGameETA += fastestETA;
                    points += 2;
                    continue;
                }
                fastestETA = 500;
                chosenSet = new SOCPossibleSettlement[2];
                boolean[][] tempPortFlagsSet = new boolean[2][6];
                SOCPossibleCity[] chosenCity = new SOCPossibleCity[2];
                chosenSet[0] = null;
                chosenSet[1] = null;
                chosenCity[0] = null;
                chosenCity[1] = null;
                int twoSettlements = 0;
                int twoCities = 500;
                int oneOfEach = 0;
                int cityBeforeSettlement = 500;
                int settlementBeforeCity = 500;
                if (cityPiecesLeft > 1 && citySpotsLeft > 1) {
                    twoCities = 500;
                    for (SOCPossibleCity posCity0 : posCitiesCopy.values()) {
                        tempPlayerNumbers.updateNumbers(posCity0.getCoordinates(), board);
                        tempCityBSE[0].recalculateEstimates(tempPlayerNumbers);
                        chosenCityBuildingSpeed[0] = tempCityBSE[0].getEstimatesFromNothingFast(tempPortFlags);
                        int tempCityETA = chosenCityBuildingSpeed[0][2];
                        if (cityETA + tempCityETA < twoCities) {
                            chosenCity[0] = posCity0;
                            twoCities = cityETA + tempCityETA;
                        }
                        tempPlayerNumbers.undoUpdateNumbers(posCity0.getCoordinates(), board);
                    }
                    if (twoCities <= fastestETA) {
                        D.ebugPrintlnINFO("WWW twoCities = " + twoCities);
                        fastestETA = twoCities;
                    }
                }
                boolean canBuild2Settlements = false;
                if (settlementPiecesLeft > 1 && posSetsCopy.size() > 1) {
                    canBuild2Settlements = true;
                    ArrayList<SOCPossibleSettlement> posSetsToPutBack = new ArrayList<SOCPossibleSettlement>();
                    for (int i = 0; i < 2; ++i) {
                        int fastestSetETA = 500;
                        int bestSpeedupTotal = 0;
                        if (posSetsCopy.isEmpty()) {
                            canBuild2Settlements = false;
                            continue;
                        }
                        for (SOCPossibleSettlement posSet : posSetsCopy.values()) {
                            int buildingType;
                            int portType;
                            int posSetETA = settlementETA + posSet.getNumberOfNecessaryRoads() * roadETA;
                            int posSetCoord = posSet.getCoordinates();
                            if (posSetETA < fastestSetETA) {
                                int portType2;
                                fastestSetETA = posSetETA;
                                tempPlayerNumbers.updateNumbers(posSetCoord, board);
                                for (portType2 = 0; portType2 <= 5; ++portType2) {
                                    tempPortFlagsSet[i][portType2] = tempPortFlags[portType2];
                                }
                                portType2 = board.getPortTypeFromNodeCoord(posSetCoord);
                                if (portType2 != -1) {
                                    tempPortFlagsSet[i][portType2] = true;
                                }
                                tempSetBSE[i].recalculateEstimates(tempPlayerNumbers);
                                chosenSetBuildingSpeed[i] = tempSetBSE[i].getEstimatesFromNothingFast(tempPortFlagsSet[i]);
                                for (int buildingType2 = 0; buildingType2 < 5; ++buildingType2) {
                                    if (ourBuildingSpeed[buildingType2] - chosenSetBuildingSpeed[i][buildingType2] <= 0) continue;
                                    bestSpeedupTotal += ourBuildingSpeed[buildingType2] - chosenSetBuildingSpeed[i][buildingType2];
                                }
                                tempPlayerNumbers.undoUpdateNumbers(posSetCoord, board);
                                chosenSet[i] = posSet;
                                continue;
                            }
                            if (posSetETA != fastestSetETA) continue;
                            boolean[] veryTempPortFlags = new boolean[6];
                            tempPlayerNumbers.updateNumbers(posSetCoord, board);
                            for (portType = 0; portType <= 5; ++portType) {
                                veryTempPortFlags[portType] = tempPortFlags[portType];
                            }
                            portType = board.getPortTypeFromNodeCoord(posSetCoord);
                            if (portType != -1) {
                                veryTempPortFlags[portType] = true;
                            }
                            tempBSE.recalculateEstimates(tempPlayerNumbers);
                            int[] tempBuildingSpeed = tempBSE.getEstimatesFromNothingFast(veryTempPortFlags);
                            int tempSpeedupTotal = 0;
                            for (buildingType = 0; buildingType < 5; ++buildingType) {
                                if (ourBuildingSpeed[buildingType] - tempBuildingSpeed[buildingType] < 0) continue;
                                tempSpeedupTotal += ourBuildingSpeed[buildingType] - tempBuildingSpeed[buildingType];
                            }
                            tempPlayerNumbers.undoUpdateNumbers(posSetCoord, board);
                            if (tempSpeedupTotal <= bestSpeedupTotal) continue;
                            fastestSetETA = posSetETA;
                            bestSpeedupTotal = tempSpeedupTotal;
                            for (buildingType = 0; buildingType < 5; ++buildingType) {
                                chosenSetBuildingSpeed[i][buildingType] = tempBuildingSpeed[buildingType];
                            }
                            for (portType = 0; portType <= 5; ++portType) {
                                tempPortFlagsSet[i][portType] = veryTempPortFlags[portType];
                            }
                            chosenSet[i] = posSet;
                        }
                        int totalNecRoads = SOCPlayerTracker.calcTotalNecessaryRoads((SOCPossibleSettlement)chosenSet[i], printedWarnSettleCoords);
                        D.ebugPrintlnINFO("WWW # necesesary roads = " + totalNecRoads);
                        D.ebugPrintlnINFO("WWW this settlement eta = " + (settlementETA + totalNecRoads * roadETA));
                        if (i == 0 && chosenSet[0] != null) {
                            posSetsCopy.remove(((SOCPossiblePiece)chosenSet[0]).getCoordinates());
                            for (SOCPossibleSettlement conflict : ((SOCPossibleSettlement)chosenSet[0]).getConflicts()) {
                                Integer conflictInt = conflict.getCoordinates();
                                SOCPossibleSettlement possibleConflict = posSetsCopy.get(conflictInt);
                                if (possibleConflict == null) continue;
                                posSetsToPutBack.add(possibleConflict);
                                posSetsCopy.remove(conflictInt);
                            }
                            twoSettlements += settlementETA + totalNecRoads * roadETA;
                        }
                        if (i != 1 || chosenSet[1] == null) continue;
                        int tempSettlementETA = chosenSetBuildingSpeed[0][1];
                        int tempRoadETA = chosenSetBuildingSpeed[0][0];
                        twoSettlements += tempSettlementETA + totalNecRoads * tempRoadETA;
                    }
                    posSetsCopy.put(((SOCPossiblePiece)chosenSet[0]).getCoordinates(), (SOCPossibleSettlement)chosenSet[0]);
                    for (SOCPossibleSettlement tmpPosSet : posSetsToPutBack) {
                        posSetsCopy.put(tmpPosSet.getCoordinates(), tmpPosSet);
                    }
                    if (canBuild2Settlements && twoSettlements <= fastestETA) {
                        D.ebugPrintlnINFO("WWW 2 * settlement = " + twoSettlements);
                        fastestETA = twoSettlements;
                    }
                }
                if (cityPiecesLeft > 0 && (settlementPiecesLeft > 0 && citySpotsLeft >= 0 || settlementPiecesLeft >= 0 && citySpotsLeft > 0) && !posSetsCopy.isEmpty()) {
                    if (chosenCity[0] == null && citySpotsLeft > 0) {
                        int bestCitySpeedupTotal = 0;
                        for (SOCPossibleCity posCity0 : posCitiesCopy.values()) {
                            int buildingType;
                            tempPlayerNumbers.updateNumbers(posCity0.getCoordinates(), board);
                            tempBSE.recalculateEstimates(tempPlayerNumbers);
                            int[] tempBuildingSpeed = tempBSE.getEstimatesFromNothingFast(tempPortFlags);
                            int tempSpeedupTotal = 0;
                            for (buildingType = 0; buildingType < 5; ++buildingType) {
                                if (ourBuildingSpeed[buildingType] - tempBuildingSpeed[buildingType] < 0) continue;
                                tempSpeedupTotal += ourBuildingSpeed[buildingType] - tempBuildingSpeed[buildingType];
                            }
                            tempPlayerNumbers.undoUpdateNumbers(posCity0.getCoordinates(), board);
                            if (tempSpeedupTotal < bestCitySpeedupTotal) continue;
                            bestCitySpeedupTotal = tempSpeedupTotal;
                            for (buildingType = 0; buildingType < 5; ++buildingType) {
                                chosenCityBuildingSpeed[0][buildingType] = tempBuildingSpeed[buildingType];
                            }
                            chosenCity[0] = posCity0;
                        }
                    }
                    if (chosenSet[0] == null) {
                        int fastestSetETA = 500;
                        int bestSpeedupTotal = 0;
                        for (SOCPossibleSettlement posSet : posSetsCopy.values()) {
                            int buildingType;
                            int portType;
                            int posSetETA = settlementETA + posSet.getNumberOfNecessaryRoads() * roadETA;
                            if (posSetETA < fastestSetETA) {
                                int portType3;
                                fastestSetETA = posSetETA;
                                tempPlayerNumbers.updateNumbers(posSet.getCoordinates(), board);
                                for (portType3 = 0; portType3 <= 5; ++portType3) {
                                    tempPortFlagsSet[0][portType3] = tempPortFlags[portType3];
                                }
                                portType3 = board.getPortTypeFromNodeCoord(posSet.getCoordinates());
                                if (portType3 != -1) {
                                    tempPortFlagsSet[0][portType3] = true;
                                }
                                tempSetBSE[0].recalculateEstimates(tempPlayerNumbers);
                                chosenSetBuildingSpeed[0] = tempSetBSE[0].getEstimatesFromNothingFast(tempPortFlagsSet[0]);
                                for (int buildingType3 = 0; buildingType3 < 5; ++buildingType3) {
                                    if (ourBuildingSpeed[buildingType3] - chosenSetBuildingSpeed[0][buildingType3] <= 0) continue;
                                    bestSpeedupTotal += ourBuildingSpeed[buildingType3] - chosenSetBuildingSpeed[0][buildingType3];
                                }
                                tempPlayerNumbers.undoUpdateNumbers(posSet.getCoordinates(), board);
                                chosenSet[0] = posSet;
                                continue;
                            }
                            if (posSetETA != fastestSetETA) continue;
                            boolean[] veryTempPortFlags = new boolean[6];
                            tempPlayerNumbers.updateNumbers(posSet.getCoordinates(), board);
                            for (portType = 0; portType <= 5; ++portType) {
                                veryTempPortFlags[portType] = tempPortFlags[portType];
                            }
                            portType = board.getPortTypeFromNodeCoord(posSet.getCoordinates());
                            if (portType != -1) {
                                veryTempPortFlags[portType] = true;
                            }
                            tempBSE.recalculateEstimates(tempPlayerNumbers);
                            int[] tempBuildingSpeed = tempBSE.getEstimatesFromNothingFast(veryTempPortFlags);
                            int tempSpeedupTotal = 0;
                            for (buildingType = 0; buildingType < 5; ++buildingType) {
                                if (ourBuildingSpeed[buildingType] - tempBuildingSpeed[buildingType] < 0) continue;
                                tempSpeedupTotal += ourBuildingSpeed[buildingType] - tempBuildingSpeed[buildingType];
                            }
                            tempPlayerNumbers.undoUpdateNumbers(posSet.getCoordinates(), board);
                            if (tempSpeedupTotal <= bestSpeedupTotal) continue;
                            fastestSetETA = posSetETA;
                            bestSpeedupTotal = tempSpeedupTotal;
                            for (buildingType = 0; buildingType < 5; ++buildingType) {
                                chosenSetBuildingSpeed[0][buildingType] = tempBuildingSpeed[buildingType];
                            }
                            for (portType = 0; portType <= 5; ++portType) {
                                tempPortFlagsSet[0][portType] = veryTempPortFlags[portType];
                            }
                            chosenSet[0] = posSet;
                        }
                    }
                    if (citySpotsLeft == 0) {
                        chosenCity[0] = new SOCPossibleCity(this.player, ((SOCPossiblePiece)chosenSet[0]).getCoordinates(), bsef);
                    }
                    int totalNecRoads = SOCPlayerTracker.calcTotalNecessaryRoads((SOCPossibleSettlement)chosenSet[0], printedWarnSettleCoords);
                    D.ebugPrintlnINFO("WWW # necesesary roads = " + totalNecRoads);
                    D.ebugPrintlnINFO("WWW this settlement eta = " + (settlementETA + totalNecRoads * roadETA));
                    if (settlementPiecesLeft > 0 && citySpotsLeft >= 0) {
                        int tempCityETA = chosenSetBuildingSpeed[0][2];
                        settlementBeforeCity = tempCityETA + (settlementETA + totalNecRoads * roadETA);
                    }
                    if (settlementPiecesLeft >= 0 && citySpotsLeft > 0) {
                        int tempSettlementETA = chosenCityBuildingSpeed[0][1];
                        int tempRoadETA = chosenCityBuildingSpeed[0][0];
                        cityBeforeSettlement = cityETA + (tempSettlementETA + totalNecRoads * tempRoadETA);
                    }
                    if ((oneOfEach = settlementBeforeCity < cityBeforeSettlement ? settlementBeforeCity : cityBeforeSettlement) <= fastestETA) {
                        D.ebugPrintlnINFO("WWW one of each = " + oneOfEach);
                        fastestETA = oneOfEach;
                    }
                }
                if (!haveLA && !this.needLA && points > 5) {
                    int laSize = 0;
                    if (laPlayer == null) {
                        laSize = 3;
                    } else if (laPlayer.getPlayerNumber() == this.playerNumber) {
                        D.ebugPrintlnINFO("WWW ERROR CALCULATING LA ETA");
                    } else {
                        laSize = laPlayer.getNumKnights() + 1;
                    }
                    this.knightsToBuy = 0;
                    if (this.player.getNumKnights() + this.player.getInventory().getAmount(9) < laSize) {
                        this.knightsToBuy = laSize - (this.player.getNumKnights() + this.player.getInventory().getAmount(0, 9));
                    }
                    tempLargestArmyETA = this.game.getNumDevCards() >= this.knightsToBuy ? (cardETA + 1) * this.knightsToBuy : 500;
                    D.ebugPrintlnINFO("WWW LA eta = " + tempLargestArmyETA);
                    if (tempLargestArmyETA < fastestETA) {
                        fastestETA = tempLargestArmyETA;
                    }
                }
                if (!haveLR && !this.needLR && points > 5) {
                    tempLongestRoadETA = roadETA * this.roadsToGo;
                    D.ebugPrintlnINFO("WWW LR eta = " + tempLongestRoadETA);
                    if (tempLongestRoadETA < fastestETA) {
                        fastestETA = tempLongestRoadETA;
                    }
                }
                D.ebugPrintlnINFO("WWW Adding " + fastestETA + " to win eta");
                points += 2;
                this.winGameETA += fastestETA;
                D.ebugPrintlnINFO("WWW WGETA SO FAR FOR PLAYER " + this.playerNumber + " = " + this.winGameETA);
                if (settlementPiecesLeft > 1 && posSetsCopy.size() > 1 && canBuild2Settlements && fastestETA == twoSettlements) {
                    Integer conflictInt;
                    Integer chosenSet0Int = ((SOCPossiblePiece)chosenSet[0]).getCoordinates();
                    Integer chosenSet1Int = ((SOCPossiblePiece)chosenSet[1]).getCoordinates();
                    posSetsCopy.remove(chosenSet0Int);
                    posSetsCopy.remove(chosenSet1Int);
                    posCitiesCopy.put(chosenSet0Int, new SOCPossibleCity(this.player, ((SOCPossiblePiece)chosenSet[0]).getCoordinates(), bsef));
                    posCitiesCopy.put(chosenSet1Int, new SOCPossibleCity(this.player, ((SOCPossiblePiece)chosenSet[1]).getCoordinates(), bsef));
                    for (SOCPossibleSettlement conflict : ((SOCPossibleSettlement)chosenSet[0]).getConflicts()) {
                        conflictInt = conflict.getCoordinates();
                        posSetsCopy.remove(conflictInt);
                    }
                    for (SOCPossibleSettlement conflict : ((SOCPossibleSettlement)chosenSet[1]).getConflicts()) {
                        conflictInt = conflict.getCoordinates();
                        posSetsCopy.remove(conflictInt);
                    }
                    settlementPiecesLeft -= 2;
                    citySpotsLeft += 2;
                    tempPlayerNumbers.updateNumbers(((SOCPossiblePiece)chosenSet[0]).getCoordinates(), board);
                    tempPlayerNumbers.updateNumbers(((SOCPossiblePiece)chosenSet[1]).getCoordinates(), board);
                    int portType = board.getPortTypeFromNodeCoord(((SOCPossiblePiece)chosenSet[0]).getCoordinates());
                    if (portType != -1) {
                        tempPortFlags[portType] = true;
                    }
                    if ((portType = board.getPortTypeFromNodeCoord(((SOCPossiblePiece)chosenSet[1]).getCoordinates())) != -1) {
                        tempPortFlags[portType] = true;
                    }
                    ourBSE.recalculateEstimates(tempPlayerNumbers);
                    ourBuildingSpeed = ourBSE.getEstimatesFromNothingFast(tempPortFlags);
                    settlementETA = ourBuildingSpeed[1];
                    roadETA = ourBuildingSpeed[0];
                    cityETA = ourBuildingSpeed[2];
                    cardETA = ourBuildingSpeed[3];
                    D.ebugPrintlnINFO("WWW  * build two settlements");
                    D.ebugPrintlnINFO("WWW    settlement 1: " + board.nodeCoordToString(((SOCPossiblePiece)chosenSet[0]).getCoordinates()));
                    D.ebugPrintlnINFO("WWW    settlement 2: " + board.nodeCoordToString(((SOCPossiblePiece)chosenSet[1]).getCoordinates()));
                    if (!this.brain.getDRecorder().isOn()) continue;
                    this.brain.getDRecorder().record(fastestETA + ": Stlmt at " + board.nodeCoordToString(((SOCPossiblePiece)chosenSet[0]).getCoordinates()) + "; Stlmt at " + board.nodeCoordToString(((SOCPossiblePiece)chosenSet[1]).getCoordinates()));
                    continue;
                }
                if (cityPiecesLeft > 0 && (settlementPiecesLeft > 0 && citySpotsLeft >= 0 || settlementPiecesLeft >= 0 && citySpotsLeft > 0) && !posSetsCopy.isEmpty() && fastestETA == oneOfEach) {
                    if (chosenCity[0] == null) break;
                    Integer chosenSet0Int = ((SOCPossiblePiece)chosenSet[0]).getCoordinates();
                    posSetsCopy.remove(chosenSet0Int);
                    if (((SOCPossiblePiece)chosenSet[0]).getCoordinates() != chosenCity[0].getCoordinates()) {
                        posCitiesCopy.put(chosenSet0Int, new SOCPossibleCity(this.player, ((SOCPossiblePiece)chosenSet[0]).getCoordinates(), bsef));
                    }
                    posCitiesCopy.remove(chosenCity[0].getCoordinates());
                    --cityPiecesLeft;
                    for (SOCPossibleSettlement conflict : ((SOCPossibleSettlement)chosenSet[0]).getConflicts()) {
                        Integer conflictInt = conflict.getCoordinates();
                        posSetsCopy.remove(conflictInt);
                    }
                    tempPlayerNumbers.updateNumbers(((SOCPossiblePiece)chosenSet[0]).getCoordinates(), board);
                    int portType = board.getPortTypeFromNodeCoord(((SOCPossiblePiece)chosenSet[0]).getCoordinates());
                    if (portType != -1) {
                        tempPortFlags[portType] = true;
                    }
                    tempPlayerNumbers.updateNumbers(chosenCity[0].getCoordinates(), board);
                    ourBSE.recalculateEstimates(tempPlayerNumbers);
                    ourBuildingSpeed = ourBSE.getEstimatesFromNothingFast(tempPortFlags);
                    settlementETA = ourBuildingSpeed[1];
                    roadETA = ourBuildingSpeed[0];
                    cityETA = ourBuildingSpeed[2];
                    cardETA = ourBuildingSpeed[3];
                    D.ebugPrintlnINFO("WWW  * build a settlement and a city");
                    D.ebugPrintlnINFO("WWW    settlement at " + board.nodeCoordToString(((SOCPossiblePiece)chosenSet[0]).getCoordinates()));
                    D.ebugPrintlnINFO("WWW    city at " + board.nodeCoordToString(chosenCity[0].getCoordinates()));
                    if (!this.brain.getDRecorder().isOn()) continue;
                    if (fastestETA == settlementBeforeCity) {
                        this.brain.getDRecorder().record(fastestETA + ": Stlmt at " + board.nodeCoordToString(((SOCPossiblePiece)chosenSet[0]).getCoordinates()) + "; City at " + board.nodeCoordToString(chosenCity[0].getCoordinates()));
                        continue;
                    }
                    this.brain.getDRecorder().record(fastestETA + ": City at " + board.nodeCoordToString(chosenCity[0].getCoordinates()) + "; Stlmt at " + board.nodeCoordToString(((SOCPossiblePiece)chosenSet[0]).getCoordinates()));
                    continue;
                }
                if (cityPiecesLeft > 1 && citySpotsLeft > 1 && fastestETA == twoCities) {
                    posCitiesCopy.remove(chosenCity[0].getCoordinates());
                    tempPlayerNumbers.updateNumbers(chosenCity[0].getCoordinates(), board);
                    int bestCitySpeedupTotal = 0;
                    for (SOCPossibleCity posCity1 : posCitiesCopy.values()) {
                        tempPlayerNumbers.updateNumbers(posCity1.getCoordinates(), board);
                        D.ebugPrintlnINFO("tempPlayerNumbers = " + tempPlayerNumbers);
                        tempBSE.recalculateEstimates(tempPlayerNumbers);
                        int[] tempBuildingSpeed = tempBSE.getEstimatesFromNothingFast(tempPortFlags);
                        int tempSpeedupTotal = 0;
                        for (int buildingType = 0; buildingType < 5; ++buildingType) {
                            D.ebugPrintlnINFO("ourBuildingSpeed[" + buildingType + "] = " + ourBuildingSpeed[buildingType]);
                            D.ebugPrintlnINFO("tempBuildingSpeed[" + buildingType + "] = " + tempBuildingSpeed[buildingType]);
                            if (ourBuildingSpeed[buildingType] - tempBuildingSpeed[buildingType] < 0) continue;
                            tempSpeedupTotal += ourBuildingSpeed[buildingType] - tempBuildingSpeed[buildingType];
                        }
                        tempPlayerNumbers.undoUpdateNumbers(posCity1.getCoordinates(), board);
                        D.ebugPrintlnINFO("tempPlayerNumbers = " + tempPlayerNumbers);
                        D.ebugPrintlnINFO("WWW City at " + board.nodeCoordToString(posCity1.getCoordinates()) + " has tempSpeedupTotal = " + tempSpeedupTotal);
                        if (tempSpeedupTotal < bestCitySpeedupTotal) continue;
                        bestCitySpeedupTotal = tempSpeedupTotal;
                        chosenCity[1] = posCity1;
                    }
                    if (chosenCity[1] != null) {
                        posCitiesCopy.remove(chosenCity[1].getCoordinates());
                        tempPlayerNumbers.updateNumbers(chosenCity[1].getCoordinates(), board);
                        settlementPiecesLeft += 2;
                        cityPiecesLeft -= 2;
                        citySpotsLeft -= 2;
                    } else {
                        --points;
                        ++settlementPiecesLeft;
                        --cityPiecesLeft;
                        --citySpotsLeft;
                    }
                    ourBSE.recalculateEstimates(tempPlayerNumbers);
                    ourBuildingSpeed = ourBSE.getEstimatesFromNothingFast(tempPortFlags);
                    settlementETA = ourBuildingSpeed[1];
                    roadETA = ourBuildingSpeed[0];
                    cityETA = ourBuildingSpeed[2];
                    cardETA = ourBuildingSpeed[3];
                    D.ebugPrintlnINFO("WWW  * build 2 cities");
                    D.ebugPrintlnINFO("WWW    city 1: " + board.nodeCoordToString(chosenCity[0].getCoordinates()));
                    if (chosenCity[1] != null) {
                        D.ebugPrintlnINFO("WWW    city 2: " + board.nodeCoordToString(chosenCity[1].getCoordinates()));
                    }
                    if (!this.brain.getDRecorder().isOn()) continue;
                    this.brain.getDRecorder().record(fastestETA + ": City at " + board.nodeCoordToString(chosenCity[0].getCoordinates()) + "; City at " + board.nodeCoordToString(chosenCity[1].getCoordinates()));
                    continue;
                }
                if (!haveLR && !this.needLR && points > 5 && fastestETA == tempLongestRoadETA) {
                    this.needLR = true;
                    D.ebugPrintlnINFO("WWW  * take longest road");
                    if (!this.brain.getDRecorder().isOn()) continue;
                    this.brain.getDRecorder().record(fastestETA + ": Longest Road");
                    continue;
                }
                if (haveLA || this.needLA || points <= 5 || fastestETA != tempLargestArmyETA) continue;
                this.needLA = true;
                D.ebugPrintlnINFO("WWW  * take largest army");
                if (!this.brain.getDRecorder().isOn()) continue;
                this.brain.getDRecorder().record(fastestETA + ": Largest Army");
            }
            D.ebugPrintlnINFO("WWW TOTAL WGETA FOR PLAYER " + this.playerNumber + " = " + this.winGameETA);
            if (this.brain.getDRecorder().isOn()) {
                this.brain.getDRecorder().record("Total WGETA for " + this.player.getName() + " = " + this.winGameETA);
                this.brain.getDRecorder().record("--------------------");
            }
        }
        catch (Exception e) {
            this.winGameETA = oldWGETA;
            System.err.println("Exception in recalcWinGameETA - " + e);
            e.printStackTrace();
        }
    }

    private static int calcTotalNecessaryRoads(SOCPossibleSettlement ps, HashSet<Integer> printedWarnSettleCoords) {
        if (ps.getNecessaryRoads().isEmpty()) {
            return 0;
        }
        int totalNecRoads = 0;
        int psNodeAddWarn = -1;
        Queue<Pair<Integer, List<SOCPossibleRoad>>> necRoadQueue = new Queue<Pair<Integer, List<SOCPossibleRoad>>>();
        necRoadQueue.clear();
        necRoadQueue.put(new Pair<Integer, List<SOCPossibleRoad>>(0, ps.getNecessaryRoads()));
        for (int maxIter = 50; maxIter > 0 && !necRoadQueue.empty(); --maxIter) {
            Pair necRoadPair = (Pair)necRoadQueue.get();
            totalNecRoads = (Integer)necRoadPair.getA();
            List necRoadsToCurrent = (List)necRoadPair.getB();
            if (necRoadsToCurrent.isEmpty()) {
                necRoadQueue.clear();
                continue;
            }
            if (necRoadQueue.size() + necRoadsToCurrent.size() > 40) {
                int psNode = ps.getCoordinates();
                if (!printedWarnSettleCoords.contains(psNode)) {
                    System.err.println("PT.calcTotalNecessaryRoads L3889: Necessary Road Path too long for settle at 0x" + Integer.toHexString(psNode));
                    psNodeAddWarn = psNode;
                }
                totalNecRoads = 40;
                necRoadQueue.clear();
                break;
            }
            for (SOCPossibleRoad nr : necRoadsToCurrent) {
                necRoadQueue.put(new Pair<Integer, List<SOCPossibleRoad>>(totalNecRoads + 1, nr.getNecessaryRoads()));
            }
        }
        if (!necRoadQueue.empty()) {
            int psNode = ps.getCoordinates();
            if (!printedWarnSettleCoords.contains(psNode)) {
                System.err.println("PT.calcTotalNecessaryRoads L3906: Necessary Road Path length unresolved for settle at 0x" + Integer.toHexString(psNode));
                psNodeAddWarn = psNode;
            }
            totalNecRoads = 40;
        }
        if (psNodeAddWarn >= 0) {
            printedWarnSettleCoords.add(psNodeAddWarn);
        }
        return totalNecRoads;
    }

    public static SOCPlayerTracker[] tryPutPiece(SOCPlayingPiece piece, SOCGame game, SOCPlayerTracker[] trackers) {
        SOCPlayerTracker[] trackersCopy = SOCPlayerTracker.copyPlayerTrackers(trackers);
        if (piece != null) {
            game.putTempPiece(piece);
            block5: for (SOCPlayerTracker trackerCopy : trackersCopy) {
                if (trackerCopy == null) continue;
                switch (piece.getType()) {
                    case 0: 
                    case 3: {
                        trackerCopy.addNewRoadOrShip((SOCRoutePiece)piece, trackersCopy);
                        continue block5;
                    }
                    case 1: {
                        trackerCopy.addNewSettlement((SOCSettlement)piece, trackersCopy);
                        continue block5;
                    }
                    case 2: {
                        trackerCopy.addOurNewCity((SOCCity)piece);
                    }
                }
            }
        }
        return trackersCopy;
    }

    public static void tryPutPieceNoCopy(SOCPlayingPiece piece, SOCGame game, SOCPlayerTracker[] trackers) {
        if (piece != null) {
            game.putTempPiece(piece);
            block5: for (SOCPlayerTracker tracker : trackers) {
                if (tracker == null) continue;
                switch (piece.getType()) {
                    case 0: 
                    case 3: {
                        tracker.addNewRoadOrShip((SOCRoutePiece)piece, trackers);
                        continue block5;
                    }
                    case 1: {
                        tracker.addNewSettlement((SOCSettlement)piece, trackers);
                        continue block5;
                    }
                    case 2: {
                        tracker.addOurNewCity((SOCCity)piece);
                    }
                }
            }
        }
    }

    public static void undoTryPutPiece(SOCPlayingPiece piece, SOCGame game) {
        if (piece != null) {
            game.undoPutTempPiece(piece);
        }
    }

    public static void playerTrackersDebug(SOCPlayerTracker[] playerTrackers) {
    }

    public static void updateWinGameETAs(SOCPlayerTracker[] playerTrackers) {
        for (SOCPlayerTracker tracker : playerTrackers) {
            if (tracker == null) continue;
            try {
                tracker.recalcLongestRoadETA();
                tracker.recalcLargestArmyETA();
                tracker.recalcWinGameETA();
            }
            catch (NullPointerException e) {
                System.err.println("Null Pointer Exception calculating winGameETA");
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        return "SOCPlayerTracker@" + Integer.toHexString(super.hashCode()) + "[" + this.brain.getOurPlayerData().getName() + ", pl=" + this.player.getName() + "]";
    }
}

