/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import soc.game.SOCCity;
import soc.game.SOCPlayer;
import soc.game.SOCPlayerNumbers;
import soc.robot.SOCBuildingSpeedEstimate;
import soc.robot.SOCBuildingSpeedEstimateFactory;
import soc.robot.SOCPossiblePiece;

public class SOCPossibleCity
extends SOCPossiblePiece {
    private static final long serialVersionUID = 1000L;
    protected int[] speedup = new int[]{0, 0, 0, 0, 0};

    public SOCPossibleCity(SOCPlayer pl, int co, SOCBuildingSpeedEstimateFactory bseFactory) {
        super(2, pl, co, bseFactory);
        this.eta = 0;
        this.threatUpdatedFlag = false;
        this.hasBeenExpanded = false;
        this.updateSpeedup();
    }

    public SOCPossibleCity(SOCPossibleCity pc) {
        super(2, pc.getPlayer(), pc.getCoordinates(), pc.bseFactory);
        this.eta = pc.getETA();
        this.threatUpdatedFlag = false;
        this.hasBeenExpanded = false;
        int[] pcSpeedup = pc.getSpeedup();
        for (int buildingType = 0; buildingType < 5; ++buildingType) {
            this.speedup[buildingType] = pcSpeedup[buildingType];
        }
    }

    public void updateSpeedup() {
        SOCBuildingSpeedEstimate bse1 = this.bseFactory.getEstimator(this.player.getNumbers());
        int[] ourBuildingSpeed = bse1.getEstimatesFromNothingFast(this.player.getPortFlags());
        SOCPlayerNumbers newNumbers = new SOCPlayerNumbers(this.player.getNumbers());
        newNumbers.updateNumbers(new SOCCity(this.player, this.coord, null), this.player.getGame().getBoard());
        SOCBuildingSpeedEstimate bse2 = this.bseFactory.getEstimator(newNumbers);
        int[] speed = bse2.getEstimatesFromNothingFast(this.player.getPortFlags());
        for (int buildingType = 0; buildingType < 5; ++buildingType) {
            this.speedup[buildingType] = ourBuildingSpeed[buildingType] - speed[buildingType];
        }
    }

    public int[] getSpeedup() {
        return this.speedup;
    }

    public int getSpeedupTotal() {
        int sum = 0;
        for (int buildingType = 0; buildingType < 5; ++buildingType) {
            sum += this.speedup[buildingType];
        }
        return sum;
    }
}

