/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import soc.game.SOCCity;
import soc.game.SOCDevCard;
import soc.game.SOCPlayer;
import soc.game.SOCResourceSet;
import soc.game.SOCRoad;
import soc.game.SOCSettlement;
import soc.game.SOCShip;
import soc.robot.SOCBuildingSpeedEstimateFactory;
import soc.robot.SOCPlayerTracker;
import soc.robot.SOCPossiblePickSpecialItem;

public abstract class SOCPossiblePiece
implements Serializable {
    private static final long serialVersionUID = 2500L;
    public static final int ROAD = 0;
    public static final int SETTLEMENT = 1;
    public static final int CITY = 2;
    public static final int SHIP = 3;
    public static final int CARD = -2;
    public static final int PICK_SPECIAL = -3;
    public static final int MIN = -3;
    public static final int MAXPLUSONE = 4;
    protected int pieceType;
    protected transient SOCPlayer player;
    protected transient SOCBuildingSpeedEstimateFactory bseFactory;
    protected int coord;
    protected int eta;
    protected boolean updated;
    protected float score;
    protected final ArrayList<SOCPossiblePiece> biggestThreats = new ArrayList();
    protected final ArrayList<SOCPossiblePiece> threats = new ArrayList();
    protected boolean threatUpdatedFlag;
    protected boolean hasBeenExpanded;

    protected SOCPossiblePiece(int pt, SOCPlayer pl, int coord) {
        this(pt, pl, coord, null);
    }

    protected SOCPossiblePiece(int pt, SOCPlayer pl, int coord, SOCBuildingSpeedEstimateFactory bsef) {
        this.pieceType = pt;
        this.player = pl;
        this.coord = coord;
        this.bseFactory = bsef;
    }

    public int getType() {
        return this.pieceType;
    }

    public SOCPlayer getPlayer() {
        return this.player;
    }

    public int getCoordinates() {
        return this.coord;
    }

    public int getETA() {
        return this.eta;
    }

    public void setETA(int e) {
        this.eta = e;
        this.updated = true;
    }

    public boolean isETAUpdated() {
        return this.updated;
    }

    public void clearUpdateFlag() {
        this.updated = false;
    }

    public void resetScore() {
        this.score = 0.0f;
    }

    public void addToScore(float amt) {
        this.score += amt;
    }

    public void subtractFromScore(float amt) {
        this.score -= amt;
    }

    public float getScore() {
        return this.score;
    }

    public void clearBiggestThreats() {
        this.biggestThreats.clear();
    }

    public void addBiggestThreat(SOCPossiblePiece bt) {
        this.biggestThreats.add(bt);
    }

    public List<SOCPossiblePiece> getBiggestThreats() {
        return this.biggestThreats;
    }

    public List<SOCPossiblePiece> getThreats() {
        return this.threats;
    }

    public void addThreat(SOCPossiblePiece piece) {
        if (!this.threats.contains(piece)) {
            this.threats.add(piece);
        }
    }

    public boolean isThreatUpdated() {
        return this.threatUpdatedFlag;
    }

    public void clearThreats() {
        if (this.threatUpdatedFlag) {
            this.threats.clear();
            this.threatUpdatedFlag = false;
        }
    }

    public void threatUpdated() {
        this.threatUpdatedFlag = true;
    }

    public boolean hasBeenExpanded() {
        return this.hasBeenExpanded;
    }

    public void resetExpandedFlag() {
        this.hasBeenExpanded = false;
    }

    public void setExpandedFlag() {
        this.hasBeenExpanded = true;
    }

    public SOCResourceSet getResourcesToBuild() {
        switch (this.pieceType) {
            case 0: {
                return SOCRoad.COST;
            }
            case 1: {
                return SOCSettlement.COST;
            }
            case 2: {
                return SOCCity.COST;
            }
            case 3: {
                return SOCShip.COST;
            }
            case -2: 
            case 6: {
                return SOCDevCard.COST;
            }
            case -3: {
                return ((SOCPossiblePickSpecialItem)this).cost;
            }
        }
        System.err.println("SOCPossiblePiece.getResourcesToBuild: Unknown piece type " + this.pieceType);
        return null;
    }

    public void setTransientsAtLoad(SOCPlayer pl, SOCPlayerTracker pt) {
        this.player = pl;
        this.bseFactory = pt.getBrain().getEstimatorFactory();
    }

    public String toString() {
        String clName = this.getClass().getName();
        int dot = clName.lastIndexOf(".");
        if (dot > 0) {
            clName = clName.substring(dot + 1);
        }
        return "SOCPossiblePiece:" + clName + "|type=" + this.pieceType + "|player=" + this.player + "|coord=" + Integer.toHexString(this.coord);
    }
}

