/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import java.util.ArrayList;
import java.util.List;
import soc.game.SOCPlayer;
import soc.robot.SOCPossiblePiece;

public class SOCPossibleRoad
extends SOCPossiblePiece {
    private static final long serialVersionUID = 2000L;
    protected final List<SOCPossibleRoad> necessaryRoads;
    protected final List<SOCPossiblePiece> newPossibilities;
    protected int longestRoadValue;
    protected int longestRoadPotential;
    protected int numberOfNecessaryRoads;

    public SOCPossibleRoad(SOCPlayer pl, int co, List<SOCPossibleRoad> nr) {
        super(0, pl, co);
        if (nr == null) {
            nr = new ArrayList<SOCPossibleRoad>();
        }
        this.necessaryRoads = nr;
        this.eta = 0;
        this.newPossibilities = new ArrayList<SOCPossiblePiece>();
        this.longestRoadValue = 0;
        this.longestRoadPotential = 0;
        this.threatUpdatedFlag = false;
        this.hasBeenExpanded = false;
        this.numberOfNecessaryRoads = -1;
    }

    public SOCPossibleRoad(SOCPossibleRoad pr) {
        super(0, pr.getPlayer(), pr.getCoordinates());
        this.necessaryRoads = new ArrayList<SOCPossibleRoad>(pr.getNecessaryRoads().size());
        this.eta = pr.getETA();
        this.newPossibilities = new ArrayList<SOCPossiblePiece>(pr.getNewPossibilities().size());
        this.longestRoadValue = pr.getLRValue();
        this.longestRoadPotential = pr.getLRPotential();
        this.threatUpdatedFlag = false;
        this.hasBeenExpanded = false;
        this.numberOfNecessaryRoads = pr.getNumberOfNecessaryRoads();
    }

    public List<SOCPossibleRoad> getNecessaryRoads() {
        return this.necessaryRoads;
    }

    public int getNumberOfNecessaryRoads() {
        return this.numberOfNecessaryRoads;
    }

    public void setNumberOfNecessaryRoads(int num) {
        this.numberOfNecessaryRoads = num;
    }

    public List<SOCPossiblePiece> getNewPossibilities() {
        return this.newPossibilities;
    }

    public int getLRValue() {
        return this.longestRoadValue;
    }

    public int getLRPotential() {
        return this.longestRoadPotential;
    }

    public void addNecessaryRoad(SOCPossibleRoad rd) {
        this.necessaryRoads.add(rd);
    }

    public void addNewPossibility(SOCPossiblePiece piece) {
        this.newPossibilities.add(piece);
    }

    public void setLRValue(int value) {
        this.longestRoadValue = value;
    }

    public void setLRPotential(int value) {
        this.longestRoadPotential = value;
    }

    public final boolean isRoadNotShip() {
        return this.pieceType == 0;
    }
}

