/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import soc.game.SOCPlayer;
import soc.robot.SOCBuildingSpeedEstimateFactory;
import soc.robot.SOCPossiblePiece;
import soc.robot.SOCPossibleRoad;

public class SOCPossibleSettlement
extends SOCPossiblePiece {
    private static final long serialVersionUID = 2000L;
    protected List<SOCPossibleRoad> necessaryRoads;
    protected List<SOCPossibleSettlement> conflicts;
    protected int[] speedup = new int[]{0, 0, 0, 0, 0};
    protected int numberOfNecessaryRoads;
    protected Stack<SOCPossibleRoad> roadPath;

    public SOCPossibleSettlement(SOCPlayer pl, int co, List<SOCPossibleRoad> nr, SOCBuildingSpeedEstimateFactory bseFactory) {
        super(1, pl, co, bseFactory);
        if (nr == null) {
            nr = new ArrayList<SOCPossibleRoad>();
        }
        this.necessaryRoads = nr;
        this.eta = 0;
        this.conflicts = new ArrayList<SOCPossibleSettlement>();
        this.threatUpdatedFlag = false;
        this.hasBeenExpanded = false;
        this.numberOfNecessaryRoads = -1;
        this.roadPath = null;
        this.updateSpeedup();
    }

    public SOCPossibleSettlement(SOCPossibleSettlement ps) {
        super(1, ps.getPlayer(), ps.getCoordinates(), ps.bseFactory);
        this.necessaryRoads = new ArrayList<SOCPossibleRoad>(ps.getNecessaryRoads().size());
        this.eta = ps.getETA();
        this.conflicts = new ArrayList<SOCPossibleSettlement>(ps.getConflicts().size());
        this.threatUpdatedFlag = false;
        this.hasBeenExpanded = false;
        int[] psSpeedup = ps.getSpeedup();
        for (int buildingType = 0; buildingType < 5; ++buildingType) {
            this.speedup[buildingType] = psSpeedup[buildingType];
        }
        this.numberOfNecessaryRoads = ps.getNumberOfNecessaryRoads();
        this.roadPath = ps.getRoadPath() == null ? null : (Stack)ps.getRoadPath().clone();
    }

    public Stack<SOCPossibleRoad> getRoadPath() {
        return this.roadPath;
    }

    public void setRoadPath(Stack<SOCPossibleRoad> path) {
        this.roadPath = path;
    }

    public List<SOCPossibleRoad> getNecessaryRoads() {
        return this.necessaryRoads;
    }

    public int getNumberOfNecessaryRoads() {
        return this.numberOfNecessaryRoads;
    }

    public void setNumberOfNecessaryRoads(int num) {
        this.numberOfNecessaryRoads = num;
    }

    public void updateSpeedup() {
    }

    public List<SOCPossibleSettlement> getConflicts() {
        return this.conflicts;
    }

    public void addNecessaryRoad(SOCPossibleRoad rd) {
        this.necessaryRoads.add(rd);
    }

    public void addConflict(SOCPossibleSettlement s) {
        this.conflicts.add(s);
    }

    public void removeConflict(SOCPossibleSettlement s) {
        this.conflicts.remove(s);
    }

    public int[] getSpeedup() {
        return this.speedup;
    }

    public int getSpeedupTotal() {
        int sum = 0;
        for (int buildingType = 0; buildingType < 5; ++buildingType) {
            sum += this.speedup[buildingType];
        }
        return sum;
    }
}

