/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import soc.baseclient.SOCDisplaylessPlayerClient;
import soc.disableDebug.D;
import soc.game.SOCBoard;
import soc.game.SOCBoardLarge;
import soc.game.SOCCity;
import soc.game.SOCGame;
import soc.game.SOCInventory;
import soc.game.SOCInventoryItem;
import soc.game.SOCPlayer;
import soc.game.SOCPlayerNumbers;
import soc.game.SOCPlayingPiece;
import soc.game.SOCResourceSet;
import soc.game.SOCRoad;
import soc.game.SOCRoutePiece;
import soc.game.SOCSettlement;
import soc.game.SOCShip;
import soc.game.SOCTradeOffer;
import soc.message.SOCAcceptOffer;
import soc.message.SOCBankTrade;
import soc.message.SOCBotGameDataCheck;
import soc.message.SOCCancelBuildRequest;
import soc.message.SOCChoosePlayer;
import soc.message.SOCChoosePlayerRequest;
import soc.message.SOCClearOffer;
import soc.message.SOCDeclinePlayerRequest;
import soc.message.SOCDevCardAction;
import soc.message.SOCDiceResult;
import soc.message.SOCDiceResultResources;
import soc.message.SOCDiscard;
import soc.message.SOCDiscardRequest;
import soc.message.SOCGameState;
import soc.message.SOCGameStats;
import soc.message.SOCInventoryItemAction;
import soc.message.SOCMakeOffer;
import soc.message.SOCMessage;
import soc.message.SOCMovePiece;
import soc.message.SOCMoveRobber;
import soc.message.SOCPlayerElement;
import soc.message.SOCPlayerElements;
import soc.message.SOCPutPiece;
import soc.message.SOCRejectOffer;
import soc.message.SOCResourceCount;
import soc.message.SOCRobberyResult;
import soc.message.SOCSetSpecialItem;
import soc.message.SOCSimpleAction;
import soc.message.SOCSimpleRequest;
import soc.message.SOCStartGame;
import soc.message.SOCTurn;
import soc.message.SOCUndoPutPiece;
import soc.robot.DiscardStrategy;
import soc.robot.MonopolyStrategy;
import soc.robot.OpeningBuildStrategy;
import soc.robot.RobberStrategy;
import soc.robot.SOCBuildPlan;
import soc.robot.SOCBuildPlanStack;
import soc.robot.SOCBuildingSpeedEstimate;
import soc.robot.SOCBuildingSpeedEstimateFactory;
import soc.robot.SOCPlayerTracker;
import soc.robot.SOCPossibleCity;
import soc.robot.SOCPossiblePickSpecialItem;
import soc.robot.SOCPossiblePiece;
import soc.robot.SOCPossibleRoad;
import soc.robot.SOCPossibleSettlement;
import soc.robot.SOCPossibleShip;
import soc.robot.SOCRobotClient;
import soc.robot.SOCRobotDM;
import soc.robot.SOCRobotNegotiator;
import soc.robot.SOCRobotPinger;
import soc.util.CappedQueue;
import soc.util.DebugRecorder;
import soc.util.SOCRobotParameters;

public class SOCRobotBrain
extends Thread {
    public static float BOTS_ONLY_FAST_PAUSE_FACTOR = 0.25f;
    public static int MAX_DENIED_BUILDING_PER_TURN = 3;
    public static int MAX_DENIED_BANK_TRADES_PER_TURN = 9;
    public static int MAX_DENIED_PLAYER_TRADES_PER_TURN = 9;
    public static int BOTS_PAUSE_FOR_HUMAN_TRADE = 8;
    protected static final int TRADE_RESPONSE_TIMEOUT_SEC_HUMANS = 30;
    protected static final int TRADE_RESPONSE_TIMEOUT_SEC_BOTS_ONLY = 5;
    protected SOCRobotParameters robotParameters;
    protected volatile boolean alive;
    protected boolean ourTurn;
    private boolean pauseFaster;
    protected Random rand = new Random();
    protected SOCRobotClient client;
    protected SOCGame game;
    protected final boolean gameIs6Player;
    protected SOCPlayer ourPlayerData;
    protected int ourPlayerNumber;
    protected final String ourPlayerName;
    protected SOCPlayer dummyCancelPlayerData;
    protected CappedQueue<SOCMessage> gameEventQ;
    protected Vector<SOCMessage> turnEventsCurrent;
    protected Vector<SOCMessage> turnEventsPrev;
    protected int turnExceptionCount;
    protected int counter;
    protected boolean decidedIfSpecialBuild;
    protected boolean waitingForSpecialBuild;
    protected SOCPlayingPiece whatWeWantToBuild;
    protected final SOCBuildPlanStack buildingPlan;
    protected SOCPlayingPiece whatWeFailedToBuild;
    protected int failedBuildingAttempts;
    protected int failedBankTrades;
    protected int declinedOurPlayerTrades;
    protected SOCPlayerTracker ourPlayerTracker;
    protected SOCPlayerTracker[] playerTrackers;
    protected SOCRobotDM decisionMaker;
    protected SOCRobotNegotiator negotiator;
    protected SOCBuildingSpeedEstimateFactory bseFactory;
    protected boolean expectSTART1A;
    protected boolean expectSTART1B;
    protected boolean expectSTART2A;
    protected boolean expectSTART2B;
    protected boolean expectSTART3A;
    protected boolean expectSTART3B;
    protected boolean expectROLL_OR_CARD;
    protected boolean expectPLAY1;
    protected boolean expectPLACING_ROAD;
    protected boolean expectPLACING_SETTLEMENT;
    protected boolean expectPLACING_CITY;
    protected boolean expectPLACING_SHIP;
    protected boolean expectPLACING_ROBBER;
    protected boolean expectPLACING_FREE_ROAD1;
    protected boolean expectPLACING_FREE_ROAD2;
    protected boolean expectPLACING_INV_ITEM;
    protected boolean expectPUTPIECE_FROM_START1A;
    protected boolean expectPUTPIECE_FROM_START1B;
    protected boolean expectPUTPIECE_FROM_START2A;
    protected boolean expectPUTPIECE_FROM_START2B;
    protected boolean expectPUTPIECE_FROM_START3A;
    protected boolean expectPUTPIECE_FROM_START3B;
    protected boolean expectDICERESULT;
    protected boolean expectDISCARD;
    protected boolean expectMOVEROBBER;
    protected boolean expectWAITING_FOR_DISCOVERY;
    protected boolean expectWAITING_FOR_MONOPOLY;
    protected boolean waitingForGameState;
    protected boolean waitingForOurTurn;
    protected boolean waitingForTurnMain;
    protected boolean waitingForTradeMsg;
    protected boolean waitingForDevCard;
    protected boolean moveRobberOnSeven;
    protected boolean waitingForTradeResponse;
    protected int tradeResponseTimeoutSec;
    protected String waitingForPickSpecialItem;
    protected boolean waitingForSC_PIRI_FortressRequest;
    protected boolean doneTrading;
    protected boolean[] offerRejections;
    protected int rejectedPlayDevCardType;
    protected SOCInventoryItem rejectedPlayInvItem;
    protected int oldGameState;
    protected int lastStartingPieceCoord;
    protected DiscardStrategy discardStrategy;
    protected OpeningBuildStrategy openingBuildStrategy;
    protected MonopolyStrategy monopolyStrategy;
    protected RobberStrategy robberStrategy;
    protected SOCRobotPinger pinger;
    protected DebugRecorder[] dRecorder;
    protected int currentDRecorder;
    protected SOCPossiblePiece lastMove;
    protected SOCPossiblePiece lastTarget;

    public SOCRobotBrain(SOCRobotClient rc, SOCRobotParameters params, SOCGame ga, CappedQueue<SOCMessage> mq) {
        this.client = rc;
        this.ourPlayerName = rc.getNickname();
        this.robotParameters = params.copyIfOptionChanged(ga.getGameOptions());
        this.game = ga;
        this.pauseFaster = this.gameIs6Player = ga.maxPlayers > 4;
        this.gameEventQ = mq;
        this.turnEventsCurrent = new Vector();
        this.turnEventsPrev = new Vector();
        this.alive = true;
        this.counter = 0;
        this.expectSTART1A = true;
        this.expectSTART1B = false;
        this.expectSTART2A = false;
        this.expectSTART2B = false;
        this.expectROLL_OR_CARD = false;
        this.expectPLAY1 = false;
        this.expectPLACING_ROAD = false;
        this.expectPLACING_SETTLEMENT = false;
        this.expectPLACING_CITY = false;
        this.expectPLACING_SHIP = false;
        this.expectPLACING_ROBBER = false;
        this.expectPLACING_FREE_ROAD1 = false;
        this.expectPLACING_FREE_ROAD2 = false;
        this.expectPUTPIECE_FROM_START1A = false;
        this.expectPUTPIECE_FROM_START1B = false;
        this.expectPUTPIECE_FROM_START2A = false;
        this.expectPUTPIECE_FROM_START2B = false;
        this.expectDICERESULT = false;
        this.expectDISCARD = false;
        this.expectMOVEROBBER = false;
        this.expectWAITING_FOR_DISCOVERY = false;
        this.expectWAITING_FOR_MONOPOLY = false;
        this.ourTurn = false;
        this.oldGameState = this.game.getGameState();
        this.waitingForGameState = false;
        this.waitingForOurTurn = false;
        this.waitingForTradeMsg = false;
        this.waitingForDevCard = false;
        this.waitingForSpecialBuild = false;
        this.decidedIfSpecialBuild = false;
        this.moveRobberOnSeven = false;
        this.waitingForTradeResponse = false;
        this.setDoneTrading(false);
        this.offerRejections = new boolean[this.game.maxPlayers];
        for (int i = 0; i < this.game.maxPlayers; ++i) {
            this.offerRejections[i] = false;
        }
        this.buildingPlan = new SOCBuildPlanStack();
        this.pinger = new SOCRobotPinger(this.gameEventQ, this.game.getName(), this.client.getNickname() + "-" + this.game.getName());
        this.dRecorder = new DebugRecorder[2];
        this.dRecorder[0] = new DebugRecorder();
        this.dRecorder[1] = new DebugRecorder();
        this.currentDRecorder = 0;
    }

    public SOCRobotParameters getRobotParameters() {
        return this.robotParameters;
    }

    public SOCRobotClient getClient() {
        return this.client;
    }

    public SOCPlayerTracker[] getPlayerTrackers() {
        return this.playerTrackers;
    }

    public SOCPlayerTracker getOurPlayerTracker() {
        return this.ourPlayerTracker;
    }

    public void addPlayerTracker(int pn) {
        if (null == this.playerTrackers) {
            return;
        }
        if (null == this.playerTrackers[pn]) {
            this.playerTrackers[pn] = new SOCPlayerTracker(this.game.getPlayer(pn), this);
        }
    }

    public SOCGame getGame() {
        return this.game;
    }

    public SOCPlayer getOurPlayerData() {
        return this.ourPlayerData;
    }

    public final int getOurPlayerNumber() {
        return this.ourPlayerNumber;
    }

    public SOCBuildPlanStack getBuildingPlan() {
        return this.buildingPlan;
    }

    public void resetBuildingPlan() {
        this.buildingPlan.clear();
    }

    public SOCRobotDM getDecisionMaker() {
        return this.decisionMaker;
    }

    public OpeningBuildStrategy getOpeningBuildStrategy() {
        return this.openingBuildStrategy;
    }

    public void turnOnDRecorder() {
        this.dRecorder[0].turnOn();
        this.dRecorder[1].turnOn();
    }

    public void turnOffDRecorder() {
        this.dRecorder[0].turnOff();
        this.dRecorder[1].turnOff();
    }

    public DebugRecorder getDRecorder() {
        return this.dRecorder[this.currentDRecorder];
    }

    public DebugRecorder getOldDRecorder() {
        return this.dRecorder[(this.currentDRecorder + 1) % 2];
    }

    public SOCPossiblePiece getLastMove() {
        return this.lastMove;
    }

    public SOCPossiblePiece getLastTarget() {
        return this.lastTarget;
    }

    public void setOurPlayerData() {
        int faceId;
        this.ourPlayerData = this.game.getPlayer(this.client.getNickname());
        this.ourPlayerTracker = new SOCPlayerTracker(this.ourPlayerData, this);
        this.ourPlayerNumber = this.ourPlayerData.getPlayerNumber();
        this.playerTrackers = new SOCPlayerTracker[this.game.maxPlayers];
        this.playerTrackers[this.ourPlayerNumber] = this.ourPlayerTracker;
        for (int pn = 0; pn < this.game.maxPlayers; ++pn) {
            SOCPlayerTracker tracker;
            if (pn == this.ourPlayerNumber || this.game.isSeatVacant(pn)) continue;
            this.playerTrackers[pn] = tracker = new SOCPlayerTracker(this.game.getPlayer(pn), this);
        }
        this.setStrategyFields();
        this.dummyCancelPlayerData = new SOCPlayer(-2, this.game);
        switch (this.getRobotParameters().getStrategyType()) {
            case 0: {
                faceId = -1;
                break;
            }
            default: {
                faceId = 0;
            }
        }
        if (this.ourPlayerData.getFaceId() != faceId) {
            this.ourPlayerData.setFaceId(faceId);
        }
    }

    protected void setStrategyFields() {
        this.decisionMaker = this.createDM();
        this.negotiator = this.createNegotiator();
        this.bseFactory = this.createEstimatorFactory();
        this.discardStrategy = new DiscardStrategy(this.game, this.ourPlayerData, this, this.rand);
        this.monopolyStrategy = new MonopolyStrategy(this.game, this.ourPlayerData, this);
        this.openingBuildStrategy = new OpeningBuildStrategy(this.game, this.ourPlayerData, this);
        this.robberStrategy = new RobberStrategy(this.game, this.ourPlayerData, this, this.rand);
    }

    public List<String> debugPrintBrainStatus(boolean withMessages) {
        boolean[] b;
        String[] s;
        ArrayList<String> rbSta = new ArrayList<String>();
        if (this.ourPlayerData == null || this.game == null) {
            rbSta.add("Robot internal state: Cannot print: null game or player");
            return rbSta;
        }
        rbSta.add("Robot internal state: " + (this.client != null ? this.client.getNickname() : this.ourPlayerData.getName()) + " in game " + this.game.getName() + ": gs=" + this.game.getGameState());
        if (this.waitingForPickSpecialItem != null) {
            rbSta.add("  waitingForPickSpecialItem = " + this.waitingForPickSpecialItem);
        }
        if (this.game.getGameState() == 50) {
            rbSta.add("  bot resource count = " + this.ourPlayerData.getResources().getTotal());
        }
        if (this.rejectedPlayDevCardType != -1) {
            rbSta.add("  rejectedPlayDevCardType = " + this.rejectedPlayDevCardType);
        }
        if (this.rejectedPlayInvItem != null) {
            rbSta.add("  rejectedPlayInvItem = " + this.rejectedPlayInvItem);
        }
        if ((s = new String[]{"ourTurn", "doneTrading", "waitingForGameState", "waitingForOurTurn", "waitingForTurnMain", "waitingForTradeMsg", "waitingForDevCard", "waitingForTradeResponse", "waitingForSC_PIRI_FortressRequest", "moveRobberOnSeven", "expectSTART1A", "expectSTART1B", "expectSTART2A", "expectSTART2B", "expectSTART3A", "expectSTART3B", "expectROLL_OR_CARD", "expectPLAY1", "expectPLACING_ROAD", "expectPLACING_SETTLEMENT", "expectPLACING_CITY", "expectPLACING_SHIP", "expectPLACING_ROBBER", "expectPLACING_FREE_ROAD1", "expectPLACING_FREE_ROAD2", "expectPLACING_INV_ITEM", "expectPUTPIECE_FROM_START1A", "expectPUTPIECE_FROM_START1B", "expectPUTPIECE_FROM_START2A", "expectPUTPIECE_FROM_START2B", "expectPUTPIECE_FROM_START3A", "expectPUTPIECE_FROM_START3B", "expectDICERESULT", "expectDISCARD", "expectMOVEROBBER", "expectWAITING_FOR_DISCOVERY", "expectWAITING_FOR_MONOPOLY"}).length != (b = new boolean[]{this.ourTurn, this.doneTrading, this.waitingForGameState, this.waitingForOurTurn, this.waitingForTurnMain, this.waitingForTradeMsg, this.waitingForDevCard, this.waitingForTradeResponse, this.waitingForSC_PIRI_FortressRequest, this.moveRobberOnSeven, this.expectSTART1A, this.expectSTART1B, this.expectSTART2A, this.expectSTART2B, this.expectSTART3A, this.expectSTART3B, this.expectROLL_OR_CARD, this.expectPLAY1, this.expectPLACING_ROAD, this.expectPLACING_SETTLEMENT, this.expectPLACING_CITY, this.expectPLACING_SHIP, this.expectPLACING_ROBBER, this.expectPLACING_FREE_ROAD1, this.expectPLACING_FREE_ROAD2, this.expectPLACING_INV_ITEM, this.expectPUTPIECE_FROM_START1A, this.expectPUTPIECE_FROM_START1B, this.expectPUTPIECE_FROM_START2A, this.expectPUTPIECE_FROM_START2B, this.expectPUTPIECE_FROM_START3A, this.expectPUTPIECE_FROM_START3B, this.expectDICERESULT, this.expectDISCARD, this.expectMOVEROBBER, this.expectWAITING_FOR_DISCOVERY, this.expectWAITING_FOR_MONOPOLY}).length) {
            rbSta.add("L745: Internal error: array length");
            return rbSta;
        }
        int slen = 0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length; ++i) {
            if (slen + s[i].length() + 8 > 79) {
                rbSta.add(sb.toString());
                slen = 0;
                sb.delete(0, sb.length());
            }
            sb.append("  ");
            sb.append(s[i]);
            sb.append(": ");
            if (b[i]) {
                sb.append("TRUE");
            } else {
                sb.append("false");
            }
            slen = sb.length();
        }
        if (slen > 0) {
            rbSta.add(sb.toString());
        }
        if (withMessages) {
            SOCRobotBrain.debugPrintTurnMessages(this.turnEventsPrev, "previous", rbSta);
            SOCRobotBrain.debugPrintTurnMessages(this.turnEventsCurrent, "current", rbSta);
        }
        return rbSta;
    }

    protected static void debugPrintTurnMessages(List<?> msgV, String msgDesc, List<String> toList) {
        int n = msgV.size();
        if (n == 0) {
            toList.add("  " + msgDesc + " turn: No messages received.");
        } else {
            toList.add("  " + msgDesc + " turn: " + n + " messages received:");
            for (int i = 0; i < n; ++i) {
                toList.add("\t" + msgV.get(i));
            }
        }
    }

    @Override
    public void run() {
        try {
            Thread.currentThread().setName("robotBrain-" + this.client.getNickname() + "-" + this.game.getName());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.pinger != null) {
            this.pinger.start();
            while (this.alive) {
                try {
                    int mesType;
                    SOCMessage mes = this.gameEventQ.get();
                    if (mes != null) {
                        mesType = mes.getType();
                        if (mesType != 1088) {
                            this.turnEventsCurrent.addElement(mes);
                        }
                    } else {
                        mesType = -1;
                    }
                    if (this.waitingForTradeMsg && this.counter > 10) {
                        this.waitingForTradeMsg = false;
                        this.counter = 0;
                    }
                    if (this.waitingForTradeResponse && this.counter > this.tradeResponseTimeoutSec) {
                        this.tradeStopWaitingClearOffer();
                    }
                    if (this.waitingForGameState && this.counter > 10000) {
                        this.counter = 0;
                        this.client.resend();
                    }
                    if (mesType == 1025) {
                        this.handleGAMESTATE(((SOCGameState)mes).getState());
                    } else if (mesType == 1018) {
                        SOCDisplaylessPlayerClient.handleSTARTGAME_checkIsBotsOnly(this.game);
                        this.handleGAMESTATE(((SOCStartGame)mes).getGameState());
                    } else if (mesType == 1026) {
                        this.handleGAMESTATE(((SOCTurn)mes).getGameState());
                        this.game.setCurrentPlayerNumber(((SOCTurn)mes).getPlayerNumber());
                        this.game.updateAtTurn();
                        this.resetFieldsAndBuildingPlan();
                        Vector<SOCMessage> oldPrev = this.turnEventsPrev;
                        this.turnEventsPrev = this.turnEventsCurrent;
                        oldPrev.clear();
                        this.turnEventsCurrent = oldPrev;
                        this.turnExceptionCount = 0;
                    } else if (mesType == 1061) {
                        this.handleGAMESTATS((SOCGameStats)mes);
                    }
                    if (this.game.getCurrentPlayerNumber() == this.ourPlayerNumber) {
                        this.ourTurn = true;
                        this.waitingForSpecialBuild = false;
                    } else {
                        this.ourTurn = false;
                    }
                    if (mesType == 1026 && this.ourTurn) {
                        this.waitingForOurTurn = false;
                        this.whatWeFailedToBuild = null;
                        this.failedBuildingAttempts = 0;
                        this.failedBankTrades = 0;
                        this.rejectedPlayDevCardType = -1;
                        this.rejectedPlayInvItem = null;
                    }
                    boolean isDataUpdateOnly = false;
                    switch (mesType) {
                        case 1024: {
                            this.handlePLAYERELEMENT((SOCPlayerElement)mes);
                            break;
                        }
                        case 1086: {
                            this.handlePLAYERELEMENTS((SOCPlayerElements)mes);
                            break;
                        }
                        case 1063: {
                            this.handlePLAYERELEMENT(null, ((SOCResourceCount)mes).getPlayerNumber(), 100, SOCPlayerElement.PEType.RESOURCE_COUNT, ((SOCResourceCount)mes).getCount());
                            break;
                        }
                        case 1028: {
                            this.handleDICERESULT((SOCDiceResult)mes);
                            break;
                        }
                        case 1092: {
                            SOCDisplaylessPlayerClient.handleDICERESULTRESOURCES((SOCDiceResultResources)mes, this.game, this.ourPlayerName, false);
                            isDataUpdateOnly = true;
                            break;
                        }
                        case 1009: {
                            this.handlePUTPIECE_updateGameData((SOCPutPiece)mes);
                            break;
                        }
                        case 1093: {
                            SOCMovePiece mpm = (SOCMovePiece)mes;
                            SOCShip sh = new SOCShip(this.game.getPlayer(mpm.getPlayerNumber()), mpm.getFromCoord(), null);
                            this.game.moveShip(sh, mpm.getToCoord());
                            break;
                        }
                        case 1044: {
                            this.handleCANCELBUILDREQUEST((SOCCancelBuildRequest)mes);
                            break;
                        }
                        case 1105: {
                            this.handleUNDOPUTPIECE((SOCUndoPutPiece)mes);
                            break;
                        }
                        case 1033: {
                            SOCDisplaylessPlayerClient.handleDISCARD((SOCDiscard)mes, this.game);
                            isDataUpdateOnly = true;
                            break;
                        }
                        case 1034: {
                            this.robberMoved(((SOCMoveRobber)mes).getCoordinates());
                            break;
                        }
                        case 1041: {
                            if (this.robotParameters.getTradeFlag() == 1) {
                                this.handleMAKEOFFER((SOCMakeOffer)mes);
                                break;
                            }
                            isDataUpdateOnly = true;
                            break;
                        }
                        case 1038: {
                            if (this.robotParameters.getTradeFlag() == 1) {
                                int pn = ((SOCClearOffer)mes).getPlayerNumber();
                                if (pn != -1) {
                                    this.game.getPlayer(pn).setCurrentOffer(null);
                                    break;
                                }
                                for (int i = 0; i < this.game.maxPlayers; ++i) {
                                    this.game.getPlayer(i).setCurrentOffer(null);
                                }
                                break;
                            }
                            isDataUpdateOnly = true;
                            break;
                        }
                        case 1039: {
                            int acceptingPN;
                            SOCDisplaylessPlayerClient.handleACCEPTOFFER((SOCAcceptOffer)mes, this.game);
                            if (!this.waitingForTradeResponse || this.robotParameters.getTradeFlag() != 1 || this.ourPlayerNumber != (acceptingPN = ((SOCAcceptOffer)mes).getAcceptingNumber()) && this.ourPlayerNumber != ((SOCAcceptOffer)mes).getOfferingNumber()) break;
                            this.handleTradeResponse(acceptingPN, true);
                            break;
                        }
                        case 1037: {
                            if (this.robotParameters.getTradeFlag() == 1) {
                                this.handleREJECTOFFER((SOCRejectOffer)mes);
                                break;
                            }
                            isDataUpdateOnly = true;
                            break;
                        }
                        case 1046: {
                            SOCDevCardAction dcMes = (SOCDevCardAction)mes;
                            if (dcMes.getAction() != 4) {
                                this.handleDEVCARDACTION(dcMes);
                                break;
                            }
                            this.rejectedPlayDevCardType = dcMes.getCardType();
                            this.waitingForGameState = false;
                            this.expectPLACING_FREE_ROAD1 = false;
                            this.expectWAITING_FOR_DISCOVERY = false;
                            this.expectWAITING_FOR_MONOPOLY = false;
                            this.expectPLACING_ROBBER = false;
                            break;
                        }
                        case 1089: {
                            SOCSimpleRequest rqMes;
                            SOCDisplaylessPlayerClient.handleSIMPLEREQUEST((SOCSimpleRequest)mes, this.game);
                            if (!this.ourTurn || !this.waitingForSC_PIRI_FortressRequest || (rqMes = (SOCSimpleRequest)mes).getRequestType() != 1000 || rqMes.getPlayerNumber() != -1) break;
                            this.waitingForSC_PIRI_FortressRequest = false;
                            this.resetFieldsAtEndTurn();
                            this.client.endTurn(this.game);
                            break;
                        }
                        case 1090: {
                            SOCDisplaylessPlayerClient.handleSIMPLEACTION((SOCSimpleAction)mes, this.game);
                            if (((SOCSimpleAction)mes).getPlayerNumber() != this.ourPlayerNumber) {
                                isDataUpdateOnly = true;
                            }
                            switch (((SOCSimpleAction)mes).getActionType()) {
                                case 1001: {
                                    if (!this.ourTurn || !this.waitingForSC_PIRI_FortressRequest) break;
                                    this.waitingForSC_PIRI_FortressRequest = false;
                                    this.resetFieldsAtEndTurn();
                                    isDataUpdateOnly = false;
                                }
                            }
                            break;
                        }
                        case 1098: {
                            if (((SOCInventoryItemAction)mes).action == 5) {
                                List<SOCInventoryItem> itms = this.ourPlayerData.getInventory().getByStateAndType(2, ((SOCInventoryItemAction)mes).itemType);
                                if (itms != null) {
                                    this.rejectedPlayInvItem = itms.get(0);
                                }
                                this.waitingForGameState = false;
                                this.expectPLACING_INV_ITEM = false;
                                break;
                            }
                            isDataUpdateOnly = true;
                            break;
                        }
                        case 1102: {
                            this.handleROBBERYRESULT((SOCRobberyResult)mes);
                            if (((SOCRobberyResult)mes).victimPN == this.ourPlayerNumber) break;
                            isDataUpdateOnly = true;
                            break;
                        }
                        case 1103: {
                            this.handleBOTGAMEDATACHECK(((SOCBotGameDataCheck)mes).getDataType(), ((SOCBotGameDataCheck)mes).getValues());
                            isDataUpdateOnly = true;
                            break;
                        }
                        case 1104: {
                            this.handleDECLINEPLAYERREQUEST((SOCDeclinePlayerRequest)mes);
                        }
                    }
                    if (isDataUpdateOnly) continue;
                    this.debugInfo();
                    if (this.game.getGameState() == 15 && !this.waitingForGameState) {
                        this.rollOrPlayKnightOrExpectDice();
                    }
                    if (this.ourTurn && this.game.getGameState() == 54 && !this.waitingForGameState) {
                        this.expectPLACING_ROBBER = true;
                        this.waitingForGameState = true;
                        this.counter = 0;
                        this.client.choosePlayer(this.game, -2);
                        this.pause(200);
                    } else if (this.game.getGameState() == 33 && !this.waitingForGameState) {
                        if (!this.waitingForOurTurn && this.ourTurn && (!this.expectROLL_OR_CARD && !this.expectPLAY1 || this.counter >= 4000)) {
                            this.moveRobber();
                            this.counter = 0;
                            if (this.moveRobberOnSeven) {
                                this.moveRobberOnSeven = false;
                                this.waitingForGameState = true;
                                this.expectPLAY1 = true;
                            } else {
                                this.waitingForGameState = true;
                                if (this.oldGameState == 15) {
                                    this.expectROLL_OR_CARD = true;
                                } else if (this.oldGameState == 20) {
                                    this.expectPLAY1 = true;
                                }
                            }
                        }
                        this.expectPLACING_ROBBER = false;
                    }
                    if (this.game.getGameState() == 52 && !this.waitingForGameState) {
                        this.expectWAITING_FOR_DISCOVERY = false;
                        if (!this.waitingForOurTurn && this.ourTurn && !this.expectPLAY1 && this.counter < 4000) {
                            this.waitingForGameState = true;
                            this.expectPLAY1 = true;
                            this.counter = 0;
                            this.client.pickResources(this.game, this.decisionMaker.resourceChoices);
                            this.pause(1500);
                        }
                    }
                    if (this.game.getGameState() == 53 && !this.waitingForGameState) {
                        this.expectWAITING_FOR_MONOPOLY = false;
                        if (!this.waitingForOurTurn && this.ourTurn && !this.expectPLAY1 && this.counter < 4000) {
                            this.waitingForGameState = true;
                            this.expectPLAY1 = true;
                            this.counter = 0;
                            this.client.pickResourceType(this.game, this.monopolyStrategy.getMonopolyChoice());
                            this.pause(1500);
                        }
                    }
                    if (this.ourTurn && !this.waitingForOurTurn && this.game.getGameState() == 42 && !this.waitingForGameState) {
                        this.planAndPlaceInvItem();
                    }
                    if (mesType == 1040) {
                        int pn;
                        SOCDisplaylessPlayerClient.handleBANKTRADE((SOCBankTrade)mes, this.game);
                        if (this.waitingForTradeMsg && (pn = ((SOCBankTrade)mes).getPlayerNumber()) == this.ourPlayerNumber) {
                            this.clearTradingFlags(true, true, true);
                        }
                    }
                    if (this.waitingForDevCard && mesType == 1090 && ((SOCSimpleAction)mes).getPlayerNumber() == this.ourPlayerNumber && ((SOCSimpleAction)mes).getActionType() == 1) {
                        this.waitingForDevCard = false;
                    }
                    if (!(this.game.getGameState() != 20 && this.game.getGameState() != 100 || this.waitingForGameState || this.waitingForTradeMsg || this.waitingForTradeResponse || this.waitingForDevCard || this.expectPLACING_ROAD || this.expectPLACING_SETTLEMENT || this.expectPLACING_CITY || this.expectPLACING_SHIP || this.expectPLACING_FREE_ROAD1 || this.expectPLACING_FREE_ROAD2 || this.expectPLACING_ROBBER || this.expectWAITING_FOR_DISCOVERY || this.expectWAITING_FOR_MONOPOLY || this.waitingForSC_PIRI_FortressRequest || this.waitingForPickSpecialItem != null)) {
                        this.expectPLAY1 = false;
                        if (!this.ourTurn && this.waitingForOurTurn && this.gameIs6Player && !this.decidedIfSpecialBuild && !this.expectPLACING_ROBBER) {
                            this.decidedIfSpecialBuild = true;
                            if (this.buildingPlan.isEmpty() && this.ourPlayerData.getResources().getTotal() > 1 && this.failedBuildingAttempts < MAX_DENIED_BUILDING_PER_TURN && (!this.game.isGameOptionSet("PLP") || this.game.getPlayerCount() >= 5)) {
                                this.planBuilding();
                                if (!this.buildingPlan.isEmpty()) {
                                    SOCPossiblePiece targetPiece = this.buildingPlan.getFirstPiece();
                                    SOCResourceSet targetResources = targetPiece.getResourcesToBuild();
                                    if (this.ourPlayerData.getResources().contains(targetResources)) {
                                        this.waitingForSpecialBuild = true;
                                        this.client.buildRequest(this.game, -1);
                                        this.pause(100);
                                    }
                                }
                            }
                        }
                        if (!(this.waitingForOurTurn || !this.ourTurn || this.expectROLL_OR_CARD && this.counter < 4000)) {
                            this.counter = 0;
                            this.planAndDoActionForPLAY1();
                        }
                    }
                    if (!this.waitingForGameState) {
                        this.placeIfExpectPlacing();
                    }
                    switch (mesType) {
                        case 1009: {
                            SOCPutPiece mpp = (SOCPutPiece)mes;
                            int pn = mpp.getPlayerNumber();
                            int coord = mpp.getCoordinates();
                            int pieceType = mpp.getPieceType();
                            this.handlePUTPIECE_updateTrackers(pn, coord, pieceType);
                            break;
                        }
                        case 1093: {
                            SOCMovePiece mpp = (SOCMovePiece)mes;
                            int pn = mpp.getPlayerNumber();
                            int coord = mpp.getToCoord();
                            int pieceType = mpp.getPieceType();
                            this.handlePUTPIECE_updateTrackers(pn, coord, pieceType);
                            break;
                        }
                        case 1028: {
                            if (!this.expectDICERESULT) break;
                            this.expectDICERESULT = false;
                            if (((SOCDiceResult)mes).getResult() == 7) {
                                boolean robWithoutRobber = this.game.isGameOptionSet("_SC_PIRI");
                                if (!robWithoutRobber) {
                                    this.moveRobberOnSeven = true;
                                }
                                if (this.ourPlayerData.getResources().getTotal() > 7) {
                                    this.expectDISCARD = true;
                                    break;
                                }
                                if (!this.ourTurn) break;
                                if (!robWithoutRobber) {
                                    this.expectPLACING_ROBBER = true;
                                    break;
                                }
                                this.expectPLAY1 = true;
                                break;
                            }
                            this.expectPLAY1 = true;
                            break;
                        }
                        case 1089: {
                            SOCSimpleRequest rqMes = (SOCSimpleRequest)mes;
                            switch (rqMes.getRequestType()) {
                                case 1: {
                                    this.counter = 0;
                                    if (this.buildingPlan.isEmpty()) {
                                        this.planBuilding();
                                    }
                                    this.client.pickResources(this.game, this.decisionMaker.pickFreeResources(rqMes.getValue1()));
                                    this.waitingForGameState = true;
                                    if (this.game.isInitialPlacement()) {
                                        if (this.game.isGameOptionSet("_SC_3IP")) {
                                            this.expectSTART3B = true;
                                            break;
                                        }
                                        this.expectSTART2B = true;
                                        break;
                                    }
                                    this.expectPLAY1 = true;
                                }
                            }
                            break;
                        }
                        case 1029: {
                            this.expectDISCARD = false;
                            if (this.game.getCurrentDice() == 7 && this.ourTurn) {
                                if (!this.game.isGameOptionSet("_SC_PIRI")) {
                                    this.expectPLACING_ROBBER = true;
                                } else {
                                    this.expectPLAY1 = true;
                                }
                            } else {
                                this.expectPLAY1 = true;
                            }
                            this.counter = 0;
                            this.discard(((SOCDiscardRequest)mes).getNumberOfDiscards());
                            break;
                        }
                        case 1036: {
                            SOCChoosePlayerRequest msg = (SOCChoosePlayerRequest)mes;
                            int choicePl = this.robberStrategy.chooseRobberVictim(msg.getChoices(), msg.canChooseNone());
                            this.counter = 0;
                            this.client.choosePlayer(this.game, choicePl);
                            break;
                        }
                        case 1035: {
                            int vpn = ((SOCChoosePlayer)mes).getChoice();
                            this.client.choosePlayer(this.game, -(vpn + 1));
                            break;
                        }
                        case 1099: {
                            if (this.waitingForPickSpecialItem == null) break;
                            SOCSetSpecialItem siMes = (SOCSetSpecialItem)mes;
                            if (siMes.typeKey.equals(this.waitingForPickSpecialItem)) {
                                switch (siMes.op) {
                                    case 3: {
                                        this.waitingForPickSpecialItem = null;
                                        break;
                                    }
                                    case 4: {
                                        this.waitingForPickSpecialItem = null;
                                    }
                                }
                            }
                            break;
                        }
                        case 1056: {
                            if (this.expectDISCARD || this.expectPLACING_ROBBER) break;
                            this.client.leaveGame(this.game, "dismiss msg", false, false);
                            this.alive = false;
                            break;
                        }
                        case 1088: {
                            ++this.counter;
                        }
                    }
                    if (this.ourTurn && this.counter > 15000) {
                        this.client.leaveGame(this.game, "counter 15000", true, false);
                        this.alive = false;
                    }
                    if (this.failedBuildingAttempts > 2 * MAX_DENIED_BUILDING_PER_TURN && this.game.isInitialPlacement()) {
                        this.client.leaveGame(this.game, "failedBuildingAttempts at start", true, false);
                        this.alive = false;
                    }
                    Thread.yield();
                }
                catch (Exception e) {
                    if (!this.alive || this.game != null && this.game.getGameState() == 1001) continue;
                    ++this.turnExceptionCount;
                    String eMsg = this.turnExceptionCount == 1 ? "*** Robot " + this.ourPlayerName + " caught an exception - " + e : "*** Robot " + this.ourPlayerName + " caught an exception (" + this.turnExceptionCount + " this turn) - " + e;
                    D.ebugPrintlnINFO(eMsg);
                    System.err.println(eMsg);
                    e.printStackTrace();
                }
            }
        } else {
            System.err.println("AGG! NO PINGER!");
        }
        this.gameEventQ = null;
        this.client.addCleanKill();
        this.client = null;
        this.game = null;
        this.ourPlayerData = null;
        this.dummyCancelPlayerData = null;
        this.whatWeWantToBuild = null;
        this.whatWeFailedToBuild = null;
        this.rejectedPlayInvItem = null;
        this.ourPlayerTracker = null;
        this.playerTrackers = null;
        this.pinger.stopPinger();
        this.pinger = null;
    }

    protected void handleGAMESTATE(int newState) {
        if (newState == 0) {
            return;
        }
        this.waitingForGameState = newState == 990 || newState == 992;
        int currGS = this.game.getGameState();
        if (currGS != newState) {
            this.oldGameState = currGS;
        }
        SOCDisplaylessPlayerClient.handleGAMESTATE(this.game, newState);
        if (newState == 15) {
            this.waitingForTurnMain = true;
        } else if (newState == 20 && this.waitingForTurnMain) {
            this.startTurnMainActions();
            this.waitingForTurnMain = false;
        }
    }

    protected void handleBOTGAMEDATACHECK(int dtype, int[] values) {
        if (dtype != 1) {
            return;
        }
        StringBuilder problems = null;
        for (int i = 0; i < values.length; i += 6) {
            int res;
            int pn = values[i];
            SOCResourceSet plRes = this.game.getPlayer(pn).getResources();
            int[] expected = new int[]{values[i + 1], values[i + 2], values[i + 3], values[i + 4], values[i + 5]};
            int localUnknown = plRes.getAmount(6);
            boolean playerOK = true;
            for (res = 1; res <= 5; ++res) {
                int missingAmt = expected[res - 1] - plRes.getAmount(res);
                if (missingAmt < 0) {
                    playerOK = false;
                    break;
                }
                if (missingAmt <= 0) continue;
                if (missingAmt <= localUnknown) {
                    localUnknown -= missingAmt;
                    continue;
                }
                playerOK = false;
                break;
            }
            if (localUnknown != 0) {
                playerOK = false;
            }
            if (playerOK) continue;
            if (problems == null) {
                problems = new StringBuilder();
            }
            problems.append("pn=" + pn);
            if (pn == this.ourPlayerNumber) {
                problems.append(" self");
            }
            problems.append(": Expected ").append(Arrays.toString(expected)).append(", has [").append(plRes).append("]. ");
            for (res = 1; res <= 5; ++res) {
                plRes.setAmount(expected[res - 1], res);
            }
            plRes.setAmount(0, 6);
        }
        if (problems != null) {
            ArrayList<String> rbSta = new ArrayList<String>();
            SOCRobotBrain.debugPrintTurnMessages(this.turnEventsPrev, "previous", rbSta);
            SOCRobotBrain.debugPrintTurnMessages(this.turnEventsCurrent, "current", rbSta);
            StringBuilder sb = new StringBuilder();
            sb.append("\nBot " + this.client.getNickname() + " in " + this.game.getName() + ": Resource mismatch server/client: " + problems + "\n");
            for (String st : rbSta) {
                sb.append(st).append('\n');
            }
            System.err.println(sb);
        }
    }

    protected void handleDECLINEPLAYERREQUEST(SOCDeclinePlayerRequest mes) {
        this.resetFieldsAndBuildingPlan();
        ++this.failedBuildingAttempts;
        int currState = mes.gameState;
        if (currState != 0 && currState != this.game.getGameState()) {
            this.handleGAMESTATE(currState);
        }
    }

    protected void resetFieldsAndBuildingPlan() {
        this.expectROLL_OR_CARD = false;
        this.expectPLAY1 = false;
        this.expectPLACING_ROAD = false;
        this.expectPLACING_SETTLEMENT = false;
        this.expectPLACING_CITY = false;
        this.expectPLACING_SHIP = false;
        this.expectPLACING_ROBBER = false;
        this.expectPLACING_FREE_ROAD1 = false;
        this.expectPLACING_FREE_ROAD2 = false;
        this.expectPLACING_INV_ITEM = false;
        this.expectDICERESULT = false;
        this.expectDISCARD = false;
        this.expectMOVEROBBER = false;
        this.expectWAITING_FOR_DISCOVERY = false;
        this.expectWAITING_FOR_MONOPOLY = false;
        this.setDoneTrading(this.robotParameters.getTradeFlag() == 0);
        this.waitingForTradeMsg = false;
        this.waitingForTradeResponse = false;
        this.declinedOurPlayerTrades = 0;
        this.negotiator.resetIsSelling();
        this.negotiator.resetOffersMade();
        this.waitingForPickSpecialItem = null;
        this.waitingForSC_PIRI_FortressRequest = false;
        this.decidedIfSpecialBuild = false;
        if (this.game.getGameState() == 100) {
            if (this.waitingForSpecialBuild && !this.buildingPlan.isEmpty()) {
                // empty if block
            }
        } else {
            this.resetBuildingPlan();
        }
        this.negotiator.resetTargetPieces();
    }

    protected void resetFieldsAtEndTurn() {
        this.waitingForGameState = true;
        this.counter = 0;
        this.expectROLL_OR_CARD = true;
        this.waitingForOurTurn = true;
        this.setDoneTrading(this.robotParameters.getTradeFlag() == 0);
        this.negotiator.resetIsSelling();
        this.negotiator.resetOffersMade();
        this.resetBuildingPlan();
        this.negotiator.resetTargetPieces();
    }

    protected boolean considerScenarioTurnFinalActions() {
        if (this.game.isGameOptionSet("_SC_FTRI")) {
            SOCInventoryItem itm = null;
            for (SOCInventoryItem i : this.ourPlayerData.getInventory().getByState(2)) {
                if (i.itype > 0 || this.rejectedPlayInvItem != null && i.itype == this.rejectedPlayInvItem.itype) continue;
                itm = i;
                break;
            }
            if (itm != null) {
                if (this.ourPlayerData.getPortMovePotentialLocations(false) == null) {
                    return false;
                }
                return this.planAndPlaceInvItemPlacement_SC_FTRI(itm);
            }
        } else {
            if (this.ourPlayerData.getNumWarships() < 5 || null == this.game.canAttackPirateFortress()) {
                return false;
            }
            this.waitingForSC_PIRI_FortressRequest = true;
            this.client.simpleRequest(this.game, this.ourPlayerNumber, 1000, 0, 0);
            return true;
        }
        return false;
    }

    protected void planAndDoActionForPLAY1() {
        if (this.game.getGameState() == 20 && !this.ourPlayerData.hasPlayedDevCard()) {
            this.playKnightCardIfShould();
        }
        if (!this.expectPLACING_ROBBER && this.buildingPlan.isEmpty() && this.ourPlayerData.getResources().getTotal() > 1 && this.failedBuildingAttempts < MAX_DENIED_BUILDING_PER_TURN) {
            this.planBuilding();
        }
        if (!this.expectPLACING_ROBBER && !this.buildingPlan.isEmpty()) {
            this.buildOrGetResourceByTradeOrCard();
        }
        if (!(this.expectPLACING_SETTLEMENT || this.expectPLACING_FREE_ROAD1 || this.expectPLACING_FREE_ROAD2 || this.expectPLACING_ROAD || this.expectPLACING_CITY || this.expectPLACING_SHIP || this.expectWAITING_FOR_DISCOVERY || this.expectWAITING_FOR_MONOPOLY || this.expectPLACING_ROBBER || this.waitingForTradeMsg || this.waitingForTradeResponse || this.waitingForDevCard || this.waitingForGameState || this.waitingForPickSpecialItem != null)) {
            boolean finishTurnNow;
            boolean scenActionTaken = false;
            if (this.game.isGameOptionSet("_SC_FTRI") || this.game.isGameOptionSet("_SC_PIRI")) {
                scenActionTaken = this.considerScenarioTurnFinalActions();
            }
            boolean bl = finishTurnNow = !scenActionTaken && this.endTurnActions();
            if (finishTurnNow) {
                this.resetFieldsAtEndTurn();
                this.pause(1500);
                this.client.endTurn(this.game);
            }
        }
    }

    protected void handleDICERESULT(SOCDiceResult mes) {
        this.game.setCurrentDice(mes.getResult());
    }

    protected void robberMoved(int newHex) {
        this.moveRobberOnSeven = false;
        this.game.setPlacingRobberForKnightCard(false);
        this.game.setLastAction(null);
        if (newHex > 0) {
            this.game.getBoard().setRobberHex(newHex, true);
        } else {
            ((SOCBoardLarge)this.game.getBoard()).setPirateHex(-newHex, true);
        }
    }

    protected void handleROBBERYRESULT(SOCRobberyResult mes) {
        SOCDisplaylessPlayerClient.handleROBBERYRESULT(mes, this.game);
    }

    protected void tradeStopWaitingClearOffer() {
        SOCTradeOffer ourCurrentOffer = this.ourPlayerData.getCurrentOffer();
        if (ourCurrentOffer != null) {
            this.negotiator.recordResourcesFromNoResponse(ourCurrentOffer);
            this.pause(1500);
            this.client.clearOffer(this.game);
            this.pause(500);
        }
        this.counter = 0;
        this.waitingForTradeResponse = false;
    }

    private void playKnightCardIfShould() {
        boolean canGrowArmy;
        if (!this.game.canPlayKnight(this.ourPlayerNumber)) {
            return;
        }
        if (this.game.isGameOptionSet("_SC_PIRI")) {
            boolean anyOpponentHasRsrcs = false;
            for (int pn = 0; pn < this.game.maxPlayers; ++pn) {
                if (pn == this.ourPlayerNumber || this.game.isSeatVacant(pn) || this.game.getPlayer(pn).getResources().getTotal() <= 0) continue;
                anyOpponentHasRsrcs = true;
                break;
            }
            canGrowArmy = anyOpponentHasRsrcs;
        } else {
            canGrowArmy = this.decisionMaker.shouldPlayKnightForLA();
        }
        if (canGrowArmy && this.rejectedPlayDevCardType != 9) {
            this.playKnightCard();
        }
    }

    protected void placeIfExpectPlacing() {
        if (this.waitingForGameState) {
            return;
        }
        switch (this.game.getGameState()) {
            case 31: {
                if (!this.ourTurn || this.waitingForOurTurn || !this.expectPLACING_SETTLEMENT) break;
                this.expectPLACING_SETTLEMENT = false;
                this.waitingForGameState = true;
                this.counter = 0;
                this.expectPLAY1 = true;
                this.pause(500);
                this.client.putPiece(this.game, this.whatWeWantToBuild);
                this.pause(1000);
                break;
            }
            case 30: {
                if (!this.ourTurn || this.waitingForOurTurn || !this.expectPLACING_ROAD) break;
                this.expectPLACING_ROAD = false;
                this.waitingForGameState = true;
                this.counter = 0;
                this.expectPLAY1 = true;
                this.pause(500);
                this.client.putPiece(this.game, this.whatWeWantToBuild);
                this.pause(1000);
                break;
            }
            case 32: {
                if (!this.ourTurn || this.waitingForOurTurn || !this.expectPLACING_CITY) break;
                this.expectPLACING_CITY = false;
                this.waitingForGameState = true;
                this.counter = 0;
                this.expectPLAY1 = true;
                this.pause(500);
                this.client.putPiece(this.game, this.whatWeWantToBuild);
                this.pause(1000);
                break;
            }
            case 35: {
                if (!this.ourTurn || this.waitingForOurTurn || !this.expectPLACING_SHIP) break;
                this.expectPLACING_SHIP = false;
                this.waitingForGameState = true;
                this.counter = 0;
                this.expectPLAY1 = true;
                this.pause(500);
                this.client.putPiece(this.game, this.whatWeWantToBuild);
                this.pause(1000);
                break;
            }
            case 40: {
                if (!this.ourTurn || this.waitingForOurTurn || !this.expectPLACING_FREE_ROAD1) break;
                this.expectPLACING_FREE_ROAD1 = false;
                this.waitingForGameState = true;
                this.counter = 0;
                this.expectPLACING_FREE_ROAD2 = true;
                this.pause(500);
                this.client.putPiece(this.game, this.whatWeWantToBuild);
                this.pause(1000);
                break;
            }
            case 41: {
                if (!this.ourTurn || this.waitingForOurTurn || !this.expectPLACING_FREE_ROAD2) break;
                this.expectPLACING_FREE_ROAD2 = false;
                this.waitingForGameState = true;
                this.counter = 0;
                this.expectPLAY1 = true;
                SOCPossiblePiece posPiece = this.buildingPlan.advancePlan();
                this.whatWeWantToBuild = posPiece.getType() == 0 ? new SOCRoad(this.ourPlayerData, posPiece.getCoordinates(), null) : new SOCShip(this.ourPlayerData, posPiece.getCoordinates(), null);
                this.pause(500);
                this.client.putPiece(this.game, this.whatWeWantToBuild);
                this.pause(1000);
                break;
            }
            case 5: {
                if (!(this.waitingForOurTurn || !this.ourTurn || this.expectPUTPIECE_FROM_START1A && this.counter < 4000)) {
                    int firstSettleNode = this.openingBuildStrategy.planInitialSettlements();
                    this.placeFirstSettlement(firstSettleNode);
                    this.expectPUTPIECE_FROM_START1A = true;
                    this.waitingForGameState = true;
                    this.counter = 0;
                }
                this.expectSTART1A = false;
                break;
            }
            case 6: {
                if (!(this.waitingForOurTurn || !this.ourTurn || this.expectPUTPIECE_FROM_START1B && this.counter < 4000)) {
                    this.planAndPlaceInitRoad();
                    this.expectPUTPIECE_FROM_START1B = true;
                    this.counter = 0;
                    this.waitingForGameState = true;
                    this.waitingForOurTurn = true;
                    this.pause(1500);
                }
                this.expectSTART1B = false;
                break;
            }
            case 10: {
                if (!(this.waitingForOurTurn || !this.ourTurn || this.expectPUTPIECE_FROM_START2A && this.counter < 4000)) {
                    int secondSettleNode = this.openingBuildStrategy.planSecondSettlement();
                    this.placeInitSettlement(secondSettleNode);
                    this.expectPUTPIECE_FROM_START2A = true;
                    this.counter = 0;
                    this.waitingForGameState = true;
                }
                this.expectSTART2A = false;
                break;
            }
            case 11: {
                if (!(this.waitingForOurTurn || !this.ourTurn || this.expectPUTPIECE_FROM_START2B && this.counter < 4000)) {
                    this.planAndPlaceInitRoad();
                    this.expectPUTPIECE_FROM_START2B = true;
                    this.counter = 0;
                    this.waitingForGameState = true;
                    this.waitingForOurTurn = true;
                    this.pause(1500);
                }
                this.expectSTART2B = false;
                break;
            }
            case 12: {
                if (!(this.waitingForOurTurn || !this.ourTurn || this.expectPUTPIECE_FROM_START3A && this.counter < 4000)) {
                    int secondSettleNode = this.openingBuildStrategy.planSecondSettlement();
                    this.placeInitSettlement(secondSettleNode);
                    this.expectPUTPIECE_FROM_START3A = true;
                    this.counter = 0;
                    this.waitingForGameState = true;
                }
                this.expectSTART3A = false;
                break;
            }
            case 13: {
                if (!(this.waitingForOurTurn || !this.ourTurn || this.expectPUTPIECE_FROM_START3B && this.counter < 4000)) {
                    this.planAndPlaceInitRoad();
                    this.expectPUTPIECE_FROM_START3B = true;
                    this.counter = 0;
                    this.waitingForGameState = true;
                    this.waitingForOurTurn = true;
                    this.pause(1500);
                }
                this.expectSTART3B = false;
            }
        }
    }

    private void playKnightCard() {
        this.expectPLACING_ROBBER = true;
        this.waitingForGameState = true;
        this.counter = 0;
        this.client.playDevCard(this.game, 9);
        this.pause(1500);
    }

    protected void rollOrPlayKnightOrExpectDice() {
        this.expectROLL_OR_CARD = false;
        if (!this.waitingForOurTurn && this.ourTurn) {
            if (!(this.expectPLAY1 || this.expectDISCARD || this.expectPLACING_ROBBER || this.expectDICERESULT && this.counter < 4000)) {
                if (this.ourPlayerData.getInventory().hasPlayable(9) && this.rejectedPlayDevCardType != 9 && !this.game.isGameOptionSet("_SC_PIRI") && !this.ourPlayerData.getNumbers().hasNoResourcesForHex(this.game.getBoard().getRobberHex())) {
                    this.playKnightCard();
                } else {
                    this.expectDICERESULT = true;
                    this.counter = 0;
                    this.client.rollDice(this.game);
                }
            }
        } else {
            this.expectDICERESULT = true;
        }
    }

    protected void buildOrGetResourceByTradeOrCard() throws IllegalStateException {
        SOCPossiblePiece secondPiece;
        SOCPossiblePiece topPiece;
        if (this.buildingPlan.isEmpty()) {
            throw new IllegalStateException("buildingPlan empty when called");
        }
        boolean gameStatePLAY1 = this.game.getGameState() == 20;
        boolean roadBuildingPlan = false;
        if (gameStatePLAY1 && !this.ourPlayerData.hasPlayedDevCard() && this.ourPlayerData.getNumPieces(0) >= 2 && this.ourPlayerData.getInventory().hasPlayable(1) && this.rejectedPlayDevCardType != 1 && (topPiece = this.buildingPlan.getPlannedPiece(0)) != null && topPiece instanceof SOCPossibleRoad && this.buildingPlan.getPlanDepth() > 1 && (secondPiece = this.buildingPlan.getPlannedPiece(1)) != null && secondPiece instanceof SOCPossibleRoad) {
            roadBuildingPlan = true;
            this.whatWeWantToBuild = topPiece instanceof SOCPossibleShip && !((SOCPossibleShip)topPiece).isCoastalRoadAndShip && secondPiece instanceof SOCPossibleShip && !((SOCPossibleShip)secondPiece).isCoastalRoadAndShip ? new SOCShip(this.ourPlayerData, topPiece.getCoordinates(), null) : new SOCRoad(this.ourPlayerData, topPiece.getCoordinates(), null);
            if (!this.whatWeWantToBuild.equals(this.whatWeFailedToBuild)) {
                this.waitingForGameState = true;
                this.counter = 0;
                this.expectPLACING_FREE_ROAD1 = true;
                this.buildingPlan.advancePlan();
                this.client.playDevCard(this.game, 1);
            } else {
                roadBuildingPlan = false;
                this.cancelWrongPiecePlacementLocal(this.whatWeWantToBuild);
            }
        }
        if (roadBuildingPlan) {
            return;
        }
        SOCPossiblePiece targetPiece = this.buildingPlan.getFirstPiece();
        SOCResourceSet targetResources = targetPiece.getResourcesToBuild();
        this.negotiator.setTargetPiece(this.ourPlayerNumber, this.buildingPlan);
        if (gameStatePLAY1 && !this.ourPlayerData.hasPlayedDevCard() && this.ourPlayerData.getInventory().hasPlayable(2) && this.rejectedPlayDevCardType != 2 && this.decisionMaker.chooseFreeResourcesIfNeeded(targetResources, 2, false)) {
            this.expectWAITING_FOR_DISCOVERY = true;
            this.waitingForGameState = true;
            this.counter = 0;
            this.client.playDevCard(this.game, 2);
            this.pause(1500);
        }
        if (!this.expectWAITING_FOR_DISCOVERY) {
            if (gameStatePLAY1 && !this.ourPlayerData.hasPlayedDevCard() && this.ourPlayerData.getInventory().hasPlayable(3) && this.rejectedPlayDevCardType != 3 && this.monopolyStrategy.decidePlayMonopoly()) {
                this.expectWAITING_FOR_MONOPOLY = true;
                this.waitingForGameState = true;
                this.counter = 0;
                this.client.playDevCard(this.game, 3);
                this.pause(1500);
            }
            if (!this.expectWAITING_FOR_MONOPOLY) {
                if (gameStatePLAY1 && !this.doneTrading && !this.ourPlayerData.getResources().contains(targetResources)) {
                    this.waitingForTradeResponse = false;
                    if (this.robotParameters.getTradeFlag() == 1) {
                        if (this.declinedOurPlayerTrades < MAX_DENIED_PLAYER_TRADES_PER_TURN) {
                            this.makeOffer(this.buildingPlan);
                        } else {
                            this.setDoneTrading(true);
                        }
                    }
                }
                if (gameStatePLAY1 && !this.waitingForTradeResponse && this.failedBankTrades < MAX_DENIED_BANK_TRADES_PER_TURN && this.tradeWithBank(this.buildingPlan)) {
                    this.counter = 0;
                    this.waitingForTradeMsg = true;
                }
                if (!this.waitingForTradeMsg && !this.waitingForTradeResponse && this.ourPlayerData.getResources().contains(targetResources)) {
                    this.buildRequestPlannedPiece();
                }
            }
        }
    }

    protected void planAndPlaceInvItem() throws IllegalStateException {
        if (this.waitingForGameState) {
            throw new IllegalStateException();
        }
        SOCInventoryItem itm = this.game.getPlacingItem();
        if (itm == null) {
            return;
        }
        if (this.game.isGameOptionSet("_SC_FTRI")) {
            this.planAndPlaceInvItemPlacement_SC_FTRI(itm);
        } else {
            System.err.println("L2720: Game " + this.game.getName() + " bot " + this.client.getNickname() + ": No PLACING_INV_ITEM handler for scenario " + this.game.getGameOptionStringValue("SC"));
        }
    }

    private boolean planAndPlaceInvItemPlacement_SC_FTRI(SOCInventoryItem itm) {
        if (itm == null) {
            return false;
        }
        if (this.rejectedPlayInvItem != null && itm.itype == this.rejectedPlayInvItem.itype) {
            return false;
        }
        List<Integer> edges = this.ourPlayerData.getPortMovePotentialLocations(true);
        if (edges.isEmpty()) {
            this.rejectedPlayInvItem = itm;
            return false;
        }
        int ptype = itm.itype;
        this.waitingForGameState = true;
        this.counter = 0;
        if (this.game.getGameState() == 42) {
            int edge = edges.get(0);
            this.expectPLAY1 = true;
            this.client.simpleRequest(this.game, this.ourPlayerNumber, 1001, edge, 0);
        } else {
            this.expectPLACING_INV_ITEM = true;
            this.client.playInventoryItem(this.game, this.ourPlayerNumber, ptype);
        }
        this.pause(1000);
        return true;
    }

    protected void handlePUTPIECE_updateGameData(SOCPutPiece mes) {
        switch (mes.getPieceType()) {
            case 0: 
            case 3: {
                SOCPlayerTracker tr;
                SOCSettlement se;
                if (!this.game.isInitialPlacement() || (se = (tr = this.playerTrackers[mes.getPlayerNumber()]).getPendingInitSettlement()) == null) break;
                this.trackNewSettlement(se, false);
            }
        }
        SOCDisplaylessPlayerClient.handlePUTPIECE(mes, this.game);
    }

    protected void handleCANCELBUILDREQUEST(SOCCancelBuildRequest mes) {
        int gstate = this.game.getGameState();
        switch (gstate) {
            case 5: 
            case 10: 
            case 12: {
                if (!this.ourTurn) break;
                this.cancelWrongPiecePlacement(mes);
                break;
            }
            case 6: 
            case 11: 
            case 13: {
                if (this.ourTurn) {
                    this.cancelWrongPiecePlacement(mes);
                    break;
                }
                int pnum = this.game.getCurrentPlayerNumber();
                SOCPlayer pl = this.game.getPlayer(pnum);
                SOCSettlement pp = new SOCSettlement(pl, pl.getLastSettlementCoord(), null);
                this.game.undoPutInitSettlement(pp);
                SOCPlayerTracker tr = this.playerTrackers[pnum];
                tr.setPendingInitSettlement(null);
                break;
            }
            case 20: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 40: 
            case 41: 
            case 100: {
                this.cancelWrongPiecePlacement(mes);
                break;
            }
            default: {
                if (this.game.isSpecialBuilding()) {
                    this.cancelWrongPiecePlacement(mes);
                    break;
                }
                System.err.println("L2521 SOCRobotBrain: " + this.client.getNickname() + ": Unhandled CANCELBUILDREQUEST(" + mes.getPieceType() + ") at state " + gstate);
            }
        }
    }

    private void handleUNDOPUTPIECE(SOCUndoPutPiece mes) {
        SOCDisplaylessPlayerClient.handleUNDOPUTPIECE(mes, this.game);
        this.resetBuildingPlan();
    }

    protected void handleTradeResponse(int toPlayerNum, boolean accepted) {
        if (accepted) {
            this.clearTradingFlags(false, true, true);
            return;
        }
        this.offerRejections[toPlayerNum] = true;
        SOCTradeOffer ourOffer = this.ourPlayerData.getCurrentOffer();
        boolean everyoneRejected = true;
        boolean allHumansRejected = this.tradeResponseTimeoutSec > 5;
        D.ebugPrintlnINFO("ourPlayerData.getCurrentOffer() = " + ourOffer);
        if (ourOffer != null) {
            boolean[] offeredTo = ourOffer.getTo();
            for (int pn = 0; pn < this.game.maxPlayers; ++pn) {
                D.ebugPrintlnINFO("offerRejections[" + pn + "]=" + this.offerRejections[pn]);
                if (!offeredTo[pn] || this.offerRejections[pn]) continue;
                everyoneRejected = false;
                if (!allHumansRejected || this.game.getPlayer(pn).isRobot()) continue;
                allHumansRejected = false;
            }
        } else {
            this.clearTradingFlags(false, true, true);
        }
        D.ebugPrintlnINFO("everyoneRejected=" + everyoneRejected);
        if (everyoneRejected) {
            this.negotiator.addToOffersMade(ourOffer);
            this.client.clearOffer(this.game);
            this.waitingForTradeResponse = false;
        } else if (allHumansRejected) {
            this.tradeResponseTimeoutSec = 5;
        }
    }

    protected void handleMAKEOFFER(SOCMakeOffer mes) {
        SOCTradeOffer offer = mes.getOffer();
        int fromPN = offer.getFrom();
        SOCPlayer offeredFromPlayer = this.game.getPlayer(fromPN);
        offeredFromPlayer.setCurrentOffer(offer);
        if (fromPN == this.ourPlayerNumber) {
            return;
        }
        this.negotiator.recordResourcesFromOffer(offer);
        if (this.waitingForTradeResponse) {
            this.offerRejections[fromPN] = true;
            boolean everyoneRejected = true;
            D.ebugPrintlnINFO("ourPlayerData.getCurrentOffer() = " + this.ourPlayerData.getCurrentOffer());
            if (this.ourPlayerData.getCurrentOffer() != null) {
                boolean[] offeredTo = this.ourPlayerData.getCurrentOffer().getTo();
                for (int i = 0; i < this.game.maxPlayers; ++i) {
                    D.ebugPrintlnINFO("offerRejections[" + i + "]=" + this.offerRejections[i]);
                    if (!offeredTo[i] || this.offerRejections[i]) continue;
                    everyoneRejected = false;
                }
            }
            D.ebugPrintlnINFO("everyoneRejected=" + everyoneRejected);
            if (everyoneRejected) {
                this.negotiator.addToOffersMade(this.ourPlayerData.getCurrentOffer());
                this.client.clearOffer(this.game);
                this.waitingForTradeResponse = false;
            }
        }
        int ourResponseToOffer = this.considerOffer(offer);
        D.ebugPrintlnINFO("%%% ourResponseToOffer = " + ourResponseToOffer);
        if (ourResponseToOffer < 0) {
            return;
        }
        long offeredAt = offeredFromPlayer.getCurrentOfferTime();
        int currentPN = this.game.getCurrentPlayerNumber();
        int delayLength = Math.abs(this.rand.nextInt() % 500) + 3500;
        if (this.pauseFaster && !this.waitingForTradeResponse) {
            delayLength *= 2;
        }
        if (ourResponseToOffer == 1) {
            boolean[] offeredTo = offer.getTo();
            for (int i = 0; i < offeredTo.length; ++i) {
                if (!offeredTo[i] || this.game.getPlayer(i).isRobot()) continue;
                delayLength += (BOTS_PAUSE_FOR_HUMAN_TRADE - 3) * 1000;
                break;
            }
        }
        this.pause(delayLength);
        if (currentPN != this.game.getCurrentPlayerNumber()) {
            return;
        }
        if (offeredAt != offeredFromPlayer.getCurrentOfferTime()) {
            offer = offeredFromPlayer.getCurrentOffer();
            if (offer == null || !offer.getTo()[this.ourPlayerNumber]) {
                return;
            }
            ourResponseToOffer = this.considerOffer(offer);
        }
        switch (ourResponseToOffer) {
            case 1: {
                this.client.acceptOffer(this.game, fromPN);
                this.resetBuildingPlan();
                this.negotiator.setTargetPiece(this.ourPlayerNumber, (SOCBuildPlan)null);
                break;
            }
            case 0: {
                if (this.waitingForTradeResponse) break;
                this.client.rejectOffer(this.game);
                break;
            }
            case 2: {
                boolean madeCounter;
                if (this.declinedOurPlayerTrades < MAX_DENIED_PLAYER_TRADES_PER_TURN) {
                    madeCounter = this.makeCounterOffer(offer);
                } else {
                    madeCounter = false;
                    this.setDoneTrading(true);
                }
                if (madeCounter) break;
                this.client.rejectOffer(this.game);
            }
        }
    }

    protected void handleREJECTOFFER(SOCRejectOffer mes) {
        int rejector = mes.getPlayerNumber();
        int reasonCode = mes.getReasonCode();
        if (rejector < 0 || reasonCode != 0) {
            if (this.waitingForTradeMsg) {
                ++this.failedBankTrades;
            } else {
                ++this.declinedOurPlayerTrades;
            }
            if (reasonCode != 3) {
                this.clearTradingFlags(rejector < 0, false, true);
            } else {
                this.clearTradingFlags(false, false, false);
            }
            return;
        }
        if (this.waitingForTradeResponse) {
            this.negotiator.recordResourcesFromReject(rejector);
            this.handleTradeResponse(rejector, false);
        } else {
            this.negotiator.recordResourcesFromRejectAlt(rejector);
        }
    }

    protected void handleDEVCARDACTION(SOCDevCardAction mes) {
        if (mes.getCardTypes() != null) {
            return;
        }
        int cardType = mes.getCardType();
        SOCPlayer pl = this.game.getPlayer(mes.getPlayerNumber());
        SOCInventory cardsInv = pl.getInventory();
        switch (mes.getAction()) {
            case 0: {
                cardsInv.addDevCard(1, 1, cardType);
                break;
            }
            case 1: {
                cardsInv.removeDevCard(0, cardType);
                pl.updateDevCardsPlayed(cardType, false);
                if (cardType != 9 || this.game.isGameOptionSet("_SC_PIRI")) break;
                this.game.setPlacingRobberForKnightCard(true);
                break;
            }
            case 3: {
                cardsInv.addDevCard(1, 0, cardType);
                break;
            }
            case 2: {
                cardsInv.addDevCard(1, 1, cardType);
                break;
            }
            case 6: {
                cardsInv.removeDevCard(0, cardType);
                break;
            }
            case 5: {
                cardsInv.removeDevCard(1, cardType);
            }
        }
    }

    public void handlePUTPIECE_updateTrackers(int pn, int coord, int pieceType) {
        switch (pieceType) {
            case 0: {
                SOCRoad newRoad = new SOCRoad(this.game.getPlayer(pn), coord, null);
                this.trackNewRoadOrShip(newRoad, false);
                break;
            }
            case 1: {
                SOCPlayer newSettlementPl = this.game.getPlayer(pn);
                SOCSettlement newSettlement = new SOCSettlement(newSettlementPl, coord, null);
                if (this.game.getGameState() == 6 || this.game.getGameState() == 11 || this.game.getGameState() == 13) {
                    SOCPlayerTracker tr = this.playerTrackers[newSettlementPl.getPlayerNumber()];
                    tr.setPendingInitSettlement(newSettlement);
                    break;
                }
                this.trackNewSettlement(newSettlement, false);
                break;
            }
            case 2: {
                SOCCity newCity = new SOCCity(this.game.getPlayer(pn), coord, null);
                this.trackNewCity(newCity, false);
                break;
            }
            case 3: {
                SOCShip newShip = new SOCShip(this.game.getPlayer(pn), coord, null);
                this.trackNewRoadOrShip(newShip, false);
                break;
            }
            case 5: {
                return;
            }
        }
        if (pn != this.ourPlayerNumber) {
            return;
        }
        if (this.expectPUTPIECE_FROM_START1A && pieceType == 1 && coord == this.ourPlayerData.getLastSettlementCoord()) {
            this.expectPUTPIECE_FROM_START1A = false;
            this.expectSTART1B = true;
        }
        if (this.expectPUTPIECE_FROM_START1B && (pieceType == 0 || pieceType == 3) && coord == this.ourPlayerData.getLastRoadCoord()) {
            this.expectPUTPIECE_FROM_START1B = false;
            this.expectSTART2A = true;
        }
        if (this.expectPUTPIECE_FROM_START2A && pieceType == 1 && coord == this.ourPlayerData.getLastSettlementCoord()) {
            this.expectPUTPIECE_FROM_START2A = false;
            this.expectSTART2B = true;
        }
        if (this.expectPUTPIECE_FROM_START2B && (pieceType == 0 || pieceType == 3) && coord == this.ourPlayerData.getLastRoadCoord()) {
            this.expectPUTPIECE_FROM_START2B = false;
            if (!this.game.isGameOptionSet("_SC_3IP")) {
                this.expectROLL_OR_CARD = true;
            } else {
                this.expectSTART3A = true;
            }
        }
        if (this.expectPUTPIECE_FROM_START3A && pieceType == 1 && coord == this.ourPlayerData.getLastSettlementCoord()) {
            this.expectPUTPIECE_FROM_START3A = false;
            this.expectSTART3B = true;
        }
        if (this.expectPUTPIECE_FROM_START3B && (pieceType == 0 || pieceType == 3) && coord == this.ourPlayerData.getLastRoadCoord()) {
            this.expectPUTPIECE_FROM_START3B = false;
            this.expectROLL_OR_CARD = true;
        }
    }

    protected void buildRequestPlannedPiece() {
        SOCPossiblePiece targetPiece = this.buildingPlan.advancePlan();
        D.ebugPrintlnINFO("$ POPPED " + targetPiece);
        this.lastMove = targetPiece;
        this.currentDRecorder = (this.currentDRecorder + 1) % 2;
        this.negotiator.setTargetPiece(this.ourPlayerNumber, targetPiece);
        switch (targetPiece.getType()) {
            case -2: {
                this.client.buyDevCard(this.game);
                this.waitingForDevCard = true;
                break;
            }
            case 0: {
                this.waitingForGameState = true;
                this.counter = 0;
                this.expectPLACING_ROAD = true;
                this.whatWeWantToBuild = new SOCRoad(this.ourPlayerData, targetPiece.getCoordinates(), null);
                if (!this.whatWeWantToBuild.equals(this.whatWeFailedToBuild)) {
                    D.ebugPrintlnINFO("!!! BUILD REQUEST FOR A ROAD AT " + Integer.toHexString(targetPiece.getCoordinates()) + " !!!");
                    this.client.buildRequest(this.game, 0);
                    break;
                }
                this.cancelWrongPiecePlacementLocal(this.whatWeWantToBuild);
                break;
            }
            case 1: {
                this.waitingForGameState = true;
                this.counter = 0;
                this.expectPLACING_SETTLEMENT = true;
                this.whatWeWantToBuild = new SOCSettlement(this.ourPlayerData, targetPiece.getCoordinates(), null);
                if (!this.whatWeWantToBuild.equals(this.whatWeFailedToBuild)) {
                    D.ebugPrintlnINFO("!!! BUILD REQUEST FOR A SETTLEMENT " + Integer.toHexString(targetPiece.getCoordinates()) + " !!!");
                    this.client.buildRequest(this.game, 1);
                    break;
                }
                this.cancelWrongPiecePlacementLocal(this.whatWeWantToBuild);
                break;
            }
            case 2: {
                this.waitingForGameState = true;
                this.counter = 0;
                this.expectPLACING_CITY = true;
                this.whatWeWantToBuild = new SOCCity(this.ourPlayerData, targetPiece.getCoordinates(), null);
                if (!this.whatWeWantToBuild.equals(this.whatWeFailedToBuild)) {
                    D.ebugPrintlnINFO("!!! BUILD REQUEST FOR A CITY " + Integer.toHexString(targetPiece.getCoordinates()) + " !!!");
                    this.client.buildRequest(this.game, 2);
                    break;
                }
                this.cancelWrongPiecePlacementLocal(this.whatWeWantToBuild);
                break;
            }
            case 3: {
                this.waitingForGameState = true;
                this.counter = 0;
                this.expectPLACING_SHIP = true;
                this.whatWeWantToBuild = new SOCShip(this.ourPlayerData, targetPiece.getCoordinates(), null);
                if (!this.whatWeWantToBuild.equals(this.whatWeFailedToBuild)) {
                    this.client.buildRequest(this.game, 3);
                    break;
                }
                this.cancelWrongPiecePlacementLocal(this.whatWeWantToBuild);
                break;
            }
            case -3: {
                SOCPossiblePickSpecialItem psi = (SOCPossiblePickSpecialItem)targetPiece;
                this.waitingForPickSpecialItem = psi.typeKey;
                this.whatWeWantToBuild = null;
                this.counter = 0;
                this.client.pickSpecialItem(this.game, psi.typeKey, psi.gi, psi.pi);
                break;
            }
            default: {
                System.err.println(this.ourPlayerData.getName() + ": buildRequestPlannedPiece: Unknown piece type " + targetPiece.getType());
            }
        }
    }

    protected void planBuilding() {
        this.decisionMaker.planStuff(this.robotParameters.getStrategyType());
        if (!this.buildingPlan.isEmpty()) {
            this.lastTarget = this.buildingPlan.getFirstPiece();
            this.negotiator.setTargetPiece(this.ourPlayerNumber, this.buildingPlan);
        }
    }

    protected void handlePLAYERELEMENTS(SOCPlayerElements mes) {
        int pn = mes.getPlayerNumber();
        SOCPlayer pl = pn != -1 ? this.game.getPlayer(pn) : null;
        int action = mes.getAction();
        int[] etypes = mes.getElementTypes();
        int[] amounts = mes.getAmounts();
        for (int i = 0; i < etypes.length; ++i) {
            this.handlePLAYERELEMENT(pl, pn, action, SOCPlayerElement.PEType.valueOf(etypes[i]), amounts[i]);
        }
        if (action == 100 && etypes.length == 5 && etypes[0] == 1 && pl != null && this.game.getGameState() == 15) {
            pl.getResources().setAmount(0, 6);
        }
    }

    protected void handlePLAYERELEMENT(SOCPlayerElement mes) {
        int pn = mes.getPlayerNumber();
        int action = mes.getAction();
        int amount = mes.getAmount();
        SOCPlayerElement.PEType etype = SOCPlayerElement.PEType.valueOf(mes.getElementType());
        this.handlePLAYERELEMENT(null, pn, action, etype, amount);
    }

    protected void handlePLAYERELEMENT(SOCPlayer pl, int pn, int action, SOCPlayerElement.PEType etype, int amount) {
        if (etype == null) {
            return;
        }
        if (pl == null && pn != -1) {
            pl = this.game.getPlayer(pn);
        }
        switch (etype) {
            case ROADS: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numPieces(pl, action, 0, amount);
                break;
            }
            case SETTLEMENTS: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numPieces(pl, action, 1, amount);
                break;
            }
            case CITIES: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numPieces(pl, action, 2, amount);
                break;
            }
            case SHIPS: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numPieces(pl, action, 3, amount);
                break;
            }
            case NUMKNIGHTS: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numKnights(this.game, pl, action, amount);
                break;
            }
            case CLAY: {
                this.handlePLAYERELEMENT_numRsrc(pl, action, 1, "CLAY", amount);
                break;
            }
            case ORE: {
                this.handlePLAYERELEMENT_numRsrc(pl, action, 2, "ORE", amount);
                break;
            }
            case SHEEP: {
                this.handlePLAYERELEMENT_numRsrc(pl, action, 3, "SHEEP", amount);
                break;
            }
            case WHEAT: {
                this.handlePLAYERELEMENT_numRsrc(pl, action, 4, "WHEAT", amount);
                break;
            }
            case WOOD: {
                this.handlePLAYERELEMENT_numRsrc(pl, action, 5, "WOOD", amount);
                break;
            }
            case UNKNOWN_RESOURCE: {
                this.handlePLAYERELEMENT_numRsrc(pl, action, 6, "UNKNOWN", amount);
                break;
            }
            case RESOURCE_COUNT: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_simple(this.game, pl, pn, action, etype, amount, this.ourPlayerName);
                break;
            }
            case SCENARIO_WARSHIP_COUNT: {
                if (this.expectPLACING_ROBBER && action == 101) {
                    this.expectPLACING_ROBBER = false;
                    this.waitingForGameState = false;
                }
            }
            default: {
                SOCDisplaylessPlayerClient.handlePLAYERELEMENT_simple(this.game, pl, pn, action, etype, amount, this.ourPlayerName);
            }
        }
        if (this.game.getGameState() == 15) {
            this.negotiator.resetIsSelling();
        }
    }

    protected void handlePLAYERELEMENT_numRsrc(SOCPlayer pl, int action, int rtype, String rtypeStr, int amount) {
        this.handleResources(action, pl, rtype, amount);
        if (this.waitingForSpecialBuild && pl == this.ourPlayerData && action != 101 && !this.buildingPlan.isEmpty()) {
            SOCPossiblePiece targetPiece = this.buildingPlan.getFirstPiece();
            SOCResourceSet targetResources = targetPiece.getResourcesToBuild();
            if (!this.ourPlayerData.getResources().contains(targetResources)) {
                this.resetBuildingPlan();
            }
        }
    }

    protected void trackNewSettlement(SOCSettlement newSettlement, boolean isCancel) {
        int pNum;
        SOCPlayerTracker tracker;
        for (SOCPlayerTracker tracker2 : this.playerTrackers) {
            if (tracker2 == null) continue;
            if (!isCancel) {
                tracker2.addNewSettlement(newSettlement, this.playerTrackers);
                continue;
            }
            tracker2.cancelWrongSettlement(newSettlement);
        }
        for (SOCPlayerTracker tracker2 : this.playerTrackers) {
            if (tracker2 == null) continue;
            Iterator<SOCPossibleRoad> posRoadsIter = tracker2.getPossibleRoads().values().iterator();
            while (posRoadsIter.hasNext()) {
                posRoadsIter.next().clearThreats();
            }
            Iterator<SOCPossibleSettlement> posSetsIter = tracker2.getPossibleSettlements().values().iterator();
            while (posSetsIter.hasNext()) {
                posSetsIter.next().clearThreats();
            }
        }
        for (SOCPlayerTracker tracker2 : this.playerTrackers) {
            if (tracker2 == null) continue;
            tracker2.updateThreats(this.playerTrackers);
        }
        if (isCancel) {
            return;
        }
        int[] roadCount = new int[]{0, 0, 0, 0, 0, 0};
        SOCBoard board = this.game.getBoard();
        for (int adjEdge : board.getAdjacentEdgesToNode(newSettlement.getCoordinates())) {
            SOCPlayerTracker tracker3;
            int roadPN;
            SOCRoutePiece rs = board.roadOrShipAtEdge(adjEdge);
            if (rs == null) continue;
            int n = roadPN = rs.getPlayerNumber();
            roadCount[n] = roadCount[n] + 1;
            if (roadCount[roadPN] != 2) continue;
            if (roadPN == this.ourPlayerNumber || (tracker3 = this.playerTrackers[roadPN]) != null) {
                // empty if block
            } else {
                break;
            }
        }
        if ((tracker = this.playerTrackers[pNum = newSettlement.getPlayerNumber()]) != null) {
            Iterator<SOCPossibleSettlement> posSetsIter = tracker.getPossibleSettlements().values().iterator();
            while (posSetsIter.hasNext()) {
                posSetsIter.next().updateSpeedup();
            }
        }
        if (tracker != null) {
            Iterator<SOCPossibleCity> posCitiesIter = tracker.getPossibleCities().values().iterator();
            while (posCitiesIter.hasNext()) {
                posCitiesIter.next().updateSpeedup();
            }
        }
    }

    protected void trackNewCity(SOCCity newCity, boolean isCancel) {
        int newCityPN = newCity.getPlayerNumber();
        for (SOCPlayerTracker tracker : this.playerTrackers) {
            if (tracker == null || tracker.getPlayer().getPlayerNumber() != newCityPN) continue;
            if (!isCancel) {
                tracker.addOurNewCity(newCity);
                break;
            }
            tracker.cancelWrongCity(newCity);
            break;
        }
        if (isCancel) {
            return;
        }
        for (SOCPlayerTracker tracker : this.playerTrackers) {
            if (tracker == null || tracker.getPlayer().getPlayerNumber() != newCityPN) continue;
            Iterator<SOCPossibleSettlement> posSetsIter = tracker.getPossibleSettlements().values().iterator();
            while (posSetsIter.hasNext()) {
                posSetsIter.next().updateSpeedup();
            }
            break;
        }
        for (SOCPlayerTracker tracker : this.playerTrackers) {
            if (tracker == null || tracker.getPlayer().getPlayerNumber() != newCityPN) continue;
            Iterator<SOCPossibleCity> posCitiesIter = tracker.getPossibleCities().values().iterator();
            while (posCitiesIter.hasNext()) {
                posCitiesIter.next().updateSpeedup();
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackNewRoadOrShip(SOCRoutePiece newPiece, boolean isCancel) {
        int newRoadPN = newPiece.getPlayerNumber();
        for (SOCPlayerTracker tracker : this.playerTrackers) {
            if (tracker == null) continue;
            tracker.takeMonitor();
            try {
                if (!isCancel) {
                    tracker.addNewRoadOrShip(newPiece, this.playerTrackers);
                    continue;
                }
                tracker.cancelWrongRoadOrShip(newPiece);
            }
            catch (Exception e) {
                if (!this.alive) continue;
                System.out.println("Exception caught - " + e);
                e.printStackTrace();
            }
            finally {
                tracker.releaseMonitor();
            }
        }
        for (SOCPlayerTracker tracker : this.playerTrackers) {
            if (tracker == null) continue;
            tracker.takeMonitor();
            try {
                Iterator<SOCPossibleRoad> posRoadsIter = tracker.getPossibleRoads().values().iterator();
                while (posRoadsIter.hasNext()) {
                    posRoadsIter.next().clearThreats();
                }
                Iterator<SOCPossibleSettlement> posSetsIter = tracker.getPossibleSettlements().values().iterator();
                while (posSetsIter.hasNext()) {
                    posSetsIter.next().clearThreats();
                }
            }
            catch (Exception e) {
                if (!this.alive) continue;
                System.out.println("Exception caught - " + e);
                e.printStackTrace();
            }
            finally {
                tracker.releaseMonitor();
            }
        }
        for (SOCPlayerTracker tracker : this.playerTrackers) {
            if (tracker == null) continue;
            tracker.updateThreats(this.playerTrackers);
            tracker.takeMonitor();
            try {
                if (tracker.getPlayer().getPlayerNumber() != newRoadPN) continue;
            }
            catch (Exception e) {
                if (!this.alive) continue;
                System.out.println("Exception caught - " + e);
                e.printStackTrace();
            }
            finally {
                tracker.releaseMonitor();
            }
        }
    }

    protected void cancelWrongPiecePlacement(SOCCancelBuildRequest mes) {
        int ptype;
        boolean gameStateIsPLAY1;
        boolean cancelBuyDevCard;
        boolean bl = cancelBuyDevCard = mes.getPieceType() == -2;
        if (cancelBuyDevCard) {
            this.waitingForDevCard = false;
        } else {
            this.whatWeFailedToBuild = this.whatWeWantToBuild;
            ++this.failedBuildingAttempts;
        }
        this.waitingForGameState = false;
        int gameState = this.game.getGameState();
        boolean bl2 = gameStateIsPLAY1 = gameState == 20;
        if (!gameStateIsPLAY1 && !cancelBuyDevCard) {
            int coord = -1;
            switch (gameState) {
                case 5: 
                case 6: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    coord = this.lastStartingPieceCoord;
                    break;
                }
                default: {
                    if (this.whatWeWantToBuild == null) break;
                    coord = this.whatWeWantToBuild.getCoordinates();
                }
            }
            if (coord != -1) {
                SOCPlayingPiece cancelPiece;
                switch (mes.getPieceType()) {
                    case 0: {
                        cancelPiece = new SOCRoad(this.dummyCancelPlayerData, coord, null);
                        break;
                    }
                    case 1: {
                        cancelPiece = new SOCSettlement(this.dummyCancelPlayerData, coord, null);
                        break;
                    }
                    case 2: {
                        cancelPiece = new SOCCity(this.dummyCancelPlayerData, coord, null);
                        break;
                    }
                    case 3: {
                        cancelPiece = new SOCShip(this.dummyCancelPlayerData, coord, null);
                        break;
                    }
                    default: {
                        cancelPiece = null;
                    }
                }
                this.cancelWrongPiecePlacementLocal(cancelPiece);
            }
        } else {
            this.whatWeWantToBuild = null;
            this.resetBuildingPlan();
        }
        if (gameStateIsPLAY1 || this.game.isSpecialBuilding()) {
            this.failedBuildingAttempts = MAX_DENIED_BUILDING_PER_TURN;
            this.expectPLACING_ROAD = false;
            this.expectPLACING_SETTLEMENT = false;
            this.expectPLACING_CITY = false;
            this.expectPLACING_SHIP = false;
            this.decidedIfSpecialBuild = true;
            if (!cancelBuyDevCard && (ptype = mes.getPieceType()) != -1) {
                this.waitingForGameState = true;
                this.expectPLAY1 = true;
                this.client.cancelBuildRequest(this.game, ptype);
            }
        } else if (gameState <= 13) {
            switch (gameState) {
                case 5: {
                    this.expectPUTPIECE_FROM_START1A = false;
                    this.expectSTART1A = true;
                    break;
                }
                case 6: {
                    this.expectPUTPIECE_FROM_START1B = false;
                    this.expectSTART1B = true;
                    break;
                }
                case 10: {
                    this.expectPUTPIECE_FROM_START2A = false;
                    this.expectSTART2A = true;
                    break;
                }
                case 11: {
                    this.expectPUTPIECE_FROM_START2B = false;
                    this.expectSTART2B = true;
                    break;
                }
                case 12: {
                    this.expectPUTPIECE_FROM_START3A = false;
                    this.expectSTART3A = true;
                    break;
                }
                case 13: {
                    this.expectPUTPIECE_FROM_START3B = false;
                    this.expectSTART3B = true;
                }
            }
        } else {
            ptype = mes.getPieceType();
            if (ptype != -1) {
                this.expectPLAY1 = true;
                this.waitingForGameState = true;
                this.counter = 0;
                this.client.cancelBuildRequest(this.game, ptype);
            } else {
                this.whatWeWantToBuild = null;
                this.resetBuildingPlan();
            }
        }
    }

    protected void cancelWrongPiecePlacementLocal(SOCPlayingPiece cancelPiece) {
        if (cancelPiece != null) {
            int coord = cancelPiece.getCoordinates();
            switch (cancelPiece.getType()) {
                case 0: 
                case 3: {
                    this.trackNewRoadOrShip((SOCRoutePiece)cancelPiece, true);
                    if (cancelPiece.getType() == 0) {
                        this.ourPlayerData.clearPotentialRoad(coord);
                        break;
                    }
                    this.ourPlayerData.clearPotentialShip(coord);
                    break;
                }
                case 1: {
                    this.trackNewSettlement((SOCSettlement)cancelPiece, true);
                    this.ourPlayerData.clearPotentialSettlement(coord);
                    break;
                }
                case 2: {
                    this.trackNewCity((SOCCity)cancelPiece, true);
                    this.ourPlayerData.clearPotentialCity(coord);
                }
            }
            if (this.game.getGameState() <= 13) {
                this.openingBuildStrategy.cancelWrongPiecePlacement(cancelPiece);
            }
        }
        this.whatWeWantToBuild = null;
        this.resetBuildingPlan();
    }

    public void kill() {
        SOCRobotPinger p = this.pinger;
        this.alive = false;
        try {
            if (p != null) {
                p.stopPinger();
            }
            this.gameEventQ.put(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pause(int msec) {
        if (this.game.isBotsOnly) {
            if ((msec = (int)((float)msec * BOTS_ONLY_FAST_PAUSE_FACTOR)) == 0) {
                return;
            }
        } else if (this.pauseFaster && !this.waitingForTradeResponse) {
            msec = msec / 2 + msec / 4;
        }
        try {
            Thread.yield();
            if (msec > 2) {
                SOCRobotBrain.sleep(msec);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void placeFirstSettlement(int firstSettlement) {
        this.pause(500);
        this.lastStartingPieceCoord = firstSettlement;
        this.client.putPiece(this.game, new SOCSettlement(this.ourPlayerData, firstSettlement, null));
        this.pause(1000);
    }

    protected void placeInitSettlement(int initSettlement) {
        if (initSettlement == -1) {
            System.err.println("robot assert failed: initSettlement -1, " + this.ourPlayerData.getName() + " leaving game " + this.game.getName());
            this.failedBuildingAttempts = 2 + 2 * MAX_DENIED_BUILDING_PER_TURN;
            this.waitingForGameState = false;
            return;
        }
        this.pause(500);
        this.lastStartingPieceCoord = initSettlement;
        this.client.putPiece(this.game, new SOCSettlement(this.ourPlayerData, initSettlement, null));
        this.pause(1000);
    }

    protected void planAndPlaceInitRoad() {
        int roadEdge = this.openingBuildStrategy.planInitRoad();
        this.pause(500);
        this.lastStartingPieceCoord = roadEdge;
        this.client.putPiece(this.game, new SOCRoad(this.ourPlayerData, roadEdge, null));
        this.pause(1000);
    }

    protected void moveRobber() {
        int bestHex = this.robberStrategy.getBestRobberHex();
        D.ebugPrintlnINFO("!!! MOVING ROBBER !!!");
        this.client.moveRobber(this.game, this.ourPlayerData, bestHex);
        this.pause(2000);
    }

    protected void discard(int numDiscards) {
        this.client.discard(this.game, this.discardStrategy.discard(numDiscards, this.buildingPlan));
    }

    protected boolean tradeWithBank(SOCBuildPlan buildPlan) {
        if (buildPlan == null || buildPlan.isEmpty() || this.ourPlayerData.getResources().contains(buildPlan.getFirstPieceResources())) {
            return false;
        }
        SOCTradeOffer bankTrade = this.negotiator.getOfferToBank(buildPlan, this.ourPlayerData.getResources());
        if (bankTrade != null && this.ourPlayerData.getResources().contains(bankTrade.getGiveSet())) {
            this.client.bankTrade(this.game, bankTrade.getGiveSet(), bankTrade.getGetSet());
            this.pause(2000);
            return true;
        }
        return false;
    }

    protected int considerOffer(SOCTradeOffer offer) {
        boolean[] offeredTo;
        int response = -1;
        SOCPlayer offeringPlayer = this.game.getPlayer(offer.getFrom());
        if (offeringPlayer.getCurrentOffer() != null && offer == offeringPlayer.getCurrentOffer() && (offeredTo = offer.getTo())[this.ourPlayerNumber]) {
            response = this.negotiator.considerOffer2(offer, this.ourPlayerNumber);
        }
        return response;
    }

    protected boolean makeOffer(SOCBuildPlan buildPlan) {
        boolean result = false;
        SOCTradeOffer offer = this.negotiator.makeOffer(buildPlan);
        this.ourPlayerData.setCurrentOffer(offer);
        this.negotiator.resetWantsAnotherOffer();
        if (offer != null) {
            boolean anyHumans = false;
            for (int pn = 0; pn < this.game.maxPlayers; ++pn) {
                this.offerRejections[pn] = false;
                if (this.game.isSeatVacant(pn) || this.game.getPlayer(pn).isRobot()) continue;
                anyHumans = true;
            }
            this.waitingForTradeResponse = true;
            this.tradeResponseTimeoutSec = anyHumans ? 30 : 5;
            this.counter = 0;
            this.client.offerTrade(this.game, offer);
            result = true;
        } else {
            this.doneTrading = true;
            this.waitingForTradeResponse = false;
        }
        return result;
    }

    protected boolean makeCounterOffer(SOCTradeOffer offer) {
        boolean result = false;
        SOCTradeOffer counterOffer = this.negotiator.makeCounterOffer(offer);
        this.ourPlayerData.setCurrentOffer(counterOffer);
        if (counterOffer != null) {
            int fromPN = offer.getFrom();
            this.offerRejections[fromPN] = false;
            this.waitingForTradeResponse = true;
            this.tradeResponseTimeoutSec = this.game.getPlayer(fromPN).isRobot() ? 5 : 30;
            this.counter = 0;
            this.client.offerTrade(this.game, counterOffer);
            result = true;
        } else {
            this.doneTrading = true;
            this.waitingForTradeResponse = false;
        }
        return result;
    }

    public void clearTradingFlags(boolean isBankTrade, boolean wasAllowed, boolean wasOfferAllowed) {
        this.waitingForTradeMsg = false;
        this.waitingForTradeResponse = false;
    }

    public void setDoneTrading(boolean isDone) {
        this.doneTrading = isDone;
    }

    protected void handleResources(int action, SOCPlayer player, int resourceType, int amount) {
        SOCDisplaylessPlayerClient.handlePLAYERELEMENT_numRsrc(player, action, resourceType, amount);
    }

    protected SOCRobotDM createDM() {
        return new SOCRobotDM(this);
    }

    public void recreateDM() {
        this.decisionMaker = this.createDM();
    }

    protected SOCRobotNegotiator createNegotiator() {
        return new SOCRobotNegotiator(this);
    }

    protected SOCBuildingSpeedEstimateFactory createEstimatorFactory() {
        return new SOCBuildingSpeedEstimateFactory(this);
    }

    protected void startTurnMainActions() {
    }

    protected boolean endTurnActions() {
        return true;
    }

    protected void handleGAMESTATS(SOCGameStats message) {
    }

    public SOCBuildingSpeedEstimate getEstimator(SOCPlayerNumbers numbers) {
        return this.bseFactory.getEstimator(numbers);
    }

    public SOCBuildingSpeedEstimate getEstimator() {
        return this.bseFactory.getEstimator();
    }

    public SOCBuildingSpeedEstimateFactory getEstimatorFactory() {
        return this.bseFactory;
    }

    protected void debugInfo() {
    }

    protected void printResources() {
    }
}

