/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.Socket;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import soc.baseclient.SOCDisplaylessPlayerClient;
import soc.baseclient.ServerConnectInfo;
import soc.disableDebug.D;
import soc.game.SOCGame;
import soc.game.SOCGameOption;
import soc.game.SOCGameOptionSet;
import soc.game.SOCPlayer;
import soc.message.SOCAdminPing;
import soc.message.SOCAdminReset;
import soc.message.SOCBotJoinGameRequest;
import soc.message.SOCChangeFace;
import soc.message.SOCDeleteGame;
import soc.message.SOCGameMembers;
import soc.message.SOCGameServerText;
import soc.message.SOCGameState;
import soc.message.SOCGameTextMsg;
import soc.message.SOCImARobot;
import soc.message.SOCInventoryItemAction;
import soc.message.SOCJoinGame;
import soc.message.SOCJoinGameAuth;
import soc.message.SOCLeaveAll;
import soc.message.SOCLeaveGame;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;
import soc.message.SOCResetBoardAuth;
import soc.message.SOCRobotDismiss;
import soc.message.SOCServerPing;
import soc.message.SOCSetSpecialItem;
import soc.message.SOCSitDown;
import soc.message.SOCStatusMessage;
import soc.message.SOCTurn;
import soc.message.SOCUpdateRobotParams;
import soc.message.SOCVersion;
import soc.robot.SOCPossiblePiece;
import soc.robot.SOCRobotBrain;
import soc.robot.SOCRobotResetThread;
import soc.server.genericServer.StringServerSocket;
import soc.util.CappedQueue;
import soc.util.CutoffExceededException;
import soc.util.DebugRecorder;
import soc.util.SOCFeatureSet;
import soc.util.SOCRobotParameters;
import soc.util.Version;

public class SOCRobotClient
extends SOCDisplaylessPlayerClient {
    public static final String CURRENT_PLANS = "CURRENT_PLANS";
    public static final String CURRENT_RESOURCES = "RESOURCES";
    public static final String PROP_JSETTLERS_BOTS_TEST_QUIT_AT_JOINREQ = "jsettlers.bots.test.quit_at_joinreq";
    private static final String HINT_SEND_DEBUG_ON_FIRST = "Debug recorder isn't on. Send :debug-on command first";
    private static int testQuitAtJoinreqPercent = 0;
    protected static boolean debugRandomPause = false;
    protected boolean debugRandomPauseActive = false;
    protected Vector<SOCMessage> debugRandomPauseQueue = null;
    protected long debugRandomPauseUntil;
    protected static final double DEBUGRANDOMPAUSE_FREQ = 0.04;
    protected static final int DEBUGRANDOMPAUSE_SECONDS = 12;
    protected String rbclass = "soc.robot.SOCRobotBrain";
    protected SOCFeatureSet cliFeats;
    private Thread readerRobot;
    protected SOCRobotParameters currentRobotParameters;
    protected Hashtable<String, SOCRobotBrain> robotBrains = new Hashtable();
    protected Hashtable<String, CappedQueue<SOCMessage>> brainQs = new Hashtable();
    private Hashtable<String, Integer> seatRequests = new Hashtable();
    protected Hashtable<String, SOCGameOptionSet> gameOptions = new Hashtable();
    protected int gamesPlayed = 0;
    protected int gamesFinished = 0;
    protected int gamesWon = 0;
    protected int cleanBrainKills = 0;
    protected final long startTime = System.currentTimeMillis();
    SOCRobotResetThread resetThread;
    public boolean printedInitialWelcome = false;

    public SOCRobotClient(ServerConnectInfo sci, String nn, String pw) throws IllegalArgumentException {
        super(sci, false);
        this.nickname = nn;
        this.password = pw;
        String val = System.getProperty(PROP_JSETTLERS_BOTS_TEST_QUIT_AT_JOINREQ);
        if (val != null) {
            try {
                testQuitAtJoinreqPercent = Integer.parseInt(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public SOCRobotClient(String h, int p, String nn, String pw, String co) {
        this(new ServerConnectInfo(h, p, co), nn, pw);
    }

    public void init() {
        try {
            if (this.serverConnectInfo.stringSocketName == null) {
                this.sock = new Socket(this.serverConnectInfo.hostname, this.serverConnectInfo.port);
                this.sock.setSoTimeout(300000);
                this.in = new DataInputStream(this.sock.getInputStream());
                this.out = new DataOutputStream(this.sock.getOutputStream());
            } else {
                this.sLocal = StringServerSocket.connectTo(this.serverConnectInfo.stringSocketName);
            }
            this.connected = true;
            this.readerRobot = new Thread(this);
            this.readerRobot.start();
            if (this.cliFeats == null) {
                this.cliFeats = this.buildClientFeats();
                if (this.cliFeats == null) {
                    throw new IllegalStateException("buildClientFeats() must not return null");
                }
            }
            this.put(SOCVersion.toCmd(Version.versionNumber(), Version.version(), Version.buildnum(), this.cliFeats.getEncodedList(), null));
            this.put(SOCImARobot.toCmd(this.nickname, this.serverConnectInfo.robotCookie, this.rbclass));
        }
        catch (Exception e) {
            this.ex = e;
            System.err.println("Could not connect to the server: " + this.ex);
        }
    }

    public void disconnectReconnect() {
        D.ebugPrintlnINFO("(*)(*)(*)(*)(*)(*)(*) disconnectReconnect()");
        this.ex = null;
        for (int attempt = 3; attempt > 0; --attempt) {
            try {
                this.connected = false;
                if (this.serverConnectInfo.stringSocketName == null) {
                    this.sock.close();
                    this.sock = new Socket(this.serverConnectInfo.hostname, this.serverConnectInfo.port);
                    this.in = new DataInputStream(this.sock.getInputStream());
                    this.out = new DataOutputStream(this.sock.getOutputStream());
                } else {
                    this.sLocal.disconnect();
                    this.sLocal = StringServerSocket.connectTo(this.serverConnectInfo.stringSocketName);
                }
                this.connected = true;
                this.readerRobot = new Thread(this);
                this.readerRobot.start();
                this.put(SOCVersion.toCmd(Version.versionNumber(), Version.version(), Version.buildnum(), this.cliFeats.getEncodedList(), null));
                this.put(SOCImARobot.toCmd(this.nickname, this.serverConnectInfo.robotCookie, "soc.robot.SOCRobotBrain"));
                break;
            }
            catch (Exception e) {
                this.ex = e;
                System.err.println("disconnectReconnect error: " + this.ex);
                if (attempt <= 0) continue;
                System.err.println("-> Retrying");
                continue;
            }
        }
        if (!this.connected) {
            System.err.println("-> Giving up");
            for (SOCRobotBrain rb : this.robotBrains.values()) {
                rb.kill();
            }
        }
    }

    protected SOCFeatureSet buildClientFeats() {
        SOCFeatureSet feats = new SOCFeatureSet(false, false);
        feats.add("6pl");
        feats.add("sb");
        feats.add("sc", Version.versionNumber());
        String gameopt3p = System.getProperty("jsettlers.debug.client.gameopt3p");
        if (gameopt3p != null) {
            gameopt3p = gameopt3p.toUpperCase(Locale.US);
            feats.add("com.example.js.feat." + gameopt3p);
            if (null == this.knownOpts.getKnownOption(gameopt3p, false)) {
                this.knownOpts.addKnownOption(new SOCGameOption(gameopt3p, 2000, Version.versionNumber(), false, 17, "Client test 3p option " + gameopt3p));
            }
        }
        return feats;
    }

    public SOCRobotBrain createBrain(SOCRobotParameters params, SOCGame ga, CappedQueue<SOCMessage> mq) {
        return new SOCRobotBrain(this, params, ga, mq);
    }

    @Override
    public void treat(SOCMessage mes) {
        SOCRobotBrain brain;
        String ga;
        if (mes == null) {
            return;
        }
        if (!(!debugRandomPause || this.robotBrains.isEmpty() || !(mes instanceof SOCMessageForGame) || mes instanceof SOCGameTextMsg || mes instanceof SOCGameServerText || mes instanceof SOCTurn || (ga = ((SOCMessageForGame)((Object)mes)).getGame()) == null || (brain = this.robotBrains.get(ga)) == null || this.debugRandomPauseActive || !(Math.random() < 0.04) || this.debugRandomPauseQueue != null && !this.debugRandomPauseQueue.isEmpty())) {
            SOCGame gm = (SOCGame)this.games.get(ga);
            int cpn = gm.getCurrentPlayerNumber();
            SOCPlayer rpl = gm.getPlayer(this.nickname);
            if (rpl != null && cpn == rpl.getPlayerNumber() && gm.getGameState() >= 15) {
                this.debugRandomPauseActive = true;
                this.debugRandomPauseUntil = System.currentTimeMillis() + 12000L;
                if (this.debugRandomPauseQueue == null) {
                    this.debugRandomPauseQueue = new Vector();
                }
                System.err.println("L379 -> do random pause: " + this.nickname);
                this.sendText(gm, "debugRandomPauseActive for 12 seconds");
            }
        }
        if (debugRandomPause && this.debugRandomPauseActive) {
            if (System.currentTimeMillis() < this.debugRandomPauseUntil && !(mes instanceof SOCTurn)) {
                this.debugRandomPauseQueue.addElement(mes);
                return;
            }
            this.debugRandomPauseActive = false;
            while (!this.debugRandomPauseQueue.isEmpty()) {
                this.treat(this.debugRandomPauseQueue.firstElement());
                this.debugRandomPauseQueue.removeElementAt(0);
            }
        }
        if (!(!this.debugTraffic && !D.ebugIsEnabled() || mes instanceof SOCServerPing && this.nextServerPingExpectedAt != 0L && Math.abs(System.currentTimeMillis() - this.nextServerPingExpectedAt) <= 66000L)) {
            soc.debug.D.ebugPrintlnINFO("IN - " + this.nickname + " - " + mes);
        }
        try {
            switch (mes.getType()) {
                case 1069: {
                    this.handleSTATUSMESSAGE((SOCStatusMessage)mes);
                    break;
                }
                case 1064: {
                    this.handleADMINPING((SOCAdminPing)mes);
                    break;
                }
                case 1065: {
                    this.handleADMINRESET((SOCAdminReset)mes);
                    break;
                }
                case 1071: {
                    this.handleUPDATEROBOTPARAMS((SOCUpdateRobotParams)mes);
                    break;
                }
                case 1021: {
                    this.handleJOINGAMEAUTH((SOCJoinGameAuth)mes, this.sLocal != null);
                    break;
                }
                case 1015: {
                    this.handleDELETEGAME((SOCDeleteGame)mes);
                    break;
                }
                case 1017: {
                    this.handleGAMEMEMBERS((SOCGameMembers)mes);
                    break;
                }
                case 1010: {
                    this.handleGAMETEXTMSG((SOCGameTextMsg)mes);
                    break;
                }
                case 1012: {
                    this.handleSITDOWN((SOCSitDown)mes);
                    break;
                }
                case 1025: {
                    this.handleGAMESTATE((SOCGameState)mes);
                    break;
                }
                case 1023: {
                    this.handleBOTJOINGAMEREQUEST((SOCBotJoinGameRequest)mes);
                    break;
                }
                case 1056: {
                    this.handleROBOTDISMISS((SOCRobotDismiss)mes);
                    break;
                }
                case 1074: {
                    this.handleRESETBOARDAUTH((SOCResetBoardAuth)mes);
                    break;
                }
                case 1098: {
                    boolean isReject = SOCDisplaylessPlayerClient.handleINVENTORYITEMACTION(this.games, (SOCInventoryItemAction)mes);
                    if (isReject) {
                        this.handlePutBrainQ((SOCInventoryItemAction)mes);
                    }
                    break;
                }
                case 1099: {
                    SOCDisplaylessPlayerClient.handleSETSPECIALITEM(this.games, (SOCSetSpecialItem)mes);
                    this.handlePutBrainQ((SOCSetSpecialItem)mes);
                    break;
                }
                case 1009: 
                case 1018: 
                case 1024: 
                case 1026: 
                case 1028: 
                case 1029: 
                case 1033: 
                case 1034: 
                case 1035: 
                case 1036: 
                case 1037: 
                case 1038: 
                case 1039: 
                case 1040: 
                case 1041: 
                case 1044: 
                case 1046: 
                case 1061: 
                case 1063: 
                case 1086: 
                case 1088: 
                case 1089: 
                case 1090: 
                case 1092: 
                case 1093: 
                case 1102: 
                case 1103: 
                case 1104: 
                case 1105: {
                    this.handlePutBrainQ((SOCMessageForGame)((Object)mes));
                    break;
                }
                case 1001: 
                case 1002: 
                case 1003: 
                case 1004: 
                case 1005: 
                case 1006: 
                case 1007: 
                case 1016: 
                case 1019: 
                case 1020: 
                case 1058: 
                case 1062: 
                case 1068: 
                case 1091: {
                    break;
                }
                default: {
                    super.treat(mes, true);
                }
            }
        }
        catch (Throwable e) {
            System.err.println("SOCRobotClient treat ERROR - " + e + " " + e.getMessage());
            e.printStackTrace();
            while (e.getCause() != null) {
                e = e.getCause();
                System.err.println(" -> nested: " + e.getClass());
                e.printStackTrace();
            }
            System.err.println("-- end stacktrace --");
            System.out.println("  For message: " + mes);
        }
    }

    protected void handleADMINPING(SOCAdminPing mes) {
        D.ebugPrintlnINFO("*** Admin Ping message = " + mes);
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            this.sendText(ga, "OK");
        } else {
            this.put(SOCJoinGame.toCmd(this.nickname, this.password, "\t", mes.getGame()));
        }
    }

    protected void handleADMINRESET(SOCAdminReset mes) {
        D.ebugPrintlnINFO("*** Admin Reset message = " + mes);
        this.disconnectReconnect();
    }

    protected void handleUPDATEROBOTPARAMS(SOCUpdateRobotParams mes) {
        this.currentRobotParameters = new SOCRobotParameters(mes.getRobotParameters());
        if (!this.printedInitialWelcome) {
            System.err.println("Robot " + this.getNickname() + ": Authenticated to server.");
            this.printedInitialWelcome = true;
        }
        if (D.ebugIsEnabled()) {
            D.ebugPrintlnINFO("*** current robot parameters = " + this.currentRobotParameters);
        }
    }

    protected void handleBOTJOINGAMEREQUEST(SOCBotJoinGameRequest mes) {
        D.ebugPrintlnINFO("**** handleBOTJOINGAMEREQUEST ****");
        String gaName = mes.getGame();
        if (testQuitAtJoinreqPercent != 0 && new Random().nextInt(100) < testQuitAtJoinreqPercent) {
            System.err.println(" -- " + this.nickname + " leaving at JoinGameRequest('" + gaName + "', " + mes.getPlayerNumber() + "): " + PROP_JSETTLERS_BOTS_TEST_QUIT_AT_JOINREQ);
            this.put(new SOCLeaveAll().toCmd());
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.disconnect();
            return;
        }
        Map<String, SOCGameOption> gaOpts = mes.getOptions(this.knownOpts);
        if (gaOpts != null) {
            this.gameOptions.put(gaName, new SOCGameOptionSet(gaOpts));
        }
        this.seatRequests.put(gaName, mes.getPlayerNumber());
        if (this.put(SOCJoinGame.toCmd(this.nickname, this.password, "\t", gaName))) {
            D.ebugPrintlnINFO("**** sent SOCJoinGame ****");
        }
    }

    @Override
    protected void handleSTATUSMESSAGE(SOCStatusMessage mes) {
        int sv = mes.getStatusValue();
        if (sv == 21) {
            sv = 0;
        } else if (sv == 23) {
            this.disconnect();
            return;
        }
        if (sv != 0 || !this.printedInitialWelcome) {
            System.err.println("Robot " + this.getNickname() + ": Status " + sv + " from server: " + mes.getStatus());
            if (sv == 0) {
                this.printedInitialWelcome = true;
            }
        }
    }

    @Override
    protected void handleJOINGAMEAUTH(SOCJoinGameAuth mes, boolean isPractice) {
        ++this.gamesPlayed;
        String gaName = mes.getGame();
        SOCGameOptionSet gameOpts = this.gameOptions.get(gaName);
        int bh = mes.getBoardHeight();
        int bw = mes.getBoardWidth();
        if (bh != 0 || bw != 0) {
            SOCGameOption opt = this.knownOpts.getKnownOption("_BHW", true);
            if (opt == null) {
                throw new IllegalStateException("Internal error: Game opt _BHW not known");
            }
            opt.setIntValue(bh << 8 | bw);
            gameOpts.put(opt);
        }
        try {
            SOCGame ga = new SOCGame(gaName, gameOpts, this.knownOpts);
            ga.isPractice = isPractice;
            ga.serverVersion = isPractice ? this.sLocalVersion : this.sVersion;
            this.games.put(gaName, ga);
            CappedQueue<SOCMessage> brainQ = new CappedQueue<SOCMessage>();
            this.brainQs.put(gaName, brainQ);
            SOCRobotBrain rb = this.createBrain(this.currentRobotParameters, ga, brainQ);
            this.robotBrains.put(gaName, rb);
        }
        catch (IllegalArgumentException e) {
            System.err.println("Sync error: Bot " + this.nickname + " can't join game " + gaName + ": " + e.getMessage());
            this.brainQs.remove(gaName);
            this.leaveGame(gaName);
        }
    }

    @Override
    protected void handleGAMEMEMBERS(SOCGameMembers mes) {
        Integer pn = this.seatRequests.get(mes.getGame());
        if (pn != null) {
            this.put(SOCSitDown.toCmd(mes.getGame(), "\t", pn, true));
        } else {
            System.err.println("** Cannot sit down: Assert failed: null pn for game " + mes.getGame());
        }
    }

    protected void handlePutBrainQ(SOCMessageForGame mes) {
        CappedQueue<SOCMessage> brainQ = this.brainQs.get(mes.getGame());
        if (brainQ != null) {
            try {
                brainQ.put((SOCMessage)((Object)mes));
            }
            catch (CutoffExceededException exc) {
                D.ebugPrintlnINFO("CutoffExceededException" + exc);
            }
        }
    }

    @Override
    protected void handleGAMETEXTMSG(SOCGameTextMsg mes) {
        if (mes.getText().startsWith(this.nickname)) {
            this.handleGAMETEXTMSG_debug(mes);
        }
    }

    protected void handleGAMETEXTMSG_debug(SOCGameTextMsg mes) {
        int nL = this.nickname.length();
        try {
            if (mes.getText().charAt(nL) != ':') {
                return;
            }
        }
        catch (IndexOutOfBoundsException e) {
            return;
        }
        String gaName = mes.getGame();
        String dcmd = mes.getText().substring(nL);
        if (dcmd.startsWith(":debug-off")) {
            SOCGame ga = (SOCGame)this.games.get(gaName);
            SOCRobotBrain brain = this.robotBrains.get(gaName);
            if (brain != null) {
                brain.turnOffDRecorder();
                this.sendText(ga, "Debug mode OFF");
            }
        } else if (dcmd.startsWith(":debug-on")) {
            SOCGame ga = (SOCGame)this.games.get(gaName);
            SOCRobotBrain brain = this.robotBrains.get(gaName);
            if (brain != null) {
                brain.turnOnDRecorder();
                this.sendText(ga, "Debug mode ON");
            }
        } else if (dcmd.startsWith(":current-plans") || dcmd.startsWith(":cp")) {
            this.sendRecordsText(gaName, CURRENT_PLANS, false);
        } else if (dcmd.startsWith(":current-resources") || dcmd.startsWith(":cr")) {
            this.sendRecordsText(gaName, CURRENT_RESOURCES, false);
        } else if (dcmd.startsWith(":last-plans") || dcmd.startsWith(":lp")) {
            this.sendRecordsText(gaName, CURRENT_PLANS, true);
        } else if (dcmd.startsWith(":last-resources") || dcmd.startsWith(":lr")) {
            this.sendRecordsText(gaName, CURRENT_RESOURCES, true);
        } else if (dcmd.startsWith(":last-move") || dcmd.startsWith(":lm")) {
            SOCRobotBrain brain = this.robotBrains.get(gaName);
            if (brain != null && brain.getOldDRecorder().isOn()) {
                SOCPossiblePiece lastMove = brain.getLastMove();
                if (lastMove != null) {
                    String key = null;
                    switch (lastMove.getType()) {
                        case -2: {
                            key = "DEVCARD";
                            break;
                        }
                        case 0: {
                            key = "ROAD" + lastMove.getCoordinates();
                            break;
                        }
                        case 1: {
                            key = "SETTLEMENT" + lastMove.getCoordinates();
                            break;
                        }
                        case 2: {
                            key = "CITY" + lastMove.getCoordinates();
                            break;
                        }
                        case 3: {
                            key = "SHIP" + lastMove.getCoordinates();
                        }
                    }
                    this.sendRecordsText(gaName, key, true);
                }
            } else {
                this.sendText((SOCGame)this.games.get(gaName), HINT_SEND_DEBUG_ON_FIRST);
            }
        } else if (dcmd.startsWith(":consider-move ") || dcmd.startsWith(":cm ")) {
            String[] tokens = dcmd.split(" ");
            int L = tokens.length;
            String keytoken = L > 2 ? tokens[L - 2].trim() : "(missing)";
            String lasttoken = L > 1 ? tokens[L - 1].trim() : "(missing)";
            String key = null;
            if (lasttoken.equals("card")) {
                key = "DEVCARD";
            } else if (keytoken.equals("road")) {
                key = "ROAD" + lasttoken;
            } else if (keytoken.equals("ship")) {
                key = "SHIP" + lasttoken;
            } else if (keytoken.equals("settlement")) {
                key = "SETTLEMENT" + lasttoken;
            } else if (keytoken.equals("city")) {
                key = "CITY" + lasttoken;
            }
            SOCGame ga = (SOCGame)this.games.get(gaName);
            if (key == null) {
                this.sendText(ga, "Unknown :consider-move type: " + keytoken);
                return;
            }
            this.sendRecordsText(gaName, key, true);
        } else if (dcmd.startsWith(":last-target") || dcmd.startsWith(":lt")) {
            SOCRobotBrain brain = this.robotBrains.get(gaName);
            if (brain != null && brain.getDRecorder().isOn()) {
                SOCPossiblePiece lastTarget = brain.getLastTarget();
                if (lastTarget != null) {
                    String key = null;
                    switch (lastTarget.getType()) {
                        case -2: {
                            key = "DEVCARD";
                            break;
                        }
                        case 0: {
                            key = "ROAD" + lastTarget.getCoordinates();
                            break;
                        }
                        case 1: {
                            key = "SETTLEMENT" + lastTarget.getCoordinates();
                            break;
                        }
                        case 2: {
                            key = "CITY" + lastTarget.getCoordinates();
                            break;
                        }
                        case 3: {
                            key = "SHIP" + lastTarget.getCoordinates();
                        }
                    }
                    this.sendRecordsText(gaName, key, false);
                }
            } else {
                this.sendText((SOCGame)this.games.get(gaName), HINT_SEND_DEBUG_ON_FIRST);
            }
        } else if (dcmd.startsWith(":consider-target ") || dcmd.startsWith(":ct ")) {
            String[] tokens = dcmd.split(" ");
            int L = tokens.length;
            String keytoken = L > 2 ? tokens[L - 2].trim() : "(missing)";
            String lasttoken = L > 1 ? tokens[L - 1].trim() : "(missing)";
            String key = null;
            if (lasttoken.equals("card")) {
                key = "DEVCARD";
            } else if (keytoken.equals("road")) {
                key = "ROAD" + lasttoken;
            } else if (keytoken.equals("ship")) {
                key = "SHIP" + lasttoken;
            } else if (keytoken.equals("settlement")) {
                key = "SETTLEMENT" + lasttoken;
            } else if (keytoken.equals("city")) {
                key = "CITY" + lasttoken;
            }
            SOCGame ga = (SOCGame)this.games.get(gaName);
            if (key == null) {
                this.sendText(ga, "Unknown :consider-target type: " + keytoken);
                return;
            }
            this.sendRecordsText(gaName, key, false);
        } else if (dcmd.startsWith(":print-vars") || dcmd.startsWith(":pv")) {
            this.debugPrintBrainStatus(gaName, true, true);
        } else if (dcmd.startsWith(":stats")) {
            SOCGame ga = (SOCGame)this.games.get(gaName);
            this.sendText(ga, "Games played:" + this.gamesPlayed);
            this.sendText(ga, "Games finished:" + this.gamesFinished);
            this.sendText(ga, "Games won:" + this.gamesWon);
            this.sendText(ga, "Clean brain kills:" + this.cleanBrainKills);
            this.sendText(ga, "Brains running: " + this.robotBrains.size());
            Runtime rt = Runtime.getRuntime();
            this.sendText(ga, "Total Memory:" + rt.totalMemory());
            this.sendText(ga, "Free Memory:" + rt.freeMemory());
        } else if (dcmd.startsWith(":gc")) {
            SOCGame ga = (SOCGame)this.games.get(gaName);
            Runtime rt = Runtime.getRuntime();
            rt.gc();
            this.sendText(ga, "Free Memory:" + rt.freeMemory());
        }
    }

    @Override
    protected SOCGame handleSITDOWN(SOCSitDown mes) {
        String gaName = mes.getGame();
        SOCGame ga = super.handleSITDOWN(mes);
        if (ga == null) {
            return null;
        }
        int pn = mes.getPlayerNumber();
        if (this.nickname.equals(mes.getNickname())) {
            int faceId;
            SOCRobotBrain brain = this.robotBrains.get(gaName);
            if (brain.ourPlayerData != null) {
                if (pn == brain.ourPlayerNumber && this.nickname.equals(ga.getPlayer(pn).getName())) {
                    return ga;
                }
                throw new IllegalStateException("bot " + this.nickname + " game " + gaName + ": got sitdown(pn=" + pn + "), but already sitting at pn=" + brain.ourPlayerNumber);
            }
            switch (brain.getRobotParameters().getStrategyType()) {
                case 0: {
                    faceId = -1;
                    break;
                }
                default: {
                    faceId = 0;
                }
            }
            brain.setOurPlayerData();
            brain.start();
            this.put(new SOCChangeFace(ga.getName(), pn, faceId).toCmd());
        } else {
            SOCRobotBrain brain = this.robotBrains.get(gaName);
            if (brain != null) {
                brain.addPlayerTracker(pn);
            }
        }
        return ga;
    }

    @Override
    protected void handleDELETEGAME(SOCDeleteGame mes) {
        SOCGame ga;
        SOCRobotBrain brain = this.robotBrains.get(mes.getGame());
        if (brain != null && (ga = (SOCGame)this.games.get(mes.getGame())) != null) {
            if (ga.getGameState() == 1000) {
                ++this.gamesFinished;
                if (ga.getPlayer(this.nickname).getTotalVP() >= ga.vp_winner) {
                    ++this.gamesWon;
                }
            }
            brain.kill();
            this.robotBrains.remove(mes.getGame());
            this.brainQs.remove(mes.getGame());
            this.games.remove(mes.getGame());
        }
    }

    @Override
    protected void handleGAMESTATE(SOCGameState mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        if (ga != null) {
            this.handlePutBrainQ(mes);
        }
    }

    protected void handleROBOTDISMISS(SOCRobotDismiss mes) {
        SOCGame ga = (SOCGame)this.games.get(mes.getGame());
        CappedQueue<SOCMessage> brainQ = this.brainQs.get(mes.getGame());
        if (ga != null && brainQ != null) {
            try {
                brainQ.put(mes);
            }
            catch (CutoffExceededException exc) {
                D.ebugPrintlnINFO("CutoffExceededException" + exc);
            }
            SOCRobotBrain brain = this.robotBrains.get(mes.getGame());
            if (brain == null || !brain.isAlive()) {
                this.leaveGame((SOCGame)this.games.get(mes.getGame()), "brain not alive in handleROBOTDISMISS", true, false);
            }
        }
    }

    @Override
    protected void handleRESETBOARDAUTH(SOCResetBoardAuth mes) {
        D.ebugPrintlnINFO("**** handleRESETBOARDAUTH ****");
        String gname = mes.getGame();
        SOCGame ga = (SOCGame)this.games.get(gname);
        if (ga == null) {
            return;
        }
        SOCRobotBrain brain = this.robotBrains.get(gname);
        if (brain != null) {
            brain.kill();
        }
        this.leaveGame(ga, "resetboardauth", false, false);
        ga.destroyGame();
    }

    protected void sendRecordsText(String gaName, String key, boolean oldNotCurrent) {
        DebugRecorder recorder;
        SOCRobotBrain brain = this.robotBrains.get(gaName);
        if (brain == null) {
            return;
        }
        SOCGame ga = (SOCGame)this.games.get(gaName);
        DebugRecorder debugRecorder = recorder = oldNotCurrent ? brain.getOldDRecorder() : brain.getDRecorder();
        if (!recorder.isOn()) {
            this.sendText(ga, HINT_SEND_DEBUG_ON_FIRST);
            return;
        }
        Vector<String> record = recorder.getRecord(key);
        if (record != null) {
            for (String str : record) {
                this.sendText(ga, str);
            }
        } else {
            this.sendText(ga, "No debug records for " + key);
        }
    }

    public void debugPrintBrainStatus(String gameName, boolean withMessages, boolean sendTextToGame) {
        SOCRobotBrain brain = this.robotBrains.get(gameName);
        if (brain == null) {
            return;
        }
        List<String> rbSta = brain.debugPrintBrainStatus(withMessages);
        if (sendTextToGame) {
            for (String st : rbSta) {
                this.put(new SOCGameTextMsg(gameName, this.nickname, st).toCmd());
            }
        } else {
            StringBuilder sb = new StringBuilder();
            for (String st : rbSta) {
                sb.append(st).append('\n');
            }
            System.err.print(sb);
        }
    }

    public void leaveGame(SOCGame ga, String leaveReason, boolean showReason, boolean showDebugTrace) {
        String r;
        if (ga == null) {
            return;
        }
        String gaName = ga.getName();
        this.robotBrains.remove(gaName);
        this.brainQs.remove(gaName);
        this.games.remove(gaName);
        String string = r = showReason || D.ebugIsEnabled() ? "L1833 robot " + this.nickname + " leaving game " + gaName + " due to " + leaveReason : null;
        if (showReason) {
            soc.debug.D.ebugPrintlnINFO(r);
        } else if (r != null) {
            D.ebugPrintlnINFO(r);
        }
        if (showDebugTrace) {
            soc.debug.D.ebugPrintStackTrace(null, "Leaving game here");
            System.err.flush();
        }
        this.put(SOCLeaveGame.toCmd(this.nickname, "-", gaName));
    }

    public void addCleanKill() {
        ++this.cleanBrainKills;
    }

    @Override
    public void destroy() {
        SOCLeaveAll leaveAllMes = new SOCLeaveAll();
        this.put(leaveAllMes.toCmd());
        this.disconnectReconnect();
        if (this.ex != null) {
            System.err.println("Reconnect to server failed: " + this.ex);
        }
    }

    public static void main(String[] args) {
        if (args.length < 5) {
            System.err.println("Java Settlers robotclient " + Version.version() + ", build " + Version.buildnum());
            System.err.println("usage: java soc.robot.SOCRobotClient host port_number bot_nickname password cookie");
            return;
        }
        SOCRobotClient ex1 = new SOCRobotClient(new ServerConnectInfo(args[0], Integer.parseInt(args[1]), args[4]), args[2], args[3]);
        ex1.init();
    }
}

