/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import soc.disableDebug.D;
import soc.game.SOCBoard;
import soc.game.SOCBoardLarge;
import soc.game.SOCCity;
import soc.game.SOCDevCard;
import soc.game.SOCFortress;
import soc.game.SOCGame;
import soc.game.SOCLRPathData;
import soc.game.SOCPlayer;
import soc.game.SOCPlayerNumbers;
import soc.game.SOCPlayingPiece;
import soc.game.SOCResourceSet;
import soc.game.SOCRoad;
import soc.game.SOCRoutePiece;
import soc.game.SOCSettlement;
import soc.game.SOCShip;
import soc.game.SOCSpecialItem;
import soc.robot.OpeningBuildStrategy;
import soc.robot.SOCBuildPlanStack;
import soc.robot.SOCBuildingSpeedEstimate;
import soc.robot.SOCBuildingSpeedEstimateFactory;
import soc.robot.SOCPlayerTracker;
import soc.robot.SOCPossibleCard;
import soc.robot.SOCPossibleCity;
import soc.robot.SOCPossiblePickSpecialItem;
import soc.robot.SOCPossiblePiece;
import soc.robot.SOCPossibleRoad;
import soc.robot.SOCPossibleSettlement;
import soc.robot.SOCPossibleShip;
import soc.robot.SOCResSetBuildTimePair;
import soc.robot.SOCRobotBrain;
import soc.util.CutoffExceededException;
import soc.util.NodeLenVis;
import soc.util.Pair;
import soc.util.Queue;
import soc.util.SOCRobotParameters;

public class SOCRobotDM {
    protected static final DecimalFormat df1 = new DecimalFormat("###0.00");
    protected int maxGameLength = 300;
    protected int maxETA = 99;
    protected float etaBonusFactor = 0.8f;
    protected float adversarialFactor = 1.5f;
    protected float leaderAdversarialFactor = 3.0f;
    protected float devCardMultiplier = 2.0f;
    protected float threatMultiplier = 1.1f;
    protected static final int LA_CHOICE = 0;
    protected static final int LR_CHOICE = 1;
    protected static final int CITY_CHOICE = 2;
    protected static final int SETTLEMENT_CHOICE = 3;
    protected static final int TWO_SETTLEMENTS = 11;
    protected static final int TWO_CITIES = 12;
    protected static final int ONE_OF_EACH = 13;
    protected static final int WIN_LA = 14;
    protected static final int WIN_LR = 15;
    public static final int SMART_STRATEGY = 0;
    public static final int FAST_STRATEGY = 1;
    protected SOCRobotBrain brain = null;
    protected SOCPlayerTracker[] playerTrackers;
    protected SOCPlayerTracker ourPlayerTracker;
    protected final SOCPlayer ourPlayerData;
    protected final int ourPlayerNumber;
    protected final SOCBuildPlanStack buildingPlan;
    protected final OpeningBuildStrategy openingBuildStrategy;
    protected SOCBuildingSpeedEstimateFactory bseFactory;
    protected final SOCGame game;
    protected SOCResourceSet resourceChoices;
    protected final ArrayList<SOCPossibleRoad> threatenedRoads;
    protected final ArrayList<SOCPossibleRoad> goodRoads;
    protected SOCPossibleRoad favoriteRoad;
    protected final ArrayList<SOCPossibleSettlement> threatenedSettlements;
    protected final ArrayList<SOCPossibleSettlement> goodSettlements;
    protected SOCPossibleSettlement favoriteSettlement;
    protected SOCPossibleCity favoriteCity;
    protected SOCPossibleCard possibleCard;

    public SOCRobotDM(SOCRobotBrain br) {
        this(br.getRobotParameters(), br.getOpeningBuildStrategy(), br.getEstimatorFactory(), br.getPlayerTrackers(), br.getOurPlayerTracker(), br.getOurPlayerData(), br.getBuildingPlan());
        this.brain = br;
    }

    public SOCRobotDM(SOCRobotParameters params, OpeningBuildStrategy obs, SOCBuildingSpeedEstimateFactory bsef, SOCPlayerTracker[] pt, SOCPlayerTracker opt, SOCPlayer opd, SOCBuildPlanStack bp) {
        this.playerTrackers = pt;
        this.ourPlayerTracker = opt;
        this.ourPlayerData = opd;
        this.ourPlayerNumber = opd.getPlayerNumber();
        this.buildingPlan = bp;
        this.bseFactory = bsef != null ? bsef : new SOCBuildingSpeedEstimateFactory(null);
        this.game = this.ourPlayerData.getGame();
        this.openingBuildStrategy = obs != null ? obs : new OpeningBuildStrategy(this.game, opd, null);
        this.maxGameLength = params.getMaxGameLength();
        this.maxETA = params.getMaxETA();
        this.etaBonusFactor = params.getETABonusFactor();
        this.adversarialFactor = params.getAdversarialFactor();
        this.leaderAdversarialFactor = params.getLeaderAdversarialFactor();
        this.devCardMultiplier = params.getDevCardMultiplier();
        this.threatMultiplier = params.getThreatMultiplier();
        this.resourceChoices = new SOCResourceSet();
        this.resourceChoices.add(2, 1);
        this.threatenedRoads = new ArrayList();
        this.goodRoads = new ArrayList();
        this.threatenedSettlements = new ArrayList();
        this.goodSettlements = new ArrayList();
    }

    public SOCPossibleSettlement getFavoriteSettlement() {
        return this.favoriteSettlement;
    }

    public SOCPossibleCity getFavoriteCity() {
        return this.favoriteCity;
    }

    public SOCPossibleRoad getFavoriteRoad() {
        return this.favoriteRoad;
    }

    public SOCPossibleCard getPossibleCard() {
        return this.possibleCard;
    }

    public void planStuff(int strategy) {
        D.ebugPrintlnINFO("PLANSTUFF");
        SOCBuildingSpeedEstimate currentBSE = this.getEstimator(this.ourPlayerData.getNumbers());
        int[] currentBuildingETAs = currentBSE.getEstimatesFromNowFast(this.ourPlayerData.getResources(), this.ourPlayerData.getPortFlags());
        this.threatenedSettlements.clear();
        this.goodSettlements.clear();
        this.threatenedRoads.clear();
        this.goodRoads.clear();
        this.favoriteRoad = null;
        this.favoriteSettlement = null;
        this.favoriteCity = null;
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().eraseAllRecords();
            this.brain.getDRecorder().startRecording("RESOURCES");
            this.brain.getDRecorder().record(this.ourPlayerData.getResources().toShortString());
            this.brain.getDRecorder().stopRecording();
            this.brain.getDRecorder().startRecording("CURRENT_PLANS");
        }
        if (strategy == 0) {
            SOCPlayerTracker.updateWinGameETAs(this.playerTrackers);
        }
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().stopRecording();
        }
        int leadersCurrentWGETA = this.ourPlayerTracker.getWinGameETA();
        for (SOCPlayerTracker tracker : this.playerTrackers) {
            int wgeta;
            if (tracker == null || (wgeta = tracker.getWinGameETA()) >= leadersCurrentWGETA) continue;
            leadersCurrentWGETA = wgeta;
        }
        for (SOCPossiblePiece sOCPossiblePiece : this.ourPlayerTracker.getPossibleCities().values()) {
            sOCPossiblePiece.resetScore();
            sOCPossiblePiece.clearBiggestThreats();
        }
        for (SOCPossiblePiece sOCPossiblePiece : this.ourPlayerTracker.getPossibleSettlements().values()) {
            sOCPossiblePiece.resetScore();
            sOCPossiblePiece.clearBiggestThreats();
        }
        for (SOCPossiblePiece sOCPossiblePiece : this.ourPlayerTracker.getPossibleRoads().values()) {
            sOCPossiblePiece.resetScore();
            sOCPossiblePiece.clearBiggestThreats();
        }
        switch (strategy) {
            case 0: {
                this.smartGameStrategy(currentBuildingETAs);
                break;
            }
            case 1: {
                this.dumbFastGameStrategy(currentBuildingETAs);
            }
        }
        if (strategy == 0 && !this.ourPlayerData.hasPlayedDevCard() && this.ourPlayerData.getNumPieces(0) >= 2 && this.ourPlayerData.getInventory().hasPlayable(1)) {
            this.planRoadBuildingTwoRoads();
        }
    }

    protected void dumbFastGameStrategy(int[] buildingETAs) {
        D.ebugPrintlnINFO("***** dumbFastGameStrategy *****");
        boolean forSpecialBuildingPhase = this.game.isSpecialBuilding() || this.game.getCurrentPlayerNumber() != this.ourPlayerNumber;
        int bestETA = 500;
        SOCBuildingSpeedEstimate ourBSE = this.getEstimator(this.ourPlayerData.getNumbers());
        if (this.ourPlayerData.getTotalVP() < 5) {
            if (this.ourPlayerData.getNumPieces(2) > 0) {
                for (SOCPossibleCity posCity : this.ourPlayerTracker.getPossibleCities().values()) {
                    D.ebugPrintlnINFO("Estimate speedup of city at " + this.game.getBoard().nodeCoordToString(posCity.getCoordinates()));
                    D.ebugPrintlnINFO("Speedup = " + posCity.getSpeedupTotal());
                    D.ebugPrintlnINFO("ETA = " + buildingETAs[2]);
                    if (this.brain != null && this.brain.getDRecorder().isOn()) {
                        this.brain.getDRecorder().startRecording("CITY" + posCity.getCoordinates());
                        this.brain.getDRecorder().record("Estimate speedup of city at " + this.game.getBoard().nodeCoordToString(posCity.getCoordinates()));
                        this.brain.getDRecorder().record("Speedup = " + posCity.getSpeedupTotal());
                        this.brain.getDRecorder().record("ETA = " + buildingETAs[2]);
                        this.brain.getDRecorder().stopRecording();
                    }
                    if (this.favoriteCity != null && posCity.getSpeedupTotal() <= this.favoriteCity.getSpeedupTotal()) continue;
                    this.favoriteCity = posCity;
                    bestETA = buildingETAs[2];
                }
            }
            this.scoreSettlementsForDumb(buildingETAs[1], ourBSE);
            for (SOCPossibleSettlement posSet : this.ourPlayerTracker.getPossibleSettlements().values()) {
                if (this.brain != null && this.brain.getDRecorder().isOn()) {
                    this.brain.getDRecorder().startRecording("SETTLEMENT" + posSet.getCoordinates());
                    this.brain.getDRecorder().record("Estimate speedup of stlmt at " + this.game.getBoard().nodeCoordToString(posSet.getCoordinates()));
                    this.brain.getDRecorder().record("Speedup = " + posSet.getSpeedupTotal());
                    this.brain.getDRecorder().record("ETA = " + posSet.getETA());
                    Stack<SOCPossibleRoad> roadPath = posSet.getRoadPath();
                    if (roadPath != null) {
                        this.brain.getDRecorder().record("Path:");
                        for (SOCPossibleRoad posRoad : roadPath) {
                            this.brain.getDRecorder().record("Road at " + this.game.getBoard().edgeCoordToString(posRoad.getCoordinates()));
                        }
                    }
                    this.brain.getDRecorder().stopRecording();
                }
                if (posSet.getETA() < bestETA) {
                    bestETA = posSet.getETA();
                    this.favoriteSettlement = posSet;
                    continue;
                }
                if (posSet.getETA() != bestETA) continue;
                if (this.favoriteSettlement == null) {
                    if (this.favoriteCity != null && posSet.getSpeedupTotal() <= this.favoriteCity.getSpeedupTotal()) continue;
                    this.favoriteSettlement = posSet;
                    continue;
                }
                if (posSet.getSpeedupTotal() <= this.favoriteSettlement.getSpeedupTotal()) continue;
                this.favoriteSettlement = posSet;
            }
            if (this.favoriteSettlement != null) {
                D.ebugPrintlnINFO("Picked favorite settlement at " + this.game.getBoard().nodeCoordToString(this.favoriteSettlement.getCoordinates()));
                this.buildingPlan.push(this.favoriteSettlement);
                if (!this.favoriteSettlement.getNecessaryRoads().isEmpty()) {
                    Stack<SOCPossibleRoad> roadPath = this.favoriteSettlement.getRoadPath();
                    while (!roadPath.empty()) {
                        this.buildingPlan.push(roadPath.pop());
                    }
                }
            } else if (this.favoriteCity != null) {
                D.ebugPrintlnINFO("Picked favorite city at " + this.game.getBoard().nodeCoordToString(this.favoriteCity.getCoordinates()));
                this.buildingPlan.push(this.favoriteCity);
            } else if (this.game.getNumDevCards() > 0 && !forSpecialBuildingPhase) {
                D.ebugPrintlnINFO("Buy a card");
                SOCPossibleCard posCard = new SOCPossibleCard(this.ourPlayerData, buildingETAs[3]);
                this.buildingPlan.push(posCard);
            }
        } else {
            int choice = -1;
            D.ebugPrintlnINFO("Calculating Largest Army ETA");
            int laETA = 500;
            int laSize = 0;
            SOCPlayer laPlayer = this.game.getPlayerWithLargestArmy();
            if (laPlayer == null) {
                laSize = 3;
            } else if (laPlayer.getPlayerNumber() == this.ourPlayerNumber) {
                D.ebugPrintlnINFO("We have largest army");
            } else {
                laSize = laPlayer.getNumKnights() + 1;
            }
            int knightsToBuy = 0;
            if (this.ourPlayerData.getNumKnights() + this.ourPlayerData.getInventory().getAmount(9) < laSize) {
                knightsToBuy = laSize - (this.ourPlayerData.getNumKnights() + this.ourPlayerData.getInventory().getAmount(0, 9));
            }
            D.ebugPrintlnINFO("knightsToBuy = " + knightsToBuy);
            if (this.ourPlayerData.getGame().getNumDevCards() >= knightsToBuy) {
                SOCResourceSet targetResources = new SOCResourceSet();
                for (int i = 0; i < knightsToBuy; ++i) {
                    targetResources.add(SOCDevCard.COST);
                }
                laETA = ourBSE.calculateRollsFast(this.ourPlayerData.getResources(), targetResources, 100, this.ourPlayerData.getPortFlags());
            }
            if (laETA < bestETA && !forSpecialBuildingPhase) {
                bestETA = laETA;
                choice = 0;
            }
            D.ebugPrintlnINFO("laETA = " + laETA);
            D.ebugPrintlnINFO("Calculating Longest Road ETA");
            int lrETA = 500;
            Vector bestLRPath = null;
            SOCPlayer lrPlayer = this.game.getPlayerWithLongestRoad();
            if (lrPlayer != null && lrPlayer.getPlayerNumber() == this.ourPlayerNumber) {
                D.ebugPrintlnINFO("We have longest road");
            } else if (!this.game.isGameOptionSet("_SC_0RVP")) {
                int lrLength = lrPlayer == null ? Math.max(4, this.ourPlayerData.getLongestRoadLength()) : lrPlayer.getLongestRoadLength();
                for (SOCLRPathData pathData : this.ourPlayerData.getLRPaths()) {
                    int depth = Math.min(lrLength + 1 - pathData.getLength(), this.ourPlayerData.getNumPieces(0));
                    Stack path = (Stack)SOCRobotDM.recalcLongestRoadETAAux(this.ourPlayerData, true, pathData.getBeginning(), pathData.getLength(), lrLength, depth);
                    if (path != null && (bestLRPath == null || path.size() < bestLRPath.size())) {
                        bestLRPath = path;
                    }
                    if ((path = (Stack)SOCRobotDM.recalcLongestRoadETAAux(this.ourPlayerData, true, pathData.getEnd(), pathData.getLength(), lrLength, depth)) == null || bestLRPath != null && path.size() >= bestLRPath.size()) continue;
                    bestLRPath = path;
                }
                if (bestLRPath != null) {
                    D.ebugPrintlnINFO("Number of roads: " + bestLRPath.size());
                    SOCResourceSet targetResources = new SOCResourceSet();
                    for (int i = 0; i < bestLRPath.size(); ++i) {
                        targetResources.add(SOCRoad.COST);
                    }
                    lrETA = ourBSE.calculateRollsFast(this.ourPlayerData.getResources(), targetResources, 100, this.ourPlayerData.getPortFlags());
                }
            }
            if (lrETA < bestETA) {
                bestETA = lrETA;
                choice = 1;
            }
            D.ebugPrintlnINFO("lrETA = " + lrETA);
            if (this.ourPlayerData.getNumPieces(2) > 0 && buildingETAs[2] <= bestETA) {
                for (SOCPossibleCity posCity : this.ourPlayerTracker.getPossibleCities().values()) {
                    if (this.brain != null && this.brain.getDRecorder().isOn()) {
                        this.brain.getDRecorder().startRecording("CITY" + posCity.getCoordinates());
                        this.brain.getDRecorder().record("Estimate speedup of city at " + this.game.getBoard().nodeCoordToString(posCity.getCoordinates()));
                        this.brain.getDRecorder().record("Speedup = " + posCity.getSpeedupTotal());
                        this.brain.getDRecorder().record("ETA = " + buildingETAs[2]);
                        this.brain.getDRecorder().stopRecording();
                    }
                    if (this.favoriteCity != null && posCity.getSpeedupTotal() <= this.favoriteCity.getSpeedupTotal()) continue;
                    this.favoriteCity = posCity;
                    bestETA = buildingETAs[2];
                    choice = 2;
                }
            }
            if (this.ourPlayerData.getNumPieces(1) > 0) {
                this.scoreSettlementsForDumb(buildingETAs[1], ourBSE);
                for (SOCPossibleSettlement posSet : this.ourPlayerTracker.getPossibleSettlements().values()) {
                    if (this.brain != null && this.brain.getDRecorder().isOn()) {
                        this.brain.getDRecorder().startRecording("SETTLEMENT" + posSet.getCoordinates());
                        this.brain.getDRecorder().record("Estimate speedup of stlmt at " + this.game.getBoard().nodeCoordToString(posSet.getCoordinates()));
                        this.brain.getDRecorder().record("Speedup = " + posSet.getSpeedupTotal());
                        this.brain.getDRecorder().record("ETA = " + posSet.getETA());
                        Stack<SOCPossibleRoad> roadPath = posSet.getRoadPath();
                        if (roadPath != null) {
                            this.brain.getDRecorder().record("Path:");
                            for (SOCPossibleRoad posRoad : roadPath) {
                                this.brain.getDRecorder().record("Road at " + this.game.getBoard().edgeCoordToString(posRoad.getCoordinates()));
                            }
                        }
                        this.brain.getDRecorder().stopRecording();
                    }
                    if (posSet.getRoadPath() != null && this.ourPlayerData.getNumPieces(0) < posSet.getRoadPath().size()) continue;
                    if (posSet.getETA() < bestETA) {
                        bestETA = posSet.getETA();
                        this.favoriteSettlement = posSet;
                        choice = 3;
                        continue;
                    }
                    if (posSet.getETA() != bestETA) continue;
                    if (this.favoriteSettlement == null) {
                        if (this.favoriteCity != null && posSet.getSpeedupTotal() <= this.favoriteCity.getSpeedupTotal()) continue;
                        this.favoriteSettlement = posSet;
                        choice = 3;
                        continue;
                    }
                    if (posSet.getSpeedupTotal() <= this.favoriteSettlement.getSpeedupTotal()) continue;
                    this.favoriteSettlement = posSet;
                }
            }
            if ((this.game.isGameOptionSet("_SC_PIRI") || this.game.isGameOptionSet("_SC_WOND")) && this.scenarioGameStrategyPlan(bestETA, -1.0f, false, choice == 0, ourBSE, 0, forSpecialBuildingPhase)) {
                return;
            }
            switch (choice) {
                case 0: {
                    D.ebugPrintlnINFO("Picked LA");
                    if (forSpecialBuildingPhase) break;
                    for (int i = 0; i < knightsToBuy; ++i) {
                        SOCPossibleCard posCard = new SOCPossibleCard(this.ourPlayerData, 1);
                        this.buildingPlan.push(posCard);
                    }
                    break;
                }
                case 1: {
                    D.ebugPrintlnINFO("Picked LR");
                    while (!((Stack)bestLRPath).empty()) {
                        SOCPossibleRoad pr = (SOCPossibleRoad)((Stack)bestLRPath).pop();
                        D.ebugPrintlnINFO("LR road at " + this.game.getBoard().edgeCoordToString(pr.getCoordinates()));
                        this.buildingPlan.push(pr);
                    }
                    break;
                }
                case 2: {
                    D.ebugPrintlnINFO("Picked favorite city at " + this.game.getBoard().nodeCoordToString(this.favoriteCity.getCoordinates()));
                    this.buildingPlan.push(this.favoriteCity);
                    break;
                }
                case 3: {
                    D.ebugPrintlnINFO("Picked favorite settlement at " + this.game.getBoard().nodeCoordToString(this.favoriteSettlement.getCoordinates()));
                    this.buildingPlan.push(this.favoriteSettlement);
                    if (this.favoriteSettlement.getNecessaryRoads().isEmpty()) break;
                    Stack<SOCPossibleRoad> roadPath = this.favoriteSettlement.getRoadPath();
                    while (!roadPath.empty()) {
                        SOCPossibleRoad pr = roadPath.pop();
                        D.ebugPrintlnINFO("Nec road at " + this.game.getBoard().edgeCoordToString(pr.getCoordinates()));
                        this.buildingPlan.push(pr);
                    }
                    break;
                }
            }
        }
    }

    protected void scoreSettlementsForDumb(int settlementETA, SOCBuildingSpeedEstimate ourBSE) {
        D.ebugPrintlnINFO("-- scoreSettlementsForDumb --");
        Queue<Pair<SOCPossibleRoad, Object>> queue = new Queue<Pair<SOCPossibleRoad, Object>>();
        for (SOCPossibleSettlement posSet : this.ourPlayerTracker.getPossibleSettlements().values()) {
            List<SOCPossibleRoad> necRoadList = posSet.getNecessaryRoads();
            if (!necRoadList.isEmpty()) {
                queue.clear();
                for (SOCPossibleRoad necRoad : necRoadList) {
                    queue.put(new Pair<SOCPossibleRoad, Object>(necRoad, null));
                }
                boolean pathTooLong = false;
                for (int maxIter = 50; maxIter > 0 && !queue.empty(); --maxIter) {
                    Pair dataPair = (Pair)queue.get();
                    SOCPossibleRoad curRoad = (SOCPossibleRoad)dataPair.getA();
                    List possRoadsToCur = (List)dataPair.getB();
                    List<SOCPossibleRoad> necRoads = curRoad.getNecessaryRoads();
                    if (necRoads.isEmpty()) {
                        D.ebugPrintlnINFO("Found a path!");
                        Stack<SOCPossibleRoad> path = new Stack<SOCPossibleRoad>();
                        path.push(curRoad);
                        if (possRoadsToCur != null) {
                            for (int i = possRoadsToCur.size() - 1; i >= 0; --i) {
                                path.push((SOCPossibleRoad)possRoadsToCur.get(i));
                            }
                        }
                        posSet.setRoadPath(path);
                        queue.clear();
                        D.ebugPrintlnINFO("Done setting path.");
                        continue;
                    }
                    ArrayList<SOCPossibleRoad> possRoadsAndCur = possRoadsToCur != null ? new ArrayList<SOCPossibleRoad>(possRoadsToCur) : new ArrayList();
                    possRoadsAndCur.add(curRoad);
                    if (queue.size() + necRoads.size() > 40) {
                        System.err.println("rDM.scoreSettlementsForDumb: Necessary Road Path too long for road/ship 0x" + Integer.toHexString(curRoad.getCoordinates()) + " for settle 0x" + Integer.toHexString(posSet.getCoordinates()));
                        pathTooLong = true;
                        queue.clear();
                        break;
                    }
                    for (SOCPossibleRoad necRoad2 : necRoads) {
                        queue.put(new Pair(necRoad2, possRoadsAndCur));
                    }
                }
                if (!queue.empty()) {
                    System.err.println("rDM.scoreSettlementsForDumb: Necessary Road Path length unresolved for settle 0x" + Integer.toHexString(posSet.getCoordinates()));
                    pathTooLong = true;
                }
                D.ebugPrintlnINFO("Done searching for path.");
                if (pathTooLong) {
                    posSet.setETA(500);
                } else {
                    SOCResourceSet targetResources = new SOCResourceSet();
                    targetResources.add(SOCSettlement.COST);
                    Stack<SOCPossibleRoad> path = posSet.getRoadPath();
                    if (path != null) {
                        int pathLength = path.size();
                        SOCPossiblePiece pathFirst = pathLength > 0 ? (SOCPossiblePiece)path.peek() : null;
                        SOCResourceSet rtype = pathFirst != null && pathFirst instanceof SOCPossibleShip && !((SOCPossibleShip)pathFirst).isCoastalRoadAndShip ? SOCShip.COST : SOCRoad.COST;
                        for (int i = 0; i < pathLength; ++i) {
                            targetResources.add(rtype);
                        }
                    }
                    posSet.setETA(ourBSE.calculateRollsFast(this.ourPlayerData.getResources(), targetResources, 100, this.ourPlayerData.getPortFlags()));
                }
            } else {
                posSet.setRoadPath(null);
                posSet.setETA(settlementETA);
            }
            D.ebugPrintlnINFO("Settlement ETA = " + posSet.getETA());
        }
    }

    protected void planRoadBuildingTwoRoads() {
        SOCPossibleRoad secondFavoriteRoad = null;
        D.ebugPrintlnINFO("*** making a plan for road building");
        if (this.favoriteRoad != null) {
            SOCRoutePiece tmpRS = this.favoriteRoad instanceof SOCPossibleShip && !((SOCPossibleShip)this.favoriteRoad).isCoastalRoadAndShip ? new SOCShip(this.ourPlayerData, this.favoriteRoad.getCoordinates(), null) : new SOCRoad(this.ourPlayerData, this.favoriteRoad.getCoordinates(), null);
            SOCPlayerTracker[] trackersCopy = SOCPlayerTracker.tryPutPiece(tmpRS, this.game, this.playerTrackers);
            SOCPlayerTracker.updateWinGameETAs(trackersCopy);
            SOCPlayerTracker ourPlayerTrackerCopy = trackersCopy[this.ourPlayerNumber];
            int ourCurrentWGETACopy = ourPlayerTrackerCopy.getWinGameETA();
            D.ebugPrintlnINFO("ourCurrentWGETACopy = " + ourCurrentWGETACopy);
            int leadersCurrentWGETACopy = ourCurrentWGETACopy;
            for (SOCPlayerTracker tracker : trackersCopy) {
                int wgeta;
                if (tracker == null || (wgeta = tracker.getWinGameETA()) >= leadersCurrentWGETACopy) continue;
                leadersCurrentWGETACopy = wgeta;
            }
            for (SOCPossiblePiece newPos : this.favoriteRoad.getNewPossibilities()) {
                if (!(newPos instanceof SOCPossibleRoad)) continue;
                newPos.resetScore();
                D.ebugPrintlnINFO("$$$ new pos road at " + Integer.toHexString(newPos.getCoordinates()));
                if (this.favoriteRoad.getCoordinates() == newPos.getCoordinates()) continue;
                if (secondFavoriteRoad == null) {
                    secondFavoriteRoad = (SOCPossibleRoad)newPos;
                    continue;
                }
                if (!(newPos.getScore() > secondFavoriteRoad.getScore())) continue;
                secondFavoriteRoad = (SOCPossibleRoad)newPos;
            }
            for (SOCPossibleRoad threatenedRoad : this.threatenedRoads) {
                D.ebugPrintlnINFO("$$$ threatened road at " + Integer.toHexString(threatenedRoad.getCoordinates()));
                threatenedRoad.resetScore();
                D.ebugPrintlnINFO("$$$  final score = 0");
                if (this.favoriteRoad.getCoordinates() == threatenedRoad.getCoordinates()) continue;
                if (secondFavoriteRoad == null) {
                    secondFavoriteRoad = threatenedRoad;
                    continue;
                }
                if (!(threatenedRoad.getScore() > secondFavoriteRoad.getScore())) continue;
                secondFavoriteRoad = threatenedRoad;
            }
            for (SOCPossibleRoad goodRoad : this.goodRoads) {
                D.ebugPrintlnINFO("$$$ good road at " + Integer.toHexString(goodRoad.getCoordinates()));
                goodRoad.resetScore();
                D.ebugPrintlnINFO("$$$  final score = 0");
                if (this.favoriteRoad.getCoordinates() == goodRoad.getCoordinates()) continue;
                if (secondFavoriteRoad == null) {
                    secondFavoriteRoad = goodRoad;
                    continue;
                }
                if (!(goodRoad.getScore() > secondFavoriteRoad.getScore())) continue;
                secondFavoriteRoad = goodRoad;
            }
            SOCPlayerTracker.undoTryPutPiece(tmpRS, this.game);
            if (!this.buildingPlan.isEmpty()) {
                SOCPossiblePiece planPeek = (SOCPossiblePiece)this.buildingPlan.peek();
                if (planPeek == null || !(planPeek instanceof SOCPossibleRoad)) {
                    if (secondFavoriteRoad != null) {
                        D.ebugPrintlnINFO("### SECOND FAVORITE ROAD IS AT " + Integer.toHexString(secondFavoriteRoad.getCoordinates()));
                        D.ebugPrintlnINFO("###   WITH A SCORE OF " + secondFavoriteRoad.getScore());
                        D.ebugPrintlnINFO("$ PUSHING " + secondFavoriteRoad);
                        this.buildingPlan.push(secondFavoriteRoad);
                        D.ebugPrintlnINFO("$ PUSHING " + this.favoriteRoad);
                        this.buildingPlan.push(this.favoriteRoad);
                    }
                } else if (secondFavoriteRoad != null) {
                    SOCPossiblePiece tmp = (SOCPossiblePiece)this.buildingPlan.pop();
                    D.ebugPrintlnINFO("$ POPPED OFF");
                    D.ebugPrintlnINFO("### SECOND FAVORITE ROAD IS AT " + Integer.toHexString(secondFavoriteRoad.getCoordinates()));
                    D.ebugPrintlnINFO("###   WITH A SCORE OF " + secondFavoriteRoad.getScore());
                    D.ebugPrintlnINFO("$ PUSHING " + secondFavoriteRoad);
                    this.buildingPlan.push(secondFavoriteRoad);
                    D.ebugPrintlnINFO("$ PUSHING " + tmp);
                    this.buildingPlan.push(tmp);
                }
            }
        }
    }

    protected static Object recalcLongestRoadETAAux(SOCPlayer pl, boolean wantsStack, int startNode, int pathLength, int lrLength, int searchDepth) {
        int longest = 0;
        int numRoads = 500;
        Pair bestPathNode = null;
        SOCBoard board = pl.getGame().getBoard();
        Stack<Pair<NodeLenVis<Object>, Object>> pending = new Stack<Pair<NodeLenVis<Object>, Object>>();
        pending.push(new Pair(new NodeLenVis(startNode, pathLength, new Vector()), null));
        while (!pending.empty()) {
            Pair dataPair = (Pair)pending.pop();
            NodeLenVis curNode = (NodeLenVis)dataPair.getA();
            int coord = curNode.node;
            int len = curNode.len;
            Vector visited = curNode.vis;
            boolean pathEnd = false;
            if (len > 0) {
                int pn = pl.getPlayerNumber();
                SOCPlayingPiece p = board.settlementAtNode(coord);
                if (p != null && p.getPlayerNumber() != pn) {
                    pathEnd = true;
                }
            }
            if (!pathEnd) {
                for (SOCLRPathData pathData : pl.getLRPaths()) {
                    if (startNode == pathData.getBeginning() || startNode == pathData.getEnd() || coord != pathData.getBeginning() && coord != pathData.getEnd()) continue;
                    pathEnd = true;
                    len += pathData.getLength();
                    break;
                }
            }
            if (!pathEnd && len - pathLength >= searchDepth) {
                pathEnd = true;
            }
            if (!pathEnd) {
                pathEnd = true;
                for (int dir = 0; dir < 3; ++dir) {
                    int j = board.getAdjacentEdgeToNode(coord, dir);
                    if (!pl.isLegalRoad(j)) continue;
                    Integer edge = j;
                    boolean match = false;
                    Enumeration ev = visited.elements();
                    while (ev.hasMoreElements()) {
                        Integer vis = (Integer)ev.nextElement();
                        if (!vis.equals(edge)) continue;
                        match = true;
                        break;
                    }
                    if (match) continue;
                    Vector newVis = new Vector(visited);
                    newVis.addElement(edge);
                    ArrayList<Integer> nodeParentList = (ArrayList<Integer>)dataPair.getB();
                    nodeParentList = nodeParentList == null ? new ArrayList<Integer>() : new ArrayList(nodeParentList);
                    nodeParentList.add(coord);
                    j = board.getAdjacentNodeToNode(coord, dir);
                    pending.push(new Pair(new NodeLenVis(j, len + 1, newVis), nodeParentList));
                    pathEnd = false;
                }
            }
            if (!pathEnd) continue;
            if (len > longest) {
                longest = len;
                numRoads = curNode.len - pathLength;
                bestPathNode = dataPair;
                continue;
            }
            if (len != longest || curNode.len >= numRoads) continue;
            numRoads = curNode.len - pathLength;
            bestPathNode = dataPair;
        }
        if (!wantsStack) {
            int rv = longest > lrLength ? numRoads : 500;
            return rv;
        }
        if (longest > lrLength && bestPathNode != null) {
            Stack<SOCPossibleRoad> path = new Stack<SOCPossibleRoad>();
            List nodeList = (List)bestPathNode.getB();
            if (nodeList == null || nodeList.isEmpty()) {
                return null;
            }
            nodeList.add(((NodeLenVis)bestPathNode.getA()).node);
            int L = nodeList.size();
            int coordP = (Integer)nodeList.get(0);
            for (int i = 1; i < L; ++i) {
                int coordC = (Integer)nodeList.get(i);
                path.push(new SOCPossibleRoad(pl, board.getEdgeBetweenAdjacentNodes(coordC, coordP), null));
                coordP = coordC;
            }
            return path;
        }
        return null;
    }

    protected void smartGameStrategy(int[] buildingETAs) {
        int road_eta_type;
        D.ebugPrintlnINFO("***** smartGameStrategy *****");
        boolean forSpecialBuildingPhase = this.game.isSpecialBuilding() || this.game.getCurrentPlayerNumber() != this.ourPlayerNumber;
        List[] savedLRPaths = new List[this.game.maxPlayers];
        for (int pn = 0; pn < this.game.maxPlayers; ++pn) {
            savedLRPaths[pn] = new ArrayList();
            savedLRPaths[pn].addAll(this.game.getPlayer(pn).getLRPaths());
        }
        int ourCurrentWGETA = this.ourPlayerTracker.getWinGameETA();
        D.ebugPrintlnINFO("ourCurrentWGETA = " + ourCurrentWGETA);
        int leadersCurrentWGETA = ourCurrentWGETA;
        for (SOCPlayerTracker tracker : this.playerTrackers) {
            int wgeta;
            if (tracker == null || (wgeta = tracker.getWinGameETA()) >= leadersCurrentWGETA) continue;
            leadersCurrentWGETA = wgeta;
        }
        if (this.ourPlayerData.getNumPieces(1) > 0) {
            this.scorePossibleSettlements(buildingETAs[1], leadersCurrentWGETA);
        }
        if (this.ourPlayerData.getNumPieces(0) > 0) {
            for (SOCPossibleRoad posRoad : this.ourPlayerTracker.getPossibleRoads().values()) {
                if (!posRoad.isRoadNotShip() || !posRoad.getNecessaryRoads().isEmpty() || this.threatenedRoads.contains(posRoad) || this.goodRoads.contains(posRoad)) continue;
                this.goodRoads.add(posRoad);
            }
        }
        if (this.ourPlayerData.getNumPieces(3) > 0) {
            SOCBoard board = this.game.getBoard();
            int pirateHex = board instanceof SOCBoardLarge ? ((SOCBoardLarge)board).getPirateHex() : 0;
            int[] pirateEdges = pirateHex != 0 ? ((SOCBoardLarge)board).getAdjacentEdgesToHex_arr(pirateHex) : null;
            for (SOCPossibleRoad posRoad : this.ourPlayerTracker.getPossibleRoads().values()) {
                if (posRoad.isRoadNotShip() || !posRoad.getNecessaryRoads().isEmpty() || this.threatenedRoads.contains(posRoad) || this.goodRoads.contains(posRoad)) continue;
                boolean edgeOK = true;
                if (pirateEdges != null) {
                    int edge = posRoad.getCoordinates();
                    for (int i = 0; i < pirateEdges.length; ++i) {
                        if (edge != pirateEdges[i]) continue;
                        edgeOK = false;
                        break;
                    }
                }
                if (!edgeOK) continue;
                this.goodRoads.add(posRoad);
            }
        }
        D.ebugPrintlnINFO("PICKING WHAT TO BUILD");
        if (this.ourPlayerData.getNumPieces(1) > 0) {
            for (SOCPossibleSettlement threatenedSet : this.threatenedSettlements) {
                if (!threatenedSet.getNecessaryRoads().isEmpty()) continue;
                D.ebugPrintlnINFO("$$$$$ threatened settlement at " + Integer.toHexString(threatenedSet.getCoordinates()) + " has a score of " + threatenedSet.getScore());
                if (this.favoriteSettlement != null && !(threatenedSet.getScore() > this.favoriteSettlement.getScore())) continue;
                this.favoriteSettlement = threatenedSet;
            }
            for (SOCPossibleSettlement goodSet : this.goodSettlements) {
                if (!goodSet.getNecessaryRoads().isEmpty()) continue;
                D.ebugPrintlnINFO("$$$$$ good settlement at " + Integer.toHexString(goodSet.getCoordinates()) + " has a score of " + goodSet.getScore());
                if (this.favoriteSettlement != null && !(goodSet.getScore() > this.favoriteSettlement.getScore())) continue;
                this.favoriteSettlement = goodSet;
            }
        }
        D.ebugPrintlnINFO("%%% RESTORING LRPATH LIST %%%");
        for (int pn = 0; pn < this.game.maxPlayers; ++pn) {
            this.game.getPlayer(pn).setLRPaths(savedLRPaths[pn]);
        }
        if (this.ourPlayerData.getNumPieces(0) > 0) {
            for (SOCPossibleRoad threatenedRoad : this.threatenedRoads) {
                D.ebugPrintlnINFO("$$$$$ threatened road at " + Integer.toHexString(threatenedRoad.getCoordinates()));
                if (this.brain != null && this.brain.getDRecorder().isOn()) {
                    this.brain.getDRecorder().startRecording((threatenedRoad.isRoadNotShip() ? "ROAD" : "SHIP") + threatenedRoad.getCoordinates());
                    this.brain.getDRecorder().record("Estimate value of road at " + this.game.getBoard().edgeCoordToString(threatenedRoad.getCoordinates()));
                }
                threatenedRoad.resetScore();
                float wgetaScore = this.getWinGameETABonusForRoad(threatenedRoad, buildingETAs[0], leadersCurrentWGETA, this.playerTrackers);
                if (this.brain != null && this.brain.getDRecorder().isOn()) {
                    this.brain.getDRecorder().stopRecording();
                }
                D.ebugPrintlnINFO("wgetaScore = " + wgetaScore);
                if (this.favoriteRoad == null) {
                    this.favoriteRoad = threatenedRoad;
                    continue;
                }
                if (!(threatenedRoad.getScore() > this.favoriteRoad.getScore())) continue;
                this.favoriteRoad = threatenedRoad;
            }
            for (SOCPossibleRoad goodRoad : this.goodRoads) {
                D.ebugPrintlnINFO("$$$$$ good road at " + Integer.toHexString(goodRoad.getCoordinates()));
                if (this.brain != null && this.brain.getDRecorder().isOn()) {
                    this.brain.getDRecorder().startRecording((goodRoad.isRoadNotShip() ? "ROAD" : "SHIP") + goodRoad.getCoordinates());
                    this.brain.getDRecorder().record("Estimate value of road at " + this.game.getBoard().edgeCoordToString(goodRoad.getCoordinates()));
                }
                goodRoad.resetScore();
                int etype = goodRoad instanceof SOCPossibleShip && !((SOCPossibleShip)goodRoad).isCoastalRoadAndShip ? 0 : 4;
                float wgetaScore = this.getWinGameETABonusForRoad(goodRoad, buildingETAs[etype], leadersCurrentWGETA, this.playerTrackers);
                if (this.brain != null && this.brain.getDRecorder().isOn()) {
                    this.brain.getDRecorder().stopRecording();
                }
                D.ebugPrintlnINFO("wgetaScore = " + wgetaScore);
                if (this.favoriteRoad == null) {
                    this.favoriteRoad = goodRoad;
                    continue;
                }
                if (!(goodRoad.getScore() > this.favoriteRoad.getScore())) continue;
                this.favoriteRoad = goodRoad;
            }
        }
        D.ebugPrintlnINFO("%%% RESTORING LRPATH LIST %%%");
        for (int pn = 0; pn < this.game.maxPlayers; ++pn) {
            this.game.getPlayer(pn).setLRPaths(savedLRPaths[pn]);
        }
        if (this.ourPlayerData.getNumPieces(2) > 0) {
            SOCPlayerTracker[] trackersCopy = SOCPlayerTracker.copyPlayerTrackers(this.playerTrackers);
            SOCPlayerTracker ourTrackerCopy = trackersCopy[this.ourPlayerNumber];
            int[] originalWGETAs = new int[this.game.maxPlayers];
            int[] WGETAdiffs = new int[this.game.maxPlayers];
            Vector<SOCPlayerTracker> leaders = new Vector<SOCPlayerTracker>();
            int bestWGETA = 1000;
            for (SOCPossibleCity posCity : this.ourPlayerTracker.getPossibleCities().values()) {
                if (this.brain != null && this.brain.getDRecorder().isOn()) {
                    this.brain.getDRecorder().startRecording("CITY" + posCity.getCoordinates());
                    this.brain.getDRecorder().record("Estimate value of city at " + this.game.getBoard().nodeCoordToString(posCity.getCoordinates()));
                }
                leaders.clear();
                if (this.brain != null && this.brain.getDRecorder().isOn()) {
                    this.brain.getDRecorder().suspend();
                }
                SOCPlayerTracker.updateWinGameETAs(trackersCopy);
                for (SOCPlayerTracker trackerBefore : trackersCopy) {
                    if (trackerBefore == null) continue;
                    int pn = trackerBefore.getPlayer().getPlayerNumber();
                    D.ebugPrintlnINFO("$$$ win game ETA for player " + pn + " = " + trackerBefore.getWinGameETA());
                    originalWGETAs[pn] = trackerBefore.getWinGameETA();
                    WGETAdiffs[pn] = trackerBefore.getWinGameETA();
                    if (trackerBefore.getWinGameETA() < bestWGETA) {
                        bestWGETA = trackerBefore.getWinGameETA();
                        leaders.removeAllElements();
                        leaders.addElement(trackerBefore);
                        continue;
                    }
                    if (trackerBefore.getWinGameETA() != bestWGETA) continue;
                    leaders.addElement(trackerBefore);
                }
                D.ebugPrintlnINFO("^^^^ bestWGETA = " + bestWGETA);
                if (this.brain != null && this.brain.getDRecorder().isOn()) {
                    this.brain.getDRecorder().resume();
                }
                SOCCity tmpCity = new SOCCity(this.ourPlayerData, posCity.getCoordinates(), null);
                this.game.putTempPiece(tmpCity);
                ourTrackerCopy.addOurNewCity(tmpCity);
                SOCPlayerTracker.updateWinGameETAs(trackersCopy);
                float wgetaScore = this.calcWGETABonusAux(originalWGETAs, trackersCopy, leaders);
                ourTrackerCopy.undoAddOurNewCity(posCity);
                this.game.undoPutTempPiece(tmpCity);
                D.ebugPrintlnINFO("*** ETA for city = " + buildingETAs[2]);
                if (this.brain != null && this.brain.getDRecorder().isOn()) {
                    this.brain.getDRecorder().record("ETA = " + buildingETAs[2]);
                }
                float etaBonus = this.getETABonus(buildingETAs[2], leadersCurrentWGETA, wgetaScore);
                D.ebugPrintlnINFO("etaBonus = " + etaBonus);
                posCity.addToScore(etaBonus);
                if (this.brain != null && this.brain.getDRecorder().isOn()) {
                    this.brain.getDRecorder().record("WGETA score = " + df1.format(wgetaScore));
                    this.brain.getDRecorder().record("Total city score = " + df1.format(etaBonus));
                    this.brain.getDRecorder().stopRecording();
                }
                D.ebugPrintlnINFO("$$$  final score = " + posCity.getScore());
                D.ebugPrintlnINFO("$$$$$ possible city at " + Integer.toHexString(posCity.getCoordinates()) + " has a score of " + posCity.getScore());
                if (this.favoriteCity != null && !(posCity.getScore() > this.favoriteCity.getScore())) continue;
                this.favoriteCity = posCity;
            }
        }
        if (this.favoriteSettlement != null) {
            D.ebugPrintlnINFO("### FAVORITE SETTLEMENT IS AT " + Integer.toHexString(this.favoriteSettlement.getCoordinates()));
            D.ebugPrintlnINFO("###   WITH A SCORE OF " + this.favoriteSettlement.getScore());
            D.ebugPrintlnINFO("###   WITH AN ETA OF " + buildingETAs[1]);
            D.ebugPrintlnINFO("###   WITH A TOTAL SPEEDUP OF " + this.favoriteSettlement.getSpeedupTotal());
        }
        if (this.favoriteCity != null) {
            D.ebugPrintlnINFO("### FAVORITE CITY IS AT " + Integer.toHexString(this.favoriteCity.getCoordinates()));
            D.ebugPrintlnINFO("###   WITH A SCORE OF " + this.favoriteCity.getScore());
            D.ebugPrintlnINFO("###   WITH AN ETA OF " + buildingETAs[2]);
            D.ebugPrintlnINFO("###   WITH A TOTAL SPEEDUP OF " + this.favoriteCity.getSpeedupTotal());
        }
        int n = road_eta_type = this.favoriteRoad != null && this.favoriteRoad instanceof SOCPossibleShip && !((SOCPossibleShip)this.favoriteRoad).isCoastalRoadAndShip ? 4 : 0;
        if (this.favoriteRoad != null) {
            D.ebugPrintlnINFO("### FAVORITE ROAD IS AT " + Integer.toHexString(this.favoriteRoad.getCoordinates()));
            D.ebugPrintlnINFO("###   WITH AN ETA OF " + buildingETAs[road_eta_type]);
            D.ebugPrintlnINFO("###   WITH A SCORE OF " + this.favoriteRoad.getScore());
        }
        int pick = -1;
        float pickScore = 0.0f;
        if (this.favoriteCity != null && this.ourPlayerData.getNumPieces(2) > 0 && this.favoriteCity.getScore() > 0.0f && (this.favoriteSettlement == null || this.ourPlayerData.getNumPieces(1) == 0 || this.favoriteCity.getScore() > this.favoriteSettlement.getScore() || this.favoriteCity.getScore() == this.favoriteSettlement.getScore() && buildingETAs[2] < buildingETAs[1]) && (this.favoriteRoad == null || this.ourPlayerData.getNumPieces(this.favoriteRoad.getType()) == 0 || this.favoriteCity.getScore() > this.favoriteRoad.getScore() || this.favoriteCity.getScore() == this.favoriteRoad.getScore() && buildingETAs[2] < buildingETAs[road_eta_type])) {
            D.ebugPrintlnINFO("### PICKED FAVORITE CITY");
            pick = 2;
            pickScore = this.favoriteCity.getScore();
        } else if (this.favoriteRoad != null && this.ourPlayerData.getNumPieces(this.favoriteRoad.getType()) > 0 && this.favoriteRoad.getScore() > 0.0f && (this.favoriteSettlement == null || this.ourPlayerData.getNumPieces(1) == 0 || this.favoriteSettlement.getScore() < this.favoriteRoad.getScore())) {
            D.ebugPrintlnINFO("### PICKED FAVORITE ROAD");
            pick = 0;
            pickScore = this.favoriteRoad.getScore();
        } else if (this.favoriteSettlement != null && this.ourPlayerData.getNumPieces(1) > 0) {
            D.ebugPrintlnINFO("### PICKED FAVORITE SETTLEMENT");
            pick = 1;
            pickScore = this.favoriteSettlement.getScore();
        }
        float devCardScore = 0.0f;
        if (this.game.getNumDevCards() > 0 && !forSpecialBuildingPhase) {
            if (this.brain != null && this.brain.getDRecorder().isOn()) {
                this.brain.getDRecorder().startRecording("DEVCARD");
                this.brain.getDRecorder().record("Estimate value of a dev card");
            }
            this.possibleCard = this.getDevCardScore(buildingETAs[3], leadersCurrentWGETA);
            devCardScore = this.possibleCard.getScore();
            D.ebugPrintlnINFO("### DEV CARD SCORE: " + devCardScore);
            if (this.brain != null && this.brain.getDRecorder().isOn()) {
                this.brain.getDRecorder().stopRecording();
            }
            if (pick == -1 || devCardScore > pickScore) {
                D.ebugPrintlnINFO("### BUY DEV CARD");
                pick = 6;
                pickScore = devCardScore;
            }
        }
        if ((this.game.isGameOptionSet("_SC_PIRI") || this.game.isGameOptionSet("_SC_WOND")) && this.scenarioGameStrategyPlan(pickScore, devCardScore, true, pick == 6, this.getEstimator(this.ourPlayerData.getNumbers()), leadersCurrentWGETA, forSpecialBuildingPhase)) {
            return;
        }
        switch (pick) {
            case 0: {
                D.ebugPrintlnINFO("$ PUSHING " + this.favoriteRoad);
                this.buildingPlan.push(this.favoriteRoad);
                break;
            }
            case 1: {
                D.ebugPrintlnINFO("$ PUSHING " + this.favoriteSettlement);
                this.buildingPlan.push(this.favoriteSettlement);
                break;
            }
            case 2: {
                D.ebugPrintlnINFO("$ PUSHING " + this.favoriteCity);
                this.buildingPlan.push(this.favoriteCity);
                break;
            }
            case 6: {
                D.ebugPrintlnINFO("$ PUSHING " + this.possibleCard);
                this.buildingPlan.push(this.possibleCard);
            }
        }
    }

    protected boolean scenarioGameStrategyPlan(float bestScoreOrETA, float cardScoreOrETA, boolean isScoreNotETA, boolean bestPlanIsDevCard, SOCBuildingSpeedEstimate ourBSE, int leadersCurrentWGETA, boolean forSpecialBuildingPhase) throws IllegalArgumentException {
        if (this.game.isGameOptionSet("_SC_PIRI")) {
            return this.scenarioGameStrategyPlan_SC_PIRI(bestScoreOrETA, cardScoreOrETA, isScoreNotETA, bestPlanIsDevCard, ourBSE, leadersCurrentWGETA, forSpecialBuildingPhase);
        }
        if (this.game.isGameOptionSet("_SC_WOND")) {
            return this.scenarioGameStrategyPlan_SC_WOND(bestScoreOrETA, cardScoreOrETA, isScoreNotETA, bestPlanIsDevCard, ourBSE, leadersCurrentWGETA, forSpecialBuildingPhase);
        }
        return false;
    }

    private final boolean scenarioGameStrategyPlan_SC_PIRI(float bestScoreOrETA, float cardScoreOrETA, boolean isScoreNotETA, boolean bestPlanIsDevCard, SOCBuildingSpeedEstimate ourBSE, int leadersCurrentWGETA, boolean forSpecialBuildingPhase) throws IllegalArgumentException {
        float scenPlanScoreOrETA;
        float shipScoreOrETA;
        int ourVP = this.ourPlayerData.getTotalVP();
        if (ourVP < 4) {
            return false;
        }
        int ourNumWarships = this.ourPlayerData.getNumWarships();
        int shipsBuilt = 15 - this.ourPlayerData.getNumPieces(3);
        boolean mightBuildShip = false;
        if (shipsBuilt >= 6 && (ourVP < 6 || ourNumWarships < 2 || this.ourPlayerData.getFortress() == null)) {
            int shipETA = 100;
            shipScoreOrETA = 0.0f;
        } else {
            mightBuildShip = true;
            int shipETA = ourBSE.calculateRollsFast(this.ourPlayerData.getResources(), SOCShip.COST, 100, this.ourPlayerData.getPortFlags());
            if (!isScoreNotETA) {
                shipScoreOrETA = shipETA;
            } else {
                shipScoreOrETA = 100.0f / (float)this.game.maxPlayers;
                shipScoreOrETA += this.getETABonus(shipETA, leadersCurrentWGETA, shipScoreOrETA);
            }
        }
        boolean mightBuyWarshipCard = false;
        int warshipCardsInHand = this.ourPlayerData.getInventory().getAmount(9);
        if (warshipCardsInHand > 0) {
            cardScoreOrETA = 100.0f;
        } else if (cardScoreOrETA < 0.0f) {
            if (isScoreNotETA) {
                throw new IllegalArgumentException("cardScoreOrETA");
            }
            cardScoreOrETA = this.game.getNumDevCards() > 0 ? (float)ourBSE.calculateRollsFast(this.ourPlayerData.getResources(), SOCDevCard.COST, 100, this.ourPlayerData.getPortFlags()) : 100.0f;
        }
        if (ourNumWarships < 6 && this.game.getNumDevCards() > 0 && warshipCardsInHand == 0) {
            mightBuyWarshipCard = true;
        }
        if (!mightBuildShip && !mightBuyWarshipCard) {
            return false;
        }
        boolean betterScoreIsBuildShip = false;
        if (!mightBuyWarshipCard) {
            scenPlanScoreOrETA = shipScoreOrETA;
        } else if (!mightBuildShip) {
            scenPlanScoreOrETA = cardScoreOrETA;
        } else {
            betterScoreIsBuildShip = isScoreNotETA ? shipScoreOrETA > cardScoreOrETA : shipScoreOrETA < cardScoreOrETA;
            float f = scenPlanScoreOrETA = betterScoreIsBuildShip ? shipScoreOrETA : cardScoreOrETA;
        }
        if (isScoreNotETA ? bestScoreOrETA > scenPlanScoreOrETA : bestScoreOrETA < scenPlanScoreOrETA) {
            return false;
        }
        if (mightBuildShip) {
            if (mightBuyWarshipCard && !betterScoreIsBuildShip) {
                this.buildingPlan.push(new SOCPossibleCard(this.ourPlayerData, 1));
                return true;
            }
            if (this.scenarioGameStrategyPlan_SC_PIRI_buildNextShip()) {
                return true;
            }
        }
        if (mightBuyWarshipCard) {
            this.buildingPlan.push(new SOCPossibleCard(this.ourPlayerData, 1));
            return true;
        }
        return false;
    }

    private final boolean scenarioGameStrategyPlan_SC_PIRI_buildNextShip() {
        int prevShipNode;
        int c1;
        SOCShip prevShip = this.ourPlayerData.getMostRecentShip();
        if (prevShip == null) {
            return false;
        }
        SOCFortress fo = this.ourPlayerData.getFortress();
        if (fo == null) {
            return false;
        }
        int fortressNode = fo.getCoordinates();
        int[] nodes = prevShip.getAdjacentNodes();
        int c0 = nodes[0] & 0xFF;
        if (c0 < (c1 = nodes[1] & 0xFF)) {
            prevShipNode = nodes[0];
        } else if (c1 < c0) {
            prevShipNode = nodes[1];
        } else {
            int r0 = nodes[0] >> 8;
            int r1 = nodes[1] >> 8;
            int rFort = fortressNode >> 8;
            prevShipNode = Math.abs(rFort - r0) < Math.abs(rFort - r1) ? nodes[0] : nodes[1];
        }
        if (prevShipNode == fortressNode) {
            return false;
        }
        HashSet<Integer> lse = this.ourPlayerData.getRestrictedLegalShips();
        if (lse == null) {
            return false;
        }
        int edge1 = -9;
        int edge2 = -9;
        SOCBoard board = this.game.getBoard();
        int prevShipEdge = prevShip.getCoordinates();
        int[] nextPossiEdges = board.getAdjacentEdgesToNode_arr(prevShipNode);
        for (int i = 0; i < nextPossiEdges.length; ++i) {
            int cShip;
            int farNode;
            int cEdge;
            int edge = nextPossiEdges[i];
            if (edge == -9 || edge == prevShipEdge || !lse.contains(edge) || (cEdge = (farNode = board.getAdjacentNodeFarEndOfEdge(edge, prevShipNode)) & 0xFF) > (cShip = prevShipNode & 0xFF)) continue;
            if (cEdge == cShip) {
                int rShip = prevShipNode >> 8;
                int rFort = fortressNode >> 8;
                int rEdge = farNode >> 8;
                if (Math.abs(rFort - rEdge) > Math.abs(rFort - rShip)) continue;
            }
            if (edge1 == -9) {
                edge1 = edge;
                continue;
            }
            edge2 = edge;
        }
        if (edge1 == -9) {
            return false;
        }
        int newEdge = edge2 == -9 || Math.random() < 0.5 ? edge1 : edge2;
        this.buildingPlan.add(new SOCPossibleShip(this.ourPlayerData, newEdge, false, null));
        return true;
    }

    private final boolean scenarioGameStrategyPlan_SC_WOND(float bestScoreOrETA, float cardScoreOrETA, boolean isScoreNotETA, boolean bestPlanIsDevCard, SOCBuildingSpeedEstimate ourBSE, int leadersCurrentWGETA, boolean forSpecialBuildingPhase) throws IllegalArgumentException {
        float bestWondScoreOrETA;
        int bestETA;
        int ourVP = this.ourPlayerData.getTotalVP();
        if (ourVP < 4) {
            return false;
        }
        SOCSpecialItem bestWond = this.ourPlayerData.getSpecialItem("_SC_WOND", 0);
        int gi = -1;
        if (bestWond != null) {
            gi = bestWond.getGameIndex();
            bestETA = ourBSE.calculateRollsFast(this.ourPlayerData.getResources(), bestWond.getCost(), 100, this.ourPlayerData.getPortFlags());
            if (isScoreNotETA) {
                bestWondScoreOrETA = 100.0f / (float)this.game.maxPlayers;
                bestWondScoreOrETA += this.getETABonus(bestETA, leadersCurrentWGETA, bestWondScoreOrETA);
            } else {
                bestWondScoreOrETA = bestETA;
            }
        } else {
            int wETA = 0;
            float wScoreOrETA = 0.0f;
            int numWonders = 1 + this.game.maxPlayers;
            for (int i = 0; i < numWonders; ++i) {
                boolean isBetter;
                float scoreOrETA;
                SOCSpecialItem wond = this.game.getSpecialItem("_SC_WOND", i + 1);
                if (wond.getPlayer() != null || !wond.checkRequirements(this.ourPlayerData, false)) continue;
                int eta = ourBSE.calculateRollsFast(this.ourPlayerData.getResources(), wond.getCost(), 100, this.ourPlayerData.getPortFlags());
                if (isScoreNotETA) {
                    scoreOrETA = 100.0f / (float)this.game.maxPlayers;
                    scoreOrETA += this.getETABonus(eta, leadersCurrentWGETA, scoreOrETA);
                } else {
                    scoreOrETA = eta;
                }
                if (bestWond == null) {
                    isBetter = true;
                } else if (isScoreNotETA) {
                    isBetter = scoreOrETA > wScoreOrETA;
                } else {
                    boolean bl = isBetter = scoreOrETA < wScoreOrETA;
                }
                if (!isBetter) continue;
                bestWond = wond;
                wETA = eta;
                wScoreOrETA = scoreOrETA;
                gi = i + 1;
            }
            if (bestWond == null) {
                return false;
            }
            bestETA = wETA;
            bestWondScoreOrETA = wScoreOrETA;
        }
        if (isScoreNotETA ? bestScoreOrETA > bestWondScoreOrETA : bestScoreOrETA < bestWondScoreOrETA) {
            return false;
        }
        this.buildingPlan.add(new SOCPossiblePickSpecialItem(this.ourPlayerData, "_SC_WOND", gi, 0, bestETA, bestWond.getCost()));
        return true;
    }

    protected void scorePossibleSettlements(int settlementETA, int leadersCurrentWGETA) {
        D.ebugPrintlnINFO("****** scorePossibleSettlements");
        for (SOCPossibleSettlement posSet : this.ourPlayerTracker.getPossibleSettlements().values()) {
            D.ebugPrintlnINFO("*** scoring possible settlement at " + Integer.toHexString(posSet.getCoordinates()));
            if (!this.threatenedSettlements.contains(posSet)) {
                this.threatenedSettlements.add(posSet);
            } else if (!this.goodSettlements.contains(posSet)) {
                this.goodSettlements.add(posSet);
            }
            if (!posSet.getNecessaryRoads().isEmpty()) continue;
            D.ebugPrintlnINFO("*** no roads needed");
            SOCBoard board = this.game.getBoard();
            SOCSettlement tmpSet = new SOCSettlement(this.ourPlayerData, posSet.getCoordinates(), board);
            if (this.brain != null && this.brain.getDRecorder().isOn()) {
                this.brain.getDRecorder().startRecording("SETTLEMENT" + posSet.getCoordinates());
                this.brain.getDRecorder().record("Estimate value of settlement at " + board.nodeCoordToString(posSet.getCoordinates()));
            }
            SOCPlayerTracker[] trackersCopy = SOCPlayerTracker.tryPutPiece(tmpSet, this.game, this.playerTrackers);
            SOCPlayerTracker.updateWinGameETAs(trackersCopy);
            float wgetaScore = this.calcWGETABonus(this.playerTrackers, trackersCopy);
            D.ebugPrintlnINFO("***  wgetaScore = " + wgetaScore);
            D.ebugPrintlnINFO("*** ETA for settlement = " + settlementETA);
            if (this.brain != null && this.brain.getDRecorder().isOn()) {
                this.brain.getDRecorder().record("ETA = " + settlementETA);
            }
            float etaBonus = this.getETABonus(settlementETA, leadersCurrentWGETA, wgetaScore);
            D.ebugPrintlnINFO("etaBonus = " + etaBonus);
            posSet.addToScore(etaBonus);
            if (this.brain != null && this.brain.getDRecorder().isOn()) {
                this.brain.getDRecorder().record("WGETA score = " + df1.format(wgetaScore));
                this.brain.getDRecorder().record("Total settlement score = " + df1.format(etaBonus));
                this.brain.getDRecorder().stopRecording();
            }
            SOCPlayerTracker.undoTryPutPiece(tmpSet, this.game);
        }
    }

    protected float getWinGameETABonus(SOCPossiblePiece posPiece) {
        SOCPlayerTracker[] trackersCopy = null;
        SOCSettlement tmpSet = null;
        SOCCity tmpCity = null;
        SOCRoutePiece tmpRS = null;
        float bonus = 0.0f;
        D.ebugPrintlnINFO("--- before [start] ---");
        D.ebugPrintlnINFO("our player numbers = " + this.ourPlayerData.getNumbers());
        D.ebugPrintlnINFO("--- before [end] ---");
        switch (posPiece.getType()) {
            case 1: {
                tmpSet = new SOCSettlement(this.ourPlayerData, posPiece.getCoordinates(), null);
                trackersCopy = SOCPlayerTracker.tryPutPiece(tmpSet, this.game, this.playerTrackers);
                break;
            }
            case 2: {
                trackersCopy = SOCPlayerTracker.copyPlayerTrackers(this.playerTrackers);
                tmpCity = new SOCCity(this.ourPlayerData, posPiece.getCoordinates(), null);
                this.game.putTempPiece(tmpCity);
                SOCPlayerTracker trackerCopy = trackersCopy[this.ourPlayerNumber];
                if (trackerCopy == null) break;
                trackerCopy.addOurNewCity(tmpCity);
                break;
            }
            case 0: {
                tmpRS = new SOCRoad(this.ourPlayerData, posPiece.getCoordinates(), null);
                trackersCopy = SOCPlayerTracker.tryPutPiece(tmpRS, this.game, this.playerTrackers);
                break;
            }
            case 3: {
                tmpRS = new SOCShip(this.ourPlayerData, posPiece.getCoordinates(), null);
                trackersCopy = SOCPlayerTracker.tryPutPiece(tmpRS, this.game, this.playerTrackers);
            }
        }
        D.ebugPrintlnINFO("--- after [start] ---");
        SOCPlayerTracker.updateWinGameETAs(trackersCopy);
        float WGETABonus = this.calcWGETABonus(this.playerTrackers, trackersCopy);
        D.ebugPrintlnINFO("$$$ win game ETA bonus : +" + WGETABonus);
        bonus = WGETABonus;
        D.ebugPrintlnINFO("our player numbers = " + this.ourPlayerData.getNumbers());
        D.ebugPrintlnINFO("--- after [end] ---");
        switch (posPiece.getType()) {
            case 1: {
                SOCPlayerTracker.undoTryPutPiece(tmpSet, this.game);
                break;
            }
            case 2: {
                this.game.undoPutTempPiece(tmpCity);
                break;
            }
            case 0: 
            case 3: {
                SOCPlayerTracker.undoTryPutPiece(tmpRS, this.game);
            }
        }
        D.ebugPrintlnINFO("our player numbers = " + this.ourPlayerData.getNumbers());
        D.ebugPrintlnINFO("--- cleanup done ---");
        return bonus;
    }

    protected float getWinGameETABonusForRoad(SOCPossibleRoad posRoad, int roadETA, int leadersCurrentWGETA, SOCPlayerTracker[] plTrackers) {
        D.ebugPrintlnINFO("--- addWinGameETABonusForRoad");
        int ourCurrentWGETA = this.ourPlayerTracker.getWinGameETA();
        D.ebugPrintlnINFO("ourCurrentWGETA = " + ourCurrentWGETA);
        SOCPlayerTracker[] trackersCopy = null;
        SOCRoutePiece tmpRS = null;
        boolean isShip = posRoad instanceof SOCPossibleShip && !((SOCPossibleShip)posRoad).isCoastalRoadAndShip;
        SOCResourceSet rsrcs = isShip ? SOCShip.COST : SOCRoad.COST;
        D.ebugPrintlnINFO("--- before [start] ---");
        SOCResourceSet originalResources = this.ourPlayerData.getResources().copy();
        SOCBuildingSpeedEstimate estimate = this.getEstimator(this.ourPlayerData.getNumbers());
        D.ebugPrintlnINFO("--- before [end] ---");
        try {
            SOCResSetBuildTimePair btp = estimate.calculateRollsAndRsrcFast(this.ourPlayerData.getResources(), rsrcs, 50, this.ourPlayerData.getPortFlags());
            btp.getResources().subtract(rsrcs);
            this.ourPlayerData.getResources().setAmounts(btp.getResources());
        }
        catch (CutoffExceededException e) {
            D.ebugPrintlnINFO("crap in getWinGameETABonusForRoad - " + e);
        }
        tmpRS = isShip ? new SOCShip(this.ourPlayerData, posRoad.getCoordinates(), null) : new SOCRoad(this.ourPlayerData, posRoad.getCoordinates(), null);
        trackersCopy = SOCPlayerTracker.tryPutPiece(tmpRS, this.game, plTrackers);
        SOCPlayerTracker.updateWinGameETAs(trackersCopy);
        float score = this.calcWGETABonus(plTrackers, trackersCopy);
        if (!posRoad.getThreats().isEmpty()) {
            D.ebugPrintlnINFO("***  (THREAT MULTIPLIER) score * " + this.threatMultiplier + " = " + (score *= this.threatMultiplier));
        }
        D.ebugPrintlnINFO("*** ETA for road = " + roadETA);
        float etaBonus = this.getETABonus(roadETA, leadersCurrentWGETA, score);
        D.ebugPrintlnINFO("$$$ score = " + score);
        D.ebugPrintlnINFO("etaBonus = " + etaBonus);
        posRoad.addToScore(etaBonus);
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().record("ETA = " + roadETA);
            this.brain.getDRecorder().record("WGETA Score = " + df1.format(score));
            this.brain.getDRecorder().record("Total road score = " + df1.format(etaBonus));
        }
        D.ebugPrintlnINFO("--- after [end] ---");
        SOCPlayerTracker.undoTryPutPiece(tmpRS, this.game);
        this.ourPlayerData.getResources().clear();
        this.ourPlayerData.getResources().add(originalResources);
        D.ebugPrintlnINFO("--- cleanup done ---");
        return etaBonus;
    }

    protected float calcWGETABonus(SOCPlayerTracker[] trackersBefore, SOCPlayerTracker[] trackersAfter) {
        D.ebugPrintlnINFO("^^^^^ calcWGETABonus");
        int[] originalWGETAs = new int[this.game.maxPlayers];
        int[] WGETAdiffs = new int[this.game.maxPlayers];
        Vector<SOCPlayerTracker> leaders = new Vector<SOCPlayerTracker>();
        int bestWGETA = 1000;
        float bonus = 0.0f;
        for (SOCPlayerTracker trackerBefore : trackersBefore) {
            if (trackerBefore == null) continue;
            int pn = trackerBefore.getPlayer().getPlayerNumber();
            D.ebugPrintlnINFO("$$$ win game ETA for player " + pn + " = " + trackerBefore.getWinGameETA());
            originalWGETAs[pn] = trackerBefore.getWinGameETA();
            WGETAdiffs[pn] = trackerBefore.getWinGameETA();
            if (trackerBefore.getWinGameETA() < bestWGETA) {
                bestWGETA = trackerBefore.getWinGameETA();
                leaders.removeAllElements();
                leaders.addElement(trackerBefore);
                continue;
            }
            if (trackerBefore.getWinGameETA() != bestWGETA) continue;
            leaders.addElement(trackerBefore);
        }
        D.ebugPrintlnINFO("^^^^ bestWGETA = " + bestWGETA);
        bonus = this.calcWGETABonusAux(originalWGETAs, trackersAfter, leaders);
        D.ebugPrintlnINFO("^^^^ final bonus = " + bonus);
        return bonus;
    }

    protected float calcWGETABonusAux(int[] originalWGETAs, SOCPlayerTracker[] trackersAfter, Vector<SOCPlayerTracker> leaders) {
        int leaderPN;
        int[] WGETAdiffs = new int[this.game.maxPlayers];
        int bestWGETA = 1000;
        float bonus = 0.0f;
        for (int i = 0; i < this.game.maxPlayers; ++i) {
            WGETAdiffs[i] = originalWGETAs[i];
            if (originalWGETAs[i] >= bestWGETA) continue;
            bestWGETA = originalWGETAs[i];
        }
        for (SOCPlayerTracker trackerAfter : trackersAfter) {
            int pn;
            if (trackerAfter == null) continue;
            int n = pn = trackerAfter.getPlayer().getPlayerNumber();
            WGETAdiffs[n] = WGETAdiffs[n] - trackerAfter.getWinGameETA();
            D.ebugPrintlnINFO("$$$ win game ETA diff for player " + pn + " = " + WGETAdiffs[pn]);
            if (pn != this.ourPlayerNumber || trackerAfter.getWinGameETA() != 0) continue;
            D.ebugPrintlnINFO("$$$$ adding win game bonus : +" + 100 / this.game.maxPlayers);
            bonus += 100.0f / (float)this.game.maxPlayers;
            if (this.brain == null || !this.brain.getDRecorder().isOn()) continue;
            this.brain.getDRecorder().record("Adding Win Game bonus :" + df1.format(bonus));
        }
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().record("WGETA Diffs: " + WGETAdiffs[0] + " " + WGETAdiffs[1] + " " + WGETAdiffs[2] + " " + WGETAdiffs[3]);
        }
        if (originalWGETAs[this.ourPlayerNumber] > 0 && bonus == 0.0f) {
            bonus += 100.0f / (float)this.game.maxPlayers * ((float)WGETAdiffs[this.ourPlayerNumber] / (float)originalWGETAs[this.ourPlayerNumber]);
        }
        D.ebugPrintlnINFO("^^^^ our current bonus = " + bonus);
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().record("WGETA bonus for only myself = " + df1.format(bonus));
        }
        for (int pn = 0; pn < this.game.maxPlayers; ++pn) {
            Enumeration<SOCPlayerTracker> leadersEnum = leaders.elements();
            while (leadersEnum.hasMoreElements()) {
                float takedownBonus;
                leaderPN = leadersEnum.nextElement().getPlayer().getPlayerNumber();
                if (pn == this.ourPlayerNumber || pn == leaderPN) continue;
                if (originalWGETAs[pn] > 0) {
                    takedownBonus = -1.0f * (100.0f / (float)this.game.maxPlayers) * this.adversarialFactor * ((float)WGETAdiffs[pn] / (float)originalWGETAs[pn]) * ((float)bestWGETA / (float)originalWGETAs[pn]);
                    bonus += takedownBonus;
                    D.ebugPrintlnINFO("^^^^ added takedown bonus for player " + pn + " : " + takedownBonus);
                    if (this.brain == null || !this.brain.getDRecorder().isOn() || takedownBonus == 0.0f) continue;
                    this.brain.getDRecorder().record("Bonus for AI with " + pn + " : " + df1.format(takedownBonus));
                    continue;
                }
                if (WGETAdiffs[pn] >= 0) continue;
                takedownBonus = 100.0f / (float)this.game.maxPlayers * this.adversarialFactor;
                bonus += takedownBonus;
                D.ebugPrintlnINFO("^^^^ added takedown bonus for player " + pn + " : " + takedownBonus);
                if (this.brain == null || !this.brain.getDRecorder().isOn() || takedownBonus == 0.0f) continue;
                this.brain.getDRecorder().record("Bonus for AI with " + pn + " : " + df1.format(takedownBonus));
            }
        }
        Enumeration<SOCPlayerTracker> leadersEnum = leaders.elements();
        while (leadersEnum.hasMoreElements()) {
            float takedownBonus;
            SOCPlayer leader = leadersEnum.nextElement().getPlayer();
            leaderPN = leader.getPlayerNumber();
            if (leaderPN == this.ourPlayerNumber) continue;
            if (originalWGETAs[leaderPN] > 0) {
                takedownBonus = -1.0f * (100.0f / (float)this.game.maxPlayers) * this.leaderAdversarialFactor * ((float)WGETAdiffs[leaderPN] / (float)originalWGETAs[leaderPN]);
                bonus += takedownBonus;
                D.ebugPrintlnINFO("^^^^ added takedown bonus for leader " + leaderPN + " : +" + takedownBonus);
                if (this.brain == null || !this.brain.getDRecorder().isOn() || takedownBonus == 0.0f) continue;
                this.brain.getDRecorder().record("Bonus for LI with " + leader.getName() + " : +" + df1.format(takedownBonus));
                continue;
            }
            if (WGETAdiffs[leaderPN] >= 0) continue;
            takedownBonus = 100.0f / (float)this.game.maxPlayers * this.leaderAdversarialFactor;
            bonus += takedownBonus;
            D.ebugPrintlnINFO("^^^^ added takedown bonus for leader " + leaderPN + " : +" + takedownBonus);
            if (this.brain == null || !this.brain.getDRecorder().isOn() || takedownBonus == 0.0f) continue;
            this.brain.getDRecorder().record("Bonus for LI with " + leader.getName() + " : +" + df1.format(takedownBonus));
        }
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().record("WGETA bonus = " + df1.format(bonus));
        }
        return bonus;
    }

    public SOCPossibleCard getDevCardScore(int cardETA, int leadersCurrentWGETA) {
        float devCardScore = 0.0f;
        D.ebugPrintlnINFO("$$$ devCardScore = +" + devCardScore);
        D.ebugPrintlnINFO("--- before [start] ---");
        int[] WGETAdiffs = new int[this.game.maxPlayers];
        int[] originalWGETAs = new int[this.game.maxPlayers];
        int bestWGETA = 1000;
        Vector<SOCPlayerTracker> leaders = new Vector<SOCPlayerTracker>();
        for (SOCPlayerTracker tracker : this.playerTrackers) {
            if (tracker == null) continue;
            int pn = tracker.getPlayer().getPlayerNumber();
            originalWGETAs[pn] = tracker.getWinGameETA();
            WGETAdiffs[pn] = tracker.getWinGameETA();
            D.ebugPrintlnINFO("$$$$ win game ETA for player " + pn + " = " + tracker.getWinGameETA());
            if (tracker.getWinGameETA() < bestWGETA) {
                bestWGETA = tracker.getWinGameETA();
                leaders.removeAllElements();
                leaders.addElement(tracker);
                continue;
            }
            if (tracker.getWinGameETA() != bestWGETA) continue;
            leaders.addElement(tracker);
        }
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().record("Estimating Knight card value ...");
        }
        this.ourPlayerData.getGame().saveLargestArmyState();
        D.ebugPrintlnINFO("--- before [end] ---");
        this.ourPlayerData.setNumKnights(this.ourPlayerData.getNumKnights() + 1);
        this.ourPlayerData.getGame().updateLargestArmy();
        D.ebugPrintlnINFO("--- after [start] ---");
        SOCPlayerTracker.updateWinGameETAs(this.playerTrackers);
        float bonus = this.calcWGETABonusAux(originalWGETAs, this.playerTrackers, leaders);
        D.ebugPrintlnINFO("^^^^ raw bonus = " + bonus);
        D.ebugPrintlnINFO("^^^^ adjusted bonus = " + (bonus *= 0.58f));
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().record("Bonus * 0.58 = " + df1.format(bonus));
        }
        D.ebugPrintlnINFO("^^^^ bonus for +1 knight = " + bonus);
        devCardScore += bonus;
        D.ebugPrintlnINFO("--- after [end] ---");
        this.ourPlayerData.setNumKnights(this.ourPlayerData.getNumKnights() - 1);
        this.ourPlayerData.getGame().restoreLargestArmyState();
        D.ebugPrintlnINFO("--- cleanup done ---");
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().record("Estimating vp card value ...");
        }
        D.ebugPrintlnINFO("--- before [start] ---");
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().suspend();
        }
        SOCPlayerTracker.updateWinGameETAs(this.playerTrackers);
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().resume();
        }
        D.ebugPrintlnINFO("--- before [end] ---");
        this.ourPlayerData.getInventory().addDevCard(1, 1, 4);
        D.ebugPrintlnINFO("--- after [start] ---");
        SOCPlayerTracker.updateWinGameETAs(this.playerTrackers);
        bonus = this.calcWGETABonusAux(originalWGETAs, this.playerTrackers, leaders);
        D.ebugPrintlnINFO("^^^^ our current bonus = " + bonus);
        D.ebugPrintlnINFO("^^^^ adjusted bonus = " + (bonus *= 0.21f));
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().record("Bonus * 0.21 = " + df1.format(bonus));
        }
        D.ebugPrintlnINFO("$$$ win game ETA bonus for +1 vp: " + bonus);
        devCardScore += bonus;
        D.ebugPrintlnINFO("--- after [end] ---");
        this.ourPlayerData.getInventory().removeDevCard(1, 4);
        D.ebugPrintlnINFO("--- cleanup done ---");
        devCardScore += this.devCardMultiplier;
        D.ebugPrintlnINFO("^^^^ misc bonus = " + this.devCardMultiplier);
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().record("Misc bonus = " + df1.format(this.devCardMultiplier));
        }
        float score = this.getETABonus(cardETA, leadersCurrentWGETA, devCardScore);
        D.ebugPrintlnINFO("$$$$$ devCardScore = " + devCardScore);
        D.ebugPrintlnINFO("$$$$$ devCardETA = " + cardETA);
        D.ebugPrintlnINFO("$$$$$ final score = " + score);
        if (this.brain != null && this.brain.getDRecorder().isOn()) {
            this.brain.getDRecorder().record("ETA = " + cardETA);
            this.brain.getDRecorder().record("dev card score = " + df1.format(devCardScore));
            this.brain.getDRecorder().record("Total dev card score = " + df1.format(score));
        }
        SOCPossibleCard posCard = new SOCPossibleCard(this.ourPlayerData, cardETA);
        posCard.addToScore(score);
        return posCard;
    }

    float getETABonus(int eta, int leadWGETA, float bonus) {
        D.ebugPrintlnINFO("**** getETABonus ****");
        return bonus / (float)Math.pow(1.0f + this.etaBonusFactor, eta);
    }

    public boolean shouldPlayKnightForLA() {
        boolean canGrowArmy;
        SOCPlayer laPlayer = this.game.getPlayerWithLargestArmy();
        if (laPlayer == null || laPlayer.getPlayerNumber() != this.ourPlayerNumber) {
            int larmySize = laPlayer == null ? 3 : laPlayer.getNumKnights() + 1;
            canGrowArmy = this.ourPlayerData.getNumKnights() + this.ourPlayerData.getInventory().getAmount(9) >= larmySize;
        } else {
            canGrowArmy = false;
        }
        return canGrowArmy;
    }

    public SOCResourceSet getResourceChoices() {
        return this.resourceChoices;
    }

    protected SOCResourceSet pickFreeResources(int numChoose) {
        if (!this.buildingPlan.isEmpty()) {
            SOCPossiblePiece targetPiece = (SOCPossiblePiece)this.buildingPlan.peek();
            SOCResourceSet targetResources = targetPiece.getResourcesToBuild();
            this.chooseFreeResourcesIfNeeded(targetResources, numChoose, true);
        } else {
            this.resourceChoices.clear();
            int[] resourceEstimates = this.openingBuildStrategy.estimateResourceRarity();
            int numEach = 0;
            while (numChoose > 0) {
                int res = -1;
                int pct = Integer.MAX_VALUE;
                for (int i = 1; i <= 5; ++i) {
                    if (resourceEstimates[i] >= pct || this.resourceChoices.getAmount(i) >= numEach) continue;
                    res = i;
                    pct = resourceEstimates[i];
                }
                if (res != -1) {
                    this.resourceChoices.add(1, res);
                    --numChoose;
                    continue;
                }
                ++numEach;
            }
        }
        return this.resourceChoices;
    }

    protected boolean chooseFreeResources(SOCResourceSet targetResources, int numChoose, boolean clearResChoices) {
        if (clearResChoices) {
            this.resourceChoices.clear();
        }
        SOCResourceSet rsCopy = this.ourPlayerData.getResources().copy();
        SOCBuildingSpeedEstimate estimate = this.getEstimator(this.ourPlayerData.getNumbers());
        int[] rollsPerResource = estimate.getRollsPerResource();
        for (int resourceCount = 0; resourceCount < numChoose; ++resourceCount) {
            int mostNeededResource = -1;
            for (int resource = 1; resource <= 5; ++resource) {
                if (rsCopy.getAmount(resource) >= targetResources.getAmount(resource)) continue;
                if (mostNeededResource < 0) {
                    mostNeededResource = resource;
                    continue;
                }
                if (rollsPerResource[resource] <= rollsPerResource[mostNeededResource]) continue;
                mostNeededResource = resource;
            }
            if (mostNeededResource == -1) {
                return false;
            }
            this.resourceChoices.add(1, mostNeededResource);
            rsCopy.add(1, mostNeededResource);
        }
        return true;
    }

    protected boolean chooseFreeResourcesIfNeeded(SOCResourceSet targetResources, int numChoose, boolean chooseIfNotNeeded) {
        if (targetResources == null) {
            return false;
        }
        if (chooseIfNotNeeded) {
            this.resourceChoices.clear();
        }
        SOCResourceSet ourResources = this.ourPlayerData.getResources();
        int numMore = numChoose;
        int buildingItem = 0;
        boolean stackTopIs0 = false;
        do {
            int numNeededResources = 0;
            if (targetResources == null) break;
            for (int resource = 1; resource <= 5; ++resource) {
                int diff = targetResources.getAmount(resource) - ourResources.getAmount(resource);
                if (diff <= 0) continue;
                numNeededResources += diff;
            }
            if (numNeededResources == numMore || chooseIfNotNeeded && numNeededResources > numMore) {
                this.chooseFreeResources(targetResources, numMore, !chooseIfNotNeeded);
                return true;
            }
            if (!chooseIfNotNeeded) {
                return false;
            }
            this.chooseFreeResources(targetResources, numMore, false);
            if (numMore <= 0) continue;
            int bpSize = this.buildingPlan.size();
            if (bpSize > ++buildingItem) {
                if (buildingItem == 1) {
                    stackTopIs0 = 0 == this.buildingPlan.indexOf(this.buildingPlan.getFirstPiece());
                }
                int i = stackTopIs0 ? buildingItem : bpSize - buildingItem - 1;
                SOCPossiblePiece targetPiece = (SOCPossiblePiece)this.buildingPlan.elementAt(i);
                targetResources = targetPiece.getResourcesToBuild();
                continue;
            }
            int[] resourceOrder = this.bseFactory.getRollsForResourcesSorted(this.ourPlayerData);
            int curRsrc = 0;
            for (numMore = numChoose - this.resourceChoices.getTotal(); numMore > 0; --numMore) {
                this.resourceChoices.add(1, resourceOrder[curRsrc]);
                if (++curRsrc != resourceOrder.length) continue;
                curRsrc = 0;
            }
        } while (numMore > 0);
        return true;
    }

    protected SOCBuildingSpeedEstimate getEstimator(SOCPlayerNumbers numbers) {
        if (this.brain != null) {
            return this.brain.getEstimator(numbers);
        }
        return this.bseFactory.getEstimator(numbers);
    }

    protected SOCBuildingSpeedEstimate getEstimator() {
        if (this.brain != null) {
            return this.brain.getEstimator();
        }
        return this.bseFactory.getEstimator();
    }

    public SOCBuildingSpeedEstimateFactory getEstimatorFactory() {
        return this.bseFactory;
    }
}

