/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import java.util.Iterator;
import java.util.Vector;
import soc.disableDebug.D;
import soc.game.SOCGame;
import soc.game.SOCPlayer;
import soc.game.SOCResourceSet;
import soc.game.SOCTradeOffer;
import soc.robot.SOCBuildPlan;
import soc.robot.SOCBuildPlanStack;
import soc.robot.SOCBuildingSpeedEstimate;
import soc.robot.SOCPlayerTracker;
import soc.robot.SOCPossiblePiece;
import soc.robot.SOCPossibleSettlement;
import soc.robot.SOCRobotBrain;
import soc.robot.SOCRobotDM;

public class SOCRobotNegotiator {
    protected static final int WIN_GAME_CUTOFF = 25;
    public static final int IGNORE_OFFER = -1;
    public static final int REJECT_OFFER = 0;
    public static final int ACCEPT_OFFER = 1;
    public static final int COUNTER_OFFER = 2;
    protected SOCRobotBrain brain;
    protected int strategyType;
    protected SOCGame game;
    protected SOCBuildPlanStack buildingPlan;
    protected SOCPlayerTracker[] playerTrackers;
    protected SOCPlayerTracker ourPlayerTracker;
    protected final SOCPlayer ourPlayerData;
    protected final int ourPlayerNumber;
    protected SOCRobotDM decisionMaker;
    protected boolean[][] isSellingResource;
    protected boolean[][] wantsAnotherOffer;
    protected Vector<SOCTradeOffer> offersMade;
    protected SOCPossiblePiece[] targetPieces;

    public SOCRobotNegotiator(SOCRobotBrain br) {
        this.brain = br;
        this.strategyType = br.getRobotParameters().getStrategyType();
        this.playerTrackers = this.brain.getPlayerTrackers();
        this.ourPlayerTracker = this.brain.getOurPlayerTracker();
        this.ourPlayerData = this.brain.getOurPlayerData();
        this.ourPlayerNumber = this.ourPlayerData.getPlayerNumber();
        this.buildingPlan = this.brain.getBuildingPlan();
        this.decisionMaker = this.brain.getDecisionMaker();
        this.game = this.brain.getGame();
        this.isSellingResource = new boolean[this.game.maxPlayers][7];
        this.resetIsSelling();
        this.wantsAnotherOffer = new boolean[this.game.maxPlayers][7];
        this.resetWantsAnotherOffer();
        this.offersMade = new Vector();
        this.targetPieces = new SOCPossiblePiece[this.game.maxPlayers];
        this.resetTargetPieces();
    }

    public void resetTargetPieces() {
        D.ebugPrintlnINFO("*** resetTargetPieces ***");
        for (int pn = 0; pn < this.game.maxPlayers; ++pn) {
            this.targetPieces[pn] = null;
        }
    }

    public void setTargetPiece(int pn, SOCBuildPlan buildPlan) {
        this.setTargetPiece(pn, buildPlan != null && !buildPlan.isEmpty() ? buildPlan.getFirstPiece() : null);
    }

    public void setTargetPiece(int pn, SOCPossiblePiece piece) {
        this.targetPieces[pn] = piece;
    }

    public void resetOffersMade() {
        this.offersMade.clear();
    }

    public void addToOffersMade(SOCTradeOffer offer) {
        if (offer != null) {
            this.offersMade.add(offer);
        }
    }

    public void resetIsSelling() {
        D.ebugPrintlnINFO("*** resetIsSelling (true for every resource the player has) ***");
        for (int rsrcType = 1; rsrcType <= 5; ++rsrcType) {
            for (int pn = 0; pn < this.game.maxPlayers; ++pn) {
                if (this.game.isSeatVacant(pn) || !this.game.getPlayer(pn).getResources().contains(rsrcType)) continue;
                this.isSellingResource[pn][rsrcType] = true;
            }
        }
    }

    public void resetWantsAnotherOffer() {
        D.ebugPrintlnINFO("*** resetWantsAnotherOffer (all false) ***");
        for (int rsrcType = 1; rsrcType <= 5; ++rsrcType) {
            for (int pn = 0; pn < this.game.maxPlayers; ++pn) {
                this.wantsAnotherOffer[pn][rsrcType] = false;
            }
        }
    }

    public void markAsNotSelling(int pn, int rsrcType) {
        D.ebugPrintlnINFO("*** markAsNotSelling pn=" + pn + " rsrcType=" + rsrcType);
        this.isSellingResource[pn][rsrcType] = false;
    }

    public void markAsSelling(int pn, int rsrcType) {
        D.ebugPrintlnINFO("*** markAsSelling pn=" + pn + " rsrcType=" + rsrcType);
        this.isSellingResource[pn][rsrcType] = true;
    }

    public void markAsNotWantingAnotherOffer(int pn, int rsrcType) {
        D.ebugPrintlnINFO("*** markAsNotWantingAnotherOffer pn=" + pn + " rsrcType=" + rsrcType);
        this.wantsAnotherOffer[pn][rsrcType] = false;
    }

    public void markAsWantsAnotherOffer(int pn, int rsrcType) {
        D.ebugPrintlnINFO("*** markAsWantsAnotherOffer pn=" + pn + " rsrcType=" + rsrcType);
        this.wantsAnotherOffer[pn][rsrcType] = true;
    }

    public boolean wantsAnotherOffer(int pn, int rsrcType) {
        return this.wantsAnotherOffer[pn][rsrcType];
    }

    public SOCTradeOffer makeOffer(SOCBuildPlan buildPlan) {
        int giveRsrcIdx1;
        int getRsrcIdx;
        int tmp;
        int i;
        int j;
        D.ebugPrintlnINFO("***** MAKE OFFER *****");
        if (buildPlan == null || buildPlan.isEmpty()) {
            return null;
        }
        SOCTradeOffer offer = null;
        SOCResourceSet targetResources = buildPlan.getFirstPieceResources();
        if (targetResources.isEmpty()) {
            return null;
        }
        SOCResourceSet ourResources = this.ourPlayerData.getResources();
        D.ebugPrintlnINFO("*** targetResources = " + targetResources);
        D.ebugPrintlnINFO("*** ourResources = " + ourResources);
        if (ourResources.contains(targetResources)) {
            return offer;
        }
        if (ourResources.contains(6)) {
            D.ebugPrintlnINFO("AGG WE HAVE UNKNOWN RESOURCES !!!! %%%%%%%%%%%%%%%%%%%%%%%%%%%%");
            return offer;
        }
        SOCTradeOffer batna = this.getOfferToBank(targetResources);
        D.ebugPrintlnINFO("*** BATNA = " + batna);
        SOCBuildingSpeedEstimate estimate = this.brain.getEstimator(this.ourPlayerData.getNumbers());
        SOCResourceSet giveResourceSet = new SOCResourceSet();
        SOCResourceSet getResourceSet = new SOCResourceSet();
        int batnaBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate);
        D.ebugPrintlnINFO("*** batnaBuildingTime = " + batnaBuildingTime);
        if (batna != null) {
            batnaBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, batna.getGiveSet(), batna.getGetSet(), estimate);
        }
        D.ebugPrintlnINFO("*** batnaBuildingTime = " + batnaBuildingTime);
        int[] rollsPerResource = estimate.getRollsPerResource();
        int[] neededRsrc = new int[5];
        int[] notNeededRsrc = new int[5];
        int neededRsrcCount = 0;
        int notNeededRsrcCount = 0;
        for (int rsrcType = 1; rsrcType <= 5; ++rsrcType) {
            if (targetResources.contains(rsrcType)) {
                neededRsrc[neededRsrcCount] = rsrcType;
                ++neededRsrcCount;
                continue;
            }
            notNeededRsrc[notNeededRsrcCount] = rsrcType;
            ++notNeededRsrcCount;
        }
        for (j = neededRsrcCount - 1; j >= 0; --j) {
            for (i = 0; i < j; ++i) {
                if (rollsPerResource[neededRsrc[i]] <= rollsPerResource[neededRsrc[i + 1]]) continue;
                tmp = neededRsrc[i];
                neededRsrc[i] = neededRsrc[i + 1];
                neededRsrc[i + 1] = tmp;
            }
        }
        for (j = notNeededRsrcCount - 1; j >= 0; --j) {
            for (i = 0; i < j; ++i) {
                if (rollsPerResource[notNeededRsrc[i]] <= rollsPerResource[notNeededRsrc[i + 1]]) continue;
                tmp = notNeededRsrc[i];
                notNeededRsrc[i] = notNeededRsrc[i + 1];
                notNeededRsrc[i + 1] = tmp;
            }
        }
        boolean[] someoneIsSellingResource = new boolean[7];
        block5: for (int rsrcType = 1; rsrcType <= 5; ++rsrcType) {
            someoneIsSellingResource[rsrcType] = false;
            for (int pn = 0; pn < this.game.maxPlayers; ++pn) {
                if (pn == this.ourPlayerNumber || !this.isSellingResource[pn][rsrcType]) continue;
                someoneIsSellingResource[rsrcType] = true;
                D.ebugPrintlnINFO("*** player " + pn + " is selling " + rsrcType);
                continue block5;
            }
        }
        for (getRsrcIdx = neededRsrcCount - 1; !(getRsrcIdx < 0 || ourResources.getAmount(neededRsrc[getRsrcIdx]) < targetResources.getAmount(neededRsrc[getRsrcIdx]) && someoneIsSellingResource[neededRsrc[getRsrcIdx]]); --getRsrcIdx) {
        }
        if (getRsrcIdx >= 0) {
            D.ebugPrintlnINFO("*** getRsrc = " + neededRsrc[getRsrcIdx]);
            getResourceSet.add(1, neededRsrc[getRsrcIdx]);
            D.ebugPrintlnINFO("*** offer should be null : offer = " + offer);
            for (int giveRsrcIdx = 0; giveRsrcIdx < notNeededRsrcCount && offer == null; ++giveRsrcIdx) {
                D.ebugPrintlnINFO("*** ourResources.getAmount(" + notNeededRsrc[giveRsrcIdx] + ") = " + ourResources.getAmount(notNeededRsrc[giveRsrcIdx]));
                if (!ourResources.contains(notNeededRsrc[giveRsrcIdx])) continue;
                giveResourceSet.clear();
                giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx]);
                offer = this.makeOfferAux(giveResourceSet, getResourceSet, neededRsrc[getRsrcIdx]);
                D.ebugPrintlnINFO("*** offer = " + offer);
                int offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate);
                D.ebugPrintlnINFO("*** offerBuildingTime = " + offerBuildingTime);
            }
            D.ebugPrintlnINFO("*** ourResources = " + ourResources);
            if (offer == null) {
                for (int giveRsrcIdx12 = 0; giveRsrcIdx12 < neededRsrcCount && offer == null; ++giveRsrcIdx12) {
                    D.ebugPrintlnINFO("*** ourResources.getAmount(" + neededRsrc[giveRsrcIdx12] + ") = " + ourResources.getAmount(neededRsrc[giveRsrcIdx12]));
                    D.ebugPrintlnINFO("*** targetResources.getAmount(" + neededRsrc[giveRsrcIdx12] + ") = " + targetResources.getAmount(neededRsrc[giveRsrcIdx12]));
                    if (ourResources.getAmount(neededRsrc[giveRsrcIdx12]) <= targetResources.getAmount(neededRsrc[giveRsrcIdx12]) || neededRsrc[giveRsrcIdx12] == neededRsrc[getRsrcIdx]) continue;
                    giveResourceSet.clear();
                    giveResourceSet.add(1, neededRsrc[giveRsrcIdx12]);
                    int offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate);
                    if (offerBuildingTime >= batnaBuildingTime && (batna == null || offerBuildingTime != batnaBuildingTime || giveResourceSet.getTotal() >= batna.getGiveSet().getTotal())) continue;
                    offer = this.makeOfferAux(giveResourceSet, getResourceSet, neededRsrc[getRsrcIdx]);
                    D.ebugPrintlnINFO("*** offer = " + offer);
                    D.ebugPrintlnINFO("*** offerBuildingTime = " + offerBuildingTime);
                }
            }
            D.ebugPrintlnINFO("*** ourResources = " + ourResources);
            SOCResourceSet leftovers = ourResources.copy();
            leftovers.subtract(targetResources);
            D.ebugPrintlnINFO("*** leftovers = " + leftovers);
            if (offer == null) {
                int offerBuildingTime;
                int giveRsrcIdx2 = 0;
                for (giveRsrcIdx1 = 0; giveRsrcIdx1 < notNeededRsrcCount && offer == null; ++giveRsrcIdx1) {
                    if (!ourResources.contains(notNeededRsrc[giveRsrcIdx1])) continue;
                    while (giveRsrcIdx2 < notNeededRsrcCount && offer == null) {
                        giveResourceSet.clear();
                        giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx1]);
                        giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx2]);
                        if (ourResources.contains(giveResourceSet) && ((offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate)) < batnaBuildingTime || batna != null && offerBuildingTime == batnaBuildingTime && giveResourceSet.getTotal() < batna.getGiveSet().getTotal())) {
                            offer = this.makeOfferAux(giveResourceSet, getResourceSet, neededRsrc[getRsrcIdx]);
                            D.ebugPrintlnINFO("*** offer = " + offer);
                            D.ebugPrintlnINFO("*** offerBuildingTime = " + offerBuildingTime);
                        }
                        ++giveRsrcIdx2;
                    }
                    for (giveRsrcIdx2 = 0; giveRsrcIdx2 < neededRsrcCount && offer == null; ++giveRsrcIdx2) {
                        if (neededRsrc[giveRsrcIdx2] == neededRsrc[getRsrcIdx]) continue;
                        giveResourceSet.clear();
                        giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx1]);
                        giveResourceSet.add(1, neededRsrc[giveRsrcIdx2]);
                        if (!leftovers.contains(giveResourceSet) || (offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate)) >= batnaBuildingTime && (batna == null || offerBuildingTime != batnaBuildingTime || giveResourceSet.getTotal() >= batna.getGiveSet().getTotal())) continue;
                        offer = this.makeOfferAux(giveResourceSet, getResourceSet, neededRsrc[getRsrcIdx]);
                        D.ebugPrintlnINFO("*** offer = " + offer);
                        D.ebugPrintlnINFO("*** offerBuildingTime = " + offerBuildingTime);
                    }
                }
                giveRsrcIdx2 = 0;
                for (giveRsrcIdx1 = 0; giveRsrcIdx1 < neededRsrcCount && offer == null; ++giveRsrcIdx1) {
                    if (!leftovers.contains(neededRsrc[giveRsrcIdx1]) || neededRsrc[giveRsrcIdx1] == neededRsrc[getRsrcIdx]) continue;
                    while (giveRsrcIdx2 < notNeededRsrcCount && offer == null) {
                        giveResourceSet.clear();
                        giveResourceSet.add(1, neededRsrc[giveRsrcIdx1]);
                        giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx2]);
                        if (leftovers.contains(giveResourceSet) && ((offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate)) < batnaBuildingTime || batna != null && offerBuildingTime == batnaBuildingTime && giveResourceSet.getTotal() < batna.getGiveSet().getTotal())) {
                            offer = this.makeOfferAux(giveResourceSet, getResourceSet, neededRsrc[getRsrcIdx]);
                            D.ebugPrintlnINFO("*** offer = " + offer);
                            D.ebugPrintlnINFO("*** offerBuildingTime = " + offerBuildingTime);
                        }
                        ++giveRsrcIdx2;
                    }
                    for (giveRsrcIdx2 = 0; giveRsrcIdx2 < neededRsrcCount && offer == null; ++giveRsrcIdx2) {
                        if (neededRsrc[giveRsrcIdx2] == neededRsrc[getRsrcIdx]) continue;
                        giveResourceSet.clear();
                        giveResourceSet.add(1, neededRsrc[giveRsrcIdx1]);
                        giveResourceSet.add(1, neededRsrc[giveRsrcIdx2]);
                        if (!leftovers.contains(giveResourceSet) || (offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate)) >= batnaBuildingTime && (batna == null || offerBuildingTime != batnaBuildingTime || giveResourceSet.getTotal() >= batna.getGiveSet().getTotal())) continue;
                        offer = this.makeOfferAux(giveResourceSet, getResourceSet, neededRsrc[getRsrcIdx]);
                        D.ebugPrintlnINFO("*** offer = " + offer);
                        D.ebugPrintlnINFO("*** offerBuildingTime = " + offerBuildingTime);
                    }
                }
            }
        }
        if (offer == null) {
            int getRsrcIdx2;
            SOCResourceSet leftovers = ourResources.copy();
            leftovers.subtract(targetResources);
            D.ebugPrintlnINFO("*** leftovers = " + leftovers);
            for (getRsrcIdx2 = notNeededRsrcCount - 1; getRsrcIdx2 >= 0 && !someoneIsSellingResource[neededRsrc[getRsrcIdx2]]; --getRsrcIdx2) {
            }
            while (getRsrcIdx2 >= 0 && offer == null) {
                int offerBuildingTime;
                getResourceSet.clear();
                getResourceSet.add(1, notNeededRsrc[getRsrcIdx2]);
                leftovers.add(1, notNeededRsrc[getRsrcIdx2]);
                if (offer == null) {
                    for (giveRsrcIdx1 = 0; giveRsrcIdx1 < notNeededRsrcCount && offer == null; ++giveRsrcIdx1) {
                        if (!leftovers.contains(notNeededRsrc[giveRsrcIdx1]) || notNeededRsrc[giveRsrcIdx1] == notNeededRsrc[getRsrcIdx2]) continue;
                        leftovers.subtract(1, notNeededRsrc[giveRsrcIdx1]);
                        if (this.getOfferToBank(targetResources, leftovers) != null) {
                            giveResourceSet.clear();
                            giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx1]);
                            offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate);
                            if (offerBuildingTime < batnaBuildingTime) {
                                offer = this.makeOfferAux(giveResourceSet, getResourceSet, notNeededRsrc[getRsrcIdx2]);
                                D.ebugPrintlnINFO("*** offer = " + offer);
                                D.ebugPrintlnINFO("*** offerBuildingTime = " + offerBuildingTime);
                            }
                        }
                        leftovers.add(1, notNeededRsrc[giveRsrcIdx1]);
                    }
                }
                if (offer == null) {
                    for (giveRsrcIdx1 = 0; giveRsrcIdx1 < neededRsrcCount && offer == null; ++giveRsrcIdx1) {
                        if (!leftovers.contains(neededRsrc[giveRsrcIdx1])) continue;
                        leftovers.subtract(1, neededRsrc[giveRsrcIdx1]);
                        if (this.getOfferToBank(targetResources, leftovers) != null) {
                            giveResourceSet.clear();
                            giveResourceSet.add(1, neededRsrc[giveRsrcIdx1]);
                            offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate);
                            if (offerBuildingTime < batnaBuildingTime) {
                                offer = this.makeOfferAux(giveResourceSet, getResourceSet, notNeededRsrc[getRsrcIdx2]);
                                D.ebugPrintlnINFO("*** offer = " + offer);
                                D.ebugPrintlnINFO("*** offerBuildingTime = " + offerBuildingTime);
                            }
                        }
                        leftovers.add(1, neededRsrc[giveRsrcIdx1]);
                    }
                }
                leftovers.subtract(1, notNeededRsrc[getRsrcIdx2]);
                --getRsrcIdx2;
            }
        }
        return offer;
    }

    protected SOCTradeOffer makeOfferAux(SOCResourceSet giveResourceSet, SOCResourceSet getResourceSet, int neededResource) {
        D.ebugPrintlnINFO("**** makeOfferAux ****");
        D.ebugPrintlnINFO("giveResourceSet = " + giveResourceSet);
        D.ebugPrintlnINFO("getResourceSet = " + getResourceSet);
        SOCTradeOffer offer = null;
        boolean match = false;
        Iterator<SOCTradeOffer> offersMadeIter = this.offersMade.iterator();
        while (offersMadeIter.hasNext() && !match) {
            SOCTradeOffer pastOffer = offersMadeIter.next();
            if (pastOffer == null || !pastOffer.getGiveSet().equals(giveResourceSet) || !pastOffer.getGetSet().equals(getResourceSet)) continue;
            match = true;
        }
        if (!match) {
            for (int i = 0; i < this.game.maxPlayers; ++i) {
                SOCTradeOffer outsideOffer;
                if (i == this.ourPlayerNumber || (outsideOffer = this.game.getPlayer(i).getCurrentOffer()) == null || !outsideOffer.getGetSet().equals(giveResourceSet) || !outsideOffer.getGiveSet().equals(getResourceSet)) continue;
                match = true;
                break;
            }
        }
        D.ebugPrintlnINFO("*** match = " + match);
        if (!match) {
            SOCPlayerTracker tracker;
            D.ebugPrintlnINFO("* this is a new offer");
            int numOfferedTo = 0;
            boolean[] offeredTo = new boolean[this.game.maxPlayers];
            if (this.game.getCurrentPlayerNumber() == this.ourPlayerNumber) {
                for (int i = 0; i < this.game.maxPlayers; ++i) {
                    D.ebugPrintlnINFO("** isSellingResource[" + i + "][" + neededResource + "] = " + this.isSellingResource[i][neededResource]);
                    if (i == this.ourPlayerNumber || !this.isSellingResource[i][neededResource] || this.game.isSeatVacant(i) || this.game.getPlayer(i).getResources().getTotal() < getResourceSet.getTotal()) continue;
                    tracker = this.playerTrackers[i];
                    if (tracker != null && tracker.getWinGameETA() >= 25) {
                        ++numOfferedTo;
                        offeredTo[i] = true;
                        continue;
                    }
                    offeredTo[i] = false;
                }
            } else {
                int curpn = this.game.getCurrentPlayerNumber();
                if (this.isSellingResource[curpn][neededResource] && this.game.getPlayer(curpn).getResources().getTotal() >= getResourceSet.getTotal()) {
                    D.ebugPrintlnINFO("** isSellingResource[" + curpn + "][" + neededResource + "] = " + this.isSellingResource[curpn][neededResource]);
                    tracker = this.playerTrackers[curpn];
                    if (tracker != null && tracker.getWinGameETA() >= 25) {
                        ++numOfferedTo;
                        offeredTo[curpn] = true;
                    }
                }
            }
            D.ebugPrintlnINFO("** numOfferedTo = " + numOfferedTo);
            if (numOfferedTo > 0) {
                offer = new SOCTradeOffer(this.game.getName(), this.ourPlayerNumber, offeredTo, giveResourceSet, getResourceSet);
                boolean acceptable = false;
                for (int pn = 0; pn < this.game.maxPlayers; ++pn) {
                    if (!offeredTo[pn]) continue;
                    int offerResponse = this.considerOffer2(offer, pn);
                    D.ebugPrintlnINFO("* considerOffer2(offer, " + pn + ") = " + offerResponse);
                    if (offerResponse != 1) continue;
                    acceptable = true;
                    break;
                }
                if (!acceptable) {
                    offer = null;
                }
            }
        }
        return offer;
    }

    protected int getETAToTargetResources(SOCPlayer player, SOCResourceSet targetResources, SOCResourceSet giveSet, SOCResourceSet getSet, SOCBuildingSpeedEstimate estimate) {
        SOCResourceSet ourResourcesCopy = player.getResources().copy();
        D.ebugPrintlnINFO("*** giveSet = " + giveSet);
        D.ebugPrintlnINFO("*** getSet = " + getSet);
        ourResourcesCopy.subtract(giveSet);
        ourResourcesCopy.add(getSet);
        int offerBuildingTime = estimate.calculateRollsFast(ourResourcesCopy, targetResources, 1000, player.getPortFlags());
        D.ebugPrintlnINFO("*** offerBuildingTime = " + offerBuildingTime);
        D.ebugPrintlnINFO("*** ourResourcesCopy = " + ourResourcesCopy);
        return offerBuildingTime;
    }

    public int considerOffer2(SOCTradeOffer offer, int receiverNum) {
        SOCRobotDM simulator;
        D.ebugPrintlnINFO("***** CONSIDER OFFER 2 *****");
        int response = 0;
        SOCPlayer receiverPlayerData = this.game.getPlayer(receiverNum);
        SOCResourceSet receiverResources = receiverPlayerData.getResources();
        SOCResourceSet rsrcsOut = offer.getGetSet();
        SOCResourceSet rsrcsIn = offer.getGiveSet();
        if (!receiverResources.contains(6) && !receiverResources.contains(rsrcsOut)) {
            return response;
        }
        int senderNum = offer.getFrom();
        D.ebugPrintlnINFO("senderNum = " + senderNum);
        D.ebugPrintlnINFO("receiverNum = " + receiverNum);
        D.ebugPrintlnINFO("rsrcs from receiver = " + rsrcsOut);
        D.ebugPrintlnINFO("rsrcs to receiver = " + rsrcsIn);
        SOCPossiblePiece receiverTargetPiece = this.targetPieces[receiverNum];
        D.ebugPrintlnINFO("targetPieces[" + receiverNum + "] = " + receiverTargetPiece);
        SOCPlayerTracker receiverPlayerTracker = this.playerTrackers[receiverNum];
        if (receiverPlayerTracker == null) {
            return response;
        }
        SOCPlayerTracker senderPlayerTracker = this.playerTrackers[senderNum];
        if (senderPlayerTracker == null) {
            return response;
        }
        if (receiverTargetPiece == null) {
            SOCBuildPlanStack receiverBuildingPlan = new SOCBuildPlanStack();
            simulator = new SOCRobotDM(this.brain.getRobotParameters(), this.brain.openingBuildStrategy, this.brain.getEstimatorFactory(), this.playerTrackers, receiverPlayerTracker, receiverPlayerData, receiverBuildingPlan);
            if (receiverNum == this.ourPlayerNumber) {
                simulator.planStuff(this.strategyType);
            } else {
                simulator.planStuff(this.strategyType);
            }
            if (receiverBuildingPlan.isEmpty()) {
                return response;
            }
            this.targetPieces[receiverNum] = receiverTargetPiece = receiverBuildingPlan.getFirstPiece();
        }
        D.ebugPrintlnINFO("receiverTargetPiece = " + receiverTargetPiece);
        SOCPossiblePiece senderTargetPiece = this.targetPieces[senderNum];
        D.ebugPrintlnINFO("targetPieces[" + senderNum + "] = " + senderTargetPiece);
        SOCPlayer senderPlayerData = this.game.getPlayer(senderNum);
        if (senderTargetPiece == null) {
            SOCBuildPlanStack senderBuildingPlan = new SOCBuildPlanStack();
            simulator = new SOCRobotDM(this.brain.getRobotParameters(), this.brain.openingBuildStrategy, this.brain.getEstimatorFactory(), this.playerTrackers, senderPlayerTracker, senderPlayerData, senderBuildingPlan);
            if (senderNum == this.ourPlayerNumber) {
                simulator.planStuff(this.strategyType);
            } else {
                simulator.planStuff(this.strategyType);
            }
            if (senderBuildingPlan.isEmpty()) {
                return response;
            }
            this.targetPieces[senderNum] = senderTargetPiece = senderBuildingPlan.getFirstPiece();
        }
        D.ebugPrintlnINFO("senderTargetPiece = " + senderTargetPiece);
        int senderWGETA = senderPlayerTracker.getWinGameETA();
        if (senderWGETA > 25) {
            boolean inARace = false;
            if (receiverTargetPiece.getType() == 1 || receiverTargetPiece.getType() == 0) {
                for (SOCPossiblePiece threat : receiverTargetPiece.getThreats()) {
                    if (threat.getType() != senderTargetPiece.getType() || threat.getCoordinates() != senderTargetPiece.getCoordinates()) continue;
                    inARace = true;
                    break;
                }
                if (inARace) {
                    D.ebugPrintlnINFO("inARace == true (threat from sender)");
                } else if (receiverTargetPiece.getType() == 1) {
                    for (SOCPossibleSettlement conflict : ((SOCPossibleSettlement)receiverTargetPiece).getConflicts()) {
                        if (senderTargetPiece.getType() != 1 || conflict.getCoordinates() != senderTargetPiece.getCoordinates()) continue;
                        inARace = true;
                        break;
                    }
                    if (inARace) {
                        D.ebugPrintlnINFO("inARace == true (conflict with sender)");
                    }
                }
            }
            if (!inARace) {
                SOCResourceSet targetResources = receiverTargetPiece.getResourcesToBuild();
                if (targetResources == null) {
                    return 0;
                }
                SOCBuildingSpeedEstimate estimate = this.brain.getEstimator(receiverPlayerData.getNumbers());
                if (D.ebugIsEnabled()) {
                    SOCTradeOffer receiverBatna = this.getOfferToBank(targetResources);
                    D.ebugPrintlnINFO("*** receiverBatna = " + receiverBatna);
                }
                int batnaBuildingTime = this.getETAToTargetResources(receiverPlayerData, targetResources, SOCResourceSet.EMPTY_SET, SOCResourceSet.EMPTY_SET, estimate);
                D.ebugPrintlnINFO("*** batnaBuildingTime = " + batnaBuildingTime);
                int offerBuildingTime = this.getETAToTargetResources(receiverPlayerData, targetResources, rsrcsOut, rsrcsIn, estimate);
                D.ebugPrintlnINFO("*** offerBuildingTime = " + offerBuildingTime);
                response = offerBuildingTime < batnaBuildingTime ? 1 : 2;
            }
        }
        return response;
    }

    public SOCTradeOffer makeCounterOffer(SOCTradeOffer originalOffer) {
        int offerBuildingTime;
        int giveRsrcIdx1;
        int getRsrcIdx;
        int tmp;
        int i;
        int j;
        SOCResourceSet targetResources;
        D.ebugPrintlnINFO("***** MAKE COUNTER OFFER *****");
        SOCTradeOffer counterOffer = null;
        SOCPossiblePiece targetPiece = this.targetPieces[this.ourPlayerNumber];
        if (targetPiece == null) {
            SOCBuildPlanStack ourBuildingPlan = this.buildingPlan;
            if (ourBuildingPlan.isEmpty()) {
                D.ebugPrintlnINFO("**** our building plan is empty ****");
                SOCRobotDM simulator = new SOCRobotDM(this.brain.getRobotParameters(), this.brain.openingBuildStrategy, this.brain.getEstimatorFactory(), this.playerTrackers, this.ourPlayerTracker, this.ourPlayerData, ourBuildingPlan);
                simulator.planStuff(this.strategyType);
            }
            if (ourBuildingPlan.isEmpty()) {
                return counterOffer;
            }
            this.targetPieces[this.ourPlayerNumber] = targetPiece = ourBuildingPlan.getFirstPiece();
        }
        if ((targetResources = targetPiece.getResourcesToBuild()) == null) {
            return null;
        }
        SOCResourceSet ourResources = this.ourPlayerData.getResources();
        D.ebugPrintlnINFO("*** targetResources = " + targetResources);
        D.ebugPrintlnINFO("*** ourResources = " + ourResources);
        if (ourResources.contains(targetResources)) {
            return counterOffer;
        }
        if (ourResources.contains(6)) {
            D.ebugPrintlnINFO("AGG WE HAVE UNKNOWN RESOURCES !!!! %%%%%%%%%%%%%%%%%%%%%%%%%%%%");
            return counterOffer;
        }
        SOCTradeOffer batna = this.getOfferToBank(targetResources);
        D.ebugPrintlnINFO("*** BATNA = " + batna);
        SOCBuildingSpeedEstimate estimate = this.brain.getEstimator(this.ourPlayerData.getNumbers());
        SOCResourceSet giveResourceSet = new SOCResourceSet();
        SOCResourceSet getResourceSet = new SOCResourceSet();
        int batnaBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate);
        if (batna != null) {
            batnaBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, batna.getGiveSet(), batna.getGetSet(), estimate);
        }
        D.ebugPrintlnINFO("*** batnaBuildingTime = " + batnaBuildingTime);
        int[] rollsPerResource = estimate.getRollsPerResource();
        int[] neededRsrc = new int[5];
        int[] notNeededRsrc = new int[5];
        int neededRsrcCount = 0;
        int notNeededRsrcCount = 0;
        for (int rsrcType = 1; rsrcType <= 5; ++rsrcType) {
            if (targetResources.contains(rsrcType)) {
                neededRsrc[neededRsrcCount] = rsrcType;
                ++neededRsrcCount;
                continue;
            }
            notNeededRsrc[notNeededRsrcCount] = rsrcType;
            ++notNeededRsrcCount;
        }
        for (j = neededRsrcCount - 1; j >= 0; --j) {
            for (i = 0; i < j; ++i) {
                if (rollsPerResource[neededRsrc[i]] <= rollsPerResource[neededRsrc[i + 1]]) continue;
                tmp = neededRsrc[i];
                neededRsrc[i] = neededRsrc[i + 1];
                neededRsrc[i + 1] = tmp;
            }
        }
        for (j = notNeededRsrcCount - 1; j >= 0; --j) {
            for (i = 0; i < j; ++i) {
                if (rollsPerResource[notNeededRsrc[i]] <= rollsPerResource[notNeededRsrc[i + 1]]) continue;
                tmp = notNeededRsrc[i];
                notNeededRsrc[i] = notNeededRsrc[i + 1];
                notNeededRsrc[i + 1] = tmp;
            }
        }
        for (getRsrcIdx = neededRsrcCount - 1; !(getRsrcIdx < 0 || ourResources.getAmount(neededRsrc[getRsrcIdx]) < targetResources.getAmount(neededRsrc[getRsrcIdx]) && originalOffer.getGiveSet().contains(neededRsrc[getRsrcIdx])); --getRsrcIdx) {
        }
        if (getRsrcIdx >= 0) {
            D.ebugPrintlnINFO("*** getRsrc = " + neededRsrc[getRsrcIdx]);
            getResourceSet.add(1, neededRsrc[getRsrcIdx]);
            D.ebugPrintlnINFO("*** counterOffer should be null : counterOffer = " + counterOffer);
            for (int giveRsrcIdx = 0; giveRsrcIdx < notNeededRsrcCount && counterOffer == null; ++giveRsrcIdx) {
                D.ebugPrintlnINFO("*** ourResources.getAmount(" + notNeededRsrc[giveRsrcIdx] + ") = " + ourResources.getAmount(notNeededRsrc[giveRsrcIdx]));
                if (!ourResources.contains(notNeededRsrc[giveRsrcIdx])) continue;
                giveResourceSet.clear();
                giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx]);
                counterOffer = this.makeOfferAux(giveResourceSet, getResourceSet, neededRsrc[getRsrcIdx]);
                D.ebugPrintlnINFO("*** counterOffer = " + counterOffer);
            }
            D.ebugPrintlnINFO("*** ourResources = " + ourResources);
            if (counterOffer == null) {
                for (int giveRsrcIdx12 = 0; giveRsrcIdx12 < neededRsrcCount && counterOffer == null; ++giveRsrcIdx12) {
                    D.ebugPrintlnINFO("*** ourResources.getAmount(" + neededRsrc[giveRsrcIdx12] + ") = " + ourResources.getAmount(neededRsrc[giveRsrcIdx12]));
                    D.ebugPrintlnINFO("*** targetResources.getAmount(" + neededRsrc[giveRsrcIdx12] + ") = " + targetResources.getAmount(neededRsrc[giveRsrcIdx12]));
                    if (ourResources.getAmount(neededRsrc[giveRsrcIdx12]) <= targetResources.getAmount(neededRsrc[giveRsrcIdx12]) || neededRsrc[giveRsrcIdx12] == neededRsrc[getRsrcIdx]) continue;
                    giveResourceSet.clear();
                    giveResourceSet.add(1, neededRsrc[giveRsrcIdx12]);
                    int offerBuildingTime2 = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate);
                    if (offerBuildingTime2 >= batnaBuildingTime && (batna == null || offerBuildingTime2 != batnaBuildingTime || giveResourceSet.getTotal() >= batna.getGiveSet().getTotal())) continue;
                    counterOffer = this.makeOfferAux(giveResourceSet, getResourceSet, neededRsrc[getRsrcIdx]);
                    D.ebugPrintlnINFO("*** counterOffer = " + counterOffer);
                    D.ebugPrintlnINFO("*** offerBuildingTime = " + offerBuildingTime2);
                }
            }
            D.ebugPrintlnINFO("*** ourResources = " + ourResources);
            SOCResourceSet leftovers = ourResources.copy();
            leftovers.subtract(targetResources);
            D.ebugPrintlnINFO("*** leftovers = " + leftovers);
            if (counterOffer == null) {
                int offerBuildingTime3;
                int giveRsrcIdx2 = 0;
                for (giveRsrcIdx1 = 0; giveRsrcIdx1 < notNeededRsrcCount && counterOffer == null; ++giveRsrcIdx1) {
                    if (!ourResources.contains(notNeededRsrc[giveRsrcIdx1])) continue;
                    while (giveRsrcIdx2 < notNeededRsrcCount && counterOffer == null) {
                        giveResourceSet.clear();
                        giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx1]);
                        giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx2]);
                        if (ourResources.contains(giveResourceSet) && ((offerBuildingTime3 = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate)) < batnaBuildingTime || batna != null && offerBuildingTime3 == batnaBuildingTime && giveResourceSet.getTotal() < batna.getGiveSet().getTotal())) {
                            counterOffer = this.makeOfferAux(giveResourceSet, getResourceSet, neededRsrc[getRsrcIdx]);
                            D.ebugPrintlnINFO("*** counterOffer = " + counterOffer);
                            D.ebugPrintlnINFO("*** offerBuildingTime = " + offerBuildingTime3);
                        }
                        ++giveRsrcIdx2;
                    }
                    for (giveRsrcIdx2 = 0; giveRsrcIdx2 < neededRsrcCount && counterOffer == null; ++giveRsrcIdx2) {
                        if (neededRsrc[giveRsrcIdx2] == neededRsrc[getRsrcIdx]) continue;
                        giveResourceSet.clear();
                        giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx1]);
                        giveResourceSet.add(1, neededRsrc[giveRsrcIdx2]);
                        if (!leftovers.contains(giveResourceSet) || (offerBuildingTime3 = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate)) >= batnaBuildingTime && (batna == null || offerBuildingTime3 != batnaBuildingTime || giveResourceSet.getTotal() >= batna.getGiveSet().getTotal())) continue;
                        counterOffer = this.makeOfferAux(giveResourceSet, getResourceSet, neededRsrc[getRsrcIdx]);
                        D.ebugPrintlnINFO("*** counterOffer = " + counterOffer);
                        D.ebugPrintlnINFO("*** offerBuildingTime = " + offerBuildingTime3);
                    }
                }
                giveRsrcIdx2 = 0;
                for (giveRsrcIdx1 = 0; giveRsrcIdx1 < neededRsrcCount && counterOffer == null; ++giveRsrcIdx1) {
                    if (!leftovers.contains(neededRsrc[giveRsrcIdx1]) || neededRsrc[giveRsrcIdx1] == neededRsrc[getRsrcIdx]) continue;
                    while (giveRsrcIdx2 < notNeededRsrcCount && counterOffer == null) {
                        giveResourceSet.clear();
                        giveResourceSet.add(1, neededRsrc[giveRsrcIdx1]);
                        giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx2]);
                        if (leftovers.contains(giveResourceSet) && ((offerBuildingTime3 = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate)) < batnaBuildingTime || batna != null && offerBuildingTime3 == batnaBuildingTime && giveResourceSet.getTotal() < batna.getGiveSet().getTotal())) {
                            counterOffer = this.makeOfferAux(giveResourceSet, getResourceSet, neededRsrc[getRsrcIdx]);
                            D.ebugPrintlnINFO("*** counterOffer = " + counterOffer);
                            D.ebugPrintlnINFO("*** offerBuildingTime = " + offerBuildingTime3);
                        }
                        ++giveRsrcIdx2;
                    }
                    for (giveRsrcIdx2 = 0; giveRsrcIdx2 < neededRsrcCount && counterOffer == null; ++giveRsrcIdx2) {
                        if (neededRsrc[giveRsrcIdx2] == neededRsrc[getRsrcIdx]) continue;
                        giveResourceSet.clear();
                        giveResourceSet.add(1, neededRsrc[giveRsrcIdx1]);
                        giveResourceSet.add(1, neededRsrc[giveRsrcIdx2]);
                        if (!leftovers.contains(giveResourceSet) || (offerBuildingTime3 = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate)) >= batnaBuildingTime && (batna == null || offerBuildingTime3 != batnaBuildingTime || giveResourceSet.getTotal() >= batna.getGiveSet().getTotal())) continue;
                        counterOffer = this.makeOfferAux(giveResourceSet, getResourceSet, neededRsrc[getRsrcIdx]);
                        D.ebugPrintlnINFO("*** counterOffer = " + counterOffer);
                        D.ebugPrintlnINFO("*** offerBuildingTime = " + offerBuildingTime3);
                    }
                }
            }
        }
        if (counterOffer == null) {
            int getRsrcIdx2;
            SOCResourceSet leftovers = ourResources.copy();
            leftovers.subtract(targetResources);
            D.ebugPrintlnINFO("*** leftovers = " + leftovers);
            for (getRsrcIdx2 = notNeededRsrcCount - 1; getRsrcIdx2 >= 0 && !originalOffer.getGiveSet().contains(notNeededRsrc[getRsrcIdx2]); --getRsrcIdx2) {
            }
            while (getRsrcIdx2 >= 0 && counterOffer == null) {
                getResourceSet.clear();
                getResourceSet.add(1, notNeededRsrc[getRsrcIdx2]);
                leftovers.add(1, notNeededRsrc[getRsrcIdx2]);
                if (counterOffer == null) {
                    for (giveRsrcIdx1 = 0; giveRsrcIdx1 < notNeededRsrcCount && counterOffer == null; ++giveRsrcIdx1) {
                        if (!leftovers.contains(notNeededRsrc[giveRsrcIdx1]) || notNeededRsrc[giveRsrcIdx1] == notNeededRsrc[getRsrcIdx2]) continue;
                        leftovers.subtract(1, notNeededRsrc[giveRsrcIdx1]);
                        if (this.getOfferToBank(targetResources, leftovers) != null) {
                            giveResourceSet.clear();
                            giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx1]);
                            offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate);
                            if (offerBuildingTime < batnaBuildingTime) {
                                counterOffer = this.makeOfferAux(giveResourceSet, getResourceSet, notNeededRsrc[getRsrcIdx2]);
                                D.ebugPrintlnINFO("*** counterOffer = " + counterOffer);
                                D.ebugPrintlnINFO("*** offerBuildingTime = " + offerBuildingTime);
                            }
                        }
                        leftovers.add(1, notNeededRsrc[giveRsrcIdx1]);
                    }
                }
                if (counterOffer == null) {
                    for (giveRsrcIdx1 = 0; giveRsrcIdx1 < neededRsrcCount && counterOffer == null; ++giveRsrcIdx1) {
                        if (!leftovers.contains(neededRsrc[giveRsrcIdx1])) continue;
                        leftovers.subtract(1, neededRsrc[giveRsrcIdx1]);
                        if (this.getOfferToBank(targetResources, leftovers) != null) {
                            giveResourceSet.clear();
                            giveResourceSet.add(1, neededRsrc[giveRsrcIdx1]);
                            offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate);
                            if (offerBuildingTime < batnaBuildingTime) {
                                counterOffer = this.makeOfferAux(giveResourceSet, getResourceSet, notNeededRsrc[getRsrcIdx2]);
                                D.ebugPrintlnINFO("*** counterOffer = " + counterOffer);
                            }
                        }
                        leftovers.add(1, neededRsrc[giveRsrcIdx1]);
                    }
                }
                leftovers.subtract(1, notNeededRsrc[getRsrcIdx2]);
                --getRsrcIdx2;
            }
        }
        if (counterOffer == null) {
            int getRsrcIdx2;
            SOCResourceSet leftovers = ourResources.copy();
            leftovers.subtract(targetResources);
            D.ebugPrintlnINFO("*** leftovers = " + leftovers);
            for (getRsrcIdx2 = notNeededRsrcCount - 1; getRsrcIdx2 >= 0 && !originalOffer.getGiveSet().contains(notNeededRsrc[getRsrcIdx2]); --getRsrcIdx2) {
            }
            while (getRsrcIdx2 >= 0 && counterOffer == null) {
                getResourceSet.clear();
                getResourceSet.add(2, notNeededRsrc[getRsrcIdx2]);
                leftovers.add(2, notNeededRsrc[getRsrcIdx2]);
                if (counterOffer == null) {
                    for (giveRsrcIdx1 = 0; giveRsrcIdx1 < notNeededRsrcCount && counterOffer == null; ++giveRsrcIdx1) {
                        if (!leftovers.contains(notNeededRsrc[giveRsrcIdx1]) || notNeededRsrc[giveRsrcIdx1] == notNeededRsrc[getRsrcIdx2]) continue;
                        leftovers.subtract(1, notNeededRsrc[giveRsrcIdx1]);
                        if (this.getOfferToBank(targetResources, leftovers) != null) {
                            giveResourceSet.clear();
                            giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx1]);
                            offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate);
                            if (offerBuildingTime < batnaBuildingTime) {
                                counterOffer = this.makeOfferAux(giveResourceSet, getResourceSet, notNeededRsrc[getRsrcIdx2]);
                                D.ebugPrintlnINFO("*** counterOffer = " + counterOffer);
                                D.ebugPrintlnINFO("*** offerBuildingTime = " + offerBuildingTime);
                            }
                        }
                        leftovers.add(1, notNeededRsrc[giveRsrcIdx1]);
                    }
                }
                if (counterOffer == null) {
                    for (giveRsrcIdx1 = 0; giveRsrcIdx1 < neededRsrcCount && counterOffer == null; ++giveRsrcIdx1) {
                        if (!leftovers.contains(neededRsrc[giveRsrcIdx1])) continue;
                        leftovers.subtract(1, neededRsrc[giveRsrcIdx1]);
                        if (this.getOfferToBank(targetResources, leftovers) != null) {
                            giveResourceSet.clear();
                            giveResourceSet.add(1, neededRsrc[giveRsrcIdx1]);
                            offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate);
                            if (offerBuildingTime < batnaBuildingTime) {
                                counterOffer = this.makeOfferAux(giveResourceSet, getResourceSet, notNeededRsrc[getRsrcIdx2]);
                                D.ebugPrintlnINFO("*** counterOffer = " + counterOffer);
                            }
                        }
                        leftovers.add(1, neededRsrc[giveRsrcIdx1]);
                    }
                }
                leftovers.subtract(2, notNeededRsrc[getRsrcIdx2]);
                --getRsrcIdx2;
            }
        }
        if (counterOffer == null) {
            int getRsrcIdx2;
            SOCResourceSet leftovers = ourResources.copy();
            leftovers.subtract(targetResources);
            D.ebugPrintlnINFO("*** leftovers = " + leftovers);
            for (getRsrcIdx2 = notNeededRsrcCount - 1; getRsrcIdx2 >= 0 && !originalOffer.getGiveSet().contains(notNeededRsrc[getRsrcIdx2]); --getRsrcIdx2) {
            }
            while (getRsrcIdx2 >= 0 && counterOffer == null) {
                getResourceSet.clear();
                getResourceSet.add(3, notNeededRsrc[getRsrcIdx2]);
                leftovers.add(3, notNeededRsrc[getRsrcIdx2]);
                if (counterOffer == null) {
                    for (giveRsrcIdx1 = 0; giveRsrcIdx1 < notNeededRsrcCount && counterOffer == null; ++giveRsrcIdx1) {
                        if (!leftovers.contains(notNeededRsrc[giveRsrcIdx1]) || notNeededRsrc[giveRsrcIdx1] == notNeededRsrc[getRsrcIdx2]) continue;
                        leftovers.subtract(1, notNeededRsrc[giveRsrcIdx1]);
                        if (this.getOfferToBank(targetResources, leftovers) != null) {
                            giveResourceSet.clear();
                            giveResourceSet.add(1, notNeededRsrc[giveRsrcIdx1]);
                            offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate);
                            if (offerBuildingTime < batnaBuildingTime) {
                                counterOffer = this.makeOfferAux(giveResourceSet, getResourceSet, notNeededRsrc[getRsrcIdx2]);
                                D.ebugPrintlnINFO("*** counterOffer = " + counterOffer);
                                D.ebugPrintlnINFO("*** offerBuildingTime = " + offerBuildingTime);
                            }
                        }
                        leftovers.add(1, notNeededRsrc[giveRsrcIdx1]);
                    }
                }
                if (counterOffer == null) {
                    for (giveRsrcIdx1 = 0; giveRsrcIdx1 < neededRsrcCount && counterOffer == null; ++giveRsrcIdx1) {
                        if (!leftovers.contains(neededRsrc[giveRsrcIdx1])) continue;
                        leftovers.subtract(1, neededRsrc[giveRsrcIdx1]);
                        if (this.getOfferToBank(targetResources, leftovers) != null) {
                            giveResourceSet.clear();
                            giveResourceSet.add(1, neededRsrc[giveRsrcIdx1]);
                            offerBuildingTime = this.getETAToTargetResources(this.ourPlayerData, targetResources, giveResourceSet, getResourceSet, estimate);
                            if (offerBuildingTime < batnaBuildingTime) {
                                counterOffer = this.makeOfferAux(giveResourceSet, getResourceSet, notNeededRsrc[getRsrcIdx2]);
                                D.ebugPrintlnINFO("*** counterOffer = " + counterOffer);
                            }
                        }
                        leftovers.add(1, neededRsrc[giveRsrcIdx1]);
                    }
                }
                leftovers.subtract(3, notNeededRsrc[getRsrcIdx2]);
                --getRsrcIdx2;
            }
        }
        return counterOffer;
    }

    public SOCTradeOffer getOfferToBank(SOCResourceSet targetResources, SOCResourceSet ourResources) {
        int tradeRatio;
        int giveRsrcIdx;
        int tmp;
        int i;
        int j;
        SOCTradeOffer bankTrade = null;
        if (ourResources.contains(targetResources)) {
            return bankTrade;
        }
        SOCBuildingSpeedEstimate estimate = this.brain.getEstimator(this.ourPlayerData.getNumbers());
        int[] rollsPerResource = estimate.getRollsPerResource();
        boolean[] ports = this.ourPlayerData.getPortFlags();
        int[] neededRsrc = new int[5];
        int[] notNeededRsrc = new int[5];
        int neededRsrcCount = 0;
        int notNeededRsrcCount = 0;
        for (int rsrcType = 1; rsrcType <= 5; ++rsrcType) {
            if (targetResources.contains(rsrcType)) {
                neededRsrc[neededRsrcCount] = rsrcType;
                ++neededRsrcCount;
                continue;
            }
            notNeededRsrc[notNeededRsrcCount] = rsrcType;
            ++notNeededRsrcCount;
        }
        if (neededRsrcCount == 0) {
            return bankTrade;
        }
        for (j = neededRsrcCount - 1; j >= 0; --j) {
            for (i = 0; i < j; ++i) {
                if (rollsPerResource[neededRsrc[i]] <= rollsPerResource[neededRsrc[i + 1]]) continue;
                tmp = neededRsrc[i];
                neededRsrc[i] = neededRsrc[i + 1];
                neededRsrc[i + 1] = tmp;
            }
        }
        for (j = notNeededRsrcCount - 1; j >= 0; --j) {
            for (i = 0; i < j; ++i) {
                if (rollsPerResource[notNeededRsrc[i]] <= rollsPerResource[notNeededRsrc[i + 1]]) continue;
                tmp = notNeededRsrc[i];
                notNeededRsrc[i] = notNeededRsrc[i + 1];
                notNeededRsrc[i + 1] = tmp;
            }
        }
        int getRsrcIdx = neededRsrcCount - 1;
        while (ourResources.getAmount(neededRsrc[getRsrcIdx]) >= targetResources.getAmount(neededRsrc[getRsrcIdx])) {
            --getRsrcIdx;
        }
        for (giveRsrcIdx = 0; giveRsrcIdx < notNeededRsrcCount; ++giveRsrcIdx) {
            tradeRatio = ports[notNeededRsrc[giveRsrcIdx]] ? 2 : (ports[0] ? 3 : 4);
            if (ourResources.getAmount(notNeededRsrc[giveRsrcIdx]) < tradeRatio) continue;
            SOCResourceSet give = new SOCResourceSet();
            SOCResourceSet get = new SOCResourceSet();
            give.add(tradeRatio, notNeededRsrc[giveRsrcIdx]);
            get.add(1, neededRsrc[getRsrcIdx]);
            boolean[] to = new boolean[this.game.maxPlayers];
            for (int i2 = 0; i2 < this.game.maxPlayers; ++i2) {
                to[i2] = false;
            }
            bankTrade = new SOCTradeOffer(this.game.getName(), this.ourPlayerNumber, to, give, get);
            return bankTrade;
        }
        for (giveRsrcIdx = 0; giveRsrcIdx < neededRsrcCount; ++giveRsrcIdx) {
            tradeRatio = ports[neededRsrc[giveRsrcIdx]] ? 2 : (ports[0] ? 3 : 4);
            if (rollsPerResource[neededRsrc[giveRsrcIdx]] >= rollsPerResource[neededRsrc[getRsrcIdx]]) {
                if (ourResources.getAmount(neededRsrc[giveRsrcIdx]) - targetResources.getAmount(neededRsrc[giveRsrcIdx]) < tradeRatio) continue;
                SOCResourceSet give = new SOCResourceSet();
                SOCResourceSet get = new SOCResourceSet();
                give.add(tradeRatio, neededRsrc[giveRsrcIdx]);
                get.add(1, neededRsrc[getRsrcIdx]);
                boolean[] to = new boolean[this.game.maxPlayers];
                for (int i3 = 0; i3 < this.game.maxPlayers; ++i3) {
                    to[i3] = false;
                }
                bankTrade = new SOCTradeOffer(this.game.getName(), this.ourPlayerNumber, to, give, get);
                return bankTrade;
            }
            if (ourResources.getAmount(neededRsrc[giveRsrcIdx]) < tradeRatio) continue;
            SOCResourceSet give = new SOCResourceSet();
            SOCResourceSet get = new SOCResourceSet();
            give.add(tradeRatio, neededRsrc[giveRsrcIdx]);
            get.add(1, neededRsrc[getRsrcIdx]);
            boolean[] to = new boolean[this.game.maxPlayers];
            for (int i4 = 0; i4 < this.game.maxPlayers; ++i4) {
                to[i4] = false;
            }
            bankTrade = new SOCTradeOffer(this.game.getName(), this.ourPlayerNumber, to, give, get);
            return bankTrade;
        }
        return bankTrade;
    }

    public SOCTradeOffer getOfferToBank(SOCBuildPlan buildPlan, SOCResourceSet ourResources) {
        if (buildPlan == null || buildPlan.isEmpty()) {
            return null;
        }
        return this.getOfferToBank(buildPlan.getFirstPieceResources(), ourResources);
    }

    public SOCTradeOffer getOfferToBank(SOCResourceSet targetResources) {
        return this.getOfferToBank(targetResources, this.ourPlayerData.getResources());
    }

    protected void recordResourcesFromOffer(SOCTradeOffer offer) {
        int fromPN = offer.getFrom();
        SOCResourceSet giveSet = offer.getGiveSet();
        for (int rsrcType = 1; rsrcType <= 5; ++rsrcType) {
            if (!giveSet.contains(rsrcType)) continue;
            D.ebugPrintlnINFO("%%% player " + fromPN + " wants to sell " + rsrcType);
            this.markAsWantsAnotherOffer(fromPN, rsrcType);
        }
        SOCResourceSet getSet = offer.getGetSet();
        for (int rsrcType = 1; rsrcType <= 5; ++rsrcType) {
            if (!getSet.contains(rsrcType)) continue;
            D.ebugPrintlnINFO("%%% player " + fromPN + " wants to buy " + rsrcType + " and therefore does not want to sell it");
            this.markAsNotSelling(fromPN, rsrcType);
        }
    }

    protected void recordResourcesFromReject(int rejector) {
        D.ebugPrintlnINFO("%%%%%%%%% REJECT OFFER %%%%%%%%%%%%%");
        SOCTradeOffer ourOffer = this.ourPlayerData.getCurrentOffer();
        if (ourOffer == null) {
            return;
        }
        SOCResourceSet getSet = ourOffer.getGetSet();
        for (int rsrcType = 1; rsrcType <= 5; ++rsrcType) {
            if (!getSet.contains(rsrcType) || this.wantsAnotherOffer(rejector, rsrcType)) continue;
            this.markAsNotSelling(rejector, rsrcType);
        }
    }

    protected void recordResourcesFromRejectAlt(int rejector) {
        D.ebugPrintlnINFO("%%%% ALT REJECT OFFER %%%%");
        for (int pn = 0; pn < this.game.maxPlayers; ++pn) {
            boolean[] offeredTo;
            SOCTradeOffer offer = this.game.getPlayer(pn).getCurrentOffer();
            if (offer == null || !(offeredTo = offer.getTo())[rejector]) continue;
            SOCResourceSet getSet = offer.getGetSet();
            for (int rsrcType = 1; rsrcType <= 5; ++rsrcType) {
                if (!getSet.contains(rsrcType) || this.wantsAnotherOffer(rejector, rsrcType)) continue;
                this.markAsNotSelling(rejector, rsrcType);
            }
        }
    }

    protected void recordResourcesFromNoResponse(SOCTradeOffer ourCurrentOffer) {
        boolean[] offeredTo = ourCurrentOffer.getTo();
        SOCResourceSet getSet = ourCurrentOffer.getGetSet();
        for (int rsrcType = 1; rsrcType <= 5; ++rsrcType) {
            if (!getSet.contains(rsrcType)) continue;
            for (int pn = 0; pn < this.game.maxPlayers; ++pn) {
                if (!offeredTo[pn]) continue;
                this.markAsNotSelling(pn, rsrcType);
                this.markAsNotWantingAnotherOffer(pn, rsrcType);
            }
        }
    }
}

