/*
 * Decompiled with CFR 0.152.
 */
package soc.robot;

import soc.message.SOCMessage;
import soc.message.SOCTimingPing;
import soc.util.CappedQueue;
import soc.util.CutoffExceededException;

class SOCRobotPinger
extends Thread {
    private CappedQueue<SOCMessage> messageQueue;
    private final SOCTimingPing ping;
    private volatile boolean alive;
    private final String robotNickname;

    public SOCRobotPinger(CappedQueue<SOCMessage> q, String gameName, String nickname) {
        this.setDaemon(true);
        this.messageQueue = q;
        this.ping = new SOCTimingPing(gameName);
        this.alive = true;
        this.robotNickname = nickname;
    }

    @Override
    public void run() {
        try {
            Thread.currentThread().setName("robotPinger-" + this.robotNickname);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        while (this.alive) {
            try {
                this.messageQueue.put(this.ping);
            }
            catch (CutoffExceededException exc) {
                this.alive = false;
            }
            Thread.yield();
            try {
                SOCRobotPinger.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.messageQueue = null;
    }

    public void stopPinger() {
        this.alive = false;
    }
}

