/*
 * Decompiled with CFR 0.152.
 */
package soc.robot.sample3p;

import soc.game.SOCGame;
import soc.game.SOCResourceSet;
import soc.game.SOCTradeOffer;
import soc.message.SOCMessage;
import soc.robot.SOCRobotBrain;
import soc.robot.SOCRobotClient;
import soc.robot.sample3p.SampleDiscardStrategy;
import soc.util.CappedQueue;
import soc.util.SOCRobotParameters;

public class Sample3PBrain
extends SOCRobotBrain {
    protected int numDeclinedTrades = 0;

    public Sample3PBrain(SOCRobotClient rc, SOCRobotParameters params, SOCGame ga, CappedQueue<SOCMessage> mq) {
        super(rc, params, ga, mq);
    }

    @Override
    public void setOurPlayerData() {
        super.setOurPlayerData();
        String botName = this.client.getNickname();
        this.client.sendText(this.game, "Hello from sample bot " + botName + "!");
        String optExtBot = this.game.getGameOptionStringValue("_EXT_BOT");
        if (optExtBot != null) {
            System.err.println("Bot " + botName + ": __EXT_BOT is: " + optExtBot);
        }
    }

    @Override
    protected void setStrategyFields() {
        super.setStrategyFields();
        this.discardStrategy = new SampleDiscardStrategy(this.game, this.ourPlayerData, this, this.rand);
    }

    @Override
    public void resetFieldsAndBuildingPlan() {
        super.resetFieldsAndBuildingPlan();
        this.numDeclinedTrades = 0;
    }

    @Override
    public void resetFieldsAtEndTurn() {
        super.resetFieldsAtEndTurn();
        this.numDeclinedTrades = 0;
    }

    @Override
    protected int considerOffer(SOCTradeOffer offer) {
        if (!offer.getTo()[this.getOurPlayerNumber()]) {
            return -1;
        }
        SOCResourceSet res = offer.getGiveSet();
        if (this.numDeclinedTrades <= 2 && !res.contains(1) && !res.contains(3)) {
            return 0;
        }
        return super.considerOffer(offer);
    }
}

