/*
 * Decompiled with CFR 0.152.
 */
package soc.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import soc.game.SOCBoard;
import soc.game.SOCBoard4p;
import soc.game.SOCBoard6p;
import soc.game.SOCBoardLarge;
import soc.game.SOCFortress;
import soc.game.SOCGame;
import soc.game.SOCGameOption;
import soc.game.SOCGameOptionSet;
import soc.game.SOCPlayer;
import soc.game.SOCSettlement;
import soc.game.SOCShip;
import soc.game.SOCVillage;
import soc.util.IntPair;
import soc.util.IntTriple;

public class SOCBoardAtServer
extends SOCBoardLarge {
    public static final String PROP_JSETTLERS_DEBUG_BOARD_FOG = "jsettlers.debug.board.fog";
    public static final String PROP_JSETTLERS_DEBUG_BOARD_FOG__GOLD = "jsettlers.debug.board.fog_gold";
    private static final long serialVersionUID = 2000L;
    private static transient NewBoardProgressListener newBoardProgressListener;
    private int bonusExcludeLandArea;
    private Stack<Integer> drawStack;
    private int piratePathIndex;
    private static final int[] FALLBACK_BOARDSIZE;
    private static final int[][] FALLBACK_VIS_SHIFT;
    private static final int[] PORT_EDGE_FACING_MAINLAND_4PL;
    private static final int[] PORT_EDGE_FACING_ISLANDS_4PL;
    private static final int[] PORT_TYPE_ISLANDS_4PL;
    private static final int[] LANDHEX_DICEPATH_MAINLAND_4PL;
    private static final int[] LANDHEX_COORD_ISLANDS_ALL_4PL;
    private static final int[][] LANDHEX_COORD_ISLANDS_EACH;
    private static final int[] LANDHEX_LANDAREA_RANGES_ISLANDS_4PL;
    private static final int[] LANDHEX_TYPE_ISLANDS_4PL;
    private static final int[] LANDHEX_DICENUM_ISLANDS_4PL;
    private static final int[] LANDHEX_DICEPATH_MAINLAND_6PL;
    private static final int[] PORT_EDGE_FACING_MAINLAND_6PL;
    private static final int[] LANDHEX_COORD_ISLANDS_ALL_6PL;
    private static final int[] LANDHEX_LANDAREA_RANGES_ISLANDS_6PL;
    private static final int[] LANDHEX_TYPE_ISLANDS_6PL;
    private static final int[] LANDHEX_DICENUM_ISLANDS_6PL;
    private static final int[] PORT_EDGE_FACING_ISLANDS_6PL;
    private static final int[] PORT_TYPE_ISLANDS_6PL;
    private static final int[] NSHO_BOARDSIZE;
    private static final int[][] NSHO_VIS_SHIFT;
    private static final int NSHO_ROBBER_HEX_3PL = 773;
    private static final int[] NSHO_PIRATE_HEX;
    private static final int[][] NSHO_LANDHEX_TYPE_MAIN;
    private static final int[][] NSHO_LANDHEX_COORD_MAIN;
    private static final int[][] NSHO_DICENUM_MAIN;
    private static final int[][] NSHO_PORT_EDGE_FACING;
    private static final int[][] NSHO_PORT_TYPE;
    private static final int[][] NSHO_LANDHEX_TYPE_ISL;
    private static final int[][] NSHO_LANDHEX_LANDAREA_RANGES;
    private static final int[][] NSHO_LANDHEX_COORD_ISL;
    private static final int[][] NSHO_DICENUM_ISL;
    private static final int[] FOG_ISL_BOARDSIZE;
    private static final int[][] FOG_ISL_VIS_SHIFT;
    private static final int[] FOG_ISL_ROBBER_HEX;
    private static final int[] FOG_ISL_PIRATE_HEX;
    private static final int[] FOG_ISL_LANDHEX_TYPE_MAIN_3PL;
    private static final int[] FOG_ISL_LANDHEX_COORD_MAIN_3PL;
    private static final int[] FOG_ISL_DICENUM_MAIN_3PL;
    private static final int[] FOG_ISL_PORT_EDGE_FACING_3PL;
    private static final int[] FOG_ISL_PORT_TYPE_3PL;
    private static final int[] FOG_ISL_LANDHEX_TYPE_FOG;
    private static final int[] FOG_ISL_LANDHEX_COORD_FOG_3PL;
    private static final int[] FOG_ISL_DICENUM_FOG_3PL;
    private static final int[] FOG_ISL_LANDHEX_TYPE_MAIN_4PL;
    private static final int[] FOG_ISL_LANDHEX_COORD_MAIN_4PL;
    private static final int[] FOG_ISL_DICENUM_MAIN_4PL;
    private static final int[] FOG_ISL_PORT_EDGE_FACING_4PL;
    private static final int[] FOG_ISL_PORT_TYPE_4PL;
    private static final int[] FOG_ISL_LANDHEX_COORD_FOG_4PL;
    private static final int[] FOG_ISL_DICENUM_FOG_4PL;
    private static final int[] FOG_ISL_LANDHEX_TYPE_MAIN_6PL;
    private static final int[] FOG_ISL_LANDHEX_COORD_MAIN_6PL;
    private static final int[] FOG_ISL_DICENUM_MAIN_6PL;
    private static final int[] FOG_ISL_PORT_EDGE_FACING_6PL;
    private static final int[] FOG_ISL_PORT_TYPE_6PL;
    private static final int[] FOG_ISL_LANDHEX_TYPE_FOG_6PL;
    private static final int[] FOG_ISL_LANDHEX_COORD_FOG_6PL;
    private static final int[] FOG_ISL_DICENUM_FOG_6PL;
    private static final int[] FOG_ISL_LANDHEX_TYPE_GC;
    private static final int[] FOG_ISL_LANDHEX_COORD_GC;
    private static final int[] FOG_ISL_DICENUM_GC;
    private static final int[] FOUR_ISL_BOARDSIZE;
    private static final int[][] FOUR_ISL_VIS_SHIFT;
    private static final int[] FOUR_ISL_ROBBER_HEX;
    private static final int[] FOUR_ISL_PIRATE_HEX;
    private static final int[] FOUR_ISL_LANDHEX_TYPE_3PL;
    private static final int[] FOUR_ISL_LANDHEX_COORD_3PL;
    private static final int[] FOUR_ISL_DICENUM_3PL;
    private static final int[] FOUR_ISL_LANDHEX_LANDAREA_RANGES_3PL;
    private static final int[] FOUR_ISL_PORT_EDGE_FACING_3PL;
    private static final int[] FOUR_ISL_PORT_TYPE_3PL;
    private static final int[] FOUR_ISL_LANDHEX_TYPE_4PL;
    private static final int[] FOUR_ISL_LANDHEX_COORD_4PL;
    private static final int[] FOUR_ISL_DICENUM_4PL;
    private static final int[] FOUR_ISL_LANDHEX_LANDAREA_RANGES_4PL;
    private static final int[] FOUR_ISL_PORT_EDGE_FACING_4PL;
    private static final int[] FOUR_ISL_PORT_TYPE_4PL;
    private static final int[] FOUR_ISL_LANDHEX_TYPE_6PL;
    private static final int[] FOUR_ISL_LANDHEX_COORD_6PL;
    private static final int[] FOUR_ISL_DICENUM_6PL;
    private static final int[] FOUR_ISL_LANDHEX_LANDAREA_RANGES_6PL;
    private static final int[] FOUR_ISL_PORT_EDGE_FACING_6PL;
    private static final int[] FOUR_ISL_PORT_TYPE_6PL;
    private static final int[] PIR_ISL_VIS_SHIFT;
    private static final int[] PIR_ISL_BOARDSIZE;
    private static final int[] PIR_ISL_PIRATE_HEX;
    private static final int[][] PIR_ISL_LANDHEX_TYPE_MAIN;
    private static final int[][] PIR_ISL_LANDHEX_COORD_MAIN;
    private static final int[][] PIR_ISL_DICENUM_MAIN;
    private static final int[][] PIR_ISL_PORT_EDGE_FACING;
    private static final int[][] PIR_ISL_PORT_TYPE;
    private static final int[][] PIR_ISL_LANDHEX_TYPE_PIRI;
    private static final int[][] PIR_ISL_LANDHEX_COORD_PIRI;
    private static final int[][] PIR_ISL_DICENUM_PIRI;
    private static final int[][] PIR_ISL_PPATH;
    private static final int[][][] PIR_ISL_SEA_EDGES;
    private static final int[][] PIR_ISL_INIT_PIECES;
    private static final int[] TTDESERT_BOARDSIZE;
    private static final int[][] TTDESERT_VIS_SHIFT;
    private static final int[] TTDESERT_PIRATE_HEX;
    private static final int[][] TTDESERT_LANDHEX_TYPE_MAIN;
    private static final int[][] TTDESERT_LANDHEX_COORD_MAIN;
    private static final int[][] TTDESERT_LANDHEX_RANGES_MAIN;
    private static final int[][] TTDESERT_LANDHEX_COORD_DESERT;
    private static final int[][] TTDESERT_DICENUM_MAIN;
    private static final int[][] TTDESERT_PORT_EDGE_FACING;
    private static final int[][] TTDESERT_PORT_TYPE;
    private static final int[][] TTDESERT_LANDHEX_TYPE_SMALL;
    private static final int[][] TTDESERT_LANDHEX_RANGES_SMALL;
    private static final int[][] TTDESERT_LANDHEX_COORD_SMALL;
    private static final int[][] TTDESERT_DICENUM_SMALL;
    private static final int[] FOR_TRI_BOARDSIZE;
    private static final int[][] FOR_TRI_VIS_SHIFT;
    private static final int[] FOR_TRI_PIRATE_HEX;
    private static final int[][] FOR_TRI_LANDHEX_TYPE_MAIN;
    private static final int[][] FOR_TRI_LANDHEX_COORD_MAIN;
    private static final int[][] FOR_TRI_LANDHEX_COORD_MAIN_FAR_COASTAL;
    private static final int[][] FOR_TRI_DICENUM_MAIN;
    private static final int[][] FOR_TRI_PORT_EDGE_FACING;
    private static final int[][] FOR_TRI_PORT_TYPE;
    private static final int[][] FOR_TRI_LANDHEX_TYPE_ISL;
    private static final int[][] FOR_TRI_LANDHEX_COORD_ISL;
    private static final int[][] FOR_TRI_SVP_EDGES;
    private static final int[][] FOR_TRI_DEV_CARD_EDGES;
    private static final int[] CLVI_BOARDSIZE;
    private static final int[][] CLVI_VIS_SHIFT;
    private static final int[] CLVI_ROBBER_HEX;
    private static final int[] CLVI_PIRATE_HEX;
    private static final int[][] CLVI_LANDHEX_TYPE_MAIN;
    private static final int[][] CLVI_LANDHEX_COORD_MAIN;
    private static final int[][] CLVI_DICENUM_MAIN;
    private static final int[][] CLVI_PORT_EDGE_FACING;
    private static final int[][] CLVI_PORT_TYPE;
    private static final int[][] CLVI_LANDHEX_TYPE_ISL;
    private static final int[][] CLVI_LANDHEX_COORD_ISL;
    private static final int[][] CLVI_CLOTH_VILLAGE_AMOUNTS_NODES_DICE;
    private static final int[] WOND_BOARDSIZE;
    private static final int[][] WOND_VIS_SHIFT;
    private static final int[][] WOND_LANDHEX_TYPE_MAIN;
    private static final int[][] WOND_LANDHEX_COORD_MAIN;
    private static final int[][] WOND_LANDHEX_COORD_MAIN_AT_DESERT;
    private static final int[][] WOND_LANDHEX_COORD_DESERT;
    private static final int[][] WOND_DICENUM_MAIN;
    private static final int[][] WOND_PORT_EDGE_FACING;
    private static final int[][] WOND_PORT_TYPE;
    private static final int[][] WOND_LANDHEX_TYPE_ISL;
    private static final int[][] WOND_LANDHEX_COORD_ISL;
    private static final int[][] WOND_DICENUM_ISL;
    private static final int[][][] WOND_SPECIAL_NODES;

    public SOCBoardAtServer(SOCGameOptionSet gameOpts, int maxPlayers, IntPair boardHeightWidth) throws IllegalArgumentException {
        super(gameOpts, maxPlayers, boardHeightWidth);
        int[] boardVS = SOCBoardAtServer.getBoardShift(gameOpts);
        if (boardVS != null) {
            this.setAddedLayoutPart("VS", boardVS);
        }
    }

    public static final void setNewBoardProgressListener(NewBoardProgressListener li) {
        newBoardProgressListener = li;
    }

    public int getBonusExcludeLandArea() {
        return this.bonusExcludeLandArea;
    }

    protected void setBonusExcludeLandArea(int la) {
        if (la <= 0) {
            throw new IllegalArgumentException("la must be > 0, is " + la);
        }
        if (this.bonusExcludeLandArea != 0) {
            throw new IllegalStateException("is already set");
        }
        if (this.startingLandArea == 0) {
            throw new IllegalStateException("startingLandArea 0");
        }
        this.bonusExcludeLandArea = la;
    }

    @Override
    public Integer drawItemFromStack() {
        if (this.drawStack == null || this.drawStack.isEmpty()) {
            return null;
        }
        return this.drawStack.pop();
    }

    @Override
    public void putItemInStackRandomly(Integer item) throws UnsupportedOperationException, IllegalArgumentException {
        if (item == null) {
            throw new IllegalArgumentException("item");
        }
        if (this.drawStack == null) {
            throw new UnsupportedOperationException("null stack");
        }
        if (this.drawStack.isEmpty()) {
            this.drawStack.push(item);
        } else {
            this.drawStack.insertElementAt(item, this.rand.nextInt(this.drawStack.size()));
        }
    }

    public boolean distributeClothFromRoll(SOCGame game, SOCGame.RollResult rollRes, int dice) {
        if (this.villages == null || this.villages.isEmpty()) {
            return false;
        }
        boolean hadAny = false;
        for (SOCVillage v : this.villages.values()) {
            if (v.diceNum != dice) continue;
            hadAny |= v.distributeCloth(game, rollRes);
        }
        return hadAny;
    }

    @Override
    public int movePirateHexAlongPath(int numSteps) throws IllegalStateException {
        int i;
        int[] path = this.getAddedLayoutPart("PP");
        if (path == null) {
            throw new IllegalStateException();
        }
        if (this.pirateHex == 0) {
            return 0;
        }
        for (i = this.piratePathIndex + numSteps; i >= path.length; i -= path.length) {
        }
        this.piratePathIndex = i;
        int ph = path[i];
        this.setPirateHex(ph, true);
        return ph;
    }

    @Override
    public void makeNewBoard(SOCGameOptionSet opts) {
        int[] nodes;
        int facing;
        int edge;
        int ptype;
        int i;
        int j;
        int L;
        int pcountMain;
        int[] portTypes_islands;
        int[] portTypes_main;
        Object desertLandhexType;
        int idx;
        int[] PORTS_TYPES_ISLANDS;
        int[] PORT_LOC_FACING_ISLANDS;
        int[] PORT_LOC_FACING_MAINLAND;
        int[] PORTS_TYPES_MAINLAND;
        int maxPl;
        String ostr;
        SOCGameOption optSC;
        SOCGameOption opt_breakClumps = opts != null ? opts.get("BC") : null;
        SOCGameOption opt = opts != null ? opts.get("_SC_FOG") : null;
        boolean hasScenarioFog = opt != null && opt.getBoolValue();
        SOCGameOption sOCGameOption = optSC = opts != null ? opts.get("SC") : null;
        String scen = optSC != null ? ((ostr = optSC.getStringValue()) != null ? ostr : "") : "";
        boolean hasScenario4ISL = scen.equals("SC_4ISL");
        if (this.maxPlayers == 6) {
            maxPl = 6;
        } else {
            SOCGameOption sOCGameOption2 = opt = opts != null ? opts.get("PL") : null;
            maxPl = opt == null ? 4 : (opt.getIntValue() > 4 ? 6 : opt.getIntValue());
        }
        if (!hasScenario4ISL) {
            this.startingLandArea = 1;
        }
        if (hasScenario4ISL) {
            if (maxPl < 4) {
                this.landAreasLegalNodes = new HashSet[5];
                this.makeNewBoard_placeHexes(FOUR_ISL_LANDHEX_TYPE_3PL, FOUR_ISL_LANDHEX_COORD_3PL, false, FOUR_ISL_DICENUM_3PL, true, true, FOUR_ISL_LANDHEX_LANDAREA_RANGES_3PL, false, false, maxPl, opt_breakClumps, scen, opts);
                PORTS_TYPES_MAINLAND = FOUR_ISL_PORT_TYPE_3PL;
                PORT_LOC_FACING_MAINLAND = FOUR_ISL_PORT_EDGE_FACING_3PL;
                this.setRobberHex(FOUR_ISL_ROBBER_HEX[0], false);
                this.pirateHex = FOUR_ISL_PIRATE_HEX[0];
            } else if (maxPl != 6) {
                this.landAreasLegalNodes = new HashSet[5];
                this.makeNewBoard_placeHexes(FOUR_ISL_LANDHEX_TYPE_4PL, FOUR_ISL_LANDHEX_COORD_4PL, false, FOUR_ISL_DICENUM_4PL, true, true, FOUR_ISL_LANDHEX_LANDAREA_RANGES_4PL, false, false, maxPl, opt_breakClumps, scen, opts);
                PORTS_TYPES_MAINLAND = FOUR_ISL_PORT_TYPE_4PL;
                PORT_LOC_FACING_MAINLAND = FOUR_ISL_PORT_EDGE_FACING_4PL;
                this.setRobberHex(FOUR_ISL_ROBBER_HEX[1], false);
                this.pirateHex = FOUR_ISL_PIRATE_HEX[1];
            } else {
                this.landAreasLegalNodes = new HashSet[7];
                this.makeNewBoard_placeHexes(FOUR_ISL_LANDHEX_TYPE_6PL, FOUR_ISL_LANDHEX_COORD_6PL, false, FOUR_ISL_DICENUM_6PL, true, true, FOUR_ISL_LANDHEX_LANDAREA_RANGES_6PL, false, false, maxPl, opt_breakClumps, scen, opts);
                PORTS_TYPES_MAINLAND = FOUR_ISL_PORT_TYPE_6PL;
                PORT_LOC_FACING_MAINLAND = FOUR_ISL_PORT_EDGE_FACING_6PL;
                this.pirateHex = FOUR_ISL_PIRATE_HEX[2];
            }
            PORT_LOC_FACING_ISLANDS = null;
            PORTS_TYPES_ISLANDS = null;
        } else if (scen.equals("SC_TTD")) {
            idx = maxPl > 4 ? 2 : (maxPl > 3 ? 1 : 0);
            this.landAreasLegalNodes = new HashSet[4 + TTDESERT_LANDHEX_RANGES_SMALL[idx].length / 2];
            this.makeNewBoard_placeHexes(TTDESERT_LANDHEX_TYPE_MAIN[idx], TTDESERT_LANDHEX_COORD_MAIN[idx], false, TTDESERT_DICENUM_MAIN[idx], true, true, TTDESERT_LANDHEX_RANGES_MAIN[idx], false, false, maxPl, opt_breakClumps, scen, opts);
            int[] desertLandHexCoords = TTDESERT_LANDHEX_COORD_DESERT[idx];
            int[] desertDiceNum = new int[desertLandHexCoords.length];
            desertLandhexType = new int[desertLandHexCoords.length];
            Arrays.fill((int[])desertLandhexType, 6);
            this.makeNewBoard_placeHexes((int[])desertLandhexType, desertLandHexCoords, true, desertDiceNum, false, false, 3, false, true, maxPl, null, scen, opts);
            this.setBonusExcludeLandArea(3);
            this.makeNewBoard_placeHexes(TTDESERT_LANDHEX_TYPE_SMALL[idx], TTDESERT_LANDHEX_COORD_SMALL[idx], false, TTDESERT_DICENUM_SMALL[idx], true, true, TTDESERT_LANDHEX_RANGES_SMALL[idx], false, false, maxPl, null, scen, opts);
            this.pirateHex = TTDESERT_PIRATE_HEX[idx];
            PORTS_TYPES_MAINLAND = TTDESERT_PORT_TYPE[idx];
            PORTS_TYPES_ISLANDS = null;
            PORT_LOC_FACING_MAINLAND = TTDESERT_PORT_EDGE_FACING[idx];
            PORT_LOC_FACING_ISLANDS = null;
        } else if (scen.equals("SC_PIRI")) {
            this.landAreasLegalNodes = new HashSet[2];
            idx = maxPl > 4 ? 1 : 0;
            this.makeNewBoard_placeHexes(PIR_ISL_LANDHEX_TYPE_MAIN[idx], PIR_ISL_LANDHEX_COORD_MAIN[idx], false, PIR_ISL_DICENUM_MAIN[idx], false, false, 1, false, false, maxPl, opt_breakClumps, scen, opts);
            this.makeNewBoard_placeHexes(PIR_ISL_LANDHEX_TYPE_PIRI[idx], PIR_ISL_LANDHEX_COORD_PIRI[idx], false, PIR_ISL_DICENUM_PIRI[idx], false, false, 0, false, false, maxPl, opt_breakClumps, scen, opts);
            this.pirateHex = PIR_ISL_PIRATE_HEX[idx];
            PORTS_TYPES_MAINLAND = PIR_ISL_PORT_TYPE[idx];
            PORTS_TYPES_ISLANDS = null;
            PORT_LOC_FACING_MAINLAND = PIR_ISL_PORT_EDGE_FACING[idx];
            PORT_LOC_FACING_ISLANDS = null;
            this.setAddedLayoutPart("PP", PIR_ISL_PPATH[idx]);
        } else if (scen.equals("SC_FTRI")) {
            this.landAreasLegalNodes = new HashSet[2];
            idx = maxPl > 4 ? 1 : 0;
            this.makeNewBoard_placeHexes(FOR_TRI_LANDHEX_TYPE_MAIN[idx], FOR_TRI_LANDHEX_COORD_MAIN[idx], false, FOR_TRI_DICENUM_MAIN[idx], true, true, 1, false, false, maxPl, opt_breakClumps, scen, opts);
            this.makeNewBoard_placeHexes(FOR_TRI_LANDHEX_TYPE_ISL[idx], FOR_TRI_LANDHEX_COORD_ISL[idx], true, null, false, false, 0, false, false, maxPl, null, scen, opts);
            this.pirateHex = FOR_TRI_PIRATE_HEX[idx];
            this.setRobberExcludedLandAreas(new int[]{0});
            if (maxPl > 4) {
                PORTS_TYPES_MAINLAND = FOR_TRI_PORT_TYPE[idx];
                PORTS_TYPES_ISLANDS = null;
                PORT_LOC_FACING_MAINLAND = FOR_TRI_PORT_EDGE_FACING[idx];
                PORT_LOC_FACING_ISLANDS = null;
            } else {
                PORTS_TYPES_MAINLAND = null;
                PORTS_TYPES_ISLANDS = FOR_TRI_PORT_TYPE[idx];
                PORT_LOC_FACING_MAINLAND = null;
                PORT_LOC_FACING_ISLANDS = FOR_TRI_PORT_EDGE_FACING[idx];
            }
            this.setAddedLayoutPart("CE", FOR_TRI_DEV_CARD_EDGES[idx]);
            this.setAddedLayoutPart("VE", FOR_TRI_SVP_EDGES[idx]);
        } else if (scen.equals("SC_CLVI")) {
            this.landAreasLegalNodes = new HashSet[2];
            idx = maxPl > 4 ? 1 : 0;
            this.makeNewBoard_placeHexes(CLVI_LANDHEX_TYPE_MAIN[idx], CLVI_LANDHEX_COORD_MAIN[idx], false, CLVI_DICENUM_MAIN[idx], true, true, 1, false, false, maxPl, opt_breakClumps, scen, opts);
            this.makeNewBoard_placeHexes(CLVI_LANDHEX_TYPE_ISL[idx], CLVI_LANDHEX_COORD_ISL[idx], false, null, false, false, 0, false, false, maxPl, null, scen, opts);
            this.setRobberHex(CLVI_ROBBER_HEX[idx], false);
            this.pirateHex = CLVI_PIRATE_HEX[idx];
            this.setRobberExcludedLandAreas(new int[]{0});
            if (maxPl > 4) {
                PORTS_TYPES_MAINLAND = CLVI_PORT_TYPE[idx];
                PORTS_TYPES_ISLANDS = null;
                PORT_LOC_FACING_MAINLAND = CLVI_PORT_EDGE_FACING[idx];
                PORT_LOC_FACING_ISLANDS = null;
            } else {
                PORTS_TYPES_MAINLAND = null;
                PORTS_TYPES_ISLANDS = CLVI_PORT_TYPE[idx];
                PORT_LOC_FACING_MAINLAND = null;
                PORT_LOC_FACING_ISLANDS = CLVI_PORT_EDGE_FACING[idx];
            }
            int[] cl = CLVI_CLOTH_VILLAGE_AMOUNTS_NODES_DICE[idx];
            this.setVillageAndClothLayout(cl);
            this.setAddedLayoutPart("CV", cl);
        } else if (scen.equals("SC_WOND")) {
            this.landAreasLegalNodes = new HashSet[3];
            idx = maxPl > 4 ? 1 : 0;
            this.makeNewBoard_placeHexes(WOND_LANDHEX_TYPE_MAIN[idx], WOND_LANDHEX_COORD_MAIN[idx], false, WOND_DICENUM_MAIN[idx], true, true, 1, false, false, maxPl, opt_breakClumps, scen, opts);
            int[] desert = new int[WOND_LANDHEX_COORD_DESERT[idx].length];
            Arrays.fill(desert, 6);
            this.makeNewBoard_placeHexes(desert, WOND_LANDHEX_COORD_DESERT[idx], true, null, false, false, 1, true, false, maxPl, null, scen, opts);
            this.makeNewBoard_placeHexes(WOND_LANDHEX_TYPE_ISL[idx], WOND_LANDHEX_COORD_ISL[idx], false, WOND_DICENUM_ISL[idx], false, false, 2, false, false, maxPl, null, scen, opts);
            this.pirateHex = 0;
            PORTS_TYPES_MAINLAND = WOND_PORT_TYPE[idx];
            PORTS_TYPES_ISLANDS = null;
            PORT_LOC_FACING_MAINLAND = WOND_PORT_EDGE_FACING[idx];
            PORT_LOC_FACING_ISLANDS = null;
            for (int i2 = 0; i2 <= 2; ++i2) {
                this.makeNewBoard_removeLegalNodes(WOND_SPECIAL_NODES[idx][i2], this.startingLandArea, i2 + 1, i2 == 2);
            }
        } else if (hasScenarioFog) {
            this.landAreasLegalNodes = new HashSet[maxPl == 6 ? 4 : 3];
            if (maxPl < 4) {
                this.makeNewBoard_placeHexes(FOG_ISL_LANDHEX_TYPE_MAIN_3PL, FOG_ISL_LANDHEX_COORD_MAIN_3PL, false, FOG_ISL_DICENUM_MAIN_3PL, true, true, 1, false, false, maxPl, opt_breakClumps, scen, opts);
                this.makeNewBoard_placeHexes(FOG_ISL_LANDHEX_TYPE_FOG, FOG_ISL_LANDHEX_COORD_FOG_3PL, false, FOG_ISL_DICENUM_FOG_3PL, true, true, 2, false, false, maxPl, null, scen, opts);
                PORTS_TYPES_MAINLAND = FOG_ISL_PORT_TYPE_3PL;
                PORT_LOC_FACING_MAINLAND = FOG_ISL_PORT_EDGE_FACING_3PL;
                idx = 0;
            } else if (maxPl == 4) {
                this.makeNewBoard_placeHexes(FOG_ISL_LANDHEX_TYPE_MAIN_4PL, FOG_ISL_LANDHEX_COORD_MAIN_4PL, false, FOG_ISL_DICENUM_MAIN_4PL, true, true, 1, false, false, maxPl, opt_breakClumps, scen, opts);
                this.makeNewBoard_placeHexes(FOG_ISL_LANDHEX_TYPE_FOG, FOG_ISL_LANDHEX_COORD_FOG_4PL, false, FOG_ISL_DICENUM_FOG_4PL, true, true, 2, false, false, maxPl, null, scen, opts);
                PORTS_TYPES_MAINLAND = FOG_ISL_PORT_TYPE_4PL;
                PORT_LOC_FACING_MAINLAND = FOG_ISL_PORT_EDGE_FACING_4PL;
                idx = 1;
            } else {
                this.makeNewBoard_placeHexes(FOG_ISL_LANDHEX_TYPE_MAIN_6PL, FOG_ISL_LANDHEX_COORD_MAIN_6PL, true, FOG_ISL_DICENUM_MAIN_6PL, true, true, 1, false, false, maxPl, opt_breakClumps, scen, opts);
                this.makeNewBoard_placeHexes(FOG_ISL_LANDHEX_TYPE_GC, FOG_ISL_LANDHEX_COORD_GC, false, FOG_ISL_DICENUM_GC, false, false, 3, false, false, maxPl, null, scen, opts);
                this.makeNewBoard_placeHexes(FOG_ISL_LANDHEX_TYPE_FOG_6PL, FOG_ISL_LANDHEX_COORD_FOG_6PL, false, FOG_ISL_DICENUM_FOG_6PL, true, true, 2, false, true, maxPl, opt_breakClumps, scen, opts);
                PORTS_TYPES_MAINLAND = FOG_ISL_PORT_TYPE_6PL;
                PORT_LOC_FACING_MAINLAND = FOG_ISL_PORT_EDGE_FACING_6PL;
                idx = 2;
            }
            PORTS_TYPES_ISLANDS = null;
            PORT_LOC_FACING_ISLANDS = null;
            if (idx < 2) {
                this.setRobberHex(FOG_ISL_ROBBER_HEX[idx], false);
            }
            this.pirateHex = FOG_ISL_PIRATE_HEX[idx];
        } else if (scen.equals("SC_NSHO")) {
            this.landAreasLegalNodes = new HashSet[maxPl == 6 ? 8 : 5];
            idx = maxPl == 6 ? 2 : (maxPl == 4 ? 1 : 0);
            this.makeNewBoard_placeHexes(NSHO_LANDHEX_TYPE_MAIN[idx], NSHO_LANDHEX_COORD_MAIN[idx], maxPl == 4, NSHO_DICENUM_MAIN[idx], maxPl < 4, true, 1, false, false, maxPl, opt_breakClumps, scen, opts);
            this.makeNewBoard_placeHexes(NSHO_LANDHEX_TYPE_ISL[idx], NSHO_LANDHEX_COORD_ISL[idx], false, NSHO_DICENUM_ISL[idx], true, true, NSHO_LANDHEX_LANDAREA_RANGES[idx], false, false, maxPl, null, scen, opts);
            if (maxPl < 4) {
                this.setRobberHex(773, false);
            }
            this.pirateHex = NSHO_PIRATE_HEX[idx];
            PORTS_TYPES_MAINLAND = NSHO_PORT_TYPE[idx];
            PORTS_TYPES_ISLANDS = null;
            PORT_LOC_FACING_MAINLAND = NSHO_PORT_EDGE_FACING[idx];
            PORT_LOC_FACING_ISLANDS = null;
        } else {
            this.landAreasLegalNodes = new HashSet[5];
            this.makeNewBoard_placeHexes(maxPl > 4 ? SOCBoard6p.makeNewBoard_landHexTypes_v2 : SOCBoard4p.makeNewBoard_landHexTypes_v1, maxPl > 4 ? LANDHEX_DICEPATH_MAINLAND_6PL : LANDHEX_DICEPATH_MAINLAND_4PL, true, maxPl > 4 ? SOCBoard6p.makeNewBoard_diceNums_v2 : SOCBoard4p.makeNewBoard_diceNums_v1, false, true, 1, false, false, maxPl, opt_breakClumps, scen, opts);
            this.makeNewBoard_placeHexes(maxPl > 4 ? LANDHEX_TYPE_ISLANDS_6PL : LANDHEX_TYPE_ISLANDS_4PL, maxPl > 4 ? LANDHEX_COORD_ISLANDS_ALL_6PL : LANDHEX_COORD_ISLANDS_ALL_4PL, false, maxPl > 4 ? LANDHEX_DICENUM_ISLANDS_6PL : LANDHEX_DICENUM_ISLANDS_4PL, true, true, maxPl > 4 ? LANDHEX_LANDAREA_RANGES_ISLANDS_6PL : LANDHEX_LANDAREA_RANGES_ISLANDS_4PL, false, false, maxPl, null, scen, opts);
            PORTS_TYPES_MAINLAND = maxPl > 4 ? SOCBoard6p.PORTS_TYPE_V2 : SOCBoard4p.PORTS_TYPE_V1;
            PORTS_TYPES_ISLANDS = maxPl > 4 ? PORT_TYPE_ISLANDS_6PL : PORT_TYPE_ISLANDS_4PL;
            PORT_LOC_FACING_MAINLAND = maxPl > 4 ? PORT_EDGE_FACING_MAINLAND_6PL : PORT_EDGE_FACING_MAINLAND_4PL;
            PORT_LOC_FACING_ISLANDS = maxPl > 4 ? PORT_EDGE_FACING_ISLANDS_6PL : PORT_EDGE_FACING_ISLANDS_4PL;
        }
        this.initLegalRoadsFromLandNodes();
        this.initLegalShipEdges();
        if (this.landAreasLegalNodes != null) {
            for (int i3 = 1; i3 < this.landAreasLegalNodes.length; ++i3) {
                if (this.landAreasLegalNodes[i3] != null) continue;
                throw new IllegalStateException("inconsistent landAreasLegalNodes: null idx " + i3);
            }
        }
        if (newBoardProgressListener != null) {
            newBoardProgressListener.boardProgress(this, opts, 4);
        }
        if (hasScenarioFog) {
            int[] FOGHEXES = maxPl == 6 ? FOG_ISL_LANDHEX_COORD_FOG_6PL : (maxPl < 4 ? FOG_ISL_LANDHEX_COORD_FOG_3PL : FOG_ISL_LANDHEX_COORD_FOG_4PL);
            this.makeNewBoard_hideHexesInFog(FOGHEXES, maxPl == 6);
        } else if (null != System.getProperty(PROP_JSETTLERS_DEBUG_BOARD_FOG)) {
            int d = this.landHexLayout.size();
            int n = (int)((float)d * 0.2f);
            if (n == 0) {
                n = 1;
            }
            int[] hideCoord = new int[n];
            desertLandhexType = this.landHexLayout.iterator();
            while (desertLandhexType.hasNext()) {
                int hexcoord = (Integer)desertLandhexType.next();
                if (this.rand.nextFloat() <= (float)n / (float)d) {
                    hideCoord[hideCoord.length - n] = hexcoord;
                    if (--n == 0) break;
                }
                --d;
            }
            this.makeNewBoard_hideHexesInFog(hideCoord, false);
        }
        if (PORTS_TYPES_MAINLAND == null && PORTS_TYPES_ISLANDS == null) {
            return;
        }
        if (PORTS_TYPES_MAINLAND != null) {
            this.makeNewBoard_checkPortLocationsConsistent(PORT_LOC_FACING_MAINLAND);
        }
        if (PORT_LOC_FACING_ISLANDS != null) {
            this.makeNewBoard_checkPortLocationsConsistent(PORT_LOC_FACING_ISLANDS);
        }
        if (PORTS_TYPES_MAINLAND != null) {
            int ptL = PORTS_TYPES_MAINLAND.length;
            int plfL = PORT_LOC_FACING_MAINLAND.length;
            if (2 * ptL != plfL) {
                throw new IllegalArgumentException("Mismatched port-array lengths: PORT_LOC_FACING_MAINLAND (" + plfL + ") should be 2 x PORTS_TYPES_MAINLAND (" + ptL + ")");
            }
            portTypes_main = new int[ptL];
            System.arraycopy(PORTS_TYPES_MAINLAND, 0, portTypes_main, 0, ptL);
            if (maxPl == 6 || !hasScenarioFog) {
                this.makeNewBoard_shufflePorts(portTypes_main, opt_breakClumps);
            }
        } else {
            portTypes_main = null;
        }
        if (PORTS_TYPES_ISLANDS != null) {
            int ptL = PORTS_TYPES_ISLANDS.length;
            int plfL = PORT_LOC_FACING_ISLANDS.length;
            if (2 * ptL != plfL) {
                throw new IllegalArgumentException("Mismatched port-array lengths: PORT_LOC_FACING_ISLANDS (" + plfL + ") should be 2 x PORTS_TYPES_ISLANDS (" + ptL + ")");
            }
            portTypes_islands = new int[ptL];
            System.arraycopy(PORTS_TYPES_ISLANDS, 0, portTypes_islands, 0, ptL);
            this.makeNewBoard_shufflePorts(portTypes_islands, null);
        } else {
            portTypes_islands = null;
        }
        this.portsCount = pcountMain = PORTS_TYPES_MAINLAND != null ? portTypes_main.length : 0;
        if (PORTS_TYPES_ISLANDS != null) {
            this.portsCount += PORTS_TYPES_ISLANDS.length;
        }
        if (this.portsLayout == null || this.portsLayout.length != 3 * this.portsCount) {
            this.portsLayout = new int[3 * this.portsCount];
        }
        if (PORTS_TYPES_MAINLAND != null) {
            System.arraycopy(portTypes_main, 0, this.portsLayout, 0, pcountMain);
        }
        if (PORTS_TYPES_ISLANDS != null) {
            System.arraycopy(portTypes_islands, 0, this.portsLayout, pcountMain, portTypes_islands.length);
        }
        this.nodeIDtoPortType = new HashMap();
        int n = L = portTypes_main != null ? portTypes_main.length : 0;
        if (L > 0) {
            j = 0;
            for (i = 0; i < L; ++i) {
                ptype = portTypes_main[i];
                edge = PORT_LOC_FACING_MAINLAND[j];
                facing = PORT_LOC_FACING_MAINLAND[++j];
                ++j;
                nodes = this.getAdjacentNodesToEdge_arr(edge);
                this.placePort(ptype, -1, facing, nodes[0], nodes[1]);
                this.portsLayout[i + this.portsCount] = edge;
                this.portsLayout[i + 2 * this.portsCount] = facing;
            }
        }
        if (PORTS_TYPES_ISLANDS != null) {
            j = 0;
            for (i = 0; i < PORTS_TYPES_ISLANDS.length; ++i) {
                ptype = portTypes_islands[i];
                edge = PORT_LOC_FACING_ISLANDS[j];
                facing = PORT_LOC_FACING_ISLANDS[++j];
                ++j;
                nodes = this.getAdjacentNodesToEdge_arr(edge);
                this.placePort(ptype, -1, facing, nodes[0], nodes[1]);
                this.portsLayout[L + i + this.portsCount] = edge;
                this.portsLayout[L + i + 2 * this.portsCount] = facing;
            }
        }
        if (newBoardProgressListener != null) {
            newBoardProgressListener.boardProgress(this, opts, 6);
        }
    }

    private final void makeNewBoard_placeHexes(int[] landHexType, int[] landPath, boolean placeRobberDesert, int[] number, boolean shuffleDiceNumbers, boolean shuffleLandHexes, int landAreaNumber, boolean addToExistingLA, boolean nodesAreInfill, int maxPl, SOCGameOption optBC, String scen, SOCGameOptionSet opts) throws IllegalStateException, IllegalArgumentException {
        int[] pathRanges = new int[]{landAreaNumber, landPath.length};
        this.makeNewBoard_placeHexes(landHexType, landPath, placeRobberDesert, number, shuffleDiceNumbers, shuffleLandHexes, pathRanges, addToExistingLA, nodesAreInfill, maxPl, optBC, scen, opts);
    }

    private final void makeNewBoard_placeHexes(int[] landHexType, int[] landPath, boolean placeRobberDesert, int[] number, boolean shuffleDiceNumbers, boolean shuffleLandHexes, int[] landAreaPathRanges, boolean addToExistingLA, boolean nodesAreInfill, int maxPl, SOCGameOption optBC, String scen, SOCGameOptionSet opts) throws IllegalStateException, IllegalArgumentException {
        int i;
        int L;
        boolean placeRobber;
        boolean checkClumps = optBC != null && optBC.getBoolValue();
        int clumpSize = checkClumps ? optBC.getIntValue() : 0;
        boolean clumpsNotOK = checkClumps;
        boolean bl = placeRobber = placeRobberDesert && !"SC_PIRI".equals(scen);
        if (landHexType.length != landPath.length) {
            throw new IllegalArgumentException("length mismatch: landHexType " + landHexType.length + ", landPath " + landPath.length);
        }
        if (landAreaPathRanges == null || landAreaPathRanges.length % 2 != 0) {
            throw new IllegalArgumentException("landAreaPathRanges: uneven length");
        }
        if (landAreaPathRanges.length <= 2) {
            L = landAreaPathRanges[1];
            if (L != landPath.length) {
                throw new IllegalArgumentException("landAreaPathRanges: landarea " + landAreaPathRanges[0] + ": range length " + L + " should be " + landPath.length);
            }
        } else {
            int i2;
            L = 0;
            for (i2 = 1; i2 < landAreaPathRanges.length; i2 += 2) {
                if ((L += landAreaPathRanges[i2]) <= landPath.length) continue;
                throw new IllegalArgumentException("landAreaPathRanges: landarea " + landAreaPathRanges[i2 - 1] + ": total range length " + L + " should be " + landPath.length);
            }
            if (L < landPath.length) {
                throw new IllegalArgumentException("landAreaPathRanges: landarea " + landAreaPathRanges[i2 - 3] + ": total range length " + L + " should be " + landPath.length);
            }
        }
        int iterRemain = 20;
        do {
            int idx;
            int i3;
            int j;
            if (shuffleLandHexes) {
                for (j = 0; j < 10; ++j) {
                    for (i3 = 0; i3 < landHexType.length; ++i3) {
                        idx = Math.abs(this.rand.nextInt() % (landHexType.length - i3));
                        if (idx == i3) continue;
                        int tmp = landHexType[idx];
                        landHexType[idx] = landHexType[i3];
                        landHexType[i3] = tmp;
                    }
                }
            }
            if (shuffleDiceNumbers) {
                for (j = 0; j < 10; ++j) {
                    for (i3 = 0; i3 < number.length; ++i3) {
                        idx = Math.abs(this.rand.nextInt() % (number.length - i3));
                        if (idx == i3) continue;
                        int tmp = number[idx];
                        number[idx] = number[i3];
                        number[i3] = tmp;
                    }
                }
            }
            ArrayList<Integer> redHexes = shuffleDiceNumbers ? new ArrayList<Integer>() : null;
            int cnt = 0;
            for (int i4 = 0; i4 < landHexType.length; ++i4) {
                int r = landPath[i4] >> 8;
                int c = landPath[i4] & 0xFF;
                try {
                    this.hexLayoutLg[r][c] = landHexType[i4];
                    if (landHexType[i4] == 6) {
                        if (placeRobber) {
                            this.setRobberHex(landPath[i4], false);
                        }
                        this.numberLayoutLg[r][c] = 0;
                        continue;
                    }
                    if (landHexType[i4] == 0) {
                        this.numberLayoutLg[r][c] = 0;
                        continue;
                    }
                    if (landHexType[i4] == 8) {
                        throw new IllegalArgumentException("landHexType can't contain FOG_HEX");
                    }
                    if (number == null || cnt >= number.length) continue;
                    int diceNum = number[cnt];
                    if (diceNum < 0) {
                        throw new IllegalArgumentException("makeNewBoard_placeHexes: number[" + cnt + "] below 0: " + diceNum);
                    }
                    this.numberLayoutLg[r][c] = diceNum;
                    ++cnt;
                    if (!shuffleDiceNumbers || diceNum != 6 && diceNum != 8) continue;
                    redHexes.add(landPath[i4]);
                    continue;
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Problem placing landPath[" + i4 + "] at 0x" + Integer.toHexString(landPath[i4]) + " [" + r + "][" + c + "]: " + ex.toString(), ex);
                }
            }
            if (newBoardProgressListener != null) {
                newBoardProgressListener.hexesProgress(this, opts, 1, landPath);
            }
            if (shuffleLandHexes && checkClumps) {
                ArrayList<Integer> unvisited = new ArrayList<Integer>();
                for (i3 = 0; i3 < landPath.length; ++i3) {
                    unvisited.add(landPath[i3]);
                }
                clumpsNotOK = this.makeNewBoard_checkLandHexResourceClumps(unvisited, clumpSize);
            } else {
                clumpsNotOK = false;
            }
            if (newBoardProgressListener != null) {
                newBoardProgressListener.hexesProgress(this, opts, 2, landPath);
            }
            if (shuffleLandHexes && !clumpsNotOK) {
                this.makeNewBoard_placeHexes_arrangeGolds(landPath, landAreaPathRanges, scen);
            }
            if (shuffleDiceNumbers && !clumpsNotOK) {
                this.makeNewBoard_placeHexes_moveFrequentNumbers(landPath, redHexes, maxPl, scen);
            }
            if (newBoardProgressListener == null || clumpsNotOK) continue;
            newBoardProgressListener.hexesProgress(this, opts, 3, landPath);
        } while (clumpsNotOK && --iterRemain > 0);
        this.cachedGetLandHexCoords = null;
        for (i = 0; i < landHexType.length; ++i) {
            this.landHexLayout.add(landPath[i]);
        }
        int hexIdx = 0;
        for (i = 0; i < landAreaPathRanges.length; i += 2) {
            int landAreaNumber = landAreaPathRanges[i];
            int landAreaLength = landAreaPathRanges[i + 1];
            int nextHexIdx = hexIdx + landAreaLength;
            this.makeNewBoard_fillNodesOnLandFromHexes(landPath, hexIdx, nextHexIdx, landAreaNumber, addToExistingLA, nodesAreInfill);
            hexIdx = nextHexIdx;
        }
    }

    private final void makeNewBoard_placeHexes_arrangeGolds(int[] hexCoords, int[] landAreaPathRanges, String scen) {
        HashMap<Integer, List<Integer>> goldAdjac = new HashMap<Integer, List<Integer>>();
        for (int hex : hexCoords) {
            List<Integer> adjacLand;
            if (7 != this.getHexTypeFromCoord(hex) || (adjacLand = this.getAdjacentHexesToHex(hex, false)) == null) continue;
            goldAdjac.put(hex, adjacLand);
        }
        if (scen.equals("SC_TTD") && landAreaPathRanges != null && landAreaPathRanges[0] == 1) {
            int i;
            if (goldAdjac.size() != 1 || landAreaPathRanges.length != 4) {
                throw new IllegalArgumentException("SC_TTD: Main island should have 1 gold hex, 2 landareas");
            }
            int goldHex = (Integer)goldAdjac.keySet().toArray()[0];
            boolean foundInLA2 = false;
            for (i = landAreaPathRanges[1]; i < hexCoords.length; ++i) {
                if (hexCoords[i] != goldHex) continue;
                foundInLA2 = true;
                break;
            }
            if (!foundInLA2) {
                i = landAreaPathRanges[1] + this.rand.nextInt(landAreaPathRanges[3]);
                int nonGoldHex = hexCoords[i];
                int gr = goldHex >> 8;
                int gc = goldHex & 0xFF;
                int nr = nonGoldHex >> 8;
                int nc = nonGoldHex & 0xFF;
                this.hexLayoutLg[gr][gc] = this.hexLayoutLg[nr][nc];
                this.hexLayoutLg[nr][nc] = 7;
            }
        }
        if (goldAdjac.size() < 2) {
            return;
        }
        HashMap<Integer, List<Integer>> goldAdjacGold = new HashMap<Integer, List<Integer>>();
        int maxAdjac = 0;
        Integer maxHex = null;
        for (Integer gHex : goldAdjac.keySet()) {
            for (Integer adjHex : (List)goldAdjac.get(gHex)) {
                if (!goldAdjac.containsKey(adjHex)) continue;
                int n = this.makeNewBoard_placeHexes_arrGolds_addToAdjacList(goldAdjacGold, gHex, adjHex);
                if (n > maxAdjac) {
                    maxAdjac = n;
                    maxHex = gHex;
                }
                if ((n = this.makeNewBoard_placeHexes_arrGolds_addToAdjacList(goldAdjacGold, adjHex, gHex)) <= maxAdjac) continue;
                maxAdjac = n;
                maxHex = adjHex;
            }
        }
        if (goldAdjacGold.isEmpty()) {
            return;
        }
        HashSet<Integer> nonAdjac = new HashSet<Integer>();
        for (int hex : hexCoords) {
            int htype = this.getHexTypeFromCoord(hex);
            if (htype == 7 || htype == 0) continue;
            Integer hexInt = hex;
            boolean adjac = false;
            for (List goldAdjacList : goldAdjac.values()) {
                if (!goldAdjacList.contains(hexInt)) continue;
                adjac = true;
                break;
            }
            if (adjac) continue;
            nonAdjac.add(hexInt);
        }
        if (nonAdjac.isEmpty()) {
            return;
        }
        this.makeNewBoard_placeHexes_arrGolds_swapWithRandom(maxHex, nonAdjac, goldAdjacGold);
        while (!goldAdjacGold.isEmpty() && !nonAdjac.isEmpty()) {
            Integer oneGold = goldAdjacGold.keySet().iterator().next();
            this.makeNewBoard_placeHexes_arrGolds_swapWithRandom(oneGold, nonAdjac, goldAdjacGold);
        }
    }

    private final int makeNewBoard_placeHexes_arrGolds_addToAdjacList(HashMap<Integer, List<Integer>> goldAdjacGold, Integer hex0, Integer hex1) {
        List<Integer> al = goldAdjacGold.get(hex0);
        if (al == null) {
            al = new ArrayList<Integer>();
            goldAdjacGold.put(hex0, al);
        }
        al.add(hex1);
        return al.size();
    }

    private final void makeNewBoard_placeHexes_arrGolds_swapWithRandom(Integer goldHex, HashSet<Integer> nonAdjac, HashMap<Integer, List<Integer>> goldAdjacGold) throws IllegalArgumentException {
        List<Integer> adjacHexesToSwapped;
        int n = nonAdjac.size();
        Iterator<Integer> nai = nonAdjac.iterator();
        if (n > 1) {
            for (n = this.rand.nextInt(n); n > 0; --n) {
                nai.next();
            }
        }
        Integer nonAdjHex = nai.next();
        int gr = goldHex >> 8;
        int gc = goldHex & 0xFF;
        int nr = nonAdjHex >> 8;
        int nc = nonAdjHex & 0xFF;
        if (this.hexLayoutLg[gr][gc] != 7) {
            throw new IllegalArgumentException("goldHex coord not gold in hexLayoutLg: 0x" + Integer.toHexString(goldHex));
        }
        this.hexLayoutLg[gr][gc] = this.hexLayoutLg[nr][nc];
        this.hexLayoutLg[nr][nc] = 7;
        nonAdjac.remove(nonAdjHex);
        List<Integer> adjs = this.getAdjacentHexesToHex(nonAdjHex, false);
        if (adjs != null) {
            for (Integer ahex : adjs) {
                nonAdjac.remove(ahex);
            }
        }
        if ((adjacHexesToSwapped = goldAdjacGold.get(goldHex)) != null) {
            for (Integer ahex : adjacHexesToSwapped) {
                List<Integer> adjacToAdjac = goldAdjacGold.get(ahex);
                if (adjacToAdjac == null) continue;
                adjacToAdjac.remove(goldHex);
                if (!adjacToAdjac.isEmpty()) continue;
                goldAdjacGold.remove(ahex);
            }
        }
        goldAdjacGold.remove(goldHex);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean makeNewBoard_placeHexes_moveFrequentNumbers(int[] landPath, ArrayList<Integer> redHexes, int maxPl, String scen) throws IllegalStateException {
        if (redHexes.isEmpty()) {
            return true;
        }
        ArrayList<Integer> frequentGold = new ArrayList<Integer>();
        for (Integer n : redHexes) {
            if (this.getHexTypeFromCoord(n) != 7) continue;
            frequentGold.add(n);
        }
        if (!frequentGold.isEmpty()) {
            int iterRemain = 100;
            Iterator iterator = frequentGold.iterator();
            while (iterator.hasNext()) {
                int diceNum;
                int swapHex;
                int hex = (Integer)iterator.next();
                do {
                    swapHex = landPath[Math.abs(this.rand.nextInt()) % landPath.length];
                    diceNum = this.getNumberOnHexFromCoord(swapHex);
                } while ((swapHex == hex || diceNum == 0 || diceNum >= 6 && diceNum <= 8 || this.getHexTypeFromCoord(swapHex) == 7) && --iterRemain > 0);
                if (iterRemain == 0) break;
                int hr = hex >> 8;
                int hc = hex & 0xFF;
                int sr = swapHex >> 8;
                int sc = swapHex & 0xFF;
                this.numberLayoutLg[sr][sc] = this.numberLayoutLg[hr][hc];
                this.numberLayoutLg[hr][hc] = diceNum;
                redHexes.remove((Object)hex);
                redHexes.add(swapHex);
            }
        }
        HashSet<Integer> moveAnyRedFromHexes = this.makeNewBoard_placeHexes_moveFrequentNumbers_checkSpecialHexes(landPath, redHexes, maxPl, scen);
        ArrayList<IntTriple> swappedNums = null;
        int n = 4;
        boolean retry = false;
        do {
            void var7_12;
            int hAdjac1;
            int adjacRed;
            HashSet<Integer> otherCoastalHexes = null;
            HashSet<Integer> otherHexes = null;
            int i = 0;
            while (i < redHexes.size()) {
                IntTriple midSwap;
                int h0 = redHexes.get(i);
                List<Integer> ahex = this.getAdjacentHexesToHex(h0, false);
                if (ahex == null) {
                    redHexes.remove(i);
                    continue;
                }
                adjacRed = 0;
                hAdjac1 = 0;
                int hAdjacNext = 0;
                Iterator<Integer> ahi = ahex.iterator();
                while (ahi.hasNext()) {
                    int h = ahi.next();
                    int dnum = this.getNumberOnHexFromCoord(h);
                    if (dnum == 6 || dnum == 8) {
                        if (++adjacRed == 1) {
                            hAdjac1 = h;
                            continue;
                        }
                        hAdjacNext = h;
                        continue;
                    }
                    ahi.remove();
                }
                if (adjacRed == 0) {
                    redHexes.remove(i);
                    continue;
                }
                if (adjacRed == 1) {
                    ++i;
                    continue;
                }
                if (adjacRed > 3 || this.isHexAdjacentToHex(hAdjac1, hAdjacNext)) {
                    ++i;
                    continue;
                }
                if (adjacRed == 3) {
                    boolean clump = false;
                    for (int h : ahex) {
                        if (h == hAdjac1 || h == hAdjacNext) continue;
                        clump = this.isHexAdjacentToHex(h, hAdjac1) || this.isHexAdjacentToHex(h, hAdjacNext);
                    }
                    if (clump) {
                        ++i;
                        continue;
                    }
                }
                if (otherCoastalHexes == null) {
                    otherCoastalHexes = new HashSet();
                    otherHexes = new HashSet();
                    this.makeNewBoard_placeHexes_moveFrequentNumbers_buildArrays(landPath, redHexes, moveAnyRedFromHexes, otherCoastalHexes, otherHexes, null, null);
                }
                if ((midSwap = this.makeNewBoard_placeHexes_moveFrequentNumbers_swapOne(h0, i, redHexes, moveAnyRedFromHexes, otherCoastalHexes, otherHexes)) == null) {
                    retry = true;
                    break;
                }
                if (swappedNums == null) {
                    swappedNums = new ArrayList<IntTriple>();
                }
                swappedNums.add(midSwap);
                if (midSwap.c == 0 || (i += midSwap.c) >= 0) continue;
                i = 0;
            }
            if (redHexes.isEmpty()) {
                return true;
            }
            if (!retry) {
                for (int redIterRemain = 200; redIterRemain > 0 && !redHexes.isEmpty(); --redIterRemain) {
                    IntTriple hexnumSwap;
                    int h0 = redHexes.get(0);
                    List<Integer> ahex = this.getAdjacentHexesToHex(h0, false);
                    if (ahex == null) {
                        redHexes.remove(0);
                        continue;
                    }
                    adjacRed = 0;
                    hAdjac1 = 0;
                    for (int h : ahex) {
                        int dnum = this.getNumberOnHexFromCoord(h);
                        if (dnum != 6 && dnum != 8 || ++adjacRed != 1) continue;
                        hAdjac1 = h;
                    }
                    if (adjacRed == 0) {
                        redHexes.remove(0);
                        continue;
                    }
                    if (otherCoastalHexes == null) {
                        otherCoastalHexes = new HashSet<Integer>();
                        otherHexes = new HashSet<Integer>();
                        this.makeNewBoard_placeHexes_moveFrequentNumbers_buildArrays(landPath, redHexes, moveAnyRedFromHexes, otherCoastalHexes, otherHexes, null, null);
                    }
                    if (adjacRed > 1) {
                        hexnumSwap = this.makeNewBoard_placeHexes_moveFrequentNumbers_swapOne(h0, 0, redHexes, moveAnyRedFromHexes, otherCoastalHexes, otherHexes);
                    } else {
                        int iAdjac1 = redHexes.indexOf(hAdjac1);
                        hexnumSwap = this.makeNewBoard_placeHexes_moveFrequentNumbers_swapOne(hAdjac1, iAdjac1, redHexes, moveAnyRedFromHexes, otherCoastalHexes, otherHexes);
                    }
                    if (hexnumSwap == null) {
                        retry = true;
                        break;
                    }
                    if (swappedNums == null) {
                        swappedNums = new ArrayList();
                    }
                    swappedNums.add(hexnumSwap);
                }
                if (!redHexes.isEmpty()) {
                    retry = true;
                }
            }
            if (!retry) continue;
            if (--var7_12 <= 0) {
                return false;
            }
            int L = swappedNums != null ? swappedNums.size() : 0;
            for (int i2 = L - 1; i2 >= 0; --i2) {
                IntTriple swap = (IntTriple)swappedNums.get(i2);
                int rs = swap.b >> 8;
                int cs = swap.b & 0xFF;
                int ro = swap.a >> 8;
                int co = swap.a & 0xFF;
                int ntmp = this.numberLayoutLg[ro][co];
                this.numberLayoutLg[ro][co] = this.numberLayoutLg[rs][cs];
                this.numberLayoutLg[rs][cs] = ntmp;
            }
            redHexes.clear();
            for (int hc : landPath) {
                int r = hc >> 8;
                int c = hc & 0xFF;
                int diceNum = this.numberLayoutLg[r][c];
                if (diceNum != 6 && diceNum != 8) continue;
                redHexes.add(hc);
            }
        } while (retry);
        return true;
    }

    private final void makeNewBoard_placeHexes_moveFrequentNumbers_buildArrays(int[] landPath, ArrayList<Integer> redHexes, HashSet<Integer> ignoreHexes, HashSet<Integer> otherCoastalHexes, HashSet<Integer> otherHexes, String scen, HashSet<Integer> otherHexesForScen) throws IllegalStateException {
        boolean buildOtherHexesLessFreq_59 = scen != null && otherHexesForScen != null && scen.equals("SC_FTRI");
        for (int h : landPath) {
            int htype = this.getHexTypeFromCoord(h);
            if (htype == 0 || htype == 6 || htype == 7) continue;
            if (htype == 8) {
                throw new IllegalStateException("Don't call this after placing fog");
            }
            int dnum = this.getNumberOnHexFromCoord(h);
            if (dnum <= 0 || dnum == 6 || dnum == 8 || ignoreHexes != null && ignoreHexes.contains(h)) continue;
            if ((dnum < 5 || dnum > 9) && buildOtherHexesLessFreq_59) {
                otherHexesForScen.add(h);
            }
            List<Integer> ahex = this.getAdjacentHexesToHex(h, false);
            boolean hasAdjacentRed = false;
            if (ahex != null) {
                for (int ah : ahex) {
                    int adnum = this.getNumberOnHexFromCoord(ah);
                    if (adnum != 6 && adnum != 8 || ignoreHexes != null && ignoreHexes.contains(ah)) continue;
                    hasAdjacentRed = true;
                    break;
                }
            }
            if (hasAdjacentRed) continue;
            Integer hInt = h;
            if (this.isHexCoastline(h)) {
                otherCoastalHexes.add(hInt);
                continue;
            }
            otherHexes.add(hInt);
        }
    }

    private HashSet<Integer> makeNewBoard_placeHexes_moveFrequentNumbers_checkSpecialHexes(int[] landPath, ArrayList<Integer> redHexes, int maxPl, String scen) {
        HashSet<Integer> moveAnyRedFromHexes;
        boolean moveAnyRedFromAlso59;
        int[] moveFrom;
        if (scen.equals("SC_FTRI")) {
            moveFrom = FOR_TRI_LANDHEX_COORD_MAIN_FAR_COASTAL[maxPl == 6 ? 1 : 0];
            moveAnyRedFromAlso59 = true;
        } else if (scen.equals("SC_WOND")) {
            moveFrom = WOND_LANDHEX_COORD_MAIN_AT_DESERT[maxPl == 6 ? 1 : 0];
            moveAnyRedFromAlso59 = false;
        } else {
            moveFrom = null;
            moveAnyRedFromAlso59 = false;
        }
        if (moveFrom != null) {
            moveAnyRedFromHexes = new HashSet<Integer>(moveFrom.length);
            for (int i = 0; i < moveFrom.length; ++i) {
                moveAnyRedFromHexes.add(moveFrom[i]);
            }
        } else {
            moveAnyRedFromHexes = null;
        }
        if (moveAnyRedFromHexes == null) {
            return null;
        }
        HashSet<Integer> hexesToMove = null;
        Iterator i = moveAnyRedFromHexes.iterator();
        while (i.hasNext()) {
            int hc = (Integer)i.next();
            int dnum = this.getNumberOnHexFromCoord(hc);
            if (dnum != 6 && dnum != 8 && (!moveAnyRedFromAlso59 || dnum != 5 && dnum != 9)) continue;
            if (hexesToMove == null) {
                hexesToMove = new HashSet<Integer>();
            }
            hexesToMove.add(hc);
        }
        if (hexesToMove != null) {
            HashSet<Integer> otherCoastalHexes = new HashSet<Integer>();
            HashSet<Integer> otherHexes = new HashSet<Integer>();
            HashSet<Integer> otherHexesForScen = moveAnyRedFromAlso59 ? new HashSet<Integer>() : null;
            this.makeNewBoard_placeHexes_moveFrequentNumbers_buildArrays(landPath, redHexes, moveAnyRedFromHexes, otherCoastalHexes, otherHexes, scen, otherHexesForScen);
            Iterator iterator = hexesToMove.iterator();
            while (iterator.hasNext()) {
                IntTriple swapped;
                int hc = (Integer)iterator.next();
                int dnum = this.getNumberOnHexFromCoord(hc);
                if (moveAnyRedFromAlso59) {
                    int rhIdx = dnum == 6 || dnum == 8 ? redHexes.indexOf(hc) : -1;
                    swapped = this.makeNewBoard_placeHexes_moveFrequentNumbers_swapOne(hc, rhIdx, redHexes, moveAnyRedFromHexes, otherHexesForScen, null);
                } else {
                    swapped = this.makeNewBoard_placeHexes_moveFrequentNumbers_swapOne(hc, redHexes.indexOf(hc), redHexes, moveAnyRedFromHexes, otherCoastalHexes, otherHexes);
                }
                if (dnum != 6 && dnum != 8 || swapped == null) continue;
                redHexes.add(swapped.b);
            }
        }
        return moveAnyRedFromHexes;
    }

    private final IntTriple makeNewBoard_placeHexes_moveFrequentNumbers_swapOne(int swaphex, int swapi, ArrayList<Integer> redHexes, HashSet<Integer> ignoreHexes, HashSet<Integer> otherCoastalHexes, HashSet<Integer> otherHexes) {
        if (otherCoastalHexes.isEmpty() && (otherHexes == null || otherHexes.isEmpty())) {
            return null;
        }
        HashSet<Integer> others = otherCoastalHexes.isEmpty() ? otherHexes : otherCoastalHexes;
        int olen = others.size();
        int oi = olen == 1 ? 0 : this.rand.nextInt(olen);
        int i = 0;
        int h = 0;
        for (int hex : others) {
            if (oi == i) {
                h = hex;
                break;
            }
            ++i;
        }
        int ohex = h;
        IntTriple triple = new IntTriple(swaphex, ohex, 0);
        int rs = swaphex >> 8;
        int cs = swaphex & 0xFF;
        int ro = ohex >> 8;
        int co = ohex & 0xFF;
        int swapNum = this.numberLayoutLg[rs][cs];
        this.numberLayoutLg[rs][cs] = this.numberLayoutLg[ro][co];
        this.numberLayoutLg[ro][co] = swapNum;
        if (swapNum != 6 && swapNum != 8) {
            return triple;
        }
        others.remove(ohex);
        List<Integer> ahex = this.getAdjacentHexesToHex(ohex, false);
        if (ahex != null) {
            for (int h2 : ahex) {
                if (otherCoastalHexes.contains(h2)) {
                    otherCoastalHexes.remove(h2);
                }
                if (otherHexes == null || !otherHexes.contains(h2)) continue;
                otherHexes.remove(h2);
            }
        }
        redHexes.remove((Object)swaphex);
        ahex = this.getAdjacentHexesToHex(swaphex, false);
        if (ahex != null) {
            int idelta = 0;
            for (int h3 : ahex) {
                int dnum = this.getNumberOnHexFromCoord(h3);
                boolean hexIsRed = dnum == 6 || dnum == 8;
                boolean hasAdjacentRed = false;
                List<Integer> aahex = this.getAdjacentHexesToHex(h3, false);
                if (aahex != null) {
                    for (int aah : aahex) {
                        int aanum = this.getNumberOnHexFromCoord(aah);
                        if (aanum != 6 && aanum != 8) continue;
                        hasAdjacentRed = true;
                        break;
                    }
                }
                if (hasAdjacentRed) continue;
                Integer hInt = h3;
                if (hexIsRed) {
                    int j = redHexes.indexOf(hInt);
                    if (j == -1) continue;
                    redHexes.remove(j);
                    if (j >= swapi || swapi == -1) continue;
                    --swapi;
                    triple.c = --idelta;
                    continue;
                }
                int htype = this.getHexTypeFromCoord(h3);
                if (otherHexes == null || ignoreHexes != null && ignoreHexes.contains(hInt) || dnum <= 0 || htype == 6 || htype == 0) continue;
                if (this.isHexCoastline(h3)) {
                    if (otherCoastalHexes.contains(hInt)) continue;
                    otherCoastalHexes.add(hInt);
                    continue;
                }
                if (otherHexes.contains(hInt)) continue;
                otherHexes.add(hInt);
            }
        }
        return triple;
    }

    private final void makeNewBoard_checkPortLocationsConsistent(int[] portsLocFacing) throws IllegalArgumentException {
        String err = null;
        int i = 0;
        while (i < portsLocFacing.length) {
            int portEdge = portsLocFacing[i++];
            int portFacing = portsLocFacing[i++];
            int r = portEdge >> 8;
            int c = portEdge & 0xFF;
            if (r % 2 == 1) {
                if (portFacing != 2 && portFacing != 5) {
                    err = " facing should be E or W";
                }
            } else if (c % 2 != r / 2 % 2) {
                if (portFacing != 6 && portFacing != 3) {
                    err = " facing should be NW or SE";
                }
            } else if (portFacing != 1 && portFacing != 4) {
                err = " facing should be NE or SW";
            }
            if (err != null) {
                err = err + ", not " + portFacing;
            }
            int hex = this.getAdjacentHexToEdge(portEdge, portFacing);
            if (err == null && (hex == 0 || this.getHexTypeFromCoord(hex) == 0)) {
                err = " faces water, not land, hex 0x" + Integer.toHexString(hex);
            }
            if ((portFacing += 3) > 6) {
                portFacing -= 6;
            }
            hex = this.getAdjacentHexToEdge(portEdge, portFacing);
            if (err == null && hex != 0 && this.getHexTypeFromCoord(hex) != 0) {
                err = " covers up land hex 0x" + Integer.toHexString(hex);
            }
            if (err == null) continue;
            throw new IllegalArgumentException("Inconsistent layout: Port at index " + (i - 2) + " edge 0x" + Integer.toHexString(portEdge) + err);
        }
    }

    private void makeNewBoard_fillNodesOnLandFromHexes(int[] landHexCoords, int startIdx, int pastEndIdx, int landAreaNumber, boolean addToExistingLA, boolean nodesAreInfill) throws IllegalStateException {
        if (landAreaNumber != 0) {
            if (this.landAreasLegalNodes == null || landAreaNumber >= this.landAreasLegalNodes.length) {
                throw new IllegalStateException("landarea " + landAreaNumber + " out of range");
            }
            if (this.landAreasLegalNodes[landAreaNumber] != null) {
                if (!addToExistingLA) {
                    throw new IllegalStateException("landarea " + landAreaNumber + " already has landAreasLegalNodes");
                }
            } else {
                this.landAreasLegalNodes[landAreaNumber] = new HashSet();
            }
        }
        for (int i = startIdx; i < pastEndIdx; ++i) {
            int hex = landHexCoords[i];
            if (this.getHexTypeFromCoord(hex) == 0) continue;
            for (Integer ni : this.getAdjacentNodesToHex(hex)) {
                if (landAreaNumber != 0) {
                    if (nodesAreInfill && this.nodesOnLand.contains(ni)) continue;
                    this.landAreasLegalNodes[landAreaNumber].add(ni);
                }
                this.nodesOnLand.add(ni);
            }
        }
    }

    private final void makeNewBoard_removeLegalNodes(int[] nodeCoords, int landAreaNumber, int addNodeListNumber, boolean emptyPartAfterInitPlace) throws IllegalArgumentException {
        if (landAreaNumber <= 0) {
            throw new IllegalArgumentException("landAreaNumber: " + landAreaNumber);
        }
        if (addNodeListNumber < 0) {
            throw new IllegalArgumentException("addNodeListNumber: " + addNodeListNumber);
        }
        HashSet legals = this.landAreasLegalNodes[landAreaNumber];
        for (int node : nodeCoords) {
            legals.remove(node);
        }
        if (addNodeListNumber != 0) {
            int L;
            this.setAddedLayoutPart("N" + addNodeListNumber, nodeCoords);
            int[] partAL = this.getAddedLayoutPart("AL");
            if (partAL == null) {
                L = 0;
                partAL = new int[2];
            } else {
                L = partAL.length;
                int[] newAL = new int[L + 2];
                System.arraycopy(partAL, 0, newAL, 0, L);
                partAL = newAL;
            }
            partAL[L] = addNodeListNumber;
            partAL[L + 1] = emptyPartAfterInitPlace ? -landAreaNumber : landAreaNumber;
            this.setAddedLayoutPart("AL", partAL);
        }
    }

    protected void makeNewBoard_hideHexesInFog(int[] hexCoords, boolean nodesAreInfill) throws IllegalStateException {
        boolean debugHalfAreGold = null != System.getProperty(PROP_JSETTLERS_DEBUG_BOARD_FOG__GOLD);
        for (int i = 0; i < hexCoords.length; ++i) {
            int hexCoord = hexCoords[i];
            if (hexCoord == 0) continue;
            int r = hexCoord >> 8;
            int c = hexCoord & 0xFF;
            int hexType = this.hexLayoutLg[r][c];
            if (hexType == 8) {
                throw new IllegalStateException("Already fog: 0x" + Integer.toHexString(hexCoord));
            }
            if (debugHalfAreGold && hexType != 0 && this.rand.nextBoolean()) {
                hexType = 7;
            }
            this.fogHiddenHexes.put(hexCoord, hexType << 8 | this.numberLayoutLg[r][c] & 0xFF);
            this.hexLayoutLg[r][c] = 8;
            this.numberLayoutLg[r][c] = 0;
            if (hexType != 0 || !this.landHexLayout.contains(hexCoord)) continue;
            this.legalRoadEdges.addAll(this.getAdjacentEdgesToHex(hexCoord));
            List<Integer> cornerNodes = this.getAdjacentNodesToHex(hexCoord);
            if (this.landAreasLegalNodes != null) {
                int node;
                int lan = 0;
                Iterator<Integer> iterator = cornerNodes.iterator();
                while (iterator.hasNext() && (lan = this.getNodeLandArea(node = iterator.next().intValue())) == 0) {
                }
                if (lan != 0 && this.landAreasLegalNodes[lan] != null) {
                    if (!nodesAreInfill) {
                        this.landAreasLegalNodes[lan].addAll(cornerNodes);
                    } else {
                        for (Integer nodeInt : cornerNodes) {
                            if (this.nodesOnLand.contains(nodeInt) || 0 != this.getNodeLandArea(nodeInt)) continue;
                            this.landAreasLegalNodes[lan].add(nodeInt);
                        }
                    }
                }
            }
            this.nodesOnLand.addAll(cornerNodes);
        }
        if (newBoardProgressListener != null) {
            newBoardProgressListener.boardProgress(this, null, 5);
        }
    }

    private static IntPair getBoardSize(SOCGameOptionSet gameOpts, int maxPlayers) {
        SOCGameOption opt;
        int heightWidth = 0;
        SOCGameOption sOCGameOption = opt = gameOpts != null ? gameOpts.get("PL") : null;
        int maxPl = opt == null || maxPlayers == 6 ? maxPlayers : (opt.getIntValue() > 4 ? 6 : opt.getIntValue());
        SOCGameOption scOpt = null;
        if (gameOpts != null) {
            scOpt = gameOpts.get("SC");
        }
        if (scOpt != null) {
            String sc = scOpt.getStringValue();
            if (sc.equals("SC_4ISL")) {
                heightWidth = FOUR_ISL_BOARDSIZE[maxPl == 6 ? 1 : 0];
            } else if (sc.equals("SC_FOG")) {
                heightWidth = FOG_ISL_BOARDSIZE[maxPl == 6 ? 1 : 0];
            } else if (sc.equals("SC_TTD")) {
                heightWidth = TTDESERT_BOARDSIZE[maxPl == 6 ? 2 : (maxPl == 4 ? 1 : 0)];
            } else if (sc.equals("SC_PIRI")) {
                heightWidth = PIR_ISL_BOARDSIZE[maxPl == 6 ? 1 : 0];
            } else if (sc.equals("SC_FTRI")) {
                heightWidth = FOR_TRI_BOARDSIZE[maxPl == 6 ? 1 : 0];
            } else if (sc.equals("SC_CLVI")) {
                heightWidth = CLVI_BOARDSIZE[maxPl == 6 ? 1 : 0];
            } else if (sc.equals("SC_WOND")) {
                heightWidth = WOND_BOARDSIZE[maxPl == 6 ? 1 : 0];
            } else if (sc.equals("SC_NSHO")) {
                heightWidth = NSHO_BOARDSIZE[maxPl == 6 ? 2 : (maxPl == 4 ? 1 : 0)];
            }
        }
        if (heightWidth == 0) {
            heightWidth = FALLBACK_BOARDSIZE[maxPl == 6 ? 1 : 0];
        }
        int bH = heightWidth >> 8;
        int bW = heightWidth & 0xFF;
        return new IntPair(bH, bW);
    }

    private static int[] getBoardShift(SOCGameOptionSet gameOpts) {
        String ostr;
        int maxPl;
        SOCGameOption opt;
        SOCGameOption sOCGameOption = opt = gameOpts != null ? gameOpts.get("PLB") : null;
        if (opt != null && opt.getBoolValue()) {
            maxPl = 6;
        } else {
            SOCGameOption sOCGameOption2 = opt = gameOpts != null ? gameOpts.get("PL") : null;
            maxPl = opt == null ? 4 : (opt.getIntValue() > 4 ? 6 : opt.getIntValue());
        }
        SOCGameOption sOCGameOption3 = opt = gameOpts != null ? gameOpts.get("SC") : null;
        String scen = opt != null ? ((ostr = opt.getStringValue()) != null ? ostr : "") : "";
        int[][] boardVS = null;
        if (scen.length() == 0) {
            boardVS = FALLBACK_VIS_SHIFT;
        } else if (scen.equals("SC_NSHO")) {
            boardVS = NSHO_VIS_SHIFT;
        } else if (scen.equals("SC_4ISL")) {
            boardVS = FOUR_ISL_VIS_SHIFT;
        } else {
            if (scen.equals("SC_PIRI")) {
                return PIR_ISL_VIS_SHIFT;
            }
            if (scen.equals("SC_TTD")) {
                boardVS = TTDESERT_VIS_SHIFT;
            } else if (scen.equals("SC_FTRI")) {
                boardVS = FOR_TRI_VIS_SHIFT;
            } else if (scen.equals("SC_CLVI")) {
                boardVS = CLVI_VIS_SHIFT;
            } else if (scen.equals("SC_WOND")) {
                boardVS = WOND_VIS_SHIFT;
            } else if (gameOpts != null && (opt = gameOpts.get("_SC_FOG")) != null && opt.getBoolValue()) {
                boardVS = FOG_ISL_VIS_SHIFT;
            }
        }
        if (boardVS == null) {
            return null;
        }
        int idx = boardVS.length == 2 ? (maxPl > 4 ? 1 : 0) : (maxPl > 4 ? 2 : (maxPl > 3 ? 1 : 0));
        return boardVS[idx];
    }

    public static final int[][] getLegalSeaEdges(SOCGame ga) {
        if (!ga.hasSeaBoard || !ga.isGameOptionSet("_SC_PIRI")) {
            return null;
        }
        int[][] LEGAL_SEA_EDGES = PIR_ISL_SEA_EDGES[ga.maxPlayers > 4 ? 1 : 0];
        int[][] lseArranged = new int[ga.maxPlayers][];
        int i = 0;
        for (int pn = 0; pn < ga.maxPlayers; ++pn) {
            if (ga.isSeatVacant(pn)) {
                lseArranged[pn] = new int[0];
                continue;
            }
            lseArranged[pn] = LEGAL_SEA_EDGES[i];
            ++i;
        }
        return lseArranged;
    }

    public static int[][] startGame_scenarioSetup(SOCGame ga) {
        if (!ga.hasSeaBoard) {
            return null;
        }
        int[][] legalSeaEdges = SOCBoardAtServer.getLegalSeaEdges(ga);
        if (legalSeaEdges != null) {
            for (int pn = 0; pn < ga.maxPlayers; ++pn) {
                ga.getPlayer(pn).setRestrictedLegalShips(legalSeaEdges[pn]);
            }
        }
        if (ga.isGameOptionSet("_SC_FTRI") || ga.isGameOptionSet("_SC_PIRI")) {
            ((SOCBoardAtServer)ga.getBoard()).startGame_putInitPieces(ga);
        }
        return legalSeaEdges;
    }

    public void startGame_putInitPieces(SOCGame ga) {
        if (ga.isGameOptionSet("_SC_FTRI")) {
            int cpn = ga.getCurrentPlayerNumber();
            ga.setCurrentPlayerNumber(-1);
            this.drawStack = new Stack();
            int n = FOR_TRI_DEV_CARD_EDGES[ga.maxPlayers > 4 ? 1 : 0].length;
            for (int i = 0; i < n; ++i) {
                this.drawStack.push(ga.buyDevCard());
            }
            ga.setCurrentPlayerNumber(cpn);
            return;
        }
        if (!ga.isGameOptionSet("_SC_PIRI")) {
            return;
        }
        int gstate = ga.getGameState();
        ga.setGameState(1);
        int[] inits = PIR_ISL_INIT_PIECES[ga.maxPlayers > 4 ? 1 : 0];
        int[] possiLoneSettles = new int[ga.maxPlayers];
        int i = 0;
        for (int pn = 0; pn < ga.maxPlayers; ++pn) {
            if (ga.isSeatVacant(pn)) continue;
            SOCPlayer pl = ga.getPlayer(pn);
            ga.putPiece(new SOCSettlement(pl, inits[i], (SOCBoard)this));
            ga.putPiece(new SOCShip(pl, inits[++i], (SOCBoard)this));
            ga.putPiece(new SOCFortress(pl, inits[++i], (SOCBoard)this));
            possiLoneSettles[pn] = inits[++i];
            ga.getPlayer(pn).addLegalSettlement(inits[i], false);
            ++i;
        }
        this.setAddedLayoutPart("LS", possiLoneSettles);
        ga.setGameState(gstate);
    }

    static {
        FALLBACK_BOARDSIZE = new int[]{5141, 5655};
        FALLBACK_VIS_SHIFT = new int[][]{{-2, 1, 3, 0}, {-2, 0, 2, 0}};
        PORT_EDGE_FACING_MAINLAND_4PL = new int[]{516, 3, 519, 4, 1034, 4, 1804, 5, 2570, 6, 3079, 6, 3076, 1, 2307, 2, 1283, 2};
        PORT_EDGE_FACING_ISLANDS_4PL = new int[]{2063, 6, 3088, 4, 4109, 6, 4103, 3};
        PORT_TYPE_ISLANDS_4PL = new int[]{0, 3, 4, 5};
        LANDHEX_DICEPATH_MAINLAND_4PL = new int[]{773, 775, 777, 1290, 1803, 2314, 2825, 2823, 2821, 2308, 1795, 1284, 1286, 1288, 1801, 2312, 2310, 1797, 1799};
        LANDHEX_COORD_ISLANDS_ALL_4PL = new int[]{783, 1294, 1296, 1807, 1809, 3342, 3344, 3346, 3853, 3855, 3843, 3845, 4358, 4360};
        LANDHEX_COORD_ISLANDS_EACH = new int[][]{{783, 1294, 1296, 1807, 1809}, {3342, 3344, 3346, 3853, 3855}, {3843, 3845, 4358, 4360}};
        LANDHEX_LANDAREA_RANGES_ISLANDS_4PL = new int[]{2, 5, 3, 5, 4, 4};
        LANDHEX_TYPE_ISLANDS_4PL = new int[]{1, 1, 2, 2, 2, 3, 3, 4, 4, 6, 5, 5, 7, 7};
        LANDHEX_DICENUM_ISLANDS_4PL = new int[]{5, 4, 6, 3, 8, 10, 9, 11, 5, 9, 4, 10, 5};
        LANDHEX_DICEPATH_MAINLAND_6PL = new int[]{2308, 1797, 1286, 775, 777, 779, 1292, 1805, 2318, 2829, 3340, 3851, 3849, 3847, 3334, 2821, 2310, 1799, 1288, 1290, 1803, 2316, 2827, 3338, 3336, 2823, 2312, 1801, 2314, 2825};
        PORT_EDGE_FACING_MAINLAND_6PL = new int[]{1796, 2, 1029, 3, 520, 3, 523, 4, 1549, 4, 2319, 5, 3085, 6, 4107, 6, 4104, 1, 3589, 1, 2820, 2};
        LANDHEX_COORD_ISLANDS_ALL_6PL = new int[]{785, 787, 1296, 1298, 1300, 1809, 1811, 2324, 3344, 3346, 3348, 3855, 3857, 3859, 4370, 4372, 4869, 4871, 4873, 4875, 4877};
        LANDHEX_LANDAREA_RANGES_ISLANDS_6PL = new int[]{2, 8, 3, 8, 4, 5};
        LANDHEX_TYPE_ISLANDS_6PL = new int[]{1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 6, 5, 5, 5, 7, 7};
        LANDHEX_DICENUM_ISLANDS_6PL = new int[]{3, 3, 4, 4, 5, 5, 5, 6, 6, 6, 8, 8, 8, 9, 9, 9, 10, 10, 11, 11};
        PORT_EDGE_FACING_ISLANDS_6PL = new int[]{2066, 1, 784, 2, 3090, 4, 4112, 1, 4617, 4};
        PORT_TYPE_ISLANDS_6PL = new int[]{0, 0, 1, 5, 0};
        NSHO_BOARDSIZE = new int[]{4623, 4625, 4630};
        NSHO_VIS_SHIFT = new int[][]{{-2, 0, 1, 0}, {-2, 1}, {-1, 0}};
        NSHO_PIRATE_HEX = new int[]{2318, 2320, 0};
        NSHO_LANDHEX_TYPE_MAIN = new int[][]{{1, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5}, SOCBoard4p.makeNewBoard_landHexTypes_v1, SOCBoard6p.makeNewBoard_landHexTypes_v2};
        NSHO_LANDHEX_COORD_MAIN = new int[][]{{2819, 2308, 1797, 1799, 2312, 2825, 3336, 3847, 3845, 3332, 2821, 2310, 2823, 3334}, {1797, 1799, 1801, 2314, 2827, 3338, 3849, 3847, 3845, 3332, 2819, 2308, 2310, 2312, 2825, 3336, 3334, 2821, 2823}, {2310, 1799, 1288, 777, 779, 781, 1294, 1807, 2320, 2831, 3342, 3853, 3851, 3849, 3336, 2823, 2312, 1801, 1290, 1292, 1805, 2318, 2829, 3340, 3338, 2825, 2314, 1803, 2316, 2827}};
        NSHO_DICENUM_MAIN = new int[][]{{2, 3, 4, 5, 5, 6, 6, 8, 8, 9, 10, 10, 11, 11}, SOCBoard4p.makeNewBoard_diceNums_v1, SOCBoard6p.makeNewBoard_diceNums_v2};
        NSHO_PORT_EDGE_FACING = new int[][]{{1796, 2, 1800, 5, 2569, 4, 3848, 5, 4102, 1, 3844, 2, 3074, 1, 2562, 3}, {1540, 3, 1543, 4, 2058, 4, 2828, 5, 3594, 6, 4103, 6, 4100, 1, 3331, 2, 2307, 2}, {523, 4, 1038, 4, 1808, 5, 2576, 6, 3343, 5, 4109, 6, 4106, 1, 3591, 1, 2565, 1, 1798, 2, 1031, 3}};
        NSHO_PORT_TYPE = new int[][]{{0, 0, 0, 1, 2, 3, 4, 5}, SOCBoard4p.PORTS_TYPE_V1, SOCBoard6p.PORTS_TYPE_V2};
        NSHO_LANDHEX_TYPE_ISL = new int[][]{{1, 1, 2, 2, 3, 4, 7, 7}, {1, 1, 2, 2, 3, 4, 5, 7, 7}, {1, 1, 2, 2, 3, 4, 5, 7, 7, 7}};
        NSHO_LANDHEX_LANDAREA_RANGES = new int[][]{{2, 2, 3, 4, 4, 2}, {2, 2, 3, 5, 4, 2}, {2, 3, 3, 3, 4, 1, 5, 1, 6, 1, 7, 1}};
        NSHO_LANDHEX_COORD_ISL = new int[][]{{773, 775, 1290, 1292, 1803, 2316, 3340, 3851}, {773, 775, 779, 1292, 1294, 1805, 2318, 3342, 3853}, {773, 1284, 1795, 2819, 3332, 3845, 785, 1811, 2835, 3857}};
        NSHO_DICENUM_ISL = new int[][]{{3, 4, 4, 5, 8, 9, 10, 12}, {2, 3, 4, 5, 6, 8, 9, 10, 11}, {2, 3, 4, 5, 6, 8, 9, 10, 11, 12}};
        FOG_ISL_BOARDSIZE = new int[]{4626, 4632};
        FOG_ISL_VIS_SHIFT = new int[][]{{-3, 1, 2, 0}, {-2, 0, 1, 0}, {-1, 0, 1, 2}};
        FOG_ISL_ROBBER_HEX = new int[]{779, 2819};
        FOG_ISL_PIRATE_HEX = new int[]{2320, 2320, 2322};
        FOG_ISL_LANDHEX_TYPE_MAIN_3PL = new int[]{1, 1, 2, 2, 3, 3, 3, 3, 4, 4, 5, 5, 5, 5};
        FOG_ISL_LANDHEX_COORD_MAIN_3PL = new int[]{2308, 2819, 2821, 3332, 3334, 3845, 3847, 779, 1290, 1292, 1803, 1805, 2316, 2318};
        FOG_ISL_DICENUM_MAIN_3PL = new int[]{3, 4, 5, 5, 6, 6, 8, 8, 9, 9, 10, 11, 11, 12};
        FOG_ISL_PORT_EDGE_FACING_3PL = new int[]{2307, 2, 3074, 1, 3844, 2, 4102, 1, 2062, 4, 1549, 4, 780, 5, 1033, 3};
        FOG_ISL_PORT_TYPE_3PL = new int[]{0, 4, 3, 0, 2, 5, 0, 1};
        FOG_ISL_LANDHEX_TYPE_FOG = new int[]{0, 0, 1, 1, 2, 2, 3, 4, 4, 5, 7, 7};
        FOG_ISL_LANDHEX_COORD_FOG_3PL = new int[]{773, 775, 1284, 1286, 1799, 2312, 2825, 3338, 3851, 3340, 3342, 3853};
        FOG_ISL_DICENUM_FOG_3PL = new int[]{3, 3, 4, 5, 6, 8, 9, 10, 11, 12};
        FOG_ISL_LANDHEX_TYPE_MAIN_4PL = new int[]{1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5, 5};
        FOG_ISL_LANDHEX_COORD_MAIN_4PL = new int[]{1795, 2308, 2819, 2821, 3332, 3334, 3336, 3845, 3847, 3849, 779, 781, 1292, 1294, 1805, 1807, 2318};
        FOG_ISL_DICENUM_MAIN_4PL = new int[]{2, 3, 3, 4, 4, 5, 5, 6, 6, 8, 8, 9, 9, 10, 10, 11, 12};
        FOG_ISL_PORT_EDGE_FACING_4PL = new int[]{2050, 1, 3074, 1, 3844, 2, 4101, 6, 4104, 1, 2319, 5, 1551, 4, 782, 5, 524, 3};
        FOG_ISL_PORT_TYPE_4PL = new int[]{0, 1, 0, 4, 3, 5, 2, 0, 0};
        FOG_ISL_LANDHEX_COORD_FOG_4PL = new int[]{773, 1286, 1799, 2312, 775, 1288, 1801, 2314, 2827, 3340, 3853, 3342};
        FOG_ISL_DICENUM_FOG_4PL = new int[]{3, 4, 5, 6, 8, 9, 10, 11, 11, 12};
        FOG_ISL_LANDHEX_TYPE_MAIN_6PL = new int[]{1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 5, 5, 5, 5, 6};
        FOG_ISL_LANDHEX_COORD_MAIN_6PL = new int[]{773, 775, 777, 779, 781, 783, 785, 787, 1286, 1288, 1290, 1292, 1294, 1296, 1298, 1799, 1801, 1803, 1805, 1807, 1809, 2314, 2316, 2318};
        FOG_ISL_DICENUM_MAIN_6PL = new int[]{2, 3, 3, 3, 4, 4, 5, 5, 6, 6, 6, 8, 8, 8, 9, 9, 10, 10, 11, 11, 11, 12, 12};
        FOG_ISL_PORT_EDGE_FACING_6PL = new int[]{1285, 2, 2056, 1, 2572, 6, 2063, 6, 1299, 5, 530, 3, 525, 4, 520, 3, 517, 4};
        FOG_ISL_PORT_TYPE_6PL = new int[]{0, 0, 0, 0, 1, 2, 3, 4, 5};
        FOG_ISL_LANDHEX_TYPE_FOG_6PL = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 7};
        FOG_ISL_LANDHEX_COORD_FOG_6PL = new int[]{1795, 1813, 2308, 2324, 2819, 2821, 2823, 2833, 2835, 2837, 3332, 3334, 3336, 3338, 3340, 3342, 3344, 3346, 3348, 3847, 3849, 3851, 3853, 3855, 3857};
        FOG_ISL_DICENUM_FOG_6PL = new int[]{2, 2, 3, 4, 5, 5, 6, 8, 9, 9, 10, 11, 12};
        FOG_ISL_LANDHEX_TYPE_GC = new int[]{7, 7};
        FOG_ISL_LANDHEX_COORD_GC = new int[]{3845, 3859};
        FOG_ISL_DICENUM_GC = new int[]{4, 10};
        FOUR_ISL_BOARDSIZE = new int[]{4624, 4630};
        FOUR_ISL_VIS_SHIFT = new int[][]{{-3, 0, 3, 6}, {-3, 0, 3, 6}, {-2, 0, 2, 2}};
        FOUR_ISL_ROBBER_HEX = new int[]{3845, 1290};
        FOUR_ISL_PIRATE_HEX = new int[]{2312, 2318, 2306};
        FOUR_ISL_LANDHEX_TYPE_3PL = new int[]{1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5};
        FOUR_ISL_LANDHEX_COORD_3PL = new int[]{1284, 1286, 1795, 1797, 2819, 2821, 2823, 3332, 3334, 3845, 777, 779, 1290, 1292, 1801, 1803, 2827, 2829, 3338, 3340};
        FOUR_ISL_DICENUM_3PL = new int[]{2, 3, 3, 4, 4, 5, 5, 5, 6, 6, 8, 8, 9, 9, 9, 10, 10, 11, 11, 12};
        FOUR_ISL_LANDHEX_LANDAREA_RANGES_3PL = new int[]{1, 4, 2, 6, 3, 6, 4, 4};
        FOUR_ISL_PORT_EDGE_FACING_3PL = new int[]{1538, 3, 1542, 6, 2563, 4, 3074, 1, 3590, 6, 1036, 4, 2058, 1, 3081, 3, 3085, 6};
        FOUR_ISL_PORT_TYPE_3PL = new int[]{0, 2, 5, 0, 3, 0, 1, 0, 4};
        FOUR_ISL_LANDHEX_TYPE_4PL = new int[]{1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5};
        FOUR_ISL_LANDHEX_COORD_4PL = new int[]{773, 1284, 1795, 1797, 2819, 2821, 3332, 3334, 3336, 3845, 3847, 777, 779, 1288, 1290, 1292, 1801, 1803, 2312, 2827, 2829, 3340, 3851};
        FOUR_ISL_DICENUM_4PL = new int[]{2, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 8, 8, 9, 9, 9, 10, 10, 10, 11, 11, 11, 12};
        FOUR_ISL_LANDHEX_LANDAREA_RANGES_4PL = new int[]{1, 4, 2, 7, 3, 8, 4, 4};
        FOUR_ISL_PORT_EDGE_FACING_4PL = new int[]{1283, 2, 2051, 6, 3074, 1, 3078, 4, 3844, 2, 2055, 3, 1548, 6, 2572, 3, 3085, 6};
        FOUR_ISL_PORT_TYPE_4PL = new int[]{4, 0, 1, 0, 3, 0, 5, 2, 0};
        FOUR_ISL_LANDHEX_TYPE_6PL = new int[]{1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5};
        FOUR_ISL_LANDHEX_COORD_6PL = new int[]{773, 775, 1284, 1286, 1795, 1797, 779, 1290, 1292, 1801, 1803, 783, 785, 1296, 1298, 1809, 2821, 3332, 3334, 3845, 3847, 2827, 2829, 3338, 3340, 3851, 2833, 2835, 3344, 3346, 3855, 3857};
        FOUR_ISL_DICENUM_6PL = new int[]{2, 2, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 11, 11, 12, 12};
        FOUR_ISL_LANDHEX_LANDAREA_RANGES_6PL = new int[]{1, 6, 2, 5, 3, 5, 4, 5, 5, 5, 6, 6};
        FOUR_ISL_PORT_EDGE_FACING_6PL = new int[]{518, 3, 1542, 6, 2052, 1, 523, 4, 529, 4, 1551, 1, 3331, 2, 3591, 4, 3593, 1, 3347, 5, 4110, 1};
        FOUR_ISL_PORT_TYPE_6PL = new int[]{1, 2, 3, 3, 4, 5, 0, 0, 0, 0, 0};
        PIR_ISL_VIS_SHIFT = new int[]{3, -1};
        PIR_ISL_BOARDSIZE = new int[]{4114, 4118};
        PIR_ISL_PIRATE_HEX = new int[]{3338, 3338};
        PIR_ISL_LANDHEX_TYPE_MAIN = new int[][]{{4, 1, 2, 5, 5, 3, 5, 4, 1, 3, 3, 5, 3, 2, 5, 4, 1}, {3, 4, 1, 2, 1, 5, 5, 5, 3, 5, 4, 4, 2, 3, 3, 3, 1, 3, 4, 2, 1, 5, 4, 5}};
        PIR_ISL_LANDHEX_COORD_MAIN = new int[][]{{268, 270, 781, 783, 1292, 1294, 1296, 1803, 1805, 1807, 2316, 2318, 2320, 2829, 2831, 3340, 3342}, {270, 272, 274, 783, 785, 787, 1294, 1296, 1298, 1300, 1805, 1807, 1809, 1811, 2318, 2320, 2322, 2324, 2831, 2833, 2835, 3342, 3344, 3346}};
        PIR_ISL_DICENUM_MAIN = new int[][]{{4, 5, 9, 10, 3, 8, 5, 6, 9, 12, 11, 8, 9, 5, 2, 10, 4}, {5, 4, 9, 3, 10, 11, 12, 6, 4, 10, 6, 4, 5, 8, 2, 10, 3, 5, 11, 9, 8, 9, 5, 4}};
        PIR_ISL_PORT_EDGE_FACING = new int[][]{{11, 3, 13, 3, 271, 5, 784, 5, 1808, 5, 2576, 6, 3087, 6, 3596, 6}, {15, 3, 17, 3, 275, 5, 788, 5, 1812, 5, 2836, 5, 3347, 5, 3601, 1, 3599, 1}};
        PIR_ISL_PORT_TYPE = new int[][]{{0, 0, 0, 1, 2, 3, 4, 5}, {0, 0, 0, 0, 1, 2, 3, 4, 5}};
        PIR_ISL_LANDHEX_TYPE_PIRI = new int[][]{{2, 7, 4, 2, 7, 4, 2, 1, 1, 6, 6, 6, 3}, {7, 2, 7, 2, 7, 2, 7, 2, 6, 6, 6, 6, 6}};
        PIR_ISL_LANDHEX_COORD_PIRI = new int[][]{{262, 260, 1282, 3334, 3332, 2306, 1797, 771, 2819, 777, 1288, 2312, 2825}, {260, 264, 1282, 1286, 2306, 2310, 3332, 3336, 779, 1284, 1801, 2308, 2827}};
        PIR_ISL_DICENUM_PIRI = new int[][]{{6, 11, 4, 6, 3, 10, 8}, {3, 6, 11, 8, 11, 6, 3, 8}};
        PIR_ISL_PPATH = new int[][]{{3338, 3336, 2823, 2310, 1799, 1286, 775, 264, 266, 779, 1290, 1801, 2314, 2827}, {3338, 2825, 2312, 1799, 1288, 777, 266, 268, 781, 1292, 1803, 2316, 2829, 3340}};
        PIR_ISL_SEA_EDGES = new int[][][]{new int[][]{{3079, -3083, 3335, -3339, 3588, -3594}, {519, -523, 263, -267, 4, -10}, {2051, -2058, 2307, 2309, 2563, 2564}, {1539, -1546, 1283, 1285, 1027, 1028}}, new int[][]{{3076, -3085}, {516, -525}, {2051, -2060}, {1539, -1548}, {3, -12}, {3587, -3596}}};
        PIR_ISL_INIT_PIECES = new int[][]{{3084, 3083, 3588, 3591, 524, 523, 4, 7, 2059, 2058, 2563, 2053, 1547, 1546, 1027, 1541}, {3086, 3085, 3076, 3080, 526, 525, 516, 520, 2061, 2060, 2051, 2055, 1549, 1548, 1539, 1543, 13, 12, 3, 9, 3597, 3596, 3587, 3593}};
        TTDESERT_BOARDSIZE = new int[]{4623, 4626, 4632};
        TTDESERT_VIS_SHIFT = new int[][]{{-2, 0, 1, 0}, {-2, 0, 1, 2}, {-2, 0, 1, 2}};
        TTDESERT_PIRATE_HEX = new int[]{2318, 2320, 3857};
        TTDESERT_LANDHEX_TYPE_MAIN = new int[][]{{1, 1, 1, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 5, 5, 7}, {1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5, 5, 5, 7}, {1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 7}};
        TTDESERT_LANDHEX_COORD_MAIN = new int[][]{{1288, 1799, 1801, 2310, 2312, 2819, 2821, 2823, 2825, 3332, 3334, 3336, 3845, 3847, 773, 1284, 1795}, {777, 1288, 1290, 1799, 1801, 1803, 2310, 2312, 2314, 2819, 2821, 2823, 2825, 3332, 3334, 3336, 3847, 773, 1284, 1795}, {1801, 1803, 1805, 1807, 2308, 2310, 2312, 2314, 2316, 2318, 2320, 2819, 2821, 2823, 2825, 2827, 2829, 2831, 3332, 3334, 3845, 1286, 1284, 773, 775, 777, 781, 783, 785, 787}};
        TTDESERT_LANDHEX_RANGES_MAIN = new int[][]{{1, TTDESERT_LANDHEX_COORD_MAIN[0].length - 3, 2, 3}, {1, TTDESERT_LANDHEX_COORD_MAIN[1].length - 3, 2, 3}, {1, TTDESERT_LANDHEX_COORD_MAIN[2].length - 9, 2, 9}};
        TTDESERT_LANDHEX_COORD_DESERT = new int[][]{{775, 1286, 1797}, {775, 1286, 1797}, {1288, 1290, 1292, 1294, 1296}};
        TTDESERT_DICENUM_MAIN = new int[][]{{2, 3, 3, 4, 4, 4, 5, 6, 6, 6, 8, 8, 9, 9, 10, 10, 11}, {3, 3, 4, 4, 5, 5, 6, 6, 8, 8, 8, 9, 9, 10, 10, 10, 11, 11, 11, 12}, {2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 8, 8, 9, 9, 9, 10, 10, 10, 11, 11, 11, 12, 12, 12}};
        TTDESERT_PORT_EDGE_FACING = new int[][]{{1032, 4, 2569, 4, 3081, 6, 3848, 5, 4101, 6, 3844, 2, 3074, 1, 2564, 3}, {778, 5, 1547, 4, 2059, 6, 3081, 6, 3848, 5, 4102, 1, 3588, 6, 3331, 2, 2309, 2}, {3331, 2, 2562, 3, 2051, 3, 2055, 3, 1808, 5, 2576, 6, 3086, 1, 3082, 1, 3079, 6, 3590, 6, 4100, 1}};
        TTDESERT_PORT_TYPE = new int[][]{{0, 0, 0, 1, 2, 3, 4, 5}, {0, 0, 0, 0, 1, 2, 3, 4, 5}, {0, 0, 0, 0, 0, 1, 2, 3, 3, 4, 5}};
        TTDESERT_LANDHEX_TYPE_SMALL = new int[][]{{2, 2, 3, 4, 7}, {1, 2, 2, 3, 4, 4, 7}, {2, 3, 3, 4, 4, 5, 7, 7}};
        TTDESERT_LANDHEX_RANGES_SMALL = new int[][]{{4, 2, 5, 1, 6, 2}, {4, 3, 5, 2, 6, 2}, {4, 2, 5, 1, 6, 4, 7, 1}};
        TTDESERT_LANDHEX_COORD_SMALL = new int[][]{{779, 1292, 2316, 3340, 3851}, {781, 1294, 1807, 2829, 2831, 3851, 3853}, {3849, 3851, 3855, 3859, 3346, 3348, 2837, 1813}};
        TTDESERT_DICENUM_SMALL = new int[][]{{5, 5, 8, 9, 11}, {2, 3, 4, 5, 6, 9, 12}, {2, 3, 4, 8, 8, 9, 10, 11}};
        FOR_TRI_BOARDSIZE = new int[]{4628, 4632};
        FOR_TRI_VIS_SHIFT = new int[][]{{-2, 0, 2, 2}, {-2, 0, 1, 2}};
        FOR_TRI_PIRATE_HEX = new int[]{777, 783};
        FOR_TRI_LANDHEX_TYPE_MAIN = new int[][]{{1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5}, {1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5}};
        FOR_TRI_LANDHEX_COORD_MAIN = new int[][]{{1795, 1797, 1799, 1801, 1803, 1805, 2308, 2310, 2312, 2314, 2316, 2318, 2819, 2821, 2823, 2825, 2827, 2829}, {1795, 1797, 1799, 1801, 1803, 1805, 1807, 1809, 1811, 1813, 2308, 2310, 2312, 2314, 2316, 2318, 2320, 2322, 2324, 2819, 2821, 2823, 2825, 2827, 2829, 2831, 2833, 2835, 2837}};
        FOR_TRI_LANDHEX_COORD_MAIN_FAR_COASTAL = new int[][]{{1805, 2318, 2829}, {1813, 2324, 2837}};
        FOR_TRI_DICENUM_MAIN = new int[][]{{2, 3, 3, 4, 4, 5, 5, 6, 6, 8, 8, 9, 9, 10, 10, 11, 11, 12}, {2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 8, 8, 8, 9, 9, 9, 10, 10, 10, 11, 11, 11, 12}};
        FOR_TRI_PORT_EDGE_FACING = new int[][]{{516, 3, 522, 3, 1553, 4, 3089, 6, 4107, 6, 4100, 1}, {519, 4, 522, 3, 528, 3, 531, 4, 4112, 1, 4109, 6, 4102, 1, 4100, 1}};
        FOR_TRI_PORT_TYPE = new int[][]{{1, 2, 3, 4, 5, 0}, {1, 2, 3, 4, 5, 0, 0, 0}};
        FOR_TRI_LANDHEX_TYPE_ISL = new int[][]{{7, 2, 6, 2, 4, 3, 5, 7, 6, 1, 1, 6}, {7, 4, 1, 2, 6, 6, 3, 3, 7, 7, 6, 6}};
        FOR_TRI_LANDHEX_COORD_ISL = new int[][]{{773, 775, 779, 781, 783, 1809, 2833, 3855, 3853, 3851, 3847, 3845}, {773, 775, 779, 781, 785, 787, 3845, 3847, 3851, 3853, 3857, 3859}};
        FOR_TRI_SVP_EDGES = new int[][]{{517, 523, 527, 1810, 4101, 4106, 4111, 2834}, {516, 518, 523, 524, 529, 4103, 4107, 4108, 4113, 4115}};
        FOR_TRI_DEV_CARD_EDGES = new int[][]{{772, 784, 3844, 3856}, {772, 525, 788, 3844, 4106, 3860}};
        CLVI_BOARDSIZE = new int[]{4626, 4630};
        CLVI_VIS_SHIFT = new int[][]{{-2, 0, 1, 1}, {-2, -1, 1, 1}};
        CLVI_ROBBER_HEX = new int[]{1795, 1795};
        CLVI_PIRATE_HEX = new int[]{2320, 2324};
        CLVI_LANDHEX_TYPE_MAIN = new int[][]{{1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 5, 5, 5, 5}, {1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5}};
        CLVI_LANDHEX_COORD_MAIN = new int[][]{{773, 775, 777, 779, 781, 1284, 1286, 1292, 1294, 1795, 3332, 3334, 3340, 3342, 2831, 3845, 3847, 3849, 3851, 3853}, {773, 775, 777, 779, 781, 783, 785, 1284, 1286, 1296, 1298, 1795, 1811, 3332, 3334, 3344, 3346, 2819, 2835, 3845, 3847, 3849, 3851, 3853, 3855, 3857}};
        CLVI_DICENUM_MAIN = new int[][]{{2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12}, {2, 2, 3, 3, 3, 3, 4, 4, 5, 5, 6, 6, 6, 8, 8, 8, 9, 9, 10, 10, 11, 11, 11, 11, 12, 12}};
        CLVI_PORT_EDGE_FACING = new int[][]{{1283, 2, 517, 4, 522, 3, 1295, 5, 3331, 2, 4102, 1, 4107, 6, 3598, 6, 2832, 5}, {1283, 2, 517, 4, 522, 3, 526, 3, 1299, 5, 3331, 2, 4102, 1, 4105, 6, 4111, 6, 3602, 6, 2836, 5}};
        CLVI_PORT_TYPE = new int[][]{{1, 2, 3, 4, 5, 0, 0, 0, 0}, {1, 2, 3, 3, 4, 5, 0, 0, 0, 0, 0}};
        CLVI_LANDHEX_TYPE_ISL = new int[][]{{7, 6, 6, 7}, {7, 6, 6, 6, 6, 7}};
        CLVI_LANDHEX_COORD_ISL = new int[][]{{2310, 1801, 2825, 2316}, {2310, 1801, 2825, 1805, 2829, 2320}};
        CLVI_CLOTH_VILLAGE_AMOUNTS_NODES_DICE = new int[][]{{10, 5, 2054, 10, 2566, 9, 1545, 11, 2057, 8, 2569, 6, 3081, 3, 2060, 4, 2572, 5}, {10, 5, 2054, 4, 2566, 9, 1545, 2, 2057, 5, 2569, 6, 3081, 12, 1549, 10, 2061, 8, 2573, 9, 3085, 10, 2064, 4, 2576, 5}};
        WOND_BOARDSIZE = new int[]{3602, 4116};
        WOND_VIS_SHIFT = new int[][]{{4, -1, 3, 0}, {-1, -1}};
        WOND_LANDHEX_TYPE_MAIN = new int[][]{{1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5}, {1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5}};
        WOND_LANDHEX_COORD_MAIN = new int[][]{{264, 266, 270, 775, 777, 781, 1288, 1294, 1296, 1799, 1801, 1803, 1805, 1807, 2310, 2312, 2314, 2316, 2318, 2320, 2825, 3336}, {775, 777, 781, 783, 1286, 1288, 1292, 1294, 1797, 1799, 1801, 1805, 1807, 2308, 2310, 2312, 2314, 2316, 2318, 2320, 2821, 2823, 2825, 2827, 2829, 2831, 2833, 3338, 3342, 3849, 3853}};
        WOND_LANDHEX_COORD_MAIN_AT_DESERT = new int[][]{{1799, 2310}, {2308, 2821}};
        WOND_LANDHEX_COORD_DESERT = new int[][]{{1797, 2308, 2821}, {2306, 2819, 3330, 3332}};
        WOND_DICENUM_MAIN = new int[][]{{2, 3, 3, 3, 4, 4, 5, 5, 6, 6, 8, 8, 9, 9, 9, 10, 10, 10, 11, 11, 11, 12}, {2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 5, 6, 6, 8, 8, 8, 9, 9, 9, 9, 10, 10, 10, 10, 11, 11, 11, 11, 12, 12}};
        WOND_PORT_EDGE_FACING = new int[][]{{9, 3, 518, 3, 782, 5, 1030, 1, 1548, 3, 1808, 5, 2567, 1, 2570, 6, 2574, 6}, {520, 3, 526, 3, 1029, 3, 1295, 5, 1540, 3, 1808, 5, 2059, 3, 2834, 5, 3080, 1, 3084, 1, 3087, 6}};
        WOND_PORT_TYPE = new int[][]{{1, 2, 3, 4, 5, 0, 0, 0, 0}, {1, 2, 3, 3, 4, 5, 0, 0, 0, 0, 0}};
        WOND_LANDHEX_TYPE_ISL = new int[][]{{7, 5, 4, 1, 7}, {5, 7, 7, 7}};
        WOND_LANDHEX_COORD_ISL = new int[][]{{1282, 771, 260, 3340, 3342}, {1282, 771, 3857, 1298}};
        WOND_DICENUM_ISL = new int[][]{{6, 4, 5, 2, 8}, {4, 6, 8, 6}};
        WOND_SPECIAL_NODES = new int[][][]{new int[][]{{1542, 2054, 2053, 2565, 2566}, {523, 524}, {11, 522, 525, 1036}}, new int[][]{{2051, 2563, 2564, 3076, 3077}, {1034, 1035, 3595, 3596}, {522, 1033, 1036, 1547, 3083, 3594, 3597, 4108}}};
    }

    public static interface NewBoardProgressListener {
        public static final int HEXES_PLACE = 1;
        public static final int HEXES_CHECK_CLUMPS = 2;
        public static final int HEXES_MOVE_FREQ_NUMS = 3;
        public static final int ALL_HEXES_PLACED = 4;
        public static final int FOG_HIDE_HEXES = 5;
        public static final int DONE_PORTS_PLACED = 6;

        public void hexesProgress(SOCBoardAtServer var1, SOCGameOptionSet var2, int var3, int[] var4);

        public void boardProgress(SOCBoardAtServer var1, SOCGameOptionSet var2, int var3);
    }

    public static class BoardFactoryAtServer
    implements SOCBoard.BoardFactory {
        @Override
        public SOCBoard createBoard(SOCGameOptionSet gameOpts, boolean largeBoard, int maxPlayers) throws IllegalArgumentException {
            if (!largeBoard) {
                return SOCBoard.DefaultBoardFactory.staticCreateBoard(gameOpts, false, maxPlayers);
            }
            return new SOCBoardAtServer(gameOpts, maxPlayers, SOCBoardAtServer.getBoardSize(gameOpts, maxPlayers));
        }
    }
}

