/*
 * Decompiled with CFR 0.152.
 */
package soc.server;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import soc.disableDebug.D;
import soc.server.SOCChatRecentBuffer;
import soc.server.genericServer.Connection;
import soc.util.MutexFlag;

public class SOCChannelList {
    protected final Hashtable<String, MutexFlag> channelMutexes = new Hashtable();
    protected final Hashtable<String, Vector<Connection>> channelMembers = new Hashtable();
    protected final Hashtable<String, SOCChatRecentBuffer> channelChatBuffer = new Hashtable();
    protected final Hashtable<String, String> channelOwners = new Hashtable();
    protected boolean inUse = false;

    public synchronized void takeMonitor() {
        D.ebugPrintlnINFO("SOCChannelList : TAKE MONITOR");
        while (this.inUse) {
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                System.out.println("EXCEPTION IN takeMonitor() -- " + e);
            }
        }
        this.inUse = true;
    }

    public synchronized void releaseMonitor() {
        D.ebugPrintlnINFO("SOCChannelList : RELEASE MONITOR");
        this.inUse = false;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean takeMonitorForChannel(String channel) {
        D.ebugPrintlnINFO("SOCChannelList : TAKE MONITOR FOR " + channel);
        MutexFlag mutex = this.channelMutexes.get(channel);
        if (mutex == null) {
            return false;
        }
        boolean done = false;
        while (!done) {
            mutex = this.channelMutexes.get(channel);
            if (mutex == null) {
                return false;
            }
            MutexFlag mutexFlag = mutex;
            synchronized (mutexFlag) {
                if (mutex.getState()) {
                    try {
                        mutex.wait(1000L);
                    }
                    catch (InterruptedException e) {
                        System.out.println("EXCEPTION IN takeMonitor() -- " + e);
                    }
                } else {
                    done = true;
                }
            }
        }
        mutex.setState(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseMonitorForChannel(String channel) {
        D.ebugPrintlnINFO("SOCChannelList : RELEASE MONITOR FOR " + channel);
        MutexFlag mutex = this.channelMutexes.get(channel);
        if (mutex == null) {
            return false;
        }
        MutexFlag mutexFlag = mutex;
        synchronized (mutexFlag) {
            mutex.setState(false);
            mutex.notify();
        }
        return true;
    }

    public Enumeration<String> getChannels() {
        return this.channelMembers.keys();
    }

    public synchronized String getOwner(String chName) {
        return this.channelOwners.get(chName);
    }

    public SOCChatRecentBuffer getChatBuffer(String chName) {
        return this.channelChatBuffer.get(chName);
    }

    public synchronized Vector<Connection> getMembers(String chName) {
        Vector<Connection> result = this.channelMembers.get(chName);
        if (result == null) {
            result = new Vector();
        }
        return result;
    }

    public synchronized boolean isMember(Connection conn, String chName) {
        Vector<Connection> members = this.getMembers(chName);
        return members != null && members.contains(conn);
    }

    public synchronized void addMember(Connection conn, String chName) {
        Vector<Connection> members = this.getMembers(chName);
        if (members != null && !members.contains(conn)) {
            members.addElement(conn);
        }
    }

    public synchronized void removeMember(Connection conn, String chName) {
        Vector<Connection> members = this.getMembers(chName);
        if (members != null) {
            members.removeElement(conn);
        }
    }

    public synchronized void replaceMemberAllChannels(Connection oldConn, Connection newConn) {
        Enumeration<String> allCh = this.getChannels();
        while (allCh.hasMoreElements()) {
            Vector<Connection> members = this.channelMembers.get(allCh.nextElement());
            if (members == null || !members.contains(oldConn)) continue;
            members.remove(oldConn);
            members.addElement(newConn);
        }
    }

    public boolean isChannel(String chName) {
        return this.channelMembers.get(chName) != null;
    }

    public synchronized boolean isChannelEmpty(String chName) {
        Vector<Connection> members = this.channelMembers.get(chName);
        return members != null && members.isEmpty();
    }

    public synchronized void createChannel(String chName, String chOwner) throws NullPointerException {
        if (this.isChannel(chName)) {
            return;
        }
        this.channelMutexes.put(chName, new MutexFlag());
        this.channelMembers.put(chName, new Vector());
        this.channelChatBuffer.put(chName, new SOCChatRecentBuffer());
        this.channelOwners.put(chName, chOwner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteChannel(String chName) {
        D.ebugPrintlnINFO("SOCChannelList : deleteChannel(" + chName + ")");
        this.channelMembers.remove(chName);
        SOCChatRecentBuffer buf = this.channelChatBuffer.remove(chName);
        if (buf != null) {
            buf.clear();
        }
        MutexFlag mutex = this.channelMutexes.get(chName);
        this.channelMutexes.remove(chName);
        if (mutex != null) {
            MutexFlag mutexFlag = mutex;
            synchronized (mutexFlag) {
                mutex.notifyAll();
            }
        }
    }
}

