/*
 * Decompiled with CFR 0.152.
 */
package soc.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class SOCChatRecentBuffer {
    public static final int BUFFER_SIZE = 9;
    private final Entry[] buf = new Entry[9];
    private int newest = -1;

    public boolean isEmpty() {
        return this.newest == -1;
    }

    public void clear() {
        this.newest = -1;
        Arrays.fill(this.buf, null);
    }

    public List<Entry> getAll() {
        ArrayList<Entry> ret = new ArrayList<Entry>();
        if (!this.isEmpty()) {
            int i;
            for (i = this.newest + 1; i < this.buf.length; ++i) {
                if (this.buf[i] == null) continue;
                ret.add(this.buf[i]);
            }
            for (i = 0; i <= this.newest; ++i) {
                if (this.buf[i] == null) continue;
                ret.add(this.buf[i]);
            }
        }
        return ret;
    }

    public void add(String nickname, String text) throws IllegalArgumentException {
        Entry ent = new Entry(nickname, text);
        ++this.newest;
        if (this.newest >= this.buf.length) {
            this.newest = 0;
        }
        this.buf[this.newest] = ent;
    }

    public static final class Entry {
        public final String nickname;
        public final String text;

        public Entry(String nickname, String text) throws IllegalArgumentException {
            if (nickname == null || text == null) {
                throw new IllegalArgumentException("null");
            }
            this.nickname = nickname;
            this.text = text;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            if (this == o) {
                return true;
            }
            return this.nickname.equals(((Entry)o).nickname) && this.text.equals(((Entry)o).text);
        }
    }
}

