/*
 * Decompiled with CFR 0.152.
 */
package soc.server;

import java.util.Locale;
import java.util.Map;
import java.util.TimerTask;
import soc.server.SOCServer;
import soc.server.genericServer.Connection;
import soc.util.SOCFeatureSet;

public class SOCClientData {
    public static final String SENT_SCEN_STRINGS = "S";
    public static final String SENT_SCEN_INFO = "I";
    private int wins = 0;
    private int losses = 0;
    public SOCFeatureSet feats;
    public boolean hasLimitedFeats;
    public Locale locale;
    public String localeStr;
    public boolean wantsI18N;
    private int currentCreatedGames;
    private int currentCreatedChannels;
    public int faceId;
    private Object countFieldSync = new Object();
    private boolean sentGameList = false;
    public boolean sentPostAuthWelcome;
    public boolean checkedLocaleScenStrings;
    public boolean localeHasScenStrings;
    public boolean sentAllScenarioStrings;
    public boolean sentAllScenarioInfo;
    public Map<String, String> scenariosInfoSent;
    public boolean sentUnknownGameoptsInfo;
    public boolean isRobot = false;
    public boolean isBuiltInRobot;
    public String robot3rdPartyBrainClass;
    public int scenVersion;
    public long disconnectLastPingMillis;
    private SOCCDCliVersionTask cliVersionTask;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wonGame() {
        Object object = this.countFieldSync;
        synchronized (object) {
            ++this.wins;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lostGame() {
        Object object = this.countFieldSync;
        synchronized (object) {
            ++this.losses;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createdGame() {
        Object object = this.countFieldSync;
        synchronized (object) {
            ++this.currentCreatedGames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createdChannel() {
        Object object = this.countFieldSync;
        synchronized (object) {
            ++this.currentCreatedChannels;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletedGame() {
        Object object = this.countFieldSync;
        synchronized (object) {
            --this.currentCreatedGames;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletedChannel() {
        Object object = this.countFieldSync;
        synchronized (object) {
            --this.currentCreatedChannels;
        }
    }

    public int getWins() {
        return this.wins;
    }

    public int getLosses() {
        return this.losses;
    }

    public int getCurrentCreatedGames() {
        return this.currentCreatedGames;
    }

    public int getcurrentCreatedChannels() {
        return this.currentCreatedChannels;
    }

    public void copyClientPlayerStats(SOCClientData source) {
        this.wins = source.wins;
        this.losses = source.losses;
        this.currentCreatedGames = source.currentCreatedGames;
        this.currentCreatedChannels = source.currentCreatedChannels;
    }

    public boolean hasSentGameList() {
        return this.sentGameList;
    }

    public void setSentGameList() {
        this.sentGameList = true;
    }

    public final boolean localeHasGameScenarios(Connection con) {
        return this.wantsI18N && !SOCServer.i18n_scenario_SC_WOND_desc.equals(con.getLocalized("gamescen.SC_WOND.n"));
    }

    public void setVersionTimer(SOCServer sr, Connection con) {
        this.cliVersionTask = new SOCCDCliVersionTask(sr, this, con);
        sr.utilTimer.schedule((TimerTask)this.cliVersionTask, 1200L);
    }

    public void clearVersionTimer() {
        if (this.cliVersionTask != null) {
            this.cliVersionTask.cancel();
            this.cliVersionTask = null;
        }
    }

    private static class SOCCDCliVersionTask
    extends TimerTask {
        private SOCServer srv;
        private SOCClientData cliData;
        private Connection cliConn;

        public SOCCDCliVersionTask(SOCServer sr, SOCClientData cd, Connection con) {
            this.srv = sr;
            this.cliData = cd;
            this.cliConn = con;
        }

        @Override
        public void run() {
            this.cliData.cliVersionTask = null;
            if (!this.cliConn.isVersionKnown()) {
                this.srv.setClientVersSendGamesOrReject(this.cliConn, 1000, null, null, false);
            }
        }
    }
}

