/*
 * Decompiled with CFR 0.152.
 */
package soc.server;

import soc.game.SOCGame;
import soc.game.SOCPlayer;
import soc.robot.SOCRobotClient;
import soc.server.GameHandler;
import soc.server.SOCClientData;
import soc.server.SOCLocalRobotClient;
import soc.server.SOCServer;
import soc.server.genericServer.Connection;

class SOCForceEndTurnThread
extends Thread {
    private final SOCServer srv;
    private final GameHandler hand;
    private final SOCGame ga;
    private final SOCPlayer pl;

    public SOCForceEndTurnThread(SOCServer srv, GameHandler hand, SOCGame g, SOCPlayer p) {
        super("forceEndTurn-" + g.getName());
        this.setDaemon(true);
        this.srv = srv;
        this.hand = hand;
        this.ga = g;
        this.pl = p;
    }

    @Override
    public void run() {
        boolean notCurrentPlayer;
        String rname = this.pl.getName();
        int plNum = this.pl.getPlayerNumber();
        int gs = this.ga.getGameState();
        boolean bl = notCurrentPlayer = this.ga.getCurrentPlayerNumber() != plNum;
        if (notCurrentPlayer && gs != 50 && gs != 56 && gs != 14) {
            return;
        }
        Connection rconn = this.srv.getConnection(rname);
        boolean isStubborn = this.pl.isStubbornRobot();
        System.err.println("For robot " + rname + (notCurrentPlayer ? ": force discard/pick" : ": force end turn") + " in game " + this.ga.getName() + " pn=" + plNum + " state " + gs + (isStubborn ? " (stubborn)" : ""));
        if (gs == 50) {
            System.err.println("  srv resource count = " + this.pl.getResources().getTotal());
        } else if (gs == 56) {
            System.err.println("  pl's gold pick count = " + this.pl.getNeedToPickGoldHexResources());
        }
        this.pl.addForcedEndTurn();
        if (rconn == null) {
            System.err.println("L9120: internal error: can't find connection for bot " + rname);
            return;
        }
        SOCClientData scd = (SOCClientData)rconn.getAppData();
        if (scd.isBuiltInRobot) {
            SOCRobotClient rcli = SOCLocalRobotClient.robotClients.get(rname);
            if (rcli != null) {
                rcli.debugPrintBrainStatus(this.ga.getName(), !isStubborn, false);
            } else {
                System.err.println("L9397: internal error: can't find robotClient for " + rname);
            }
        } else {
            System.err.println("  Can't print brain status; robot type is " + scd.robot3rdPartyBrainClass);
        }
        this.hand.endGameTurnOrForce(this.ga, plNum, rname, rconn, false);
    }
}

