/*
 * Decompiled with CFR 0.152.
 */
package soc.server;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import soc.debug.D;
import soc.game.GameAction;
import soc.game.ResourceSet;
import soc.game.SOCBoard;
import soc.game.SOCBoardLarge;
import soc.game.SOCDevCard;
import soc.game.SOCForceEndTurnResult;
import soc.game.SOCFortress;
import soc.game.SOCGame;
import soc.game.SOCGameEvent;
import soc.game.SOCGameEventListener;
import soc.game.SOCGameOption;
import soc.game.SOCGameOptionSet;
import soc.game.SOCInventory;
import soc.game.SOCInventoryItem;
import soc.game.SOCPlayer;
import soc.game.SOCPlayerEvent;
import soc.game.SOCPlayingPiece;
import soc.game.SOCResourceSet;
import soc.game.SOCRoutePiece;
import soc.game.SOCScenario;
import soc.game.SOCSettlement;
import soc.game.SOCSpecialItem;
import soc.game.SOCTradeOffer;
import soc.game.SOCVillage;
import soc.message.SOCAcceptOffer;
import soc.message.SOCBankTrade;
import soc.message.SOCBoardLayout;
import soc.message.SOCBoardLayout2;
import soc.message.SOCBotGameDataCheck;
import soc.message.SOCBotJoinGameRequest;
import soc.message.SOCCancelBuildRequest;
import soc.message.SOCChangeFace;
import soc.message.SOCChoosePlayerRequest;
import soc.message.SOCClearOffer;
import soc.message.SOCClearTradeMsg;
import soc.message.SOCDebugFreePlace;
import soc.message.SOCDeclinePlayerRequest;
import soc.message.SOCDevCardAction;
import soc.message.SOCDevCardCount;
import soc.message.SOCDiceResult;
import soc.message.SOCDiscardRequest;
import soc.message.SOCFirstPlayer;
import soc.message.SOCGameElements;
import soc.message.SOCGameMembers;
import soc.message.SOCGameState;
import soc.message.SOCGameStats;
import soc.message.SOCGameTextMsg;
import soc.message.SOCInventoryItemAction;
import soc.message.SOCJoinGame;
import soc.message.SOCJoinGameAuth;
import soc.message.SOCKeyedMessage;
import soc.message.SOCLargestArmy;
import soc.message.SOCLastSettlement;
import soc.message.SOCLeaveGame;
import soc.message.SOCLongestRoad;
import soc.message.SOCMakeOffer;
import soc.message.SOCMessage;
import soc.message.SOCMoveRobber;
import soc.message.SOCPickResources;
import soc.message.SOCPieceValue;
import soc.message.SOCPlayerElement;
import soc.message.SOCPlayerElements;
import soc.message.SOCPlayerStats;
import soc.message.SOCPotentialSettlements;
import soc.message.SOCPutPiece;
import soc.message.SOCResetBoardReject;
import soc.message.SOCRevealFogHex;
import soc.message.SOCRobberyResult;
import soc.message.SOCRollDicePrompt;
import soc.message.SOCSVPTextMessage;
import soc.message.SOCSetLastAction;
import soc.message.SOCSetPlayedDevCard;
import soc.message.SOCSetSeatLock;
import soc.message.SOCSetSpecialItem;
import soc.message.SOCSetTurn;
import soc.message.SOCSimpleAction;
import soc.message.SOCSimpleRequest;
import soc.message.SOCSitDown;
import soc.message.SOCStartGame;
import soc.message.SOCStatusMessage;
import soc.message.SOCTurn;
import soc.message.SOCUndoNotAllowedReasonText;
import soc.server.GameHandler;
import soc.server.GameMessageHandler;
import soc.server.SOCBoardAtServer;
import soc.server.SOCChatRecentBuffer;
import soc.server.SOCClientData;
import soc.server.SOCForceEndTurnThread;
import soc.server.SOCGameMessageHandler;
import soc.server.SOCServer;
import soc.server.UnlocalizedString;
import soc.server.genericServer.Connection;
import soc.util.DataUtils;
import soc.util.IntPair;
import soc.util.SOCFeatureSet;
import soc.util.SOCStringManager;
import soc.util.Version;

public class SOCGameHandler
extends GameHandler
implements SOCGameEventListener {
    public static int ROBOT_FORCE_ENDTURN_TRADEOFFER_SECONDS = 60;
    public static boolean DESTROY_BOT_ONLY_GAMES_WHEN_OVER = true;
    private static final String DEBUG_COMMANDS_HELP_RSRCS = "rsrcs: #cl #or #sh #wh #wo player";
    private static final String DEBUG_COMMANDS_HELP_DEV = "dev: #typ player";
    private static final String DEBUG_COMMANDS_HELP_DEVNEXT = "devnext: #typ";
    private static final String DEBUG_COMMANDS_HELP_PLAYER = "'Player' is a player name or #number (upper-left is #0, increasing clockwise)";
    private static final String DEBUG_COMMANDS_HELP_DEV_TYPES = "### 1:road  2:year of plenty  3:mono  4:gov  5:market  6:univ  7:temple  8:chapel  9:soldier";
    private static final String DEBUG_CMD_FREEPLACEMENT = "*FREEPLACE*";
    private static final String DEBUG_CMD_PFX_SCENARIO = "*SCEN* ";
    private static final String[] SOC_DEBUG_COMMANDS_HELP = new String[]{"*FREEPLACE* 1 or 0  Start or end 'Free Placement' mode", "--- Debug Resources ---", "rsrcs: #cl #or #sh #wh #wo player", "Example  rsrcs: 0 3 0 2 0 Myname  or  rsrcs: 0 3 0 2 0 #3", "devnext: #typ", "dev: #typ player", "Example  dev: 2 Myname   or  dev: 2 #3", "'Player' is a player name or #number (upper-left is #0, increasing clockwise)", "Development card types are:", "1 road-building", "2 year of plenty", "3 monopoly", "4 governors house", "5 market", "6 university", "7 temple", "8 chapel", "9 robber", "--- Scenario Debugging ---", "For SC_FTRI: *scen* giveport #typenum #placeflag player"};
    public static final SOCPlayerElement.PEType[] ELEM_RESOURCES = new SOCPlayerElement.PEType[]{SOCPlayerElement.PEType.CLAY, SOCPlayerElement.PEType.ORE, SOCPlayerElement.PEType.SHEEP, SOCPlayerElement.PEType.WHEAT, SOCPlayerElement.PEType.WOOD};
    public static final SOCPlayerElement.PEType[] ELEM_RESOURCES_WITH_UNKNOWN = new SOCPlayerElement.PEType[]{SOCPlayerElement.PEType.CLAY, SOCPlayerElement.PEType.ORE, SOCPlayerElement.PEType.SHEEP, SOCPlayerElement.PEType.WHEAT, SOCPlayerElement.PEType.WOOD, SOCPlayerElement.PEType.UNKNOWN_RESOURCE};
    private static final SOCPlayerElement.PEType[] ELEM_PIECETYPES_CLASSIC = new SOCPlayerElement.PEType[]{SOCPlayerElement.PEType.ROADS, SOCPlayerElement.PEType.SETTLEMENTS, SOCPlayerElement.PEType.CITIES};
    private static final SOCPlayerElement.PEType[] ELEM_PIECETYPES_SEA = new SOCPlayerElement.PEType[]{SOCPlayerElement.PEType.ROADS, SOCPlayerElement.PEType.SETTLEMENTS, SOCPlayerElement.PEType.CITIES, SOCPlayerElement.PEType.SHIPS};
    private static final SOCPlayerElement.PEType[] ELEM_JOINGAME_WITH_PIECETYPES_CLASSIC = new SOCPlayerElement.PEType[]{SOCPlayerElement.PEType.LAST_SETTLEMENT_NODE, SOCPlayerElement.PEType.UNKNOWN_RESOURCE, SOCPlayerElement.PEType.NUMKNIGHTS, SOCPlayerElement.PEType.ROADS, SOCPlayerElement.PEType.SETTLEMENTS, SOCPlayerElement.PEType.CITIES};
    private static final SOCPlayerElement.PEType[] ELEM_JOINGAME_WITH_PIECETYPES_SEA = new SOCPlayerElement.PEType[]{SOCPlayerElement.PEType.LAST_SETTLEMENT_NODE, SOCPlayerElement.PEType.UNKNOWN_RESOURCE, SOCPlayerElement.PEType.NUMKNIGHTS, SOCPlayerElement.PEType.ROADS, SOCPlayerElement.PEType.SETTLEMENTS, SOCPlayerElement.PEType.CITIES, SOCPlayerElement.PEType.SHIPS};
    private static final SOCGameElements.GEType[] ELEM_JOINGAME_DEVCARDS_ROUNDS_PLNUMS_FIRST_LONGEST_LARGEST = new SOCGameElements.GEType[]{SOCGameElements.GEType.DEV_CARD_COUNT, SOCGameElements.GEType.ROUND_COUNT, SOCGameElements.GEType.FIRST_PLAYER, SOCGameElements.GEType.LONGEST_ROAD_PLAYER, SOCGameElements.GEType.LARGEST_ARMY_PLAYER};
    private final SOCGameMessageHandler gameMessageHandler;

    public SOCGameHandler(SOCServer server) {
        super(server);
        this.gameMessageHandler = new SOCGameMessageHandler(server, this);
    }

    @Override
    public GameMessageHandler getMessageHandler() {
        return this.gameMessageHandler;
    }

    @Override
    public boolean processDebugCommand(Connection debugCli, SOCGame ga, String dcmd, String dcmdU) {
        if (dcmdU.startsWith("RSRCS:")) {
            this.debugGiveResources(debugCli, dcmd, ga);
            return true;
        }
        if (dcmdU.startsWith("DEV:")) {
            this.debugGiveDevCard(debugCli, dcmd, ga);
            return true;
        }
        if (dcmdU.startsWith("DEVNEXT:")) {
            this.debugSetNextDevCard(debugCli, dcmd, ga);
            return true;
        }
        if (dcmd.charAt(0) != '*') {
            return false;
        }
        if (dcmdU.startsWith(DEBUG_CMD_FREEPLACEMENT)) {
            this.processDebugCommand_freePlace(debugCli, ga, dcmd.substring(DEBUG_CMD_FREEPLACEMENT.length()).trim());
            return true;
        }
        if (dcmdU.startsWith(DEBUG_CMD_PFX_SCENARIO)) {
            this.processDebugCommand_scenario(debugCli, ga, dcmd.substring(DEBUG_CMD_PFX_SCENARIO.length()).trim());
            return true;
        }
        return false;
    }

    @Override
    public final String[] getDebugCommandsHelp() {
        return SOC_DEBUG_COMMANDS_HELP;
    }

    final void processDebugCommand_freePlace(Connection c, SOCGame ga, String arg) {
        String gaName = ga.getName();
        boolean wasInitial = ga.isInitialPlacement();
        boolean ppValue = ga.isDebugFreePlacement();
        int eventPN = -258;
        boolean ppWanted = arg == null || arg.length() == 0 ? ppValue : arg.equals("1");
        if (ppValue != ppWanted) {
            if (!ppWanted) {
                try {
                    ga.setDebugFreePlacement(false);
                }
                catch (IllegalStateException e) {
                    if (wasInitial) {
                        this.srv.messageToPlayer(c, gaName, eventPN, "* To exit this debug mode, all players must have either");
                        this.srv.messageToPlayer(c, gaName, eventPN, "  1 settlement and 1 road, or all must have at least 2 of each.");
                    } else {
                        this.srv.messageToPlayer(c, gaName, eventPN, "* Could not exit this debug mode: " + e.getMessage());
                    }
                    return;
                }
            } else {
                if (c.getVersion() < 1112) {
                    this.srv.messageToPlayer(c, gaName, eventPN, "* Requires client version " + Version.version(1112) + " or newer.");
                    return;
                }
                SOCPlayer cliPl = ga.getPlayer(c.getData());
                if (cliPl == null) {
                    return;
                }
                eventPN = cliPl.getPlayerNumber();
                if (ga.getCurrentPlayerNumber() != eventPN) {
                    this.srv.messageToPlayer(c, gaName, eventPN, "* Can do this only on your own turn.");
                    return;
                }
                if (ga.getGameState() != 20 && !ga.isInitialPlacement()) {
                    this.srv.messageToPlayer(c, gaName, eventPN, "* Can do this only after rolling the dice.");
                    return;
                }
                ga.setDebugFreePlacement(true);
            }
        }
        this.srv.messageToPlayer(c, gaName, eventPN, "- Free Placement mode is " + (ppWanted ? "ON -" : "off -"));
        if (ppValue != ppWanted) {
            this.srv.messageToPlayer(c, gaName, eventPN, new SOCDebugFreePlace(gaName, ga.getCurrentPlayerNumber(), ppWanted));
            if (wasInitial && !ppWanted) {
                if (!this.checkTurn(c, ga)) {
                    this.sendTurn(ga, false);
                } else {
                    this.sendGameState(ga, false, true, false);
                }
            }
        }
    }

    private final void processDebugCommand_scenario(Connection c, SOCGame ga, String argStr) {
        if (argStr.isEmpty()) {
            return;
        }
        String gaName = ga.getName();
        if (ga.getGameOptionStringValue("SC") == null) {
            this.srv.messageToPlayer(c, gaName, -256, "This game has no scenario");
            return;
        }
        if (!ga.isGameOptionSet("_SC_FTRI")) {
            this.srv.messageToPlayer(c, gaName, -256, "This scenario has no debug commands");
            return;
        }
        StringTokenizer st = new StringTokenizer(argStr);
        if (!st.hasMoreTokens()) {
            return;
        }
        String subCmd = st.nextToken();
        if (subCmd.equalsIgnoreCase("giveport")) {
            boolean parseOK = false;
            int ptype = 0;
            boolean placeNow = false;
            SOCPlayer pl = null;
            try {
                ptype = Integer.parseInt(st.nextToken());
                int i = Integer.parseInt(st.nextToken());
                boolean bl = placeNow = i == 1;
                if (placeNow || i == 0) {
                    String plName;
                    boolean bl2 = parseOK = ptype >= 0 && ptype <= 5;
                    if (parseOK && (pl = this.debug_getPlayer(c, ga, plName = st.nextToken(Character.toString('\u0001')).trim())) == null) {
                        return;
                    }
                }
            }
            catch (NumberFormatException i) {
            }
            catch (NoSuchElementException e) {
                parseOK = false;
            }
            if (!parseOK) {
                String[] usage;
                for (String txt : usage = new String[]{"### Usage: giveport #typenum #placeflag player", "### typenum: 0 for 3:1 port, or 1 to 5 (clay, ore, sheep, wheat, wood)", "### placeflag: 1 to force placement now, 0 to add to inventory"}) {
                    this.srv.messageToPlayer(c, gaName, -256, txt);
                }
                return;
            }
            if (placeNow) {
                if (ga.getCurrentPlayerNumber() != pl.getPlayerNumber() || pl.getPortMovePotentialLocations(false) == null) {
                    this.srv.messageToPlayer(c, gaName, -256, "Player must be current and have a potential location for the port");
                    return;
                }
                int edge = ga.getBoard().getBoardWidth() + 2 | 0x101;
                ga.placePort(null, edge, ptype);
                ga.removePort(pl, edge);
                this.sendGameState(ga);
            } else {
                pl.getInventory().addItem(SOCInventoryItem.createForScenario(ga, -ptype, true, false, false, !placeNow));
                this.srv.messageToGame(gaName, true, new SOCInventoryItemAction(gaName, pl.getPlayerNumber(), 2, -ptype, false, false, true));
            }
        } else {
            this.srv.messageToPlayer(c, gaName, -256, "Unknown debug command: " + subCmd);
        }
    }

    @Override
    public final void calcGameClientFeaturesRequired(SOCGame ga) {
        SOCGameOptionSet opts;
        String scKey;
        SOCFeatureSet fs = null;
        if (ga.isGameOptionSet("SBL")) {
            fs = new SOCFeatureSet((String)null);
            fs.add("sb");
        }
        if (ga.maxPlayers > 4) {
            if (fs == null) {
                fs = new SOCFeatureSet((String)null);
            }
            fs.add("6pl");
        }
        if ((scKey = ga.getGameOptionStringValue("SC")) != null) {
            SOCScenario sc;
            if (fs == null) {
                fs = new SOCFeatureSet((String)null);
            }
            int scVers = (sc = SOCScenario.getScenario(scKey)) != null ? sc.minVersion : Integer.MAX_VALUE;
            fs.add("sc", scVers);
        }
        if ((opts = ga.getGameOptions()) != null) {
            for (SOCGameOption opt : opts) {
                String feat = opt.getClientFeature();
                if (feat == null || !opt.hasValue()) continue;
                if (fs != null) {
                    if (fs.isActive(feat)) {
                        continue;
                    }
                } else {
                    fs = new SOCFeatureSet((String)null);
                }
                fs.add(feat);
            }
        }
        if (fs != null) {
            ga.setClientFeaturesRequired(fs);
        }
    }

    final boolean checkTurn(Connection c, SOCGame ga) {
        if (c == null || ga == null) {
            return false;
        }
        try {
            return ga.getCurrentPlayerNumber() == ga.getPlayer(c.getData()).getPlayerNumber();
        }
        catch (Throwable th) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endGameTurn(SOCGame ga, SOCPlayer currPlayer, boolean callEndTurn) {
        boolean hadBoardResetRequest;
        String gname = ga.getName();
        int gaState = ga.getGameState();
        int cpn = ga.getCurrentPlayerNumber();
        if (currPlayer == null) {
            currPlayer = ga.getPlayer(cpn);
        }
        if (ga.doesCancelRoadBuildingReturnCard()) {
            this.srv.messageToGameKeyed(ga, true, true, "action.card.roadbuilding.cancel", currPlayer.getName());
            this.srv.messageToGame(gname, true, new SOCDevCardAction(gname, cpn, 3, 1));
            this.srv.messageToGame(gname, true, new SOCPlayerElement(gname, cpn, 100, SOCPlayerElement.PEType.PLAYED_DEV_CARD_FLAG, 0));
            if (!callEndTurn) {
                ga.cancelBuildRoad(cpn);
            }
        } else if (gaState == 41) {
            this.srv.messageToGameKeyed(ga, true, true, "action.card.roadbuilding.skip.r", currPlayer.getName());
        } else if (gaState == 100) {
            currPlayer.setAskedSpecialBuild(false);
            this.srv.messageToGame(gname, true, new SOCPlayerElement(gname, cpn, 100, SOCPlayerElement.PEType.ASK_SPECIAL_BUILD, 0));
        }
        boolean bl = hadBoardResetRequest = -1 != ga.getResetVoteRequester();
        if (callEndTurn) {
            ga.endTurn();
            gaState = ga.getGameState();
        }
        if (hadBoardResetRequest) {
            this.srv.messageToGame(gname, true, new SOCResetBoardReject(gname));
        }
        this.srv.gameList.takeMonitorForGame(gname);
        try {
            if (ga.clientVersionLowest >= 1109) {
                this.srv.messageToGameWithMon(gname, true, new SOCClearOffer(gname, -1));
            } else {
                for (int i = 0; i < ga.maxPlayers; ++i) {
                    this.srv.messageToGameWithMon(gname, false, new SOCClearOffer(gname, i));
                }
                if (this.srv.isRecordGameEventsActive()) {
                    this.srv.recordGameEvent(gname, new SOCClearOffer(gname, -1));
                }
            }
        }
        finally {
            this.srv.gameList.releaseMonitorForGame(gname);
        }
        if (this.srv.getConfigBoolProperty("jsettlers.debug.bots.datacheck.rsrc", false)) {
            ArrayList<Integer> allRes = null;
            for (int pn = 0; pn < ga.maxPlayers; ++pn) {
                SOCPlayer pl;
                if (ga.isSeatVacant(pn) || !(pl = ga.getPlayer(pn)).isRobot()) continue;
                if (allRes == null) {
                    allRes = new ArrayList<Integer>(6);
                }
                SOCResourceSet plRes = pl.getResources();
                allRes.add(pn);
                for (int resAmt : plRes.getAmounts(false)) {
                    allRes.add(resAmt);
                }
            }
            if (allRes != null) {
                this.srv.messageToGame(gname, false, new SOCBotGameDataCheck(gname, 1, DataUtils.intListToPrimitiveArray(allRes)));
            }
        }
        this.sendTurn(ga, false);
        if (ga.getGameState() == 100) {
            this.srv.messageToGameForVersionsKeyed(ga, -1, 2499, true, false, "action.sbp.turn.to.place.common", ga.getPlayer(ga.getCurrentPlayerNumber()).getName());
        }
    }

    private final boolean forceEndGameTurn(SOCGame ga, String plName) {
        int forceRes;
        SOCPlayer pl;
        int newLargestArmyPN;
        String gaName = ga.getName();
        int cpn = ga.getCurrentPlayerNumber();
        int endFromGameState = ga.getGameState();
        SOCPlayer pl2 = ga.getPlayerWithLargestArmy();
        int largestArmyPN = pl2 != null ? pl2.getPlayerNumber() : -1;
        SOCPlayer cp = ga.getPlayer(cpn);
        if (cp.hasAskedSpecialBuild()) {
            cp.setAskedSpecialBuild(false);
            this.srv.messageToGame(gaName, true, new SOCPlayerElement(gaName, cpn, 100, SOCPlayerElement.PEType.ASK_SPECIAL_BUILD, 0));
        }
        SOCForceEndTurnResult res = ga.forceEndTurn();
        if (1000 == ga.getGameState()) {
            return false;
        }
        SOCResourceSet resGainLoss = res.getResourcesGainedLost();
        if (resGainLoss != null) {
            if (!res.isLoss()) {
                if (endFromGameState == 56 || endFromGameState == 14) {
                    this.reportRsrcGainGold(ga, cp, cpn, resGainLoss, true, false);
                } else {
                    this.reportRsrcGainLoss(ga, resGainLoss, false, false, cpn, -1, null);
                }
            } else {
                int totalRes = resGainLoss.getTotal();
                if (ga.isGameOptionSet("PLAY_FO")) {
                    this.reportRsrcGainLoss(ga, resGainLoss, true, true, cpn, -1, null);
                } else {
                    Connection c = this.srv.getConnection(plName);
                    if (c != null && c.isConnected()) {
                        this.reportRsrcGainLoss(ga, resGainLoss, true, true, cpn, -1, c);
                    }
                    this.srv.messageToGameExcept(gaName, c, cpn, (SOCMessage)new SOCPlayerElement(gaName, cpn, 102, SOCPlayerElement.PEType.UNKNOWN_RESOURCE, totalRes, true), true);
                }
                this.srv.messageToGameKeyed(ga, true, true, "action.discarded.total.common", plName, totalRes);
            }
        }
        SOCInventoryItem itemCard = res.getReturnedInvItem();
        SOCInventoryItemAction retItemActionMsg = null;
        if (itemCard != null) {
            Connection c = this.srv.getConnection(plName);
            if (c != null && c.isConnected()) {
                if (itemCard instanceof SOCDevCard) {
                    int card = itemCard.itype;
                    if (card == 9 && c.getVersion() < 2000) {
                        card = 0;
                    }
                    this.srv.messageToPlayer(c, gaName, cpn, new SOCDevCardAction(gaName, cpn, 3, card));
                } else {
                    retItemActionMsg = new SOCInventoryItemAction(gaName, cpn, itemCard.isPlayable() ? 2 : 3, itemCard.itype, itemCard.isKept(), itemCard.isVPItem(), itemCard.canCancelPlay);
                    this.srv.messageToPlayer(c, gaName, cpn, retItemActionMsg);
                }
            }
            boolean announceAsInvItemAction = false;
            boolean announceAsUnknown = true;
            if (!(itemCard instanceof SOCDevCard)) {
                boolean handled = false;
                if (ga.isGameOptionSet("_SC_FTRI")) {
                    handled = true;
                    announceAsInvItemAction = true;
                    announceAsUnknown = false;
                }
                if (!handled) {
                    System.err.println("forceEndGameTurn: Unhandled inventory item type " + itemCard.itype + " class " + itemCard.getClass());
                }
            }
            if (announceAsInvItemAction) {
                this.srv.messageToGameExcept(gaName, c, cpn, retItemActionMsg, true);
            } else if (announceAsUnknown) {
                if (ga.clientVersionLowest >= 2000) {
                    boolean isObservableVP = ga.isGameOptionSet("PLAY_FO") || ga.isGameOptionSet("PLAY_VPO");
                    this.srv.messageToGameExcept(gaName, c, cpn, (SOCMessage)new SOCDevCardAction(gaName, cpn, 3, isObservableVP ? itemCard.itype : 0), true);
                } else {
                    this.srv.messageToGameForVersionsExcept(ga, -1, 1999, c, (SOCMessage)new SOCDevCardAction(gaName, cpn, 3, 9), true);
                    this.srv.messageToGameForVersionsExcept(ga, 2000, Integer.MAX_VALUE, c, (SOCMessage)new SOCDevCardAction(gaName, cpn, 3, 0), true);
                    this.srv.recordGameEventNotTo(gaName, cpn, (SOCMessage)new SOCDevCardAction(gaName, cpn, 3, 0));
                }
                this.srv.messageToGameKeyed(ga, true, true, "forceend.devcard.returned", plName);
                if (itemCard.itype == 9) {
                    this.srv.messageToGame(gaName, true, new SOCPlayerElement(gaName, cpn, 100, SOCPlayerElement.PEType.NUMKNIGHTS, cp.getNumKnights()));
                }
            }
        }
        int n = newLargestArmyPN = (pl = ga.getPlayerWithLargestArmy()) != null ? pl.getPlayerNumber() : -1;
        if (largestArmyPN != newLargestArmyPN) {
            SOCMessage msg = ga.clientVersionLowest >= 2000 ? new SOCGameElements(gaName, SOCGameElements.GEType.LARGEST_ARMY_PLAYER, newLargestArmyPN) : new SOCLargestArmy(gaName, newLargestArmyPN);
            this.srv.messageToGame(gaName, true, msg);
        }
        if ((forceRes = res.getResult()) == 2 || forceRes == 3) {
            if (res.didUpdateFP() || res.didUpdateLP()) {
                int fpn = ga.getFirstPlayer();
                SOCMessage msg = ga.clientVersionLowest >= 2000 ? new SOCGameElements(gaName, SOCGameElements.GEType.FIRST_PLAYER, fpn) : new SOCFirstPlayer(gaName, fpn);
                this.srv.messageToGame(gaName, true, msg);
            }
            this.sendTurn(ga, false);
            return true;
        }
        if (ga.canEndTurn(cpn)) {
            this.endGameTurn(ga, null, true);
        } else {
            this.sendGameState(ga, false, true, false);
        }
        return ga.getGameState() != 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void joinGame(SOCGame gameData, Connection c, boolean isReset, boolean isLoading, boolean isRejoinOrLoadgame) {
        int pn;
        SOCPlayer cliPl;
        int i;
        int laPlayerNum;
        void var16_37;
        HashMap<String, ArrayList[]> gameSItoPlayer;
        Set<String> ty;
        boolean allSeatsBots;
        boolean hasRobot = false;
        String gameName = gameData.getName();
        String cliName = c.getData();
        int gameState = gameData.getGameState();
        int cliVers = c.getVersion();
        boolean isFullyObservable = gameData.isGameOptionSet("PLAY_FO");
        if (!isReset) {
            void var16_29;
            int bw;
            int bh;
            SOCBoard board;
            String gameScen = gameData.getGameOptionStringValue("SC");
            if (gameScen != null) {
                this.srv.sendGameScenarioInfo(gameScen, null, c, false, false);
            }
            if ((board = gameData.getBoard()) instanceof SOCBoardLarge) {
                bh = board.getBoardHeight();
                bw = board.getBoardWidth();
                int[] nArray = ((SOCBoardLarge)board).getAddedLayoutPart("VS");
            } else {
                bw = 0;
                bh = 0;
                Object var16_28 = null;
            }
            this.srv.messageToPlayer(c, gameName, -257, new SOCJoinGameAuth(gameName, bh, bw, (int[])var16_29));
            SOCClientData scd = (SOCClientData)c.getAppData();
            if (!scd.sentPostAuthWelcome || c.getVersion() < 2000) {
                c.put(new SOCStatusMessage(0, this.srv.getClientWelcomeMessage(c)));
                scd.sentPostAuthWelcome = true;
            }
        }
        if (isLoading) {
            allSeatsBots = true;
            for (int pn2 = 0; pn2 < gameData.maxPlayers; ++pn2) {
                if (gameData.isSeatVacant(pn2) || !gameData.getPlayer(pn2).getName().equals(cliName)) continue;
                allSeatsBots = false;
                break;
            }
        } else {
            allSeatsBots = false;
        }
        if (cliVers >= 2000) {
            this.srv.messageToPlayer(c, gameName, -257, new SOCSetSeatLock(gameName, gameData.getSeatLocks()));
        }
        for (int i2 = 0; i2 < gameData.maxPlayers; ++i2) {
            boolean bl;
            SOCPlayer pl;
            String plName;
            if (cliVers < 2000) {
                SOCGame.SeatLockState sl = gameData.getSeatLock(i2);
                this.srv.messageToPlayer(c, gameName, -257, new SOCSetSeatLock(gameName, i2, sl != SOCGame.SeatLockState.CLEAR_ON_RESET ? sl : SOCGame.SeatLockState.UNLOCKED));
            }
            if (isReset || (plName = (pl = gameData.getPlayer(i2)).getName()) == null || gameData.isSeatVacant(i2)) continue;
            boolean bl2 = pl.isRobot();
            if (!(gameState != 990 || bl2 || allSeatsBots || isLoading || this.srv.gameList.isMember(plName, gameName))) {
                bl = true;
            }
            this.srv.messageToPlayer(c, gameName, -257, new SOCSitDown(gameName, plName, i2, bl || allSeatsBots));
            if (!bl) continue;
            hasRobot = true;
        }
        if (gameState != 0 || cliVers < 2000) {
            this.srv.messageToPlayer(c, gameName, -257, SOCGameHandler.getBoardLayoutMessage(gameData));
        }
        for (SOCPotentialSettlements sOCPotentialSettlements : SOCGameHandler.gatherBoardPotentials(gameData, cliVers)) {
            this.srv.messageToPlayer(c, gameName, -257, sOCPotentialSettlements);
        }
        if (gameState < 5 && gameData.isGameOptionSet("_SC_CLVI")) {
            this.srv.messageToPlayer(c, gameName, -257, new SOCPlayerElement(gameName, -1, 100, SOCPlayerElement.PEType.SCENARIO_CLOTH_COUNT, ((SOCBoardLarge)gameData.getBoard()).getCloth()));
        }
        if (gameData.hasSeaBoard && gameState >= 15) {
            boolean sendEdgeChanges;
            SOCBoardLarge bl = (SOCBoardLarge)gameData.getBoard();
            HashMap<Integer, SOCVillage> villages = bl.getVillages();
            if (villages != null) {
                for (SOCVillage sOCVillage : villages.values()) {
                    int cl = sOCVillage.getCloth();
                    if (cl == 5) continue;
                    this.srv.messageToPlayer(c, gameName, -257, new SOCPieceValue(gameName, 5, sOCVillage.getCoordinates(), cl, 0));
                }
            }
            if (!(sendEdgeChanges = bl.hasSpecialEdges())) {
                for (String ap : SOCBoardLarge.SPECIAL_EDGE_LAYOUT_PARTS) {
                    if (bl.getAddedLayoutPart(ap) == null) continue;
                    sendEdgeChanges = true;
                    break;
                }
            }
            if (sendEdgeChanges) {
                this.joinGame_sendBoardSpecialEdgeChanges(gameData, bl, c);
            }
        }
        this.srv.messageToPlayer(c, gameName, -257, cliVers >= 2000 ? new SOCGameElements(gameName, SOCGameElements.GEType.CURRENT_PLAYER, gameData.getCurrentPlayerNumber()) : new SOCSetTurn(gameName, gameData.getCurrentPlayerNumber()));
        String[] gameSITypes = gameState >= 5 ? ((ty = gameData.getSpecialItemTypes()) != null ? ty.toArray(new String[ty.size()]) : null) : null;
        if (gameSITypes == null) {
            gameSItoPlayer = null;
        } else {
            gameSItoPlayer = new HashMap<String, ArrayList[]>();
            for (int i3 = 0; i3 < gameSITypes.length; ++i3) {
                String string = gameSITypes[i3];
                ArrayList<SOCSpecialItem> gsi = gameData.getSpecialItems(string);
                if (gsi == null) continue;
                int L = gsi.size();
                for (int gi = 0; gi < L; ++gi) {
                    ArrayList<SOCSpecialItem> iList;
                    ArrayList<SOCSpecialItem> iList2;
                    SOCSpecialItem si = gsi.get(gi);
                    if (si == null) {
                        this.srv.messageToPlayer(c, gameName, -257, new SOCSetSpecialItem(gameName, 2, string, gi, -1, -1));
                        continue;
                    }
                    int pi = -1;
                    SOCPlayer pl = si.getPlayer();
                    if (pl != null && (iList2 = pl.getSpecialItems(string)) != null) {
                        for (int k = 0; k < iList2.size(); ++k) {
                            if (si != iList2.get(k)) continue;
                            pi = k;
                            break;
                        }
                    }
                    this.srv.messageToPlayer(c, gameName, -257, new SOCSetSpecialItem(gameData, 1, string, gi, pi, si));
                    if (pi == -1) continue;
                    ArrayList[] toAllPl = (ArrayList[])gameSItoPlayer.get(string);
                    if (toAllPl == null) {
                        toAllPl = new ArrayList[gameData.maxPlayers];
                        gameSItoPlayer.put(string, toAllPl);
                    }
                    if ((iList = toAllPl[pl.getPlayerNumber()]) == null) {
                        toAllPl[pl.getPlayerNumber()] = iList = new ArrayList<SOCSpecialItem>();
                    }
                    for (int iLL = iList.size(); iLL <= pi; ++iLL) {
                        iList.add(null);
                    }
                    iList.set(pi, si);
                }
            }
        }
        boolean doSendUBL = gameState >= 15 && gameData.isGameOptionSet("UBL");
        boolean bl = false;
        while (var16_37 < gameData.maxPlayers) {
            SOCPlayingPiece piece;
            SOCPlayer pl = gameData.getPlayer((int)var16_37);
            boolean isTakingOverThisSeat = isRejoinOrLoadgame && c.getData().equals(pl.getName());
            int itm = pl.getSpecialVP();
            if (itm != 0) {
                this.srv.messageToPlayer(c, gameName, -257, new SOCPlayerElement(gameName, (int)var16_37, 100, SOCPlayerElement.PEType.SCENARIO_SVP, itm));
                ArrayList<SOCPlayer.SpecialVPInfo> svpis = pl.getSpecialVPInfo();
                if (svpis != null) {
                    for (SOCPlayer.SpecialVPInfo svpi : svpis) {
                        this.srv.messageToPlayer(c, gameName, -257, new SOCSVPTextMessage(gameName, (int)var16_37, svpi.svp, c.getLocalized(svpi.desc), true));
                    }
                }
            }
            if ((itm = pl.getPlayerEvents()) != 0) {
                this.srv.messageToPlayer(c, gameName, -257, new SOCPlayerElement(gameName, (int)var16_37, 100, SOCPlayerElement.PEType.PLAYEREVENTS_BITMASK, itm));
            }
            if ((itm = pl.getScenarioSVPLandAreas()) != 0) {
                this.srv.messageToPlayer(c, gameName, -257, new SOCPlayerElement(gameName, (int)var16_37, 100, SOCPlayerElement.PEType.SCENARIO_SVP_LANDAREAS_BITMASK, itm));
            }
            if ((itm = pl.getStartingLandAreasEncoded()) != 0) {
                this.srv.messageToPlayer(c, gameName, -257, new SOCPlayerElement(gameName, (int)var16_37, 100, SOCPlayerElement.PEType.STARTING_LANDAREAS, itm));
            }
            if ((itm = pl.getCloth()) != 0) {
                this.srv.messageToPlayer(c, gameName, -257, new SOCPlayerElement(gameName, (int)var16_37, 100, SOCPlayerElement.PEType.SCENARIO_CLOTH_COUNT, itm));
            }
            Enumeration<SOCPlayingPiece> piecesEnum = pl.getPieces().elements();
            while (piecesEnum.hasMoreElements()) {
                piece = piecesEnum.nextElement();
                if (piece.getType() == 2) {
                    this.srv.messageToPlayer(c, gameName, -257, new SOCPutPiece(gameName, (int)var16_37, 1, piece.getCoordinates()));
                }
                this.srv.messageToPlayer(c, gameName, -257, new SOCPutPiece(gameName, (int)var16_37, piece.getType(), piece.getCoordinates()));
            }
            piece = pl.getFortress();
            if (piece != null) {
                int coord = piece.getCoordinates();
                int str = ((SOCFortress)piece).getStrength();
                this.srv.messageToPlayer(c, gameName, -257, new SOCPutPiece(gameName, (int)var16_37, piece.getType(), coord));
                if (str != 3) {
                    this.srv.messageToPlayer(c, gameName, -257, new SOCPieceValue(gameName, 4, coord, str, 0));
                }
            }
            if ((itm = pl.getNumWarships()) != 0) {
                this.srv.messageToPlayer(c, gameName, -257, new SOCPlayerElement(gameName, (int)var16_37, 100, SOCPlayerElement.PEType.SCENARIO_WARSHIP_COUNT, itm));
            }
            if (doSendUBL && pl.getPublicVP() > 0) {
                this.srv.messageToPlayer(c, gameName, -257, new SOCPlayerElement(gameName, (int)var16_37, 100, SOCPlayerElement.PEType.NUM_UNDOS_REMAINING, pl.getUndosRemaining()));
            }
            int[] counts = new int[gameData.hasSeaBoard ? 7 : 6];
            counts[0] = pl.getLastSettlementCoord();
            counts[1] = isFullyObservable ? 0 : pl.getResources().getTotal();
            counts[2] = pl.getNumKnights();
            counts[3] = pl.getNumPieces(0);
            counts[4] = pl.getNumPieces(1);
            counts[5] = pl.getNumPieces(2);
            if (gameData.hasSeaBoard) {
                counts[6] = pl.getNumPieces(3);
            }
            if (cliVers >= 2000) {
                this.srv.messageToPlayer(c, gameName, -257, new SOCPlayerElements(gameName, (int)var16_37, 100, gameData.hasSeaBoard ? ELEM_JOINGAME_WITH_PIECETYPES_SEA : ELEM_JOINGAME_WITH_PIECETYPES_CLASSIC, counts));
                if (isFullyObservable) {
                    this.srv.messageToPlayer(c, gameName, -257, new SOCPlayerElements(gameName, (int)var16_37, 100, ELEM_RESOURCES, pl.getResources().getAmounts(false)));
                }
            } else {
                this.srv.messageToPlayer(c, gameName, -257, new SOCLastSettlement(gameName, (int)var16_37, counts[0]));
                for (int j = 1; j < counts.length; ++j) {
                    this.srv.messageToPlayer(c, gameName, -257, new SOCPlayerElement(gameName, (int)var16_37, 100, ELEM_JOINGAME_WITH_PIECETYPES_CLASSIC[j], counts[j]));
                }
            }
            if (pl.hasAskedSpecialBuild()) {
                this.srv.messageToPlayer(c, gameName, -257, new SOCPlayerElement(gameName, (int)var16_37, 100, SOCPlayerElement.PEType.ASK_SPECIAL_BUILD, 1));
            }
            if (!isTakingOverThisSeat) {
                boolean cliVersionRecent;
                boolean bl3 = cliVersionRecent = cliVers >= 2000;
                if (!cliVersionRecent || !isFullyObservable && !gameData.isGameOptionSet("PLAY_VPO")) {
                    int numDevCards = pl.getInventory().getTotal();
                    int unknownType = cliVersionRecent ? 0 : 9;
                    SOCDevCardAction cardUnknownMsg = new SOCDevCardAction(gameName, (int)var16_37, 3, unknownType);
                    for (int j = 0; j < numDevCards; ++j) {
                        this.srv.messageToPlayer(c, gameName, -257, cardUnknownMsg);
                    }
                } else {
                    for (SOCMessage msg : this.sitDown_gatherInventoryContents(gameName, pl, cliVers)) {
                        this.srv.messageToPlayer(c, gameName, -257, msg);
                    }
                }
            }
            if (gameSITypes != null) {
                for (int j = 0; j < gameSITypes.length; ++j) {
                    String tkey = gameSITypes[j];
                    ArrayList<SOCSpecialItem> plsi = pl.getSpecialItems(tkey);
                    if (plsi == null) continue;
                    ArrayList[] toAllPl = (ArrayList[])gameSItoPlayer.get(tkey);
                    ArrayList iList = toAllPl != null ? toAllPl[var16_37] : null;
                    int L = plsi.size();
                    for (int pi = 0; pi < L; ++pi) {
                        SOCSpecialItem si = plsi.get(pi);
                        if (si == null) {
                            this.srv.messageToPlayer(c, gameName, -257, new SOCSetSpecialItem(gameName, 2, tkey, -1, pi, (int)var16_37));
                            continue;
                        }
                        if (iList != null && iList.size() > pi && iList.get(pi) == si) continue;
                        this.srv.messageToPlayer(c, gameName, -257, new SOCSetSpecialItem(gameData, 1, tkey, -1, pi, si));
                    }
                }
            }
            if (var16_37 == false && cliVers < 2000) {
                this.srv.messageToPlayer(c, gameName, -257, new SOCFirstPlayer(gameName, gameData.getFirstPlayer()));
                this.srv.messageToPlayer(c, gameName, -257, new SOCDevCardCount(gameName, gameData.getNumDevCards()));
            }
            this.srv.messageToPlayer(c, gameName, -257, new SOCChangeFace(gameName, (int)var16_37, pl.getFaceId()));
            if (var16_37 == false) {
                this.srv.messageToPlayer(c, gameName, -257, new SOCDiceResult(gameName, gameData.getCurrentDice()));
            }
            if ((itm = pl.getNeedToPickGoldHexResources()) > 0 && !gameData.isSeatVacant((int)var16_37)) {
                this.srv.messageToPlayer(c, gameName, -257, new SOCPlayerElement(gameName, (int)var16_37, 100, SOCPlayerElement.PEType.NUM_PICK_GOLD_HEX_RESOURCES, itm));
            }
            this.sendTradeOffer(pl, c);
            ++var16_37;
        }
        SOCPlayer sOCPlayer = gameData.getPlayerWithLongestRoad();
        SOCPlayer laPlayer = gameData.getPlayerWithLargestArmy();
        int lrPlayerNum = sOCPlayer != null ? sOCPlayer.getPlayerNumber() : -1;
        int n = laPlayerNum = laPlayer != null ? laPlayer.getPlayerNumber() : -1;
        if (cliVers < 2000) {
            this.srv.messageToPlayer(c, gameName, -257, new SOCLongestRoad(gameName, lrPlayerNum));
            this.srv.messageToPlayer(c, gameName, -257, new SOCLargestArmy(gameName, laPlayerNum));
        } else {
            this.srv.messageToPlayer(c, gameName, -257, new SOCGameElements(gameName, ELEM_JOINGAME_DEVCARDS_ROUNDS_PLNUMS_FIRST_LONGEST_LARGEST, new int[]{gameData.getNumDevCards(), gameData.getRoundCount(), gameData.getFirstPlayer(), lrPlayerNum, laPlayerNum}));
        }
        if (gameState >= 5) {
            GameAction act;
            List<Integer> shipEdges;
            if (isLoading && cliVers >= 2700 && (shipEdges = gameData.getShipsPlacedThisTurn()) != null && !shipEdges.isEmpty()) {
                int n2 = shipEdges.size();
                int[] edg = new int[n2];
                SOCGameElements.GEType[] ge = new SOCGameElements.GEType[n2];
                for (i = 0; i < n2; ++i) {
                    ge[i] = SOCGameElements.GEType.SHIP_PLACED_THIS_TURN_EDGE;
                    edg[i] = shipEdges.get(i);
                }
                this.srv.messageToPlayer(c, gameName, -257, new SOCGameElements(gameName, ge, edg));
            }
            if (gameData.isGameOptionSet("_SC_CLVI")) {
                this.srv.messageToPlayer(c, gameName, -257, new SOCPlayerElement(gameName, -1, 100, SOCPlayerElement.PEType.SCENARIO_CLOTH_COUNT, ((SOCBoardLarge)gameData.getBoard()).getCloth()));
            }
            if (cliVers >= 2700 && gameData.isPlacingRobberForKnightCard()) {
                this.srv.messageToPlayer(c, gameName, -257, new SOCGameElements(gameName, SOCGameElements.GEType.IS_PLACING_ROBBER_FOR_KNIGHT_CARD_FLAG, 1));
            }
            if (cliVers >= 2700 && (act = gameData.getLastAction()) != null) {
                this.srv.messageToPlayer(c, gameName, -257, new SOCSetLastAction(gameName, act.actType.value, act.param1, act.param2, act.param3, act.rset1, act.rset2));
                String reasonText = act.cannotUndoReason;
                if (reasonText != null) {
                    if (reasonText != "?") {
                        try {
                            reasonText = c.getLocalized(reasonText);
                        }
                        catch (MissingResourceException missingResourceException) {
                            // empty catch block
                        }
                    }
                    this.srv.messageToPlayer(c, gameName, -257, new SOCUndoNotAllowedReasonText(gameName, true, reasonText, true));
                }
            }
        }
        if (isRejoinOrLoadgame && !isLoading && (cliPl = gameData.getPlayer(cliName)) != null && (pn = cliPl.getPlayerNumber()) != -1 && !gameData.isSeatVacant(pn)) {
            this.sitDown_sendPrivateInfo(gameData, c, pn, true);
        }
        if (cliVers >= 2700) {
            this.sendGameStatsTiming(c, gameData);
        }
        if (!gameData.isBoardReset() || gameData.getGameState() >= 5 || cliVers < 1118) {
            List<SOCChatRecentBuffer.Entry> recents;
            SOCChatRecentBuffer buf = this.srv.gameList.getChatBuffer(gameName);
            SOCChatRecentBuffer sOCChatRecentBuffer = buf;
            synchronized (sOCChatRecentBuffer) {
                recents = buf.getAll();
            }
            if (!recents.isEmpty()) {
                this.srv.messageToPlayer(c, gameName, -257, new SOCGameTextMsg(gameName, ":", c.getLocalized("member.join.recap_begin")));
                for (SOCChatRecentBuffer.Entry e : recents) {
                    this.srv.messageToPlayer(c, gameName, -257, new SOCGameTextMsg(gameName, e.nickname, e.text));
                }
                this.srv.messageToPlayer(c, gameName, -257, new SOCGameTextMsg(gameName, ":", c.getLocalized("member.join.recap_end")));
            }
        }
        ArrayList<String> memberNames = null;
        this.srv.gameList.takeMonitorForGame(gameName);
        try {
            Vector<Connection> gameMembers;
            Vector<Connection> vector = gameMembers = this.srv.gameList.getMembers(gameName);
            synchronized (vector) {
                int n3 = gameMembers.size();
                memberNames = new ArrayList<String>(n3);
                for (i = 0; i < n3; ++i) {
                    memberNames.add(((Connection)gameMembers.get(i)).getData());
                }
            }
        }
        catch (Exception e) {
            D.ebugPrintlnINFO("Exception in SGH.joinGame (gameMembers) - " + e);
        }
        finally {
            this.srv.gameList.releaseMonitorForGame(gameName);
        }
        if (memberNames != null) {
            this.srv.messageToPlayer(c, gameName, -257, new SOCGameMembers(gameName, memberNames));
        }
        this.srv.messageToPlayer(c, gameName, -257, new SOCGameState(gameName, gameState));
        if (gameState == 1000) {
            this.sendGameStateOVER(gameData, c);
        }
        D.ebugPrintlnINFO("*** " + cliName + " joined the game " + gameName + " at " + SOCGameHandler.formatTimeHHMMSS(null));
        if (isRejoinOrLoadgame && gameState != 990) {
            return;
        }
        this.srv.messageToGame(gameName, true, new SOCJoinGame(cliName, "", "\t", gameName));
        if (isRejoinOrLoadgame) {
            return;
        }
        if (!isReset && gameState >= 10 && gameState < 1000) {
            this.srv.messageToPlayerKeyed(c, gameName, -257, hasRobot ? "member.join.game.started.bots" : "member.join.game.started");
        }
    }

    public static SOCPotentialSettlements[] gatherBoardPotentials(SOCGame gameData, int cliVers) {
        SOCPotentialSettlements[] ret;
        String gameName = gameData.getName();
        if (gameData.getGameState() < 5 && cliVers >= 2000) {
            SOCPotentialSettlements psMsg;
            HashSet<Integer> psSet;
            int pan;
            HashSet<Integer>[] lan;
            if (gameData.hasSeaBoard) {
                SOCBoardLarge bl = (SOCBoardLarge)gameData.getBoard();
                lan = bl.getLandAreasLegalNodes();
                pan = bl.getStartingLandArea();
                psSet = lan == null ? gameData.getPlayer(0).getPotentialSettlements() : null;
            } else {
                psSet = gameData.getPlayer(0).getPotentialSettlements();
                lan = null;
                pan = 0;
            }
            if (lan == null) {
                psMsg = new SOCPotentialSettlements(gameName, -1, new ArrayList<Integer>(psSet));
            } else {
                ArrayList<Integer> psList = psSet != null ? new ArrayList<Integer>(psSet) : null;
                psMsg = new SOCPotentialSettlements(gameName, -1, psList, pan, lan, SOCBoardAtServer.getLegalSeaEdges(gameData));
            }
            ret = new SOCPotentialSettlements[]{psMsg};
        } else {
            ret = new SOCPotentialSettlements[gameData.maxPlayers];
            int[][] lse = SOCBoardAtServer.getLegalSeaEdges(gameData);
            for (int pn = 0; pn < gameData.maxPlayers; ++pn) {
                Object plLse;
                Object object;
                HashSet<Integer>[] lan;
                SOCPlayer pl = gameData.getPlayer(pn);
                ArrayList<Integer> psList = new ArrayList<Integer>(pl.getPotentialSettlements());
                if (gameData.hasSeaBoard && pn == 0) {
                    SOCBoardLarge bl = (SOCBoardLarge)gameData.getBoard();
                    lan = bl.getLandAreasLegalNodes();
                } else {
                    lan = null;
                }
                if (lse != null) {
                    int[][] nArrayArray = new int[1][];
                    object = nArrayArray;
                    nArrayArray[0] = lse[pn];
                } else {
                    object = plLse = (int[][])null;
                }
                SOCPotentialSettlements psMsg = lan == null ? (lse == null ? new SOCPotentialSettlements(gameName, pn, psList) : new SOCPotentialSettlements(gameName, pn, (List<Integer>)psList, (int[][])plLse)) : new SOCPotentialSettlements(gameName, pn, (List<Integer>)psList, 0, lan, (int[][])plLse);
                ret[pn] = psMsg;
            }
        }
        return ret;
    }

    private final void joinGame_sendBoardSpecialEdgeChanges(SOCGame game, SOCBoardLarge board, Connection c) {
        String gaName = game.getName();
        int[][] seCoord = new int[SOCBoardLarge.SPECIAL_EDGE_LAYOUT_PARTS.length][];
        for (int i = 0; i < SOCBoardLarge.SPECIAL_EDGE_LAYOUT_PARTS.length; ++i) {
            String part = SOCBoardLarge.SPECIAL_EDGE_LAYOUT_PARTS[i];
            int[] edges = board.getAddedLayoutPart(part);
            if (edges == null) continue;
            seCoord[i] = edges;
            int edgeSEType = SOCBoardLarge.SPECIAL_EDGE_TYPES[i];
            for (int j = 0; j < edges.length; ++j) {
                int edge = edges[j];
                int seType = board.getSpecialEdgeType(edge);
                if (seType == edgeSEType) continue;
                this.srv.messageToPlayer(c, gaName, -257, new SOCSimpleAction(gaName, -1, 4, edge, seType));
            }
        }
        Iterator<Map.Entry<Integer, Integer>> seIter = board.getSpecialEdges();
        while (seIter.hasNext()) {
            Map.Entry<Integer, Integer> entry = seIter.next();
            int edge = entry.getKey();
            int seType = entry.getValue();
            boolean found = false;
            block3: for (int i = 0; i < SOCBoardLarge.SPECIAL_EDGE_LAYOUT_PARTS.length; ++i) {
                if (seType != SOCBoardLarge.SPECIAL_EDGE_TYPES[i]) continue;
                if (seCoord[i] == null) break;
                for (int j = 0; j < seCoord[i].length; ++j) {
                    if (edge != seCoord[i][j]) continue;
                    found = true;
                    break block3;
                }
                break;
            }
            if (found) continue;
            this.srv.messageToPlayer(c, gaName, -257, new SOCSimpleAction(gaName, -1, 4, edge, seType));
        }
    }

    void sendGameStatsTiming(Connection c, SOCGame gameData) {
        String gameName = gameData.getName();
        int gameState = gameData.getGameState();
        long timeCreated = gameData.getStartTime().getTime() / 1000L;
        long timeFinished = gameState >= 1000 ? timeCreated + (long)gameData.getDurationSeconds() : 0L;
        long[] stats = new long[]{timeCreated, gameState >= 5 ? 1L : 0L, timeFinished};
        this.srv.messageToPlayer(c, gameName, -257, new SOCGameStats(gameName, 2, stats));
    }

    @Override
    public void sitDown_sendPrivateInfo(SOCGame ga, Connection c, int pn, boolean isRejoinOrLoadgame) {
        int numGoldRes;
        boolean hasObservableInventory;
        String gaName = ga.getName();
        SOCPlayer pl = ga.getPlayer(pn);
        int cliVers = c.getVersion();
        SOCResourceSet resources = pl.getResources();
        int[] counts = resources.getAmounts(true);
        if (cliVers >= 2000) {
            this.srv.messageToPlayer(c, gaName, pn, new SOCPlayerElements(gaName, pn, 100, ELEM_RESOURCES_WITH_UNKNOWN, counts));
        } else {
            for (int i = 0; i < counts.length; ++i) {
                this.srv.messageToPlayer(c, null, -256, new SOCPlayerElement(gaName, pn, 100, ELEM_RESOURCES_WITH_UNKNOWN[i], counts[i]));
            }
            if (this.srv.isRecordGameEventsActive()) {
                this.srv.recordGameEventTo(gaName, pn, new SOCPlayerElements(gaName, pn, 100, ELEM_RESOURCES_WITH_UNKNOWN, counts));
            }
        }
        boolean cliVersionRecent = cliVers >= 2000;
        boolean cliVersionClearsInventory = cliVers >= 2300;
        boolean bl = hasObservableInventory = cliVersionRecent && (ga.isGameOptionSet("PLAY_FO") || ga.isGameOptionSet("PLAY_VPO"));
        if (!(isRejoinOrLoadgame || cliVersionClearsInventory || hasObservableInventory)) {
            int nCards;
            int i;
            Object cardUnknown = new SOCDevCardAction(gaName, pn, 1, cliVersionRecent ? 0 : 9);
            for (i = nCards = pl.getInventory().getTotal(); i > 0; --i) {
                this.srv.messageToPlayer(c, null, -256, (SOCMessage)cardUnknown);
            }
            if (this.srv.isRecordGameEventsActive()) {
                if (((SOCDevCardAction)cardUnknown).getCardType() != 0) {
                    cardUnknown = new SOCDevCardAction(gaName, pn, 1, 0);
                }
                for (i = nCards; i > 0; --i) {
                    this.srv.recordGameEventTo(gaName, pn, (SOCMessage)cardUnknown);
                }
            }
        }
        if (!hasObservableInventory || cliVersionClearsInventory) {
            for (SOCMessage msg : this.sitDown_gatherInventoryContents(gaName, pl, cliVers)) {
                this.srv.messageToPlayer(c, null, -256, msg);
                if (!this.srv.isRecordGameEventsActive()) continue;
                if (cliVersionRecent || !(msg instanceof SOCDevCardAction) || ((SOCDevCardAction)msg).getCardType() != 0) {
                    this.srv.recordGameEventTo(gaName, pn, msg);
                    continue;
                }
                this.srv.recordGameEventTo(gaName, pn, new SOCDevCardAction(gaName, pn, ((SOCDevCardAction)msg).getAction(), 9));
            }
        }
        if (cliVers >= 2700 && ga.getGameState() >= 5) {
            this.srv.messageToPlayer(c, gaName, pn, new SOCPlayerStats(pl, 1));
            this.srv.messageToPlayer(c, gaName, pn, new SOCPlayerStats(pl, 2));
        }
        this.sendGameState(ga);
        if (ga.getCurrentDice() == 7 && pl.getNeedToDiscard()) {
            this.srv.messageToPlayer(c, gaName, pn, new SOCDiscardRequest(gaName, pl.getCountToDiscard()));
        } else if (ga.hasSeaBoard && (numGoldRes = pl.getNeedToPickGoldHexResources()) > 0) {
            this.srv.messageToPlayer(c, gaName, pn, new SOCSimpleRequest(gaName, pn, 1, numGoldRes));
        }
        this.srv.messageToGame(gaName, true, new SOCChangeFace(gaName, pn, pl.getFaceId()));
    }

    private List<SOCMessage> sitDown_gatherInventoryContents(String gaName, SOCPlayer pl, int cliVers) {
        SOCInventory cardsInv = pl.getInventory();
        int pn = pl.getPlayerNumber();
        boolean cliVersionRecent = cliVers >= 2000;
        ArrayList<SOCMessage> ret = new ArrayList<SOCMessage>();
        for (int dcState = 1; dcState <= 3; ++dcState) {
            boolean dcAge = dcState == 1;
            int addCmd = dcAge ? 2 : 3;
            for (SOCInventoryItem iitem : cardsInv.getByState(dcState)) {
                SOCMessage addMsg;
                if (iitem instanceof SOCDevCard) {
                    int dcType = iitem.itype;
                    addMsg = new SOCDevCardAction(gaName, pn, addCmd, cliVersionRecent || dcType != 9 ? dcType : 0);
                } else {
                    addMsg = new SOCInventoryItemAction(gaName, pn, iitem.isPlayable() ? 2 : 3, iitem.itype, iitem.isKept(), iitem.isVPItem(), iitem.canCancelPlay);
                }
                ret.add(addMsg);
            }
        }
        return ret;
    }

    @Override
    public boolean leaveGame(SOCGame ga, Connection c, boolean hasReplacement, boolean hasHumanReplacement) {
        boolean shouldEndGame;
        int playerNumber;
        String gm = ga.getName();
        String gameOwner = ga.getOwner();
        String plName = c.getData();
        boolean gameHasHumanPlayer = hasHumanReplacement;
        boolean gameHasObserver = false;
        boolean gameVotingActiveDuringStart = false;
        int gameState = ga.getGameState();
        boolean isPlayer = false;
        for (playerNumber = 0; playerNumber < ga.maxPlayers; ++playerNumber) {
            SOCPlayer player = ga.getPlayer(playerNumber);
            if (player == null || player.getName() == null || !player.getName().equals(plName)) continue;
            isPlayer = true;
            if (ga.getResetVoteActive()) {
                if (gameState <= 14) {
                    gameVotingActiveDuringStart = true;
                }
                if (ga.getResetPlayerVote(playerNumber) == 0) {
                    this.srv.gameList.releaseMonitorForGame(gm);
                    ga.takeMonitor();
                    this.srv.resetBoardVoteNotifyOne(ga, playerNumber, plName, false);
                    ga.releaseMonitor();
                    this.srv.gameList.takeMonitorForGame(gm);
                }
            }
            ga.removePlayer(plName, hasReplacement);
            break;
        }
        SOCLeaveGame leaveMessage = new SOCLeaveGame(plName, "-", gm);
        this.srv.messageToGameWithMon(gm, true, leaveMessage);
        D.ebugPrintlnINFO("*** " + plName + " left the game " + gm + " at " + SOCGameHandler.formatTimeHHMMSS(null));
        this.srv.messageToGameKeyed(ga, true, false, "member.left.game", plName);
        if (!hasHumanReplacement) {
            for (int pn = 0; pn < ga.maxPlayers; ++pn) {
                SOCPlayer player = ga.getPlayer(pn);
                if (player == null || player.getName() == null || player.isRobot() || ga.isSeatVacant(pn)) continue;
                gameHasHumanPlayer = true;
                break;
            }
        }
        if (!gameHasHumanPlayer && !this.srv.gameList.isGameEmpty(gm)) {
            Enumeration<Connection> membersEnum = this.srv.gameList.getMembers(gm).elements();
            while (membersEnum.hasMoreElements()) {
                Connection member = membersEnum.nextElement();
                boolean nameMatch = false;
                for (int pn = 0; pn < ga.maxPlayers; ++pn) {
                    SOCPlayer player = ga.getPlayer(pn);
                    if (player == null || player.getName() == null || !player.getName().equals(member.getData())) continue;
                    nameMatch = true;
                    break;
                }
                if (nameMatch) continue;
                gameHasObserver = true;
                break;
            }
            if (gameHasObserver && gameState != 0 && gameState != 990 && !ga.isBotsOnly && 0 == this.srv.getConfigIntProperty("jsettlers.bots.botgames.total", 0)) {
                gameHasObserver = false;
            }
        }
        if (isPlayer && (gameHasHumanPlayer || gameHasObserver) && (ga.getPlayer(playerNumber).getPublicVP() > 0 || gameState == 5 || gameState == 6) && gameState < 990 && gameState >= 5) {
            boolean stillActive;
            boolean foundNoRobots;
            if (ga.getPlayer(playerNumber).isRobot()) {
                foundNoRobots = true;
            } else {
                boolean bl = foundNoRobots = !this.findRobotAskJoinGame(ga, playerNumber, true);
            }
            if (foundNoRobots && !(stillActive = this.endGameTurnOrForce(ga, playerNumber, plName, c, true))) {
                gameHasHumanPlayer = false;
                gameHasObserver = false;
            }
        } else if (ga.isBotsOnly && ga.getGameState() < 1000) {
            gameHasObserver = true;
        }
        boolean bl = shouldEndGame = !gameHasHumanPlayer && !gameHasObserver;
        if (!shouldEndGame && (gameOwner == null || gameOwner.equals(plName))) {
            ga.setOwner(null, null);
            Connection oldestRemainingConn = null;
            long oldestRemainingConnAtMillis = 0L;
            for (int pn = 0; pn < ga.maxPlayers; ++pn) {
                Connection plConn;
                String name;
                SOCPlayer pl;
                if (ga.isSeatVacant(pn) || (pl = ga.getPlayer(pn)).isRobot() || (name = pl.getName()) == null || name.isEmpty() || (plConn = this.srv.getConnection(name)) == null) continue;
                long connAtMillis = plConn.getConnectTime().getTime();
                if (oldestRemainingConn != null && connAtMillis >= oldestRemainingConnAtMillis) continue;
                oldestRemainingConn = plConn;
                oldestRemainingConnAtMillis = connAtMillis;
            }
            if (oldestRemainingConn != null) {
                String newOwnerName = oldestRemainingConn.getData();
                ga.setOwner(newOwnerName, oldestRemainingConn.getI18NLocale());
                this.srv.messageToGameKeyed(ga, true, false, "member.left.is_new_owner", newOwnerName);
            }
        }
        return shouldEndGame;
    }

    @Override
    public boolean findRobotAskJoinGame(SOCGame ga, Object seatNumberObj, boolean gameIsActive) {
        int seatNumber;
        if (gameIsActive) {
            this.srv.messageToGameKeyed(ga, true, false, "member.bot.join.fetching");
        }
        if (this.srv.robots.isEmpty()) {
            this.srv.messageToGameKeyed(ga, true, false, "member.bot.join.no.bots.server");
            return false;
        }
        if (ga.getClientVersionMinRequired() > Version.versionNumber()) {
            this.srv.messageToGameKeyed(ga, true, false, "member.bot.join.interror.version_nolocaliz", ga.getClientVersionMinRequired());
            return false;
        }
        Connection robotConn = null;
        boolean nameMatch = true;
        String gaName = ga.getName();
        boolean gameHasLimitedFeats = ga.getClientFeaturesRequired() != null;
        Hashtable<Connection, Object> requestedBots = this.srv.robotJoinRequests.get(gaName);
        if (!(seatNumberObj instanceof Integer)) {
            seatNumberObj = null;
        } else {
            HashSet<String> gameBots = new HashSet<String>();
            for (int i = 0; i < ga.maxPlayers; ++i) {
                String pname;
                SOCPlayer pl = ga.getPlayer(i);
                if (pl == null || (pname = pl.getName()) == null) continue;
                gameBots.add(pname);
            }
            int[] robotIndexes = this.srv.robotShuffleForJoin();
            for (int idx = 0; idx < this.srv.robots.size(); ++idx) {
                robotConn = this.srv.robots.get(robotIndexes[idx]);
                nameMatch = gameBots.contains(robotConn.getData());
                if (!nameMatch && requestedBots != null) {
                    nameMatch = requestedBots.containsKey(robotConn);
                }
                if (nameMatch) continue;
                if (!gameHasLimitedFeats || ga.canClientJoin(((SOCClientData)robotConn.getAppData()).feats)) break;
                nameMatch = true;
            }
        }
        if (!nameMatch) {
            seatNumber = (Integer)seatNumberObj;
            if (ga.getSeatLock(seatNumber) != SOCGame.SeatLockState.UNLOCKED) {
                ga.setSeatLock(seatNumber, SOCGame.SeatLockState.UNLOCKED);
                this.srv.messageToGameWithMon(gaName, true, new SOCSetSeatLock(gaName, seatNumber, SOCGame.SeatLockState.UNLOCKED));
            }
            if (requestedBots == null) {
                requestedBots = new Hashtable();
                requestedBots.put(robotConn, seatNumberObj);
                this.srv.robotJoinRequests.put(gaName, requestedBots);
            } else {
                requestedBots.put(robotConn, seatNumberObj);
            }
        } else {
            this.srv.messageToGameKeyed(ga, true, false, "member.bot.join.cantfind");
            return false;
        }
        this.srv.messageToPlayer(robotConn, gaName, -257, new SOCBotJoinGameRequest(gaName, seatNumber, ga.getGameOptions()));
        return true;
    }

    @Override
    public void sendGameState(SOCGame ga) {
        this.sendGameState(ga, false, true, true);
    }

    boolean sendGameState(SOCGame ga, boolean omitGameStateMessage, boolean sendStateMessageToAllVersions, boolean sendRollPrompt) {
        if (ga == null) {
            return false;
        }
        int gaState = ga.getGameState();
        int cpn = ga.getCurrentPlayerNumber();
        String gname = ga.getName();
        boolean wantRollPrompt = false;
        if (gaState == 1000) {
            if (!sendStateMessageToAllVersions) {
                this.srv.messageToGameForVersions(ga, -1, 1999, new SOCSetTurn(gname, cpn), true);
            } else if (ga.clientVersionLowest >= 2000) {
                this.srv.messageToGame(gname, true, new SOCGameElements(gname, SOCGameElements.GEType.CURRENT_PLAYER, cpn));
            } else {
                this.srv.messageToGame(gname, false, new SOCSetTurn(gname, cpn));
                if (this.srv.isRecordGameEventsActive()) {
                    this.srv.recordGameEvent(gname, new SOCGameElements(gname, SOCGameElements.GEType.CURRENT_PLAYER, cpn));
                }
            }
        }
        if (!omitGameStateMessage || gaState >= 1000) {
            SOCGameState gstateMsg = new SOCGameState(gname, gaState);
            if (sendStateMessageToAllVersions) {
                this.srv.messageToGame(gname, true, gstateMsg);
            } else {
                this.srv.messageToGameForVersions(ga, -1, 1999, gstateMsg, true);
            }
        }
        SOCPlayer player = null;
        if (cpn != -1) {
            player = ga.getPlayer(cpn);
        }
        switch (gaState) {
            case 5: 
            case 10: 
            case 12: {
                Connection con;
                this.srv.messageToGameKeyed(ga, true, true, "prompt.turn.to.build.stlmt", player.getName());
                if (gaState < 10 || !ga.isGameOptionSet("_SC_3IP") || (con = this.srv.getConnection(player.getName())) == null) break;
                this.srv.messageToPlayerKeyed(con, gname, cpn, "prompt.gameopt._SC_3IP.part1");
                this.srv.messageToPlayerKeyed(con, gname, cpn, "prompt.gameopt._SC_3IP.part2");
                break;
            }
            case 6: 
            case 11: 
            case 13: {
                this.srv.messageToGameKeyed(ga, true, true, ga.hasSeaBoard ? "prompt.turn.to.build.road.or.ship" : "prompt.turn.to.build.road", player.getName());
                break;
            }
            case 15: {
                if (ga.clientVersionLowest < 2000) {
                    String prompt = "It's " + player.getName() + "'s turn to roll the dice.";
                    this.srv.messageToGameForVersions(ga, 0, 1999, new SOCGameTextMsg(gname, "Server", prompt), true);
                }
                if (sendRollPrompt) {
                    this.srv.messageToGame(gname, true, new SOCRollDicePrompt(gname, player.getPlayerNumber()));
                    break;
                }
                wantRollPrompt = true;
                break;
            }
            case 50: {
                ArrayList<String> names = new ArrayList<String>();
                for (int i = 0; i < ga.maxPlayers; ++i) {
                    if (!ga.getPlayer(i).getNeedToDiscard()) continue;
                    names.add(ga.getPlayer(i).getName());
                }
                if (names.size() == 1) {
                    this.srv.messageToGameKeyed(ga, true, true, "prompt.discard.1", names.get(0));
                    break;
                }
                this.srv.messageToGameKeyedSpecial(ga, true, true, "prompt.discard.n", names);
                break;
            }
            case 54: {
                this.srv.messageToGameKeyed(ga, true, true, "robber.willmove.choose", player.getName());
                break;
            }
            case 33: {
                this.srv.messageToGameKeyed(ga, true, true, "robber.willmove", player.getName());
                break;
            }
            case 34: {
                this.srv.messageToGameKeyed(ga, true, true, "robber.willmove.pirate", player.getName());
                break;
            }
            case 51: {
                Connection con = this.srv.getConnection(ga.getPlayer(cpn).getName());
                if (con == null) break;
                boolean canChooseNone = ga.isGameOptionSet("_SC_PIRI");
                boolean[] choices = new boolean[ga.maxPlayers];
                for (SOCPlayer pl : ga.getPossibleVictims()) {
                    choices[pl.getPlayerNumber()] = true;
                }
                this.srv.messageToPlayer(con, gname, cpn, new SOCChoosePlayerRequest(gname, choices, canChooseNone));
                break;
            }
            case 1000: {
                this.sendGameStateOVER(ga, null);
            }
        }
        return wantRollPrompt;
    }

    final void sendGameState_sendDiscardRequests(SOCGame ga, String gaName) {
        for (int pn = 0; pn < ga.maxPlayers; ++pn) {
            SOCPlayer pl = ga.getPlayer(pn);
            if (ga.isSeatVacant(pn) || !pl.getNeedToDiscard()) continue;
            SOCDiscardRequest disMsg = new SOCDiscardRequest(gaName, pl.getCountToDiscard());
            Connection con = this.srv.getConnection(pl.getName());
            if (con != null) {
                this.srv.messageToPlayer(con, gaName, pn, disMsg);
                continue;
            }
            this.srv.recordGameEventTo(gaName, pn, disMsg);
        }
    }

    final void sendGameState_sendGoldPickAnnounceText(SOCGame ga, String gname, Connection playerCon, SOCGame.RollResult roll) {
        int ignoreAmountFromPirateFleet = roll != null && ga.isGameOptionSet("_SC_PIRI") && roll.sc_piri_fleetAttackRsrcs != null ? roll.sc_piri_fleetAttackRsrcs.getAmount(6) : 0;
        int count = 0;
        int amount = 0;
        int firstPN = -1;
        ArrayList<String> names = new ArrayList<String>();
        int[] num = new int[ga.maxPlayers];
        for (int pn = 0; pn < ga.maxPlayers; ++pn) {
            SOCPlayer pp = ga.getPlayer(pn);
            int numGoldRes = pp.getNeedToPickGoldHexResources();
            if (numGoldRes <= 0) continue;
            num[pn] = numGoldRes;
            if (ignoreAmountFromPirateFleet > 0 && pp == roll.sc_piri_fleetAttackVictim) {
                numGoldRes -= ignoreAmountFromPirateFleet;
            }
            if (numGoldRes <= 0) continue;
            names.add(pp.getName());
            if (++count != 1) continue;
            amount = numGoldRes;
            firstPN = pn;
        }
        if (count > 1) {
            this.srv.messageToGameKeyedSpecial(ga, true, true, "prompt.pick.gold.n", names);
        } else if (count == 1) {
            this.srv.messageToGameKeyed(ga, true, true, "prompt.pick.gold.1", names.get(0));
        }
        boolean singlePlayerGetsPickRequest = playerCon != null && count == 1;
        for (int pn = 0; pn < ga.maxPlayers; ++pn) {
            Connection plCon;
            if (num[pn] <= 0) continue;
            this.srv.messageToGame(gname, true, new SOCPlayerElement(gname, pn, 100, SOCPlayerElement.PEType.NUM_PICK_GOLD_HEX_RESOURCES, num[pn]));
            if (singlePlayerGetsPickRequest || (plCon = this.srv.getConnection(ga.getPlayer(pn).getName())) == null) continue;
            this.srv.messageToPlayer(plCon, gname, pn, new SOCSimpleRequest(gname, pn, 1, num[pn]));
        }
        if (singlePlayerGetsPickRequest) {
            this.srv.messageToPlayer(playerCon, gname, firstPN, new SOCSimpleRequest(gname, firstPN, 1, amount));
        }
    }

    private void sendGameStateOVER(SOCGame ga, Connection joiningConn) {
        String gname = ga.getName();
        SOCPlayer winPl = ga.getPlayer(ga.getCurrentPlayerNumber());
        if (joiningConn == null && winPl.getTotalVP() < ga.vp_winner && !ga.hasScenarioWinCondition) {
            for (int i = 0; i < ga.maxPlayers; ++i) {
                if (winPl.getTotalVP() < ga.vp_winner) continue;
                winPl = ga.getPlayer(i);
                break;
            }
        }
        if (joiningConn == null) {
            this.srv.messageToGameKeyed(ga, true, true, "stats.game.winner.withpoints", winPl.getName(), winPl.getTotalVP());
        } else {
            this.srv.messageToPlayerKeyed(joiningConn, gname, -257, "stats.game.winner.withpoints", winPl.getName(), winPl.getTotalVP());
        }
        boolean hasOnlyBotPlayers = ga.isBotsOnly;
        if (!ga.isGameOptionSet("PLAY_FO") && !ga.isGameOptionSet("PLAY_VPO")) {
            for (int pn = 0; pn < ga.maxPlayers; ++pn) {
                List<SOCInventoryItem> vpCards;
                SOCPlayer pl = ga.getPlayer(pn);
                if (hasOnlyBotPlayers && !ga.isSeatVacant(pn) && !pl.isRobot()) {
                    hasOnlyBotPlayers = false;
                }
                if ((vpCards = pl.getInventory().getByState(3)).isEmpty()) continue;
                if (ga.clientVersionHighest >= 2000 || joiningConn != null) {
                    ArrayList<Integer> vpCardsITypes = new ArrayList<Integer>();
                    for (SOCInventoryItem i : vpCards) {
                        vpCardsITypes.add(i.itype);
                    }
                    SOCDevCardAction dcaMsg = new SOCDevCardAction(gname, pn, 3, vpCardsITypes);
                    if (joiningConn != null) {
                        if (joiningConn.getVersion() < 2000) continue;
                        this.srv.messageToPlayer(joiningConn, gname, -257, dcaMsg);
                        continue;
                    }
                    if (ga.clientVersionLowest >= 2000) {
                        this.srv.messageToGame(gname, true, dcaMsg);
                        continue;
                    }
                    String txt = SOCStringManager.getFallbackServerManagerForClient().formatSpecial(ga, "{0} has {1,dcards}.", pl.getName(), vpCards);
                    this.srv.messageToGameForVersions(ga, 0, 1999, new SOCGameTextMsg(gname, "Server", txt), true);
                    this.srv.messageToGameForVersions(ga, 2000, Integer.MAX_VALUE, dcaMsg, true);
                    this.srv.recordGameEvent(gname, dcaMsg);
                    continue;
                }
                this.srv.messageToGame(gname, true, SOCStringManager.getFallbackServerManagerForClient().formatSpecial(ga, "{0} has {1,dcards}.", pl.getName(), vpCards));
            }
        }
        int[] scores = new int[ga.maxPlayers];
        boolean[] isRobot = new boolean[ga.maxPlayers];
        for (int i = 0; i < ga.maxPlayers; ++i) {
            scores[i] = ga.getPlayer(i).getTotalVP();
            isRobot[i] = ga.getPlayer(i).isRobot();
        }
        SOCGameStats statsMsg = new SOCGameStats(gname, scores, isRobot);
        if (joiningConn == null) {
            this.srv.messageToGame(gname, true, statsMsg);
        } else {
            this.srv.messageToPlayer(joiningConn, gname, -257, statsMsg);
        }
        if (joiningConn != null || ga.hasDoneGameOverTasks) {
            return;
        }
        ga.hasDoneGameOverTasks = true;
        int gameRounds = ga.getRoundCount();
        int gameSeconds = ga.getDurationSeconds();
        int gameMinutes = gameSeconds / 60;
        if ((gameSeconds %= 60) == 0) {
            this.srv.messageToGameKeyed(ga, true, true, "stats.game.was.roundsminutes", gameRounds, gameMinutes);
        } else {
            this.srv.messageToGameKeyed(ga, true, true, "stats.game.was.roundsminutessec", gameRounds, gameMinutes, gameSeconds);
        }
        for (int pn = 0; pn < ga.maxPlayers; ++pn) {
            SOCClientData cd;
            if (ga.isSeatVacant(pn)) continue;
            SOCPlayer pl = ga.getPlayer(pn);
            Connection plConn = this.srv.getConnection(pl.getName());
            if (plConn != null) {
                cd = (SOCClientData)plConn.getAppData();
                if (pl == winPl) {
                    cd.wonGame();
                } else {
                    cd.lostGame();
                }
            } else {
                cd = null;
            }
            if (pl.isRobot() || plConn == null) continue;
            int cliVers = plConn.getVersion();
            if (cliVers >= 1109) {
                this.srv.messageToPlayer(plConn, gname, pn, new SOCPlayerStats(pl, 1));
                if (cliVers >= 2600) {
                    this.srv.messageToPlayer(plConn, gname, pn, new SOCPlayerStats(pl, 2));
                }
            }
            this.srv.processDebugCommand_connStats(plConn, ga, true);
        }
        this.srv.gameOverIncrGamesFinishedCount(ga);
        this.srv.storeGameScores(ga);
        if (ga.isBotsOnly && hasOnlyBotPlayers && DESTROY_BOT_ONLY_GAMES_WHEN_OVER) {
            this.srv.destroyGameAndBroadcast(gname, "sendGameStateOVER");
        }
    }

    @Override
    public void sendDecline(Connection playerConn, SOCGame game, boolean withGameState, int eventPN, int reasonCode, int detailValue1, int detailValue2, String reasonTextKey, Object ... reasonTextParams) throws IllegalArgumentException {
        SOCDeclinePlayerRequest msg;
        if (playerConn == null) {
            throw new IllegalArgumentException("playerConn");
        }
        if (game == null) {
            throw new IllegalArgumentException("game");
        }
        boolean isRecentClient = playerConn.getVersion() >= 2500;
        int gameState = withGameState && reasonCode != 2 ? game.getGameState() : 0;
        String gameName = game.getName();
        if (isRecentClient || eventPN != -256 && this.srv.isRecordGameEventsActive()) {
            String localText = reasonTextKey != null ? (reasonTextParams == null || reasonTextParams.length == 0 ? playerConn.getLocalized(reasonTextKey) : playerConn.getLocalizedSpecial(game, reasonTextKey, reasonTextParams)) : null;
            msg = new SOCDeclinePlayerRequest(gameName, gameState, reasonCode, detailValue1, detailValue2, localText);
        } else {
            msg = null;
        }
        if (isRecentClient) {
            this.srv.messageToPlayer(playerConn, gameName, eventPN, msg);
        } else {
            if (msg != null) {
                this.srv.recordGameEventTo(gameName, eventPN, msg);
            }
            if (reasonTextKey == null) {
                switch (reasonCode) {
                    case 1: {
                        reasonTextKey = "reply.common.cannot.in_this_game";
                        break;
                    }
                    case 2: {
                        reasonTextKey = "base.reply.not.your.turn";
                        break;
                    }
                    case 4: {
                        reasonTextKey = "reply.common.cannot.at_that_location";
                        break;
                    }
                    default: {
                        reasonTextKey = "reply.common.cannot.right_now";
                    }
                }
            }
            if (reasonTextParams == null || reasonTextParams.length == 0) {
                this.srv.messageToPlayerKeyed(playerConn, gameName, -256, reasonTextKey);
            } else {
                this.srv.messageToPlayerKeyedSpecial(playerConn, game, -256, reasonTextKey, reasonTextParams);
            }
            if (gameState != 0) {
                this.srv.messageToPlayer(playerConn, null, -256, new SOCGameState(gameName, gameState));
            }
        }
    }

    void reportRobbery(SOCGame ga, SOCPlayer pe, SOCPlayer vi, int rsrc) {
        if (ga == null) {
            return;
        }
        String gaName = ga.getName();
        String peName = pe.getName();
        String viName = vi.getName();
        int pePN = pe.getPlayerNumber();
        int viPN = vi.getPlayerNumber();
        if (rsrc == 7) {
            int peAmt = pe.getCloth();
            int viAmt = vi.getCloth();
            SOCRobberyResult rrMsg = new SOCRobberyResult(gaName, pePN, viPN, SOCPlayerElement.PEType.SCENARIO_CLOTH_COUNT, false, peAmt, viAmt, 0);
            if (ga.clientVersionLowest >= 2500) {
                this.srv.messageToGame(gaName, true, rrMsg);
            } else {
                this.srv.recordGameEvent(gaName, rrMsg);
                this.srv.messageToGameForVersions(ga, 2500, Integer.MAX_VALUE, rrMsg, true);
                this.srv.messageToGameForVersions(ga, 0, 2499, new SOCPlayerElement(gaName, viPN, 100, SOCPlayerElement.PEType.SCENARIO_CLOTH_COUNT, viAmt, true), true);
                this.srv.messageToGameForVersions(ga, 0, 2499, new SOCPlayerElement(gaName, pePN, 100, SOCPlayerElement.PEType.SCENARIO_CLOTH_COUNT, peAmt), true);
                this.srv.messageToGameForVersionsKeyed(ga, 0, 2499, true, false, "robber.common.stole.cloth.from", peName, viName);
            }
            return;
        }
        boolean isFullyObservable = ga.isGameOptionSet("PLAY_FO");
        SOCRobberyResult reportRobb = new SOCRobberyResult(gaName, pePN, viPN, rsrc, true, 1, 0, 0);
        SOCRobberyResult reportRobbUnknown = isFullyObservable ? null : new SOCRobberyResult(gaName, pePN, viPN, 6, true, 1, 0, 0);
        Connection peCon = this.srv.getConnection(peName);
        Connection viCon = this.srv.getConnection(viName);
        int[] notToPNs = new int[]{pePN, viPN};
        ArrayList<Connection> sendNotTo = new ArrayList<Connection>(2);
        sendNotTo.add(peCon);
        sendNotTo.add(viCon);
        if (ga.clientVersionLowest >= 2500) {
            if (isFullyObservable) {
                this.srv.messageToGame(gaName, true, reportRobb);
            } else {
                this.srv.messageToPlayer(peCon, gaName, pePN, reportRobb);
                this.srv.messageToPlayer(viCon, gaName, viPN, reportRobb);
                this.srv.messageToGameExcept(gaName, sendNotTo, notToPNs, (SOCMessage)reportRobbUnknown, true);
            }
            return;
        }
        if (isFullyObservable) {
            this.srv.recordGameEvent(gaName, reportRobb);
        } else {
            this.srv.recordGameEventTo(gaName, pePN, reportRobb);
            this.srv.recordGameEventTo(gaName, viPN, reportRobb);
            this.srv.recordGameEventNotTo(gaName, notToPNs, (SOCMessage)reportRobbUnknown);
        }
        SOCPlayerElement gainRsrc = null;
        SOCPlayerElement loseRsrc = null;
        gainRsrc = new SOCPlayerElement(gaName, pePN, 101, rsrc, 1);
        loseRsrc = new SOCPlayerElement(gaName, viPN, 102, rsrc, 1, true);
        if (isFullyObservable) {
            this.srv.messageToGameForVersions(ga, 2500, Integer.MAX_VALUE, reportRobb, true);
            this.srv.messageToGameForVersions(ga, -1, 2499, gainRsrc, true);
            this.srv.messageToGameForVersions(ga, -1, 2499, loseRsrc, true);
            if (peCon.getVersion() < 2500) {
                this.srv.messageToPlayerKeyedSpecial(peCon, ga, -256, "robber.common.you.stole.resource.from", -1, rsrc, viName);
            }
            if (viCon.getVersion() < 2500) {
                this.srv.messageToPlayerKeyedSpecial(viCon, ga, -256, "robber.common.stole.resource.from.you", peName, -1, rsrc);
            }
        } else {
            if (peCon.getVersion() < 2500) {
                this.srv.messageToPlayer(peCon, null, -256, gainRsrc);
                this.srv.messageToPlayer(peCon, null, -256, loseRsrc);
                this.srv.messageToPlayerKeyedSpecial(peCon, ga, -256, "robber.common.you.stole.resource.from", -1, rsrc, viName);
            } else {
                this.srv.messageToPlayer(peCon, null, -256, reportRobb);
            }
            if (viCon.getVersion() < 2500) {
                this.srv.messageToPlayer(viCon, null, -256, gainRsrc);
                this.srv.messageToPlayer(viCon, null, -256, loseRsrc);
                this.srv.messageToPlayerKeyedSpecial(viCon, ga, -256, "robber.common.stole.resource.from.you", peName, -1, rsrc);
            } else {
                this.srv.messageToPlayer(viCon, null, -256, reportRobb);
            }
            this.srv.messageToGameForVersionsExcept(ga, 2500, Integer.MAX_VALUE, sendNotTo, (SOCMessage)reportRobbUnknown, true);
            if (ga.clientVersionLowest < 2500) {
                SOCPlayerElement gainUnknown = new SOCPlayerElement(gaName, pePN, 101, SOCPlayerElement.PEType.UNKNOWN_RESOURCE, 1);
                SOCPlayerElement loseUnknown = new SOCPlayerElement(gaName, viPN, 102, SOCPlayerElement.PEType.UNKNOWN_RESOURCE, 1);
                this.srv.messageToGameForVersionsExcept(ga, 0, 2499, sendNotTo, (SOCMessage)gainUnknown, true);
                this.srv.messageToGameForVersionsExcept(ga, 0, 2499, sendNotTo, (SOCMessage)loseUnknown, true);
            }
        }
        this.srv.messageToGameForVersionsKeyedExcept(ga, 0, 2499, true, sendNotTo, true, "robber.common.stole.resource.from", peName, viName);
    }

    @Override
    public void sendTradeOffer(SOCPlayer player, Connection toJoiningClient) {
        int lowestVersion;
        SOCTradeOffer offer = player.getCurrentOffer();
        if (offer == null) {
            return;
        }
        SOCGame ga = player.getGame();
        String gaName = ga.getName();
        int n = lowestVersion = toJoiningClient != null ? toJoiningClient.getVersion() : ga.clientVersionLowest;
        if (lowestVersion < 2000) {
            String txt = SOCStringManager.getFallbackServerManagerForClient().formatSpecial(ga, "{0} offered to give {1,rsrcs} for {2,rsrcs}.", player.getName(), offer.getGiveSet(), offer.getGetSet());
            if (toJoiningClient == null) {
                this.srv.messageToGameForVersions(ga, 0, 1999, new SOCGameTextMsg(gaName, "Server", txt), true);
            } else {
                this.srv.messageToPlayer(toJoiningClient, gaName, -256, txt);
            }
        }
        SOCMakeOffer makeOfferMessage = new SOCMakeOffer(gaName, offer);
        if (toJoiningClient == null) {
            this.srv.messageToGame(gaName, true, makeOfferMessage);
        } else {
            this.srv.messageToPlayer(toJoiningClient, gaName, -257, makeOfferMessage);
        }
        if (toJoiningClient == null) {
            if (ga.clientVersionLowest >= 1112) {
                this.srv.messageToGame(gaName, true, new SOCClearTradeMsg(gaName, -1));
            } else {
                this.srv.gameList.takeMonitorForGame(gaName);
                for (int i = 0; i < ga.maxPlayers; ++i) {
                    this.srv.messageToGameWithMon(gaName, false, new SOCClearTradeMsg(gaName, i));
                }
                this.srv.gameList.releaseMonitorForGame(gaName);
                if (this.srv.isRecordGameEventsActive()) {
                    this.srv.recordGameEvent(gaName, new SOCClearTradeMsg(gaName, -1));
                }
            }
        }
    }

    void reportTrade(SOCGame ga, int offering, int accepting) {
        String gaName = ga.getName();
        SOCTradeOffer offer = ga.getPlayer(offering).getCurrentOffer();
        SOCResourceSet giveSet = offer.getGiveSet();
        SOCResourceSet getSet = offer.getGetSet();
        if (ga.clientVersionLowest < 2500) {
            this.reportRsrcGainLossForVersions(ga, giveSet, true, false, offering, accepting, null, 2499);
            this.reportRsrcGainLossForVersions(ga, getSet, false, false, offering, accepting, null, 2499);
        }
        this.srv.messageToGame(gaName, true, new SOCAcceptOffer(gaName, accepting, offering, giveSet, getSet));
        if (ga.clientVersionLowest < 2000) {
            String txt = SOCStringManager.getFallbackServerManagerForClient().formatSpecial(ga, "{0} gave {1,rsrcs} for {2,rsrcs} from {3}.", ga.getPlayer(offering).getName(), giveSet, getSet, ga.getPlayer(accepting).getName());
            this.srv.messageToGameForVersions(ga, 0, 1999, new SOCGameTextMsg(gaName, "Server", txt), true);
        }
    }

    void reportBankTrade(SOCGame ga, SOCResourceSet give, SOCResourceSet get) {
        String gaName = ga.getName();
        int cpn = ga.getCurrentPlayerNumber();
        if (ga.clientVersionLowest <= 2500) {
            this.reportRsrcGainLossForVersions(ga, give, true, false, cpn, -1, null, 2499);
            this.reportRsrcGainLossForVersions(ga, get, false, false, cpn, -1, null, 2499);
        }
        SOCBankTrade bt = null;
        if (ga.clientVersionHighest >= 2000) {
            bt = new SOCBankTrade(gaName, give, get, cpn);
        }
        if (ga.clientVersionLowest >= 2000) {
            this.srv.messageToGame(gaName, true, bt);
        } else {
            int getTotal;
            int giveTotal;
            if (bt != null) {
                this.srv.messageToGameForVersions(ga, 2000, Integer.MAX_VALUE, bt, true);
            }
            if (this.srv.isRecordGameEventsActive()) {
                if (bt == null) {
                    bt = new SOCBankTrade(gaName, give, get, cpn);
                }
                this.srv.recordGameEvent(gaName, bt);
            }
            boolean isUndo = (giveTotal = give.getTotal()) < (getTotal = get.getTotal());
            StringBuilder fmt = new StringBuilder("{0} traded {1,rsrcs} for {2,rsrcs} from ");
            boolean isFromBank = isUndo ? getTotal / giveTotal == 4 : giveTotal / getTotal == 4;
            fmt.append(isFromBank ? "the bank." : "a port.");
            if (isUndo) {
                fmt.append(" (Undo previous trade)");
            }
            String txt = SOCStringManager.getFallbackServerManagerForClient().formatSpecial(ga, fmt.toString(), ga.getPlayer(cpn).getName(), give, get);
            this.srv.messageToGameForVersions(ga, 0, 1999, new SOCGameTextMsg(gaName, "Server", txt), true);
        }
    }

    void reportRsrcGainLoss(SOCGame ga, ResourceSet resourceSet, boolean isLoss, boolean isNews, int mainPlayer, int tradingPlayer, Connection playerConn) {
        this.reportRsrcGainLossForVersions(ga, resourceSet, isLoss, isNews, mainPlayer, tradingPlayer, playerConn, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportRsrcGainLossForVersions(SOCGame ga, ResourceSet resourceSet, boolean isLoss, boolean isNews, int mainPlayer, int tradingPlayer, Connection playerConn, int vmax) {
        int playerConnVersion;
        int n = playerConnVersion = playerConn != null ? playerConn.getVersion() : 0;
        if (playerConn != null && vmax != 0 && playerConnVersion > vmax) {
            return;
        }
        String gaName = ga.getName();
        int losegain = isLoss ? 102 : 101;
        int gainlose = isLoss ? 101 : 102;
        int[] resAmounts = new int[6];
        int resTypeCount = 0;
        for (int res = 1; res <= 5; ++res) {
            int amt = resourceSet.getAmount(res);
            if (amt <= 0) continue;
            resAmounts[res] = amt;
            ++resTypeCount;
        }
        boolean isRecording = vmax == 0 && this.srv.isRecordGameEventsActive();
        this.srv.gameList.takeMonitorForGame(gaName);
        try {
            SOCPlayerElements elementsMessage2;
            int clientVersionHighest = playerConn != null ? playerConnVersion : ga.clientVersionHighest;
            boolean sendAsElementsMessage = !(isNews || vmax != 0 && vmax < 2000 || resTypeCount <= 1 || clientVersionHighest < 2000 && !isRecording);
            SOCPlayerElements elementsMessage = sendAsElementsMessage ? new SOCPlayerElements(gaName, mainPlayer, losegain, resourceSet) : null;
            SOCPlayerElements sOCPlayerElements = elementsMessage2 = sendAsElementsMessage && tradingPlayer != -1 ? new SOCPlayerElements(gaName, tradingPlayer, gainlose, resourceSet) : null;
            if (playerConn != null) {
                if (sendAsElementsMessage && playerConnVersion >= 2000) {
                    this.srv.messageToPlayer(playerConn, gaName, isRecording ? mainPlayer : -256, elementsMessage);
                } else {
                    if (isRecording && sendAsElementsMessage) {
                        this.srv.recordGameEventTo(gaName, mainPlayer, elementsMessage);
                    }
                    for (int res = 1; res <= 5; ++res) {
                        int amt = resAmounts[res];
                        if (amt <= 0) continue;
                        this.srv.messageToPlayer(playerConn, gaName, isRecording && !sendAsElementsMessage ? mainPlayer : -256, new SOCPlayerElement(gaName, mainPlayer, losegain, res, amt, isNews));
                        if (!isNews) continue;
                        isNews = false;
                    }
                }
            } else if (sendAsElementsMessage && ga.clientVersionLowest >= 2000 && (vmax == 0 || clientVersionHighest <= vmax)) {
                this.srv.messageToGameWithMon(gaName, isRecording, elementsMessage);
                if (elementsMessage2 != null) {
                    this.srv.messageToGameWithMon(gaName, isRecording, elementsMessage2);
                }
            } else {
                int vmaxSend;
                int n2 = vmaxSend = vmax == 0 ? Integer.MAX_VALUE : vmax;
                if (sendAsElementsMessage) {
                    this.srv.messageToGameForVersions(ga, 2000, vmaxSend, elementsMessage, false);
                    if (elementsMessage2 != null) {
                        this.srv.messageToGameForVersions(ga, 2000, vmaxSend, elementsMessage2, false);
                    }
                    if (isRecording) {
                        this.srv.recordGameEvent(gaName, elementsMessage);
                        if (elementsMessage2 != null) {
                            this.srv.recordGameEvent(gaName, elementsMessage2);
                        }
                    }
                    if (ga.clientVersionLowest >= 2000) {
                        return;
                    }
                }
                if (sendAsElementsMessage) {
                    vmaxSend = 1999;
                }
                for (int res = 1; res <= 5; ++res) {
                    SOCPlayerElement elemMsg2;
                    int amt = resAmounts[res];
                    if (amt <= 0) continue;
                    SOCPlayerElement elemMsg = new SOCPlayerElement(gaName, mainPlayer, losegain, res, amt, isNews);
                    SOCPlayerElement sOCPlayerElement = elemMsg2 = tradingPlayer != -1 ? new SOCPlayerElement(gaName, tradingPlayer, gainlose, res, amt, isNews) : null;
                    if (vmaxSend == Integer.MAX_VALUE) {
                        this.srv.messageToGameWithMon(gaName, isRecording, elemMsg);
                        if (elemMsg2 != null) {
                            this.srv.messageToGameWithMon(gaName, isRecording, elemMsg2);
                        }
                    } else {
                        this.srv.messageToGameForVersions(ga, -1, vmaxSend, elemMsg, false);
                        if (elemMsg2 != null) {
                            this.srv.messageToGameForVersions(ga, -1, vmaxSend, elemMsg2, false);
                        }
                        if (isRecording && resTypeCount == 1) {
                            this.srv.recordGameEvent(gaName, elemMsg);
                            if (elemMsg2 != null) {
                                this.srv.recordGameEvent(gaName, elemMsg2);
                            }
                        }
                    }
                    if (!isNews) continue;
                    isNews = false;
                }
            }
        }
        finally {
            this.srv.gameList.releaseMonitorForGame(gaName);
        }
    }

    void reportRsrcGainGold(SOCGame ga, SOCPlayer player, int pn, SOCResourceSet rsrcs, boolean isNews, boolean includeGoldHexText) {
        String gaName = ga.getName();
        SOCPickResources picked = new SOCPickResources(gaName, rsrcs, pn, includeGoldHexText ? 3 : 1);
        if (ga.clientVersionLowest >= 2500) {
            this.srv.messageToGame(gaName, true, picked);
        } else {
            this.srv.recordGameEvent(gaName, picked);
            this.srv.messageToGameForVersions(ga, 2500, Integer.MAX_VALUE, picked, true);
            this.reportRsrcGainLossForVersions(ga, rsrcs, false, isNews, pn, -1, null, 2499);
            this.srv.messageToGameForVersionsKeyed(ga, 0, 2499, true, true, includeGoldHexText ? "action.picked.rsrcs.goldhex" : "action.picked.rsrcs", player.getName(), rsrcs);
        }
        this.srv.messageToGame(gaName, true, new SOCPlayerElement(gaName, pn, 100, SOCPlayerElement.PEType.NUM_PICK_GOLD_HEX_RESOURCES, 0));
    }

    final void reportLongestRoadIfChanged(SOCGame ga, SOCPlayer prevLongestRoadPlayer, boolean hasGameMonitor) {
        int newPN;
        int prevPN = prevLongestRoadPlayer != null ? prevLongestRoadPlayer.getPlayerNumber() : -1;
        SOCPlayer pl = ga.getPlayerWithLongestRoad();
        int n = newPN = pl != null ? pl.getPlayerNumber() : -1;
        if (newPN == prevPN) {
            return;
        }
        String gaName = ga.getName();
        SOCMessage msg = ga.clientVersionLowest >= 2000 ? new SOCGameElements(gaName, SOCGameElements.GEType.LONGEST_ROAD_PLAYER, newPN) : new SOCLongestRoad(gaName, newPN);
        if (hasGameMonitor) {
            this.srv.messageToGameWithMon(gaName, true, msg);
        } else {
            this.srv.messageToGame(gaName, true, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startGame(SOCGame ga) {
        if (ga == null) {
            return;
        }
        String gaName = ga.getName();
        ++this.srv.numberOfGamesStarted;
        ga.setGameEventListener(this);
        ga.startGame();
        int[][] legalSeaEdges = ga.hasSeaBoard ? SOCBoardAtServer.startGame_scenarioSetup(ga) : (int[][])null;
        this.srv.gameList.takeMonitorForGame(gaName);
        try {
            try {
                this.srv.messageToGameWithMon(gaName, true, SOCGameHandler.getBoardLayoutMessage(ga));
            }
            catch (IllegalArgumentException e) {
                System.err.println("startGame: Cannot send board for " + gaName + ": " + e.getMessage());
                this.srv.gameList.releaseMonitorForGame(gaName);
                return;
            }
            if (ga.hasSeaBoard) {
                SOCBoardLarge bl = (SOCBoardLarge)ga.getBoard();
                HashSet<Integer>[] lan = bl.getLandAreasLegalNodes();
                int pan = bl.getStartingLandArea();
                if (lan == null) {
                    this.srv.messageToGameWithMon(gaName, true, new SOCPotentialSettlements(gaName, -1, new ArrayList<Integer>(ga.getPlayer(0).getPotentialSettlements())));
                } else {
                    this.srv.messageToGameWithMon(gaName, true, new SOCPotentialSettlements(gaName, -1, null, pan, lan, legalSeaEdges));
                }
            }
            boolean sentInitPiecesState = false;
            for (int i = 0; i < ga.maxPlayers; ++i) {
                if (ga.isSeatVacant(i)) continue;
                SOCPlayer pl = ga.getPlayer(i);
                int[] counts = new int[ga.hasSeaBoard ? 4 : 3];
                counts[0] = pl.getNumPieces(0);
                counts[1] = pl.getNumPieces(1);
                counts[2] = pl.getNumPieces(2);
                if (ga.hasSeaBoard) {
                    Vector<SOCPlayingPiece> pieces = pl.getPieces();
                    if (!pieces.isEmpty()) {
                        if (!sentInitPiecesState) {
                            this.srv.messageToGameWithMon(gaName, true, new SOCGameState(gaName, 1));
                            sentInitPiecesState = true;
                        }
                        for (SOCPlayingPiece pp : pieces) {
                            this.srv.messageToGameWithMon(gaName, true, new SOCPutPiece(gaName, i, pp.getType(), pp.getCoordinates()));
                        }
                        SOCFortress pp = pl.getFortress();
                        if (pp != null) {
                            this.srv.messageToGameWithMon(gaName, true, new SOCPutPiece(gaName, i, pp.getType(), pp.getCoordinates()));
                        }
                    }
                    counts[3] = pl.getNumPieces(3);
                }
                if (ga.clientVersionLowest >= 2000) {
                    this.srv.messageToGameWithMon(gaName, true, new SOCPlayerElements(gaName, i, 100, ga.hasSeaBoard ? ELEM_PIECETYPES_SEA : ELEM_PIECETYPES_CLASSIC, counts));
                } else {
                    for (int j = 0; j < counts.length; ++j) {
                        this.srv.messageToGameWithMon(gaName, true, new SOCPlayerElement(gaName, i, 100, ELEM_PIECETYPES_SEA[j], counts[j]));
                    }
                }
                if (ga.clientVersionLowest >= 2000) continue;
                this.srv.messageToGameWithMon(gaName, false, new SOCSetPlayedDevCard(gaName, i, false));
            }
            if (ga.clientVersionLowest >= 2000) {
                this.srv.messageToGameWithMon(gaName, true, new SOCPlayerElement(gaName, -1, 100, SOCPlayerElement.PEType.PLAYED_DEV_CARD_FLAG, 0));
            } else if (this.srv.isRecordGameEventsActive()) {
                this.srv.recordGameEvent(gaName, new SOCPlayerElement(gaName, -1, 100, SOCPlayerElement.PEType.PLAYED_DEV_CARD_FLAG, 0));
            }
            if (ga.clientVersionLowest >= 2000) {
                this.srv.messageToGameWithMon(gaName, true, new SOCGameElements(gaName, SOCGameElements.GEType.DEV_CARD_COUNT, ga.getNumDevCards()));
            } else {
                this.srv.messageToGameWithMon(gaName, false, new SOCDevCardCount(gaName, ga.getNumDevCards()));
                if (this.srv.isRecordGameEventsActive()) {
                    this.srv.recordGameEvent(gaName, new SOCGameElements(gaName, SOCGameElements.GEType.DEV_CARD_COUNT, ga.getNumDevCards()));
                }
            }
            this.srv.messageToGameKeyed(ga, true, false, "start.picking.random.starting.player");
        }
        finally {
            this.srv.gameList.releaseMonitorForGame(gaName);
        }
        if (ga.clientVersionLowest >= 2000) {
            this.srv.messageToGame(gaName, true, new SOCStartGame(gaName, ga.getGameState()));
            this.sendTurn(ga, false);
        } else {
            int cpn = ga.getCurrentPlayerNumber();
            boolean sendRoll = this.sendGameState(ga, false, true, false);
            this.srv.messageToGame(gaName, false, new SOCStartGame(gaName, 0));
            this.srv.messageToGame(gaName, false, new SOCTurn(gaName, cpn, 0));
            if (this.srv.isRecordGameEventsActive()) {
                this.srv.recordGameEvent(gaName, new SOCStartGame(gaName, ga.getGameState()));
            }
            if (sendRoll) {
                this.srv.messageToGame(gaName, true, new SOCRollDicePrompt(gaName, cpn));
            }
        }
    }

    @Override
    public void sendGameStateResumingReloaded(SOCGame ga) {
        ga.setGameEventListener(this);
        this.sendGameState(ga);
    }

    void sendTurnStateAtInitialPlacement(SOCGame ga, SOCPlayer pl, Connection c, int prevGameState) {
        if (!this.checkTurn(c, ga)) {
            this.sendTurn(ga, true);
            return;
        }
        if (prevGameState < 15 && ga.getGameState() == 15) {
            int bxLA;
            SOCBoard board = ga.getBoard();
            if (board instanceof SOCBoardAtServer && (bxLA = ((SOCBoardAtServer)board).getBonusExcludeLandArea()) != 0) {
                String gaName = ga.getName();
                for (int pn = 0; pn < ga.maxPlayers; ++pn) {
                    if (ga.isSeatVacant(pn)) continue;
                    this.srv.messageToGame(gaName, true, new SOCPlayerElement(gaName, pn, 100, SOCPlayerElement.PEType.STARTING_LANDAREAS, ga.getPlayer(pn).getStartingLandAreasEncoded()));
                }
            }
            if (ga.clientVersionLowest >= 2500) {
                this.sendTurn(ga, false);
            } else {
                String gaName = ga.getName();
                int cpn = ga.getCurrentPlayerNumber();
                SOCTurn turnMsg = new SOCTurn(gaName, cpn, 15);
                this.srv.recordGameEvent(gaName, turnMsg);
                this.srv.messageToGameForVersions(ga, 2500, Integer.MAX_VALUE, turnMsg, true);
                this.srv.messageToGameForVersions(ga, -1, 2499, new SOCGameState(gaName, 15), true);
                this.srv.messageToGame(gaName, true, new SOCRollDicePrompt(gaName, cpn));
            }
            return;
        }
        if (ga.isInitialPlacementRoundDone(prevGameState)) {
            this.sendTurn(ga, false);
        } else {
            boolean sendRoll = this.sendGameState(ga, false, true, false);
            if (sendRoll) {
                String gaName = ga.getName();
                this.srv.messageToGame(gaName, true, new SOCRollDicePrompt(gaName, pl.getPlayerNumber()));
            }
        }
    }

    void sendTurn(SOCGame ga, boolean sendRollPrompt) {
        if (ga == null) {
            return;
        }
        boolean hasV1Clients = ga.clientVersionLowest < 2000;
        String gname = ga.getName();
        int gaState = ga.getGameState();
        int cpn = ga.getCurrentPlayerNumber();
        if (gaState == 1000) {
            SOCTurn turnMsg = new SOCTurn(gname, cpn, gaState);
            if (!hasV1Clients) {
                this.srv.messageToGame(gname, true, turnMsg);
            } else {
                this.srv.recordGameEvent(gname, turnMsg);
                this.srv.messageToGameForVersions(ga, 2000, Integer.MAX_VALUE, turnMsg, true);
            }
            this.sendGameState(ga, false, false, false);
            if (hasV1Clients) {
                this.srv.messageToGameForVersions(ga, -1, 1999, turnMsg, true);
            }
            return;
        }
        if (hasV1Clients) {
            this.srv.messageToGameForVersions(ga, -1, 1999, new SOCGameState(gname, gaState), true);
        }
        sendRollPrompt |= this.sendGameState(ga, true, false, false);
        if (ga.clientVersionLowest < 2500) {
            this.srv.messageToGameForVersions(ga, -1, 2499, ga.clientVersionLowest >= 2000 ? new SOCPlayerElement(gname, cpn, 100, SOCPlayerElement.PEType.PLAYED_DEV_CARD_FLAG, 0) : new SOCSetPlayedDevCard(gname, cpn, false), true);
        }
        this.srv.messageToGame(gname, true, new SOCTurn(gname, cpn, gaState));
        if (sendRollPrompt && gaState >= 15) {
            this.srv.messageToGame(gname, true, new SOCRollDicePrompt(gname, cpn));
        }
    }

    public static SOCMessage getBoardLayoutMessage(SOCGame ga) throws IllegalArgumentException {
        int[] numbers;
        int[] hexes;
        SOCBoard board = ga.getBoard();
        int bef = board.getBoardEncodingFormat();
        if (bef == 2 || bef == 1) {
            hexes = board.getHexLayout();
            numbers = board.getNumberLayout();
        } else {
            hexes = null;
            numbers = null;
        }
        int robber = board.getRobberHex();
        if (bef == 1 && ga.getClientVersionMinRequired() < 1108) {
            return new SOCBoardLayout(ga.getName(), hexes, numbers, robber);
        }
        switch (bef) {
            case 1: 
            case 2: {
                return new SOCBoardLayout2(ga.getName(), bef, hexes, numbers, board.getPortsLayout(), robber);
            }
            case 3: {
                SOCBoardLarge bl = (SOCBoardLarge)board;
                return new SOCBoardLayout2(ga.getName(), bef, bl.getLandHexLayout(), board.getPortsLayout(), robber, bl.getPirateHex(), bl.getPlayerExcludedLandAreas(), bl.getRobberExcludedLandAreas(), bl.getAddedLayoutParts());
            }
        }
        throw new IllegalArgumentException("unknown board encoding v" + bef);
    }

    private final void debugGiveResources(Connection c, String mes, SOCGame game) {
        String gaName = game.getName();
        StringTokenizer st = new StringTokenizer(mes.substring(6));
        int[] resources = new int[5];
        int resourceTypeIdx = 0;
        String name = "";
        boolean parseError = false;
        while (st.hasMoreTokens()) {
            if (resourceTypeIdx < 5) {
                String token = st.nextToken();
                try {
                    int amt = Integer.parseInt(token);
                    if (amt < 0) {
                        parseError = true;
                    }
                    resources[resourceTypeIdx] = amt;
                    ++resourceTypeIdx;
                    continue;
                }
                catch (NumberFormatException e) {
                    parseError = true;
                    break;
                }
            }
            name = st.nextToken(Character.toString('\u0001')).trim();
            break;
        }
        SOCPlayer pl = null;
        if (!parseError && (pl = this.debug_getPlayer(c, game, name)) == null) {
            parseError = true;
        }
        if (parseError) {
            this.srv.messageToPlayer(c, gaName, -256, "### Usage: rsrcs: #cl #or #sh #wh #wo player");
            this.srv.messageToPlayer(c, gaName, -256, DEBUG_COMMANDS_HELP_PLAYER);
            return;
        }
        SOCResourceSet rset = new SOCResourceSet(resources);
        pl.getResources().add(rset);
        this.reportRsrcGainLoss(game, rset, false, false, pl.getPlayerNumber(), -1, null);
        this.srv.messageToGameKeyedSpecial(game, true, true, "game.playername.gets.resources.common", pl.getName(), rset);
    }

    private final void debugGiveDevCard(Connection c, String mes, SOCGame game) {
        boolean parseError = false;
        String name = "";
        int cardType = -1;
        if (mes.length() <= 5) {
            parseError = true;
        } else {
            StringTokenizer st = new StringTokenizer(mes.substring(5));
            while (st.hasMoreTokens()) {
                if (cardType < 0) {
                    try {
                        cardType = Integer.parseInt(st.nextToken());
                        if (cardType >= 1 && cardType < 10) continue;
                        parseError = true;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        parseError = true;
                        break;
                    }
                }
                name = st.nextToken(Character.toString('\u0001')).trim();
                break;
            }
        }
        String gaName = game.getName();
        SOCPlayer pl = null;
        if (!parseError && (pl = this.debug_getPlayer(c, game, name)) == null) {
            parseError = true;
        }
        if (parseError) {
            for (String txt : new String[]{"### Usage: dev: #typ player", DEBUG_COMMANDS_HELP_PLAYER, DEBUG_COMMANDS_HELP_DEV_TYPES}) {
                this.srv.messageToPlayer(c, gaName, -256, txt);
            }
            return;
        }
        pl.getInventory().addDevCard(1, 1, cardType);
        int pnum = pl.getPlayerNumber();
        if (cardType != 9 || game.clientVersionLowest >= 2000) {
            this.srv.messageToGame(game.getName(), true, new SOCDevCardAction(gaName, pnum, 0, cardType));
        } else {
            this.srv.messageToGameForVersions(game, -1, 1999, new SOCDevCardAction(gaName, pnum, 0, 0), true);
            this.srv.messageToGameForVersions(game, 2000, Integer.MAX_VALUE, new SOCDevCardAction(gaName, pnum, 0, 9), true);
            this.srv.recordGameEvent(gaName, new SOCDevCardAction(gaName, pnum, 0, cardType));
        }
        this.srv.messageToGameKeyedSpecial(game, true, true, "debug.dev.gets", pl.getName(), cardType);
    }

    private final void debugSetNextDevCard(Connection c, String mes, SOCGame game) {
        StringTokenizer st = new StringTokenizer(mes.substring(8));
        int cardType = -1;
        boolean parseError = false;
        try {
            cardType = Integer.parseInt(st.nextToken());
            if (cardType < 1 || cardType >= 10) {
                parseError = true;
            }
        }
        catch (NumberFormatException e) {
            parseError = true;
        }
        if (st.hasMoreTokens()) {
            parseError = true;
        }
        String gaName = game.getName();
        if (parseError) {
            for (String txt : new String[]{"### Usage: devnext: #typ", DEBUG_COMMANDS_HELP_DEV_TYPES}) {
                this.srv.messageToPlayer(c, gaName, -256, txt);
            }
            return;
        }
        if (game.getNumDevCards() > 0) {
            game.setNextDevCard(cardType);
            this.srv.messageToGameKeyedSpecial(game, true, true, "debug.devnext.set", cardType);
        } else {
            this.srv.messageToPlayer(c, gaName, -256, "There are no more Development cards.");
        }
    }

    private SOCPlayer debug_getPlayer(Connection c, SOCGame ga, String name) {
        if (name.length() == 0) {
            return null;
        }
        SOCPlayer pl = null;
        if (name.startsWith("#") && name.length() > 1 && Character.isDigit(name.charAt(1))) {
            String err = null;
            int max = ga.maxPlayers - 1;
            try {
                int i = Integer.parseInt(name.substring(1).trim());
                if (i > max) {
                    err = "Max player number is " + Integer.toString(max);
                } else if (ga.isSeatVacant(i)) {
                    err = "Player number " + Integer.toString(i) + " is vacant";
                } else {
                    pl = ga.getPlayer(i);
                }
            }
            catch (NumberFormatException e) {
                err = "Player number format is # followed by the number (0 to " + Integer.toString(max) + " inclusive)";
            }
            if (err != null) {
                this.srv.messageToPlayer(c, ga.getName(), -256, "### " + err);
                return null;
            }
        }
        if (pl == null) {
            pl = ga.getPlayer(name);
        }
        if (pl == null) {
            this.srv.messageToPlayer(c, ga.getName(), -256, "### Player name not found: " + name);
        }
        return pl;
    }

    @Override
    public void endTurnIfInactive(SOCGame ga, long currentTimeMillis) {
        int gameState = ga.getGameState();
        boolean isDiscardOrPickRsrc = gameState == 50 || gameState == 56 || gameState == 14;
        SOCPlayer pl = ga.getPlayer(ga.getCurrentPlayerNumber());
        if (isDiscardOrPickRsrc) {
            SOCPlayer plEnd = null;
            for (int pn = 0; pn < ga.maxPlayers; ++pn) {
                SOCPlayer pli = ga.getPlayer(pn);
                if (!pli.getNeedToDiscard() && pli.getNeedToPickGoldHexResources() == 0) continue;
                if (pli.isRobot()) {
                    if (plEnd != null) continue;
                    plEnd = pli;
                    continue;
                }
                return;
            }
            if (plEnd == null) {
                return;
            }
            pl = plEnd;
        } else if (!pl.isRobot()) {
            return;
        }
        SOCTradeOffer plCurrentOffer = pl.getCurrentOffer();
        if (plCurrentOffer != null) {
            long tradeInactiveTime;
            boolean waitingForHuman = false;
            for (int pn = 0; pn < ga.maxPlayers; ++pn) {
                if (!plCurrentOffer.isWaitingReplyFrom(pn) || ga.getPlayer(pn).isRobot()) continue;
                waitingForHuman = true;
                break;
            }
            if (waitingForHuman && ga.lastActionTime > (tradeInactiveTime = currentTimeMillis - 1000L * (long)ROBOT_FORCE_ENDTURN_TRADEOFFER_SECONDS)) {
                return;
            }
        }
        new SOCForceEndTurnThread(this.srv, this, ga, pl).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean endGameTurnOrForce(SOCGame ga, int plNumber, String plName, Connection plConn, boolean hasMonitorFromGameList) {
        boolean gameStillActive = true;
        String gaName = ga.getName();
        if (!hasMonitorFromGameList) {
            this.srv.gameList.takeMonitorForGame(gaName);
        }
        int cpn = ga.getCurrentPlayerNumber();
        int gameState = ga.getGameState();
        boolean gameVotingActiveDuringStart = false;
        if (ga.getResetVoteActive()) {
            if (gameState <= 14) {
                gameVotingActiveDuringStart = true;
            }
            if (!ga.isSeatVacant(plNumber) && ga.getResetPlayerVote(plNumber) == 0) {
                this.srv.gameList.releaseMonitorForGame(gaName);
                ga.takeMonitor();
                this.srv.resetBoardVoteNotifyOne(ga, plNumber, plName, false);
                ga.releaseMonitor();
                this.srv.gameList.takeMonitorForGame(gaName);
            }
        }
        if (plNumber == cpn) {
            if (gameState == 6 || gameState == 11 || gameState == 13) {
                SOCPlayer pl = ga.getPlayer(plNumber);
                SOCSettlement pp = new SOCSettlement(pl, pl.getLastSettlementCoord(), null);
                ga.undoPutInitSettlement(pp);
                ga.setGameState(gameState);
                this.srv.messageToGameWithMon(gaName, true, new SOCCancelBuildRequest(gaName, 1));
            }
            if (ga.canEndTurn(plNumber)) {
                this.srv.gameList.releaseMonitorForGame(gaName);
                ga.takeMonitor();
                try {
                    this.endGameTurn(ga, null, true);
                }
                finally {
                    ga.releaseMonitor();
                }
                this.srv.gameList.takeMonitorForGame(gaName);
            } else {
                this.srv.gameList.releaseMonitorForGame(gaName);
                ga.takeMonitor();
                try {
                    if (gameVotingActiveDuringStart) {
                        this.srv.messageToGame(gaName, true, new SOCResetBoardReject(gaName));
                        ga.resetVoteClear();
                    }
                    gameStillActive = this.forceEndGameTurn(ga, plName);
                }
                finally {
                    ga.releaseMonitor();
                }
                if (gameStillActive) {
                    this.srv.gameList.takeMonitorForGame(gaName);
                }
            }
        } else if (gameState == 50 && ga.getPlayer(plNumber).getNeedToDiscard() || (gameState == 56 || gameState == 14) && ga.getPlayer(plNumber).getNeedToPickGoldHexResources() > 0) {
            this.srv.gameList.releaseMonitorForGame(gaName);
            System.err.println("L5789: Waiting too long for bot discard or gain: game=" + ga.getName() + ", pn=" + plNumber + "  " + plName);
            ga.takeMonitor();
            try {
                this.forceGamePlayerDiscardOrGain(ga, cpn, plConn, plName, plNumber);
                this.sendGameState(ga, false, true, false);
                if (ga.getGameState() == 50) {
                    this.sendGameState_sendDiscardRequests(ga, gaName);
                }
            }
            finally {
                ga.releaseMonitor();
            }
            this.srv.gameList.takeMonitorForGame(gaName);
        }
        if (!hasMonitorFromGameList) {
            this.srv.gameList.releaseMonitorForGame(gaName);
        }
        return gameStillActive;
    }

    private final void forceGamePlayerDiscardOrGain(SOCGame cg, int cpn, Connection c, String plName, int pn) throws IllegalStateException {
        boolean isDiscard = cg.getGameState() == 50;
        SOCResourceSet rset = cg.playerDiscardOrGainRandom(pn, isDiscard);
        cg.getPlayer(pn).addForcedEndTurn();
        String gaName = cg.getName();
        int totalRes = rset.getTotal();
        if (isDiscard) {
            if (cg.isGameOptionSet("PLAY_FO")) {
                this.reportRsrcGainLoss(cg, rset, true, true, pn, -1, null);
            } else {
                if (c != null && c.isConnected()) {
                    this.reportRsrcGainLoss(cg, rset, true, true, pn, -1, c);
                }
                this.srv.messageToGameExcept(gaName, c, pn, (SOCMessage)new SOCPlayerElement(gaName, pn, 102, SOCPlayerElement.PEType.UNKNOWN_RESOURCE, totalRes, true), true);
            }
            this.srv.messageToGameKeyed(cg, true, true, "action.discarded.total.common", plName, totalRes);
            System.err.println("Forced discard: " + totalRes + " from " + plName + " in game " + gaName);
        } else {
            this.reportRsrcGainGold(cg, cg.getPlayer(pn), pn, rset, true, false);
            System.err.println("Forced gold picks: " + totalRes + " to " + plName + " in game " + gaName);
        }
    }

    @Override
    public void gameEvent(SOCGame ga, SOCGameEvent evt, Object detail) {
        switch (evt) {
            case SGE_FOG_HEX_REVEALED: {
                int res;
                SOCBoard board = ga.getBoard();
                int hexCoord = (Integer)detail;
                int hexType = board.getHexTypeFromCoord(hexCoord);
                int diceNum = board.getNumberOnHexFromCoord(hexCoord);
                String gaName = ga.getName();
                this.srv.messageToGame(gaName, true, new SOCRevealFogHex(gaName, hexCoord, hexType, diceNum));
                int cpn = ga.getCurrentPlayerNumber();
                if (cpn == -1 || (res = board.getHexTypeFromNumber(hexCoord)) < 1 || res > 5) break;
                ga.pendingMessagesOut.add(new SOCPlayerElement(gaName, cpn, 101, res, 1, true));
                ga.pendingMessagesOut.add(new UnlocalizedString(true, "event.fog.reveal", ga.getPlayer(cpn).getName(), 1, res));
                break;
            }
            case SGE_CLVI_WIN_VILLAGE_CLOTH_EMPTY: {
                this.srv.messageToGameKeyed(ga, true, true, "event.sc_clvi.game.ending.villages");
                this.srv.messageToGameKeyed(ga, true, true, "event.won.special.cond", ((SOCPlayer)detail).getName());
                break;
            }
            case SGE_PIRI_LAST_FORTRESS_FLEET_DEFEATED: {
                String gaName = ga.getName();
                this.srv.messageToGameKeyedSpecial(ga, true, true, "event.sc_piri.fleet.defeated", new Object[0]);
                this.srv.messageToGame(gaName, true, new SOCMoveRobber(gaName, ga.getCurrentPlayerNumber(), 0));
                break;
            }
            case SGE_CURRENT_ACTION_UNDO_NOT_ALLOWED: {
                GameAction act = ga.getLastAction();
                String reasonTextKey = null;
                if (act != null) {
                    reasonTextKey = "?".equals(act.cannotUndoReason) ? null : act.cannotUndoReason;
                }
                ga.pendingMessagesOut.add(new SOCUndoNotAllowedReasonText(ga.getName(), true, reasonTextKey));
                break;
            }
        }
    }

    @Override
    public void playerEvent(SOCGame ga, SOCPlayer pl, SOCPlayerEvent evt, boolean flagsChanged, Object obj) {
        String gaName = ga.getName();
        String plName = pl.getName();
        int pn = pl.getPlayerNumber();
        boolean sendSVP = true;
        boolean sendPlayerEventsBitmask = true;
        switch (evt) {
            case SVP_SETTLED_ANY_NEW_LANDAREA: {
                String newSettleEventStr = this.playerEvent_newSettlementIsByShip(ga, (SOCSettlement)obj) ? "event.svp.sc_sany.island" : "event.svp.sc_sany.area";
                SOCGameHandler.updatePlayerSVPPendingMessage(ga, pl, 1, newSettleEventStr);
                break;
            }
            case SVP_SETTLED_EACH_NEW_LANDAREA: {
                String newSettleEventStr = this.playerEvent_newSettlementIsByShip(ga, (SOCSettlement)obj) ? "event.svp.sc_seac.island" : "event.svp.sc_seac.area";
                SOCGameHandler.updatePlayerSVPPendingMessage(ga, pl, 2, newSettleEventStr);
                sendPlayerEventsBitmask = false;
                int las = pl.getScenarioSVPLandAreas();
                if (las == 0) break;
                ga.pendingMessagesOut.add(new SOCPlayerElement(gaName, pn, 100, SOCPlayerElement.PEType.SCENARIO_SVP_LANDAREAS_BITMASK, las));
                break;
            }
            case CLOTH_TRADE_ESTABLISHED_VILLAGE: {
                sendSVP = false;
                if (!flagsChanged) {
                    sendPlayerEventsBitmask = false;
                }
                ga.pendingMessagesOut.add(new UnlocalizedString("event.sc_clvi.established", plName));
                if (flagsChanged) {
                    this.srv.messageToPlayerPendingKeyed(pl, gaName, "event.sc_clvi.not.prevented.pirate");
                }
                SOCVillage vi = (SOCVillage)obj;
                this.srv.messageToGame(gaName, true, new SOCPieceValue(gaName, 5, vi.getCoordinates(), vi.getCloth(), 0));
                this.srv.messageToGame(gaName, true, new SOCPlayerElement(gaName, pn, 100, SOCPlayerElement.PEType.SCENARIO_CLOTH_COUNT, pl.getCloth()));
                break;
            }
            case DEV_CARD_REACHED_SPECIAL_EDGE: {
                sendPlayerEventsBitmask = false;
                sendSVP = false;
                IntPair edge_cardType = (IntPair)obj;
                Connection c = this.srv.getConnection(plName);
                ga.pendingMessagesOut.add(new UnlocalizedString("action.built.sc_ftri.dev", plName));
                int ctype = edge_cardType.getB();
                boolean isObservableVP = ga.isGameOptionSet("PLAY_FO") || ga.isGameOptionSet("PLAY_VPO");
                this.srv.messageToPlayer(c, gaName, pn, new SOCDevCardAction(gaName, pn, 0, ctype));
                this.srv.messageToGameExcept(gaName, c, pn, (SOCMessage)new SOCDevCardAction(gaName, pn, 0, isObservableVP ? ctype : 0), true);
                this.srv.messageToGame(gaName, true, new SOCSimpleAction(gaName, -1, 4, edge_cardType.getA(), 0));
                break;
            }
            case SVP_REACHED_SPECIAL_EDGE: {
                SOCGameHandler.updatePlayerSVPPendingMessage(ga, pl, 1, "event.svp.sc_ftri.gift");
                sendPlayerEventsBitmask = false;
                this.srv.messageToGame(gaName, true, new SOCSimpleAction(gaName, -1, 4, (Integer)obj, 0));
                break;
            }
            case REMOVED_TRADE_PORT: {
                sendPlayerEventsBitmask = false;
                sendSVP = false;
                IntPair edge_portType = (IntPair)obj;
                int edge = edge_portType.getA();
                int portType = edge_portType.getB();
                int gameState = ga.getGameState();
                if (gameState == 950) break;
                if ((edge & 0xFF) <= ga.getBoard().getBoardWidth()) {
                    this.srv.messageToGame(gaName, true, new SOCSimpleAction(gaName, pn, 1002, edge, portType));
                }
                if (gameState == 42) {
                    Connection c = this.srv.getConnection(plName);
                    this.srv.messageToPlayer(c, gaName, pn, new SOCInventoryItemAction(gaName, pn, 7, -portType, false, false, false));
                    break;
                }
                this.srv.messageToGame(gaName, true, new SOCInventoryItemAction(gaName, pn, 2, -portType, false, false, true));
                break;
            }
        }
        if (sendSVP) {
            ga.pendingMessagesOut.add(new SOCPlayerElement(gaName, pn, 100, SOCPlayerElement.PEType.SCENARIO_SVP, pl.getSpecialVP()));
        }
        if (sendPlayerEventsBitmask) {
            ga.pendingMessagesOut.add(new SOCPlayerElement(gaName, pn, 100, SOCPlayerElement.PEType.PLAYEREVENTS_BITMASK, pl.getPlayerEvents()));
        }
    }

    private final boolean playerEvent_newSettlementIsByShip(SOCGame ga, SOCSettlement se) {
        if (se == null) {
            return true;
        }
        SOCBoard board = ga.getBoard();
        int shipCount = 0;
        int roadCount = 0;
        for (int edge : board.getAdjacentEdgesToNode(se.getCoordinates())) {
            SOCRoutePiece pp = board.roadOrShipAtEdge(edge);
            if (pp == null) continue;
            if (pp.isRoadNotShip()) {
                ++roadCount;
                continue;
            }
            ++shipCount;
        }
        return shipCount > roadCount;
    }

    private static void updatePlayerSVPPendingMessage(SOCGame ga, SOCPlayer pl, int svp, String descKey) {
        pl.addSpecialVPInfo(svp, descKey);
        String gaName = ga.getName();
        ga.pendingMessagesOut.add(new SOCSVPTextMessage(gaName, pl.getPlayerNumber(), svp, descKey));
    }

    void sendGamePendingMessages(SOCGame ga, boolean takeMon) {
        String gaName = ga.getName();
        if (takeMon) {
            this.srv.gameList.takeMonitorForGame(gaName);
        }
        for (Object msg : ga.pendingMessagesOut) {
            if (msg instanceof SOCKeyedMessage) {
                this.srv.messageToGameKeyedType(ga, true, (SOCKeyedMessage)msg, false);
                continue;
            }
            if (msg instanceof SOCMessage) {
                this.srv.messageToGameWithMon(gaName, true, (SOCMessage)msg);
                continue;
            }
            if (!(msg instanceof UnlocalizedString)) continue;
            UnlocalizedString us = (UnlocalizedString)msg;
            if (us.isSpecial) {
                this.srv.messageToGameKeyedSpecial(ga, true, false, us.key, us.params);
                continue;
            }
            this.srv.messageToGameKeyed(ga, true, false, us.key, us.params);
        }
        ga.pendingMessagesOut.clear();
        for (SOCPlayer p : ga.getPlayers()) {
            int pn = p.getPlayerNumber();
            List<Object> pq = p.pendingMessagesOut;
            int L = pq.size();
            if (L < 0) continue;
            Connection c = this.srv.getConnection(p.getName());
            if (c != null) {
                for (int i = 0; i < L; ++i) {
                    this.srv.messageToPlayer(c, gaName, pn, (SOCMessage)pq.get(i));
                }
            }
            pq.clear();
        }
        if (takeMon) {
            this.srv.gameList.releaseMonitorForGame(gaName);
        }
    }

    private static String formatTimeHHMMSS(Date time) {
        if (time == null) {
            time = new Date();
        }
        return new SimpleDateFormat("HH:mm:ss", Locale.US).format(time);
    }
}

