/*
 * Decompiled with CFR 0.152.
 */
package soc.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import soc.debug.D;
import soc.game.SOCGame;
import soc.game.SOCGameOptionSet;
import soc.message.SOCDeleteGame;
import soc.message.SOCGames;
import soc.message.SOCGamesWithOptions;
import soc.message.SOCNewGame;
import soc.message.SOCNewGameWithOptions;
import soc.server.GameHandler;
import soc.server.GameMessageHandler;
import soc.server.SOCBoardAtServer;
import soc.server.SOCChatRecentBuffer;
import soc.server.SOCClientData;
import soc.server.genericServer.Connection;
import soc.util.SOCFeatureSet;
import soc.util.SOCGameBoardReset;
import soc.util.SOCGameList;
import soc.util.Version;

public class SOCGameListAtServer
extends SOCGameList {
    public static int GAME_TIME_EXPIRE_MINUTES = 120;
    private final Hashtable<String, SOCGame> gameData;
    protected final Hashtable<String, Vector<Connection>> gameMembers;
    protected final Hashtable<String, SOCChatRecentBuffer> gameChatBuffer;
    private final Random rand;
    private static final String ALPHANUMERIC_LEGIBLE_CHOICES = "234678abcdefhjkmnpqrstwxyz";

    public SOCGameListAtServer(Random rand, SOCGameOptionSet knownOpts) throws IllegalArgumentException {
        super(knownOpts);
        this.rand = rand;
        if (knownOpts == null) {
            throw new IllegalArgumentException("knownOpts");
        }
        if (!(SOCGame.boardFactory instanceof SOCBoardAtServer.BoardFactoryAtServer)) {
            SOCGame.boardFactory = new SOCBoardAtServer.BoardFactoryAtServer();
        }
        this.gameData = new Hashtable();
        this.gameMembers = new Hashtable();
        this.gameChatBuffer = new Hashtable();
    }

    public synchronized boolean isGameEmpty(String gaName) {
        Vector<Connection> members = this.gameMembers.get(gaName);
        boolean result = members != null && members.isEmpty();
        return result;
    }

    public SOCGame getGameData(String gaName) {
        return this.gameData.get(gaName);
    }

    public Collection<SOCGame> getGamesData() {
        return this.gameData.values();
    }

    public GameHandler getGameTypeHandler(String gaName) {
        SOCGameList.GameInfo gi = (SOCGameList.GameInfo)this.gameInfo.get(gaName);
        if (gi == null || !(gi instanceof GameInfoAtServer)) {
            return null;
        }
        return ((GameInfoAtServer)gi).handler;
    }

    public GameMessageHandler getGameTypeMessageHandler(String gaName) {
        SOCGameList.GameInfo gi = (SOCGameList.GameInfo)this.gameInfo.get(gaName);
        if (gi == null || !(gi instanceof GameInfoAtServer)) {
            return null;
        }
        return ((GameInfoAtServer)gi).messageHandler;
    }

    public SOCChatRecentBuffer getChatBuffer(String gaName) {
        return this.gameChatBuffer.get(gaName);
    }

    public synchronized Vector<Connection> getMembers(String gaName) {
        return this.gameMembers.get(gaName);
    }

    public boolean isMember(Connection conn, String gaName) {
        Vector<Connection> members = this.getMembers(gaName);
        return members != null && members.contains(conn);
    }

    public boolean isMember(String memberName, String gaName) {
        Vector<Connection> members = this.getMembers(gaName);
        if (members == null) {
            return false;
        }
        for (Connection c : members) {
            String na = c.getData();
            if (na == null || !na.equals(memberName)) continue;
            return true;
        }
        return false;
    }

    public synchronized void addMember(Connection conn, String gaName) {
        Vector<Connection> members = this.getMembers(gaName);
        if (members == null) {
            if (!this.isGame(gaName)) {
                return;
            }
            members = new Vector();
            this.gameMembers.put(gaName, members);
        }
        if (!members.contains(conn)) {
            SOCClientData scd;
            String gaLocale;
            boolean firstMember = members.isEmpty();
            members.addElement(conn);
            SOCGame ga = this.getGameData(gaName);
            if (ga == null) {
                return;
            }
            int cliVers = conn.getVersion();
            if (firstMember) {
                ga.clientVersionLowest = cliVers;
                ga.clientVersionHighest = cliVers;
                ga.hasOldClients = cliVers < Version.versionNumber();
            } else {
                int cliLowestAlready = ga.clientVersionLowest;
                int cliHighestAlready = ga.clientVersionHighest;
                if (cliVers < cliLowestAlready) {
                    ga.clientVersionLowest = cliVers;
                    if (cliVers < Version.versionNumber()) {
                        ga.hasOldClients = true;
                    }
                }
                if (cliVers > cliHighestAlready) {
                    ga.clientVersionHighest = cliVers;
                }
            }
            if (!ga.hasMultiLocales && (gaLocale = ga.getOwnerLocale()) != null && (scd = (SOCClientData)conn.getAppData()) != null && scd.localeStr != null && !gaLocale.equals(scd.localeStr)) {
                ga.hasMultiLocales = true;
            }
        }
    }

    public synchronized void removeMember(Connection conn, String gaName) {
        Vector<Connection> members = this.getMembers(gaName);
        if (members != null) {
            members.removeElement(conn);
            if (!members.isEmpty()) {
                int lowVers;
                Connection c = members.firstElement();
                int highVers = lowVers = c.getVersion();
                for (int i = members.size() - 1; i >= 1; --i) {
                    c = members.elementAt(i);
                    int v = c.getVersion();
                    if (v < lowVers) {
                        lowVers = v;
                    }
                    if (v <= highVers) continue;
                    highVers = v;
                }
                SOCGame ga = this.getGameData(gaName);
                ga.clientVersionLowest = lowVers;
                ga.clientVersionHighest = highVers;
                ga.hasOldClients = lowVers < Version.versionNumber();
                String memberName = conn.getData();
                if (memberName != null) {
                    ga.setMemberChatAllowed(memberName, false);
                }
            }
        }
    }

    public synchronized List<SOCGame> replaceMemberAllGames(Connection oldConn, Connection newConn, boolean alwaysCheckFeats) throws IllegalArgumentException {
        if (!oldConn.getData().equals(newConn.getData())) {
            throw new IllegalArgumentException("keyname data");
        }
        ArrayList<SOCGame> unjoinables = new ArrayList<SOCGame>();
        boolean sameVersion = oldConn.getVersion() == newConn.getVersion();
        SOCClientData scd = (SOCClientData)newConn.getAppData();
        boolean cliHasLimitedFeats = alwaysCheckFeats || scd.hasLimitedFeats;
        for (String gaName : this.getGameNames()) {
            SOCGame ga;
            Vector<Connection> members = this.gameMembers.get(gaName);
            if (members == null || !members.contains(oldConn)) continue;
            if (cliHasLimitedFeats && (ga = this.getGameData(gaName)) != null && !ga.canClientJoin(scd.feats)) {
                unjoinables.add(ga);
                continue;
            }
            if (sameVersion) {
                members.remove(oldConn);
                members.addElement(newConn);
                continue;
            }
            this.removeMember(oldConn, gaName);
            this.addMember(newConn, gaName);
        }
        return unjoinables.isEmpty() ? null : unjoinables;
    }

    public synchronized SOCGame createGame(String gaName, String gaOwner, String gaLocaleStr, SOCGameOptionSet gaOpts, GameHandler handler) throws IllegalArgumentException {
        return this.addGame(new SOCGame(gaName, gaOpts, this.knownOpts), handler, gaOwner, gaLocaleStr);
    }

    protected synchronized SOCGame addGame(SOCGame game, GameHandler handler, String gaOwner, String gaLocaleStr) throws IllegalArgumentException, NoSuchElementException {
        if (handler == null) {
            throw new IllegalArgumentException("handler");
        }
        String gaName = game.getName();
        if (this.isGame(gaName)) {
            if ((gaName = this.makeUnusedName(gaName)) == null) {
                throw new NoSuchElementException("gaName");
            }
            game.setName(gaName);
        }
        if (gaOwner != null) {
            game.setOwner(gaOwner, gaLocaleStr);
        }
        Vector members = new Vector();
        this.gameMembers.put(gaName, members);
        this.gameChatBuffer.put(gaName, new SOCChatRecentBuffer());
        game.setExpiration(game.getStartTime().getTime() + (long)(60000 * GAME_TIME_EXPIRE_MINUTES));
        handler.calcGameClientFeaturesRequired(game);
        this.gameInfo.put(gaName, new GameInfoAtServer(game.getGameOptions(), handler));
        this.gameData.put(gaName, game);
        return game;
    }

    private synchronized String makeUnusedName(String baseName) {
        String name;
        int i;
        Matcher m;
        int i0 = 2;
        String base = baseName;
        int baseLen = base.length();
        if (Character.isDigit(baseName.charAt(baseLen - 1)) && (m = Pattern.compile("-(\\d+)$").matcher(baseName)).find(1)) {
            base = baseName.substring(0, m.start());
            baseLen = base.length();
            try {
                i0 = Integer.parseInt(m.group(1));
                i0 = i0 < Integer.MAX_VALUE ? ++i0 : 2;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String dbase = base;
        int excessLen = baseLen + 2 + (int)Math.floor(Math.log10(i0 + 20)) - 30;
        if (excessLen > 0) {
            dbase = base.substring(0, baseLen - excessLen);
        }
        for (i = i0; i <= i0 + 20; ++i) {
            name = dbase + '-' + i;
            if (this.isGame(name)) continue;
            return name;
        }
        dbase = base;
        excessLen = baseLen + 1 + 5 - 30;
        if (excessLen > 0) {
            dbase = base.substring(0, baseLen - excessLen);
        }
        for (i = 1; i < 20; ++i) {
            name = dbase + '-' + this.randomAlphanumericLegibles(5);
            if (this.isGame(name)) continue;
            return name;
        }
        for (int i2 = 1; i2 < 200; ++i2) {
            String name2 = "game-" + this.randomAlphanumericLegibles(6);
            if (this.isGame(name2)) continue;
            return name2;
        }
        return null;
    }

    private final StringBuffer randomAlphanumericLegibles(int length) {
        int L = ALPHANUMERIC_LEGIBLE_CHOICES.length();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            sb.append(ALPHANUMERIC_LEGIBLE_CHOICES.charAt(this.rand.nextInt(L)));
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SOCGameBoardReset resetBoard(String gaName) {
        SOCGame oldGame = this.gameData.get(gaName);
        if (oldGame == null) {
            return null;
        }
        this.takeMonitorForGame(gaName);
        SOCGameBoardReset reset = null;
        try {
            reset = new SOCGameBoardReset(oldGame, this.getMembers(gaName));
            SOCGame rgame = reset.newGame;
            rgame.setExpiration(System.currentTimeMillis() + (long)(60000 * GAME_TIME_EXPIRE_MINUTES));
            this.gameData.remove(gaName);
            this.gameData.put(gaName, rgame);
            oldGame.destroyGame();
        }
        catch (Throwable e) {
            D.ebugPrintStackTrace(e, "ERROR -> gamelist.resetBoard");
        }
        finally {
            this.releaseMonitorForGame(gaName);
        }
        return reset;
    }

    @Override
    public synchronized void addGames(SOCGameList gl, int ourVersion) {
        Hashtable<String, SOCGame> gdata;
        if (gl == null) {
            return;
        }
        if (gl instanceof SOCGameListAtServer && (gdata = ((SOCGameListAtServer)gl).gameData) != null) {
            this.addGames(gdata.values(), ourVersion);
        }
        super.addGames(gl, ourVersion);
    }

    @Override
    public synchronized void deleteGame(String gaName) {
        SOCChatRecentBuffer buf;
        SOCGame game = this.gameData.remove(gaName);
        if (game != null) {
            game.destroyGame();
        }
        super.deleteGame(gaName);
        Vector<Connection> members = this.gameMembers.remove(gaName);
        if (members != null) {
            members.removeAllElements();
        }
        if ((buf = this.gameChatBuffer.remove(gaName)) != null) {
            buf.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int playerGamesMinVersion(Connection plConn) {
        int minVers = 0;
        Hashtable<String, SOCGame> hashtable = this.gameData;
        synchronized (hashtable) {
            for (SOCGame ga : this.getGamesData()) {
                int vers;
                Vector<Connection> members = this.getMembers(ga.getName());
                if (members == null || !members.contains(plConn) || (vers = ga.getClientVersionMinRequired()) <= minVers) continue;
                minVers = vers;
            }
        }
        return minVers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SOCGame> memberGames(Connection c, String firstGameName) {
        ArrayList<SOCGame> cGames = new ArrayList<SOCGame>();
        Hashtable<String, SOCGame> hashtable = this.gameData;
        synchronized (hashtable) {
            Vector<Connection> members;
            SOCGame firstGame = null;
            if (firstGameName != null && (firstGame = this.getGameData(firstGameName)) != null && (members = this.getMembers(firstGameName)) != null && members.contains(c)) {
                cGames.add(firstGame);
            }
            for (SOCGame ga : this.getGamesData()) {
                Vector<Connection> members2;
                if (ga == firstGame || (members2 = this.getMembers(ga.getName())) == null || !members2.contains(c)) continue;
                cGames.add(ga);
            }
        }
        return cGames;
    }

    public void sendGameList(Connection c, int prevVers, boolean alwaysCheckFeats) {
        boolean cliVersionChange;
        int cliVers = c.getVersion();
        SOCClientData scd = (SOCClientData)c.getAppData();
        boolean cliCanKnow = cliVers >= 1106;
        boolean cliCouldKnow = prevVers >= 1106;
        boolean cliGetsUnjoinableWithOpts = cliVers >= 2700;
        boolean cliNotLimitedFeats = !alwaysCheckFeats && !scd.hasLimitedFeats;
        SOCFeatureSet cliLimitedFeats = cliNotLimitedFeats ? null : scd.feats;
        ArrayList<Object> gl = new ArrayList<Object>();
        this.takeMonitor();
        boolean alreadySent = scd.hasSentGameList();
        boolean bl = cliVersionChange = alreadySent && cliVers > prevVers;
        if (alreadySent && !cliVersionChange) {
            this.releaseMonitor();
            return;
        }
        if (!alreadySent) {
            scd.setSentGameList();
        }
        Collection<SOCGame> gaEnum = this.getGamesData();
        this.releaseMonitor();
        if (cliVersionChange && cliCouldKnow) {
            cliCanKnow = false;
        }
        try {
            for (SOCGame g : gaEnum) {
                boolean canJoin;
                int n = g.getClientVersionMinRequired();
                if (cliVersionChange && prevVers >= n) continue;
                boolean bl2 = canJoin = cliVers >= n && (cliNotLimitedFeats || g.canClientJoin(cliLimitedFeats));
                if (canJoin || cliGetsUnjoinableWithOpts) {
                    if (!canJoin) {
                        gl.add(Boolean.FALSE);
                    }
                    gl.add(g);
                    continue;
                }
                if (!cliCanKnow) continue;
                StringBuffer sb = new StringBuffer();
                sb.append('?');
                sb.append(g.getName());
                gl.add(sb.toString());
            }
            if (!alreadySent) {
                c.put(cliVers >= 1107 ? new SOCGamesWithOptions(gl, cliVers) : new SOCGames(gl));
            } else {
                boolean isJoinable = true;
                for (Object e : gl) {
                    String gaName;
                    if (e instanceof Boolean) {
                        isJoinable = (Boolean)e;
                        continue;
                    }
                    if (e instanceof SOCGame) {
                        gaName = ((SOCGame)e).getName();
                        if (!isJoinable) {
                            gaName = '?' + gaName;
                        }
                    } else {
                        gaName = (String)e;
                    }
                    if (cliCouldKnow) {
                        c.put(new SOCDeleteGame(gaName));
                    }
                    if (e instanceof SOCGame && cliVers >= 1107) {
                        c.put(new SOCNewGameWithOptions((SOCGame)e, cliVers, isJoinable));
                    } else {
                        c.put(new SOCNewGame(gaName));
                    }
                    if (isJoinable) continue;
                    isJoinable = true;
                }
            }
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception in GLAS.sendGameList");
        }
    }

    protected class GameInfoAtServer
    extends SOCGameList.GameInfo {
        public final GameHandler handler;
        public final GameMessageHandler messageHandler;

        public GameInfoAtServer(SOCGameOptionSet gameOpts, GameHandler typeHandler) throws IllegalArgumentException {
            super((SOCGameList)SOCGameListAtServer.this, true, gameOpts);
            if (typeHandler == null) {
                throw new IllegalArgumentException("handler");
            }
            this.handler = typeHandler;
            this.messageHandler = this.handler.getMessageHandler();
        }
    }
}

