/*
 * Decompiled with CFR 0.152.
 */
package soc.server;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import soc.debug.D;
import soc.game.GameAction;
import soc.game.ResourceSet;
import soc.game.SOCBoard;
import soc.game.SOCBoardLarge;
import soc.game.SOCCity;
import soc.game.SOCDevCard;
import soc.game.SOCFortress;
import soc.game.SOCGame;
import soc.game.SOCInventoryItem;
import soc.game.SOCMoveRobberResult;
import soc.game.SOCPlayer;
import soc.game.SOCPlayingPiece;
import soc.game.SOCResourceSet;
import soc.game.SOCRoad;
import soc.game.SOCSettlement;
import soc.game.SOCShip;
import soc.game.SOCSpecialItem;
import soc.game.SOCTradeOffer;
import soc.game.SOCVillage;
import soc.message.SOCAcceptOffer;
import soc.message.SOCBankTrade;
import soc.message.SOCBuildRequest;
import soc.message.SOCBuyDevCardRequest;
import soc.message.SOCCancelBuildRequest;
import soc.message.SOCChoosePlayer;
import soc.message.SOCClearOffer;
import soc.message.SOCClearTradeMsg;
import soc.message.SOCDebugFreePlace;
import soc.message.SOCDevCardAction;
import soc.message.SOCDevCardCount;
import soc.message.SOCDiceResult;
import soc.message.SOCDiceResultResources;
import soc.message.SOCDiscard;
import soc.message.SOCDiscardRequest;
import soc.message.SOCEndTurn;
import soc.message.SOCGameElements;
import soc.message.SOCGameServerText;
import soc.message.SOCGameState;
import soc.message.SOCGameStats;
import soc.message.SOCGameTextMsg;
import soc.message.SOCInventoryItemAction;
import soc.message.SOCLargestArmy;
import soc.message.SOCLongestRoad;
import soc.message.SOCMakeOffer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;
import soc.message.SOCMovePiece;
import soc.message.SOCMoveRobber;
import soc.message.SOCPickResourceType;
import soc.message.SOCPickResources;
import soc.message.SOCPieceValue;
import soc.message.SOCPlayDevCardRequest;
import soc.message.SOCPlayerElement;
import soc.message.SOCPlayerElements;
import soc.message.SOCPutPiece;
import soc.message.SOCRejectOffer;
import soc.message.SOCRemovePiece;
import soc.message.SOCResourceCount;
import soc.message.SOCRobberyResult;
import soc.message.SOCRollDice;
import soc.message.SOCSetPlayedDevCard;
import soc.message.SOCSetShipRouteClosed;
import soc.message.SOCSetSpecialItem;
import soc.message.SOCSimpleAction;
import soc.message.SOCSimpleRequest;
import soc.message.SOCUndoPutPiece;
import soc.server.GameMessageHandler;
import soc.server.SOCClientData;
import soc.server.SOCGameHandler;
import soc.server.SOCServer;
import soc.server.genericServer.Connection;
import soc.util.SOCStringManager;

public class SOCGameMessageHandler
implements GameMessageHandler {
    private final SOCServer srv;
    private final SOCGameHandler handler;

    public SOCGameMessageHandler(SOCServer srv, SOCGameHandler sgh) {
        this.srv = srv;
        this.handler = sgh;
    }

    @Override
    public boolean dispatch(SOCGame game, SOCMessageForGame message, Connection connection) throws Exception {
        switch (message.getType()) {
            case 1009: {
                this.handlePUTPIECE(game, connection, (SOCPutPiece)message);
                break;
            }
            case 1034: {
                this.handleMOVEROBBER(game, connection, (SOCMoveRobber)message);
                break;
            }
            case 1031: {
                this.handleROLLDICE(game, connection, (SOCRollDice)message);
                break;
            }
            case 1033: {
                this.handleDISCARD(game, connection, (SOCDiscard)message);
                break;
            }
            case 1032: {
                this.handleENDTURN(game, connection, (SOCEndTurn)message);
                break;
            }
            case 1035: {
                this.handleCHOOSEPLAYER(game, connection, (SOCChoosePlayer)message);
                break;
            }
            case 1041: {
                this.handleMAKEOFFER(game, connection, (SOCMakeOffer)message);
                break;
            }
            case 1038: {
                this.handleCLEAROFFER(game, connection, (SOCClearOffer)message);
                break;
            }
            case 1037: {
                this.handleREJECTOFFER(game, connection, (SOCRejectOffer)message);
                break;
            }
            case 1039: {
                this.handleACCEPTOFFER(game, connection, (SOCAcceptOffer)message);
                break;
            }
            case 1040: {
                this.handleBANKTRADE(game, connection, (SOCBankTrade)message);
                break;
            }
            case 1043: {
                this.handleBUILDREQUEST(game, connection, (SOCBuildRequest)message);
                break;
            }
            case 1044: {
                this.handleCANCELBUILDREQUEST(game, connection, (SOCCancelBuildRequest)message);
                break;
            }
            case 1045: {
                this.handleBUYDEVCARDREQUEST(game, connection, (SOCBuyDevCardRequest)message);
                break;
            }
            case 1049: {
                this.handlePLAYDEVCARDREQUEST(game, connection, (SOCPlayDevCardRequest)message);
                break;
            }
            case 1052: {
                this.handlePICKRESOURCES(game, connection, (SOCPickResources)message);
                break;
            }
            case 1053: {
                this.handlePICKRESOURCETYPE(game, connection, (SOCPickResourceType)message);
                break;
            }
            case 1087: {
                this.handleDEBUGFREEPLACE(game, connection, (SOCDebugFreePlace)message);
                break;
            }
            case 1089: {
                this.handleSIMPLEREQUEST(game, connection, (SOCSimpleRequest)message);
                break;
            }
            case 1098: {
                this.handleINVENTORYITEMACTION(game, connection, (SOCInventoryItemAction)message);
                break;
            }
            case 1093: {
                this.handleMOVEPIECE(game, connection, (SOCMovePiece)message);
                break;
            }
            case 1099: {
                this.handleSETSPECIALITEM(game, connection, (SOCSetSpecialItem)message);
                break;
            }
            case 1061: {
                this.handleGAMESTATS(game, connection, (SOCGameStats)message);
                break;
            }
            case 1105: {
                this.handleUNDOPUTPIECE(game, connection, (SOCUndoPutPiece)message);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleROLLDICE(SOCGame ga, Connection c, SOCRollDice mes) {
        String gn = ga.getName();
        ga.takeMonitor();
        try {
            SOCPlayer pp;
            int pn;
            String plName = c.getData();
            SOCPlayer pl = ga.getPlayer(plName);
            if (pl == null || !ga.canRollDice(pl.getPlayerNumber())) {
                this.srv.messageToPlayerKeyed(c, gn, pl != null ? pl.getPlayerNumber() : -257, "reply.rolldice.cannot.now");
                return;
            }
            SOCGame.RollResult roll = ga.rollDice();
            this.srv.messageToGame(gn, true, new SOCDiceResult(gn, ga.getCurrentDice()));
            if (ga.clientVersionLowest < 2000) {
                this.srv.messageToGameForVersions(ga, 0, 1999, new SOCGameTextMsg(gn, "Server", plName + " rolled a " + roll.diceA + " and a " + roll.diceB + "."), true);
            }
            boolean someoneWonFreeRsrc = false;
            if (ga.isGameOptionSet("_SC_PIRI")) {
                this.srv.messageToGame(gn, true, new SOCMoveRobber(gn, ga.getCurrentPlayerNumber(), -((SOCBoardLarge)ga.getBoard()).getPirateHex()));
                if (roll.sc_piri_fleetAttackVictim != null) {
                    SOCRobberyResult wonMsg;
                    int lootTotal;
                    SOCPlayer vic = roll.sc_piri_fleetAttackVictim;
                    int vpn = vic.getPlayerNumber();
                    String vicName = vic.getName();
                    int strength = roll.diceA < roll.diceB ? roll.diceA : roll.diceB;
                    SOCResourceSet loot = roll.sc_piri_fleetAttackRsrcs;
                    int n = lootTotal = loot != null ? loot.getTotal() : 0;
                    if (lootTotal == 0) {
                        wonMsg = new SOCRobberyResult(gn, -1, vpn, 0, true, 0, 0, strength);
                        if (ga.clientVersionLowest >= 2500) {
                            this.srv.messageToGame(gn, true, wonMsg);
                        } else {
                            this.srv.messageToGameForVersions(ga, 2500, Integer.MAX_VALUE, wonMsg, true);
                            this.srv.messageToGameForVersionsKeyed(ga, -1, 2499, true, false, "action.rolled.sc_piri.player.tied", vicName, strength);
                            this.srv.recordGameEvent(gn, wonMsg);
                        }
                    } else if (loot.contains(6)) {
                        someoneWonFreeRsrc = true;
                        wonMsg = new SOCRobberyResult(gn, -1, vpn, 6, true, 0, 0, strength);
                        if (ga.clientVersionLowest >= 2500) {
                            this.srv.messageToGame(gn, true, wonMsg);
                        } else {
                            this.srv.messageToGameForVersions(ga, 2500, Integer.MAX_VALUE, wonMsg, true);
                            this.srv.messageToGameForVersionsKeyed(ga, -1, 2499, true, false, "action.rolled.sc_piri.player.won.pick.free", vicName, strength);
                            this.srv.recordGameEvent(gn, wonMsg);
                        }
                    } else {
                        int vVersion;
                        SOCRobberyResult reportDetails = new SOCRobberyResult(gn, -1, vpn, loot, strength);
                        SOCRobberyResult reportUnknown = new SOCRobberyResult(gn, -1, vpn, 6, true, lootTotal, 0, strength);
                        Connection vCon = this.srv.getConnection(vicName);
                        int n2 = vVersion = vCon != null ? vCon.getVersion() : 0;
                        if (ga.clientVersionLowest >= 2500) {
                            if (ga.isGameOptionSet("PLAY_FO")) {
                                this.srv.messageToGame(gn, true, reportDetails);
                            } else {
                                this.srv.messageToPlayer(vCon, gn, vpn, reportDetails);
                                this.srv.messageToGameExcept(gn, vCon, vpn, (SOCMessage)reportUnknown, true);
                            }
                        } else {
                            if (ga.isGameOptionSet("PLAY_FO")) {
                                this.srv.recordGameEvent(gn, reportDetails);
                                this.srv.messageToGameForVersions(ga, 2500, Integer.MAX_VALUE, reportDetails, true);
                                this.handler.reportRsrcGainLossForVersions(ga, loot, true, true, vpn, -1, null, 2499);
                                if (vVersion < 2500) {
                                    this.srv.messageToPlayerKeyedSpecial(vCon, ga, -256, "action.rolled.sc_piri.you.lost.rsrcs.to.fleet", loot, strength);
                                }
                            } else {
                                if (vVersion >= 2500) {
                                    this.srv.messageToPlayer(vCon, gn, vpn, reportDetails);
                                } else {
                                    this.srv.recordGameEventTo(gn, vpn, reportDetails);
                                    this.handler.reportRsrcGainLossForVersions(ga, loot, true, true, vpn, -1, vCon, 2499);
                                    this.srv.messageToPlayerKeyedSpecial(vCon, ga, -256, "action.rolled.sc_piri.you.lost.rsrcs.to.fleet", loot, strength);
                                }
                                this.srv.recordGameEventNotTo(gn, vpn, (SOCMessage)reportUnknown);
                                this.srv.messageToGameForVersionsExcept(ga, 2500, Integer.MAX_VALUE, vCon, (SOCMessage)reportUnknown, true);
                                this.srv.messageToGameForVersionsExcept(ga, -1, 2499, vCon, (SOCMessage)new SOCPlayerElement(gn, vpn, 102, SOCPlayerElement.PEType.UNKNOWN_RESOURCE, lootTotal), true);
                            }
                            this.srv.messageToGameForVersionsKeyedExcept(ga, -1, 2499, true, Arrays.asList(vCon), false, "action.rolled.sc_piri.player.lost.rsrcs.to.fleet", vicName, lootTotal, strength);
                        }
                    }
                }
            }
            if (ga.getCurrentDice() != 7) {
                boolean noPlayersGained = true;
                String rollRsrcTxtToV1 = null;
                SOCDiceResultResources rollRsrcMsg = null;
                if (ga.clientVersionHighest >= 2000 || this.srv.isRecordGameEventsActive()) {
                    rollRsrcMsg = SOCDiceResultResources.buildForGame(ga);
                    boolean bl = noPlayersGained = rollRsrcMsg == null;
                }
                if (ga.clientVersionLowest < 2000) {
                    StringBuffer gainsText = new StringBuffer();
                    noPlayersGained = true;
                    for (int pn2 = 0; pn2 < ga.maxPlayers; ++pn2) {
                        SOCPlayer pp2;
                        SOCResourceSet rsrcs;
                        if (ga.isSeatVacant(pn2) || (rsrcs = (pp2 = ga.getPlayer(pn2)).getRolledResources()).getKnownTotal() == 0) continue;
                        if (noPlayersGained) {
                            noPlayersGained = false;
                        } else {
                            gainsText.append(" ");
                        }
                        gainsText.append(c.getLocalizedSpecial(ga, "_nolocaliz.roll.gets.resources", pp2.getName(), rsrcs));
                        this.handler.reportRsrcGainLossForVersions(ga, rsrcs, false, true, pn2, -1, null, 1999);
                    }
                    if (!noPlayersGained) {
                        rollRsrcTxtToV1 = gainsText.toString();
                    }
                }
                if (noPlayersGained) {
                    String key = roll.cloth == null ? (someoneWonFreeRsrc ? "action.rolled.no_other_player_gets.anything" : "action.rolled.no_player_gets.anything") : (someoneWonFreeRsrc ? "action.rolled.no_other_player_gets.resources" : "action.rolled.no_player_gets.resources");
                    this.srv.messageToGameKeyed(ga, true, true, key);
                } else {
                    if (rollRsrcTxtToV1 == null) {
                        this.srv.messageToGame(gn, true, rollRsrcMsg);
                    } else if (rollRsrcMsg == null) {
                        this.srv.messageToGame(gn, true, rollRsrcTxtToV1);
                    } else {
                        this.srv.messageToGameForVersions(ga, 0, 1999, new SOCGameTextMsg(gn, "Server", rollRsrcTxtToV1), true);
                        this.srv.messageToGameForVersions(ga, 2000, Integer.MAX_VALUE, rollRsrcMsg, true);
                        this.srv.recordGameEvent(gn, rollRsrcMsg);
                    }
                    for (pn = 0; pn < ga.maxPlayers; ++pn) {
                        Connection playerCon;
                        pp = ga.getPlayer(pn);
                        if (pp.getRolledResources().getKnownTotal() == 0 || (playerCon = this.srv.getConnection(pp.getName())) == null) continue;
                        SOCResourceSet resources = pp.getResources();
                        int[] counts = resources.getAmounts(false);
                        if (playerCon.getVersion() >= 2000) {
                            this.srv.messageToPlayer(playerCon, gn, pn, new SOCPlayerElements(gn, pn, 100, SOCGameHandler.ELEM_RESOURCES, counts));
                        } else {
                            for (int i = 0; i < counts.length; ++i) {
                                this.srv.messageToPlayer(playerCon, null, -256, new SOCPlayerElement(gn, pn, 100, SOCGameHandler.ELEM_RESOURCES[i], counts[i]));
                            }
                            if (this.srv.isRecordGameEventsActive()) {
                                this.srv.recordGameEventTo(gn, pn, new SOCPlayerElements(gn, pn, 100, SOCGameHandler.ELEM_RESOURCES, counts));
                            }
                        }
                        if (ga.clientVersionLowest >= 2000) continue;
                        this.srv.messageToGameForVersions(ga, -1, 1999, new SOCResourceCount(gn, pn, resources.getTotal()), true);
                    }
                }
                if (roll.cloth != null) {
                    if (roll.clothVillages != null) {
                        for (SOCVillage vi : roll.clothVillages) {
                            this.srv.messageToGame(gn, true, new SOCPieceValue(gn, 5, vi.getCoordinates(), vi.getCloth(), 0));
                        }
                    }
                    if (roll.cloth[0] > 0) {
                        this.srv.messageToGame(gn, true, new SOCPlayerElement(gn, -1, 100, SOCPlayerElement.PEType.SCENARIO_CLOTH_COUNT, ((SOCBoardLarge)ga.getBoard()).getCloth()));
                    }
                    String clplName = null;
                    int clplAmount = 0;
                    ArrayList<String> clpls = null;
                    for (int i = 1; i < roll.cloth.length; ++i) {
                        if (roll.cloth[i] == 0) continue;
                        int pn3 = i - 1;
                        SOCPlayer clpl = ga.getPlayer(pn3);
                        this.srv.messageToGame(gn, true, new SOCPlayerElement(gn, pn3, 100, SOCPlayerElement.PEType.SCENARIO_CLOTH_COUNT, clpl.getCloth()));
                        if (clplName == null) {
                            clplName = clpl.getName();
                            clplAmount = roll.cloth[i];
                            continue;
                        }
                        if (clpls == null) {
                            clpls = new ArrayList<String>();
                            clpls.add(clplName);
                        }
                        clpls.add(clpl.getName());
                    }
                    if (clpls == null) {
                        this.srv.messageToGameKeyed(ga, true, true, "action.rolled.sc_clvi.received.cloth.1", clplName, clplAmount);
                    } else {
                        this.srv.messageToGameKeyedSpecial(ga, true, true, "action.rolled.sc_clvi.received.cloth.n", clpls);
                    }
                }
                if (ga.getGameState() == 56) {
                    this.handler.sendGameState_sendGoldPickAnnounceText(ga, gn, null, roll);
                }
                this.handler.sendGameState(ga);
            } else {
                int newGameState = ga.getGameState();
                int[] goldPicks = null;
                Connection[] goldPickPlayerClis = null;
                if (newGameState == 56) {
                    goldPicks = new int[ga.maxPlayers];
                    goldPickPlayerClis = new Connection[ga.maxPlayers];
                    for (pn = 0; pn < ga.maxPlayers; ++pn) {
                        pp = ga.getPlayer(pn);
                        int numPick = pp.getNeedToPickGoldHexResources();
                        if (ga.isSeatVacant(pn) || numPick <= 0) continue;
                        this.srv.messageToGame(gn, true, new SOCPlayerElement(gn, pn, 100, SOCPlayerElement.PEType.NUM_PICK_GOLD_HEX_RESOURCES, numPick));
                        goldPicks[pn] = numPick;
                        goldPickPlayerClis[pn] = this.srv.getConnection(pp.getName());
                    }
                }
                this.handler.sendGameState(ga);
                if (newGameState == 50) {
                    this.handler.sendGameState_sendDiscardRequests(ga, gn);
                } else if (goldPickPlayerClis != null) {
                    for (pn = 0; pn < ga.maxPlayers; ++pn) {
                        Connection con = goldPickPlayerClis[pn];
                        if (con == null) continue;
                        this.srv.messageToPlayer(con, gn, pn, new SOCSimpleRequest(gn, pn, 1, goldPicks[pn], 0));
                    }
                }
            }
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception caught at handleROLLDICE" + e);
        }
        finally {
            ga.releaseMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDISCARD(SOCGame ga, Connection c, SOCDiscard mes) {
        String gn = ga.getName();
        SOCPlayer player = ga.getPlayer(c.getData());
        int pn = player != null ? player.getPlayerNumber() : -1;
        ga.takeMonitor();
        try {
            if (player == null) {
                throw new IllegalArgumentException("player not found in game");
            }
            ResourceSet res = mes.getResources();
            if (ga.canDiscard(pn, res)) {
                ga.discard(pn, res);
                boolean cliVersionsSendDiscard = ga.clientVersionHighest >= 2500;
                SOCDiscard disMsg = cliVersionsSendDiscard || this.srv.isRecordGameEventsActive() ? new SOCDiscard(gn, pn, res) : null;
                int numRes = res.getTotal();
                if (ga.isGameOptionSet("PLAY_FO")) {
                    if (ga.clientVersionLowest >= 2500) {
                        this.srv.messageToGame(gn, true, disMsg);
                    } else {
                        this.srv.recordGameEvent(gn, disMsg);
                        this.srv.messageToGameForVersions(ga, 2500, Integer.MAX_VALUE, disMsg, true);
                        this.handler.reportRsrcGainLossForVersions(ga, res, true, false, pn, -1, null, 2499);
                    }
                } else {
                    SOCDiscard disUnknownMsg;
                    SOCDiscard sOCDiscard = disUnknownMsg = cliVersionsSendDiscard || this.srv.isRecordGameEventsActive() ? new SOCDiscard(gn, pn, 0, 0, 0, 0, 0, numRes) : null;
                    if (c.getVersion() >= 2500) {
                        this.srv.messageToPlayer(c, gn, pn, disMsg);
                    } else {
                        this.srv.recordGameEventTo(gn, pn, disMsg);
                        this.handler.reportRsrcGainLossForVersions(ga, res, true, false, pn, -1, c, 2499);
                    }
                    if (ga.clientVersionLowest >= 2500) {
                        this.srv.messageToGameExcept(gn, c, pn, (SOCMessage)disUnknownMsg, true);
                    } else {
                        this.srv.recordGameEventNotTo(gn, pn, (SOCMessage)disUnknownMsg);
                        this.srv.messageToGameForVersionsExcept(ga, 2500, Integer.MAX_VALUE, c, (SOCMessage)disUnknownMsg, true);
                        this.srv.messageToGameForVersionsExcept(ga, -1, 2499, c, (SOCMessage)new SOCPlayerElement(gn, pn, 102, SOCPlayerElement.PEType.UNKNOWN_RESOURCE, numRes, true), true);
                    }
                }
                this.srv.messageToGameForVersionsKeyed(ga, -1, 2499, true, false, "action.discarded.total.common", player.getName(), numRes);
                int gstate = ga.getGameState();
                if (gstate != 20 || !ga.isForcingEndTurn()) {
                    if (gstate == 50) {
                        SOCGameState gstateMsg = new SOCGameState(gn, gstate);
                        if (ga.clientVersionLowest >= 2500) {
                            this.srv.messageToGame(gn, true, gstateMsg);
                        } else {
                            this.srv.recordGameEvent(gn, gstateMsg);
                            this.srv.messageToGameForVersions(ga, 2500, Integer.MAX_VALUE, gstateMsg, true);
                        }
                        this.handler.sendGameState(ga, true, false, false);
                    } else {
                        this.handler.sendGameState(ga);
                    }
                } else {
                    this.handler.endGameTurn(ga, player, true);
                }
            } else {
                this.srv.messageToPlayer(c, gn, pn, "You can't discard that many cards.");
                int n = player.getCountToDiscard();
                if (n > 0 && !player.hasAskedDiscardTwiceThisTurn()) {
                    player.setAskedDiscardTwiceThisTurn();
                    this.srv.messageToPlayer(c, gn, pn, new SOCDiscardRequest(gn, n));
                }
            }
        }
        catch (Throwable e) {
            D.ebugPrintStackTrace(e, "Exception caught");
        }
        finally {
            ga.releaseMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMOVEROBBER(SOCGame ga, Connection c, SOCMoveRobber mes) {
        ga.takeMonitor();
        try {
            boolean canDo;
            SOCPlayer player = ga.getPlayer(c.getData());
            if (player == null) {
                return;
            }
            String gaName = ga.getName();
            boolean isPirate = ga.getRobberyPirateFlag();
            int pn = player.getPlayerNumber();
            if (pn != ga.getCurrentPlayerNumber()) {
                this.handler.sendDecline(c, ga, false, pn, 2, 0, 0, null, new Object[0]);
                return;
            }
            int coord = mes.getCoordinates();
            boolean bl = isPirate == coord < 0 && (isPirate ? ga.canMovePirate(pn, -coord) : ga.canMoveRobber(pn, coord)) ? true : (canDo = false);
            if (canDo) {
                SOCMoveRobber moveMsg;
                SOCMoveRobberResult result;
                if (isPirate) {
                    result = ga.movePirate(pn, -coord);
                    moveMsg = new SOCMoveRobber(gaName, pn, coord);
                } else {
                    result = ga.moveRobber(pn, coord);
                    moveMsg = new SOCMoveRobber(gaName, pn, coord);
                }
                this.srv.messageToGame(gaName, true, moveMsg);
                List<SOCPlayer> victims = result.getVictims();
                if (victims.size() == 1 && ga.getGameState() != 55) {
                    SOCPlayer victim = victims.get(0);
                    this.handler.reportRobbery(ga, player, victim, result.getLoot());
                } else {
                    String msgKey = victims.size() == 0 ? "robberpirate.moved" : (ga.getGameState() == 55 ? "robberpirate.moved.choose.cloth.rsrcs" : "robberpirate.moved.choose.victim");
                    this.srv.messageToGameKeyed(ga, true, true, msgKey, player.getName(), isPirate ? 2 : 1);
                }
                this.handler.sendGameState(ga);
                if (ga.getGameState() == 55) {
                    int vpn = victims.get(0).getPlayerNumber();
                    this.srv.messageToPlayer(c, gaName, pn, new SOCChoosePlayer(gaName, vpn));
                }
            } else {
                this.handler.sendDecline(c, ga, true, pn, 3, 0, 0, coord < 0 ? "robber.cantmove.pirate" : "robber.cantmove", new Object[0]);
            }
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception caught");
        }
        finally {
            ga.releaseMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCHOOSEPLAYER(SOCGame ga, Connection c, SOCChoosePlayer mes) {
        block20: {
            ga.takeMonitor();
            try {
                String gaName = ga.getName();
                if (this.handler.checkTurn(c, ga)) {
                    int choice = mes.getChoice();
                    switch (ga.getGameState()) {
                        case 54: {
                            ga.chooseMovePirate(choice == -3);
                            this.handler.sendGameState(ga);
                            break;
                        }
                        case 51: {
                            if (choice == -1 && ga.canChoosePlayer(-1)) {
                                ga.choosePlayerForRobbery(-1);
                                this.srv.messageToGameKeyed(ga, true, true, "robber.declined", c.getData());
                                this.handler.sendGameState(ga);
                                break;
                            }
                            if (ga.canChoosePlayer(choice)) {
                                boolean waitingClothOrRsrc;
                                int rsrc = ga.choosePlayerForRobbery(choice);
                                boolean bl = waitingClothOrRsrc = ga.getGameState() == 55;
                                if (!waitingClothOrRsrc) {
                                    this.handler.reportRobbery(ga, ga.getPlayer(c.getData()), ga.getPlayer(choice), rsrc);
                                } else {
                                    this.srv.messageToGameKeyed(ga, true, true, "robber.moved.choose.cloth.rsrcs", c.getData(), ga.getPlayer(choice).getName());
                                }
                                this.handler.sendGameState(ga);
                                if (waitingClothOrRsrc) {
                                    this.srv.messageToPlayer(c, gaName, ga.getCurrentPlayerNumber(), new SOCChoosePlayer(gaName, choice));
                                    break;
                                }
                                break block20;
                            }
                            this.srv.messageToPlayerKeyed(c, gaName, ga.getCurrentPlayerNumber(), "robber.cantsteal");
                            this.handler.sendGameState(ga, true, true, false);
                            break;
                        }
                        case 55: {
                            int pn;
                            boolean stealCloth;
                            if (choice < 0) {
                                stealCloth = true;
                                pn = -choice - 1;
                            } else {
                                stealCloth = false;
                                pn = choice;
                            }
                            if (ga.canChoosePlayer(pn) && ga.canChooseRobClothOrResource(pn)) {
                                int rsrc = ga.stealFromPlayer(pn, stealCloth);
                                this.handler.reportRobbery(ga, ga.getPlayer(c.getData()), ga.getPlayer(pn), rsrc);
                                this.handler.sendGameState(ga);
                                break;
                            }
                            List<SOCPlayer> victims = ga.getPossibleVictims();
                            if (victims != null && victims.size() == 1) {
                                int vpn = victims.get(0).getPlayerNumber();
                                this.srv.messageToPlayer(c, gaName, ga.getCurrentPlayerNumber(), new SOCChoosePlayer(gaName, vpn));
                                break;
                            }
                        }
                        default: {
                            this.handler.sendDecline(c, ga, true, ga.getCurrentPlayerNumber(), 3, 0, 0, "robber.cantsteal", new Object[0]);
                        }
                    }
                    break block20;
                }
                this.handler.sendDecline(c, ga, false, -258, 2, 0, 0, null, new Object[0]);
            }
            catch (Throwable e) {
                D.ebugPrintStackTrace(e, "Exception caught");
            }
            finally {
                ga.releaseMonitor();
            }
        }
    }

    List<SOCMessage> sendUndoSideEffects(SOCGame ga, GameAction actToUndo, int pieceType) {
        if (actToUndo.effects == null) {
            return null;
        }
        ArrayList<SOCMessage> msgsAfter = new ArrayList<SOCMessage>();
        String gaName = ga.getName();
        int cpn = ga.getCurrentPlayerNumber();
        int gameStateAfterUndo = 0;
        block21: for (GameAction.Effect e : actToUndo.effects) {
            switch (e.eType) {
                case DEDUCT_COST_FROM_PLAYER: {
                    SOCResourceSet cost = null;
                    if (e.params != null) {
                        cost = new SOCResourceSet(e.params);
                    } else {
                        try {
                            cost = SOCPlayingPiece.getResourcesToBuild(pieceType);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    if (cost == null) continue block21;
                    msgsAfter.add(new SOCPlayerElements(gaName, cpn, 101, cost));
                    break;
                }
                case CHANGE_GAMESTATE: {
                    gameStateAfterUndo = e.params[0];
                    break;
                }
                case CHANGE_LONGEST_ROAD_PLAYER: {
                    msgsAfter.add(new SOCLongestRoad(gaName, e.params[0]));
                    break;
                }
                case PLAYER_GAIN_SVP: {
                    int prevSVP = e.params[0];
                    int prevEvents = 0;
                    boolean sendPrevEvents = false;
                    if (e.params.length >= 4) {
                        prevEvents = e.params[2];
                        int effectEventFlag = e.params[3];
                        boolean bl = sendPrevEvents = 0 == (prevEvents & effectEventFlag);
                    }
                    if (sendPrevEvents) {
                        msgsAfter.add(new SOCPlayerElements(gaName, cpn, 100, new SOCPlayerElement.PEType[]{SOCPlayerElement.PEType.SCENARIO_SVP, SOCPlayerElement.PEType.PLAYEREVENTS_BITMASK}, new int[]{prevSVP, prevEvents}));
                        break;
                    }
                    msgsAfter.add(new SOCPlayerElement(gaName, cpn, 100, SOCPlayerElement.PEType.SCENARIO_SVP, prevSVP));
                    break;
                }
                case PLAYER_GAIN_SETTLED_LANDAREA: {
                    msgsAfter.add(new SOCPlayerElements(gaName, cpn, 100, new SOCPlayerElement.PEType[]{SOCPlayerElement.PEType.SCENARIO_SVP, SOCPlayerElement.PEType.SCENARIO_SVP_LANDAREAS_BITMASK}, new int[]{e.params[0], e.params[1]}));
                    break;
                }
                case GAME_SET_HAS_BUILT_CITY_N7C: {
                    msgsAfter.add(new SOCGameElements(gaName, SOCGameElements.GEType.HAS_BUILT_CITY_N7C, 0));
                    break;
                }
                case CLOSE_SHIP_ROUTE: {
                    this.srv.messageToGame(gaName, true, new SOCSetShipRouteClosed(gaName, false, e.params));
                    break;
                }
                case PLAYER_SET_EVENT_FLAGS: {
                    msgsAfter.add(new SOCPlayerElement(gaName, cpn, 100, SOCPlayerElement.PEType.PLAYEREVENTS_BITMASK, ga.getPlayer(cpn).getPlayerEvents()));
                    break;
                }
                case PLAYER_GAIN_INVENTORY_ITEM: {
                    msgsAfter.add(new SOCInventoryItemAction(gaName, cpn, e.params[1] == 1 ? 8 : 9, e.params[0], e.params[2] == 1, e.params[3] == 1, e.params[4] == 1));
                    break;
                }
                case PLAYER_SCEN_CLVI_RECEIVE_CLOTH: {
                    msgsAfter.add(new SOCPlayerElement(gaName, cpn, 100, SOCPlayerElement.PEType.SCENARIO_CLOTH_COUNT, ga.getPlayer(cpn).getCloth()));
                    SOCBoardLarge board = (SOCBoardLarge)ga.getBoard();
                    int villageNodeCoord = e.params[1];
                    if (villageNodeCoord != 0) {
                        SOCVillage vi = board.getVillageAtNode(villageNodeCoord);
                        if (vi == null) continue block21;
                        msgsAfter.add(new SOCPieceValue(gaName, 5, villageNodeCoord, vi.getCloth(), 0));
                        if (e.params[2] == 0) continue block21;
                        msgsAfter.add(new SOCSimpleAction(gaName, cpn, 1003, villageNodeCoord));
                        break;
                    }
                    msgsAfter.add(new SOCPlayerElement(gaName, -1, 100, SOCPlayerElement.PEType.SCENARIO_CLOTH_COUNT, board.getCloth()));
                    break;
                }
                case PLAYER_SCEN_FTRI_REACHED_SPECIAL_EDGE: {
                    SOCPlayer cp = ga.getPlayer(cpn);
                    int edgeCoord = e.params[0];
                    int seType = e.params[1];
                    switch (seType) {
                        case 2: {
                            msgsAfter.add(new SOCPlayerElement(gaName, cpn, 100, SOCPlayerElement.PEType.SCENARIO_SVP, cp.getSpecialVP()));
                            break;
                        }
                        case 1: {
                            msgsAfter.add(new SOCDevCardAction(gaName, cpn, 5, e.params[2]));
                        }
                    }
                    msgsAfter.add(new SOCSimpleAction(gaName, -1, 4, edgeCoord, seType));
                    break;
                }
                case GAME_SCEN_FTRI_PORT_REMOVED: {
                    msgsAfter.add(new SOCSimpleRequest(gaName, cpn, 1001, e.params[0], e.params[1]));
                    break;
                }
                case GAME_SCEN_FTRI_PORT_PLACED: {
                    msgsAfter.add(new SOCSimpleAction(gaName, cpn, 1002, e.params[0], e.params[1]));
                    break;
                }
            }
        }
        if (gameStateAfterUndo > 0) {
            msgsAfter.add(new SOCGameState(gaName, gameStateAfterUndo));
        }
        return msgsAfter.isEmpty() ? null : msgsAfter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleENDTURN(SOCGame ga, Connection c, SOCEndTurn mes) {
        String gname = ga.getName();
        if (ga.isDebugFreePlacement()) {
            this.handler.processDebugCommand_freePlace(c, ga, "0");
        }
        ga.takeMonitor();
        int gaState = ga.getGameState();
        try {
            String plName = c.getData();
            if (gaState == 1000) {
                SOCPlayer pl = ga.getPlayer(plName);
                if (pl != null) {
                    String msg = ga.gameOverMessageToPlayer(pl);
                    this.srv.messageToPlayer(c, gname, -258, msg);
                }
            } else if (this.handler.checkTurn(c, ga)) {
                int pn;
                SOCPlayer pl = ga.getPlayer(plName);
                int n = pn = pl != null ? pl.getPlayerNumber() : -1;
                if (ga.canEndTurn(pn)) {
                    this.handler.endGameTurn(ga, pl, true);
                } else {
                    this.srv.messageToPlayerKeyed(c, gname, pn, "reply.endturn.cannot");
                    this.srv.messageToPlayer(c, gname, pn, new SOCGameState(gname, gaState));
                }
            } else {
                this.srv.messageToPlayerKeyed(c, gname, -258, "base.reply.not.your.turn");
            }
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception caught at handleENDTURN");
        }
        finally {
            ga.releaseMonitor();
        }
    }

    private void handleSIMPLEREQUEST(SOCGame ga, Connection c, SOCSimpleRequest mes) {
        int clientPN;
        String gaName = ga.getName();
        SOCPlayer clientPl = ga.getPlayer(c.getData());
        if (clientPl == null) {
            return;
        }
        int pn = mes.getPlayerNumber();
        boolean clientIsPN = pn == (clientPN = clientPl.getPlayerNumber());
        int reqtype = mes.getRequestType();
        int cpn = ga.getCurrentPlayerNumber();
        boolean replyDecline = false;
        switch (reqtype) {
            case 1000: {
                SOCShip adjac = ga.canAttackPirateFortress();
                if (!clientIsPN || clientPN != cpn || adjac == null || adjac.getPlayerNumber() != cpn) {
                    this.srv.messageToPlayer(c, gaName, clientPN, new SOCSimpleRequest(gaName, -1, reqtype, 0, 0));
                    return;
                }
                int prevState = ga.getGameState();
                SOCPlayer cp = ga.getPlayer(cpn);
                int prevNumWarships = cp.getNumWarships();
                SOCFortress fort = cp.getFortress();
                int[] res = ga.attackPirateFortress(adjac);
                if (res.length > 1) {
                    int n;
                    this.srv.messageToGame(gaName, true, new SOCRemovePiece(gaName, adjac));
                    if (res.length > 2) {
                        this.srv.messageToGame(gaName, true, new SOCRemovePiece(gaName, cpn, 3, res[2]));
                    }
                    if ((n = cp.getNumWarships()) != prevNumWarships) {
                        this.srv.messageToGame(gaName, true, new SOCPlayerElement(gaName, cpn, 100, SOCPlayerElement.PEType.SCENARIO_WARSHIP_COUNT, n));
                    }
                } else {
                    int fortStrength = fort.getStrength();
                    this.srv.messageToGame(gaName, true, new SOCPieceValue(gaName, 4, fort.getCoordinates(), fortStrength, 0));
                    if (0 == fortStrength) {
                        this.srv.messageToGame(gaName, true, new SOCPutPiece(gaName, cpn, 1, fort.getCoordinates()));
                    }
                }
                this.srv.messageToGame(gaName, true, new SOCSimpleAction(gaName, cpn, 1001, res[0], res.length - 1));
                if (!this.handler.checkTurn(c, ga)) {
                    this.handler.endGameTurn(ga, cp, false);
                    break;
                }
                int gstate = ga.getGameState();
                if (gstate == prevState) break;
                this.handler.sendGameState(ga);
                break;
            }
            case 1001: {
                if (clientIsPN && clientPN == cpn) {
                    int edge = mes.getValue1();
                    if (ga.getGameState() == 42 && ga.canPlacePort(clientPl, edge)) {
                        int ptype = ga.placePort(edge);
                        this.handler.sendGameState(ga);
                        this.srv.messageToGame(gaName, true, new SOCSimpleRequest(gaName, cpn, 1001, edge, ptype));
                        break;
                    }
                    replyDecline = true;
                    break;
                }
                this.srv.messageToPlayerKeyed(c, gaName, clientPN, "base.reply.not.your.turn");
                replyDecline = true;
                break;
            }
            default: {
                replyDecline = true;
                System.err.println("handleSIMPLEREQUEST: Unknown type " + reqtype + " from " + c.getData() + " in game " + ga);
            }
        }
        if (replyDecline) {
            this.srv.messageToPlayer(c, gaName, clientPN, new SOCSimpleRequest(gaName, -1, reqtype, 0, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMAKEOFFER(SOCGame ga, Connection c, SOCMakeOffer mes) {
        String gaName = ga.getName();
        if (ga.isGameOptionSet("NT")) {
            this.srv.messageToPlayer(c, gaName, -258, "Trading is not allowed in this game.");
            return;
        }
        SOCTradeOffer offer = mes.getOffer();
        SOCPlayer player = ga.getPlayer(c.getData());
        if (player == null) {
            return;
        }
        try {
            ga.takeMonitor();
            SOCResourceSet giveSet = offer.getGiveSet();
            boolean canOffer = player.getResources().contains(giveSet);
            int cpn = ga.getCurrentPlayerNumber();
            if (canOffer && cpn != player.getPlayerNumber()) {
                boolean[] to = offer.getTo();
                for (int pn = 0; pn < to.length; ++pn) {
                    if (!to[pn] || pn == cpn) continue;
                    canOffer = false;
                    break;
                }
            }
            if (!canOffer) {
                int cliPN = player.getPlayerNumber();
                SOCMessage msg = c.getVersion() >= 2500 ? new SOCRejectOffer(gaName, cliPN, 3) : new SOCGameServerText(gaName, "You can't make that offer.");
                this.srv.messageToPlayer(c, gaName, cliPN, msg);
                return;
            }
            SOCTradeOffer remadeOffer = new SOCTradeOffer(gaName, player.getPlayerNumber(), offer.getTo(), giveSet, offer.getGetSet());
            player.setCurrentOffer(remadeOffer);
            this.handler.sendTradeOffer(player, null);
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception caught");
        }
        finally {
            ga.releaseMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCLEAROFFER(SOCGame ga, Connection c, SOCClearOffer mes) {
        ga.takeMonitor();
        try {
            String gaName = ga.getName();
            SOCPlayer pl = ga.getPlayer(c.getData());
            if (pl == null) {
                return;
            }
            pl.setCurrentOffer(null);
            this.srv.messageToGame(gaName, true, new SOCClearOffer(gaName, pl.getPlayerNumber()));
            this.srv.gameList.takeMonitorForGame(gaName);
            try {
                if (ga.clientVersionLowest >= 1112) {
                    this.srv.messageToGameWithMon(gaName, true, new SOCClearTradeMsg(gaName, -1));
                } else {
                    for (int i = 0; i < ga.maxPlayers; ++i) {
                        this.srv.messageToGameWithMon(gaName, false, new SOCClearTradeMsg(gaName, i));
                    }
                    if (this.srv.isRecordGameEventsActive()) {
                        this.srv.recordGameEvent(gaName, new SOCClearTradeMsg(gaName, -1));
                    }
                }
            }
            finally {
                this.srv.gameList.releaseMonitorForGame(gaName);
            }
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception caught");
        }
        finally {
            ga.releaseMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleREJECTOFFER(SOCGame ga, Connection c, SOCRejectOffer mes) {
        SOCPlayer player = ga.getPlayer(c.getData());
        if (player == null) {
            return;
        }
        int pn = player.getPlayerNumber();
        try {
            ga.takeMonitor();
            ga.rejectTradeOffersTo(pn);
        }
        finally {
            ga.releaseMonitor();
        }
        String gaName = ga.getName();
        this.srv.messageToGame(gaName, true, new SOCRejectOffer(gaName, pn));
    }

    private void handleACCEPTOFFER(SOCGame ga, Connection c, SOCAcceptOffer mes) {
        SOCPlayer player = ga.getPlayer(c.getData());
        if (player == null) {
            return;
        }
        this.executeTrade(ga, mes.getOfferingNumber(), player.getPlayerNumber(), c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTrade(SOCGame ga, int offeringNumber, int acceptingNumber, Connection c) {
        block16: {
            ga.takeMonitor();
            try {
                String gaName = ga.getName();
                if (ga.canMakeTrade(offeringNumber, acceptingNumber)) {
                    int i;
                    ga.makeTrade(offeringNumber, acceptingNumber);
                    this.handler.reportTrade(ga, offeringNumber, acceptingNumber);
                    for (i = 0; i < ga.maxPlayers; ++i) {
                        ga.getPlayer(i).setCurrentOffer(null);
                    }
                    try {
                        this.srv.gameList.takeMonitorForGame(gaName);
                        if (ga.clientVersionLowest >= 1109) {
                            this.srv.messageToGameWithMon(gaName, true, new SOCClearOffer(gaName, -1));
                        } else {
                            for (i = 0; i < ga.maxPlayers; ++i) {
                                this.srv.messageToGameWithMon(gaName, false, new SOCClearOffer(gaName, i));
                            }
                            if (this.srv.isRecordGameEventsActive()) {
                                this.srv.recordGameEvent(gaName, new SOCClearOffer(gaName, -1));
                            }
                        }
                        break block16;
                    }
                    finally {
                        this.srv.gameList.releaseMonitorForGame(gaName);
                    }
                }
                if (c.getVersion() >= 2500) {
                    this.srv.messageToPlayer(c, gaName, acceptingNumber, new SOCRejectOffer(gaName, acceptingNumber, 1));
                } else {
                    this.srv.messageToPlayerKeyed(c, gaName, acceptingNumber, "reply.common.trade.cannot_make");
                }
            }
            catch (Exception e) {
                D.ebugPrintStackTrace(e, "Exception caught");
            }
            finally {
                ga.releaseMonitor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBANKTRADE(SOCGame ga, Connection c, SOCBankTrade mes) {
        String gaName = ga.getName();
        SOCResourceSet give = mes.getGiveSet();
        SOCResourceSet get = mes.getGetSet();
        ga.takeMonitor();
        try {
            if (this.handler.checkTurn(c, ga)) {
                if (ga.canMakeBankTrade(give, get)) {
                    ga.makeBankTrade(give, get);
                    this.handler.reportBankTrade(ga, give, get);
                } else {
                    int pn = ga.getCurrentPlayerNumber();
                    if (c.getVersion() >= 2500) {
                        this.srv.messageToPlayer(c, gaName, pn, new SOCRejectOffer(gaName, -1, 1));
                    } else {
                        this.srv.messageToPlayerKeyed(c, gaName, pn, "reply.common.trade.cannot_make");
                    }
                    SOCClientData scd = (SOCClientData)c.getAppData();
                    if (scd != null && scd.isRobot) {
                        SOCPlayer pl = ga.getPlayer(ga.getCurrentPlayerNumber());
                        D.ebugPrintlnINFO("ILLEGAL BANK TRADE: " + c.getData() + ": " + gaName + " gs=" + ga.getGameState() + ": give " + give + ", get " + get + ", has " + pl.getResources() + ", ports " + Arrays.toString(pl.getPortFlags()));
                    }
                }
            } else if (c.getVersion() >= 2500) {
                this.srv.messageToPlayer(c, gaName, -258, new SOCRejectOffer(gaName, -1, 2));
            } else {
                this.srv.messageToPlayerKeyed(c, gaName, -258, "base.reply.not.your.turn");
            }
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception caught");
        }
        finally {
            ga.releaseMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBUILDREQUEST(SOCGame ga, Connection c, SOCBuildRequest mes) {
        String gaName = ga.getName();
        ga.takeMonitor();
        try {
            boolean isCurrent = this.handler.checkTurn(c, ga);
            SOCPlayer player = ga.getPlayer(c.getData());
            if (player == null) {
                return;
            }
            int pn = player.getPlayerNumber();
            int pieceType = mes.getPieceType();
            int sendDeclineReason = -1;
            String sendDeclineTextKey = null;
            boolean sendCancelReply = false;
            if (isCurrent) {
                if (ga.getGameState() == 20 || ga.getGameState() == 100) {
                    sendCancelReply = !this.handleBUILDREQUEST(ga, player, c, pieceType, true);
                } else if (pieceType == -1) {
                    try {
                        ga.askSpecialBuild(pn, true);
                        this.srv.messageToGame(gaName, true, new SOCPlayerElement(gaName, pn, 100, SOCPlayerElement.PEType.ASK_SPECIAL_BUILD, 1));
                        this.handler.endGameTurn(ga, player, true);
                    }
                    catch (NoSuchElementException e) {
                        sendDeclineReason = 1;
                        sendDeclineTextKey = "action.build.cannot.special.PLP.common";
                    }
                    catch (IllegalStateException e) {
                        sendDeclineReason = 3;
                        sendDeclineTextKey = "action.build.cannot.now.ask";
                    }
                } else {
                    sendDeclineReason = 3;
                    sendDeclineTextKey = "action.build.cannot.now";
                }
            } else if (ga.maxPlayers <= 4) {
                sendDeclineReason = 2;
            } else {
                try {
                    ga.askSpecialBuild(pn, true);
                    this.srv.messageToGame(gaName, true, new SOCPlayerElement(gaName, pn, 100, SOCPlayerElement.PEType.ASK_SPECIAL_BUILD, 1));
                }
                catch (NoSuchElementException e) {
                    sendDeclineReason = 1;
                    sendDeclineTextKey = "action.build.cannot.special.PLP.common";
                }
                catch (IllegalStateException e) {
                    sendDeclineReason = 3;
                    sendDeclineTextKey = "action.build.cannot.now.ask";
                }
            }
            if (sendDeclineReason != -1) {
                this.handler.sendDecline(c, ga, false, pn, sendDeclineReason, 0, 0, sendDeclineTextKey, new Object[0]);
            }
            if ((sendCancelReply || sendDeclineReason != -1) && pieceType != -1 && ga.getPlayer(pn).isRobot()) {
                this.srv.messageToPlayer(c, gaName, pn, new SOCCancelBuildRequest(gaName, pieceType));
            }
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception caught at handleBUILDREQUEST");
        }
        finally {
            ga.releaseMonitor();
        }
    }

    private boolean handleBUILDREQUEST(SOCGame ga, SOCPlayer player, Connection c, int pieceType, boolean sendGameState) {
        int pn = player.getPlayerNumber();
        int sendDeclineReason = -1;
        String sendDeclineTextKey = null;
        switch (pieceType) {
            case 0: {
                if (ga.couldBuildRoad(pn)) {
                    ga.buyRoad(pn);
                    this.handler.reportRsrcGainLoss(ga, SOCRoad.COST, true, false, pn, -1, null);
                    if (!sendGameState) break;
                    this.handler.sendGameState(ga);
                    break;
                }
                sendDeclineReason = 3;
                sendDeclineTextKey = "action.build.cannot.now.road";
                break;
            }
            case 1: {
                if (ga.couldBuildSettlement(pn)) {
                    ga.buySettlement(pn);
                    this.handler.reportRsrcGainLoss(ga, SOCSettlement.COST, true, false, pn, -1, null);
                    if (!sendGameState) break;
                    this.handler.sendGameState(ga);
                    break;
                }
                sendDeclineReason = 3;
                sendDeclineTextKey = "action.build.cannot.now.stlmt";
                break;
            }
            case 2: {
                if (ga.couldBuildCity(pn)) {
                    ga.buyCity(pn);
                    this.handler.reportRsrcGainLoss(ga, SOCCity.COST, true, false, pn, -1, null);
                    if (!sendGameState) break;
                    this.handler.sendGameState(ga);
                    break;
                }
                sendDeclineReason = 3;
                sendDeclineTextKey = "action.build.cannot.now.city";
                break;
            }
            case 3: {
                if (ga.couldBuildShip(pn)) {
                    ga.buyShip(pn);
                    this.handler.reportRsrcGainLoss(ga, SOCShip.COST, true, false, pn, -1, null);
                    if (!sendGameState) break;
                    this.handler.sendGameState(ga);
                    break;
                }
                sendDeclineReason = 3;
                sendDeclineTextKey = "action.build.cannot.now.ship";
                break;
            }
            default: {
                sendDeclineReason = 5;
                sendDeclineTextKey = "reply.piece.type.unknown";
            }
        }
        if (sendDeclineReason != -1) {
            this.handler.sendDecline(c, ga, false, pn, sendDeclineReason, 0, 0, sendDeclineTextKey, new Object[0]);
        }
        return sendDeclineReason == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCANCELBUILDREQUEST(SOCGame ga, Connection c, SOCCancelBuildRequest mes) {
        ga.takeMonitor();
        try {
            String gaName = ga.getName();
            if (this.handler.checkTurn(c, ga)) {
                SOCPlayer player = ga.getPlayer(c.getData());
                SOCPlayer playerWithLargestArmy = ga.getPlayerWithLargestArmy();
                int pn = player.getPlayerNumber();
                int gstate = ga.getGameState();
                int sendDeclineReason = -1;
                String sendDeclineTextKey = null;
                int cardTypeRet = -1;
                String cardTypeRetTextKey = null;
                boolean isConvertToWarship = false;
                boolean noAction = false;
                block2 : switch (mes.getPieceType()) {
                    case 0: {
                        if (gstate == 30 || gstate == 40 || gstate == 41) {
                            boolean wasDevCardRet = ga.doesCancelRoadBuildingReturnCard();
                            ga.cancelBuildRoad(pn);
                            if (gstate == 30) {
                                this.handler.reportRsrcGainLoss(ga, SOCRoad.COST, false, false, pn, -1, null);
                                break;
                            }
                            if (wasDevCardRet) {
                                cardTypeRet = 1;
                                cardTypeRetTextKey = "action.card.roadbuilding.cancel";
                                break;
                            }
                            this.srv.messageToGameKeyed(ga, true, true, "action.card.roadbuilding.skip.r", player.getName());
                            break;
                        }
                        sendDeclineReason = 3;
                        sendDeclineTextKey = "action.build.didnt.road._nolocaliz";
                        noAction = true;
                        break;
                    }
                    case 1: {
                        if (gstate == 31) {
                            ga.cancelBuildSettlement(pn);
                            this.handler.reportRsrcGainLoss(ga, SOCSettlement.COST, false, false, pn, -1, null);
                            break;
                        }
                        if (gstate == 6 || gstate == 11 || gstate == 13) {
                            SOCSettlement pp = new SOCSettlement(player, player.getLastSettlementCoord(), null);
                            ga.undoPutInitSettlement(pp);
                            this.srv.messageToGame(gaName, true, mes);
                            this.srv.messageToGameKeyed(ga, true, true, "action.built.stlmt.cancel", player.getName());
                            break;
                        }
                        sendDeclineReason = 3;
                        sendDeclineTextKey = "action.build.didnt.stlmt._nolocaliz";
                        noAction = true;
                        break;
                    }
                    case 2: {
                        if (gstate == 32) {
                            ga.cancelBuildCity(pn);
                            this.handler.reportRsrcGainLoss(ga, SOCCity.COST, false, false, pn, -1, null);
                            break;
                        }
                        sendDeclineReason = 3;
                        sendDeclineTextKey = "action.build.didnt.city._nolocaliz";
                        noAction = true;
                        break;
                    }
                    case 3: {
                        if (gstate == 35 || gstate == 40 || gstate == 41) {
                            boolean wasDevCardRet = ga.doesCancelRoadBuildingReturnCard();
                            ga.cancelBuildShip(pn);
                            if (gstate == 35) {
                                this.handler.reportRsrcGainLoss(ga, SOCShip.COST, false, false, pn, -1, null);
                                break;
                            }
                            if (wasDevCardRet) {
                                cardTypeRet = 1;
                                cardTypeRetTextKey = "action.card.roadbuilding.cancel";
                                break;
                            }
                            this.srv.messageToGameKeyed(ga, true, true, "action.card.roadbuilding.skip.s", player.getName());
                            break;
                        }
                        sendDeclineReason = 3;
                        sendDeclineTextKey = "action.build.didnt.ship._nolocaliz";
                        noAction = true;
                        break;
                    }
                    case -2: {
                        if (ga.canCancelPlayCurrentDevCard()) {
                            GameAction lastAct = ga.getLastAction();
                            isConvertToWarship = lastAct != null && lastAct.actType == GameAction.ActionType.SHIP_CONVERT_TO_WARSHIP;
                            cardTypeRet = ga.cancelPlayCurrentDevCard();
                            switch (cardTypeRet) {
                                case 2: {
                                    cardTypeRetTextKey = "action.card.discov.cancel";
                                    break block2;
                                }
                                case 9: {
                                    cardTypeRetTextKey = isConvertToWarship ? "action.card.soldier.warship.cancel" : "action.card.soldier.cancel";
                                    break block2;
                                }
                                case 3: {
                                    cardTypeRetTextKey = "action.card.mono.cancel";
                                    break block2;
                                }
                            }
                            cardTypeRetTextKey = "action.card.play.cancel";
                            break;
                        }
                        sendDeclineReason = 3;
                        sendDeclineTextKey = "action.card.play.cancel.cant._nolocaliz";
                        noAction = true;
                        break;
                    }
                    case -3: {
                        SOCInventoryItem item = null;
                        if (gstate == 42) {
                            item = ga.cancelPlaceInventoryItem(false);
                        }
                        if (item != null) {
                            this.srv.messageToGame(gaName, true, new SOCInventoryItemAction(gaName, pn, 2, item.itype, item.isKept(), item.isVPItem(), item.canCancelPlay));
                        }
                        if (item != null || gstate != ga.getGameState()) {
                            this.srv.messageToGameKeyed(ga, true, true, "reply.placeitem.cancel", player.getName());
                            break;
                        }
                        sendDeclineReason = 0;
                        sendDeclineTextKey = "reply.placeitem.cancel.cannot";
                        noAction = true;
                        break;
                    }
                    default: {
                        System.err.println("SGMH.handleCANCELBUILDREQUEST:  Unknown piece type " + mes.getPieceType() + " from " + c.getData() + " in game " + ga.getName());
                        sendDeclineReason = 5;
                        sendDeclineTextKey = "reply.piece.type.unknown";
                        noAction = true;
                    }
                }
                if (sendDeclineReason != -1) {
                    this.handler.sendDecline(c, ga, true, pn, sendDeclineReason, 0, 0, sendDeclineTextKey, new Object[0]);
                } else if (cardTypeRet != -1) {
                    boolean isKnight = cardTypeRet == 9;
                    this.srv.messageToGameKeyed(ga, true, true, cardTypeRetTextKey, player.getName());
                    if (ga.clientVersionLowest >= 2000) {
                        this.srv.messageToGame(gaName, true, new SOCDevCardAction(gaName, pn, 3, cardTypeRet));
                        if (isConvertToWarship && isKnight) {
                            this.srv.messageToGame(gaName, true, new SOCPlayerElement(gaName, pn, 100, SOCPlayerElement.PEType.SCENARIO_WARSHIP_COUNT, player.getNumWarships()));
                        } else if (isKnight) {
                            this.srv.messageToGame(gaName, true, new SOCPlayerElement(gaName, pn, 102, SOCPlayerElement.PEType.NUMKNIGHTS, 1));
                            SOCPlayer newPlayerWithLargestArmy = ga.getPlayerWithLargestArmy();
                            if (newPlayerWithLargestArmy != playerWithLargestArmy) {
                                int newPNwithLargestArmy = newPlayerWithLargestArmy != null ? newPlayerWithLargestArmy.getPlayerNumber() : -1;
                                this.srv.messageToGame(gaName, true, new SOCGameElements(gaName, SOCGameElements.GEType.LARGEST_ARMY_PLAYER, newPNwithLargestArmy));
                            }
                        }
                        this.srv.messageToGame(gaName, true, new SOCPlayerElement(gaName, pn, 100, SOCPlayerElement.PEType.PLAYED_DEV_CARD_FLAG, 0));
                    } else {
                        SOCDevCardAction actmsg = new SOCDevCardAction(gaName, pn, 3, cardTypeRet);
                        if (!isKnight) {
                            this.srv.messageToGame(gaName, true, actmsg);
                        } else {
                            this.srv.recordGameEvent(gaName, actmsg);
                            this.srv.messageToGameForVersions(ga, 2000, Integer.MAX_VALUE, actmsg, true);
                            this.srv.messageToGameForVersions(ga, -1, 1999, new SOCDevCardAction(gaName, pn, 3, 0), true);
                            this.srv.messageToGame(gaName, true, new SOCPlayerElement(gaName, pn, 102, SOCPlayerElement.PEType.NUMKNIGHTS, 1));
                            SOCPlayer newPlayerWithLargestArmy = ga.getPlayerWithLargestArmy();
                            if (newPlayerWithLargestArmy != playerWithLargestArmy) {
                                int newPNwithLargestArmy = newPlayerWithLargestArmy != null ? newPlayerWithLargestArmy.getPlayerNumber() : -1;
                                this.srv.messageToGame(gaName, true, new SOCLargestArmy(gaName, newPNwithLargestArmy));
                            }
                        }
                        this.srv.messageToGame(gaName, true, new SOCSetPlayedDevCard(gaName, pn, false));
                    }
                }
                if (!noAction) {
                    this.handler.sendGameState(ga);
                }
            } else {
                this.handler.sendDecline(c, ga, false, -258, 2, 0, 0, null, new Object[0]);
            }
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception caught");
        }
        finally {
            ga.releaseMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void handlePUTPIECE(SOCGame ga, Connection c, SOCPutPiece mes) {
        block44: {
            ga.takeMonitor();
            try {
                block45: {
                    gaName = ga.getName();
                    plName = c.getData();
                    player = ga.getPlayer(plName);
                    if (!this.handler.checkTurn(c, ga)) break block45;
                    sendDeclineReason = -1;
                    sendDeclineTextKey = null;
                    sendCancelReply = false;
                    gameState = ga.getGameState();
                    coord = mes.getCoordinates();
                    pieceType = mes.getPieceType();
                    pn = player.getPlayerNumber();
                    isBuyAndPut = gameState == 20 || gameState == 100;
                    longestRoutePlayer = ga.getPlayerWithLongestRoad();
                    if (isBuyAndPut) {
                        if (!this.handleBUILDREQUEST(ga, player, c, pieceType, false)) {
                            return;
                        }
                        gameState = ga.getGameState();
                    }
                    switch (pieceType) {
                        case 0: {
                            if (gameState != 6 && gameState != 11 && gameState != 13 && gameState != 30 && gameState != 40 && gameState != 41) ** GOTO lbl53
                            if (!player.isPotentialRoad(coord) || player.getNumPieces(0) < 1) ** GOTO lbl44
                            rd = new SOCRoad(player, coord, null);
                            ga.putPiece(rd);
                            this.srv.gameList.takeMonitorForGame(gaName);
                            try {
                                this.srv.messageToGameKeyed(ga, true, false, "action.built.road", new Object[]{plName});
                                this.srv.messageToGameWithMon(gaName, true, new SOCPutPiece(gaName, pn, 0, coord));
                                this.handler.reportLongestRoadIfChanged(ga, longestRoutePlayer, true);
                                if (!ga.pendingMessagesOut.isEmpty()) {
                                    this.handler.sendGamePendingMessages(ga, false);
                                }
                            }
                            finally {
                                this.srv.gameList.releaseMonitorForGame(gaName);
                            }
                            this.handler.sendTurnStateAtInitialPlacement(ga, player, c, gameState);
                            newState = ga.getGameState();
                            if (newState != 14 && newState != 56) break;
                            this.handler.sendGameState_sendGoldPickAnnounceText(ga, gaName, c, null);
                            break;
lbl44:
                            // 1 sources

                            D.ebugPrintlnINFO("ILLEGAL ROAD: 0x" + Integer.toHexString(coord) + ": player " + pn);
                            if (player.isRobot()) {
                                D.ebugPrintlnINFO(" - pl.isPotentialRoad: " + player.isPotentialRoad(coord));
                                pp = ga.getBoard().roadOrShipAtEdge(coord);
                                D.ebugPrintlnINFO(" - roadAtEdge: " + (pp != null ? pp : "none"));
                            }
                            sendDeclineReason = 4;
                            sendDeclineTextKey = "action.build.cannot.there.road";
                            sendCancelReply = true;
                            break;
lbl53:
                            // 1 sources

                            sendDeclineReason = 3;
                            sendDeclineTextKey = "action.build.cannot.now.road";
                            break;
                        }
                        case 1: {
                            if (gameState != 5 && gameState != 10 && gameState != 12 && gameState != 31) ** GOTO lbl90
                            if (!player.canPlaceSettlement(coord) || player.getNumPieces(1) < 1) ** GOTO lbl81
                            se = new SOCSettlement(player, coord, null);
                            ga.putPiece(se);
                            this.srv.gameList.takeMonitorForGame(gaName);
                            try {
                                this.srv.messageToGameKeyed(ga, true, false, "action.built.stlmt", new Object[]{plName});
                                this.srv.messageToGameWithMon(gaName, true, new SOCPutPiece(gaName, pn, 1, coord));
                                this.handler.reportLongestRoadIfChanged(ga, longestRoutePlayer, true);
                                if (!ga.pendingMessagesOut.isEmpty()) {
                                    this.handler.sendGamePendingMessages(ga, false);
                                }
                            }
                            finally {
                                this.srv.gameList.releaseMonitorForGame(gaName);
                            }
                            if (!this.handler.checkTurn(c, ga)) {
                                this.handler.sendTurn(ga, false);
                            } else {
                                this.handler.sendGameState(ga);
                            }
                            if (!ga.hasSeaBoard || ga.getGameState() != 14) break;
                            this.handler.sendGameState_sendGoldPickAnnounceText(ga, gaName, c, null);
                            break;
lbl81:
                            // 1 sources

                            D.ebugPrintlnINFO("ILLEGAL SETTLEMENT: 0x" + Integer.toHexString(coord) + ": player " + pn);
                            if (player.isRobot()) {
                                D.ebugPrintlnINFO(" - pl.isPotentialSettlement: " + player.isPotentialSettlement(coord));
                                pp = ga.getBoard().settlementAtNode(coord);
                                D.ebugPrintlnINFO(" - settlementAtNode: " + (pp != null ? pp : "none"));
                            }
                            sendDeclineReason = 4;
                            sendDeclineTextKey = "action.build.cannot.there.stlmt";
                            sendCancelReply = true;
                            break;
lbl90:
                            // 1 sources

                            sendDeclineReason = 3;
                            sendDeclineTextKey = "action.build.cannot.now.stlmt";
                            break;
                        }
                        case 2: {
                            if (gameState != 32) ** GOTO lbl129
                            if (!player.isPotentialCity(coord) || player.getNumPieces(2) < 1) ** GOTO lbl120
                            v0 = houseRuleFirstCity = ga.isGameOptionSet("N7C") != false && ga.hasBuiltCity() == false;
                            if (houseRuleFirstCity && ga.isGameOptionSet("N7") && ga.getRoundCount() < ga.getGameOptionIntValue("N7")) {
                                houseRuleFirstCity = false;
                            }
                            ci = new SOCCity(player, coord, null);
                            ga.putPiece(ci);
                            this.srv.gameList.takeMonitorForGame(gaName);
                            try {
                                this.srv.messageToGameKeyed(ga, true, false, "action.built.city", new Object[]{plName});
                                this.srv.messageToGameWithMon(gaName, true, new SOCPutPiece(gaName, pn, 2, coord));
                                if (!ga.pendingMessagesOut.isEmpty()) {
                                    this.handler.sendGamePendingMessages(ga, false);
                                }
                                if (houseRuleFirstCity) {
                                    this.srv.messageToGameKeyed(ga, true, false, "action.built.nextturn.7.houserule");
                                }
                            }
                            finally {
                                this.srv.gameList.releaseMonitorForGame(gaName);
                            }
                            if (!this.handler.checkTurn(c, ga)) {
                                this.handler.sendTurn(ga, false);
                                break;
                            }
                            this.handler.sendGameState(ga);
                            break;
lbl120:
                            // 1 sources

                            D.ebugPrintlnINFO("ILLEGAL CITY: 0x" + Integer.toHexString(coord) + ": player " + pn);
                            if (player.isRobot()) {
                                D.ebugPrintlnINFO(" - pl.isPotentialCity: " + player.isPotentialCity(coord));
                                pp = ga.getBoard().settlementAtNode(coord);
                                D.ebugPrintlnINFO(" - city/settlementAtNode: " + (pp != null ? pp : "none"));
                            }
                            sendDeclineReason = 4;
                            sendDeclineTextKey = "action.build.cannot.there.city";
                            sendCancelReply = true;
                            break;
lbl129:
                            // 1 sources

                            sendDeclineReason = 3;
                            sendDeclineTextKey = "action.build.cannot.now.city";
                            break;
                        }
                        case 3: {
                            if (gameState != 6 && gameState != 11 && gameState != 13 && gameState != 35 && gameState != 40 && gameState != 41) ** GOTO lbl164
                            if (!ga.canPlaceShip(player, coord) || player.getNumPieces(3) < 1) ** GOTO lbl155
                            sh = new SOCShip(player, coord, null);
                            ga.putPiece(sh);
                            this.srv.gameList.takeMonitorForGame(gaName);
                            try {
                                this.srv.messageToGameKeyed(ga, true, false, "action.built.ship", new Object[]{plName});
                                this.srv.messageToGameWithMon(gaName, true, new SOCPutPiece(gaName, pn, 3, coord));
                                this.handler.reportLongestRoadIfChanged(ga, longestRoutePlayer, true);
                                if (!ga.pendingMessagesOut.isEmpty()) {
                                    this.handler.sendGamePendingMessages(ga, false);
                                }
                            }
                            finally {
                                this.srv.gameList.releaseMonitorForGame(gaName);
                            }
                            this.handler.sendTurnStateAtInitialPlacement(ga, player, c, gameState);
                            newState = ga.getGameState();
                            if (newState != 14 && newState != 56) break;
                            this.handler.sendGameState_sendGoldPickAnnounceText(ga, gaName, c, null);
                            break;
lbl155:
                            // 1 sources

                            D.ebugPrintlnINFO("ILLEGAL SHIP: 0x" + Integer.toHexString(coord) + ": player " + pn);
                            if (player.isRobot()) {
                                D.ebugPrintlnINFO(" - pl.isPotentialShip: " + player.isPotentialShip(coord));
                                pp = ga.getBoard().roadOrShipAtEdge(coord);
                                D.ebugPrintlnINFO(" - ship/roadAtEdge: " + (pp != null ? pp : "none"));
                            }
                            sendDeclineReason = 4;
                            sendDeclineTextKey = "action.build.cannot.there.ship";
                            sendCancelReply = true;
                            break;
lbl164:
                            // 1 sources

                            sendDeclineReason = 3;
                            sendDeclineTextKey = "action.build.cannot.now.ship";
                            break;
                        }
                        default: {
                            sendDeclineReason = 5;
                            sendDeclineTextKey = "reply.piece.type.unknown";
                        }
                    }
                    if (sendDeclineReason != -1) {
                        this.handler.sendDecline(c, ga, false, pn, sendDeclineReason, pieceType, coord, sendDeclineTextKey, new Object[0]);
                    }
                    if (sendCancelReply) {
                        if (isBuyAndPut) {
                            this.handler.sendGameState(ga);
                        }
                        if (pieceType != -1) {
                            this.srv.messageToPlayer(c, gaName, pn, new SOCCancelBuildRequest(gaName, pieceType));
                        }
                        if (player.isRobot()) {
                            ga.lastActionTime = 0L;
                        }
                    }
                    break block44;
                }
                this.handler.sendDecline(c, ga, false, -258, 2, 0, 0, null, new Object[0]);
            }
            catch (Exception e) {
                D.ebugPrintStackTrace(e, "Exception caught in handlePUTPIECE");
            }
            finally {
                ga.releaseMonitor();
            }
        }
    }

    private void handleMOVEPIECE(SOCGame ga, Connection c, SOCMovePiece mes) {
        String gaName = ga.getName();
        boolean isCurrent = this.handler.checkTurn(c, ga);
        boolean denyRequest = false;
        int fromEdge = mes.getFromCoord();
        int toEdge = mes.getToCoord();
        if (mes.getPieceType() != 3 || !isCurrent) {
            denyRequest = true;
        } else {
            int pn = ga.getCurrentPlayerNumber();
            SOCShip moveShip = ga.canMoveShip(pn, fromEdge, toEdge);
            if (moveShip == null) {
                denyRequest = true;
            } else {
                int gstate = ga.getGameState();
                SOCPlayer longestRoutePlayer = ga.getPlayerWithLongestRoad();
                ga.moveShip(moveShip, toEdge);
                this.srv.messageToGame(gaName, true, new SOCMovePiece(gaName, pn, 3, fromEdge, toEdge));
                this.handler.reportLongestRoadIfChanged(ga, longestRoutePlayer, false);
                if (!ga.pendingMessagesOut.isEmpty()) {
                    this.handler.sendGamePendingMessages(ga, true);
                }
                if (ga.getGameState() == 56) {
                    this.handler.sendGameState(ga, false, true, false);
                    this.handler.sendGameState_sendGoldPickAnnounceText(ga, gaName, c, null);
                } else if (gstate != ga.getGameState()) {
                    this.handler.sendGameState(ga, false, true, false);
                }
            }
        }
        if (denyRequest) {
            if (isCurrent) {
                D.ebugPrintlnINFO("ILLEGAL MOVEPIECE: 0x" + Integer.toHexString(fromEdge) + " -> 0x" + Integer.toHexString(toEdge) + ": player " + c.getData());
            }
            this.srv.messageToPlayerKeyed(c, gaName, -258, "reply.movepiece.cannot.now.ship");
            this.srv.messageToPlayer(c, gaName, -258, new SOCCancelBuildRequest(gaName, 3));
        }
    }

    private void handleDEBUGFREEPLACE(SOCGame ga, Connection c, SOCDebugFreePlace mes) {
        if (!ga.isDebugFreePlacement()) {
            return;
        }
        String gaName = ga.getName();
        int gstate = ga.getGameState();
        SOCPlayer longestRoutePlayer = ga.getPlayerWithLongestRoad();
        int coord = mes.getCoordinates();
        SOCPlayer player = ga.getPlayer(mes.getPlayerNumber());
        if (player == null) {
            return;
        }
        boolean didPut = false;
        int pieceType = mes.getPieceType();
        int pn = player.getPlayerNumber();
        boolean initialDeny = ga.isInitialPlacement() && !player.canBuildInitialPieceType(pieceType);
        boolean denyInSpecial = false;
        switch (pieceType) {
            case 0: {
                if (!player.isPotentialRoad(coord) || initialDeny) break;
                ga.putPiece(new SOCRoad(player, coord, null));
                didPut = true;
                break;
            }
            case 1: {
                if (!player.canPlaceSettlement(coord) || initialDeny) break;
                ga.putPiece(new SOCSettlement(player, coord, null));
                didPut = true;
                break;
            }
            case 2: {
                if (!player.isPotentialCity(coord) || initialDeny) break;
                ga.putPiece(new SOCCity(player, coord, null));
                didPut = true;
                break;
            }
            case 3: {
                if (!ga.canPlaceShip(player, coord) || initialDeny) break;
                if (player.canPlaceShip_debugFreePlace(coord)) {
                    ga.putPiece(new SOCShip(player, coord, null));
                    didPut = true;
                    break;
                }
                denyInSpecial = true;
                break;
            }
            default: {
                this.srv.messageToPlayer(c, gaName, -258, "* Unknown piece type: " + pieceType);
            }
        }
        if (didPut) {
            int newState;
            int numGoldRes;
            this.srv.messageToGame(gaName, true, new SOCPutPiece(gaName, pn, pieceType, coord));
            this.handler.reportLongestRoadIfChanged(ga, longestRoutePlayer, false);
            if (!ga.pendingMessagesOut.isEmpty() || !player.pendingMessagesOut.isEmpty()) {
                this.handler.sendGamePendingMessages(ga, true);
            }
            if ((numGoldRes = player.getNeedToPickGoldHexResources()) > 0) {
                int newGS = ga.getGameState();
                if (newGS == 56) {
                    this.srv.messageToGame(gaName, true, new SOCGameState(gaName, newGS));
                }
                this.srv.messageToPlayer(c, gaName, pn, new SOCSimpleRequest(gaName, pn, 1, numGoldRes));
            }
            if ((newState = ga.getGameState()) >= 1000) {
                this.handler.processDebugCommand_freePlace(c, ga, "0");
                this.handler.sendGameState(ga, false, true, false);
            } else if (newState != gstate) {
                this.handler.sendGameState(ga, false, true, false);
            }
        } else if (initialDeny) {
            String pieceTypeFirst = player.getPieces().size() % 2 == 0 ? "settlement" : "road";
            this.srv.messageToPlayer(c, gaName, -258, "Place a " + pieceTypeFirst + " before placing that.");
        } else if (denyInSpecial) {
            this.srv.messageToPlayer(c, gaName, -258, "Can't currently do that during Free Placement.");
        } else {
            this.srv.messageToPlayer(c, gaName, -258, "Not a valid location to place that.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUNDOPUTPIECE(SOCGame ga, Connection c, SOCUndoPutPiece mes) {
        String gaName = ga.getName();
        int pieceType = mes.getPieceType();
        int coord = mes.getCoordinates();
        ga.takeMonitor();
        try {
            SOCPlayingPiece pp;
            SOCPlayer player = ga.getPlayer(c.getData());
            int pn = player != null ? player.getPlayerNumber() : -257;
            GameAction act = ga.getLastAction();
            if (act == null || act.param1 != pieceType || act.actType != GameAction.ActionType.BUILD_PIECE && act.actType != GameAction.ActionType.MOVE_PIECE || player == null || ga.getCurrentPlayerNumber() != pn) {
                this.srv.messageToPlayer(c, gaName, pn, new SOCUndoPutPiece(gaName, -1, pieceType, coord));
                return;
            }
            SOCBoard board = ga.getBoard();
            switch (pieceType) {
                case 0: 
                case 3: {
                    pp = board.roadOrShipAtEdge(coord);
                    break;
                }
                case 1: 
                case 2: {
                    pp = board.settlementAtNode(coord);
                    break;
                }
                default: {
                    pp = null;
                }
            }
            boolean sendDenyReply = true;
            if (act.actType == GameAction.ActionType.MOVE_PIECE && pp instanceof SOCShip) {
                if (ga.canUndoMoveShip(pn, (SOCShip)pp)) {
                    GameAction undoShipMove = ga.undoMoveShip((SOCShip)pp);
                    sendDenyReply = false;
                    List<SOCMessage> msgsAfter = this.sendUndoSideEffects(ga, undoShipMove, 3);
                    this.srv.messageToGame(gaName, true, new SOCUndoPutPiece(gaName, pn, pieceType, coord, undoShipMove.param3));
                    if (msgsAfter != null) {
                        for (SOCMessage m : msgsAfter) {
                            this.srv.messageToGame(gaName, true, m);
                        }
                    }
                }
            } else if (pp != null && ga.canUndoPutPiece(pn, pp)) {
                GameAction undoBuild = ga.undoPutPiece(pp);
                sendDenyReply = false;
                List<SOCMessage> msgsAfter = this.sendUndoSideEffects(ga, undoBuild, pieceType);
                this.srv.messageToGame(gaName, true, new SOCUndoPutPiece(gaName, pn, pieceType, coord));
                if (msgsAfter != null) {
                    for (SOCMessage m : msgsAfter) {
                        this.srv.messageToGame(gaName, true, m);
                    }
                }
            }
            if (sendDenyReply) {
                if (player.getUndosRemaining() <= 0) {
                    this.srv.messageToPlayer(c, gaName, pn, new SOCPlayerElement(gaName, pn, 100, SOCPlayerElement.PEType.NUM_UNDOS_REMAINING, 0));
                }
                this.srv.messageToPlayer(c, gaName, pn, new SOCUndoPutPiece(gaName, -1, pieceType, coord));
            } else {
                this.srv.messageToGame(gaName, true, new SOCGameState(gaName, ga.getGameState()));
            }
        }
        finally {
            ga.releaseMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleBUYDEVCARDREQUEST(SOCGame ga, Connection c, SOCBuyDevCardRequest mes) {
        ga.takeMonitor();
        try {
            String gaName = ga.getName();
            SOCPlayer player = ga.getPlayer(c.getData());
            if (player == null) {
                return;
            }
            int pn = player.getPlayerNumber();
            int sendDeclineReason = -1;
            String sendDeclineTextKey = null;
            if (this.handler.checkTurn(c, ga)) {
                if ((ga.getGameState() == 20 || ga.getGameState() == 100) && ga.couldBuyDevCard(pn)) {
                    int card = ga.buyDevCard();
                    int devCount = ga.getNumDevCards();
                    this.handler.reportRsrcGainLoss(ga, SOCDevCard.COST, true, false, pn, -1, null);
                    this.srv.messageToGameForVersions(ga, -1, 2499, ga.clientVersionLowest >= 2000 ? new SOCGameElements(gaName, SOCGameElements.GEType.DEV_CARD_COUNT, devCount) : new SOCDevCardCount(gaName, devCount), true);
                    if (card == 9 && c.getVersion() < 2000) {
                        card = 0;
                    }
                    SOCDevCardAction drawMsg = new SOCDevCardAction(gaName, pn, 0, card);
                    this.srv.messageToPlayer(c, null, -256, drawMsg);
                    if (this.srv.isRecordGameEventsActive()) {
                        if (card == 0) {
                            drawMsg = new SOCDevCardAction(gaName, pn, 0, 9);
                        }
                        this.srv.recordGameEventTo(gaName, pn, drawMsg);
                    }
                    if (ga.clientVersionLowest >= 2000) {
                        int ctypeToOthers = ga.isGameOptionSet("PLAY_FO") || ga.isGameOptionSet("PLAY_VPO") ? card : 0;
                        this.srv.messageToGameExcept(gaName, c, pn, (SOCMessage)new SOCDevCardAction(gaName, pn, 0, ctypeToOthers), true);
                    } else {
                        this.srv.messageToGameForVersionsExcept(ga, -1, 1999, c, (SOCMessage)new SOCDevCardAction(gaName, pn, 0, 9), true);
                        this.srv.messageToGameForVersionsExcept(ga, 2000, Integer.MAX_VALUE, c, (SOCMessage)new SOCDevCardAction(gaName, pn, 0, 0), true);
                        if (this.srv.isRecordGameEventsActive()) {
                            this.srv.recordGameEventNotTo(gaName, pn, (SOCMessage)new SOCDevCardAction(gaName, pn, 0, 0));
                        }
                    }
                    int remain = ga.getNumDevCards();
                    SOCSimpleAction actmsg = new SOCSimpleAction(gaName, pn, 1, remain, 0);
                    if (ga.clientVersionLowest >= 1119) {
                        this.srv.messageToGame(gaName, true, actmsg);
                    } else {
                        this.srv.recordGameEvent(gaName, actmsg);
                        this.srv.gameList.takeMonitorForGame(gaName);
                        try {
                            String remainTxt;
                            this.srv.messageToGameForVersions(ga, 1119, Integer.MAX_VALUE, actmsg, false);
                            String boughtTxt = MessageFormat.format("{0} bought a development card.", player.getName());
                            this.srv.messageToGameForVersions(ga, -1, 1118, new SOCGameTextMsg(gaName, "Server", boughtTxt), false);
                            switch (remain) {
                                case 0: {
                                    remainTxt = "There are no more Development cards.";
                                    break;
                                }
                                case 1: {
                                    remainTxt = "There is 1 card left.";
                                    break;
                                }
                                default: {
                                    remainTxt = MessageFormat.format("There are {0,number} cards left.", ga.getNumDevCards());
                                }
                            }
                            this.srv.messageToGameForVersions(ga, -1, 1118, new SOCGameTextMsg(gaName, "Server", remainTxt), false);
                        }
                        finally {
                            this.srv.gameList.releaseMonitorForGame(gaName);
                        }
                    }
                    this.handler.sendGameState(ga);
                } else if (ga.getNumDevCards() == 0) {
                    sendDeclineReason = 1;
                    sendDeclineTextKey = "buy.dev.cards.none.common";
                } else {
                    sendDeclineReason = 3;
                    sendDeclineTextKey = "buy.dev.cards.cannot_now";
                }
            } else if (ga.maxPlayers <= 4) {
                sendDeclineReason = 2;
            } else {
                try {
                    ga.askSpecialBuild(pn, true);
                    this.srv.messageToGame(gaName, true, new SOCPlayerElement(gaName, pn, 100, SOCPlayerElement.PEType.ASK_SPECIAL_BUILD, 1));
                }
                catch (NoSuchElementException e) {
                    sendDeclineReason = 1;
                    sendDeclineTextKey = "action.build.cannot.special.PLP.common";
                }
                catch (IllegalStateException e) {
                    sendDeclineReason = 3;
                    sendDeclineTextKey = "buy.dev.cards.cannot_now";
                }
            }
            if (sendDeclineReason != -1) {
                this.handler.sendDecline(c, ga, false, pn, sendDeclineReason, 0, 0, sendDeclineTextKey, new Object[0]);
                if (ga.getPlayer(pn).isRobot()) {
                    this.srv.messageToPlayer(c, gaName, pn, new SOCCancelBuildRequest(gaName, -2));
                }
            }
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception caught");
        }
        finally {
            ga.releaseMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handlePLAYDEVCARDREQUEST(SOCGame ga, Connection c, SOCPlayDevCardRequest mes) {
        ga.takeMonitor();
        try {
            SOCClientData scd;
            String gaName = ga.getName();
            boolean denyPlayCardNow = false;
            String denyTextKey = null;
            if (!this.handler.checkTurn(c, ga)) {
                this.handler.sendDecline(c, ga, false, -258, 2, 0, 0, null, new Object[0]);
                return;
            }
            SOCPlayer player = ga.getPlayer(c.getData());
            int pn = player.getPlayerNumber();
            int ctype = mes.getDevCard();
            if (ctype == 0 && c.getVersion() < 2000) {
                ctype = 9;
            }
            switch (ctype) {
                case 9: {
                    boolean isWarshipConvert = ga.isGameOptionSet("_SC_PIRI");
                    if (ga.canPlayKnight(pn)) {
                        int newPNwithLargestArmy;
                        SOCPlayerElement.PEType peType = isWarshipConvert ? SOCPlayerElement.PEType.SCENARIO_WARSHIP_COUNT : SOCPlayerElement.PEType.NUMKNIGHTS;
                        SOCPlayer pl = ga.getPlayerWithLargestArmy();
                        int pnWithLargestArmy = pl != null ? pl.getPlayerNumber() : -1;
                        ga.playKnight();
                        String cardplayed = isWarshipConvert ? "action.card.soldier.warship" : "action.card.soldier";
                        this.srv.gameList.takeMonitorForGame(gaName);
                        this.srv.messageToGameKeyed(ga, true, false, cardplayed, player.getName());
                        if (ga.clientVersionLowest >= 2000) {
                            this.srv.messageToGameWithMon(gaName, true, new SOCDevCardAction(gaName, pn, 1, 9));
                        } else {
                            this.srv.messageToGameForVersions(ga, -1, 1999, new SOCDevCardAction(gaName, pn, 1, 0), false);
                            this.srv.messageToGameForVersions(ga, 2000, Integer.MAX_VALUE, new SOCDevCardAction(gaName, pn, 1, 9), false);
                            if (this.srv.isRecordGameEventsActive()) {
                                this.srv.recordGameEvent(gaName, new SOCDevCardAction(gaName, pn, 1, 9));
                            }
                        }
                        if (ga.clientVersionLowest >= 2000) {
                            this.srv.messageToGameWithMon(gaName, true, new SOCPlayerElement(gaName, pn, 100, SOCPlayerElement.PEType.PLAYED_DEV_CARD_FLAG, 1));
                        } else {
                            this.srv.messageToGameWithMon(gaName, true, new SOCSetPlayedDevCard(gaName, pn, true));
                        }
                        this.srv.messageToGameWithMon(gaName, true, new SOCPlayerElement(gaName, pn, 101, peType, 1));
                        this.srv.gameList.releaseMonitorForGame(gaName);
                        if (isWarshipConvert) break;
                        SOCPlayer pl2 = ga.getPlayerWithLargestArmy();
                        int n = newPNwithLargestArmy = pl2 != null ? pl2.getPlayerNumber() : -1;
                        if (newPNwithLargestArmy != pnWithLargestArmy) {
                            void var16_19;
                            if (ga.clientVersionLowest >= 2000) {
                                SOCGameElements sOCGameElements = new SOCGameElements(gaName, SOCGameElements.GEType.LARGEST_ARMY_PLAYER, newPNwithLargestArmy);
                            } else {
                                SOCLargestArmy sOCLargestArmy = new SOCLargestArmy(gaName, newPNwithLargestArmy);
                            }
                            this.srv.messageToGame(gaName, true, (SOCMessage)var16_19);
                        }
                        this.handler.sendGameState(ga);
                        break;
                    }
                    denyPlayCardNow = true;
                    break;
                }
                case 1: {
                    if (ga.canPlayRoadBuilding(pn)) {
                        ga.playRoadBuilding();
                        this.srv.gameList.takeMonitorForGame(gaName);
                        this.srv.messageToGameWithMon(gaName, true, new SOCDevCardAction(gaName, pn, 1, 1));
                        if (ga.clientVersionLowest >= 2000) {
                            this.srv.messageToGameWithMon(gaName, true, new SOCPlayerElement(gaName, pn, 100, SOCPlayerElement.PEType.PLAYED_DEV_CARD_FLAG, 1));
                        } else {
                            this.srv.messageToGameWithMon(gaName, true, new SOCSetPlayedDevCard(gaName, pn, true));
                        }
                        this.srv.messageToGameKeyed(ga, true, false, "action.card.roadbuilding", player.getName());
                        this.srv.gameList.releaseMonitorForGame(gaName);
                        this.handler.sendGameState(ga);
                        if (ga.getGameState() == 40) {
                            this.srv.messageToPlayerKeyed(c, gaName, pn, ga.hasSeaBoard ? "action.card.road.place.2s" : "action.card.road.place.2r");
                            break;
                        }
                        this.srv.messageToPlayerKeyed(c, gaName, pn, ga.hasSeaBoard ? "action.card.road.place.1s" : "action.card.road.place.1r");
                        break;
                    }
                    denyPlayCardNow = true;
                    break;
                }
                case 2: {
                    if (ga.canPlayDiscovery(pn)) {
                        ga.playDiscovery();
                        this.srv.gameList.takeMonitorForGame(gaName);
                        this.srv.messageToGameWithMon(gaName, true, new SOCDevCardAction(gaName, pn, 1, 2));
                        if (ga.clientVersionLowest >= 2000) {
                            this.srv.messageToGameWithMon(gaName, true, new SOCPlayerElement(gaName, pn, 100, SOCPlayerElement.PEType.PLAYED_DEV_CARD_FLAG, 1));
                        } else {
                            this.srv.messageToGameWithMon(gaName, true, new SOCSetPlayedDevCard(gaName, pn, true));
                        }
                        this.srv.messageToGameKeyed(ga, true, false, "action.card.discoveryplenty", player.getName());
                        this.srv.gameList.releaseMonitorForGame(gaName);
                        this.handler.sendGameState(ga);
                        break;
                    }
                    denyPlayCardNow = true;
                    break;
                }
                case 3: {
                    if (ga.canPlayMonopoly(pn)) {
                        ga.playMonopoly();
                        this.srv.gameList.takeMonitorForGame(gaName);
                        this.srv.messageToGameWithMon(gaName, true, new SOCDevCardAction(gaName, pn, 1, 3));
                        if (ga.clientVersionLowest >= 2000) {
                            this.srv.messageToGameWithMon(gaName, true, new SOCPlayerElement(gaName, pn, 100, SOCPlayerElement.PEType.PLAYED_DEV_CARD_FLAG, 1));
                        } else {
                            this.srv.messageToGameWithMon(gaName, true, new SOCSetPlayedDevCard(gaName, pn, true));
                        }
                        this.srv.messageToGameKeyed(ga, true, false, "action.card.mono", player.getName());
                        this.srv.gameList.releaseMonitorForGame(gaName);
                        this.handler.sendGameState(ga);
                        break;
                    }
                    denyPlayCardNow = true;
                    break;
                }
                default: {
                    denyTextKey = "reply.playdevcard.type.unknown";
                    D.ebugPrintlnINFO("* srv handlePLAYDEVCARDREQUEST: asked to play unhandled type " + mes.getDevCard());
                }
            }
            if (!denyPlayCardNow) {
                if (denyTextKey == null) return;
            }
            if ((scd = (SOCClientData)c.getAppData()) == null || !scd.isRobot) {
                if (denyTextKey != null) {
                    this.handler.sendDecline(c, ga, true, -258, 3, 0, 0, denyTextKey, new Object[0]);
                    return;
                }
                this.handler.sendDecline(c, ga, true, -258, 3, 0, 0, "reply.playdevcard.cannot.now", mes.getDevCard());
                return;
            }
            this.srv.messageToPlayer(c, null, -258, new SOCDevCardAction(gaName, -1, 4, mes.getDevCard()));
            return;
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception caught");
            return;
        }
        finally {
            ga.releaseMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePICKRESOURCES(SOCGame ga, Connection c, SOCPickResources mes) {
        String gaName = ga.getName();
        SOCResourceSet rsrcs = mes.getResources();
        ga.takeMonitor();
        SOCPlayer player = ga.getPlayer(c.getData());
        int pn = player != null ? player.getPlayerNumber() : -1;
        try {
            if (player == null) {
                throw new IllegalArgumentException("player not found in game");
            }
            int gstate = ga.getGameState();
            if (gstate == 52) {
                if (this.handler.checkTurn(c, ga)) {
                    if (ga.canDoDiscoveryAction(rsrcs)) {
                        ga.doDiscoveryAction(rsrcs);
                        SOCPickResources picked = new SOCPickResources(gaName, rsrcs, pn, 2);
                        if (ga.clientVersionLowest >= 2500) {
                            this.srv.messageToGame(gaName, true, picked);
                        } else {
                            this.srv.recordGameEvent(gaName, picked);
                            this.srv.messageToGameForVersions(ga, 2500, Integer.MAX_VALUE, picked, true);
                            this.handler.reportRsrcGainLossForVersions(ga, rsrcs, false, true, pn, -1, null, 2499);
                            this.srv.messageToGameForVersionsKeyed(ga, 0, 2499, true, true, "action.card.discov.received", player.getName(), rsrcs);
                        }
                        this.handler.sendGameState(ga);
                    } else if (rsrcs.getTotal() != 2) {
                        this.srv.messageToPlayerKeyed(c, gaName, pn, "action.card.discov.notlegal");
                        this.srv.messageToPlayer(c, gaName, pn, c.getVersion() >= 2000 ? new SOCSimpleRequest(gaName, pn, 1, 2) : new SOCGameState(gaName, 52));
                    } else {
                        this.handler.sendDecline(c, ga, true, pn, 5, 0, 0, "action.card.discov.notlegal", new Object[0]);
                    }
                } else {
                    this.handler.sendDecline(c, ga, false, pn, 2, 0, 0, null, new Object[0]);
                }
            } else if (ga.canPickGoldHexResources(pn, rsrcs)) {
                boolean fromInitPlace = ga.isInitialPlacement();
                boolean fromPirateFleet = ga.isPickResourceIncludingPirateFleet(pn);
                int prevState = ga.pickGoldHexResources(pn, rsrcs);
                int newState = ga.getGameState();
                this.handler.reportRsrcGainGold(ga, player, pn, rsrcs, false, !fromPirateFleet);
                if (gstate != 20 || newState == 50 || !ga.isForcingEndTurn()) {
                    if (!fromInitPlace) {
                        this.handler.sendGameState(ga);
                        if (newState == 50) {
                            this.handler.sendGameState_sendDiscardRequests(ga, gaName);
                        }
                    } else {
                        switch (newState) {
                            case 6: 
                            case 11: 
                            case 13: {
                                this.handler.sendGameState(ga);
                                break;
                            }
                            case 5: 
                            case 10: 
                            case 12: 
                            case 15: {
                                this.handler.sendTurnStateAtInitialPlacement(ga, player, c, prevState);
                            }
                        }
                    }
                } else {
                    this.handler.endGameTurn(ga, player, true);
                }
            } else {
                int npick = player.getNeedToPickGoldHexResources();
                if (npick != rsrcs.getTotal()) {
                    this.srv.messageToPlayerKeyed(c, gaName, pn, "reply.pick.gold.cannot.that_many");
                    if (npick > 0 && gstate < 1000) {
                        this.srv.messageToPlayer(c, gaName, pn, new SOCSimpleRequest(gaName, pn, 1, npick));
                    } else {
                        this.srv.messageToPlayer(c, gaName, pn, new SOCPlayerElement(gaName, pn, 100, SOCPlayerElement.PEType.NUM_PICK_GOLD_HEX_RESOURCES, 0));
                    }
                } else {
                    this.srv.messageToGame(gaName, true, "Recovering from buggy state: " + player.getName() + " won free resources but game state didn't allow them to be picked; giving them anyway.");
                    player.getResources().add(rsrcs);
                    player.setNeedToPickGoldHexResources(0);
                    this.handler.reportRsrcGainGold(ga, player, pn, rsrcs, true, false);
                }
            }
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception caught");
        }
        finally {
            ga.releaseMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePICKRESOURCETYPE(SOCGame ga, Connection c, SOCPickResourceType mes) {
        ga.takeMonitor();
        try {
            String gaName = ga.getName();
            if (this.handler.checkTurn(c, ga)) {
                if (ga.canDoMonopolyAction()) {
                    int pn;
                    int rsrc = mes.getResourceType();
                    int[] monoPicks = ga.doMonopolyAction(rsrc);
                    boolean[] isVictim = new boolean[ga.maxPlayers];
                    int cpn = ga.getCurrentPlayerNumber();
                    String monoPlayerName = c.getData();
                    int monoTotal = 0;
                    for (pn = 0; pn < ga.maxPlayers; ++pn) {
                        int n = monoPicks[pn];
                        if (n <= 0) continue;
                        monoTotal += n;
                        isVictim[pn] = true;
                    }
                    this.srv.gameList.takeMonitorForGame(gaName);
                    for (pn = 0; pn < ga.maxPlayers; ++pn) {
                        if (!isVictim[pn]) continue;
                        SOCResourceSet plRes = ga.getPlayer(pn).getResources();
                        this.srv.messageToGameWithMon(gaName, true, new SOCPlayerElement(gaName, pn, 100, rsrc, plRes.getAmount(rsrc), true));
                        this.srv.messageToGameWithMon(gaName, true, new SOCResourceCount(gaName, pn, plRes.getTotal()));
                    }
                    this.srv.messageToGameWithMon(gaName, true, new SOCPlayerElement(gaName, cpn, 101, rsrc, monoTotal, false));
                    SOCSimpleAction actMsg = new SOCSimpleAction(gaName, cpn, 3, monoTotal, rsrc);
                    if (ga.clientVersionLowest >= 2000) {
                        this.srv.messageToGameWithMon(gaName, true, actMsg);
                    } else {
                        this.srv.recordGameEvent(gaName, actMsg);
                        this.srv.messageToGameForVersions(ga, 2000, Integer.MAX_VALUE, actMsg, false);
                        String monoTxt = monoPlayerName + " monopolized " + SOCStringManager.getFallbackServerManagerForClient().getSOCResourceCount(rsrc, monoTotal);
                        this.srv.messageToGameForVersions(ga, -1, 1999, new SOCGameTextMsg(gaName, "Server", monoTxt), false);
                    }
                    this.srv.gameList.releaseMonitorForGame(gaName);
                    for (int pn2 = 0; pn2 < ga.maxPlayers; ++pn2) {
                        if (!isVictim[pn2]) continue;
                        int picked = monoPicks[pn2];
                        SOCPlayer victim = ga.getPlayer(pn2);
                        String viName = victim.getName();
                        Connection viCon = this.srv.getConnection(viName);
                        if (viCon == null || victim.isRobot()) continue;
                        this.srv.messageToPlayerKeyedSpecial(viCon, ga, pn2, picked == 1 ? "action.mono.took.your.1" : "action.mono.took.your.n", monoPlayerName, picked, rsrc);
                    }
                    this.handler.sendGameState(ga);
                } else {
                    this.handler.sendDecline(c, ga, true, -258, 3, 0, 0, "reply.playdevcard.cannot.now", 3);
                }
            } else {
                this.handler.sendDecline(c, ga, false, -258, 2, 0, 0, null, new Object[0]);
            }
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception caught");
        }
        finally {
            ga.releaseMonitor();
        }
    }

    private void handleINVENTORYITEMACTION(SOCGame ga, Connection c, SOCInventoryItemAction mes) {
        if (mes.action != 4) {
            return;
        }
        String gaName = ga.getName();
        SOCPlayer clientPl = ga.getPlayer(c.getData());
        if (clientPl == null) {
            return;
        }
        int pn = clientPl.getPlayerNumber();
        int replyCannot = ga.canPlayInventoryItem(pn, mes.itemType);
        if (replyCannot != 0) {
            this.srv.messageToPlayer(c, gaName, pn, new SOCInventoryItemAction(gaName, -1, 5, mes.itemType, replyCannot));
            return;
        }
        int oldGameState = ga.getGameState();
        SOCInventoryItem item = ga.playInventoryItem(mes.itemType);
        if (item == null) {
            this.srv.messageToPlayer(c, gaName, pn, new SOCInventoryItemAction(gaName, -1, 5, mes.itemType, 1));
            return;
        }
        this.srv.messageToGame(gaName, true, new SOCInventoryItemAction(gaName, pn, 6, item.itype, item.isKept(), item.isVPItem(), item.canCancelPlay));
        int gstate = ga.getGameState();
        if (gstate != oldGameState) {
            this.handler.sendGameState(ga);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSETSPECIALITEM(SOCGame ga, Connection c, SOCSetSpecialItem mes) {
        String gaName = ga.getName();
        SOCPlayer pl = ga.getPlayer(c.getData());
        String typeKey = mes.typeKey;
        int op = mes.op;
        int gi = mes.gameItemIndex;
        int pi = mes.playerItemIndex;
        int pn = pl != null ? pl.getPlayerNumber() : -1;
        boolean sendDenyReply = false;
        try {
            SOCSpecialItem itm = null;
            ga.takeMonitor();
            if (pl == null || op < 1 || op > 3) {
                sendDenyReply = true;
                boolean paidCost = false;
            } else {
                int prevState = ga.getGameState();
                if (op == 3) {
                    int startCostPType;
                    boolean paidCost;
                    SOCSpecialItem pBefore;
                    SOCSpecialItem gBefore;
                    int replyPickOp = 3;
                    int pickPN = pn;
                    int pickCoord = -1;
                    int pickLevel = 0;
                    boolean isStartingPick = false;
                    String pickSV = null;
                    if (gi != -1 && pi != -1) {
                        gBefore = ga.getSpecialItem(typeKey, gi);
                        pBefore = pl.getSpecialItem(typeKey, pi);
                    } else {
                        gBefore = null;
                        pBefore = null;
                    }
                    itm = ga.getSpecialItem(typeKey, gi, pi, pn);
                    if (itm != null) {
                        pickCoord = itm.getCoordinates();
                        pickLevel = itm.getLevel();
                        pickSV = itm.getStringValue();
                        boolean bl = isStartingPick = 0 == pickLevel && null == itm.getPlayer();
                    }
                    if ((paidCost = SOCSpecialItem.playerPickItem(typeKey, ga, pl, gi, pi)) && itm != null) {
                        this.handler.reportRsrcGainLoss(ga, itm.getCost(), true, false, pn, -1, null);
                    }
                    if (gi == -1 || pi == -1) {
                        SOCSpecialItem itmAfter = ga.getSpecialItem(typeKey, gi, pi, pn);
                        if (itmAfter != null) {
                            replyPickOp = 5;
                            pickPN = itmAfter.getPlayer() != null ? itmAfter.getPlayer().getPlayerNumber() : -1;
                            pickCoord = itmAfter.getCoordinates();
                            pickLevel = itmAfter.getLevel();
                            pickSV = itmAfter.getStringValue();
                        } else {
                            replyPickOp = 6;
                        }
                    } else {
                        SOCSpecialItem pAfter;
                        SOCSpecialItem gAfter = ga.getSpecialItem(typeKey, gi);
                        if (gAfter == (pAfter = pl.getSpecialItem(typeKey, pi))) {
                            if (gAfter != null) {
                                replyPickOp = 5;
                                pickCoord = gAfter.getCoordinates();
                                pickLevel = gAfter.getLevel();
                                pickSV = gAfter.getStringValue();
                            } else {
                                replyPickOp = 6;
                            }
                        } else {
                            boolean setPickFieldsFromGAfter = false;
                            if (gAfter == null) {
                                if (gBefore != null) {
                                    this.srv.messageToGame(gaName, true, new SOCSetSpecialItem(gaName, 2, typeKey, gi, -1, -1));
                                }
                            } else {
                                this.srv.messageToGame(gaName, true, new SOCSetSpecialItem(ga, 1, typeKey, gi, -1, gAfter));
                                pickCoord = gAfter.getCoordinates();
                                pickLevel = gAfter.getLevel();
                                pickSV = gAfter.getStringValue();
                                setPickFieldsFromGAfter = true;
                            }
                            if (pAfter == null) {
                                if (pBefore != null) {
                                    this.srv.messageToGame(gaName, true, new SOCSetSpecialItem(gaName, 2, typeKey, -1, pi, pn));
                                }
                            } else {
                                this.srv.messageToGame(gaName, true, new SOCSetSpecialItem(ga, 1, typeKey, -1, pi, pAfter));
                                if (!setPickFieldsFromGAfter) {
                                    pickCoord = pAfter.getCoordinates();
                                    pickLevel = pAfter.getLevel();
                                    pickSV = pAfter.getStringValue();
                                }
                            }
                        }
                    }
                    this.srv.messageToGame(gaName, true, new SOCSetSpecialItem(gaName, replyPickOp, typeKey, gi, pi, pickPN, pickCoord, pickLevel, pickSV));
                    if (isStartingPick && (startCostPType = itm.getStartingCostPiecetype()) != -1) {
                        this.srv.messageToGame(gaName, true, new SOCPlayerElement(gaName, pn, 100, SOCPlayerElement.elementTypeForPieceType(startCostPType), pl.getNumPieces(startCostPType)));
                    }
                } else {
                    boolean paidCost;
                    if (op == 2) {
                        itm = ga.getSpecialItem(typeKey, gi, pi, pn);
                    }
                    if ((paidCost = SOCSpecialItem.playerSetItem(typeKey, ga, pl, gi, pi, op == 1)) && itm != null) {
                        this.handler.reportRsrcGainLoss(ga, itm.getCost(), true, false, pn, -1, null);
                    }
                    if (op != 2) {
                        itm = ga.getSpecialItem(typeKey, gi, pi, pn);
                    }
                    if (op == 2 || itm == null) {
                        this.srv.messageToGame(gaName, true, new SOCSetSpecialItem(gaName, 2, typeKey, gi, pi, pn));
                    } else {
                        this.srv.messageToGame(gaName, true, new SOCSetSpecialItem(ga, op, typeKey, gi, pi, itm));
                    }
                }
                int gstate = ga.getGameState();
                if (gstate != prevState) {
                    this.handler.sendGameState(ga);
                }
            }
        }
        catch (IllegalStateException e) {
            sendDenyReply = true;
        }
        catch (Exception e) {
            D.ebugPrintStackTrace(e, "Exception caught");
        }
        finally {
            ga.releaseMonitor();
        }
        if (sendDenyReply) {
            this.srv.messageToPlayer(c, gaName, pn >= 0 ? pn : -258, new SOCSetSpecialItem(gaName, 4, typeKey, gi, pi, mes.playerNumber));
        }
    }

    private void handleGAMESTATS(SOCGame ga, Connection c, SOCGameStats mes) {
        int statType = mes.getStatType();
        if (statType != 2) {
            return;
        }
        this.handler.sendGameStatsTiming(c, ga);
    }
}

