/*
 * Decompiled with CFR 0.152.
 */
package soc.server;

import soc.server.SOCServer;

class SOCGameTimeoutChecker
extends Thread {
    private SOCServer server;
    private boolean alive;

    public SOCGameTimeoutChecker(SOCServer srv) {
        this.server = srv;
        this.alive = true;
        this.setName("timeoutChecker");
        try {
            this.setDaemon(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        int sleepMillis = SOCServer.ROBOT_FORCE_ENDTURN_STUBBORN_SECONDS * 1100;
        long gameExpireCheckTime = 0L;
        while (this.alive) {
            long now = System.currentTimeMillis();
            if (gameExpireCheckTime == 0L) {
                gameExpireCheckTime = now;
            }
            if (now >= gameExpireCheckTime) {
                this.server.checkForExpiredGames(now);
                gameExpireCheckTime = now + (long)(SOCServer.GAME_TIME_EXPIRE_CHECK_MINUTES * 60 * 1000);
                Thread.yield();
            }
            this.server.checkForExpiredTurns(now);
            Thread.yield();
            try {
                SOCGameTimeoutChecker.sleep(sleepMillis);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.server = null;
    }

    public void stopChecking() {
        this.alive = false;
    }
}

