/*
 * Decompiled with CFR 0.152.
 */
package soc.server;

import soc.debug.D;
import soc.game.SOCGame;
import soc.game.SOCPlayer;
import soc.message.SOCMessage;
import soc.message.SOCMessageForGame;
import soc.message.SOCMessageFromUnauthClient;
import soc.message.SOCSitDown;
import soc.message.SOCStatusMessage;
import soc.server.GameMessageHandler;
import soc.server.SOCGameListAtServer;
import soc.server.SOCServer;
import soc.server.SOCServerMessageHandler;
import soc.server.genericServer.Connection;
import soc.server.genericServer.Server;

class SOCMessageDispatcher
implements Server.InboundMessageDispatcher {
    private SOCServer srv;
    private SOCServerMessageHandler srvHandler;
    private SOCGameListAtServer gameList;

    public void setServer(SOCServer srv, SOCServerMessageHandler srvHandler, SOCGameListAtServer gameList) throws IllegalArgumentException, IllegalStateException {
        if (srv == null || srvHandler == null || gameList == null) {
            throw new IllegalArgumentException("null");
        }
        if (this.srv != null) {
            throw new IllegalStateException();
        }
        this.srv = srv;
        this.srvHandler = srvHandler;
        this.gameList = gameList;
    }

    @Override
    public void dispatch(SOCMessage mes, Connection con) throws IllegalStateException {
        if (this.srv == null) {
            throw new IllegalStateException("Not ready to dispatch: call setServer first");
        }
        if (mes == null) {
            return;
        }
        try {
            String cliName = con.getData();
            if (!(mes instanceof SOCMessageFromUnauthClient) && cliName == null) {
                con.put(new SOCStatusMessage(SOCStatusMessage.statusFallbackForVersion(24, con.getVersion()), "Must authenticate first"));
                return;
            }
            if (mes instanceof SOCMessageForGame) {
                String gaName = ((SOCMessageForGame)((Object)mes)).getGame();
                if (gaName == null) {
                    return;
                }
                if (!gaName.equals("\u0016")) {
                    SOCGame ga = this.gameList.getGameData(gaName);
                    if (ga == null || con == null) {
                        if (!(mes instanceof SOCSitDown)) {
                            return;
                        }
                    } else {
                        GameMessageHandler hand = this.gameList.getGameTypeMessageHandler(gaName);
                        if (hand != null) {
                            if (this.srv.isRecordGameEventsFromClientsActive()) {
                                SOCPlayer pl = ga.getPlayer(cliName);
                                this.srv.recordClientMessage(gaName, pl != null ? pl.getPlayerNumber() : -257, (SOCMessageForGame)((Object)mes));
                            }
                            if (hand.dispatch(ga, (SOCMessageForGame)((Object)mes), con)) {
                                return;
                            }
                        }
                    }
                }
            }
            this.srvHandler.dispatch(mes, con);
        }
        catch (Throwable e) {
            D.ebugPrintStackTrace(e, "ERROR -> dispatch");
        }
    }
}

