/*
 * Decompiled with CFR 0.152.
 */
package soc.server;

import soc.message.SOCSitDown;
import soc.server.SOCClientData;
import soc.server.genericServer.Connection;

class SOCReplaceRequest {
    private final Connection arriving;
    private final Connection leaving;
    private final int playerNumber;
    private final boolean isArrivingRobot;

    public SOCReplaceRequest(Connection arriv, Connection leave, SOCSitDown sm) throws IllegalArgumentException {
        if (arriv == null) {
            throw new IllegalArgumentException("arriving");
        }
        if (leave == null) {
            throw new IllegalArgumentException("leaving");
        }
        if (sm == null) {
            throw new IllegalArgumentException("sm");
        }
        this.arriving = arriv;
        this.leaving = leave;
        this.playerNumber = sm.getPlayerNumber();
        SOCClientData arrivScd = (SOCClientData)arriv.getAppData();
        this.isArrivingRobot = arrivScd != null ? arrivScd.isRobot : false;
    }

    public Connection getArriving() {
        return this.arriving;
    }

    public boolean isArrivingRobot() {
        return this.isArrivingRobot;
    }

    public Connection getLeaving() {
        return this.leaving;
    }

    public int getPlayerNumber() {
        return this.playerNumber;
    }
}

